#!/bin/bash

# ArangoDB sample import script for Lobbywatch data
# https://www.arangodb.com/docs/stable/programs-arangoimport-options.html

set -e

echo -e "\n\nImport 'partei' with 'export/node_partei.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Partei');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_partei.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Partei
echo -e "\n\nImport 'branche' with 'export/node_branche.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Branche');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_branche.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Branche
echo -e "\n\nImport 'interessengruppe' with 'export/node_interessengruppe.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Interessengruppe');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_interessengruppe.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Interessengruppe
echo -e "\n\nImport 'interessenraum' with 'export/node_interessenraum.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Interessenraum');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_interessenraum.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Interessenraum
echo -e "\n\nImport 'kommission' with 'export/node_kommission.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Kommission');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_kommission.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Kommission
echo -e "\n\nImport 'organisation' with 'export/node_organisation.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Organisation');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_organisation.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Organisation
echo -e "\n\nImport 'organisation_jahr' with 'export/node_organisation_jahr.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('OrganisationJahr');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_organisation_jahr.arangodb.jsonl' --type jsonl --progress true --create-collection --collection OrganisationJahr
echo -e "\n\nImport 'parlamentarier' with 'export/node_parlamentarier.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Parlamentarier');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_parlamentarier.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Parlamentarier
echo -e "\n\nImport 'fraktion' with 'export/node_fraktion.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Fraktion');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_fraktion.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Fraktion
echo -e "\n\nImport 'rat' with 'export/node_rat.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Rat');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_rat.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Rat
echo -e "\n\nImport 'kanton' with 'export/node_kanton.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Kanton');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_kanton.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Kanton
echo -e "\n\nImport 'kanton_jahr' with 'export/node_kanton_jahr.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('KantonJahr');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_kanton_jahr.arangodb.jsonl' --type jsonl --progress true --create-collection --collection KantonJahr
echo -e "\n\nImport 'person' with 'export/node_person.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('Person');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/node_person.arangodb.jsonl' --type jsonl --progress true --create-collection --collection Person
echo -e "\n\nImport 'interessenbindung' with 'export/relationship_interessenbindung.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_INTERESSENBINDUNG_MIT');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_interessenbindung.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_INTERESSENBINDUNG_MIT
echo -e "\n\nImport 'interessenbindung_jahr' with 'export/relationship_interessenbindung_jahr.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('VERGUETED');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_interessenbindung_jahr.arangodb.jsonl' --type jsonl --progress true --create-collection --collection VERGUETED
echo -e "\n\nImport 'in_kommission' with 'export/relationship_in_kommission.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('IST_IN_KOMMISSION');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_in_kommission.arangodb.jsonl' --type jsonl --progress true --create-collection --collection IST_IN_KOMMISSION
echo -e "\n\nImport 'mandat' with 'export/relationship_mandat.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_MANDAT');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_mandat.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_MANDAT
echo -e "\n\nImport 'mandat_jahr' with 'export/relationship_mandat_jahr.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('VERGUETED');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_mandat_jahr.arangodb.jsonl' --type jsonl --progress true --create-collection --collection VERGUETED
echo -e "\n\nImport 'organisation_beziehung' with 'export/relationship_organisation_beziehung.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_BEZIEHUNG');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_organisation_beziehung.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_BEZIEHUNG
echo -e "\n\nImport 'zutrittsberechtigung' with 'export/relationship_zutrittsberechtigung.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_ZUTRITTSBERECHTIGTER');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_zutrittsberechtigung.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_ZUTRITTSBERECHTIGTER
echo -e "\n\nImport 'parlamentarier_partei' with 'export/relationship_parlamentarier_partei.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('IST_PARTEIMITGLIED_VON');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_parlamentarier_partei.arangodb.jsonl' --type jsonl --progress true --create-collection --collection IST_PARTEIMITGLIED_VON
echo -e "\n\nImport 'parlamentarier_fraktion' with 'export/relationship_parlamentarier_fraktion.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('IST_FRAKTIONMITGLIED_VON');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_parlamentarier_fraktion.arangodb.jsonl' --type jsonl --progress true --create-collection --collection IST_FRAKTIONMITGLIED_VON
echo -e "\n\nImport 'parlamentarier_rat' with 'export/relationship_parlamentarier_rat.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('IST_IM_RAT');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_parlamentarier_rat.arangodb.jsonl' --type jsonl --progress true --create-collection --collection IST_IM_RAT
echo -e "\n\nImport 'parlamentarier_kanton' with 'export/relationship_parlamentarier_kanton.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('WOHNT_IM_KANTON');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_parlamentarier_kanton.arangodb.jsonl' --type jsonl --progress true --create-collection --collection WOHNT_IM_KANTON
echo -e "\n\nImport 'organisation_interessengruppe' with 'export/relationship_organisation_interessengruppe.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('GEHOERT_ZU');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_organisation_interessengruppe.arangodb.jsonl' --type jsonl --progress true --create-collection --collection GEHOERT_ZU
echo -e "\n\nImport 'organisation_interessengruppe2' with 'export/relationship_organisation_interessengruppe2.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('GEHOERT_ZU');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_organisation_interessengruppe2.arangodb.jsonl' --type jsonl --progress true --create-collection --collection GEHOERT_ZU
echo -e "\n\nImport 'organisation_interessengruppe3' with 'export/relationship_organisation_interessengruppe3.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('GEHOERT_ZU');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_organisation_interessengruppe3.arangodb.jsonl' --type jsonl --progress true --create-collection --collection GEHOERT_ZU
echo -e "\n\nImport 'organisation_interessenraum' with 'export/relationship_organisation_interessenraum.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_INTERESSENRAUM');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_organisation_interessenraum.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_INTERESSENRAUM
echo -e "\n\nImport 'organisation_jahr' with 'export/relationship_organisation_jahr.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('ORGANISATION_HAT_IM_JAHR');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_organisation_jahr.arangodb.jsonl' --type jsonl --progress true --create-collection --collection ORGANISATION_HAT_IM_JAHR
echo -e "\n\nImport 'kanton_jahr' with 'export/relationship_kanton_jahr.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('KANTON_HAT_IM_JAHR');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_kanton_jahr.arangodb.jsonl' --type jsonl --progress true --create-collection --collection KANTON_HAT_IM_JAHR
echo -e "\n\nImport 'interessengruppe_branche' with 'export/relationship_interessengruppe_branche.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('IST_IN_BRANCHE');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_interessengruppe_branche.arangodb.jsonl' --type jsonl --progress true --create-collection --collection IST_IN_BRANCHE
echo -e "\n\nImport 'branche_kommission' with 'export/relationship_branche_kommission.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_ZUSTAENDIGE_KOMMISSION');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_branche_kommission.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_ZUSTAENDIGE_KOMMISSION
echo -e "\n\nImport 'branche_kommission2' with 'export/relationship_branche_kommission2.arangodb.jsonl'"; docker exec -it arangodb arangosh --server.authentication false --javascript.execute-string "db._drop('HAT_ZUSTAENDIGE_KOMMISSION');"; docker exec -it arangodb arangoimport --server.authentication false --file '/import/export/relationship_branche_kommission2.arangodb.jsonl' --type jsonl --progress true --create-collection --collection HAT_ZUSTAENDIGE_KOMMISSION

