Lobbywatch Export: YAML
=======================

Datei: export/aggregated_essential_parlamentarier_nested.yaml  
Datum: 03.11.2025 02:31:01  
Datensatztyp: aggregated  
Exporttyp: Öffentlich / Public  

Herausgeber: Lobbywatch (https://lobbywatch.ch)  

Die Inhalte von Lobbywatch.ch sind lizenziert unter einer Creative Commons Namensnennung - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz. (https://creativecommons.org/licenses/by-sa/4.0/deed.de)

Data are licensed as CC BY-SA


## essential_parlamentarier_nested (parlamentarier)

Datensatz mit den wesentlichen Daten über Parlamentarier als geschachtelte Struktur.

Datensatztyp: aggregated

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
name | Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_de | Deutscher Name des Datensatzes.
name_fr | Französicher Name des Datensatzes.
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
nachname | Nachname des Parlamentariers
vorname | Vornahme des Parlamentariers
vorname_kurz | Alltagsvorname oder gebräuchlicher Spitzname, z.B. Nik für Niklaus
zweiter_vorname | Zweiter Vorname des Parlamentariers
buergerorte | Strichpunkt getrennte Liste der Bürgerorte
rat_id | Ratszugehörigkeit; Fremdschlüssel des Rates
kanton_id | Kantonszugehörigkeit; Fremdschlüssel des Kantons
kommissionen | Abkürzungen der Kommissionen des Parlamentariers (automatisch erzeugt [in_Kommission Trigger])
partei_id | Fremdschlüssel Partei. Leer bedeutet parteilos.
parteifunktion | Funktion des Parlamentariers in der Partei
fraktion_id | Fraktionszugehörigkeit im nationalen Parlament. Fremdschlüssel.
fraktionsfunktion | Funktion des Parlamentariers in der Fraktion
im_rat_seit | Jahr der Zugehörigkeit zum Parlament
im_rat_bis | Austrittsdatum aus dem Parlament. Leer (NULL) = aktuell im Rat, nicht leer = historischer Eintrag
ratswechsel | Datum in welchem der Parlamentarier den Rat wechselte, in der Regel vom National- in den Ständerat. Leer (NULL) = kein Ratswechsel hat stattgefunden
ratsunterbruch_von | Unterbruch in der Ratstätigkeit von, leer (NULL) = kein Unterbruch
ratsunterbruch_bis | Unterbruch in der Ratstätigkeit bis, leer (NULL) = kein Unterbruch
beruf | Beruf des Parlamentariers
beruf_fr | Beruf des Parlamentariers auf französisch
beruf_interessengruppe_id | Zuordnung (Fremdschlüssel) zu Interessengruppe für den Beruf des Parlamentariers
titel | Titel des Parlamentariers, wird von ws.parlament.ch importiert
aemter | Politische Ämter (importiert von ws.parlament.ch mandate)
weitere_aemter | Zusätzliche Ämter (importiert von ws.parlament.ch additionalMandate)
zivilstand | Zivilstand
anzahl_kinder | Anzahl der Kinder
militaerischer_grad_id | Militärischer Grad, leer (NULL) = kein Militärdienst
geschlecht | Geschlecht des Parlamentariers, M=Mann, F=Frau
geburtstag | Geburtstag des Parlamentariers
photo_dateiname | Photodateiname ohne Erweiterung
photo_dateierweiterung | Erweiterung der Photodatei
photo_dateiname_voll | Photodateiname mit Erweiterung
photo_mime_type | MIME Type des Photos
kleinbild | Bild 44x62 px oder leer.png
sitzplatz | Sitzplatznr im Parlament. Siehe Sitzordnung auf parlament.ch
email_2 | 2. (private) E-Mail-Adresse des Parlamentariers
homepage | Homepage des Parlamentariers
homepage_2 | Zweite Homepage, importiert von ws.parlament.ch
parlament_biografie_id | Biographie ID auf Parlament.ch; Dient zur Herstellung eines Links auf die Parlament.ch Seite des Parlamenteriers. Zudem kann die ID für die automatische Verarbeitung gebraucht werden.
parlament_number | Number Feld auf ws.parlament.ch, wird von ws.parlament.ch importiert, wird z.B. als ID für Photos verwendet.
parlament_beruf_json | Importierter Beruf des Parlamentariers: Beruf, Arbeitgeber, Jobtitel/Funktion, von, bis (von parlament.ch)
parlament_interessenbindungen | Importierte Interessenbindungen von ws.parlament.ch
parlament_interessenbindungen_json | Importierte Interessenbindungen von ws.parlament.ch als JSON. Rechtsformen: -, AG, Anst., EG, EidgKomm, Gen., GmbH, KollG, Komm., Körp., Stift., Ve., öffStift; Gremien: -, A, AufR., Bei., D, GL, GL, V, GV, Pat., Sr., V, VR, Vw., ZA, ZV; Funktionen: -, A, AufR., Bei., D, GL, GL, V, GV, Pat., Sr., V, VR, Vw., ZA, ZV
parlament_interessenbindungen_updated | Datum, wann die Interessenbindungen von ws.parlament.ch zu letzt aktualisiert wurden.
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
wikipedia | Link zum Wikipedia-Eintrag des Parlamentariers
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
sprache | Sprache des Parlamentariers, wird von ws.parlament.ch importiert
arbeitssprache | Arbeitssprache des Parlamentariers, erhältlich auf parlament.ch
adresse_firma | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
adresse_plz | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
adresse_ort | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
bfs_gemeinde_nr | BFS Gemeindenummer (BFS GDENR)
erfasst | Ist der Parlamentarier erfasst? Falls der Parlamentarier beispielsweise nicht mehr zur Wiederwahl antritt und deshalb nicht erfasst wird, kann dieses Feld auf Nein gestellt werden. NULL bedeutet Status unklar.
autorisierung_reminder_verschickt_visa | Autorisierungerinnerung verschickt durch
autorisierung_reminder_verschickt_datum | Autorisierungerinnerung verschickt am. (Leer/NULL bedeutet noch keine Anfrage verschickt.)
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass die Interessenbindungen und Zutrittsberechtigungen vom Parlamentarier autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
beruf_de | Beruf des Parlamentariers
von | Jahr der Zugehörigkeit zum Parlament
bis | Austrittsdatum aus dem Parlament. Leer (NULL) = aktuell im Rat, nicht leer = historischer Eintrag
aktiv | 0/1: Ist der Datensatz zum Zeitpunkt des Exportes aktuell? , 1=aktiv, 0=abgelaufen/historisiert. Der Wert 'aktiv' wird vom 'von'- und 'bis'-Datum berechnet.
geburtstag_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe geburtstag
im_rat_seit_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe im_rat_seit
im_rat_bis_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe im_rat_bis
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'
von_unix | Von-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'von'
bis_unix | Bis-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'bis'
vertretene_bevoelkerung | Brechnetes Feld. Nationalrat: Kantonsbevölkerung / Anzahl Nationalräte des Kantons, Ständerat: Kantonsbevölkerung / Anzahl Ständeräte des Kantons
rat | Kürzel des Rates
kanton | Kantonskürzel
romandie | Gehört dieser Kanton zur Romandie?
rat_de | Kürzel des Rates
kanton_name_de | Deutscher Name des Kantons
rat_fr | Französische Abkürzung
kanton_name_fr | Französischer Name
kommissionen_namen | Deutsche Namen der Kommissionen in welcher der Parlamentarier Einsitz hat. Die Kommssionen sind durch Semikolon ('; ') getrennt.
kommissionen_namen_de | Französische Namen der Kommissionen in welcher der Parlamentarier Einsitz hat. Die Kommssionen sind durch Semikolon ('; ') getrennt.
kommissionen_namen_fr | Deutsche Namen der Kommissionen in welcher der Parlamentarier Einsitz hat. Die Kommssionen sind durch Semikolon ('; ') getrennt.
kommissionen_abkuerzung | Deutsche Kürzel der Kommissionen in welcher der Parlamentarier Einsitz hat. Die Kommssionen sind durch Komma (', ') getrennt.
kommissionen_abkuerzung_de | Deutsche Kürzel der Kommissionen in welcher der Parlamentarier Einsitz hat. Die Kommssionen sind durch Komma (', ') getrennt.
kommissionen_abkuerzung_fr | Französische Kürzel der Kommissionen in welcher der Parlamentarier Einsitz hat. Die Kommssionen sind durch Komma (', ') getrennt.
kommissionen_anzahl | Anzahl der Kommissionen in welcher der Parlamentarier Einsitz hat.
partei | Parteiabkürzung
partei_name | Ausgeschriebener Name der Partei
fraktion | Fraktionsabkürzung
militaerischer_grad | Name des militärischen Grades
partei_de | Parteiabkürzung
partei_name_de | Ausgeschriebener Name der Partei
militaerischer_grad_de | Name des militärischen Grades
partei_fr | Französische Parteiabkürzung
partei_name_fr | Ausgeschriebener französischer Name der Partei
militaerischer_grad_fr | Französischer Name des militärischen Grades
beruf_branche_id | Fremdschlüssel Branche
titel_de | Deutscher Titel der Person, z.B. Dr.
titel_fr | Französischer Titel der Person, z.B. Dr.
parlamentarier_id | Fremdschlüssel Parlamentarier
verguetungstransparenz_beurteilung_stichdatum | Stichdatum der Auswertung der Vergütungstransparenz
verguetungstransparenz_beurteilung | Ist der dieser Parlamentarier transparent bzgl seinen Vergütungen? ja, nein, teilweise (Leer/NULL bedeutet noch nicht eingetragen): NEIN=Minimaltransparenz (= gesetzliches Minimum, bezahlt/ehrenamtlich); TEILWEISE=teilweise transparent (=gesetzl Minimum plus einzelne Entschädigungen als Betrag offengelegt); JA=transparent (=gesetzl. Minimum plus alles Entschädigungen offengelegt; Exkl. Entschädigung aus Hauptberuf)
refreshed_date | Datum er letzten Aktualisierung der MV-Tabelle ('Materialized View')

### parlamentarier_transparenz (parlamentarier_transparenz)

Feld | Beschreibung
- | -
id | Technischer Schlüssel Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
stichdatum | Stichdatum der Auswertung der Vergütungstransparenz
in_liste | Ist dieser Eintrag in der Transparenzliste mit dem angegebenen Stichdatum enthalten? (Dieses Feld verhindert Transparenzlisteneinträge löschen zu müssen, wenn diese nicht in der Transparenzliste enthalten sind.)
verguetung_transparent | Ist der dieser Parlamentarier transparent bzgl seinen Vergütungen? ja, nein, teilweise (Leer/NULL bedeutet noch nicht eingetragen): NEIN=Minimaltransparenz (= gesetzliches Minimum, bezahlt/ehrenamtlich); TEILWEISE=teilweise transparent (=gesetzl Minimum plus einzelne Entschädigungen als Betrag offengelegt); JA=transparent (=gesetzl. Minimum plus alles Entschädigungen offengelegt; Exkl. Entschädigung aus Hauptberuf)
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'

### interessenbindungen (interessenbindung)

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
id | Technischer Schlüssel der Interessenbindung Technischer Schlüssel
parlamentarier_id | Fremdschlüssel Parlamentarier
organisation_id | Fremdschlüssel Organisation
art | Art der Interessenbindung
funktion_im_gremium | Funktion innerhalb des Gremiums, z.B. Präsident in einem Vorstand einer AG entspricht einem Verwaltungsratspräsidenten, Präsident einer Geschäftsleitung entspricht einem CEO.
deklarationstyp | Ist diese Interessenbindung deklarationspflichtig? Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
status | Status der Interessenbindung
hauptberuflich | Eigene Firma/Haupttätigkeit: Ist diese Interessenbindung hauptberuflich? (Hauptberufliche Interessenbindungen müssen nicht offengelegt werden.)
behoerden_vertreter | Entstand diese Interessenbindung als Behördenvertreter von Amtes wegen? Beispielsweise weil ein Regierungsrat in einem Verwaltungsrat von Amtes wegen Einsitz nimmt.
beschreibung | Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
beschreibung_fr | Französische Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist die Quell-URL noch gültig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn der Interessenbindung, leer (NULL) = unbekannt
bis | Ende der Interessenbindung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
unterscheidung | Unterscheidungsfeld für ansonsten gleiche Interessenbindungen (parlamentarier_id, organisation_id, art und bis). NUR ANGEBEN WO NÖTIG.
updated_by_import | Datum, wann die Interessenbindung durch einen Import zu letzt aktualisiert wurde. Ein Datum bedeutet, dass die Interessenbindung unter der Kontrolle des Importprozesses.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
aktiv | 0/1: Ist der Datensatz zum Zeitpunkt des Exportes aktuell? , 1=aktiv, 0=abgelaufen/historisiert. Der Wert 'aktiv' wird vom 'von'- und 'bis'-Datum berechnet.
bis_unix | Bis-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'bis'
von_unix | Von-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'von'
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'
wirksamkeit | 'tief', 'mittel', 'hoch': Wirksamkeit der Interessenbindung, siehe https://lobbywatch.ch/de/seite/wirksamkeit. Die Wirksamkeit ist eines der primären Resultate von Lobbywach.
parlamentarier_im_rat_seit | Jahr der Zugehörigkeit zum Parlament

#### verguetungen (interessenbindung_jahr)

Feld | Beschreibung
- | -
id | Technischer Schlüssel Jahresvergütung von Intressenbindung Technischer Schlüssel
interessenbindung_id | Fremdschlüssel der Interessenbindung
jahr | Jahr auf welche sich die Werte beziehen
verguetung | Jährliche Vergütung CHF für Tätigkeiten aus dieser Interessenbindung, z.B. Entschädigung für Beiratsfunktion.
beschreibung | Beschreibung der Vergütung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass die Interessenbindungen vom Parlamentarier autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'

### zutrittsberechtigungen (zutrittsberechtigung)

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Zutrittsberechtigung Technischer Schlüssel
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
name | Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_de | Deutscher Name des Datensatzes.
name_fr | Französicher Name des Datensatzes.
nachname | Nachname des berechtigten Persion
vorname | Vorname der berechtigten Person
zweiter_vorname | Zweiter Vorname der zutrittsberechtigten Person
beschreibung_de | Beschreibung der Person. Der Text ist öffentlich einsehbar.
beschreibung_fr | Französische Beschreibung der Person. Der Text ist öffentlich einsehbar.
parlamentarier_kommissionen | Abkürzungen der Kommissionen des zugehörigen Parlamentariers (automatisch erzeugt [in_Kommission/person Trigger])
parlamentarier_kommissionen_zutrittsberechtigung | Abkürzungen der Kommissionen des zugehörigen Parlamentariers (automatisch erzeugt [in_Kommission/zutrittsberechtigung Trigger])
beruf | Beruf der Person
beruf_fr | Französische Bezeichung des Beruf der Person
beruf_interessengruppe_id | Fremdschlüssel zur Interessengruppe für den Beruf
partei_id | Fremdschlüssel Partei. Parteimitgliedschaft der zutrittsberechtigten Person.
geschlecht | Geschlecht des Parlamentariers, M=Mann, F=Frau
arbeitssprache | Arbeitssprache des Zutrittsberechtigten
homepage | Homepage der zutrittsberechtigen Person
twitter_name | Twittername
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
erfasst | Ist die Person erfasst? Falls der zugehörige Parlamentarier beispielsweise nicht mehr zur Wiederwahl antritt und deshalb die Person nicht erfasst wird, kann dieses Feld auf Nein gestellt werden. NULL bedeutet Status unklar.
eingabe_abgeschlossen_visa_person | Kürzel der Person, welche die Eingabe abgeschlossen hat.
eingabe_abgeschlossen_datum_person | Die Eingabe ist für den Ersteller der Einträge abgeschlossen und bereit für die Kontrolle. (Leer/NULL bedeutet, dass die Eingabe noch im Gange ist.)
kontrolliert_visa_person | Kürzel der Person, welche die Eingabe kontrolliert hat.
kontrolliert_datum_person | Der Eintrag wurde durch eine zweite Person am angegebenen Datum kontrolliert. (Leer/NULL bedeutet noch nicht kontrolliert.)
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_visa_person | Freigabe von wem? (Freigabe = Daten sind fertig)
freigabe_datum_person | Freigabedatum (Freigabe = Daten sind fertig)
created_visa_person | Datensatz erstellt von
created_date_person | Erstellt am
updated_visa_person | Abgeändert von
updated_date_person | Abgeändert am
published_person | Veröffentlichkeitstatus der Person
freigabe_datum_unix_person | Datum als UNIX-Timestap (Sekunden seit 1.1.1970)
parlamentarier_id | Fremdschlüssel Parlamentarier
person_id | Fremdschlüssel zur zutrittsberechtigten Person
zutrittsberechtigung_id | Technischer Schlüssel der Zutrittsberechtigung
funktion | Funktion der zutrittsberechtigen Person.
funktion_fr | Funktion der zutrittsberechtigen Person auf französisch.
von | Beginn der Zutrittsberechtigung, leer (NULL) = unbekannt
bis | Ende der Zutrittsberechtigung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
bis_unix | Bis-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'bis'
von_unix | Von-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'von'
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'
beruf_branche_id | Fremdschlüssel Branche
partei | Parteiabkürzung
partei_de | Parteiabkürzung
partei_fr | Französische Parteiabkürzung
parlamentarier_name | Name des Parlamentariers, der den Zutrittsbadge gegeben hat.
parlamentarier_freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
parlamentarier_freigabe_datum_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970)
refreshed_date | Datum er letzten Aktualisierung der MV-Tabelle ('Materialized View')

#### mandate (mandat)

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
id | Technischer Schlüssel
person_id | Fremdschlüssel Person
organisation_id | Fremdschlüssel Organisation
art | Art der Funktion des Mandatsträgers innerhalb der Organisation
funktion_im_gremium | Funktion innerhalb des Gremiums, z.B. Präsident in einem Vorstand einer AG entspricht einem Verwatlungsratspräsidenten, Präsident einer Geschäftsleitung entspricht einem CEO.
hauptberuflich | Eigene Firma/Haupttätigkeit: Ist dieses Mandat hauptberuflich? (Hauptberufliche Mandate müssen nicht offengelegt werden.)
beschreibung | Umschreibung des Mandates. Beschreibung wird nicht ausgewertet, jedoch in den Resultaten angezeigt.
beschreibung_fr | Französische Bezeichung des Mandates. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist die Quell-URL noch gültig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn des Mandates, leer (NULL) = unbekannt
bis | Ende des Mandates, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
unterscheidung | Unterscheidungsfeld für ansonsten gleiche Mandate (person_id, organisation_id, art und bis). NUR ANGEBEN WO NÖTIG.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
aktiv | 0/1: Ist der Datensatz zum Zeitpunkt des Exportes aktuell? , 1=aktiv, 0=abgelaufen/historisiert. Der Wert 'aktiv' wird vom 'von'- und 'bis'-Datum berechnet.
bis_unix | Bis-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'bis'
von_unix | Von-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'von'
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'
wirksamkeit | 'tief', 'mittel', 'hoch': Wirksamkeit des Mandates analog zur Wirksamkeit von Interessenbindungen, siehe https://lobbywatch.ch/de/seite/wirksamkeit, jedoch ohne Einbezug der Kommissionen.

