-- Lobbywatch.ch SQL export 03.11.2025 02:31:01

SET NAMES utf8mb4;

SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;

SET SQL_NOTES=1;

CREATE DATABASE IF NOT EXISTS lobbywatch_public DEFAULT CHARACTER SET utf8mb4;
USE lobbywatch_public;

DROP TABLE IF EXISTS kanton;
CREATE TABLE kanton (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel des Kantons',
  abkuerzung enum('AG','AR','AI','BL','BS','BE','FR','GE','GL','GR','JU','LU','NE','NW','OW','SH','SZ','SO','SG','TI','TG','UR','VD','VS','ZG','ZH') NOT NULL COMMENT 'Kantonskürzel',
  kantonsnr tinyint(4) NOT NULL COMMENT 'Nummer des Kantons gemäss Verfassung',
  name_de varchar(50) NOT NULL COMMENT 'Deutscher Name des Kantons',
  name_fr varchar(50) NOT NULL COMMENT 'Französischer Name',
  name_it varchar(50) NOT NULL COMMENT 'Italienischer Name',
  romandie tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Gehört dieser Kanton zur Romandie?',
  anzahl_staenderaete tinyint(4) NOT NULL COMMENT 'Anzahl Ständeräte',
  amtssprache set('de','fr','it','rm') NOT NULL COMMENT 'Amtssprachen des Kantons',
  hauptort_de varchar(50) NOT NULL COMMENT 'Hauptort des Kantons',
  hauptort_fr varchar(50) DEFAULT NULL COMMENT 'Hauptort auf französisch',
  hauptort_it varchar(50) DEFAULT NULL COMMENT 'Hauptort auf italienisch',
  flaeche_km2 int(11) unsigned NOT NULL COMMENT 'Fläche in km2',
  beitrittsjahr smallint(6) unsigned NOT NULL COMMENT 'Beitrittsjahr zur Schweiz',
  wappen_svg text NOT NULL COMMENT 'SVG Wappen des Kantons',
  wappen_svg_pfad varchar(255) NOT NULL COMMENT 'Pfad zu SVG Wappen des Kantons',
  wappen_klein varchar(255) NOT NULL COMMENT 'Pfad zu kleinem Wappen des Kantons (25px)',
  wappen varchar(255) NOT NULL COMMENT 'Pfad zu Wappen des Kantons (50px)',
  lagebild varchar(255) NOT NULL COMMENT 'Pfad zum lagebild des Kantons',
  homepage varchar(255) DEFAULT NULL COMMENT 'Homepage des Kantons',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Beschreibung des Kantons',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY abkuerzung (abkuerzung),
  UNIQUE KEY kantonsnr (kantonsnr)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Kantone der Schweiz';

INSERT INTO kanton (id, abkuerzung, kantonsnr, name_de, name_fr, name_it, romandie, anzahl_staenderaete, amtssprache, hauptort_de, hauptort_fr, hauptort_it, flaeche_km2, beitrittsjahr, wappen_svg, wappen_svg_pfad, wappen_klein, wappen, lagebild, homepage, beschreibung, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'ZH',1,'Zürich','Zurich','Zurigo',0,2,'de','Zürich',NULL,NULL,1729,1351,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.224px" height="492.466px" viewBox="-175.818 -214.101 406.224 492.466"\n	 enable-background="new -175.818 -214.101 406.224 492.466" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M27.194-212.026h201.734v296.5c0,106.563-90.25,192.938-201.602,192.938\n		c-111.336,0-201.59-86.375-201.59-192.938v-296.5H27.194L27.194-212.026z"/>\n	<path fill="#248BCC" d="M-174.263,84.458c0,106.563,90.254,192.953,201.59,192.953c74.461,0,140.805-40.906,175.711-98.357\n		l-377.301-391.414V84.458z"/>\n	<path fill="none" stroke="#000000" stroke-width="3.048" d="M27.159-212.577h201.722V83.927\n		c0,106.531-90.233,192.913-201.577,192.913c-111.336,0-201.598-86.382-201.598-192.913v-296.504H27.159z"/>\n</g>\n</svg>','images/kanton/wappen/svg/zh.svg','images/kanton/wappen/20px/Wappen_Aargau_matt.svg.png','images/kanton/wappen/50px/Wappen_Aargau_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Aargau_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Z%C3%BCrich','Q11943','2014-09-16 00:00:00','2014-03-16 10:24:00','2021-02-05 20:25:09'),
(2,'BE',2,'Bern','Berne','Berna',0,2,'de','Bern',NULL,NULL,5959,1353,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.505px" height="492.818px" viewBox="-176.002 -213.546 406.505 492.818"\n	 enable-background="new -176.002 -213.546 406.505 492.818" xml:space="preserve">\n<g>\n	<path fill="#FFD72E" d="M27.127-212.022h201.852V84.685c0,106.625-90.297,193.063-201.723,193.063\n		c-111.406,0-201.734-86.438-201.734-193.063v-296.707H27.127z"/>\n	<path d="M210.557-11.084c-3.766-7.023-31.813-35.09-66.813-54.191c-15.422-8.426-63.109-34.066-102.172-41.242\n		c-4.227-0.773-7.898-2.629-12.164-1.641c-1.77,0.41-4.414-2.152-1.367-3.902c1.672-0.969,3.375-1.77,12.031-1.609\n		c-7.359-5.16-9.801-4.367-21.527-4.148c2.496-4.777,16.152-4.785,16.152-4.785s-6.289-3.891-25.023-2.535\n		c3.789-3.137,11.145-4.594,11.145-4.594s-10.227-4.207-21.969,1.176c-0.953,0.434-2.066,1.352-4.352,1.488\n		c-2.289,0.137-7.961-0.68-8.891-0.879c-0.91-0.211-4.504-0.832-4.102-4.129c0.375-3.289,3.207-3.359,3.926-3.426\n		c0.703-0.094,9.168,0.539,11.367-3.527c1.488-2.766,4.281-13.574-3.352-16.688c-10.91-4.441-16.414-0.777-18.047-0.391\n		c-1.648,0.367-3.902-1.313-3.902-1.313s-8.418-8.578-11.145-10.625c-2.738-2.031-10.594-5.703-16.563-6.734\n		c-1.32-0.211-3.672-0.859-4.031-1.16c-1.359-1.137-5.848-1.785-7.445-1.656c-1.992,0.168-6.313-0.512-8.648,3.023\n		c-1.488,2.246-2.641,2.305-5.617,2.785c-2.969,0.484-10.801,0.039-10.801,0.039s-10.094-0.047-13.352-2.273\n		c-1.52-1.047-6.223-5.281-7.504-6.816c-1.258-1.527-3.238-0.598-3.07-0.031c0.773,2.832,0.168,7.992-2.84,11.344\n		c-3.457,3.801-7.363,7.395-8.043,8.234c-0.695,0.832-1.816,4.879,0.602,6.414c2.406,1.512,4.305,2.648,4.305,2.648\n		s-1.555,10.023-1.219,13.039c-2.277-0.969-6.23-3.113-8.621-5.031c-15.625-12.551-16.93-26.582-20.16-27.113\n		c-3.234-0.527-7.664,15.961,1.238,27.281c10.289,13.104,30.039,16.168,30.039,16.168s-3.223,4.09-2.855,9.719\n		c-3.43,1.707-3.902,2.875-3.902,2.875s-0.289,2.23,1.902,4c60.907-1.435,104.923,56.62,94.747,123.307\n		c-1.473,9.672-8.73,33.871-11.633,40.902c-2.922,7.031-3.785,18.461-3.785,18.461s-0.969,3.555-2.742,3.305\n		c-1.73-0.242-1.84-1.648-1.777-2.555c0.305-1.328-0.879-6.539-0.406-9.82c0.496-3.242-1.395-5.586-1.395-5.586\n		s4.688-10.43-7.422-19.461c2.168,11.82-1.73,14.461-1.73,14.461S-67.4,35.966-83.142,36.49c6.801,5.82,7.84,14.195,8.086,14.789\n		c-1.941-3.789-17.598-14.164-26.75-0.047c15.465,0.93,18.031,6.75,18.031,6.75s-18.414-6.797-26.313,10.906\n		c8.785-2.281,18.008-0.516,18.008-0.516s-10.961,2.484-11.094,12.063c6.016-2.922,15.375-0.938,15.375-0.938s-0.273,0-0.176,0.922\n		c1.48,0.469,8.262,10.641,13.91,13.328c5.656,2.672,37.832,4.625,51.578-1.719c3.488-1.609,3.719-0.969,5.016-5.281\n		c4.262-14.172,21.168-52.938,33.031-76.68C23.505-5.878,30.869-16.902,30.9-17.902c0.063-1.969-9.754-13.008-10.891-14.266\n		c-1.113-1.262,0.969-1.957,0.969-1.957s7.43,1.789,10.477,6.148c3.07,4.363,3.609,5.145,2.969,7.465\n		c-0.656,2.328-6.199,19.043-6.199,19.043s85.887,6.895,86.449,9.75c0.586,2.863-26.82,5.406-34,6.93\n		C68.33,17.832,56.752,32.527,57.963,36.699c5,17.344,6.805,60.828,7.203,64.125c0.422,3.297,4.82,4.953,6.508,5.047\n		c1.672,0.078,10.57,0.164,11.406,1.563c0.805,1.406-0.461,1.953-0.461,1.953s-1.984,1.438-5.523,1.109\n		c-3.539-0.297-24.164-6.031-27.539-9.766c-3.344-3.75-5.031-5.656-5.031-5.656s2.016-16.766-14.063-14.922\n		c5.781,8.094,1.406,11.688,1.406,11.688s-6.453-12.359-26.453-6.375c13.512,5.188,13.871,9.047,13.871,9.047\n		s-11.109-5-22.453,5.531c14.977,0.172,17,5.984,17,5.984s-16.898-3.5-20.336,14.563c12.055-7.445,18.59-2.641,18.59-2.641\n		s-18.633,5.828-13.512,22.227c7.289-7.195,16.512-9.016,16.512-9.016l0.25,0.773c0,0,4.422,1.867,8.438,1.922\n		c4.008,0.047,4.984-0.578,4.449-2.789c-0.535-2.211,0.313-4.711,0.352-5.563c0.055-0.836,1.48-1.063,1.48-1.063\n		s0.906-0.211,1.203,1.086c0.688,2.898-1.5,5.273,1.328,8.586c2.836,3.313,7.211,2.57,8.594,3.086\n		c1.375,0.508,9.047,1.961,9.047,1.961s21.555,3.773,28.359,0.867c4.813-2.047,18.938-11.172,22.797-17.5\n		c1.875-3.078,2.688-7.016,3.141-11.344c1.656-16.609,5.922-36.531,17.906-45.938c0.922-0.75,2.875-1.297,3.906-1.938\n		c1.156-0.703,2.188-0.953,2.625-2.078c0.328-2.625-4.203-36.469-4.859-45.859c-1.156-16.992-13.875-30.105-13.875-30.105\n		s0-1.113,1.375-1.398c1.383-0.305,3.578,0.246,3.578,0.246s7.984-0.344,13.922,30.922c5.922,31.242,6.484,56.273,12.719,68.094\n		c1.906,3.578,10.625,17.656,17.656,31.414c5.813,11.375,7.531,19.359,9.875,24.047c5.188,10.359,0.188,23.125-1.859,24.523\n		c-2.063,1.414-2.203,0.102-2.922-0.328c-0.734-0.461,0.25-5.445,0.25-5.445s2.016-2.406-0.75-6.719\n		c-2.797-4.328-15.438-7.422-15.438-7.422s-1.875-1.359-3.094-2.016c1.297-12.625-19.805-13.813-19.805-13.813\n		s6.086,8.625,5.227,16.953c-15.164-11.164-27.453-0.031-27.453-0.031s11.453,2.016,16.609,11.094\n		c-20.109-5.156-22.297,9.719-22.297,9.719s8.164-3.719,16.891,3.047c-18.922,1.406-16.016,16.359-16.016,16.359\n		s4.938-6.516,19.625-1.609c-0.281,0.438-12.063,9.203-4.734,23.477c1.719-3.695,6.141-9.695,11.391-11.875\n		c0.531,0.672,0.625,0.625,0.797,0.789c0,0,11.688-5,17.641-5.164c5.969-0.164,10.844-0.523,18.563-1.313\n		c7.719-0.805,12.172-4.438,15.797-6.523c3.609-2.078,17.813-20.313,21.422-23.461c3.609-3.164,4.531-8.539,4.531-8.539\n		s2.375-7.625,3.75-25.133c1.375-17.523,2.392-41.633,2.017-56.984C208.965,47.277,196.45,0.144,196.45,0.144\n		s-0.047-1.574,1.078-1.969c1.148-0.383,1.109,0.012,2.672,2.504c1.547,2.465,4.546,15.852,7.046,17.801\n		c0.969,0.746,0.805,3.594,4.655,2.105c1.188-0.449,2.97-8.063,3.625-12.215C216.213,4.154,214.307-4.069,210.557-11.084\n		 M-112.544-147.948c0.457,0.168,0.961,0.43,0.961,0.43s-1.023,8.938,0.281,12.953c-5.527-2.09-10-3.703-10-3.703\n		S-116.041-146.413-112.544-147.948 M-112.318-117.725c-0.219,0.016-0.855-0.078-1.754-0.16c-4.07-3.375-4.422-9.23-4.422-9.23\n		s9.023,2.199,10.543,2.902C-108.677-122.303-111.873-119.885-112.318-117.725 M-101.248-115.917\n		c-1.113-0.352-3.664-2.672-3.766-4.176c-0.098-2.055-0.586-3.359-0.586-3.359s13.184,3.633,17.023,10.191\n		C-93.935-114.588-100.134-115.565-101.248-115.917 M-109.927-133.975c0,0,4.328-6.879,8.055-8.637\n		c12.426,6.48,18.379,17.695,20.504,25.629C-88.263-125.702-109.927-133.975-109.927-133.975"/>\n	<path d="M-109.529-18.303c16.02-4.672,32.539-22.516,44.113-34.086c6.578-6.586,11.328-10,12.648-11.047\n		c1.938,1.574,10.367,15.512,14.449,28.992c3.152,10.406,2.887,21.191,2.734,24.285C-36.087-0.741-42.294,1.13-42.294,1.13\n		S-80.119,13.548-86.63,13.388c-2.992-0.09-26.113,5.453-32.816,4.824c-17.625-1.695-21.879-10.113-21.879-10.113l-8.809-15.297\n		c0,0-1.113-3.582,2.113-2.504c3.23,1.105,3.652,1.168,6.559,1.969c2.902,0.816,0.582-2.078,0.582-2.078s-2.863-1.602-5.375-2.707\n		c-8.113-3.566-8.977-15.457-8.977-15.457s-0.414-9.828-0.016-17.023c0.395-7.191-16.289-6.734-16.289-6.734s6.387-13.168,26-5.52\n		c0.176-7.066-17.023-12.367-17.023-12.367s10.563-11.191,29.992,4.438c1.016-11.367-8.84-20.43-8.84-20.43\n		s15.543-2.824,21.898,18.863c6.605-5.336,2.59-19.871,2.59-19.871s15.039,8.359,10.336,23.645\n		c7.832-1.383,10.77-11.598,10.77-11.598s6.039,10.648-3.73,21.113c-3.672,3.926-4.496,2.773-4.496,2.773\n		s-15.613,20.395-5.605,46.305c1.277,3.336,3.438,0.824,3.727-0.672C-105.638-6.542-106.455-12.061-109.529-18.303"/>\n	<path d="M-38.646-170.405c0,0,11.48,10.328,12.559,11.641c0.938,1.109,7.855-2.656,11.449-1.816\n		c2.191,0.512-1.168-6.199-2.543-8.145c-1.387-1.922-5.977-6.785-11.516-5.863C-33.408-173.803-38.646-170.405-38.646-170.405"/>\n	<path fill="#E7423F" d="M-87.919-116.557c-5.895-7.098-18.617-10.055-33.289-13.777c-10.605-2.703-22.109-7.293-27.832-15.496\n		c-3.008-4.27-4.438-8.973-4.613-13.191c-0.129-3.16,0.32-5.918,0.902-7.75c0.297,0.559,0.578,1.152,0.84,1.703\n		c2.594,5.473,6.785,14.766,17.504,23.094c5.113,3.945,14.219,6.664,23.098,10.027c9.535,3.277,19.75,8.137,25.961,14.445\n		c0,0,3.934,4.371,4.309,5.84c-0.895-0.168-2.301-0.496-4.031-0.781C-85.677-114.022-87.919-116.557-87.919-116.557"/>\n	<path fill="none" stroke="#E41E2E" stroke-width="0.888" d="M-87.919-116.557c-5.895-7.098-18.617-10.055-33.289-13.777\n		c-10.605-2.703-22.109-7.293-27.832-15.496c-3.008-4.27-4.438-8.973-4.613-13.191c-0.129-3.16,0.32-5.918,0.902-7.75\n		c0.297,0.559,0.578,1.152,0.84,1.703c2.594,5.473,6.785,14.766,17.504,23.094c5.113,3.945,14.219,6.664,23.098,10.027\n		c9.535,3.277,19.75,8.137,25.961,14.445c0,0,3.934,4.371,4.309,5.84c-0.895-0.168-2.301-0.496-4.031-0.781\n		C-85.677-114.022-87.919-116.557-87.919-116.557z"/>\n	<path fill="#FFFFFF" d="M-122.189-118.174c1.52-0.031,3.453-0.207,5-0.031c-2.16-1.52-3.074-7.473-3.074-7.473\n		S-122.431-122.303-122.189-118.174"/>\n	<path fill="#FFFFFF" d="M-110.255-117.381c1.504,0.078,2.57,0.406,5.098,0.84c-2.227-1.488-1.297-4.254-2.168-5.465\n		C-108.873-119.475-109.822-119.213-110.255-117.381"/>\n	<path fill="#FFFFFF" d="M-109.759-137.756c2.344-3.711,5.527-5.961,5.703-6.008c-1.086-0.504-5.59-2.785-5.59-2.785\n		S-109.99-138.092-109.759-137.756"/>\n	<path fill="#FFFFFF" d="M-121.83-141.045c0,0,4.926-6.793,7.102-7.809c-3.375-0.992-4.781-1.793-5.902-2.43\n		C-121.576-146.038-121.83-141.045-121.83-141.045"/>\n	<path fill="#E7423F" d="M104.62,22.49c0,0,13.344-1.934,20.766,4.363c-0.094-1.234-0.953-8.289-0.953-8.289\n		S111.417,13.939,104.62,22.49"/>\n	<path fill="none" stroke="#E41E2E" stroke-width="0.888" d="M104.62,22.49c0,0,13.344-1.934,20.766,4.363\n		c-0.094-1.234-0.953-8.289-0.953-8.289S111.417,13.939,104.62,22.49z"/>\n	<path fill="#FFFFFF" d="M-66.431-170.573c0,0,3.633,0.297,4.93,3.832c1.238,3.438,1.816,8.512-0.785,18.961\n		c-0.23,0.961-2.129,0.758-2.176-0.426c-0.039-1.191,1.168-6.391,1.496-9.406c0.328-3.015-0.082-6.73-1.09-7.641\n		c-0.824-0.746-2.375-1.359-2.711-1.426c-0.336-0.078-2.145-0.445-1.77-2.16C-68.15-170.557-66.431-170.573-66.431-170.573"/>\n	<path fill="#FFFFFF" d="M-65.576-160.366c1.816-0.504,1.016-2.375-1.23-3.191c-2.242-0.824-7.359,0.496-8.945,5.313\n		c-1.473,4.406,5.648,8.055,7.121,7.984c2.52-0.105,3.176-3.457,1.664-4.146c-1.488-0.703-3.855-0.953-3.648-2.896\n		C-70.416-159.252-67.384-159.846-65.576-160.366"/>\n	<path fill="#E7423F" d="M-105.392-60.1c0,0,4.219,0.168,8.387-6.121c-0.336,5.625-4.824,10.367-4.824,10.367L-105.392-60.1z"/>\n	<path fill="#E7423F" d="M-164.767-54.292c6.098-4.961,18.375-0.012,18.375-0.012l-6.262,5.434\n		C-152.654-48.877-155.181-54.366-164.767-54.292"/>\n	<path fill="#E7423F" d="M-154.888-69.924c8.824-2.809,21.234,7.992,21.234,7.992s-6.563,3.375-8.496,4.336\n		C-142.005-58.327-143.103-66.252-154.888-69.924"/>\n	<path fill="#E7423F" d="M-134.697-81.991c8.684,2.961,12.059,17.281,12.059,17.281l-6.945,1.383\n		C-129.591-63.327-127.623-72.436-134.697-81.991"/>\n	<path fill="#E7423F" d="M-116.759-64.733c3.242-3.375,5.383-8.695,4-14.938c2.281,2.098,5.145,10.746,2.648,17.043\n		C-111.134-63.167-112.384-64.534-116.759-64.733"/>\n	<path fill="#E7423F" d="M-55.751,54.888c-1.207-0.75-3.086-1.078-4.383-1.094c3.605-3.469,2.816-8.672,2.816-8.672\n		S-53.888,50.576-55.751,54.888"/>\n	<path fill="#E7423F" d="M-65.056,53.904c-3.438,0.328-5.816,1.078-6.488,1.438c-0.512-9.867-4.016-14.406-4.016-14.406\n		S-67.509,45.56-65.056,53.904"/>\n	<path fill="#E7423F" d="M-74.72,56.544c-1.75,1.25-1.43,0.75-4.184,2.836c-3.238-5.297-6.758-9.758-18.16-10.039\n		C-88.376,43.107-77.263,50.576-74.72,56.544"/>\n	<path fill="#E7423F" d="M-103.791,64.919c3.168-6.047,16.129-6.375,22.48-2.883c-1.93,2.273-2.387,3.305-3.113,5.797\n		C-90.189,64.201-100.677,64.591-103.791,64.919"/>\n	<path fill="#E7423F" d="M-98.791,76.185c4.305-5.75,13.031-5.766,13.168-5.5c-0.273,0.375-1.785,5.109-1.785,5.734\n		C-87.837,76.138-92.615,74.888-98.791,76.185"/>\n	<path fill="#E7423F" d="M41.401,94.388c-1.969-0.438-4.594-0.938-6.422-1.234c0.719-0.703,2.828-6.281,0.313-10.422\n		C37.088,83.201,41.276,84.701,41.401,94.388"/>\n	<path fill="#E7423F" d="M23.104,95.013c2.465-1.531,4.074-1.719,5.992-1.625c-2.238-5.391-12.992-7.516-14.863-6.922\n		C15.424,86.998,22.799,90.623,23.104,95.013"/>\n	<path fill="#E7423F" d="M4.471,98.044c7.219-3.5,14.012-0.859,14.539-0.5c-0.809,0.766-2.93,3.063-3.824,5.195\n		C13.592,99.013,4.471,98.044,4.471,98.044"/>\n	<path fill="#E7423F" d="M-2.349,115.419c0.574-1.375,7.398-8.172,15.055-6c-1.176,2.109-1.367,3.344-0.793,5.125\n		C4.44,111.529-2.095,115.341-2.349,115.419"/>\n	<path fill="#E7423F" d="M0.639,134.654c1.785-9.078,8.402-11.672,11.648-13.188c-0.094,1.422,0.41,5.422,1.16,6.531\n		C12.553,127.81,4.377,130.091,0.639,134.654"/>\n	<path fill="#E7423F" d="M141.12,141.982c-2.297,0.625-5.688,2.047-6.906,2.813c0.406-5.469-1.313-10.813-2.898-13.188\n		C133.932,131.966,141.807,135.248,141.12,141.982"/>\n	<path fill="#E7423F" d="M123.667,154.732c-0.734-2.359-7.406-9.922-13.391-11.109c4.609-2.516,12.656-2.234,20.047,3.922\n		C127.401,149.451,124.323,153.482,123.667,154.732"/>\n	<path fill="#E7423F" d="M102.542,161.544c3.82-6.859,15.703-4.094,19.063-2.781c-1.453,1.594-2.766,4.359-3.109,8.688\n		C115.557,162.201,106.323,160.56,102.542,161.544"/>\n	<path fill="#E7423F" d="M101.948,179.107c-0.25,0.641,1.734-8.563,16.063-7.859c-0.422,3.492-0.469,4.953,0.063,8.375\n		C108.792,175.748,101.948,179.107,101.948,179.107"/>\n	<path fill="#E7423F" d="M114.432,199.482c0,0-1.313-7.344,4.922-13.047c0.625,3.141,1.578,4.969,2.828,6.203\n		C118.37,193.888,114.432,199.482,114.432,199.482"/>\n	<path fill="none" stroke="#FFFFFF" stroke-width="3.176" stroke-linecap="round" stroke-linejoin="round" d="M-114.63-57.831\n		c-3.074,2.855-6.344,2.313-9.129,5.504c-2.023,2.32-7.48,10.219-4.582,23.145c1.895,8.418,3.664,23.219,4.75,28.008\n		c1.457,6.426-2.262,12.504-4.855,12.602"/>\n	<path fill="none" stroke="#FFFFFF" stroke-width="2.664" stroke-linecap="round" stroke-linejoin="round" d="M36.26,99.529\n		c0.25,3.703,0.25,5.859,1.453,9.281c0.859,2.469,5.625,4.297,14.719,6.891c5.563,1.594,15.875,5.141,19.094,6.516\n		c7.422,3.156,4.266,8.211,4.391,11"/>\n	<path fill="#E7423F" d="M-174.478,84.685c0,106.625,90.328,193.063,201.734,193.063c46.254,0,88.879-14.906,122.91-39.969\n		L-174.478,40.732V84.685z"/>\n	<polygon fill="#E7423F" points="228.979,-212.022 27.127,-212.022 -71.904,-212.022 228.979,-29.381 	"/>\n	<g>\n		<path fill="none" stroke="#000000" stroke-width="3.048" d="M27.127-212.022h201.852V84.685\n			c0,106.625-90.297,193.063-201.723,193.063c-111.406,0-201.734-86.438-201.734-193.063v-296.707H27.127z"/>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/be.svg','images/kanton/wappen/20px/Wappen_Appenzell_Ausserrhoden_matt.svg.png','images/kanton/wappen/50px/Wappen_Appenzell_Ausserrhoden_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Appenzell_Ausserrhoden_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Bern','Q11911','2014-09-16 00:00:00','2014-03-16 10:24:00','2021-02-05 20:25:09'),
(3,'LU',3,'Luzern','Lucerne','Lucerna',0,2,'de','Luzern',NULL,NULL,1493,1332,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.504px" height="492.75px" viewBox="-176.134 -213.811 406.504 492.75"\n	 enable-background="new -176.134 -213.811 406.504 492.75" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M26.963-212.292h201.875V84.376c0,106.609-90.328,193.031-201.73,193.031\n		c-111.395,0-201.715-86.422-201.715-193.031v-296.668H26.963z"/>\n	<path fill="#248BCC" d="M27.116,277.408L27.116,277.408c-111.395,0-201.715-86.422-201.715-193.031v-296.668H26.963L27.116,277.408\n		z"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.134" y="-213.811" width="406.504" height="492.75"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#000000" stroke-width="3.048" d="M26.963-212.292h201.875V84.376\n						c0,106.609-90.328,193.031-201.73,193.031c-111.395,0-201.715-86.422-201.715-193.031v-296.668H26.963z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/lu.svg','images/kanton/wappen/20px/Wappen_Appenzell_Innerrhoden_matt.svg.png','images/kanton/wappen/50px/Wappen_Appenzell_Innerrhoden_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Appenzell_Innerrhoden_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Luzern','Q12121','2014-09-16 00:00:00','2014-03-16 10:24:01','2021-02-05 20:25:09'),
(4,'UR',4,'Uri','Uri','Uri',0,2,'de','Altdorf',NULL,NULL,1077,1291,'\n<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1900 2298">\n<title>Wappen Uri</title>\n<path d="m949.3 7.079h939.7v1381c0 497-420 899-939 899-518.6 0-939.1-402-939.1-899l0.04-1381 938.4 0.079z" fill="#ffd72e"/>\n<g stroke="#fff" fill="none">\n<path stroke-linejoin="round" d="m1446 949c7-46.6 11-99.2 7-134.7-6-50.9-23-103.1-48-124.6 13-17.5 77-104.4-25-146m-925.4 405.3c-7.7-46.6-11.7-99.2-7.5-134.7 6.1-50.9 22.7-103.1 47.8-124.6-12.6-17.5-76.7-104.4 25.3-146" stroke-linecap="round" stroke-width="25.19"/>\n<path d="m755.2 1802h381.8" stroke-width="14.2"/>\n<path d="m480.3 742 313.2 215.8 1.4 408.2s-3.6 59-20.3 94c-9.2 19-63.1 64-81.9 70m722.3-788-313 215.8-1 408.2s4 59 20 94c9 19 63 64 82 70" stroke-linecap="round" stroke-width="25.19"/>\n</g>\n<g>\n<path d="m515.6 535.1s-51.5-22.4-131.3-228.1c-79.8-205.8-209-184.7-210.2-184.5-4 0.9-13.5 1.7-15.8 13.6-2.1 12 7.3 17.2 10.3 18.4 3 1.3 78.8 21 113.4 234.4 38.3 236.8 166.7 294.8 193.6 301.7-65.6-126.9 40-155.5 40-155.5"/>\n<path d="m1515 307c80-205.8 209-184.7 210-184.5 4 0.9 14 1.7 16 13.6 2 12-7 17.2-10 18.4-3 1.3-79 21-114 234.4-38 236.8-167 294.8-193 301.7 65-126.9-40-155.5-40-155.5"/>\n<path d="m1435 718.7s50 94.1 21 230.3c4 6.3 59 54 157 22.6s103-144.7 188-172.4c-54-90.6-176-206.4-366-80.5"/>\n</g>\n<path d="m1780 794.1s-78-38.9-122-38.9-141 60.4-158 59.1c-18-1.2-36-1.2-36-1.2" stroke="#fff" stroke-width="14.2" fill="none"/>\n<path d="m463.9 715s-49.5 94-20.6 230.2c-3.8 6.3-58.7 54.1-156.8 22.7-98.2-31.5-103.2-144.7-188.8-172.5 54.1-90.5 176.2-206.3 366.2-80.4"/>\n<path d="m119.2 790.4s77.9-39 121.9-39 140.9 60.4 158.6 59.1c17.6-1.2 35.2-1.2 35.2-1.2" stroke="#fff" stroke-width="14.2" fill="none"/>\n<g>\n<path d="m755.3 1809h381.7s7 69-46 69h-297.5c-41.1 0-38.2-69-38.2-69"/>\n<path d="m470.5 749.2 315.4 214.8 1.1 403s-8.6 53-23.1 93c-7.3 19-63.2 65-82.7 65-11.3-1-53.6-127-77.5-170-11.5-21-102.8-97-45.1-180-167.7-257.1-88.1-425.8-88.1-425.8"/>\n<path d="m1427 749.2-316 214.8-1 403s9 53 23 93c8 19 64 65 83 65 12-1 54-127 78-170 11-21 102-97 45-180 167-257.1 88-425.8 88-425.8"/>\n</g>\n<g>\n<path d="m599.2 901.4c0 48.2 41.5 87.3 92.7 87.3 25.5 0 48.4-9.7 65.2-25.3l-147.4-102.4c-6.6 12.1-10.5 25.8-10.5 40.4" fill="#fff"/>\n<path d="m627.1 901.4c0 33.7 29 61.1 64.8 61.1 17.5 0 33.3-6.6 45.1-17.2l-103-71.5c-4.4 8.3-6.9 17.6-6.9 27.6"/>\n<path d="m1296 901.4c0 48.2-41 87.3-93 87.3-25 0-48-9.7-65-25.3l147-102.4c7 12.1 11 25.8 11 40.4" fill="#fff"/>\n<path d="m1268 901.4c0 33.7-29 61.1-65 61.1-17 0-33-6.6-45-17.2l103-71.5c4 8.3 7 17.6 7 27.6"/>\n<path d="m1250 1556c-4-2-42 2-101-53-14-14-39-45-40-51-12-44-16-92-15-168 1-88 0-330 0-330l329-227.9s-24-51.1-62-52.8c-19-0.8-317 0.4-412.2 0.9-95.4-0.5-393.5-1.7-412-0.9-38.3 1.7-62.5 52.8-62.5 52.8l329 227.9s-1 242 0.4 330c1 76-3 124-14.8 168-1.5 6-26.1 37-40.7 51-58.3 55-96 51-100.5 53-22.8 8-49.3 26-22.8 129 26.4 102 72.2 110 72.2 110h503.9s45-8 72-110c26-103 0-121-23-129"/>\n<path d="m512.8 535.5c-29.8 11.6-50.3 30-58.5 52.8-2.7 7.8-4.2 15.9-4.2 24.5 0 22.4 8 52.2 27.1 79.2 53.4 75.8 119.6 67 150.8 52.7 0.1 0.1 0.1 0.1 0.2 0.1 10 19.1 19.7 31.3 41.7 41.3 15.8 7 36 1.2 55.6-4.4 6.8-2 16.6-4.8 20.7-4.9 2.8 1.5 9.1 7.4 13.5 11.4 11.4 10.7 24.4 22.9 39.8 24.5 12.2 1.2 24.8-3.6 38.3-8.6 10.6-4 22.4-8.5 29.7-7.8 0 0 1.5 0.1 1.6 0.1 0 0.2 1.1 1.1 1.1 1.1 11.4 9.5 25 17.3 79 17.8 54.8-0.6 67.8-8.9 77.8-18.8v-0.1l1-0.1c7-0.7 19 3.8 30 7.8 13 5 26 9.8 38 8.6 15-1.6 28-13.8 40-24.5 4-4 10-9.8 13-11.4 4 0.1 14 2.9 21 4.9 19 5.6 40 11.4 55 4.4 22-10 32-22.2 42-41.3v-0.2c19 8 96 23.6 155-52.6 18-23.4 23-56.8 23-79.2 0-8.4-1-16.5-4-24.1-9-27.4-33-43.2-56-52.5" fill="#fff"/>\n<path d="m1363 546.9c3-7.6 4-15.9 4-24.4 0-44.5-37-80.5-82-80.5-11 0-20 1.9-30 5.3-10-32.2-41-55.5-78-55.5-18 0-35 6.1-49 16.4-15-22.8-40-38.1-69-38.1-18 0-34 5.7-48 15.4-17.2 12.8-60.6-14.5-60.6-14.5s-53.6 22.8-76.2 9.7c-12-6.7-25.6-10.6-40.3-10.6-28.3 0-53.2 14.4-67.6 36.2-13.4-9.6-29.8-15.4-47.7-15.4-36.1 0-66.7 23.6-77 56.2-9.4-3.9-19.6-6-30.3-6-44.7 0-81 36.1-81 80.6 0 8.6 1.3 16.9 3.9 24.6-34.6 9.6-102.3 47.2-40.1 135.4 62.2 88.3 130.6 42.7 130.6 42.7s11.3-6.1 20 10.4c8.5 16.5 15.4 25.1 32.9 32.8 17.3 7.9 59.8-14.7 73.6-10.3 13.9 4.3 33.6 33.8 50.2 35.5 16.5 1.7 45.9-18.2 67.6-16.5 21.7 1.8 2.5 18.2 80.4 19.1 77.6-0.9 55.6-17.3 76.6-19.1 22-1.7 51 18.2 68 16.5 16-1.7 36-31.2 50-35.5 14-4.4 56 18.2 74 10.3 17-7.7 24-16.3 33-32.8 8-16.5 19-10.4 19-10.4s72 44.3 134-44c61-86.5-6-123.2-41-133.5"/>\n<path d="m818.3 1683c6.3 13 2.4 28-9 33l-18.3 9c-11.4 6-25.7 0-32-12l-36.7-73c-6.4-13-2.5-28 8.8-34l18.3-9c11.3-5 25.7 0 32.1 13l36.8 73z" fill="#12080d"/>\n<path d="m1075 1683c-6 13-3 28 9 33l18 9c11 6 26 0 32-12l37-73c6-13 2-28-9-34l-19-9c-11-5-25 0-31 13l-37 73z" fill="#12080d"/>\n</g>\n<path d="m818.3 1683c6.3 13 2.4 28-9 33l-18.3 9c-11.4 6-25.7 0-32-12l-36.7-73c-6.4-13-2.5-28 8.8-34l18.3-9c11.3-5 25.7 0 32.1 13l36.8 73zm256.7 0c-6 13-3 28 9 33l18 9c11 6 26 0 32-12l37-73c6-13 2-28-9-34l-19-9c-11-5-25 0-31 13l-37 73z" stroke="#fff" stroke-width="14.2" fill="none"/>\n<path d="m1107 1645c17-27 22-26 23-26 68 51 113 131 113 220 0 154-133 279-296 279-163.3 0-295.7-125-295.7-279 0-89 44.2-169 112.9-220 2.2-1 12.1-6 22.5 27 10.6 33 10.3 38 9.4 39-45 38-73.5 93-73.5 154 0 115 100.6 208 224.4 208 124 0 224-93 224-208 0-62-29-117-75-156 0 0-8-7 11-38" fill="#e7423f"/>\n<path d="m1107 1645c17-27 22-26 23-26 68 51 113 131 113 220 0 154-133 279-296 279-163.3 0-295.7-125-295.7-279 0-89 44.2-169 112.9-220 2.2-1 12.1-6 22.5 27 10.6 33 10.3 38 9.4 39-45 38-73.5 93-73.5 154 0 115 100.6 208 224.4 208 124 0 224-93 224-208 0-62-29-117-75-156 0 0-8-7 11-38z" stroke="#000" stroke-width="14.2" fill="none"/>\n<path d="m1027 1796c4 18 7 37 7 57 0 78-39.8 141-89 141s-89.2-63-89.2-141c0-20 2.7-39 7.6-56 45.1 0 146.6-1 163.6-1" fill="#e7423f"/>\n<path d="m1027 1796c4 18 7 37 7 57 0 78-39.8 141-89 141s-89.2-63-89.2-141c0-20 2.7-39 7.6-56 45.1 0 146.6-1 163.6-1zm-77.7-1789h939.7v1381c0 497-420 899-939 899-518.6 0-939.1-402-939.1-899l0.04-1381 938.4 0.079z" stroke="#000" stroke-width="14.2" fill="none"/>\n</svg>','images/kanton/wappen/svg/ur.svg','images/kanton/wappen/20px/Wappen_Basel-Landschaft.svg.png','images/kanton/wappen/50px/Wappen_Basel-Landschaft.svg.png','images/kanton/lage/Karte_Lage_Kanton_Basel_Landschaft_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Uri','Q12404','2014-09-16 00:00:00','2014-03-16 10:24:01','2021-02-05 20:25:09'),
(5,'SZ',5,'Schwyz','Schwyz','Svitto',0,2,'de','Schwyz',NULL,NULL,908,1291,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.523px" height="492.832px" viewBox="-176.119 -213.831 406.523 492.832"\n	 enable-background="new -176.119 -213.831 406.523 492.832" xml:space="preserve">\n<g>\n	<path fill="#E7423F" d="M27.018-212.311h201.871V84.392c0,106.633-90.328,193.07-201.742,193.07\n		c-111.426,0-201.746-86.438-201.746-193.07v-296.703H27.018z"/>\n	<polygon fill="#FFFFFF" points="209.686,-139.518 151.092,-139.518 151.092,-197.553 132.014,-197.553 132.014,-139.518\n		73.577,-139.518 73.577,-120.217 132.014,-120.217 132.014,-61.92 151.092,-61.92 151.092,-120.217 209.686,-120.217 	"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.119" y="-213.831" width="406.523" height="492.832"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#000000" stroke-width="3.048" d="M27.018-212.311h201.871V84.392\n						c0,106.633-90.328,193.07-201.742,193.07c-111.426,0-201.746-86.438-201.746-193.07v-296.703H27.018z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/sz.svg','images/kanton/wappen/20px/Wappen_Basel-Stadt_matt.svg.png','images/kanton/wappen/50px/Wappen_Basel-Stadt_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Basel_Stadt_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Schwyz','Q12433','2014-09-16 00:00:00','2014-03-16 10:24:01','2021-02-05 20:25:09'),
(6,'OW',6,'Obwalden','Obwald','Obvaldo',0,1,'de','Sarnen',NULL,NULL,491,1291,'\n<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="647" width="530">\n<g stroke="#000" stroke-width="3.6" fill="#d32">\n<path d="m2 3v377a263 263 0 0 0 526 0v-377z" fill="#fff"/>\n<path d="m528 2h-526v306h526z"/>\n<path d="m286 324v-306h-42v306m0-285h-50v24.3h-16v-24.3h-62v42h45v18h-45v42h62v-24h16v24h24v17h-24v24h-16v-24h-62v42h45v18h-45v42h62v-24h16v24h50" fill="#fff"/>\n<use xlink:href="#b" transform="matrix(-1,0,0,1,530,0)"/>\n<g id="b">\n<path id="a" d="m395 422c18 31 11 62-14 76s-36 1-35-22c-16 17-5 43 11 47 12 3 31-1 44-8 36-20 48-72 24-111"/>\n<path d="m264 343h34c4 0 6-4 6-7v-21c0-3-2-7-6-7h-34m0 318c37 0 67-17 81-46 11-22 7-42 1-58-11-29-51-23-55 1 15-10 33-11 36 11 4 36-22 57-63 57m1-248h27c9 0 21 7 17 21l-15 51h-29"/>\n<use xlink:href="#a" transform="matrix(.472 -.882 -.882 -.472 581 970)"/>\n<path d="m264 334h40c12 0 11-17 0-17h-40"/>\n<circle cy="483" cx="320" r="18.2"/>\n<circle cy="543" cx="370" r="18.2"/>\n</g>\n<ellipse cy="371" cx="265" rx="21" ry="28"/>\n<circle cy="426" cx="265" r="24.7"/>\n</g></svg>','images/kanton/wappen/svg/ow.svg','images/kanton/wappen/20px/Wappen_Bern_matt.svg.png','images/kanton/wappen/50px/Wappen_Bern_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Bern_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Obwalden','Q12573','2014-09-16 00:00:00','2014-03-16 10:24:01','2021-02-05 20:25:09'),
(7,'NW',7,'Nidwalden','Nidwald','Nidvaldo',0,1,'de','Stans',NULL,NULL,276,1291,'\n<svg xmlns="http://www.w3.org/2000/svg" height="2298" width="1900">\n<title>Wappen Nidwalden</title>\n<g stroke="#000" stroke-linecap="square" stroke-miterlimit="10" stroke-width="14.13" fill="#fff">\n<path d="m949.4 7.048h939.6v1381c0 497-420 899-939 899-518.6 0-939.1-402-939.1-899l-0.02-1381 938.5 0.048z" fill="#e7423f"/>\n<path d="m1119 844.2h129v107.3h200v-107.3h90v107.3h220v-121.7h-81v-96.9h81v-122.9h-220v107.3h-90v-107.3h-119v-94.3h119v-107.3h90v107.3h220v-121.6h-81v-96.9h81v-121.6h-220v105.9h-90v-105.9h-200v105.9h-129v562.7z"/>\n<path d="m777.8 844.2h-128.2v107.3h-200.2v-107.3h-90.3v107.3h-219.8v-121.7h81.1v-96.9h-81.1v-122.9h219.8v107.3h90.3v-107.3h119.1v-94.3h-119.1v-107.3h-90.3v107.3h-219.8v-121.6h81.1v-96.9h-81.1v-121.6h219.8v105.9h90.3v-105.9h200.2v105.9h128.2v562.7z"/>\n<path d="m969.1 69.66 1.2 1293c0 2 1.7 132 134.7 132 72 0 104-24 134-46 34-25 68-50 156-51 32 0 107 4 156 53 32 32 48 76 48 133 0 52-34 103-89 134-73 39-162 36-234-12l-18-12c-41-28-98-67-165-34-43 21-66 57-63 99 0 26 8 41 18 58 15 25 33 56 33 140 0 50-16 137-119.7 146-83.1 8-143.7-73-144.1-146-0.5-84 18.1-115 32.6-140 9.9-17 18.4-32 18.4-57 2.7-43-20.4-79-63.5-100-66.8-33-123.1 6-164.7 34l-17.8 12c-72.7 49-161.2 51-233.8 12-55.3-31-89.6-82-89.6-134 0-57 16.2-101 48-133 49.4-49 124.3-53 154.2-53 89.9 1 124.3 26 157.6 51 30.9 22 62.8 46 134.3 46 133.1 0 134.8-130 134.8-132l1.1-1293-163.3-0.68v1227c0 22-6 37-17 42-12.7 6-32.3-2-53.6-21-56.4-51-151.6-74-220.9-74-69.8 0-330.7 57-330.7 339 0 151 113.5 314 362.9 314 76.5 0 150.5-39 190.5-67-20.8 37-34.7 80-34.7 126 0 39 7.3 79 22.4 118 40.8 103 125.6 170 232.6 182 9.3 2 23.7 2 33 2 9.2 0 18.1 0 26.2-1 111.8-13 196.8-80 237.8-183 15-38 22-79 22-117 0-47-14-90-35-127 40 28 114 67 191 67 249 0 363-163 363-314 0-282-261-339-331-339-69 0-165 23-221 74-21 19-41 27-54 21-10-5-16-20-16-42v-1227z"/>\n<path d="m1213 1127c0 29-23 52-51 52h-424.7c-28.6 0-51.7-23-51.7-52s23.1-52 51.7-52h424.7c28 0 51 23 51 52z"/>\n</g>\n</svg>','images/kanton/wappen/svg/nw.svg','images/kanton/wappen/20px/Wappen_des_Kantons_Schwyz.svg.png','images/kanton/wappen/50px/Wappen_des_Kantons_Schwyz.svg.png','images/kanton/lage/Karte_Lage_Kanton_Freiburg_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Nidwalden','Q12592','2014-09-16 00:00:00','2014-03-16 10:24:01','2021-02-05 20:25:09'),
(8,'GL',8,'Glarus','Glaris','Glarona',0,2,'de','Glarus',NULL,NULL,685,1352,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.539px" height="492.849px" viewBox="-175.873 -214.081 406.539 492.849"\n	 enable-background="new -175.873 -214.081 406.539 492.849" xml:space="preserve">\n<g>\n	<path fill="#E8423F" d="M27.264-212.561h201.895V84.166c0,106.625-90.352,193.063-201.766,193.063\n		c-111.426,0-201.746-86.438-201.746-193.063v-296.727H27.264z"/>\n	<path fill="#FFD730" d="M112.682-152.225c0,27.32-24.266,49.48-54.203,49.48c-29.941,0-54.207-22.16-54.207-49.48\n		c0-27.336,24.266-49.488,54.207-49.488C88.417-201.713,112.682-179.561,112.682-152.225"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-175.873" y="-214.081" width="406.539" height="492.849"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.32" stroke-miterlimit="10" d="M58.479-201.706\n						c29.945,0,54.211,22.152,54.211,49.48s-24.266,49.48-54.211,49.48c-29.938,0-54.207-22.152-54.207-49.48\n						S28.542-201.706,58.479-201.706z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<polygon fill="#010202" points="-128.814,-181.905 -77.361,233.791 -62.087,232.103 -109.806,-184.026 	"/>\n	<path fill="#FFD730" d="M-124.966-178.866c0.086,0.625,50.543,408.258,50.625,408.859c0.551-0.078,7.863-0.867,8.438-0.93\n		c-0.086-0.633-46.871-408.648-46.941-409.289C-113.431-180.143-124.384-178.928-124.966-178.866"/>\n	<path fill="#010202" d="M-121.623-197.659L-121.623-197.659c-9.801,1.234-17.055,7.898-16.184,14.867\n		c0.895,6.969,9.582,11.613,19.367,10.375c5.77-0.719,10.938-3.391,13.84-7.113c1.848-2.414,2.672-5.094,2.336-7.758\n		C-103.142-194.256-111.83-198.913-121.623-197.659"/>\n	<path fill="#FFD730" d="M-121.201-194.241c-7.52,0.945-13.223,5.457-13.223,10.254c0,0.25,0.016,0.508,0.047,0.762\n		c0.648,5.082,7.602,8.402,15.52,7.395c4.859-0.617,9.18-2.793,11.523-5.82c1.285-1.672,1.855-3.477,1.645-5.199\n		C-106.333-191.928-113.287-195.241-121.201-194.241"/>\n	<path fill="#010202" d="M-108.24-91.858L-108.24-91.858c-9.457,1.219-16.43,7.68-15.559,14.395\n		c0.871,6.719,9.254,11.199,18.695,9.984c9.449-1.203,16.406-7.672,15.559-14.395C-90.408-88.592-98.791-93.073-108.24-91.858"/>\n	<path fill="#FFD730" d="M-107.806-88.424c-7.168,0.918-12.617,5.215-12.617,9.801c0,0.238,0.016,0.496,0.047,0.734\n		c0.625,4.824,7.273,7.969,14.832,6.992c7.547-0.969,13.191-5.695,12.555-10.527C-93.591-86.264-100.24-89.409-107.806-88.424"/>\n	<path fill="#010202" d="M-68.263-51.737c40.969-3.543,90.336-17.848,112.375-71.199c21.672,0,27.75-1.457,27.75-1.457\n		s7.984,10.535,46.078,30.594c7.219,3.789,29.203,82.59,29.203,82.59s4.063,15.594-7.297,16.906\n		c-11.359,1.277-31.953,0.438-31.953,0.438s26.492,208.734,26.688,210.516c-1.5,0.422-10.523,5.203-20.828,10.594\n		c-10.219,5.313-21.75,11.266-28.547,12.953c-0.438,0.125-5.469,1.359-7.781-3.25c-2.313-4.578,0.859-8.063,0.859-8.063\n		l22.281-19.641c0,0,0.625-1.117,0.594-1.875c-0.055-0.781-1.039-1.078-1.039-1.078l-36.422-0.281L29.432,29.4l-4.023,0.902\n		L58.651,206.54l-71.137,0.047L6.323-24.303l-72.211-0.203C-65.88-24.506-68.064-49.608-68.263-51.737"/>\n	<polygon fill="#FFFFFF" points="71.417,-102.768 74.057,-122.944 67.698,-109.143 48.846,-109.143 43.549,-121.881\n		45.909,-102.768 	"/>\n	<rect x="42.995" y="-57.377" fill="#FFD730" width="47.797" height="32.145"/>\n	<rect x="33.713" y="-57.377" fill="#FFD730" width="7.18" height="32.145"/>\n	<rect x="27.338" y="-57.377" fill="#FFD730" width="4.508" height="32.145"/>\n	<path fill="#010202" d="M93.581-152.225c0,18.609-16.195,33.68-36.164,33.68c-19.984,0-36.176-15.07-36.176-33.68\n		c0-18.605,16.191-33.688,36.176-33.688C77.385-185.913,93.581-170.831,93.581-152.225"/>\n	<path fill="#FFFFFF" d="M56.612-167.127c8.313,0.16,22.836-2.891,19.922,14.805c-0.609,3.699,0,8.57,0,8.57\n		s0.547,5.664-0.156,9.414c-1.25,11.328-3.859,13.496-16.859,13.961c-15.344,0.547-15.063-0.969-17.563-7.191\n		c-5.672-17.281-3.328-30.551-3.328-30.551S40.026-167.409,56.612-167.127"/>\n	<path fill="#010202" d="M13.608,210.064c0,0-16.992,0-26.613-0.055c-6.426,9.023-25.891,6.328-31.082,6.609\n		c-4.559,0.266-7.695,3.219-7.695,7.969c0,4.773,3.953,8.016,8.207,8.016H5.288c5.938,0,7.715-5.359,7.715-5.359L13.608,210.064z"/>\n	<path fill="#FFFFFF" d="M65.94-0.346l-2.945-22.75l-15.742,0.109H32.549c-0.625,0-1.148,0.656-1.148,1.426\n		c0,0.801,0.508,1.441,1.148,1.441h11.688c0,0,0.297,2.031-0.57,2.078c0,0-12.883,0.234-13.461,0.234\n		c-0.594,0-4.285-3.25-4.285-3.25c-0.215-0.215-0.305-0.313-0.391-0.438c-0.152-0.219-0.207-0.578-0.207-0.578\n		c0-0.656-0.203-1.25-0.945-1.297c-0.754-0.047-1.328,0.426-1.41,1.098c-0.184,1.473,0.059,1.605,0.168,1.766\n		c0.098,0.168,0.242,0.426,4.699,4.855c0.215,0.313,0.773,0.516,1.133,0.508l11.77-0.066l0.109,2.184H28.881\n		c-0.641,0-1.152,0.641-1.152,1.441c0,0.785,0.504,1.426,1.152,1.426h12.074l0.109,2.031H29.44c-0.633,0-1.16,0.641-1.16,1.422\n		c0,0.801,0.52,1.426,1.16,1.426h11.766l0.078,2.145H30.19c-0.652,0-1.164,0.641-1.164,1.422c0,0.801,0.504,1.441,1.164,1.441\n		h14.953c0.047,0,0.109-0.051,0.172-0.051H65.94V-0.346z"/>\n	<path fill="#010202" d="M-116.494-50.264c0,1.832,1.285,4.77,4.918,4.77h13.801v21.215l57.594-0.215l-2.641-27.922l-73.672-0.07\n		V-50.264z"/>\n	<path fill="#FFFFFF" d="M-67.56-26.674l-2.215-23.543l-44.52-0.047c0,0.918,0.574,2.605,2.727,2.605h15.984v21.035L-67.56-26.674z"\n		/>\n	<path fill="#010202" d="M-110.287-47.639c-2.023,0-3.664,1.719-3.664,3.855c0,2.125,1.641,3.84,3.664,3.84h13.953\n		c2.039,0,3.672-1.723,3.672-3.84c0-2.145-1.633-3.855-3.672-3.855H-110.287z"/>\n	<path fill="#FFFFFF" d="M-110.287-45.456c-0.809,0-1.465,0.75-1.465,1.672c0,0.902,0.656,1.656,1.465,1.656h13.953\n		c0.824,0,1.496-0.754,1.496-1.656c0-0.922-0.672-1.672-1.496-1.672H-110.287z"/>\n	<path fill="#010202" d="M-109.263-41.69c-2.023,0-3.641,1.703-3.641,3.816c0,2.082,1.617,3.801,3.641,3.801h13.488\n		c2,0,3.633-1.719,3.633-3.801c0-2.113-1.633-3.816-3.633-3.816H-109.263z"/>\n	<path fill="#FFFFFF" d="M-109.263-39.506c-0.801,0-1.457,0.723-1.457,1.625c0,0.871,0.656,1.609,1.457,1.609h13.488\n		c0.793,0,1.449-0.738,1.449-1.609c0-0.902-0.656-1.625-1.449-1.625H-109.263z"/>\n	<path fill="#010202" d="M-108.767-35.897c-1.992,0-3.574,1.574-3.574,3.512c0,1.922,1.582,3.512,3.574,3.512h13.625\n		c1.984,0,3.59-1.59,3.59-3.512c0-1.938-1.605-3.512-3.59-3.512H-108.767z"/>\n	<path fill="#FFFFFF" d="M-108.767-33.69c-0.801,0-1.457,0.578-1.457,1.313c0,0.738,0.656,1.313,1.457,1.313h13.625\n		c0.809,0,1.445-0.574,1.445-1.313c0-0.734-0.637-1.313-1.445-1.313H-108.767z"/>\n	<path fill="#010202" d="M-107.904-30.905c-1.961,0-3.559,1.488-3.559,3.328c0,1.855,1.598,3.375,3.559,3.375h12.914\n		c1.977,0,3.566-1.512,3.566-3.375c0-1.84-1.59-3.328-3.566-3.328H-107.904L-107.904-30.905z"/>\n	<path fill="#FFFFFF" d="M-107.904-28.721c-0.758,0-1.375,0.512-1.375,1.145c0,0.641,0.617,1.168,1.375,1.168h12.914\n		c0.781,0,1.375-0.527,1.375-1.168c0-0.625-0.594-1.145-1.375-1.145H-107.904z"/>\n	<path fill="#010202" d="M47.924-147.194c0,1.229-1,2.207-2.195,2.207c-1.211,0-2.195-0.979-2.195-2.207\n		c0-1.215,0.984-2.199,2.195-2.199C46.924-149.401,47.924-148.409,47.924-147.194"/>\n	<path fill="#010202" d="M67.877-147.194c0,1.229-0.984,2.207-2.219,2.207c-1.188,0-2.188-0.979-2.188-2.207\n		c0-1.215,1-2.199,2.188-2.199C66.893-149.401,67.877-148.409,67.877-147.194"/>\n	<path fill="#010202" d="M59.76-154.522c-0.477,0.395-0.508,1.074-0.148,1.555c0.398,0.461,1.758,0.879,2.219,0.488\n		c0.125-0.105,3.844-2.121,4.781-1.953c1.656,0.32,3.672,0.895,6,2.063c0.547,0.273,1.172,0.25,1.547-0.23\n		c0.375-0.504,0.078-1.449-0.445-1.809C66.284-159.799,59.831-154.577,59.76-154.522"/>\n	<path fill="#010202" d="M42.713-154.616c-0.555,0.23-0.805,0.879-0.57,1.449c0.25,0.559,1.297,1.008,1.844,0.758\n		c1.188-0.504,4.266-1.734,6.125-0.449c1.094,0.793,1.563,2.395,1.391,4.785c-0.703,10-0.641,12.879-0.641,13.008\n		c0.016,0.586,0.477,1.063,1.063,1.09l9.031,0.344c0.609,0.023,0.672-2.191,0.086-2.219c0,0-6.25,0.219-7.906,0.145\n		c0.039-1.527,0.117-5.445,0.594-12.191c0.031-0.367,0.031-0.703,0.031-1.063c0-2.648,0.313-4.586-1.227-5.723\n		C49.088-157.194,42.924-154.729,42.713-154.616"/>\n	<path fill="#010202" d="M51.956-128.995c-0.914,0-1.656,0.73-1.656,1.648c0,0.914,0.742,1.664,1.656,1.664h10\n		c0.922,0,1.672-0.75,1.672-1.664c0-0.918-0.75-1.648-1.672-1.648H51.956z"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_3_" x="-175.873" y="-214.081" width="406.539" height="492.849"/>\n					</defs>\n					<clipPath id="SVGID_4_">\n						<use xlink:href="#SVGID_3_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_4_)" fill="none" stroke="#010202" stroke-width="3.048" d="M27.264-212.561h201.895V84.166\n						c0,106.625-90.352,193.063-201.766,193.063c-111.426,0-201.746-86.438-201.746-193.063v-296.727H27.264z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/gl.svg','images/kanton/wappen/20px/Wappen_Freiburg_matt.svg.png','images/kanton/wappen/50px/Wappen_Freiburg_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Genf_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Glarus','Q11922','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(9,'ZG',9,'Zug','Zoug','Zugo',0,2,'de','Zug',NULL,NULL,239,1352,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="407.257px" height="493.719px" viewBox="-176.486 -214.276 407.257 493.719"\n	 enable-background="new -176.486 -214.276 407.257 493.719" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M26.987-212.749h202.277V84.49c0,106.844-90.508,193.422-202.141,193.422s-202.09-86.578-202.09-193.422\n		v-297.238L26.987-212.749L26.987-212.749z"/>\n	<polygon fill="#268BCC" points="-174.966,103.224 -174.966,-54.198 26.987,-54.198 229.264,-54.198 229.264,103.224 	"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.486" y="-214.276" width="407.257" height="493.719"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M26.987-212.749h202.277V84.49\n						c0,106.844-90.508,193.422-202.141,193.422s-202.09-86.578-202.09-193.422v-297.238L26.987-212.749L26.987-212.749z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/zg.svg','images/kanton/wappen/20px/Wappen_Genf_matt.svg.png','images/kanton/wappen/50px/Wappen_Genf_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Glarus_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Zug','Q11933','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(10,'FR',10,'Freiburg','Fribourg','Friburgo',1,2,'fr','Freiburg',NULL,NULL,1671,1481,'<svg xmlns="http://www.w3.org/2000/svg" height="765" width="605" >\n <path d="m1.5,1.5,0,458.87c0,166.31,134.31,301.13,300,301.13s300-134.82,300-301.13v-458.87h-600z" stroke="#000000" stroke-width="3" fill="#ffffff"/>\n <path fill="#000000" d="m1.5,1.5,0,365.5,600,0,0-365.5-600,0z" fill-rule="nonzero"/>\n</svg>','images/kanton/wappen/svg/fr.svg','images/kanton/wappen/20px/Wappen_Glarus_matt.svg.png','images/kanton/wappen/50px/Wappen_Glarus_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Graubünden_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Freiburg','Q12640','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(11,'SO',11,'Solothurn','Soleure','Soletta',0,2,'de','Solothurn',NULL,NULL,791,1481,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.425px" height="492.703px" viewBox="-176.197 -213.866 406.425 492.703"\n	 enable-background="new -176.197 -213.866 406.425 492.703" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M26.881-212.346h201.824V84.306c0,106.594-90.281,193.016-201.688,193.016\n		c-111.398,0-201.695-86.422-201.695-193.016v-296.652H26.881z"/>\n	<polygon fill="#E8423F" points="-174.677,20.529 -174.677,-212.346 26.881,-212.346 228.707,-212.346 228.707,20.529 	"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.197" y="-213.866" width="406.425" height="492.703"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M26.881-212.346h201.824V84.306\n						c0,106.594-90.281,193.016-201.688,193.016c-111.398,0-201.695-86.422-201.695-193.016v-296.652H26.881z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/so.svg','images/kanton/wappen/20px/Wappen_Graubünden_matt.svg.png','images/kanton/wappen/50px/Wappen_Graubünden_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Jura_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_St._Gallen','Q12746','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(12,'BS',12,'Basel-Stadt','Bâle-Ville','Basilea Città',0,1,'de','Basel',NULL,NULL,37,1501,'\n<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1900 2274">\n<title>Wappen Stadt Basel</title>\n<path d="m1893 6.869v1369c0 492-423 890-943.5 890-521 0-942.6-398-942.6-890l-0.031-1369z" stroke="#000" stroke-width="13.74px" fill="#fff"/>\n<path d="m702.2 540.7c22.2 35.4 37 234.5-199.7 227.2-142.7-4.1-245.2-173-204-354.4 41.2-182.5 227.2-288.8 390-285.7 283.2 7.3 427.5 221 469.5 340.9 37 110.5 59 257.5 58 350.3h-424c29.6-168.9 11.6-237.7 11.6-237.7s-41.2-172-164.8-172-149 107.4-149 107.4-13.7 83.4 48.6 96.9c15.9 3.2 48.6 1.1 48.6-39.6 0-19.8-16.9-38.6-46.5-34.4 13.8-65.7 104.6-90.7 161.7 1.1zm-28.5 389.9c-31.7 0-57.1 25-57.1 56.3 0 31.1 25.4 57.1 57.1 57.1h1 660.3c32 0 58-26 58-57.1 0-31.3-26-56.3-58-56.3h-661.3zm61.3-90.7c-18 0-31.8 15.6-31.8 34.4 0 19.8 13.8 34.4 31.8 34.4h538c17 0 32-14.6 32-34.4 0-18.8-15-34.4-32-34.4zm-29.6 225.1c-19 0-34.9 16-34.9 34 0 19 15.9 35 34.9 35h596.6c19 0 35-16 35-35 0-18-16-34-35-34h-596.6zm23.2 88-143.7 899 245.2-183 173.9 186 175-186 245 183-145-899z"/>\n</svg>','images/kanton/wappen/svg/bs.svg','images/kanton/wappen/20px/Wappen_Jura_matt.svg.png','images/kanton/wappen/50px/Wappen_Jura_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Luzern_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Basel-Stadt','Q12172','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(13,'BL',13,'Basel-Landschaft','Bâle-Campagne','Basilea Campagna',0,1,'de','Liestal',NULL,NULL,518,1501,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="408.272px" height="494.945px" viewBox="-176.966 -215.01 408.272 494.945"\n	 enable-background="new -176.966 -215.01 408.272 494.945" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M27.034-213.491h202.75V84.49c0,107.102-90.704,193.906-202.605,193.906\n		c-111.918,0-202.625-86.813-202.625-193.906v-297.98L27.034-213.491L27.034-213.491z"/>\n	<path fill="#E8423F" d="M180.917-103.768c-0.055-2.266-0.219-4.543-0.531-6.848c-0.836-6.32-2.961-13.113-6.258-19.891\n		c4.656-2.285,7.883-6.965,7.883-12.391c0-7.672-6.461-13.887-14.391-13.887c-3.672,0-6.969,1.313-9.508,3.48\n		c-7.18-7.48-15.953-14.145-26.211-19.168c0.914-1.832,1.469-3.867,1.469-6.027c0-7.672-6.438-13.902-14.422-13.902\n		c-7.047,0-12.938,4.938-14.148,11.441c-10.25-1.578-21.359-1.594-33.359,0.367c-1.5-6.146-7.18-10.729-13.984-10.729\n		c-7.984,0-14.406,6.223-14.406,13.896c0,1.59,0.281,3.121,0.781,4.535c-1.031,0.426-2.063,0.832-3.094,1.266\n		c-8.703,3.605-17.512,8.598-25.926,14.926c-2.609-2.695-6.328-4.398-10.465-4.398c-7.977,0-14.414,6.215-14.414,13.887\n		c0,3.898,1.664,7.426,4.359,9.953c-7.113,8.406-13.441,18.07-18.543,29.031c-1.801-0.758-3.785-1.176-5.832-1.176\n		c-8.066,0-14.609,6.313-14.609,14.09c0,6.688,4.801,12.262,11.273,13.719c-2.512,10.68-4.008,22.254-4.113,34.75h79.184\n		c-0.367-31.734,6.938-55.199,19.82-68.23c14.914-15.07,36.75-16.703,54.281-9.328c18.422,7.738,26.422,26.281,19.289,40.383\n		c-5.523,10.977-20.984,19.273-42.945,17.723c13.469,16.375,27.914,22.871,41.156,22.559c1.016,6.738,6.984,11.902,14.219,11.902\n		c7.969,0,14.422-6.215,14.422-13.887c0-3.031-1.031-5.816-2.719-8.098c7.016-5.766,12.781-13.605,16.594-22.652\n		c1.078,0.223,2.164,0.383,3.313,0.383c7.961,0,14.375-6.223,14.375-13.91C193.456-97.065,187.995-102.889,180.917-103.768"/>\n	<polygon fill="#E8423F" points="2.245,237.099 28.299,135.787 73.917,215.083 47.604,-10.338 -43.38,-10.338 -69.435,215.083\n		-24.052,135.787 	"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M180.917-103.768c-0.055-2.266-0.219-4.543-0.531-6.848\n		c-0.836-6.32-2.961-13.113-6.258-19.891c4.656-2.285,7.883-6.965,7.883-12.391c0-7.672-6.461-13.887-14.391-13.887\n		c-3.672,0-6.969,1.313-9.508,3.48c-7.18-7.48-15.953-14.145-26.211-19.168c0.914-1.832,1.469-3.867,1.469-6.027\n		c0-7.672-6.438-13.902-14.422-13.902c-7.047,0-12.938,4.938-14.148,11.441c-10.25-1.578-21.359-1.594-33.359,0.367\n		c-1.5-6.146-7.18-10.729-13.984-10.729c-7.984,0-14.406,6.223-14.406,13.896c0,1.59,0.281,3.121,0.781,4.535\n		c-1.031,0.426-2.063,0.832-3.094,1.266c-8.703,3.605-17.512,8.598-25.926,14.926c-2.609-2.695-6.328-4.398-10.465-4.398\n		c-7.977,0-14.414,6.215-14.414,13.887c0,3.898,1.664,7.426,4.359,9.953c-7.113,8.406-13.441,18.07-18.543,29.031\n		c-1.801-0.758-3.785-1.176-5.832-1.176c-8.066,0-14.609,6.313-14.609,14.09c0,6.688,4.801,12.262,11.273,13.719\n		c-2.512,10.68-4.008,22.254-4.113,34.75h79.184c-0.367-31.734,6.938-55.199,19.82-68.23c14.914-15.07,36.75-16.703,54.281-9.328\n		c18.422,7.738,26.422,26.281,19.289,40.383c-5.523,10.977-20.984,19.273-42.945,17.723c13.469,16.375,27.914,22.871,41.156,22.559\n		c1.016,6.738,6.984,11.902,14.219,11.902c7.969,0,14.422-6.215,14.422-13.887c0-3.031-1.031-5.816-2.719-8.098\n		c7.016-5.766,12.781-13.605,16.594-22.652c1.078,0.223,2.164,0.383,3.313,0.383c7.961,0,14.375-6.223,14.375-13.91\n		C193.456-97.065,187.995-102.889,180.917-103.768z"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-linecap="round" stroke-linejoin="round" d="M1.627-46.85\n		c-0.352-31.734,8.68-52.461,18.137-68.07c10.969-18.176,36.816-45.777,92.832-33.832c62.781,13.375,56.281,105.855-16.75,84.168"/>\n	<path fill="#040304" d="M47.604-10.338H-43.38l-26.055,225.406l1.512-2.641l2.328-4.063l41.527-72.578L0.651,230.99l0.824,3.172\n		l0.762,2.938l0.766-2.938l0.809-3.141l24.48-95.234l41.789,72.594l2.328,4.047l1.516,2.641L47.604-10.338z M-40.669-7.288h85.57\n		l24.258,207.996l-38.234-66.453l-3.73-6.484l-1.863,7.25L2.209,224.904l-23.328-89.883l-1.871-7.25l-3.711,6.508l-38.016,66.414\n		L-40.669-7.288z"/>\n	<line fill="none" stroke="#040304" stroke-width="3.048" x1="2.573" y1="-9.209" x2="2.573" y2="228.591"/>\n	<rect x="-65.486" y="-48.522" fill="#E8423F" width="139.121" height="40.641"/>\n	<rect x="-65.486" y="-48.522" fill="none" stroke="#010202" stroke-width="3.048" width="139.121" height="40.641"/>\n	<rect x="-82.478" y="-36.713" fill="#E8423F" width="173.129" height="17.082"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.966" y="-215.01" width="408.272" height="494.945"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M27.034-213.491h202.75V84.49\n						c0,107.102-90.704,193.906-202.605,193.906c-111.918,0-202.625-86.813-202.625-193.906v-297.98L27.034-213.491L27.034-213.491z\n						 M90.651-19.631H-82.47v-17.082H90.651V-19.631z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/bl.svg','images/kanton/wappen/20px/Wappen_Luzern_matt.svg.png','images/kanton/wappen/50px/Wappen_Luzern_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Neuenburg_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Basel-Landschaft','Q12146','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(14,'SH',14,'Schaffhausen','Schaffhouse','Sciaffusa',0,2,'de','Schaffhausen',NULL,NULL,298,1501,'\n<svg xmlns="http://www.w3.org/2000/svg" height="2298" width="1900" version="1.1" xmlns:cc="http://creativecommons.org/ns#">\n<title>Wappen Schaffhausen</title>\n<path d="m949.4 7.069h939.6v1381c0 497-420 899-939 899-518.7 0-939.1-402-939.1-899l-0.02-1381 938.5 0.069z" fill="#ffd72e"/>\n<path d="m949.4 7.069h939.6v1381c0 497-420 899-939 899-518.7 0-939.1-402-939.1-899l-0.02-1381 938.5 0.069z" stroke="#000" stroke-width="14.14" fill="none"/>\n<path d="m166.5 747.7s60.5 14.3 93.1 2.5c19.4-7 21.1-43.5 15.7-42-14.6 4.3-91.4-8-117.7-14.8-7.5-1.9 8.9 54.3 8.9 54.3z" stroke="#000" stroke-miterlimit="10" stroke-width="12.43" fill="none"/>\n<path d="m294 742.6s-141.5-3.1-150.5-6.7c-9.1-3.6 16.9 60.1 53.2 75.1 20.9 8.6 58.5-36 100.2-39.4 10.3-0.8-2.9-29-2.9-29" fill="#ffd72e"/>\n<path d="m253.4 698.5c-2.4 2.5-4.1 35-4.1 35l31.8 45.3s25.5-8.5 24.7-3c3.1 15.2-12.9 27 10 33 22.8 6.1 22.7-32 90.6-29.6 67.8 2.5 90.5 10 107.9 35.7 22 32.5 36.2 126 41.8 139.5 4.2 10.1 16.1 40.9 33.7 48.6 18.4 7 41.4-27.7 41.4-28.7 0-7.8-7.9-16.4-7.9-23.2 0-6.9 9.8-25.1 17.1-36.8 9.5-15.3-29.6-103.7-32.2-113.8-0.3-17.4-7-33.8-7-33.8s-11.3-20.8-16.6-26.1c-5.4-5.2-6.4-11.2-12.8-13.2-4.7-1.6-61.8-12.4-100.8-13-11.3-0.2-94.5-14.5-103.8-8.1-32.1-10.1-81.7-44-113.8-7.8"/>\n<path d="m1003 1482c1 6 19 140 19 144s-28.3 44-66.3 41c-24.8-3-38.7-50-33-98 5.6-48 68.4-90 80.3-87z" stroke="#000" stroke-width="13.99" fill="none"/>\n<path d="m1108 1618c-27-43-83-129-83-129s-52.7 10-48.6 98c4.2 88 106.6 81 131.6 31" fill="#ffd72e"/>\n<g stroke="#000" fill="none">\n<path d="m1108 1618c-27-43-83-129-83-129s-52.7 10-48.6 98c4.2 88 106.6 81 131.6 31z" stroke-width="13.99"/>\n<path d="m294 742.6s-141.5-3.1-150.5-6.7c-9.1-3.6 16.9 60.1 53.2 75.1 20.9 8.6 58.5-36 100.2-39.4 10.3-0.8-2.9-29-2.9-29z" stroke-miterlimit="10" stroke-width="12.43"/>\n<path d="m225.9 1104-33.3 100s-84.5 1-76.4-5c8-7 51.9-77 60.6-80s49.1-15 49.1-15z" stroke-miterlimit="10" stroke-width="13.99"/>\n</g>\n<path d="m222.5 1096s58.3 9 54.7 8 3.1 83 0.7 87c-2.3 5-71.3 54-112 38-6-2 56.6-133 56.6-133" fill="#ffd72e"/>\n<path d="m222.5 1096s58.3 9 54.7 8 3.1 83 0.7 87c-2.3 5-71.3 54-112 38-6-2 56.6-133 56.6-133z" stroke="#000" stroke-miterlimit="10" stroke-width="13.99" fill="none"/>\n<path d="m454.5 1900s41.7-3 48.9 7-60.1 73-60.1 73-69.2 5-73.3-2 84.5-78 84.5-78z" stroke="#000" stroke-width="13.99" fill="none"/>\n<path d="m508.2 1888 30.4 11s7.9 83-2.6 95c-10.7 13-72.2 40-124.6 17-12.3-6 96.8-123 96.8-123" fill="#ffd72e"/>\n<path d="m508.2 1888 30.4 11s7.9 83-2.6 95c-10.7 13-72.2 40-124.6 17-12.3-6 96.8-123 96.8-123zm989.8-10c14-10 29-22 53-23l-4 114s-72 34-74 29 14-110 25-120z" stroke="#000" stroke-width="13.99" fill="none"/>\n<path d="m1550 1824s-39 173-35 179c3 5 99-42 104-76 4-33-26-110-26-110l-43 7z" fill="#ffd72e"/>\n<path d="m1550 1824s-39 173-35 179c3 5 99-42 104-76 4-33-26-110-26-110l-43 7z" stroke="#000" stroke-width="13.99" fill="none"/>\n<path d="m1037 1460c-11 14-28 21-30 17 6-38-10.6-85-40.2-122 35.2 5 83.2 90 70.2 105m-471.4-324c4.9 7-6.2 30 7.1 49 9.8 14 34.8 8 41.1 17 10.6 14 36.9 86 104.6 30 17 38 257.1 113 237 107-94.6-23-88.1 9-106.6 2-18.5-8-66.7-35-82.2 22-39-10-57.2-7-83.9 45-5.4 3-70.6 15-53.8 84-40 23-29.5 58 6.5 97-4.7 38-14.7 68 51.2 76 3.8 6 11.5 33 67.2 30 10.5 18-1.8 26-1.8 26s-150.6 108-216.6 111c-26.7 2-25.4 4-32.3 10s-25.7 51-25.7 51-7.5 12 3.1 17c10.4 6 36.9 16 55.3 17 5.6 1 13.6-2 16.9-14 3.4-13 28.7-23 32.3 14 0.4 4 22.4-1 24.3-4 16.2-26 28.8-65 99.5-94 58.3-23 166-61 174.3-66 8.2-6 12.3-38 5-49-7.4-10-26.2-35-26.2-35s68.3-24 74.2-26c-50.6-78 20.3-179 89.9-163-2 2-21 23 15 48-25 52 40 64 40 64s2 34 9 39 7 6 61 2c16-1 46 57 102 0 12 30 80 43 92-1 67 36 91-34 86-46 9 0 9-1 12-8 32 17 37 50 52 93 16 49 33 104 33 104s3 23-1 26c-10 6-19 31-10 57 61 31 92 4 92-1 1-5 4-21 9-25s29-15 29-21c-1-6-8-15-18-26-11-5-18-20-27-25-16-9-68-177-74-202-5-25 16-89-19-96-31-6-44 29-64 11-5-6 13-11-2-34-3-4-15-18-38-13 8-49-51-54-51-54s9-24-28-82c97 7 87-28 103-32 8-2 78 21 86-30 10 0 60 7 71-46 53 12 62-48 62-48s71-13 37-67c27-22 30-63-22-69 2-57.5-43-61.3-72-31.2-2-4.6-48-38.2-77 33.2-63-9-55 50-55 50s-51-13-47 62c-23 3-20 20-20 20s10 104-79 122c-33-55-130-83-197-119-45-23-75-50-70-59 28-53 17-65 17-65s48-22.9 40-54.1c47-14.5 33-52.6 42-62.9 8-10.3 49-5.3 30-59.9-4-9.3-55-27.1-74-54.3-4 0-7 0.5-7 0.5s-2-38.2-18-39.5-39 26.8-58 25.9c-10-0.4-39.6-1.7-47.6-3-8.1-1.2-37.3 22.7-37.3 22.7s-65-15.2-83.5 21.8c-47.7-22.6-71.5 18.5-71.5 18.5s-60.7-18.9-71.2 53c-69.1 12.1-64.9 47.7-63.4 63.6 1.4 16 8.6 16.2 3.4 32.5-24.9 6.5-49.6 36.2-49.6 36.2s-8.9 4-38.3-20c-35-27.9-51.6-41.3-59.7-50.5-8.2-9.2-30.3-14.3-64.5 0.9-14.8 6.5-12.8 12.6-54.2 39.1-49.1 31.5-102.7 69.5-136.5 64.5-20.5-3-58.5 29-58.9 56-0.3 26 98.2 23 99.3 12 1.2-11 8.8-16 8.8-16s23.8 48 52.6 12 52.4-55 52.4-55 37.6-42 73.8-26 61.4 63 93.5 97"/>\n<path d="m815.3 300.2c-15.9-161.7 369.7-165.2 268.7 183.2" stroke="#000" stroke-width="13.8" fill="none"/>\n<path d="m1145 616.5c10 7.9 72-130.1 84-142.9 12-12.7 19-30.4 19-50.1 0-31.2-18-57.8-43-67.6 9-14.2 14-31.4 14-50.1 1-48.9-34-88.9-78-89.3-2-0.1-4 0.1-6 0.3 16-20.4 20-48.4 7-70.7-16-29.1-54-37.3-84-18.4-2 1.1-4 2.4-5 3.6-1-8.9-4-17.5-9-25.1-17-27.26-54.8-32.45-83.7-11.75-3.3 2.3-6.2 4.86-8.9 7.55-18-25.25-54.3-29.77-82.5-9.59-8.2 5.79-14.7 13.09-19.5 21.19-17.6-9.6-38.8-9.4-55.6 2.6-23.1 16.5-29.6 49.3-16.4 76.2-14.5-0.9-28.7 4-39.1 15-20.9 21.7-19.2 59 3.6 83.4 1.4 1.4 2.9 2.8 4.3 4.1-0.8 0.8-1.6 1.5-2.4 2.3-19.8 20.7-19.7 54.8 0.3 76.1 14.6 15.5 35.6 19.9 53.6 13.2-6.5 18.6-3.4 39.6 9.8 53.7 18.8 19.9 50.6 18.8 71.1-2.7 3.6-3.8 6.6-8 9.1-12.5 17.2 21.7 46.6 25.8 66.2 9.2 18.1-15.4 21.4-43.1 9-64.9 52.1-42.2-20.6-112.6-64.3-69.6 22.1 10.3 25.1 36.6 6.2 45.9-9 4.3-19.1 7.2-27.2 4.5-34.3-11.2-29.6-57.8-25.8-70.1 15-48.9 86.4-58.5 133.2-38.8 24 10 122 49 42 264.6" stroke="#000" stroke-width="14" fill="none"/>\n<path d="m1650 765.4c23-15 37-42.6 33-72-3-25.9-19-46.7-40-57.2 6-12.2 8-25.9 7-40.2-5-39-39-66.7-79-64 4-8.2 6-17.1 5-26.4-4-29.2-33-49.4-65-45.2-17 2.2-32 11-41 23.2-11-32-44-52.8-79-48.1-23 2.9-42 15.5-54 33-17-11.4-40-17-64-13.8-48 6.3-82 42.4-77 80.8 1 12.3 6 23.4 14 32.4l-71 48.5 66 94.7s95-73.4 176-69.4c91 4.4 136 45.8 132 121.7-4 66.1-72 65.6-85 32.9-14-32.6 16-49.2 16-49.2-41-40.5-82-7.9-88 19.2-14-3.4-28-0.8-39 8.7-20 16.7-22 48.4-5 70.8 4 4.2 7 7.9 11 10.8-11 18.3-10 44.3 5 63.7 18 23.7 49 28.9 70 11.6 0-0.4 1-0.9 1-1.3 2 4.7 5 9.2 8 13.4 18 23.7 50 28 72 9.6 8-7.2 14-17 16-27.5 2 1.4 3 2.9 4 4.3 25 24.3 64 22.5 87-3.9 16-17.9 21-42.5 14-64.2 4 0 7-0.1 10-0.5 37-4.9 64-33.1 60-63.1-2-13.6-9-25.2-20-33.3" fill="#ffd72e"/>\n<path d="m1650 765.4c23-15 37-42.6 33-72-3-25.9-19-46.7-40-57.2 6-12.2 8-25.9 7-40.2-5-39-39-66.7-79-64 4-8.2 6-17.1 5-26.4-4-29.2-33-49.4-65-45.2-17 2.2-32 11-41 23.2-11-32-44-52.8-79-48.1-23 2.9-42 15.5-54 33-17-11.4-40-17-64-13.8-48 6.3-82 42.4-77 80.8 1 12.3 6 23.4 14 32.4l-71 48.5 66 94.7s95-73.4 176-69.4c91 4.4 136 45.8 132 121.7-4 66.1-72 65.6-85 32.9-14-32.6 16-49.2 16-49.2-41-40.5-82-7.9-88 19.2-14-3.4-28-0.8-39 8.7-20 16.7-22 48.4-5 70.8 4 4.2 7 7.9 11 10.8-11 18.3-10 44.3 5 63.7 18 23.7 49 28.9 70 11.6 0-0.4 1-0.9 1-1.3 2 4.7 5 9.2 8 13.4 18 23.7 50 28 72 9.6 8-7.2 14-17 16-27.5 2 1.4 3 2.9 4 4.3 25 24.3 64 22.5 87-3.9 16-17.9 21-42.5 14-64.2 4 0 7-0.1 10-0.5 37-4.9 64-33.1 60-63.1-2-13.6-9-25.2-20-33.3zm-251 40.3c44 104.1 211 27.3 131-126.5-52-100.2-214-95.1-287-25.6" stroke="#000" stroke-width="14.06" fill="none"/>\n<g fill="#ffd72e">\n<path d="m1141 605.6c11 13.7 35 10.8 54-6.2 20-17 27-41.9 16-55.6s-36-10.9-55 6.2c-19 17-26 41.9-15 55.6"/>\n<path d="m1059 523.5c11 14.3 36 12.1 55-5 20-17 26-42.5 15-56.7-11-14.3-36-12.1-56 4.9-19 17.1-25 42.6-14 56.8"/>\n<path d="m1204 682.9c12 14.2 37 11.7 56-5.7 20-17.4 27-43 16-57.2-12-14.3-37-11.7-56 5.6-20 17.4-27 43.1-16 57.3"/>\n</g>\n<path d="m1141 605.6c11 13.7 35 10.8 54-6.2 20-17 27-41.9 16-55.6s-36-10.9-55 6.2c-19 17-26 41.9-15 55.6zm-82-82.1c11 14.3 36 12.1 55-5 20-17 26-42.5 15-56.7-11-14.3-36-12.1-56 4.9-19 17.1-25 42.6-14 56.8zm145 159.4c12 14.2 37 11.7 56-5.7 20-17.4 27-43 16-57.2-12-14.3-37-11.7-56 5.6-20 17.4-27 43.1-16 57.3z" stroke="#000" stroke-width="11.73" fill="none"/>\n<path d="m1008 498.9c25-52.7 14-108.2 14-108.2s83 39.3 46 151c-4-3.7-39-31.1-60-42.8" fill="#ffd72e"/>\n<path d="m1209 717.1c55-32.6 134-17.9 134-17.9s-59-89.1-159-22c4 3.4 17 18.8 25 39.9" fill="#ffd72e"/>\n<path d="m1008 498.9c25-52.7 14-108.2 14-108.2s83 39.3 46 151c-4-3.7-39-31.1-60-42.8z" stroke="#000" stroke-width="14.06" fill="none"/>\n<path d="m1209 717.1c55-32.6 134-17.9 134-17.9s-59-89.1-159-22c4 3.4 17 18.8 25 39.9z" stroke="#000" stroke-width="13.8" fill="none"/>\n<g>\n<path d="m868.3 698c-10.2 8.6-159.1 60.8-196.1 11.8-39.8-52.5 13.1-111.3 20.9-107.1 7.7 4.2 10.2 67.4 49.8 79.1 39.5 11.7 113.4 4.6 113.4 4.6l12 11.6z" fill="#050102"/>\n<path d="m1051 617.1c19 22.8 58 19.2 89-8s41-67.8 23-90.6-58-19.3-88 7.9c-31 27.3-42 67.9-24 90.7" fill="#ffd72e"/>\n<path d="m1128 673c15 19.1 50 14.4 78-10.3 29-24.8 39-60.2 24-79.3-15-19-50-14.4-78 10.4-28 24.7-39 60.2-24 79.2" fill="#ffd72e"/>\n</g>\n<path d="m1051 617.1c19 22.8 58 19.2 89-8s41-67.8 23-90.6-58-19.3-88 7.9c-31 27.3-42 67.9-24 90.7zm77 55.9c15 19.1 50 14.4 78-10.3 29-24.8 39-60.2 24-79.3-15-19-50-14.4-78 10.4-28 24.7-39 60.2-24 79.2z" stroke="#000" stroke-width="14.06" fill="none"/>\n<path d="m987.3 523.8c111.7 62.3 177.7 173.7 194.7 213.5 14-6.9 19-17.5 32-23.3-44-93.6-126-183-203-222.9-7 11.7-14.9 21.6-23.7 32.7" fill="#ffd72e"/>\n<path d="m987.3 523.8c111.7 62.3 177.7 173.7 194.7 213.5 14-6.9 19-17.5 32-23.3-44-93.6-126-183-203-222.9-7 11.7-14.9 21.6-23.7 32.7z" stroke="#000" stroke-width="14.06" fill="none"/>\n<path d="m1086 576.2c44 42.8 88 102.3 102 148-2 2.7 7-2 3-0.1 17 6.4 20 10.6 38 26.3 9 8.2 17 14.7 22 29.4 3 10.4 3 21 3 31.6 2 35.1-8 68.1-23 77.1-20 12.4-21-13.9-32-32.3-21-36.5-80-60.7-97-90.1-4-7.6-12-44.3-12-44.3s-52 36-83 39.7c-31.7 3.7-47.8-20.7-107-19.3-20.7 18.4-41.4 25.5-58.8 33-18.1 7.9-27.6-23.9-52.4-40.1 9.4-7.4 77.5 5.7 79.5-37.1-10.2 8.6-159.1 60.8-196.1 11.8-39.8-52.5 13.1-111.3 20.9-107.1 7.7 4.2 10.2 67.4 49.8 79.1 39.5 11.7 113.4 4.6 113.4 4.6s-2.5-1.5-4.4-3c-1.4 5.1-98.1-2.7-98.1-2.7s-13.1-25.7-3.9-40.5c3.8-4.7 4.2-4.7 4.2-4.7l9.6-19.8s5.7-7.9 13.9-4.5 25.8 2.8 25.8 2.8 79.7-65 106.1-54.1c2.4-21.2 36.7-73.4 87.2-48.9 3.1-1.9 0.1 2 2.5 3.1 6.8 0.2 47.8 24.4 86.8 62.1"/>\n<path d="m671.8 654.9c-0.9 4.2-1.3 8.3-1.4 12.2 0 12.2 3.9 23.7 11.8 34.2 28 37.3 141.8 4.2 179-9.2-34.2 10.6-98.7 7.3-123.7 1.3-29.1-6.3-46.7-47.5-50.2-70.2v-0.1c-5.7 7-12.6 18.2-15.5 31.8" fill="#e7423f"/>\n<g fill="#ffd72e">\n<path d="m999.8 598.2c-2-1.8-19.6-13.8-27.5-13-2.4-2.3-13.3-8.8-7.4-11.4 3.1-1.4 9-2.1 10.2-2.1 1.3 0 14.4 2.2 17.2 2.3 12.7 1.8 37.7 20.6 32.7 53.7-1 6.7-20-24.8-25.2-29.5"/>\n<path d="m804.4 633.3 7.7-2.3 6.6 3.5-0.1 3.5-3.3 6.9-5.5 5.7-8.8 5.7h-5.5l-3.2-2.3-2.2-4.7 3.3-5.7 11-10.3z"/>\n<circle cx="986" cy="605.4" r="18.8"/>\n</g>\n</svg>','images/kanton/wappen/svg/sh.svg','images/kanton/wappen/20px/Wappen_Neuenburg_matt.svg.png','images/kanton/wappen/50px/Wappen_Neuenburg_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Nidwalden_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Schaffhausen','Q12697','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(15,'AR',15,'Appenzell Ausserrhoden','Appenzell Rhodes-Extérieures','Appenzello Esterno',0,1,'de','Herisau, Trogen',NULL,NULL,243,1513,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="407.543px" height="494.059px" viewBox="-176.544 -214.721 407.543 494.059"\n	 enable-background="new -176.544 -214.721 407.543 494.059" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M27.088-213.19h202.395V84.275c0,106.875-90.568,193.532-202.25,193.532\n		c-111.703,0-202.242-86.657-202.242-193.532V-213.19H27.088z"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.544" y="-214.721" width="407.543" height="494.059"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M27.088-213.19h202.395V84.275\n						c0,106.875-90.568,193.532-202.25,193.532c-111.703,0-202.242-86.657-202.242-193.532V-213.19H27.088z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<path fill="#010202" d="M-170.048,30.888v1.281c0,0,12.563,1.785,17.738,10.715c5.16,8.906,48.254,115.719,47.648,119.25\n		c0.672,0.063,1.148-0.25,1.148-0.25l46.969-116.969c0,0,4.527-11.809,15.641-11.73c2.832-0.25,4.152-0.512,4.152-0.512v-1.281\n		l-42.832,0.266v1.262h4.625c0,0,12.664-0.031,8.055,14.816c-4.625,14.852-29.945,88.117-29.945,88.117s-33-82.883-34.293-93.211\n		c-1.297-10.344,11.742-10.234,11.742-10.234h2.977v-1.27L-170.048,30.888z"/>\n	<path fill="#010202" d="M166.139,153.9c0,0-10.484-1.781-11.766-8.18c-1.297-6.406-0.523-53.688-0.523-53.688\n		s1.125-1.102,1.813-0.773c0.695,0.344,2.445,2.672,2.445,2.672s24.813,58.172,53.125,58.625c2.563,0,3.656,0.414,5.938-0.094\n		c-28.734-28.547-34.594-51.125-37.469-55.5c-2.875-4.391,1.18-6.172,2.539-6.219c35.03-1.094,37.164-27.891,37.313-30.922\n		c0.789-14.891-11.953-22.328-20.166-25.063c-8.234-2.719-26.344-3.063-26.344-3.063l-24.805,1.016h-7.164l-17.867-2.344\n		c0,0-0.758,0.098-0.836,0.359c-0.063,0.266,0.164,0.543,0.25,0.754c0.891,1.934,11.438,3.543,12.328,6.605\n		c1.75,6.031-0.266,104.563-0.266,104.563s-1.984,10.219-14.836,11.25c0.141,0.156,0,1.266,0,1.266h46.289L166.139,153.9\n		L166.139,153.9z"/>\n	<path fill="#010202" d="M-46.302-113.92c20.277,6.961,52.734,19.641,58.414,23.297C9.577-88.112-2.056-75.752-6.638-48.799\n		c-10.352,4.688-13.434-0.422-13.434-0.422s-4.031,0.184-4.84,2.229c-7.762-4.816-6.23-11.336-11.512-7.375\n		c-1.238,0.934-7.055-9.52-9.129-4.707c-5.504-1.406-5.137-7.887-6.648-8.246c-1.488-0.344-4.566,2.262-5.453,0.512\n		c-1.496-2.992-3.176-6.504-3.73-7c-0.559-0.512-2.27,0.922-4.613,0.113c-2.355-0.801-3.809-6.832-5.867-7.699\n		c-4.133,1.602-6.445-5.223-6.719-6.148c-0.625,1.871-6.258,2.512-5.504-0.672c2.594-11.051-14.664-10.715-13.207-21.336\n		c-21.93-3.746-17.242-44.531-21.555-45.344c-7.926-1.531-13.367-0.992-13.367-0.992s0.703-6.25,11.695-7\n		c-5.758-4.043-13.422-5.09-13.422-5.09s3.137-4.895,16.91-2.281c-3.023-7.07-10.344-10.574-10.344-10.574s8.402-2.113,17.051,5.566\n		c-0.699-8.863-7.547-16.063-7.547-16.063s8.219-1.113,16.137,12.863c1.863-8.398-1.223-17.328-1.223-17.328\n		s8.863,1.266,11.445,18.77c7.504,10.445,2.457,26.008,10.305,43.984C-76.83-123.014-63.576-119.846-46.302-113.92"/>\n	<path fill="#010202" d="M-9.728,127.478c6.68-22.75,29.305-37.875,52.297-35.969c1.211-4.703,2.242-8.922,1.852-9.75\n		c-13.492-28.516-21.5-31.719-21.5-31.719s-29.727-6.344-47.633,2.016c-3.598,1.688-30.398,18.578-25.117,19.719\n		c8.672,1.922-3.465,7.547-5.379,12.203c-1.926,4.688,2.832,3.563,3.059,4.141c0.535,1.406-12.008,13.578-8.883,14.188\n		c11.625,2.297-5.238,13.844-1.621,14.703c10,2.375-2.25,12.438,1.301,12.969c1.273,0.188,3.715,0.797,5.68,1.078\n		c-1.109,1.984-4.055,7.703-3.445,13.609c0.297,2.719,3.512-2.5,5.152,1.078c-8.242,6.703,7.16,25.828,8.23,37.234\n		c-5.574,0.641-4.633-6.406-9.473-8.484c-2.621,4.719-7.918,4.703-14.254,3.141c-6.32-1.563-13.707-4.641-20.457-4.734\n		c-14.832-3.75-21.008,1.359-22.359,3.047c0.43,0.141,5.633,1.344,13.109,4.547c-12.613,0.898-14.832,8.555-14.832,8.555\n		s6.48-0.406,14.539,1.195c-13.074,6.594-11.266,13.891-11.266,13.891s7.242-4.266,14.695-4.828\n		c-4.023,2.984-7.359,9.547-4.887,14.297c2.953-2.797,8.672-5.422,10.734-6.266c-2.758,6.297-2.344,10.906,0.691,14.25\n		c8.168-11.164,11.102-10.469,13.469-10.281c1.297,0.094,4.816,1.203,9.977,1.766c4.313,0.438,9.785,0.281,16.023,0.656\n		c14.992,0.828,32.352,1.328,43.809-10.188C-9.728,177.9-16.158,149.369-9.728,127.478"/>\n	<path fill="#0A0406" d="M90.553-182.983c6.898-8.375,33.641-2.84,21.375,17.047C101.389-163.288,100.303-181.448,90.553-182.983"/>\n	<polygon fill="#FFFFFF" points="33.405,-118.401 33.405,-118.393 33.42,-118.393 	"/>\n	<path fill="#E8423F" d="M15.592,61.931c0,0,7.727-2.125,19.094,1.906c1.508,2.516,4.453,6.844,6.594,11.547\n		C36.897,70.759,15.592,61.931,15.592,61.931"/>\n	<path fill="#010202" d="M14.577-50.655C-37.841-40.823-79.326-6.721-99.998-36.487c5.887,1.16,10.773,11.719,18.672,7.922\n		c-9.672-8.395-16.074-27.578-26.992-33.723c-7.578-20.656-16.426-21.391-16.426-21.391s5.551,17.305,4.063,20.648\n		c-14.344-14.355-21.992-10.777-21.992-10.777l12.906,16.625c0,0-14.57-7.352-21.074-1.777c8.473,3.32,16.281,9.152,16.121,10.93\n		c-1.039,0.145-13.055-1.512-15.328,5.293c4.785,0.816,13.207,3.594,14.672,6.051c-4.895,2.078-13.918,4.934-12.438,12.801\n		c6.16-0.984,10.879-4.363,16.461-3.234c7.449-2.016,20.363,14.488,21.609,16.113c1.23,1.621,26.488,25.641,35.711,15.656\n		c0.625-0.688,9.219,5.984,10.555,4.129c4.461-6.129,3.656-3.953,6.824-1.021c1.621,1.512,5.719-0.512,7.629,2.313\n		c4.168-6.781,13.867,2.328,18.449-3.199c5.039,2.609,8.09,5.359,9.391-1.094c5.363,6.604,6.77,0.016,11.395,4.59\n		c-0.379-6.313,3.535-3.77,10.781-2.574c4.684,0.781,11,0.078,17.625-0.891C35.483,4.466,42.124-9.721,43.319-12.174\n		c2.195-4.594,4.711-4.266,3.93-1.578C43.155,0.689,34.288,12.76,10.019,11.607c-1.328-0.063-1.961,0.508-2.531,1.313\n		c-0.559,0.816-0.535,1.488-0.383,4.41c0.242,6,16.383,23.703,25.66,36.984c12.14,17.406,16.03,26.359,14.562,30.242\n		c-2.594,6.859-8.055,42.742-7.813,43.906c0.25,1.164,2.219,2.203,4.156,0.563c2.375,2.453-2.141,11.875,0.766,12.094\n		c2.195-1.375,4.906-2.563,4.906-2.563s-4.578,10.547,2.016,15.594c0.828-2.922,3.422-5.109,3.422-5.109s-1.281,10.219,5.063,13.094\n		c0.109-0.656,0.008-1.078,0.742-4.328c3.82,12.391,5.617,13.547,6.617,12.672c1-0.836-1.844-5.164,1.5-4.234\n		c1.156,10.805,4.523,10.656,4.523,10.656s0.406-0.438,2.016-2.945c3.82,9.164,25.328,18.945,21.57,41.016\n		c-0.781,0.453-2.523,0.406-3.047-1.297c-0.508-1.688-1.836-6.719-2.469-7.414c-0.609-0.688-2.406-2.898-16.578-4.391\n		c-14.172-1.484-21.219,4.953-21.219,4.953s-15.672-4.672-24.051,5.266c4.988-1.063,17.199,4.813,17.199,4.813\n		s-12.57,2.727-14.508,14.25c8.953-4.141,18.094-3.016,18.094-3.016s-11.109,7.641-8.844,18.422c7.805-7.375,16-9.281,16-9.281\n		s-7.523,11.398-1.281,18.938c3.031-3.969,8.609-12.258,12.805-11.672c1.734,11.297,8.867,15.266,9.836,14.477\n		c0.984-0.805-1.938-10.414,5.281-16.328c12.328-2.672,42.672-7.883,54.391-33.328c-1.328-7.883-26.188-44.773-25.656-71.344\n		c0.125-7.391,1.25-36.773,1.25-36.773s0.898-17.164-5.875-28.586c4.234,0.313,5.836,7.836,8.266,9.195\n		c2.422,1.391,4.328-2.078,4.328-2.078l-0.906-6.469l4.836,5.25c0,0,4.164-8.234,0.656-18.438\n		c-3.492-10.188-19.781-29.988-22.016-36.711c-1.57-4.688-4.508-22.293-5.656-29.543c-1.164-7.266-0.75-29.359-0.75-29.359\n		s3.422,0.504,5.656,2.297c1.805-1.953-0.891-8.547-0.086-9.504c0.758,1.262,3.859,1.391,5.656,3.094\n		c2.969-5.391,0.398-10.672,0.086-11.359c4.969,1.902,9.539,1.504,10.258-0.223c-1.898-1.73-4.5-12.031-4.391-13.305\n		c1.906-0.855,7.375,3.504,8.344,1.938c-2.984-4.188-1.375-10.609-6.031-17.777c1.734-1.242,3.531,1.016,5.656-2.016\n		c-9.141-12.953,2.094-25.992,1.109-35.625c-1.57-15.391-10.93-18-10.93-18s24.688-0.121,19.508-17.992\n		c-5.203-17.887-18.031-6.48-26.43-11.078c-8.391-4.602-8.195-16.824-21.148-17.488c-18.273-0.953-42.719,11.521-56.93,11.521\n		c-4.426-0.031-3.848,0.68-14.383-2.098c-2.762,13.383,2.695,14.793,1.117,17.922c-2.949,5.848-1.855,7.344-1.855,7.344l1.578,0.031\n		c-0.449,2.055-0.617,6.023,2.613,10.512c3.871-5.359,5.176-8.762,5.602-10.367l1.113,0.023c-0.188,2.457-0.082,6.984,2.527,10.344\n		c3.918-3.543,5.313-8.039,5.781-10.191l0.234,0.008c0,0,8.93-0.609,14.664,2.223c5.734,2.848,5.5,13.793,5.5,13.793\n		s-15.563-4.672-22.27-4.535c-9.465,0.191-24.16,3.777-33.078,1.895c-8.922-1.871-17.023-13.344-17.023-13.344\n		s-14.035,18.969,17.344,23.688c7,1.059,13.551,0.664,19.293-0.152c0,0,14.961-2.934,18.172-3.336\n		c3.203-0.398,16.234,1.289,16.234,1.289s-0.75,4.246-7.156,4.246c-2.141,0-27.633-0.43-27.633-0.43s-0.688,7.656,4.953,8.137\n		c1.809,0.145,8.48-0.465,17.117,0.688c18.156,2.426,38.766,8.91,53.781-5.801c12.969-12.703,2.805-31.52,14.445-39.559\n		c9.57-6.641,20.133-0.648,20.523,1.918c-14.328-5.223-17.313-0.613-18.969,0.496c-11.5,7.793,5.688,47.352-38.094,48.512\n		c-15.25,0.41-31.313,1.234-38.281,7.969c-3.949,3.816-7.898,3.617-13.637,8.762C1.928-77.088,0.295-59.983-1.326-51.358\n		c-0.641,3.391,1.086,2.313,1.086,2.313s8.25-2.656,14.273-3.379c1.063-0.125,1.176,0.504,1.176,0.504s0.023,0.746-1.031,1.266"/>\n	<path fill="#E8423F" d="M-148.025-59.311c4.762,2.207,10.457,5.617,13.016,8.52c0.777-1.984,2.625-4.785,3.297-5.742\n		C-134.119-57.6-142.455-60.944-148.025-59.311"/>\n	<path fill="#E8423F" d="M-147.662-43.686c3.438,0.801,9.133,2.543,12.156,4.766c-0.078-0.766-0.168-1.543-0.191-2.309\n		c-0.078-1.836,0.035-3.594,0.273-5.313C-137.103-46.616-145.287-46.768-147.662-43.686"/>\n	<path fill="#E8423F" d="M-140.216-72.944c0.738,0.93,10.922,14.059,11.297,14.527c1.688-1.277,5.535-3.328,6.77-3.969\n		C-131.017-71.143-137.072-72.831-140.216-72.944"/>\n	<path fill="#E8423F" d="M-146.63-25.502c1.344-0.375,2.734-0.801,4.359-1.41c2.902-1.047,5.879-2.125,9.184-2.016\n		c-0.945-1.965-1.719-4.078-2.273-6.293C-137.216-34.487-146.56-30.565-146.63-25.502"/>\n	<path fill="#E8423F" d="M-119.119-66.182c0.07,0.992,0,1.727-0.16,2.32c1.504-0.145,6.254-0.594,9.07-0.219\n		c-5.023-11.949-10.07-16.52-13.016-18.285C-121.712-77.901-119.439-70.577-119.119-66.182"/>\n	<path fill="#E8423F" d="M33.663,210.626c5.742,1.016,12.914,4.406,13.758,4.781c0,0,0.719,0.367,1.172,0.578\n		c0-0.164-0.031-0.328-0.031-0.508c0-3.109,0.992-5.625,2.875-7.508C47.045,207.166,39.374,206.689,33.663,210.626"/>\n	<path fill="#E8423F" d="M51.202,229.447L51.202,229.447c-0.078,0.063-8.016,5.734-8.375,13.719\n		c6.266-5.078,12.188-6.984,13.695-7.391c-0.93-0.953-1.805-2.078-2.578-3.391c0.023,0.031,0.023,0.016-1.211-2.266\n		c0,0-0.5-0.906-0.672-1.266C51.897,228.986,51.663,229.15,51.202,229.447"/>\n	<path fill="#E8423F" d="M47.03,218.494L47.03,218.494c-0.117,0.031-9.164,2.172-12.266,10.031\n		c8.094-2.852,15.359-2.094,15.672-2.047c0,0,0.375,0.047,0.688,0.078c-1.328-2.883-2.164-5.719-2.477-8.438\n		C48.389,218.197,47.936,218.314,47.03,218.494"/>\n	<path fill="#E8423F" d="M70.569,244.197c0.008,0.031,0.023,0.078,0.023,0.078c1.109,7.204,4.5,11.148,6.633,12.563\n		c0-0.578-0.031-1.625-0.031-1.625c0-3,0.422-7.359,3.344-11.18C77.749,244.97,74.272,245.041,70.569,244.197"/>\n	<path fill="#E8423F" d="M58.78,238.119c-0.031,0.063-3.492,5.359-3.492,10.813c0,1.609,0.344,3.07,0.977,4.367\n		c2.813-3.875,6.875-9.25,10.961-10.18C64.139,242.001,61.241,240.298,58.78,238.119"/>\n	<path fill="#E8423F" d="M-93.017-178.616l0.02-0.016c-1.922-9.367-5.555-13.504-8.121-15.27c0.504,1.836,1.008,4.27,1.246,7\n		c0.219,2.543,0.184,5.316-0.336,8.078l-0.16,0.824C-97.736-178.831-95.224-179.057-93.017-178.616"/>\n	<path fill="#E8423F" d="M-103.353-178.624c-4.293-7.199-8.535-10.105-11.469-11.297c2.27,3.145,5.133,8.082,5.664,13.793\n		l0.148,1.535c2.105-1.238,4.234-2.191,6.348-2.848L-103.353-178.624z"/>\n	<path fill="#E8423F" d="M-118.095-169.12c-6.672-1.031-10.664-0.445-12.969,0.391c3,0.699,7.121,1.969,10.746,4.297l0.574,0.375\n		c0.84-1.559,1.945-3.102,3.289-4.598L-118.095-169.12z"/>\n	<path fill="#E8423F" d="M-120.638-161.456c-5.855,0.609-8.402,2.625-9.52,4.176c1.703-0.063,5.246,0,8.848,0.281\n		c-0.043-1.41,0.238-2.914,0.781-4.457H-120.638z"/>\n	<path fill="#E8423F" d="M-110.599-173.471l-1.383-1.168c-4.273-3.609-8.402-4.855-11.418-5.223\n		c5.23,3.496,7.855,9.297,8.191,10.055c0.496-0.543,2.563-2.258,4.023-3.289C-110.974-173.229-110.806-173.342-110.599-173.471"/>\n	<path fill="#E8423F" d="M-92.849,198.986l-2.16,1.602c-2.832,2.117-5.109,5.984-5.109,9.398c0,0.258,0.078,0.539,0.109,0.836\n		c3.504-2.516,8.113-4.508,9.168-4.938l2.875-1.203C-89.873,203.017-91.552,201.072-92.849,198.986"/>\n	<path fill="#E8423F" d="M-95.857,190.259l-2.824,1.445c-7.223,3.625-9.504,7.313-10.176,9.656\n		c2.875-1.359,7.699-3.258,12.699-3.656l2.52-0.211c-0.113-0.188-0.242-0.414-0.336-0.609\n		C-94.912,194.744-95.529,192.494-95.857,190.259"/>\n	<path fill="#E8423F" d="M-95.728,181.853l-3.313,0.25c-7.168,0.516-10.566,3.297-12.145,5.297c2.723,0.031,7.027,0.266,12.066,1.25\n		l3.145,0.641C-96.248,186.728-96.134,184.181-95.728,181.853"/>\n	<path fill="#E8423F" d="M-88.63,208.001c-1.16,2.586-1.715,4.867-1.715,6.867c0,1.477,0.336,2.773,0.938,3.922\n		c4.617-5.969,7.625-8.188,10.082-8.875c-2.762-1.078-5.578-2.703-8.074-4.766L-88.63,208.001z"/>\n	<path fill="#E8423F" d="M-108.759,175.259c2.367,0.711,5.91,1.891,10.254,3.758l3.105,1.313c0.633-2.508,1.625-4.688,2.93-6.328\n		C-101.185,172.228-106.224,173.791-108.759,175.259"/>\n	<path fill="#E8423F" d="M109.139-143.221c0,0-1.688,0.184-1.57,1.229c0.094,1.055,1.344,1.223,1.344,1.223s6.836,1.875,8.539-5.688\n		C116.319-142.823,109.139-143.221,109.139-143.221"/>\n	<path fill="#E8423F" d="M109.975-148.737c-0.555-0.117-2.375,0.852-2.328,1.898c0.039,0.582,0.672,0.617,1.266,0.703\n		c2.773,0.406,8.953-4.496,6.18-5.406C113.959-151.92,113.749-148.487,109.975-148.737"/>\n	<path fill="#E8423F" d="M78.256-172.928c-0.672-0.695-22.289,7.199-22.75,11.082c-0.039,0.313,0.438,1.305,1.523,1.07\n		c0.813-0.184,11.523-1.297,19.75-0.832c3.203,0.168,6.016,0.848,7.703,1.52c2.219,0.867,5.313,0.531,5.43-0.438\n		c0.117-0.969-7.836-3.25-11.313-3.539c-6.328-0.551-18.938,1.074-18.938,1.074S79.272-171.913,78.256-172.928"/>\n	<path fill="#FFFFFF" d="M-92.208-126.565c3.672-16.449-7.406-32.043-7.559-44.754c-3.168,9.633,2.297,19.934,4.457,30.16\n		c2.336,11.191,1.957,20.406-5.027,20.336c-1.293,0.031-1.156,1.449-0.422,1.43C-94.623-119.655-93.255-122.647-92.208-126.565"/>\n	<path fill="#FFFFFF" d="M76.241-159.073c0.836,0.586,1.344,1.508,1.344,2.555c0,1.734-1.461,3.145-3.242,3.145\n		c-1.797,0-3.266-1.41-3.266-3.145c0-1.145,0.641-2.145,1.586-2.68c-2.961,0.605-5.586,2.633-5.586,3.727\n		c0,1.289,3.625,3.984,7.156,4.113c3.375,0.102,6.672-2.922,6.672-3.93C80.897-156.096,78.78-158.256,76.241-159.073"/>\n	<path fill="#010202" d="M17.631-128.295c-0.68,1.25-1.504,3.207-1.504,5.402c0,2.398,0.938,4.469,2.703,5.992l0.395,0.309h7.383\n		l-1.527-2.039c-0.969-1.297-1.633-2.91-2.352-4.727c-0.84-2.16-1.648-4.043-2.977-5.266l-1.289-1.176L17.631-128.295z"/>\n	<path fill="#010202" d="M27.12-128.655c-0.688,1.391-1.496,3.711-1.496,6.848c0,1.199,0.137,2.504,0.434,3.895l0.223,1.09\n		l3.785-0.168c-0.016,0,3.387-0.098,3.387-0.098l2.398-0.07l-1.336-1.938c-0.75-1.117-1.422-2.641-2.125-4.223\n		c-0.891-2.047-1.797-4.023-2.98-5.559l-1.328-1.715L27.12-128.655z"/>\n	<path fill="#FFFFFF" d="M15.081-145.495c0,1.383,0.305,3.16,1.289,5.137c2.125-3.242,3.262-5.809,3.734-7.176\n		c-1.742-0.121-3.48,0.031-4.785-0.059C15.186-147.081,15.081-146.366,15.081-145.495"/>\n	<path fill="#FFFFFF" d="M24.608-146.135c0,1.762,0.25,4.063,1.223,6.121c2.25-2.648,3.305-5.785,3.738-7.527\n		c-1.641,0-3.391-0.016-4.906-0.137C24.639-147.229,24.608-146.729,24.608-146.135"/>\n	<path fill="#FFFFFF" d="M21.463-122.901c-0.758-1.938-1.504-3.738-2.648-4.785c-0.742,1.352-1.352,3.023-1.352,4.793\n		c0,0.254,0.023,0.508,0.043,0.773c1.102,0.016,2.582,0.039,4.301,0.063C21.698-122.327,21.577-122.616,21.463-122.901"/>\n	<path fill="#FFFFFF" d="M31.155-122.823c-0.828-1.906-1.715-3.832-2.828-5.281c-0.535,1.082-1.336,3.184-1.367,6.137\n		c1.512,0.031,3.09,0.055,4.609,0.082C31.436-122.206,31.311-122.502,31.155-122.823"/>\n	<path fill="#FFFFFF" d="M197.913,60.228c0,0,1.734,4.531-1.758,14.016c-3.484,9.461-19.766,12.25-19.766,12.25\n		s-16.438,2.164-21.523,1c-2.656-5.523-0.492-47.297-0.492-47.297s5.031-3.078,17.266-3.484\n		C194.389,35.935,197.913,60.228,197.913,60.228"/>\n	<path fill="#E8423F" d="M-21.783-137.721c0,1.289,0.277,2.508,0.801,3.602c2.094,4.258,8.133,7.105,17.973,8.473\n		c5.77,0.801,11.875,0.746,18.699-0.145c0.094-0.023,14.855-2.703,18.184-3.078c2.859-0.328,11.797,0.621,15.5,1.047\n		c0,0,1.172,0.137,1.609,0.191c0.141-0.664,0.438-1.84,0.57-2.465c-0.445-0.117-1.711-0.406-1.711-0.406\n		c-3.406-0.906-15.078-3.863-20.371-3.77c-3.352,0.059-7.43,0.527-11.758,1.043c-7.777,0.895-15.816,1.836-21.793,0.68\n		c-7.031-1.371-13.328-7.473-16.289-10.738C-21.064-141.799-21.783-139.823-21.783-137.721"/>\n</g>\n</svg>','images/kanton/wappen/svg/ar.svg','images/kanton/wappen/20px/Wappen_Nidwalden_matt.svg.png','images/kanton/wappen/50px/Wappen_Nidwalden_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Obwalden_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Appenzell_Ausserrhoden','Q12079','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(16,'AI',16,'Appenzell Innerrhoden','Appenzell Rhodes-Intérieures','Appenzello Interno',0,1,'de','Appenzell',NULL,NULL,173,1513,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="407.152px" height="493.613px" viewBox="-176.681 -214.424 407.152 493.613"\n	 enable-background="new -176.681 -214.424 407.152 493.613" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M26.78-212.905h202.184v297.18c0,106.805-90.469,193.375-202.055,193.375\n		c-111.59,0-202.07-86.57-202.07-193.375v-297.18H26.78z"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.681" y="-214.424" width="407.152" height="493.613"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M26.78-212.905h202.184v297.18\n						c0,106.805-90.469,193.375-202.055,193.375c-111.59,0-202.07-86.57-202.07-193.375v-297.18H26.78z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<path fill="#010202" d="M-39.787-112.249c21.641,8.055,45.262,17.223,50.535,21.504c1.504,1.223-14.84,14.832-15.574,41.688\n		c-11.371,4.656-14.555-0.41-14.555-0.41s-3.125,0.473-4.063,2.504c-8.273-4.766-6.391-11.215-12.25-7.293\n		c-1.375,0.918-6.941-9.707-9.328-4.969c-5.949-1.359-5.344-7.785-6.973-8.145c-1.602-0.336-5.016,2.246-5.945,0.504\n		c-1.504-2.938-3.238-6.41-3.816-6.922c-0.609-0.496-1.375,1.625-3.871,0.84c-2.551-0.813-3.93-6.773-6.129-7.621\n		c-4.535,1.598-6.84-5.145-7.113-6.059c-0.742,1.852-6.863,2.488-5.965-0.648c3.152-10.926-13.355-13.344-11.465-23.848\n		c-23.656-3.695-17.48-41.902-22.121-42.711c-8.559-1.504-14.48-0.969-14.48-0.969s0.961-6.168,12.914-6.934\n		c-6.121-3.984-14.402-5.023-14.402-5.023s3.57-4.824,18.418-2.25c-3.066-7-10.891-10.449-10.891-10.449s9.152-2.094,18.297,5.504\n		c-0.457-8.758-7.656-15.887-7.656-15.887s8.945-1.09,17.09,12.719c2.277-8.301-0.777-17.125-0.777-17.125s9.578,1.238,11.84,18.527\n		c7.816,10.352,1.848,25.719,9.832,43.496C-73.794-122.338-57.892-118.987-39.787-112.249"/>\n	<path fill="#010202" d="M-9.994,128.541c6.68-22.75,29.383-36.891,52.402-35c1.219-4.688,2.266-9.891,1.844-10.719\n		C30.749,54.306,22.717,52.431,22.717,52.431s-29.762-6.672-47.746,1.672c-3.598,1.688-30.469,17.594-25.176,18.766\n		c8.691,1.906-3.461,7.516-5.398,12.188c-1.91,4.672,2.855,3.547,3.07,4.109c0.531,1.422-12.023,13.578-8.902,14.219\n		c11.648,2.25-5.238,13.828-1.633,14.688c10.031,2.359-2.262,12.438,1.32,12.953c1.266,0.164,3.719,0.797,5.703,1.078\n		c-1.117,1.984-4.094,7.688-3.445,13.594c0.277,2.734,3.496-2.492,5.133,1.109c-8.254,6.688,7.18,25.813,8.266,37.203\n		c-5.59,0.625-4.656-6.422-9.504-8.508c-2.617,4.758-7.938,4.703-14.289,3.164c-6.32-1.547-13.727-4.625-20.488-4.719\n		c-14.91-3.758-21.102,1.328-22.461,3.031c0.445,0.141,5.68,1.328,13.168,4.539c-12.648,0.922-14.898,8.523-14.898,8.523\n		s6.512-0.375,14.609,1.203c-13.121,6.609-11.313,13.922-11.313,13.922s7.266-4.266,14.754-4.844c-4.051,3-7.402,9.578-4.922,14.281\n		c2.977-2.766,8.719-5.391,10.785-6.25c-2.785,6.297-2.359,10.891,0.711,14.25c8.16-11.156,11.105-10.469,13.48-10.297\n		c1.297,0.117,4.824,1.234,10.016,1.773c4.32,0.453,9.793,0.289,16.055,0.648c15.016,0.859,32.457,1.352,43.938-10.156\n		C-10.001,178.947-16.443,150.423-9.994,128.541"/>\n	<path fill="#010202" d="M15.397-121.018c0,0-0.695,7.664,4.945,8.16c1.816,0.145,8.504-0.48,17.16,0.688\n		c18.203,2.418,38.859,8.902,53.938-5.801c13-12.711,2.797-31.521,14.484-39.543c9.594-6.641,20.156-0.656,20.578,1.91\n		c-14.344-5.23-17.359-0.598-19.016,0.508c-11.563,7.773,5.703,47.32-38.219,48.492c-15.297,0.41-31.398,1.234-38.375,7.984\n		c-3.961,3.801-7.922,3.586-13.625,8.738C1.702-75.948,1.147-58.354-0.466-49.729c-0.641,3.391,1.121,2.313,1.121,2.313\n		s9.832-2.488,15.863-3.203c1.078-0.141,1.207,0.488,1.207,0.488s0.328,1.184-1.039,1.281\n		c-20.082,1.184-73.305,24.457-97.199,24.703c-1.508-0.328-15.426-3.473-17.152-10.934c1.934-2.344,10.84,11.375,19.184,7.184\n		c-9.824-8.066-15.863-27.199-27.051-32.953c-7.184-20.582-16.398-20.938-16.398-20.938s5.273,17.266,3.594,20.73\n		c-14.496-13.898-22.547-9.953-22.547-9.953l12.922,16.266c0,0-14.906-6.785-21.891-0.859c8.707,3,16.656,8.547,16.449,10.363\n		c-1.086,0.184-13.52-0.953-16.129,6.063c4.938,0.594,13.641,3.031,15.059,5.457c-5.16,2.313-14.617,5.625-13.344,13.512\n		c6.445-1.266,11.473-4.871,17.238-4.016c7.824-2.379,14.512,5.871,23.426,14.719c10.48,10.41,25.824,20.281,33.063,17.375\n		c1.746-0.703,0.727-2.309,2.008-2.527c1.313-0.199,10.168,7.441,10.832,5.266c2.207-7.25,2.52-3.313,6.504-1.563\n		c2.023,0.875,5.234,0.203,7.961,2.266c1.75-7.785,12.984,3.922,15.535-2.801c5.625,0.832,11.609,4.656,10.727-1.871\n		c7.258,4.512,7.914,2.184,11.578,3.887C-8.601,3.87-1.211,9.249,1.543,9.198c28.944-0.575,36.077-8.919,41.6-20.247\n		c2.234-4.578,4.703-4.266,3.969-1.594c-4.109,14.441-14.5,24.891-38.785,23.754c-1.348-0.066-1.977,0.473-2.531,1.297\n		c-0.551,0.824-0.527,1.488-0.383,4.406c0.23,6,17.137,25.313,26.426,38.594c12.18,17.375,16.836,26.344,15.344,30.211\n		c-2.602,6.859-7.742,43.375-7.492,44.531c0.266,1.156,2.227,2.188,4.195,0.578c2.359,2.453-2.18,11.859,0.75,12.094\n		c2.188-1.391,4.922-2.594,4.922-2.594s-4.586,10.563,2,15.609c0.867-2.953,3.461-5.109,3.461-5.109s-1.297,10.234,5.094,13.094\n		c0.094-0.641,0.016-1.063,0.734-4.313c3.828,12.375,5.641,13.516,6.625,12.641c1.031-0.828-1.844-5.172,1.508-4.219\n		c1.148,10.797,4.531,10.656,4.531,10.656s0.422-0.453,2.031-2.969c3.82,9.172,25.047,18.328,21.211,40.344\n		c-0.75,0.492-2.5,0.422-3.016-1.281c-0.523-1.703-1.852-6.719-2.469-7.406c-0.609-0.688-2.438-2.891-16.625-4.406\n		c-14.219-1.469-21.25,4.984-21.25,4.984s-15.719-4.688-24.125,5.234c4.969-1.047,17.227,4.828,17.227,4.828\n		s-12.617,2.719-14.539,14.25c8.969-4.156,18.125-3.016,18.125-3.016s-11.133,7.625-8.883,18.406\n		c7.836-7.357,16.07-9.281,16.07-9.281s-7.563,11.359-1.297,18.922c3.063-3.97,8.625-12.281,12.844-11.641\n		c1.703,11.25,8.859,15.234,9.859,14.438c0.961-0.781-1.938-10.392,5.273-16.328c12.383-2.656,42.789-7.867,54.547-33.313\n		c-1.383-7.852-26.266-44.734-25.742-71.273c0.148-7.43,1.281-36.773,1.281-36.773s0.906-15.523-5.906-26.969\n		c4.219,0.313,5.859,7.844,8.266,9.203c2.445,1.375,4.359-2.078,4.359-2.078l-0.898-6.469l4.836,5.234c0,0,4.164-8.234,0.672-18.414\n		c-3.5-10.18-19.836-29.328-22.094-36.047c-1.547-4.672-4.516-24.543-5.656-31.801c-1.172-7.25-0.766-30.656-0.766-30.656\n		s3.438,0.512,5.672,2.297c1.828-1.938-0.875-8.512-0.063-9.488c0.766,1.277,3.852,1.391,5.688,3.113\n		c2.953-5.41,0.344-10.691,0.063-11.379c4.969,1.922,9.547,1.512,10.281-0.215c-1.891-1.734-4.508-12.016-4.375-13.313\n		c1.922-0.84,7.375,3.512,8.328,1.938c-2.969-4.168-1.359-10.617-6.047-17.77c1.734-1.23,3.57,1.023,5.672-2.008\n		c-9.164-12.938,2.094-24.672,1.141-34.32c-1.578-15.367-10.984-17.969-10.984-17.969s24.766-0.109,19.578-17.992\n		c-5.234-17.855-18.094-6.48-26.516-11.078c-8.422-4.609-8.219-16.824-21.188-17.488c-18.359-0.953-42.852,11.504-57.098,11.504\n		c-4.426-0.031-3.852,0.695-14.402-2.082c-2.766,13.387,2.73,14.793,1.137,17.922c-2.961,5.848-1.848,7.328-1.848,7.328l1.566,0.031\n		c-0.43,2.066-0.613,6.023,2.633,10.52c3.895-5.375,5.184-8.773,5.617-10.375l1.078,0.031c-0.176,2.457-0.078,6.969,2.539,10.344\n		c3.949-3.551,5.324-8.063,5.805-10.199h0.227c0,0,8.98-0.594,14.699,2.242c5.75,2.828,5.508,12.813,5.508,12.813\n		s-15.586-4.672-22.289-4.527c-9.504,0.176-24.23,3.77-33.168,1.898c-8.961-1.883-17.063-13.355-17.063-13.355\n		s-14.066,19.922,17.383,24.656c7.016,1.051,13.625,0.656,19.344-0.164c0,0,14.984-2.938,18.199-3.336\n		c3.18-0.395,16.273,1.293,16.273,1.293s-0.734,4.242-7.172,4.242C40.924-120.569,15.397-121.018,15.397-121.018"/>\n	<path fill="#010202" d="M90.557-181.811c6.898-8.359,33.734-2.84,21.406,17.043C101.377-162.104,100.331-180.256,90.557-181.811"/>\n	<path fill="#E8423F" d="M-22.083-137.62c0,1.41,0.266,2.715,0.824,3.891c2.07,4.625,8.121,7.711,17.984,9.184\n		c5.816,0.871,11.918,0.824,18.75-0.16c0.105-0.023,14.914-2.922,18.246-3.336c2.852-0.352,11.813,0.68,15.508,1.137\n		c0,0,1.18,0.152,1.609,0.207c0.18-0.703,0.469-1.992,0.602-2.672c-0.422-0.145-1.734-0.449-1.734-0.449\n		c-3.414-0.977-15.109-4.191-20.406-4.07c-3.367,0.07-7.445,0.574-11.773,1.113c-7.793,0.973-15.84,2-21.848,0.742\n		c-7.016-1.479-13.371-8.098-16.336-11.617C-21.365-142.026-22.083-139.889-22.083-137.62"/>\n	<path fill="#E8423F" d="M15.397,63.025c0,0,7.719-2.125,19.113,1.875c1.508,2.531,4.477,6.859,6.602,11.547\n		C36.721,71.822,15.397,63.025,15.397,63.025"/>\n	<path fill="#E8423F" d="M-145.9-55.788c4.754,2.02,10.418,5.203,12.871,7.984c0.859-1.984,2.867-4.816,3.609-5.781\n		C-131.818-54.545-140.146-57.577-145.9-55.788"/>\n	<path fill="#E8423F" d="M-146.787-40.393c3.457,0.672,9.168,2.199,12.168,4.297c-0.063-0.771-0.121-1.531-0.121-2.281\n		c0-1.816,0.191-3.563,0.504-5.266C-135.931-43.643-144.251-43.506-146.787-40.393"/>\n	<path fill="#E8423F" d="M-137.869-69.866c0.699,0.879,10.641,13.406,11.008,13.863c1.754-1.344,5.715-3.527,6.992-4.23\n		C-128.587-68.491-134.708-69.913-137.869-69.866"/>\n	<path fill="#E8423F" d="M-146.169-22.346c1.414-0.391,2.84-0.832,4.551-1.457c2.992-1.094,6.094-2.215,9.457-2.16\n		c-0.832-1.918-1.504-4-1.961-6.184C-136.044-31.393-145.771-27.331-146.169-22.346"/>\n	<path fill="#E8423F" d="M-116.365-63.202c0,0.984-0.133,1.703-0.293,2.297c1.504-0.168,6.359-0.641,9.176-0.328\n		c-4.234-11.715-9.059-16.176-11.93-17.871C-118.189-74.729-116.365-67.53-116.365-63.202"/>\n	<path fill="#E8423F" d="M33.487,211.65c5.742,0.984,12.969,4.391,13.789,4.789c0,0,0.727,0.359,1.18,0.539\n		c-0.031-0.156-0.031-0.313-0.031-0.469c0-3.125,1.016-5.641,2.891-7.547C46.885,208.197,39.198,207.697,33.487,211.65"/>\n	<path fill="#E8423F" d="M51.081,230.478L51.081,230.478c-0.078,0.047-8.047,5.703-8.391,13.688\n		c6.273-5.078,12.227-6.984,13.688-7.375c-0.922-0.953-1.75-2.078-2.555-3.391c0.016,0.016,0,0.016-1.203-2.266\n		c0,0-0.508-0.906-0.688-1.25C51.768,229.978,51.51,230.166,51.081,230.478"/>\n	<path fill="#E8423F" d="M46.854,219.509L46.854,219.509c-0.086,0.016-9.164,2.188-12.297,10.031\n		c8.148-2.875,15.445-2.094,15.727-2.031c0,0,0.406,0.031,0.719,0.078c-1.359-2.906-2.18-5.734-2.5-8.438\n		C48.26,219.212,47.768,219.306,46.854,219.509"/>\n	<path fill="#E8423F" d="M70.471,245.197c0.023,0.031,0.023,0.078,0.023,0.078c1.109,7.219,4.539,11.148,6.672,12.547\n		c0-0.563,0-1.625,0-1.625c0-2.984,0.391-7.328,3.305-11.172C77.69,245.962,74.198,246.041,70.471,245.197"/>\n	<path fill="#E8423F" d="M58.659,239.142c-0.039,0.063-3.492,5.359-3.492,10.805c0,1.625,0.359,3.063,0.961,4.359\n		c2.859-3.859,6.922-9.25,11.039-10.205C64.065,242.994,61.112,241.291,58.659,239.142"/>\n	<path fill="#E8423F" d="M-89.955-176.354c0,0,0.016-0.008,0.016-0.023c-1.391-9.105-4.902-13.184-7.418-14.992\n		c0.395,1.816,0.77,4.176,0.816,6.824c0.059,2.465-0.168,5.137-0.895,7.793l-0.215,0.797\n		C-94.884-176.706-92.236-176.85-89.955-176.354"/>\n	<path fill="#E8423F" d="M-100.673-176.385c-4.121-7.023-8.426-9.871-11.402-11.063c2.199,3.07,4.961,7.887,5.258,13.406l0.07,1.48\n		c2.266-1.168,4.535-2.051,6.762-2.648L-100.673-176.385z"/>\n	<path fill="#E8423F" d="M-116.306-167.467c-6.863-1.199-11.051-0.711-13.52,0.02c3.063,0.758,7.262,2.109,10.895,4.438l0.574,0.375\n		c0.977-1.453,2.234-2.934,3.691-4.344L-116.306-167.467z"/>\n	<path fill="#E8423F" d="M-119.869-160.163c-6.109,0.395-8.887,2.242-10.199,3.703c1.785,0,5.465,0.184,9.176,0.57\n		c0.082-1.359,0.457-2.816,1.16-4.289L-119.869-160.163z"/>\n	<path fill="#E8423F" d="M-108.337-171.659l-1.379-1.16c-4.293-3.551-8.535-4.809-11.656-5.207c5.289,3.473,7.754,9.113,8.066,9.84\n		c0.52-0.527,2.734-2.168,4.352-3.137C-108.763-171.432-108.564-171.538-108.337-171.659"/>\n	<path fill="#E8423F" d="M-93.345,199.994l-2.168,1.609c-2.844,2.125-5.113,5.969-5.113,9.375c0,0.297,0.07,0.547,0.094,0.844\n		c3.531-2.5,8.152-4.5,9.195-4.938l2.871-1.188C-90.345,204.025-92.044,202.111-93.345,199.994"/>\n	<path fill="#E8423F" d="M-96.357,191.291l-2.848,1.406c-7.199,3.656-9.512,7.344-10.207,9.711\n		c2.922-1.398,7.754-3.297,12.762-3.695l2.52-0.18c-0.105-0.211-0.242-0.422-0.336-0.656\n		C-95.412,195.767-96.037,193.509-96.357,191.291"/>\n	<path fill="#E8423F" d="M-96.244,182.9l-3.32,0.234c-7.191,0.516-10.598,3.297-12.16,5.297c2.723,0.047,7.059,0.281,12.09,1.266\n		l3.16,0.609C-96.771,187.767-96.65,185.212-96.244,182.9"/>\n	<path fill="#E8423F" d="M-89.138,209.009c-1.129,2.594-1.723,4.875-1.723,6.859c0,1.484,0.371,2.766,0.977,3.938\n		c4.617-5.969,7.648-8.203,10.113-8.875c-2.801-1.063-5.602-2.703-8.09-4.766L-89.138,209.009z"/>\n	<path fill="#E8423F" d="M-109.306,176.291c2.375,0.703,5.926,1.875,10.305,3.75l3.094,1.328c0.648-2.5,1.641-4.703,2.953-6.313\n		C-101.681,173.244-106.763,174.837-109.306,176.291"/>\n	<path fill="#E8423F" d="M109.182-142.034c0,0-1.688,0.168-1.594,1.215c0.102,1.066,1.359,1.234,1.359,1.234\n		s6.836,1.848,8.563-5.691C116.362-141.674,109.182-142.034,109.182-142.034"/>\n	<path fill="#E8423F" d="M110.018-147.561c-0.578-0.121-2.359,0.84-2.328,1.902c0.031,0.57,0.656,0.602,1.258,0.695\n		c2.773,0.395,8.953-4.504,6.195-5.406C114.018-150.745,113.768-147.338,110.018-147.561"/>\n	<path fill="#E8423F" d="M78.213-171.737c-0.703-0.695-22.359,7.191-22.82,11.063c-0.031,0.313,0.43,1.32,1.531,1.082\n		c0.813-0.168,11.563-1.281,19.813-0.84c3.172,0.176,6.031,0.879,7.703,1.535c2.234,0.848,5.344,0.52,5.477-0.441\n		c0.102-0.984-7.867-3.254-11.375-3.535c-6.359-0.535-18.984,1.063-18.984,1.063S79.198-170.729,78.213-171.737"/>\n	<path fill="#FFFFFF" d="M14.901-144.338c0,1.398,0.273,3.16,1.266,5.145c2.117-3.246,3.262-5.816,3.742-7.184\n		c-1.77-0.113-3.496,0.031-4.785-0.055C15.006-145.905,14.901-145.194,14.901-144.338"/>\n	<path fill="#FFFFFF" d="M24.42-144.971c0,1.777,0.25,4.074,1.234,6.121c2.23-2.641,3.285-5.77,3.734-7.527\n		c-1.664,0-3.391-0.008-4.914-0.129C24.444-146.057,24.42-145.553,24.42-144.971"/>\n	<path fill="#FFFFFF" d="M-90.357-125.827c4.473-16.246-7.07-31.656-6.863-44.223c-3.734,9.52,1.922,19.695,3.914,29.816\n		c2.191,11.063,1.512,20.168-6.066,20.102c-1.422,0.035-1.301,1.426-0.488,1.41C-93.22-119.01-91.65-121.956-90.357-125.827"/>\n	<path fill="#FFFFFF" d="M76.198-157.889c0.805,0.574,1.328,1.504,1.328,2.535c0,1.762-1.461,3.16-3.25,3.16\n		c-1.82,0-3.273-1.398-3.273-3.16c0-1.152,0.617-2.129,1.586-2.688c-2.953,0.633-5.586,2.641-5.586,3.734\n		c0,1.289,3.617,4,7.156,4.121c3.375,0.121,6.703-2.918,6.703-3.926C80.854-154.92,78.737-157.081,76.198-157.889"/>\n	<path fill="#010202" d="M17.428-127.124c-0.672,1.242-1.504,3.191-1.504,5.402c0,2.398,0.93,4.453,2.711,5.969l0.402,0.328h7.383\n		l-1.52-2.059c-0.969-1.277-1.617-2.895-2.352-4.711c-0.832-2.168-1.656-4.031-2.984-5.266l-1.305-1.168L17.428-127.124z"/>\n	<path fill="#010202" d="M26.924-127.506c-0.68,1.402-1.512,3.711-1.512,6.863c0,1.176,0.176,2.504,0.465,3.875l0.223,1.086\n		l3.785-0.16c-0.023,0,3.406-0.113,3.406-0.113l2.414-0.063l-1.344-1.93c-0.781-1.133-1.438-2.629-2.156-4.23\n		c-0.887-2.047-1.777-4.016-2.977-5.551l-1.336-1.711L26.924-127.506z"/>\n	<path fill="#FFFFFF" d="M21.292-121.729c-0.789-1.945-1.527-3.738-2.672-4.793c-0.75,1.344-1.336,3.023-1.336,4.801\n		c0,0.254,0.016,0.504,0.043,0.75c1.078,0.016,2.559,0.051,4.293,0.082C21.502-121.186,21.397-121.448,21.292-121.729"/>\n	<path fill="#FFFFFF" d="M30.999-121.674c-0.867-1.895-1.73-3.832-2.852-5.281c-0.52,1.082-1.324,3.195-1.359,6.137\n		c1.504,0.031,3.059,0.059,4.602,0.09C31.245-121.049,31.124-121.354,30.999-121.674"/>\n	<path fill="#FFFFFF" d="M33.362-116.834h-0.016H33.362z"/>\n</g>\n</svg>','images/kanton/wappen/svg/ai.svg','images/kanton/wappen/20px/Wappen_Obwalden_matt.svg.png','images/kanton/wappen/50px/Wappen_Obwalden_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Schaffhausen_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Appenzell_Innerrhoden','Q12094','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(17,'SG',17,'St. Gallen','Saint-Gall','San Gallo',0,2,'de','St. Gallen',NULL,NULL,2026,1803,'\n<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="531" height="669" viewBox="0 0 354 446">\n<g stroke="black" stroke-width="4.5" fill="#009933">\n<path d="M 2.5,2.5 h 349 V 176.2 C 351.5,293.6 320,395 177,443.35 34,395 2.5,293.6 2.5,176.2 z" stroke-width="5" />\n<path d="M 168.6,35.7 a 8.45,7.5 0 0,1 16.8,0 V 411.5 a 8.45,7.5 0 0,1 -16.8,0 z" fill="white" />\n<path d="M 144.75,369.3 a 7.45,7.2 0 0,1 -14.9,0 V 114.6 a 7.45,6.4 0 0,1 14.9,0 V 367.9 a 9.375,8.9 0 0,0 18.75,0 V 116.2 a 9.375,8.4 0 0,0 -18.75,0 M 209.25,369.3 a 7.45,7.2 0 0,0 14.9,0 V 114.6 a 7.45,6.4 0 0,0 -14.9,0 V 367.9 a 9.375,8.9 0 0,1 -18.75,0 V 116.2 a 9.375,8.4 0 0,1 18.75,0 M 163.5,119 A 13.5,11.5 0 0 1 190.5,119 L 190.5,366 A 13.5,11 0 0 1 163.5,366 M 198,77.6 V 49.8 H 173 c -25,-0.2 -38.5,-13 -49.4,-27.2 -6.9,13.6 -8.9,22 -9.2,34.8 0.4,15 2.2,24.1 11,40 13.9,-14.2 26.7,-19.5 46.3,-19.8 z" fill="white" />\n<path d="M 125.5,131 l 103,0 0,22 -103,0 z M 125.5,331.7 l 103,0 0,22 -103,0 z M 125.5,319.5 l 1.5,0 101.5,-120.5 0,-33.7 -1.5,0 -101.5,120.5 z" stroke-linejoin="round" />\n<path d="M 125.5,165.3 l 1.5,0 101.5,120.5 0,33.7 -1.5,0 -101.5,-120.5 z" stroke-linejoin="round" />\n</g>\n</svg>','images/kanton/wappen/svg/sg.svg','images/kanton/wappen/20px/Wappen_Schaffhausen_matt.svg.png','images/kanton/wappen/50px/Wappen_Schaffhausen_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Schwyz_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Solothurn','Q11929','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(18,'GR',18,'Graubünden','Grisons','Grigioni',0,2,'de','Chur',NULL,NULL,7105,1803,'\n<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1900 2307">\n<title>Wappen Graubünden</title>\n<path d="m1893 8.939v1387c0 498-422 902-943 902-520.7 0-942.9-404-942.9-902l0.005-1387z" stroke="#000" stroke-width="14.21" fill="#fff"/>\n<path d="m477.6 1111h-469.6l0.037-1104 469.6 0.186v1104zm1094 247c-1-5-4-10-6-14 1-6 1-12-1-18-4-11-14-19-25-22 0-5 0-9-2-14-4-13-17-22-33-23 0-4 0-7-1-10-7-19-29-28-52-22 0-2 0-4-1-6-7-19-31-29-54-21-1 1-2 1-2 1 0-3-1-5-2-8-6-18-30-26-53-18-4 1-8 3-11 5 0-2 0-5-1-7-6-18-30-26-54-18-8 3-16 8-21 14-5-17-27-28-50-24-13 3-23 9-30 17-8-13-27-20-47-17-18 4-32 15-36 28-8-12-26-19-44-16-22 5-38 23-34 42 0 2 1 3 1 5 9-7 22-14 33-17 23-6 45-2 58 10 4-3 8-6 13-8 23-11 49-8 63 7 1 0 2-1 3-2 28-13 59-6 70 17v2c1-1 1-1 2-1 27-13 58-6 69 17 1 1 2 3 2 5 54-15 191 58 238 156 9-11 12-26 8-40m-716.7-104c0-4 3.8-7 9.6-9 1 7 7.6 13 15.6 13 8.7 0 15.8-7 15.8-16h-0.1c9.7 1 17.3 5 17.3 12 0 20-58.2 16-58.2 0m641.7 208c2-8 2-17-2-25-5-9-12-16-20-19 3-8 3-17-1-26-5-9-13-16-23-18 2-8 2-16-1-24-6-12-19-18-33-18 2-8 1-17-2-24-8-15-26-22-45-19 0-4-1-9-3-13-8-17-29-24-50-17 1-7 0-13-2-18-8-17-33-23-56-12-5 2-9 5-13 9 0-5 0-10-3-15-8-17-33-23-55-12-4 2-8 4-11 7-8-18-33-23-56-12-7 3-13 8-18 13-8-14-31-21-54-15-14 4-25 11-33 20-41.4-44-94.9-39-109.6-37-74.4 11-111.2 58-158 62-21.3 2-42.6-6-53.5-12-10.4 19 8.7 13 7.1 26-0.5 4-21.3 28 8.2 29 14.1 1 39.2-2 47.9 9-137.9 23-100.3-43-123.7-43-33.8 0-28.4 97 66.5 79 3.3 7 10.4 12 15.3 16 31.6-22 101.9-10 35.4 38 52.9 6 60.5-31 61-34 19.2-9 62.2 9 86.2 6 24-2 57.2-36 66.5-38 33.2 38 56.7 36 120.7 22-22-56-85-37-89.1-52 24.1-16 73.1-24 128.1-22 0 0 1 1 2 1 50 2 107 13 156 35 103 48 191 138 194 245 28-32 32-63 20-92m-357 266c25 27 27 80 95 132-42 39-50 12-53 10-69 4-19-69-24-87-92 84-34 149-34 149s15 25-9 30c-52 11-178.6 60-218.5 122-21 32-40.3-12-48.1-11-14.8 3-48.7 62-48.7 62s-79.4 12-81.7 9c-2.4-4 28.2-52 39.1-69-19.9-10-48.9 42-48.9 42l-42.9 6s67.8-69 71.2-81c3.2-8 153.9 6 248-123-170.8-149 112.5-205 155.5-191m-1036 30s27.2 7 33.2 10c5.9 4 53.3-39 56.9-39 3.7 1 7.1 3 7.9 7 0.7 4-65.5 68-65.5 68s57.7 3 90.8 1c33.2-3 32.3-24 41.6-43 12.6-13 19.6-16 19.6-16s8.8 13 29.1 16c22.1 4 44.6-47 103.8-87 38.2-27 149 7 149 7s165.7 51 175.3 69c49.6-13 53.5-109 72.3-102 32.9 13-7.6 41-6.4 59 26.5-5 277.1-15 298.1-5 2 0-57-31-57-31s80-51 153 125c24 59 93 57 135 76 122 18 82 170 87 189-1 3-8 10-10 12-8 9-32 13-32 13h-8s-11-3-21-3c-26-1-51 35-84 72 21 10 41-6 41-6s38-62 48-41c1 3-43 72-47 76 5 16 33-9 42-11 10-1 59-5 68-45 4-23 59-17 59-17s10-4 14-9c-16-19-1-182-9-207 12-31-2-47-2-47s-25 1-45-16c-35-17-74-165-100-178 2-5 4-9 8-11 35-15 70 18 73 42 1 17 56 24 56 24s3-4-13-23c-4-4 4-8 4-8s61 27 74-19c-70 23-116-96-216-17-41-36-129-93-388.5-133 78.5-88 58.4-143 26.7-158-71.9 55-95.4 14-121.1 22-20.9 90-248.1 18-258.8 215 3.6 0 65.3 3 74.2 3 3.2 12 7.9 12-24.6 20-17.9-5-112.6-7-155.9-20-45.9-9-91.7 30-91.7 30s-76.3 61-93.8 69c-17.4 8-55.7 16-66.1 21-10.2 4-30.3-2-30.3-2l-93.8 48zm479.4-297c4.4 6 20.6 14 20.6 14s-29 35-44.5 111c-20.4-1-33.5-2-33.5-2s-25.2 2-33.7-32c-21.5-85-23.6-121-45.6-151-10.8-15-39.4-23-65.7-31-27.4-9-52.5-17-52.5-17s-34.4-16-61.6 8c-3.1 3-9.7 2-10.6-14s-18.1-9-18.1-9-24.7 14-50.5 21c-32.4 9-84.3-55-101.4-54 25.2-1 98.9-2 98.9-2s10.4-8 2.9-15-63.7 10-69.7 1-16.8-26-16.8-26 31.2 10 77.6 4c35.4-5 56.5 1 60.1 3 72.4 45 199 50 219.1 47 28.4-4 42.4 22 48.3 31 7.8 13 11.7 24 11.7 24s33.1 46 65 89"/>\n<path d="m1098 1763s21-18 63 0c4 9 5 10 11 22-12-17-60-15-74-22" fill="#e7423f"/>\n<path d="m632.3 1267c8.2 1 4.8 36 44.7 43 21.9 4 48.4 4 79.1-1 0 4-0.3 6-0.6 10-64.2 12-80.3 17-107.1 5-31.7-13-26.3-58-16.1-57" fill="#e7423f"/>\n<path d="m950.7 7.107v1104h941.3v-1104l-941.3 0.107z" stroke="#000" stroke-width="14.21" fill="#248bcc"/>\n<g stroke="#000" stroke-width="14.21" fill="none">\n<path d="m1276 1111h-325.3v-402.1h325.3v402.1z"/>\n<path d="m1892 410.5h-325v-403l325 0.059v403z"/>\n<path d="m7.813 7.108 0.218 1104h1884v-1104z" stroke-linecap="square" stroke-miterlimit="10"/>\n</g>\n<path d="m1892 410.5h-325v-403l325 0.059v403zm-616 700.5h-325.3v-402.1h325.3v402.1zm0-1103v402.9h-323.8l-0.2 149.2h469v-552.1l-145 0.021zm616 701.3v-149.8h-471v551.9h146v-402.1h325z" stroke="#000" stroke-width="14.21" fill="#ffd72e"/>\n</svg>','images/kanton/wappen/svg/gr.svg','images/kanton/wappen/20px/Wappen_Solothurn_matt.svg.png','images/kanton/wappen/50px/Wappen_Solothurn_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Solothurn_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Graub%C3%BCnden','Q11925','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(19,'AG',19,'Aargau','Argovie','Argovia',0,2,'de','Aarau',NULL,NULL,1404,1803,'\n<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1900 2298">\n<title>Wappen Aargau</title>\n<path d="m949.4 7.088h939.6v1381c0 497-420 899-939.1 899-518.5 0-939-402-939-899v-1381l938.5 0.088z" stroke="#000" stroke-width="14.18" fill="#248bcc"/>\n<path d="m949.9 2287c-518.5 0-939-402-939-899v-1381l938.5 0.088 0.5 2280z"/>\n<g fill="#fff">\n<path d="m919.9 857.4c-44.4 0-64.7-9.8-83-19.5-9.8-5.7-19.9-11.5-33.8-15.5-0.3-0.1-0.7-0.2-1.1-0.2-0.4-0.2-0.7-0.3-1.2-0.5-10-2.6-21.9-4.3-37.6-4.3h-0.5-0.6c-20.9 0-35.1 3-46.6 7.4-31.7 11.6-46.3 32.4-108.6 32.6-17-0.1-30.5-1.6-41.5-4-46.1-9.9-52.4-36-113.4-36h-0.6-0.5c-75.6 0-70 40-157 40s-78.5-40-154.2-40c-70.31 0-72.77 33.6-125.3 38.3l-0.01 127.4c52.54-4.7 55-38.2 125.3-38.2 75.7 0 67.2 40 154.2 40 12.8 0 23.5-0.9 32.8-2.4v0.1c52.3-4.7 54.9-38.1 124.7-38.3 60.6 0.2 66.5 26.1 114 36.1 10.9 2.4 24.1 3.9 40.8 3.9 0.2 0 0.4-0.1 0.7-0.1s0.5 0.1 0.7 0.1c65.5 0 77.6-20.9 107.9-32.6 12-4.3 26.5-7.3 47.2-7.4 15.7 0.1 27.9 1.8 38.1 4.5 0.5 0.1 0.8 0.2 1.2 0.3 0.4 0 0.8 0.2 1.1 0.3 13.4 3.9 23.3 9.6 33.8 15.4 11.6 6.6 22.8 13.1 39.8 16.3v-0.3c11.5 2.5 25.3 4.1 43.2 4.1 11.4 0 21.2-0.7 29.7-1.8v-127.5c-8.5 1.1-18.3 1.8-29.7 1.8"/>\n<path d="m919.9 1028c-44.4 0-64.7-10-83-20-9.8-6-19.9-11.3-33.8-15.3-0.3-0.1-0.7-0.2-1.1-0.2-0.4-0.2-0.7-0.3-1.2-0.4-10-2.7-21.9-4.4-37.6-4.4h-0.5-0.6c-20.9 0-35.1 3-46.6 7.5-31.7 11.8-46.3 31.8-108.6 32.8-17 0-30.5-2-41.5-4-46.1-10-52.4-36.3-113.4-36.3h-0.6-0.5c-75.6 0-70 40.3-157 40.3s-78.5-40.3-154.2-40.3c-70.31 0-72.77 33.3-125.3 38.3l-0.01 127c52.54-4 55-38 125.3-38 75.7 0 67.2 40 154.2 40 12.8 0 23.5-1 32.8-2 52.3-5 54.9-38 124.7-38 60.6 0 66.5 26 114 36 10.9 2 24.1 4 40.8 4h0.7 0.7c65.5 0 77.6-21 107.9-33 12-4 26.5-7 47.2-7 15.7 0 27.9 1 38.1 4h1.2c0.4 0 0.8 1 1.1 1 13.4 4 23.3 9 33.8 15 11.6 7 22.8 13 39.8 16 11.5 3 25.3 4 43.2 4 11.4 0 21.2 0 29.7-2v-127c-8.5 1-18.3 2-29.7 2"/>\n<path d="m919.9 1198c-44.4 0-64.7-10-83-20-9.8-5-19.9-11-33.8-15h-1.1c-0.4 0-0.7-1-1.2-1-10-2-21.9-4-37.6-4h-0.5-0.6c-20.9 0-35.1 3-46.6 7-31.7 12-46.3 33-108.6 33-17 0-30.5-2-41.5-4-46.1-10-52.4-36-113.4-36h-0.6-0.5c-75.6 0-70 40-157 40s-78.5-40-154.2-40c-70.31 0-72.77 33-125.3 38l-0.01 128c52.54-5 55-39 125.3-39 75.7 0 67.2 40 154.2 40 12.8 0 23.5 0 32.8-2 52.3-5 54.9-38 124.7-38 60.6 0 66.5 26 114 36 10.9 2 24.1 4 40.8 4h0.7 0.7c65.5 0 77.6-21 107.9-33 12-4 26.5-7 47.2-7 15.7 0 27.9 2 38.1 4 0.5 0 0.8 0 1.2 1h1.1c13.4 4 23.3 10 33.8 15 11.6 7 22.8 14 39.8 17v-1c11.5 3 25.3 4 43.2 4 11.4 0 21.2 0 29.7-1v-128c-8.5 1-18.3 2-29.7 2"/>\n</g>\n<path d="m1640 639.8 55 148.7h145l-114 78.7 43 140.8-129-82.7-129 82.7 45-141.9-116-77.6h146l54-148.7z" stroke="#000" stroke-width="14.18" fill="#fff"/>\n<path d="m1191 639.8 54 148.7h146l-115 78.7 44 140.8-129-82.7-128 82.7 44-141.9-116.4-77.6h145.4l55-148.7z" stroke="#000" stroke-width="14.18" fill="#fff"/>\n<path d="m1416 1033 55 149h145l-116 78 45 142-129-83-129 82 44-141-115-79h145l55-148z" stroke="#000" stroke-width="14.18" fill="#fff"/>\n<path d="m948.3 5.674v2281" stroke="#000" stroke-width="10.34" fill="none"/>\n</svg>','images/kanton/wappen/svg/ag.svg','images/kanton/wappen/20px/Wappen_St._Gallen.svg.png','images/kanton/wappen/50px/Wappen_St._Gallen.svg.png','images/kanton/lage/Karte_Lage_Kanton_St._Gallen_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Aargau','Q11972','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(20,'TG',20,'Thurgau','Thurgovie','Turgovia',0,2,'de','Frauenfeld',NULL,NULL,991,1803,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.402px" height="492.691px" viewBox="-176.306 -213.897 406.402 492.691"\n	 enable-background="new -176.306 -213.897 406.402 492.691" xml:space="preserve">\n<g>\n	<path fill="#FFFFFF" d="M26.772-212.377h201.816V84.271c0,106.586-90.297,193-201.68,193c-111.406,0-201.695-86.416-201.695-193\n		v-296.648H26.772z"/>\n	<path fill="#16A74E" d="M-174.787,84.271c0,106.586,90.289,193,201.695,193c74.484,0,139.5-38.643,174.453-96.104l-376.148-391.277\n		V84.271z"/>\n	<path fill="#E8423F" d="M-51.091-27.659c-1.176-0.457-6.078-1.512-7.328,0.625c-7.047,12.047,4.504,38.688,15.352,44.016\n		c5.84,2.84,5.914,0.832,5.898,0.184C-37.322,9.63-58.833-13.284-51.091-27.659"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M-51.091-27.659c-1.176-0.457-6.078-1.512-7.328,0.625\n		c-7.047,12.047,4.504,38.688,15.352,44.016c5.84,2.84,5.914,0.832,5.898,0.184C-37.322,9.63-58.833-13.284-51.091-27.659z"/>\n	<path fill="#FFD730" d="M48.393,130.498c-19.262-3.75-49.18,5.719-49.18,5.719s-17.672,7.656-21.402,17.102\n		c-3.758,9.492,0.379,13.328,0.379,13.328s9.008,15.297,3.031,21.898c-11.074,2.758-29.336-0.141-33.879-6.391\n		c-4.707-6.438,3.031-10.688,3.168-15.281c0.293-9.75-7.426-13.984-10.387-12.719c-1.863,0.805,3.922,4.625,0.914,8.969\n		c-3.512,5.031-8.633-2.891-13.41-5.328c-4.773-2.453-9.391,1.148-9.391,1.148s4.809,1.508,5.887,2.508\n		c1.074,1.016,1.234,5.734-1.152,7c-3.605,1.953-12.832-2.344-18.629,6.109c4.879-1.523,6.848-0.094,7.277,0.25\n		c3.449,2.609-2.133,8.078,6.418,12.641c-6.137,0.148-8.168,0.297-9.57,0.703c6.488,0.789,4.531,7.844,9.035,9.688\n		c4.488,1.875,7.992,1.391,8.758,2.102c34.711,30.57,91.754,8.031,95.578,3.867c0.941-0.969-6.098-8.797-7.402-11.508\n		c-0.758-1.521,2.68-21.508,7.289-23.211c6.473-6.695,30.934-11.641,30.934-11.641S50.002,137.466,48.393,130.498"/>\n	<path fill="#FFD730" d="M48.393,130.498c-19.262-3.75-49.18,5.719-49.18,5.719s-17.672,7.656-21.402,17.102\n		c-3.758,9.492,0.379,13.328,0.379,13.328s9.008,15.297,3.031,21.898c-11.074,2.758-29.336-0.141-33.879-6.391\n		c-4.707-6.438,3.031-10.688,3.168-15.281c0.293-9.75-7.426-13.984-10.387-12.719c-1.863,0.805,3.922,4.625,0.914,8.969\n		c-3.512,5.031-8.633-2.891-13.41-5.328c-4.773-2.453-9.391,1.148-9.391,1.148s4.809,1.508,5.887,2.508\n		c1.074,1.016,1.234,5.734-1.152,7c-3.605,1.953-12.832-2.344-18.629,6.109c4.879-1.523,6.848-0.094,7.277,0.25\n		c3.449,2.609-2.133,8.078,6.418,12.641c-6.137,0.148-8.168,0.297-9.57,0.703c6.488,0.789,4.531,7.844,9.035,9.688\n		c4.488,1.875,7.992,1.391,8.758,2.102c34.711,30.57,91.754,8.031,95.578,3.867c0.941-0.969-6.098-8.797-7.402-11.508\n		c-0.758-1.521,2.68-21.508,7.289-23.211c6.473-6.695,30.934-11.641,30.934-11.641S50.002,137.466,48.393,130.498"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="17" d="M48.393,130.498\n		c-19.262-3.75-49.18,5.719-49.18,5.719s-17.672,7.656-21.402,17.102c-3.758,9.492,0.379,13.328,0.379,13.328\n		s9.008,15.297,3.031,21.898c-11.074,2.758-29.336-0.141-33.879-6.391c-4.707-6.438,3.031-10.688,3.168-15.281\n		c0.293-9.75-7.426-13.984-10.387-12.719c-1.863,0.805,3.922,4.625,0.914,8.969c-3.512,5.031-8.633-2.891-13.41-5.328\n		c-4.773-2.453-9.391,1.148-9.391,1.148s4.809,1.508,5.887,2.508c1.074,1.016,1.234,5.734-1.152,7\n		c-3.605,1.953-12.832-2.344-18.629,6.109c4.879-1.523,6.848-0.094,7.277,0.25c3.449,2.609-2.133,8.078,6.418,12.641\n		c-6.137,0.148-8.168,0.297-9.57,0.703c6.488,0.789,4.531,7.844,9.035,9.688c4.488,1.875,7.992,1.391,8.758,2.102\n		c34.711,30.57,91.754,8.031,95.578,3.867c0.941-0.969-6.098-8.797-7.402-11.508c-0.758-1.521,2.68-21.508,7.289-23.211\n		c6.473-6.695,30.934-11.641,30.934-11.641S50.002,137.466,48.393,130.498z"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M-65.205,163.544c0,0-5.336,14.516,1.242,23.844\n		c6.574,9.328,13.344,8.297,18.879,25.781 M-79.314,169.576c0,0-0.754,3.117,4.781,6.148c-2.039,2.656-2.445,19.234,1.441,24.25"/>\n	<path fill="#FFD730" d="M-3.13,64.974c0-0.07,0-0.164-0.008-0.313c0,0.016-0.008,0.047-0.008,0.063\n		C-3.138,64.81-3.13,64.904-3.13,64.974 M-3.13,64.974C-3.107,65.154-3.107,65.154-3.13,64.974 M144.167,143.123\n		c-11.477-16.906-35.547-29.938-48-34.422C81.112,97.294,78.002,97.263,73.471,94.044c2.188-14.781-10.164-32.703-10.164-32.703\n		s-5.781-6.578-18.508-6.641c3.344,2.625,16.891,13.422,13.367,16.031c-15.383-26.828-37.68-17.906-37.68-17.906\n		s9.168,1.719,11.652,7.172c2.52,5.469,11.895,26.344,22.059,36.031c3.242,3.109,9.852,8.047,18.313,11.047\n		c20.781,7.359,50.555,25.578,56.82,33.719c3.273,4.234,5.375,10.078,5.273,12.188c-0.109,2.094-2.297,4.031-5.391,3.625\n		c-3.906-0.5-50.492-30.594-50.492-30.594s-10.047-7.266-30.438-12.281C34.932,95.654-4.189,77.154-12.466,70.357\n		c-0.059,0.078-0.121,0.156-0.168,0.219c4.367-5.25,7.68-10.922,10.039-15.938c-0.656,5.344-0.594,8.844-0.543,10.016\n		c0.086-1.906,20.344-22.438,16.504-31.855c14.664-5.801,12.801-7.457,12.121-13.082c-0.516,0.199-1.625,0.129-2.992,0\n		c0.973,0.066,1.973,0.082,2.992,0C25.467,12.212,7.061,8.279,7.573,7.279c0.504-0.984,5.961,1.438,7.113,0.391\n		C15.1,7.244-8.404-20.643-13.74-19.889c-2.063,0.656-3.152,2.543-5.457,1.246c-2.316-1.297-7.805-6.816-9.934-7.168\n		c0.137,0.785-2.488,2.816-2.488,2.816s-3.137,1.082-5.672,2.887c-2.543,1.816-2.367,7.969,0.145,10.488\n		c0.137,0.129-2.129,6.625-2.129,6.625s3.93-5.297,4.641-5.297c0.688,0,7.961,4.594,8.254,8.891\n		c0.547,7.766-12.809,19.605-13.305,19.688c-2.75,0.422-7.988-9.457-9.293-10.129c-0.504-0.25-2.563-2.184-5.281,7.785\n		c-0.199,0.766,0.574,2.453,1.922,4.637v-0.016c0,0-10.914-7.59-21.793-8.527c1.832,0.113,3.496,0.41,4.75,0.801\n		c-3.781-7.922-11.352-38.344-7.711-54.594c24.594-9.309,22.039-13.199,21.777-17.871c3.672-4.59-2.023-10.109-2.023-10.109\n		l-2.188,6.184c0,0-2.484,1.672-5.559-0.512c-3.07-2.168-1.086-10.434-2.391-15.105c-1.313-4.641-6.586-9.434-6.586-9.434\n		s1.207,3.707,1.434,4.809c0.199,1.113-0.496,3.266-4.832,3.031c-4.328-0.23-4.168-4.773-6.57-6.934\n		c-2.43-2.184-7.309-3.395-7.309-3.395s3.27,7.113,2.496,8.172c-2.211,0.23-5,6.598-6.777,7.148\n		c-1.762,0.523-6.953-7.605-11.031-2.148c5.039-0.578,5.504,2.172,5.598,3.117c0.313,3.479-8.16,16.801-1.504,20.77\n		c-6.406,14.816,0.168,23.672,0.168,23.672s-4.941,24.641-5.52,53.422c0.754,0.547,1.328,1.203,1.785,1.875\n		c-15.359-13.297-24.84-54.145-24-59.184c0.438-2.609,1.047-3.594,1.047-3.594s1.961,0.281,3.984-0.266\n		c2.047-0.543,2.664-1.063,2.664-1.063s5.816-0.527,7.352-1.016c1.52-0.488,7.098-11.113,4.16-18.234\n		c-0.816,1.754-1.902,5.836-4.273,6.426c-2.375,0.609-2.102-1.609-5.84-3.145c1.16-11.109-9.656-23.039-9.656-23.039\n		s3.633,7.422,1.227,8.758c-2.395,1.344-6.512,2.594-6.512,2.594l-1.25,12.855c0.191-2.672,0.395-6.656,0.395-11.902\n		c-1.465-3.344-4.602-9.008-8.73-13.703c1.922,3.063,4.219,8.438-0.664,15.422c0.176,0.473,0.52,1.504,3.402,7.785\n		c-3.273-5.754-15.105-13.145-15.105-13.145s2.977,11.313-2.953,17.785c4.203,1.855,1.234,39.063,11.785,40.965\n		c2.68,5.563,5.656,72.262,19.641,89.98c1.758,0.117,15.598-0.078,15.598-0.078l-2.652,0.656c0,0,17.973,20,24.566,25\n		c9.07,6.938,47.887,13.266,74.434,15.938c26.551,2.688,39.68,12.359,40.543,11.031c0.496-1.063-6.137-8.734-4.816-9.109\n		c2.809-0.781,14.922,38.438,25.828,47.625c10.922,9.234,37.281,12.906,38.906,21.625c1.313,6.828-2.766,25.078-13.516,23.672\n		c-1.602-0.234-6.313-17.266-9.016-18.531c-2.719-1.25-9.93-2.75-16.328,0.813c1.078,0.328,7.641,1.859,10.203,2.461\n		c2.219,2.281-1.609,6.836-2.938,7.328c-3.031,1.063-5.43,0.344-7.805,0.836c-6.461,1.391-10.414,10.281-10.414,10.281\n		s11.75,0.359,12.25,6.688c6.328-3.547,8.328-6.328,12.734-3.656c-14.289,3.25-15.422,6.734-17.836,16.805\n		c5.383-2.891,8.586-5.219,10.18-4.164c1.563,1.078,3.469,2.344,5.906,1.406c0.422-0.156,0.969-0.391,1.586-0.688\n		c-1.195,0.789-2.164,1.531-2.406,2.031c-0.789,1.688-1.18,9.82-0.164,10.844c0.477-1.047,1.625-5.078,4.313-5.156\n		c2.672-0.125,12.047,1.969,13.359,0c1.297-1.984-0.969,0.156,1.875-3.148c2.844-3.242,15.422-8.18,18.281-10.211\n		c3.328-6.719,30.328-32.313,29.125-50.531c-17.125-3.203-16.5-6.953-18.508-9.922c-11.773-2.719-30.039-33.5-33.203-38.25\n		c4.609,4.844,46.656,31.805,57.25,34.906C140.737,171.466,154.245,157.974,144.167,143.123 M17.803,19.251\n		c-2.711-0.164-5.504-0.125-7.301,0.906C12.62,18.958,15.124,18.998,17.803,19.251 M-36.009,86.341\n		c0.879-0.25,1.773-0.531,2.645-0.828C-34.236,85.81-35.123,86.091-36.009,86.341"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M-102.212-28.249c6.41-0.984,12.824-9.707,19.855-20.738\n		c7.035-11.047,14.77-13.543,16.891-13.281 M-102.65-52.37c0,0,13.695-14.504,23.313-17.336c-3.664-9.898,0.512-9.266,0.512-9.266\n		 M-120.978-52.827c0,0-8.633,8.906-9.074,19.145 M46.237,210.451c8.484,0.922,23.391,10.953,21.109,4 M45.799-24.315\n		c-0.797,2.441-0.734,2.754,3.398,6.984C41.69-2.737,47.081,7.951,47.081,7.951"/>\n	<path fill="#E8423F" d="M9.182,139.63c0,0,15.305,7.703,20.848,7.492c-0.992-2.742-3.969-8.727-3.969-8.727\n		S20.174,135.029,9.182,139.63"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M9.182,139.63c0,0,15.305,7.703,20.848,7.492\n		c-0.992-2.742-3.969-8.727-3.969-8.727S20.174,135.029,9.182,139.63z"/>\n	<path fill="#FFD730" d="M150.065-18.729c-2.188-1.184-24.445-4.906-35.516-3.168c-11.078,1.719-13.063,12.766-13.797,17.832\n		c-0.688,5.031,0.813,12.855-15.047,9.98C78.963,4.701,70.393-3.69,70.456-8.018c0.094-5.984,7.438-8.41,7.641-13.082\n		c0.063-1.406,0.141-13.031-8.82-13.031c-0.766,2.473,3.297,9.047-2.18,9.641c-5.266,0.563-9.672-7.016-14.219-9.871\n		c-3.453-2.199-8.078-0.656-8.078-0.656l6.031,3.816c0,0-0.141,5.129-2.375,6.313c-4.266,2.246-12.984-5.098-20.953,3.641\n		c5.168-0.656,6.664,0.781,8.086,1.109c1.539,3.816-1.914,10.641,4.133,13.281c-1.25-0.16-9.805-0.754-9.645-0.457\n		c5.121,1.723,4.285,6.281,4.285,6.281s1.969,6.246,11.227,7.457c14.57,19.887,53.773,35.355,79.43,33.996\n		c-0.344-20.375,6.289-26.094,18.406-28.141C144.393,7.662,149.854-17.764,150.065-18.729"/>\n	<path fill="#FFD730" d="M-52.244-160.698c-0.254,0.984-3.145,10.613,2.551,20.262c0.105-0.27-0.055-1.805-0.055-1.805\n		s3.57-2.523,4.984-5.352c0.672-1.32,5.488-3.195,8.184-6.5c2.762-4.094,0.559-12.848-4.816-17.598\n		c0.313,4.168,1.367,6.664,0.656,7.406C-43.611-161.17-51.986-161.674-52.244-160.698"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M-52.244-160.698c-0.254,0.984-3.145,10.613,2.551,20.262\n		c0.105-0.27-0.055-1.805-0.055-1.805s3.57-2.523,4.984-5.352c0.672-1.32,5.488-3.195,8.184-6.5\n		c2.762-4.094,0.559-12.848-4.816-17.598c0.313,4.168,1.367,6.664,0.656,7.406C-43.611-161.17-51.986-161.674-52.244-160.698z"/>\n	<path fill="#E8423F" d="M67.854-186.377c-1.266-0.168-6.398-0.008-7.102,2.605c-4.063,14.762,13.953,40.258,26.031,43.082\n		c6.516,1.504,6.086-0.688,5.922-1.344C90.706-150.084,63.737-168.94,67.854-186.377"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M150.065-18.729c-2.188-1.184-24.445-4.906-35.516-3.168\n		c-11.078,1.719-13.063,12.766-13.797,17.832c-0.688,5.031,0.813,12.855-15.047,9.98C78.963,4.701,70.393-3.69,70.456-8.018\n		c0.094-5.984,7.438-8.41,7.641-13.082c0.063-1.406,0.141-13.031-8.82-13.031c-0.766,2.473,3.297,9.047-2.18,9.641\n		c-5.266,0.563-9.672-7.016-14.219-9.871c-3.453-2.199-8.078-0.656-8.078-0.656l6.031,3.816c0,0-0.141,5.129-2.375,6.313\n		c-4.266,2.246-12.984-5.098-20.953,3.641c5.168-0.656,6.664,0.781,8.086,1.109c1.539,3.816-1.914,10.641,4.133,13.281\n		c-1.25-0.16-9.805-0.754-9.645-0.457c5.121,1.723,4.285,6.281,4.285,6.281s1.969,6.246,11.227,7.457\n		c14.57,19.887,53.773,35.355,79.43,33.996c-0.344-20.375,6.289-26.094,18.406-28.141C144.393,7.662,149.854-17.764,150.065-18.729z\n		 M67.854-186.377c-1.266-0.168-6.398-0.008-7.102,2.605c-4.063,14.762,13.953,40.258,26.031,43.082\n		c6.516,1.504,6.086-0.688,5.922-1.344C90.706-150.084,63.737-168.94,67.854-186.377z"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.306" y="-213.897" width="406.402" height="492.691"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="#FFD730" d="M223.346-2.713c-0.859-8.266-9.609-29.953-30.938-62.457\n						c-15.063-22.93-16.313-34.688-13.516-44.77c13.844-2.008,32.079-20.695,31.579-32.008c-0.517-11.336-7.392-17.094-7.392-17.094\n						s-3.906,24.449-8.969,23.055c1.734-2.504,7.016-10.344,7.094-21.398c0.094-11.043-15.609-20.832-17.797-20.977\n						c1.453,2.008,7.555,8.367,6,13.277c-1.578,4.898-5.688,10.523-11.281,17.883c-5.672,7.422-13.016,19.664-13.891,31.375\n						c-0.891,11.602,5.516,25.473,8.406,33.848c3.094,8.879,24.094,42.77,24.094,42.77S221.82-1.459,213.329,5.51\n						c-2.578,2.129-13.508,1.488-19.625-7c-5.734-7.938-4.969-7.609-9.883-14.953c-6.969-10.438-11.328-9.672-11.609-10.934\n						c-22.461-37.625-53.82-58.543-58.445-61.281c0,0,7.25-7.063,9.461-14.895c-0.148,2.742-0.703,9.734-0.703,9.734\n						s20.211-22.633,17.883-34.43c26.133-2.344,16.508-14.816,14.313-16.059c0.148-1.488-14.938-7.91-14.938-9.32\n						c0,0,0.344-0.207,0.844-0.414c4.953,1.48,6.156,1.191,6.078,0.414c-0.063-0.766-20.594-23.91-29.141-25.559\n						c-2.859,1.992-3.344,0.848-5.188,1.199c-2.836,0.449-9.836-8.734-13.359-8.941c-0.359,1.406-3.625,3.086-3.625,3.086\n						s-7.078,2.129-8.484,4.734c-1.422,2.602,1.203,8.77,1.203,8.77l-1.148,5.84c0,0,3.773-4.648,3.969-5.008\n						c1.906,2.832,8,2.527,9.477,10.656c1.484,8.121-4.734,10.801-7.133,15.68c-2.422,4.855-4.898,3.105-6.945,2.758\n						c-3.039-0.535-10.133-7.637-10.398-7.637c-3.195,0-4.898,8.336-4.836,9.465c0.922-0.344,1.328,3.031,2.25,3.484\n						c0.406,0.195,1,0.563,1.656,1c-11.016-7.336-29.125-5.504-29-4.965c0.141,0.52,4.961,2.461,4.672,3.688\n						c-0.203,0.871-8.594-1.258-19.863,2.703c0.129-0.047,0.242-0.098,0.363-0.145c0,0-20.008-20.703-14.664-35.457\n						c6.75-1.527,12.094-0.926,16.094-2.48c6.664-2.582,9.805-10.367,9.703-14.031c-6.508,7.059-8.469,5.25-9.551,4.777\n						c-4.016-1.816,0.387-12.168,0-15.887c-0.367-3.715-5.254-8.105-5.254-8.105s1.512,5.504-6.512,8.105\n						c-3.785,1.215-6.906-4.336-9.547-6.672c-2.664-2.313-7.664-2.699-7.664-2.699s4.008,6.043,2.875,7.633\n						c-2.617,0.059-4.992,4.289-8.457,5.074c-3.465,0.789-6.824-6.992-12.73-1.906c4.418-0.422,4.801,0.848,5.25,1.586\n						c2.063,3.352-1.121,4.367-2.504,17.488c-0.625,5.719-0.105,11.773,0.504,16.734c1.367,11.273,9.801,24.074,14.582,50.105\n						c0.02,0.016,0.066,0.039,0.121,0.055c-17.727-7.25-37.512-12.25-47.785-22.496c-10.68-10.656-9.246-27.16-7.863-29.648\n						c0-0.871-7.16-11.672-20.742-13.336c7.152,5.809,6.238,3.984,0.984,12.336c3.504,3.887,5.391,7.73,6.406,10.488\n						c-1-2.078-2.832-4.992-6.273-8.992c-3.637-1.129-9.52-1.344-17.102,0.648c10.102,1.727,8.152,13.273,8.152,13.273\n						s2.598,1.742,7.75,4.398c-5.641-2.406-22.766,1.176-22.766,1.176s13.848,1.184,12.598,9.777\n						c6.984,4.605,15.113,13.945,18.754,15.918c1.391,0.832,0.742,1.52,7.742,3C-31.373-81.42,9.108-56.85,13.604-55.147\n						c5.121-1.109,14.121-0.734,14.121-0.734s-3.762,0.488-7.625,0.918c6.738,8.785,30.434,10.41,61.074,14.035\n						c41.109,4.836,57.344,27.766,59.719,28.141c0.734-1.984-1.375-3.125-1.641-10.344c6.875,11.328-1.234,44.969,11.016,57.563\n						c11.75,12.082,28.359,22.543,32.578,28.262c1.328,1.773,3.016,5.492,2.125,15.82c-0.375,4.75-3.875,7.359-7.297,13.438\n						c-2.203,1.094-5.047,1.344-8.688,0.031c-21.063-7.563-27.359,3.484-27.359,3.484s12.766-1.375,12.375,6.094\n						c1.078-0.195,2.328-0.289,3.625-0.328c-3,1.07-5.922,3.547-7.75,8.695c5.5-3.133,10.484,3.227,12.891,6.422\n						c2.391,3.211,5.156,0.461,5.156,0.461s6.563-7.625,12.031-7.719c-0.594,0.344-16.594,4.328-12.453,21.852\n						c2.125-11.07,14.844-2.578,18.047-6.867c0.188-0.789-0.078-3.172,1.734-5.563c1.75-2.391,12-6,12-6\n						s10.172-16.531,10.734-26.148c0.164-2.641,2.547-15.789,2.766-38.945c-17.438-1.516-18.313-13.102-19.93-25.711\n						c-1.117-8.672-3.922-14.902-5.594-17.965c3.297,5.109,12.836,17.391,27.07,14.109C224.081,15.564,224.213,5.517,223.346-2.713\n						 M77.096-132.506c-0.258-0.25-0.57-0.48-0.852-0.711C76.542-132.971,76.838-132.737,77.096-132.506 M75.87-133.499\n						c-0.281-0.191-0.563-0.398-0.852-0.602C75.307-133.889,75.588-133.69,75.87-133.499"/>\n				</g>\n			</g>\n		</g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_3_" x="-176.306" y="-213.897" width="406.402" height="492.691"/>\n					</defs>\n					<clipPath id="SVGID_4_">\n						<use xlink:href="#SVGID_3_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_4_)" fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="16" d="\n						M113.752-88.651c4.625,2.738,35.984,23.656,58.445,61.281c0.273,1.262,4.641,0.504,11.602,10.934\n						c4.922,7.344,4.164,7.016,9.891,14.953c6.109,8.488,17.046,9.129,19.625,7c8.484-6.969-16.592-44.719-16.592-44.719\n						s-20.984-33.891-24.086-42.77c-2.883-8.383-9.289-22.246-8.406-33.848c0.867-11.711,8.211-23.953,13.883-31.375\n						c5.594-7.359,9.711-12.984,11.281-17.879c1.563-4.914-4.539-11.273-6-13.281c2.188,0.145,17.891,9.934,17.805,20.977\n						c-0.086,11.055-5.359,18.887-7.102,21.398c5.07,1.395,8.969-23.055,8.969-23.055s6.875,5.758,7.391,17.094\n						c0.508,11.313-17.734,30-31.57,32.012c-2.805,10.078-1.539,21.836,13.508,44.766c21.33,32.504,30.08,54.184,30.938,62.457\n						c0.875,8.23,0.75,18.277-9.031,20.543c-17.859,4.129-28.344-16.281-28.344-16.281s5.25,7.516,6.875,20.145\n						c1.625,12.609,2.5,24.203,19.938,25.703c-0.22,23.172-2.608,36.313-2.767,38.953c-0.563,9.609-10.742,26.141-10.742,26.141\n						s-10.242,3.609-12,6c-1.82,2.391-1.539,4.789-1.734,5.563c-3.195,4.297-15.922-4.188-18.055,6.875\n						c-4.141-17.531,11.859-21.516,12.461-21.859c-5.477,0.094-12.031,7.719-12.031,7.719s-2.773,2.766-5.164-0.453\n						c-2.406-3.188-7.391-9.547-12.883-6.422c5-14.219,18.492-8.125,18.492-8.125s-9.117-1.188-14.367-0.234\n						c0.398-7.469-12.375-6.094-12.375-6.094s6.297-11.047,27.359-3.492c3.641,1.313,6.492,1.063,8.695-0.031\n						c3.422-6.086,6.914-8.695,7.289-13.445c0.891-10.328-0.805-14.047-2.125-15.813c-4.219-5.719-20.836-16.188-32.578-28.262\n						c-12.242-12.594-4.148-46.234-11.016-57.563c0.266,7.219,2.375,8.359,1.641,10.344c-2.375-0.375-18.609-23.297-59.727-28.145\n						C50.511-44.56,26.812-46.185,20.078-54.97c3.863-0.441,7.625-0.918,7.625-0.918s-9-0.379-14.121,0.734\n						c-4.496-1.703-44.977-26.273-70.328-56.809c-7-1.48-6.352-2.168-7.742-3c-3.641-1.977-11.77-11.313-18.754-15.918\n						c1.25-8.586-12.598-9.777-12.598-9.777s18.734-3.926,23.477-0.824c-5.613-2.848-8.461-4.758-8.461-4.758\n						s1.949-11.547-8.152-13.273c7.574-1.992,13.465-1.777,17.102-0.648c8.258,9.586,7.387,13.063,7.387,13.063\n						s-0.891-7.199-7.512-14.551c5.254-8.352,6.168-6.527-0.984-12.336c13.582,1.664,20.742,12.465,20.742,13.336\n						c-1.383,2.496-2.816,18.992,7.863,29.648c14.602,14.559,48.457,18.488,68.191,33.496c13.145,10.008,11.238,25.793-1.965,27.094\n						c5.574,5.188,29.203,4.043,29.203,4.043s-4.508,4.23-6,5.621c2.016,1.492,28,4.984,44.242-13.828\n						c-2.258,5.109-3.633,7.719-3.633,7.719S92.276-65.858,113.752-88.651z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="9" d="M21.87-70.42\n		c5.574,5.188,29.211,4.043,29.211,4.043s-4.516,4.23-6,5.621c2.016,1.488,27.984,4.984,44.234-13.828\n		c-2.266,5.109-3.641,7.719-3.641,7.719s6.609,1,28.094-21.793c0,0,7.25-7.063,9.461-14.895c-0.148,2.742-0.703,9.734-0.703,9.734\n		s20.211-22.633,17.883-34.43c26.133-2.344,16.508-14.816,14.313-16.059c-0.688-0.137-7.438,0-13.195-0.27\n		c-5.789-0.273-7.563,5.504-7.563,5.504s-3.984,9.453-12.688,20.84c-12.867,16.957-33.539-5.09-44.164-14.273\n		c-10.586-9.176-31.227-7.145-31.094-6.566c0.148,0.521,4.961,2.461,4.672,3.688c-0.281,1.229-16.922-3.563-34.941,11.391\n		c0.816,0,9.242-0.113,8.93,2.176c-0.129,1.105-11.664,2.48-15.539,15.801c0.832,0.262,10.379,5.223,14.707,8.504\n		C36.971-87.506,35.081-71.721,21.87-70.42"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M9.131-106.018c3.875-13.32,15.418-14.695,15.539-15.801\n		c0.309-2.289-8.121-2.176-8.93-2.176c5.406-4.48,10.695-7.184,15.441-8.832c0,0-20.008-20.703-14.664-35.457\n		c6.75-1.527,12.094-0.926,16.094-2.48c6.664-2.582,9.813-10.367,9.703-14.031c-6.5,7.059-8.469,5.25-9.551,4.777\n		c-4.016-1.816,0.379-12.168,0-15.887c-0.367-3.715-5.254-8.104-5.254-8.104s1.512,5.504-6.512,8.104\n		c-3.785,1.215-6.906-4.336-9.547-6.672c-2.664-2.313-7.664-2.699-7.664-2.699s4.008,6.043,2.875,7.633\n		c-2.617,0.059-4.992,4.289-8.457,5.074c-3.465,0.789-6.824-6.992-12.73-1.906c4.418-0.422,4.801,0.848,5.25,1.586\n		c2.063,3.352-1.121,4.367-2.504,17.488c-0.625,5.719-0.105,11.773,0.504,16.734c1.367,11.273,9.801,24.074,14.582,50.105\n		C3.893-108.217,9.131-106.018,9.131-106.018z"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="5" d="M154.721-144.299\n		c-0.016,0.281-7.445,0-13.203-0.27c-5.781-0.273-7.563,5.504-7.563,5.504s-3.984,9.453-12.688,20.84\n		c-12.875,16.957-33.547-5.09-44.156-14.273c-1.148-1-2.875-2.176-3.75-2.602c-0.922-0.453-1.328-3.828-2.25-3.484\n		c-0.078-1.129,1.625-9.465,4.828-9.465c0.266,0,7.359,7.102,10.391,7.637c2.047,0.348,4.531,2.105,6.953-2.758\n		c2.391-4.879,8.609-7.559,7.125-15.68c-1.477-8.121-7.57-7.824-9.477-10.656c-0.195,0.359-3.969,5.008-3.969,5.008l1.148-5.84\n		c0,0-2.625-6.168-1.203-8.77c1.406-2.605,8.484-4.734,8.484-4.734s3.266-1.68,3.625-3.086c3.516,0.207,10.516,9.391,13.359,8.941\n		c1.844-0.352,2.328,0.793,5.188-1.199c8.547,1.648,29.078,24.801,29.141,25.559c0.078,0.785-1.125,1.066-6.078-0.414\n		c-0.5,0.199-0.844,0.414-0.844,0.414C139.768-152.209,154.854-145.788,154.721-144.299z"/>\n	<path fill="#010202" d="M114.213-172.17c1.148,0.145,11.836,2.887,13.719,15.391c-0.422,0.688-13.719-2.063-13.719-6.023\n		C114.213-167.268,118.799-168.233,114.213-172.17"/>\n	<path fill="#E8423F" d="M120.393-14.331c8.328-0.047,18.344,0.344,20.813,4.41c0.047,1.688,0.625,5.484,0.906,8.164\n		C138.002-2.338,120.393-13.401,120.393-14.331"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M-104.533,30.662c0,0,1.16-5.938,12.961-4.672\n		c1.227-2.199-7.559-3.938-7.414-4.609c0.168-0.688,12.688-5.934,21.262-3.984c-1.809-1.375-3.102-1.949-5.559-2.168\n		c4.328-1.781,10.582-1.406,13.895-0.391c-3.781-7.922-11.352-38.344-7.711-54.594c24.594-9.309,22.039-13.199,21.777-17.871\n		c3.672-4.59-2.023-10.109-2.023-10.109l-2.188,6.184c0,0-2.488,1.672-5.559-0.512c-3.07-2.168-1.086-10.434-2.391-15.105\n		c-1.313-4.641-6.586-9.434-6.586-9.434s1.207,3.707,1.434,4.809c0.199,1.113-0.496,3.266-4.832,3.031\n		c-4.328-0.23-4.168-4.773-6.57-6.934c-2.43-2.184-7.309-3.395-7.309-3.395s3.27,7.113,2.492,8.172c-2.207,0.23-5,6.598-6.773,7.148\n		c-1.762,0.523-6.953-7.605-11.031-2.148c5.039-0.578,5.504,2.172,5.598,3.117c0.313,3.479-8.16,16.801-1.504,20.77\n		c-6.406,14.816,0.168,23.672,0.168,23.672s-4.941,24.641-5.52,53.422C-105.189,27.044-104.533,30.662-104.533,30.662z\n		 M18.42-196.209c0.594,2.52-5.199,4.574-7.855,9.688c-11.922,2.984-20.113,12.543-22.504,18.801 M-8.474-148.163\n		c2.27-1.129,16.574-30.457,28.758-35.777c6.609-2.879,6.082,0.656,10.984-2.52 M120.393-14.331\n		c8.328-0.047,18.344,0.344,20.813,4.41c0.047,1.688,0.625,5.484,0.906,8.164C138.002-2.338,120.393-13.401,120.393-14.331z"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="17" d="M-39.283-3.002c0,0,3.926-5.297,4.641-5.297\n		c0.688,0,7.961,4.594,8.254,8.887c0.547,7.77-12.809,19.609-13.305,19.691c-2.75,0.422-7.988-9.457-9.293-10.129\n		c-0.504-0.25-2.563-2.184-5.281,7.785c-0.816,3.031,13.855,20.906,19.625,25.953c18.992,16.641,35.238-8.89,37.199-10.859\n		c5.719-5.672,4.098-10.719,7.938-12.871c4.078-2.313,9.543-0.031,14.973-0.441C25.452,12.212,7.045,8.279,7.557,7.279\n		c0.504-0.984,5.961,1.438,7.113,0.391c0.414-0.426-23.09-28.313-28.426-27.559c-2.063,0.656-3.152,2.543-5.457,1.246\n		c-2.32-1.297-7.809-6.816-9.934-7.168c0.137,0.785-2.488,2.816-2.488,2.816s-3.137,1.082-5.672,2.887\n		c-2.547,1.816-2.367,7.969,0.145,10.488C-37.029-9.499-39.283-3.002-39.283-3.002z"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="7" d="M-52.345,22.564\n		c4.039,6.547,13.375,17.543,17.703,21.324C-15.65,60.529,0.596,35.005,2.557,33.037c5.719-5.672,4.098-10.719,7.938-12.871\n		c4.078-2.313,13.102,0.281,14.973-0.441c0.68,5.625,2.547,7.281-12.117,13.082c3.863,9.473-16.68,30.215-16.504,31.918\n		c0.176,1.711-0.426-2.242,0.551-10.078C-8.129,66.272-18.512,81.483-36.02,86.35c0.457-0.898,1.898-3.508,3.473-7.461\n		c-24,23.398-48.277,14.844-48.277,14.844s1.695-1.453,6.016-5.125c-15.953-0.766-22.855-2.781-37.602-14.688\n		c9.129-1.266,13.25-10.234,14.281-18.688c1.047-8.438-2.891-9.766-4.922-14.422c-2.063-4.672-1.488-10.164-1.488-10.164\n		s1.16-5.938,12.961-4.672c1.223-2.199-7.559-3.938-7.414-4.609c0.168-0.688,12.688-5.934,21.262-3.984\n		c-1.809-1.375-4.031-2.422-6.496-2.621C-71.412,9.486-52.345,22.564-52.345,22.564z"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="10" d="M-12.458,70.357\n		c-5.504,6.5-13.504,13.188-23.543,15.984c0.453-0.906,1.895-3.5,3.469-7.453c-24,23.391-48.277,14.836-48.277,14.836\n		s1.695-1.453,6.016-5.125c-15.953-0.773-22.855-2.789-37.602-14.695c9.129-1.258,13.25-10.227,14.281-18.688\n		c1.047-8.438-2.887-9.766-4.922-14.422c-2.063-4.672-1.488-10.156-1.488-10.156s-0.184-2.281-1.605-3.738\n		c-15.359-13.293-24.84-54.141-24-59.184c0.438-2.605,1.047-3.59,1.047-3.59s1.961,0.281,3.984-0.266\n		c2.047-0.543,2.664-1.063,2.664-1.063s5.816-0.527,7.352-1.016c1.52-0.488,7.098-11.113,4.16-18.234\n		c-0.816,1.754-1.902,5.832-4.273,6.426c-2.375,0.605-2.102-1.609-5.84-3.145c1.16-11.113-9.656-23.039-9.656-23.039\n		s3.633,7.422,1.227,8.758c-2.395,1.344-6.512,2.594-6.512,2.594l-1.695,16.969c0,0,0.813-5.457,0.813-16\n		c-1.461-3.344-4.598-9.008-8.727-13.703c1.113,3.398,4.215,8.438-0.664,15.422c0.184,0.488,0.559,1.625,4.016,9.129\n		c-1.902-5.855-15.719-14.488-15.719-14.488s2.977,11.313-2.953,17.781c4.199,1.859,1.234,39.066,11.785,40.969\n		c2.68,5.563,5.656,72.262,19.641,89.98c1.758,0.117,15.598-0.078,15.598-0.078l-2.656,0.656c0,0,17.977,20,24.57,25\n		c9.07,6.938,47.887,13.266,74.43,15.938c26.555,2.688,39.68,12.359,40.547,11.031c0.496-1.063-1.824-6.906-4.816-9.109\n		c4.16,0.125,14.922,38.438,25.828,47.625c10.922,9.234,37.281,12.906,38.906,21.625c1.313,6.828-2.766,25.078-13.516,23.672\n		c-1.609-0.234-6.313-17.266-9.016-18.531c-2.719-1.25-9.938-2.75-16.328,0.813c1.078,0.328,7.641,1.859,10.203,2.461\n		c2.219,2.273-1.609,6.836-2.938,7.328c-3.031,1.063-5.43,0.344-7.805,0.836c-6.461,1.391-10.414,10.281-10.414,10.281\n		s11.75,0.359,12.25,6.688c6.328-3.547,8.328-6.328,12.734-3.656c-14.297,3.25-15.422,6.734-17.836,16.797\n		c5.375-2.883,8.586-5.211,10.18-4.156c1.563,1.078,3.469,2.344,5.906,1.406c2.422-0.898,8.273-4.508,8.273-4.508\n		s-8.289,4.195-9.094,5.852c-0.789,1.688-1.18,9.82-0.164,10.845c0.477-1.048,1.625-5.079,4.313-5.157\n		c2.672-0.133,12.047,1.969,13.359,0c1.297-1.984-0.969,0.156,1.875-3.148c2.844-3.242,15.422-8.18,18.281-10.211\n		c3.328-6.719,30.328-32.313,29.125-50.531c-17.125-3.203-16.5-6.953-18.516-9.922c-12.453-2.891-32-36.563-33.633-38.859\n		c0,2.188,46.492,32.203,57.688,35.516c12.852,3.766,26.375-9.734,16.289-24.578c-11.469-16.906-35.539-29.938-48-34.422\n		c-15.048-11.41-18.165-11.441-22.688-14.66c2.188-14.781-10.164-32.703-10.164-32.703s-5.781-6.578-18.508-6.641\n		c3.344,2.625,16.891,13.422,13.359,16.031C42.784,43.904,20.487,52.826,20.487,52.826s9.168,1.719,11.652,7.172\n		c2.52,5.469,11.895,26.344,22.059,36.031c3.242,3.109,9.852,8.047,18.313,11.047c20.781,7.359,50.555,25.578,56.82,33.719\n		c3.273,4.234,5.375,10.078,5.273,12.188c-0.109,2.094-2.297,4.031-5.391,3.625c-3.906-0.5-50.492-30.594-50.492-30.594\n		s-10.047-7.266-30.438-12.281C34.932,95.662-4.177,77.154-12.458,70.357z"/>\n	<path fill="#010202" d="M-14.771-11.155C-3.38-8.17-1.314,3.662-1.162,5.005c-1.211,0.344-12.145-1.969-13.32-6.199\n		C-15.564-5.108-8.763-8.057-14.771-11.155"/>\n	<path fill="none" stroke="#010202" stroke-width="3.048" d="M62.127-25.659c0,0-6.75,12-4.867,19.281\n		C59.885,3.916,72.721,11.951,72.034,26.06"/>\n	<path fill="#FFD730" d="M158.331,88.927c0,0-0.328-2.852,0.703-4.234c1-1.375,1.469-5.18,1.344-6.359\n		c-0.117-1.164,0.555-1.477-5.906-2.625c5.609-2.164,14.938,1.414,16.828,2.891c1.859,1.422,2.953,10.648,5.5,12.18\n		c-1.156,2.188-5.781,1.508-5.781,1.508L158.331,88.927z"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_5_" x="-176.306" y="-213.897" width="406.402" height="492.691"/>\n					</defs>\n					<clipPath id="SVGID_6_">\n						<use xlink:href="#SVGID_5_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_6_)" fill="none" stroke="#010202" stroke-width="3.048" d="M158.331,88.927\n						c0,0-0.328-2.852,0.703-4.234c1-1.375,1.469-5.18,1.344-6.359c-0.117-1.164,0.555-1.477-5.906-2.625\n						c5.609-2.164,14.938,1.414,16.828,2.891c1.859,1.422,2.953,10.648,5.5,12.18c-1.156,2.188-5.781,1.508-5.781,1.508\n						L158.331,88.927z"/>\n				</g>\n			</g>\n		</g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_7_" x="-176.306" y="-213.897" width="406.402" height="492.691"/>\n					</defs>\n					<clipPath id="SVGID_8_">\n						<use xlink:href="#SVGID_7_"  overflow="visible"/>\n					</clipPath>\n\n						<line clip-path="url(#SVGID_8_)" fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="7" x1="-174.548" y1="-209.881" x2="201.377" y2="180.669"/>\n				</g>\n			</g>\n		</g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_9_" x="-176.306" y="-213.897" width="406.402" height="492.691"/>\n					</defs>\n					<clipPath id="SVGID_10_">\n						<use xlink:href="#SVGID_9_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_10_)" fill="none" stroke="#010202" stroke-width="3.048" d="M26.772-212.377h201.816V84.271\n						c0,106.586-90.297,193-201.68,193c-111.406,0-201.695-86.416-201.695-193v-296.648H26.772z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/tg.svg','images/kanton/wappen/20px/Wappen_Tessin_matt.svg.png','images/kanton/wappen/50px/Wappen_Tessin_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Tessin_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Thurgau','Q12713','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(21,'TI',21,'Tessin','Tessin','Ticino',0,2,'it','Bellinzona',NULL,NULL,2812,1803,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="407.406px" height="493.888px" viewBox="-176.31 -214.37 407.406 493.888"\n	 enable-background="new -176.31 -214.37 407.406 493.888" xml:space="preserve">\n<g>\n	<path fill="#268BCC" d="M27.241-212.842h202.332V84.509c0,106.859-90.516,193.47-202.188,193.47L27.241-212.842z"/>\n	<path fill="#E8423F" d="M27.385,277.979L27.385,277.979c-111.664,0-202.168-86.609-202.168-193.47v-297.352H27.241L27.385,277.979z\n		"/>\n	<g>\n		<g>\n			<g>\n				<g>\n					<defs>\n						<rect id="SVGID_1_" x="-176.31" y="-214.37" width="407.406" height="493.888"/>\n					</defs>\n					<clipPath id="SVGID_2_">\n						<use xlink:href="#SVGID_1_"  overflow="visible"/>\n					</clipPath>\n					<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M27.241-212.842h202.332V84.509\n						c0,106.859-90.516,193.47-202.188,193.47c-111.664,0-202.168-86.609-202.168-193.47v-297.352L27.241-212.842L27.241-212.842z"\n						/>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>\n','images/kanton/wappen/svg/ti.svg','images/kanton/wappen/20px/Wappen_Thurgau_matt.svg.png','images/kanton/wappen/50px/Wappen_Thurgau_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Thurgau_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Tessin','Q12724','2014-09-16 00:00:00','2014-03-16 10:24:02','2021-02-05 20:25:09'),
(22,'VD',22,'Waadt','Vaud','Vaud',1,2,'fr','Lausanne',NULL,NULL,3212,1803,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.431px" height="492.728px" viewBox="-175.826 -214.526 406.431 492.728"\n	 enable-background="new -175.826 -214.526 406.431 492.728" xml:space="preserve">\n<g>\n	<path fill="#16A74E" d="M27.249-213.002h201.832V83.662c0,106.594-90.313,193.016-201.688,193.016\n		c-111.398,0-201.695-86.422-201.695-193.016v-296.664H27.249z"/>\n	<polygon fill="#FFFFFF" points="-174.302,19.876 -174.302,-213.002 27.249,-213.002 229.081,-213.002 229.081,19.876 	"/>\n	<path fill="#010202" d="M-123.041-185.194v4.473l1.328,0.07c2.281,0.121,3.152,0.434,3.473,0.602\n		c0.527,0.289,1.191,0.848,1.191,2.758v32.922c0,1.926-0.719,2.52-1.27,2.809c-0.344,0.191-1.234,0.504-3.387,0.574l-1.336,0.051\n		v4.5h41.891l3.297-18.23h-4.617l-0.359,0.914c-1.883,4.902-4.145,8.223-6.633,9.855c-2.543,1.648-5.762,2.496-9.559,2.496\n		c-2.715,0-3.602-0.379-3.844-0.527c-0.324-0.203-0.527-0.852-0.527-1.793v-32.146c0-3.152,0.688-3.801,0.824-3.895\n		c0.32-0.242,1.395-0.785,4.762-0.891l1.375-0.039v-4.504L-123.041-185.194L-123.041-185.194z"/>\n	<path fill="#FFD730" d="M-121.08-183.233v0.656c1.777,0.133,3.039,0.398,3.793,0.824c1.48,0.773,2.223,2.285,2.223,4.473v32.918\n		c0,2.207-0.781,3.754-2.336,4.543c-0.781,0.434-2.039,0.648-3.68,0.754v0.664h38.289c0.16-0.832,2.375-13.129,2.59-14.289h-0.949\n		c-2.023,5.098-4.449,8.633-7.242,10.449c-2.863,1.855-6.43,2.805-10.629,2.805c-2.41,0-4.012-0.27-4.883-0.82\n		c-0.949-0.602-1.457-1.77-1.457-3.465v-32.145c0-2.895,0.539-4.695,1.609-5.496c0.953-0.703,2.738-1.105,5.336-1.23v-0.641H-121.08\n		z"/>\n	<path fill="#010202" d="M-77.814-185.194v4.488l1.344,0.055c2.383,0.105,3.305,0.418,3.648,0.602\n		c0.512,0.27,1.199,0.832,1.199,2.77v32.941c0,1.938-0.746,2.535-1.297,2.824c-0.344,0.176-1.289,0.496-3.52,0.535l-1.375,0.035\n		v4.508h26.598v-4.543h-1.422c-2.313,0-3.488-0.406-4.047-0.758c-0.625-0.371-0.938-1.242-0.938-2.602v-32.953\n		c0-1.941,0.711-2.512,1.246-2.797c0.328-0.168,1.281-0.473,3.801-0.57l1.359-0.055v-4.48H-77.814z"/>\n	<path fill="#FFD730" d="M-75.853-183.233v0.648c1.832,0.117,3.133,0.367,3.941,0.789c1.496,0.777,2.25,2.297,2.25,4.504v32.945\n		c0,2.223-0.801,3.77-2.371,4.574c-0.832,0.41-2.117,0.625-3.832,0.707v0.656h22.664v-0.641c-1.965-0.051-3.469-0.367-4.52-1.008\n		c-1.238-0.746-1.855-2.191-1.855-4.289v-32.945c0-2.238,0.762-3.766,2.297-4.551c0.801-0.398,2.145-0.625,4.078-0.75v-0.641\n		h-22.652V-183.233z"/>\n	<path fill="#010202" d="M-51.294-185.194v4.473l1.328,0.07c2.246,0.129,3.113,0.434,3.406,0.609\n		c0.297,0.168,1.145,0.625,1.145,2.762v32.941c0,1.914-0.703,2.504-1.23,2.801c-0.344,0.184-1.199,0.496-3.281,0.559l-1.359,0.051\n		v4.504h23.215c6.031,0,10.953-1.258,14.641-3.754c3.855-2.594,5.832-6.063,5.832-10.305c0-4.527-2.063-8.102-6.113-10.625\n		c-1.063-0.645-2.23-1.191-3.469-1.645c1.277-0.586,2.512-1.336,3.688-2.289c2.391-1.914,3.59-4.535,3.59-7.793\n		c0-5.246-2.855-8.918-8.504-10.871c-2.801-0.984-6.359-1.48-10.512-1.48h-22.375v-0.008H-51.294z M-31.822-178.467\n		c0-0.887,0.16-1.367,0.344-1.504c0.078-0.063,0.512-0.375,2.063-0.375c2.168,0,3.563,0.625,4.234,1.91\n		c0.832,1.563,1.262,3.539,1.262,5.875c0,3.094-0.574,5.215-1.734,6.297c-0.738,0.688-2.395,1.492-6.168,1.648L-31.822-178.467\n		L-31.822-178.467z M-31.478-142.178l-0.016-0.031c-0.082-0.152-0.297-0.656-0.328-1.93v-15.574c2.75,0.047,4.816,0.414,6.109,1.152\n		c2.41,1.344,3.578,4.109,3.578,8.43c0,2.914-0.543,5.152-1.656,6.656c-1.031,1.367-2.953,2.074-5.688,2.074\n		C-31.048-141.409-31.361-141.987-31.478-142.178"/>\n	<path fill="#FFD730" d="M-49.326-183.233v0.656c1.75,0.133,2.984,0.398,3.734,0.824c1.441,0.773,2.145,2.285,2.145,4.473v32.941\n		c0,2.199-0.77,3.73-2.281,4.52c-0.766,0.426-2,0.648-3.59,0.746v0.672h21.246c5.641,0,10.184-1.152,13.543-3.418\n		c3.328-2.238,4.953-5.086,4.953-8.672c0-3.848-1.688-6.789-5.168-8.953c-1.801-1.109-3.953-1.91-6.391-2.383l-0.457-0.094v-1.555\n		l0.457-0.094c2.297-0.426,4.438-1.441,6.406-3.023c1.922-1.547,2.855-3.602,2.855-6.258c0-4.391-2.344-7.352-7.168-9.031\n		c-2.59-0.898-5.934-1.359-9.871-1.359h-20.414L-49.326-183.233L-49.326-183.233z M-33.775-178.467c0-1.406,0.328-2.422,1.031-3\n		c0.656-0.574,1.754-0.848,3.328-0.848c2.922,0,4.922,1,5.969,2.961c1,1.84,1.488,4.137,1.488,6.801\n		c0,3.646-0.785,6.254-2.344,7.734c-1.578,1.488-4.504,2.211-8.922,2.211h-0.551L-33.775-178.467L-33.775-178.467z M-33.775-144.1\n		v-17.574l0.527-0.008c3.871-0.098,6.641,0.359,8.488,1.41c3.047,1.695,4.594,5.102,4.594,10.141c0,3.344-0.688,5.977-2.051,7.824\n		c-1.438,1.906-3.855,2.863-7.262,2.863c-1.816,0-3.051-0.59-3.703-1.75C-33.56-141.842-33.767-142.788-33.775-144.1"/>\n	<path fill="#010202" d="M-6.064-185.194v4.473l1.328,0.07c2.297,0.129,3.184,0.441,3.504,0.617\n		c0.547,0.289,1.234,0.848,1.234,2.754v32.941c0,1.871-0.672,2.457-1.184,2.746c-0.348,0.207-1.266,0.543-3.516,0.613l-1.359,0.051\n		v4.504h42.301l3.344-16.93h-4.492l-0.359,0.816c-2.016,4.328-4.297,7.305-6.785,8.832c-2.512,1.535-5.84,2.32-9.902,2.32\n		c-2.801,0-3.578-0.426-3.77-0.543c-0.438-0.297-0.512-1.242-0.512-1.777v-15.016c2.688,0.16,4.594,0.758,5.625,1.848\n		c1.297,1.344,2.168,3.832,2.594,7.367l0.168,1.227h4.375v-25.707h-4.305l-0.207,1.129c-0.855,4.434-2,6.383-2.801,7.23\n		c-0.922,0.961-2.816,1.496-5.457,1.609v-14.273c0-1.008,0.199-1.383,0.281-1.453c0.031,0,0.574-0.355,3.113-0.355\n		c5.094,0,8.605,0.715,10.406,2.113c1.77,1.395,3.074,4.145,3.855,8.152l0.219,1.129h4.297v-16.488L-6.064-185.194L-6.064-185.194z"\n		/>\n	<path fill="#FFD730" d="M-4.095-183.233v0.656c1.785,0.133,3.031,0.398,3.801,0.824c1.504,0.773,2.262,2.277,2.262,4.473v32.941\n		c0,2.16-0.734,3.648-2.184,4.457c-0.832,0.48-2.145,0.719-3.871,0.816v0.672h38.723c0.164-0.809,2.344-11.824,2.578-12.992h-0.875\n		c-2.125,4.496-4.594,7.656-7.344,9.352c-2.832,1.727-6.512,2.598-10.938,2.598c-2.441,0-4.047-0.285-4.887-0.879\n		c-0.906-0.629-1.344-1.785-1.344-3.398v-17.039h0.543c4.031,0,6.855,0.848,8.473,2.543c1.512,1.609,2.504,4.238,3.031,7.984h0.719\n		v-21.793h-0.734c-0.754,3.703-1.801,6.273-3.199,7.746c-1.504,1.582-4.203,2.328-8.281,2.27h-0.543v-16.289\n		c0-1.469,0.344-2.461,1.047-3.008c0.688-0.527,2.047-0.766,4.297-0.766c5.641,0,9.438,0.824,11.621,2.527\n		c2.07,1.633,3.547,4.633,4.477,8.863h0.703v-12.559L-4.095-183.233L-4.095-183.233z"/>\n	<path fill="#010202" d="M39.409-185.194v4.434l1.281,0.109c2.852,0.242,3.539,0.688,3.641,0.785\n		c0.289,0.215,0.961,1.078,0.961,4.008v30.098c0,2.918-0.602,3.703-0.797,3.854c-0.313,0.297-1.234,0.805-3.75,0.926l-1.344,0.066\n		v4.488h25.594v-4.512l-1.359-0.051c-2.656-0.094-3.484-0.695-3.719-0.934c-0.25-0.25-0.805-1.129-0.805-3.852v-9.156\n		c3.523,4.719,13.82,18.492,13.82,18.492H89.26v-4.316l-1.328-0.105c-0.461-0.039-0.859-0.105-1.133-0.207\n		c-0.078-0.043-0.273-0.152-0.57-0.551c-0.016-0.027-9.859-13.203-13.297-17.801c1.867-0.602,3.719-1.418,5.422-2.664\n		c3.219-2.418,4.859-5.738,4.859-9.875c0-5.645-3.063-9.582-9.102-11.727c-2.945-1.008-6.82-1.504-11.469-1.504H39.409V-185.194z\n		 M59.127-178.584c0-0.395,0.07-0.93,0.328-1.145c0.016-0.016,0.492-0.371,2.711-0.371c2.813,0,4.617,0.984,5.656,3.105\n		c0.617,1.32,0.945,3.215,0.945,5.633c0,3.703-0.766,6.137-2.211,7.031c-1.492,0.914-4.016,1.449-7.43,1.609L59.127-178.584\n		L59.127-178.584z"/>\n	<path fill="#FFD730" d="M41.377-183.233v0.68c2.117,0.215,3.508,0.59,4.195,1.152c1.133,0.91,1.672,2.727,1.672,5.535v30.094\n		c0,2.715-0.453,4.449-1.406,5.328c-0.875,0.777-2.359,1.219-4.469,1.379v0.664h21.672v-0.656c-2.219-0.152-3.734-0.625-4.563-1.504\n		c-0.891-0.953-1.328-2.656-1.328-5.211v-32.813c0-1.203,0.359-2.105,1.078-2.672c0.672-0.547,1.906-0.809,3.922-0.809\n		c3.547,0,6.047,1.414,7.422,4.199c0.758,1.602,1.148,3.801,1.148,6.504c0,4.551-1.031,7.398-3.148,8.711\n		c-2.031,1.25-5.242,1.891-9.836,1.961h-0.508c0.133,0.168,1,1.273,1,1.273s15.359,20.559,15.688,21.008h13.375v-0.602\n		c-0.438-0.055-0.867-0.113-1.211-0.238c-0.523-0.195-1.031-0.625-1.461-1.242l-14.984-20.07l0.891-0.168\n		c2.328-0.434,4.578-1.418,6.672-2.945c2.719-2.031,4.047-4.75,4.047-8.289c0-4.789-2.539-8.008-7.781-9.871\n		c-2.734-0.918-6.359-1.398-10.813-1.398H41.377z"/>\n	<path fill="#010202" d="M86.784-185.194l-0.078,16.488h4.641l0.148-1.281c0.359-4.398,1.93-7.285,4.766-8.832\n		c1.313-0.703,3.195-1.125,5.578-1.305v34.344c0,2.816-0.625,3.707-0.906,3.945c-0.25,0.258-1.234,0.871-4.375,0.871h-1.406v4.527\n		h27.078v-4.527h-1.406c-3.234,0-4.203-0.59-4.492-0.855c-0.25-0.238-0.875-1.117-0.875-3.961v-34.359\n		c2.43,0.168,4.313,0.594,5.578,1.289c2.586,1.504,4.211,4.496,4.805,8.922l0.156,1.207h4.609l-0.094-16.488H86.784V-185.194z"/>\n	<path fill="#FFD730" d="M88.737-183.233c0,0.984-0.047,11.566-0.047,12.566h0.898c0.531-4.742,2.43-8.094,5.727-9.887\n		c1.836-0.992,4.508-1.535,7.883-1.633l0.578-0.016v36.414c0,2.672-0.5,4.441-1.5,5.395c-0.922,0.863-2.656,1.305-5.172,1.359v0.633\n		h23.141v-0.633c-2.586-0.047-4.344-0.488-5.281-1.352c-0.977-0.945-1.453-2.703-1.453-5.402v-36.414l0.578,0.016\n		c3.469,0.098,6.109,0.641,7.891,1.633c3.063,1.766,4.969,5.109,5.688,9.887h0.922c0-1-0.047-11.582-0.047-12.566H88.737z"/>\n	<path fill="#010202" d="M158.573-201.553c-0.523,0.375-1.016,0.832-1.438,1.375l-10.594,13.016h6.953l9.438-6.246\n		c0.953-0.625,1.688-1.227,2.203-1.832c0.672-0.754,1.016-1.746,1.016-2.961c0-1.207-0.422-2.25-1.219-3.098\n		c-0.828-0.855-1.93-1.301-3.242-1.301C160.588-202.608,159.542-202.241,158.573-201.553 M131.393-185.194v4.473l1.328,0.07\n		c2.297,0.129,3.164,0.441,3.492,0.617c0.555,0.289,1.227,0.848,1.227,2.754v32.941c0,1.871-0.656,2.457-1.164,2.746\n		c-0.359,0.207-1.266,0.543-3.531,0.613l-1.344,0.051v4.504h42.297l3.344-16.93h-4.484l-0.375,0.816\n		c-2.016,4.328-4.297,7.305-6.773,8.832c-2.523,1.535-5.836,2.32-9.898,2.32c-2.805,0-3.578-0.426-3.758-0.543\n		c-0.461-0.297-0.523-1.242-0.523-1.777v-15.016c2.672,0.16,4.594,0.758,5.625,1.848c1.297,1.344,2.141,3.832,2.602,7.367\n		l0.133,1.227h4.391v-25.707h-4.313l-0.211,1.129c-0.836,4.434-1.961,6.383-2.781,7.23c-0.938,0.961-2.836,1.496-5.461,1.609\n		v-14.273c0-1.008,0.219-1.383,0.297-1.453c0,0,0.578-0.355,3.109-0.355c5.086,0,8.594,0.715,10.383,2.113\n		c1.766,1.395,3.078,4.145,3.883,8.152l0.203,1.129h4.313v-16.488L131.393-185.194L131.393-185.194z"/>\n	<path fill="#FFD730" d="M159.706-199.944L159.706-199.944c-0.375,0.254-0.742,0.59-1.031,0.988c0,0-5.891,7.234-8,9.832h2.227\n		c0.25-0.191,8.922-5.926,8.922-5.926c0.813-0.527,1.422-1.016,1.844-1.488c0.313-0.391,0.5-0.953,0.5-1.672\n		c0-0.695-0.219-1.266-0.656-1.734c-0.438-0.473-1.047-0.699-1.828-0.699C161.002-200.643,160.362-200.417,159.706-199.944\n		 M133.346-183.233v0.656c1.805,0.133,3.063,0.398,3.836,0.824c1.453,0.766,2.242,2.27,2.242,4.461v32.945\n		c0,2.16-0.734,3.648-2.195,4.457c-0.82,0.48-2.133,0.719-3.875,0.816v0.672h38.75c0.156-0.809,2.313-11.824,2.547-12.992h-0.859\n		c-2.125,4.496-4.594,7.656-7.344,9.352c-2.844,1.727-6.516,2.598-10.938,2.598c-2.453,0-4.047-0.285-4.906-0.879\n		c-0.883-0.633-1.328-1.785-1.328-3.396v-17.039h0.563c4,0,6.844,0.848,8.453,2.543c1.531,1.609,2.508,4.238,3.039,7.984h0.688\n		v-21.785h-0.703c-0.773,3.703-1.82,6.273-3.203,7.746c-1.508,1.582-4.195,2.328-8.258,2.27h-0.563v-16.289\n		c0-1.469,0.344-2.461,1.047-3.008c0.672-0.527,2.047-0.766,4.313-0.766c5.609,0,9.406,0.824,11.609,2.527\n		c2.063,1.633,3.578,4.633,4.438,8.863h0.766v-12.559H133.346L133.346-183.233z"/>\n	<path fill="#010202" d="M-17.998-123.772v4.473l1.313,0.074c2.309,0.137,3.199,0.445,3.512,0.609\n		c0.527,0.285,1.246,0.863,1.246,2.758v32.938c0,1.871-0.688,2.469-1.184,2.75c-0.359,0.199-1.281,0.535-3.527,0.617l-1.359,0.047\n		v4.496h42.293l3.344-16.918h-4.47l-0.379,0.813c-2.016,4.336-4.293,7.305-6.781,8.836c-2.512,1.535-5.84,2.301-9.891,2.301\n		c-2.816,0-3.59-0.398-3.781-0.52c-0.441-0.313-0.512-1.246-0.512-1.793V-97.28c2.688,0.164,4.605,0.766,5.637,1.855\n		c1.266,1.352,2.16,3.832,2.578,7.367l0.16,1.23h4.391v-25.734h-4.297l-0.215,1.152c-0.855,4.43-1.984,6.375-2.801,7.223\n		c-0.902,0.961-2.816,1.504-5.453,1.617v-14.289c0-1.016,0.215-1.398,0.293-1.465c0.016-0.016,0.578-0.352,3.098-0.352\n		c5.113,0,8.594,0.711,10.406,2.113c1.785,1.398,3.082,4.145,3.875,8.152l0.199,1.129h4.297v-16.492h-41.992V-123.772z"/>\n	<path fill="#FFD730" d="M-16.033-121.803v0.656c1.785,0.129,3.035,0.395,3.816,0.816c1.488,0.77,2.234,2.289,2.234,4.473v32.938\n		c0,2.168-0.723,3.656-2.168,4.477c-0.816,0.449-2.145,0.715-3.871,0.809v0.664h38.719c0.168-0.801,2.344-11.824,2.559-13h-0.84\n		c-2.145,4.504-4.605,7.664-7.375,9.354c-2.816,1.727-6.488,2.598-10.906,2.598c-2.453,0-4.047-0.289-4.902-0.879\n		c-0.887-0.633-1.344-1.77-1.344-3.402v-17.039h0.574c4,0,6.832,0.855,8.441,2.551c1.527,1.594,2.512,4.234,3.047,7.977h0.688\n		v-21.79h-0.734c-0.734,3.719-1.785,6.277-3.184,7.75c-1.504,1.578-4.184,2.328-8.281,2.281l-0.543-0.008v-16.281\n		c0-1.48,0.344-2.473,1.063-3.023c0.672-0.512,2.035-0.77,4.281-0.77c5.641,0,9.441,0.832,11.609,2.543\n		c2.094,1.625,3.574,4.625,4.473,8.852h0.734v-12.555h-38.09V-121.803z"/>\n	<path fill="#010202" d="M28.112-123.772l-0.078,16.492h4.641l0.125-1.271c0.383-4.41,1.938-7.297,4.789-8.84\n		c1.297-0.695,3.18-1.137,5.578-1.297v34.336c0,2.816-0.641,3.695-0.906,3.945c-0.281,0.27-1.266,0.863-4.391,0.863h-1.398v4.527\n		h27.07v-4.527h-1.391c-3.234,0-4.219-0.594-4.516-0.84c-0.227-0.25-0.852-1.129-0.852-3.969v-34.344\n		c2.43,0.168,4.313,0.598,5.547,1.297c2.602,1.496,4.242,4.488,4.836,8.902l0.156,1.219h4.594l-0.078-16.492H28.112L28.112-123.772z\n		"/>\n	<path fill="#FFD730" d="M30.065-121.803c0,0.969-0.047,11.563-0.063,12.555H30.9c0.531-4.746,2.445-8.098,5.719-9.875\n		c1.859-1,4.516-1.551,7.906-1.629l0.578-0.027v36.418c0,2.672-0.5,4.434-1.5,5.375c-0.938,0.879-2.672,1.32-5.188,1.387v0.621\n		h23.141V-77.6c-2.57-0.066-4.328-0.508-5.266-1.363c-0.977-0.941-1.484-2.703-1.484-5.398v-36.418l0.578,0.027\n		c3.484,0.078,6.141,0.629,7.922,1.629c3.063,1.746,4.953,5.098,5.688,9.875h0.922c0-0.992-0.047-11.586-0.047-12.555H30.065z"/>\n	<path fill="#010202" d="M-96.623-62.331v4.375l1.246,0.145c2.504,0.281,3.402,0.77,3.707,1.031c0.086,0.066,0.68,0.691,0.68,3.771\n		v30.098c0,2.75-0.512,3.574-0.738,3.813c-0.238,0.234-1.055,0.801-3.59,0.984l-1.305,0.098v4.441h25.359v-4.488l-1.352-0.051\n		c-2.504-0.094-3.426-0.604-3.746-0.902c-0.184-0.184-0.797-0.984-0.797-3.887v-11.313c3.367-0.016,6.047-0.113,7.895-0.281\n		c2.176-0.184,4.391-0.75,6.559-1.625c3.02-1.313,5.211-3.094,6.547-5.293c1.313-2.184,1.969-4.527,1.969-7.02\n		c0-5.078-1.738-8.734-5.195-10.871c-3.223-2.016-7.934-3.016-13.957-3.016h-23.281L-96.623-62.331L-96.623-62.331z M-77.158-56.28\n		c0-0.348,0.055-0.609,0.152-0.656c0.176-0.098,0.727-0.313,2.23-0.313c2.414,0,3.961,0.703,4.762,2.141\n		c0.91,1.707,1.383,4,1.383,6.844c0,4.031-0.863,6.621-2.57,7.719c-0.695,0.438-2.277,0.969-5.949,1.145v-16.88H-77.158z"/>\n	<path fill="#FFD730" d="M-94.654-60.37v0.688c2.063,0.266,3.473,0.719,4.277,1.426c0.914,0.797,1.344,2.512,1.344,5.246v30.098\n		c0,2.574-0.414,4.277-1.285,5.184c-0.816,0.816-2.234,1.313-4.336,1.504v0.672h21.414v-0.641c-2.121-0.16-3.598-0.594-4.473-1.406\n		c-0.934-0.906-1.414-2.625-1.414-5.313v-13.25h0.574c4.008,0,7.074-0.094,9.105-0.281c1.992-0.164,4.008-0.672,6.016-1.5\n		c2.578-1.129,4.465-2.656,5.578-4.492c1.133-1.855,1.695-3.871,1.695-6c0-4.422-1.379-7.422-4.266-9.199\n		c-2.918-1.816-7.273-2.734-12.918-2.734h-21.311V-60.37z M-79.126-56.28c0-1.164,0.398-1.953,1.176-2.379\n		c0.68-0.375,1.719-0.559,3.168-0.559c3.16,0,5.328,1.078,6.48,3.168c1.094,1.984,1.633,4.605,1.633,7.785\n		c0,4.734-1.168,7.887-3.496,9.375c-1.449,0.918-4.195,1.422-8.395,1.504h-0.574V-56.28H-79.126z"/>\n	<path fill="#010202" d="M-37.775-63.331l-15.391,38.129c-1.426,3.527-2.184,4.887-2.578,5.422\n		c-0.766,1.051-1.688,1.578-2.926,1.656l-1.305,0.098v4.441h16.664V-18.1l-1.375-0.016c-1.754-0.016-2.641-0.199-3.082-0.344\n		c-0.984-0.328-0.984-0.656-0.984-0.781c0-0.359,0.113-1.281,0.84-3.375c-0.016,0.016,1.031-2.836,1.578-4.328h13.359\n		c0.438,1.078,1.344,3.246,1.344,3.246l0.855,2.246c0.406,1.25,0.457,1.801,0.457,1.969c0,0.625-0.129,0.855-0.16,0.891\n		c-0.266,0.109-1.129,0.359-3.891,0.469l-1.359,0.051v4.488h24.816v-4.578l-1.457,0.047c-1.078,0.035-1.84-0.328-2.391-1.109\n		c-0.543-0.719-1.609-2.625-3.672-7.488l-15.512-36.609h-3.832v-0.01H-37.775z M-39.853-43.659\n		c1.293,3.113,3.652,8.801,4.652,11.234h-9.031C-43.31-34.827-41.095-40.514-39.853-43.659"/>\n	<path fill="#FFD730" d="M-36.439-61.354c-0.281,0.688-14.902,36.887-14.902,36.887c-1.234,3.031-2.168,4.938-2.832,5.84\n		c-0.984,1.363-2.281,2.129-3.848,2.363v0.703h12.75v-0.641c-1.313-0.047-2.375-0.16-3.098-0.391\n		c-1.934-0.656-2.359-1.816-2.359-2.656c0-0.875,0.313-2.168,0.938-4c0-0.016,2.063-5.688,2.063-5.688h0.395h15.656l1.871,4.484\n		l0.887,2.363c0.375,1.16,0.543,2.016,0.543,2.605c0,1.426-0.453,2.344-1.375,2.723c-0.703,0.277-2.031,0.469-4.016,0.574v0.625\n		h20.871v-0.641c-1.473-0.098-2.641-0.719-3.488-1.871c-0.855-1.199-2.145-3.785-3.871-7.871c0,0-13.543-32-15-35.41h-1.185V-61.354\n		z M-40.509-47.37h1.23l7.031,16.902h-14.871L-40.509-47.37z"/>\n	<path fill="#010202" d="M-15.326-62.331l-0.082,16.473h4.656l0.113-1.266c0.391-4.406,1.934-7.293,4.801-8.84\n		c1.293-0.703,3.168-1.125,5.543-1.309v34.344c0,2.813-0.609,3.703-0.855,3.949c-0.281,0.25-1.281,0.871-4.41,0.871h-1.422v4.516\n		h27.094v-4.516h-1.406c-3.215,0-4.199-0.605-4.488-0.855c-0.25-0.23-0.855-1.125-0.855-3.965v-34.344\n		c2.422,0.164,4.297,0.605,5.559,1.293c2.609,1.488,4.215,4.488,4.801,8.922l0.16,1.199h4.59l-0.078-16.473L-15.326-62.331\n		L-15.326-62.331z"/>\n	<path fill="#FFD730" d="M-13.376-60.37c0,0.984-0.047,11.559-0.047,12.543h0.906c0.527-4.734,2.438-8.078,5.719-9.855\n		c1.84-1,4.504-1.559,7.902-1.641l0.563-0.016v36.41c0,2.672-0.488,4.422-1.504,5.375c-0.922,0.871-2.641,1.313-5.184,1.375v0.625\n		h23.156v-0.609c-2.59-0.063-4.344-0.504-5.262-1.375c-1-0.938-1.473-2.703-1.473-5.391v-36.41l0.559,0.016\n		c3.488,0.082,6.145,0.641,7.906,1.641c3.078,1.754,4.969,5.098,5.703,9.855h0.922c-0.02-0.984-0.066-11.559-0.066-12.543H-13.376z"\n		/>\n	<path fill="#010202" d="M29.409-62.331v4.41l1.281,0.109c2.852,0.25,3.523,0.703,3.641,0.785c0.289,0.23,0.945,1.098,0.945,4.016\n		v30.098c0,2.934-0.586,3.703-0.781,3.871c-0.328,0.297-1.25,0.801-3.766,0.918l-1.32,0.066v4.473h25.594v-4.488l-1.367-0.051\n		c-2.672-0.109-3.5-0.703-3.719-0.934c-0.242-0.266-0.797-1.129-0.797-3.855v-9.16c3.516,4.734,13.813,18.488,13.813,18.488h16.313\n		v-4.328l-1.313-0.082c-0.469-0.031-0.852-0.113-1.141-0.215c-0.094-0.031-0.297-0.145-0.563-0.543\n		c-0.031-0.035-9.867-13.203-13.313-17.816c1.875-0.594,3.719-1.41,5.445-2.656c3.211-2.41,4.852-5.719,4.852-9.875\n		c0-5.637-3.063-9.574-9.094-11.734c-2.969-1-6.828-1.488-11.484-1.488H29.409V-62.331z M49.127-55.713\n		c0-0.41,0.055-0.922,0.313-1.16c0.016-0.016,0.508-0.375,2.711-0.375c2.828,0,4.617,0.984,5.648,3.109\n		c0.641,1.328,0.953,3.219,0.953,5.625c0,3.719-0.766,6.16-2.195,7.047c-1.508,0.922-4.016,1.441-7.43,1.594V-55.713z"/>\n	<path fill="#FFD730" d="M31.362-60.37v0.672c2.109,0.215,3.508,0.59,4.195,1.146c1.148,0.918,1.688,2.734,1.688,5.543v30.098\n		c0,2.719-0.469,4.453-1.422,5.328c-0.859,0.766-2.344,1.215-4.469,1.375v0.656h21.672v-0.641c-2.203-0.16-3.719-0.641-4.547-1.512\n		c-0.906-0.938-1.328-2.641-1.328-5.199v-32.801c0-1.215,0.344-2.145,1.047-2.688c0.688-0.543,1.938-0.816,3.938-0.816\n		c3.563,0,6.063,1.422,7.422,4.215c0.773,1.609,1.164,3.785,1.164,6.488c0,4.563-1.031,7.426-3.148,8.719\n		c-2.031,1.234-5.242,1.891-9.852,1.953c0,0-0.391,0-0.508,0c0.117,0.168,0.984,1.281,0.984,1.281s15.391,20.559,15.719,21h13.359\n		v-0.586c-0.438-0.063-0.867-0.125-1.195-0.246c-0.523-0.215-1.031-0.625-1.461-1.25L59.604-37.698l0.906-0.168\n		c2.328-0.426,4.594-1.406,6.688-2.953c2.719-2.031,4.031-4.734,4.031-8.281c0-4.797-2.539-8.016-7.766-9.871\n		c-2.734-0.918-6.375-1.391-10.828-1.391H31.362V-60.37z"/>\n	<path fill="#010202" d="M78.456-62.331v4.473l1.328,0.047c2.383,0.129,3.313,0.441,3.656,0.594c0.508,0.281,1.18,0.855,1.18,2.781\n		v32.938c0,1.938-0.734,2.543-1.273,2.832c-0.359,0.168-1.313,0.504-3.508,0.543l-1.383,0.035v4.504h26.578v-4.531h-1.414\n		c-2.328,0-3.484-0.422-4.063-0.766c-0.609-0.359-0.922-1.234-0.922-2.609v-32.934c0-1.938,0.727-2.531,1.234-2.801\n		c0.344-0.16,1.297-0.457,3.82-0.578l1.344-0.047v-4.473H78.456V-62.331z"/>\n	<path fill="#FFD730" d="M80.424-60.37v0.656c1.82,0.098,3.133,0.359,3.922,0.77c1.492,0.781,2.258,2.309,2.258,4.508v32.938\n		c0,2.234-0.797,3.785-2.359,4.578c-0.836,0.406-2.141,0.621-3.828,0.719v0.641h22.625v-0.625c-1.938-0.063-3.438-0.375-4.5-1.016\n		c-1.234-0.754-1.859-2.184-1.859-4.297v-32.938c0-2.23,0.781-3.766,2.297-4.543c0.797-0.391,2.156-0.637,4.063-0.734v-0.656\n		L80.424-60.37L80.424-60.37z"/>\n	<path fill="#010202" d="M104.854-62.331v4.457l1.328,0.063c2.289,0.145,3.164,0.457,3.484,0.625c0.563,0.281,1.25,0.855,1.25,2.75\n		v32.938c0,1.871-0.672,2.473-1.188,2.754c-0.359,0.199-1.266,0.543-3.531,0.621l-1.344,0.051v4.488h42.328l3.328-16.922h-4.484\n		l-0.406,0.832c-1.984,4.328-4.266,7.297-6.766,8.816c-2.508,1.527-5.836,2.313-9.875,2.313c-2.813,0-3.609-0.391-3.766-0.512\n		c-0.461-0.328-0.531-1.266-0.531-1.801v-15c2.672,0.168,4.594,0.785,5.641,1.855c1.266,1.344,2.156,3.832,2.578,7.375l0.156,1.234\n		h4.391v-25.738h-4.297l-0.219,1.16c-0.828,4.426-1.984,6.363-2.797,7.219c-0.922,0.965-2.828,1.504-5.453,1.621v-14.285\n		c0-1.02,0.234-1.41,0.297-1.473c0,0,0.563-0.359,3.109-0.359c5.094,0,8.578,0.719,10.391,2.125\n		c1.766,1.395,3.078,4.129,3.844,8.145l0.25,1.129h4.281v-16.473h-42L104.854-62.331L104.854-62.331z"/>\n	<path fill="#FFD730" d="M106.799-60.37v0.656c1.805,0.129,3.07,0.406,3.82,0.801c1.5,0.797,2.266,2.297,2.266,4.488v32.934\n		c0,2.16-0.734,3.656-2.188,4.473c-0.813,0.473-2.141,0.703-3.891,0.816v0.656h38.734c0.164-0.801,2.344-11.816,2.563-12.984h-0.844\n		c-2.125,4.512-4.602,7.672-7.375,9.359c-2.813,1.719-6.484,2.594-10.898,2.594c-2.477,0-4.055-0.297-4.906-0.875\n		c-0.898-0.637-1.375-1.781-1.375-3.406v-17.031h0.57c4.016,0,6.859,0.855,8.477,2.543c1.508,1.609,2.508,4.25,3.031,7.984h0.727\n		v-21.801h-0.742c-0.766,3.719-1.805,6.281-3.195,7.77c-1.508,1.559-4.203,2.313-8.281,2.262h-0.578v-16.285\n		c0-1.488,0.359-2.473,1.078-3.02c0.672-0.527,2.047-0.781,4.313-0.781c5.609,0,9.406,0.84,11.578,2.543\n		c2.094,1.625,3.578,4.625,4.5,8.84h0.719v-12.543H106.8L106.799-60.37L106.799-60.37z"/>\n	<g>\n		<path fill="none" stroke="#010202" stroke-width="3.048" d="M-174.318,19.912h403.43 M27.249-213.002h201.832V83.662\n			c0,106.594-90.313,193.016-201.688,193.016c-111.398,0-201.695-86.422-201.695-193.016v-296.664H27.249z"/>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/vd.svg','images/kanton/wappen/20px/Wappen_Uri_matt.svg.png','images/kanton/wappen/50px/Wappen_Uri_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Uri_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Waadt','Q12771','2014-09-16 00:00:00','2014-03-16 10:24:03','2021-02-05 20:25:09'),
(23,'VS',23,'Wallis','Valais','Vallese',1,2,'fr','Sitten',NULL,NULL,5224,1815,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.794px" height="493.177px" viewBox="-176.752 -214.492 406.794 493.177"\n	 enable-background="new -176.752 -214.492 406.794 493.177" xml:space="preserve">\n<g>\n	<path fill="#E8423F" d="M26.506-212.967h202.012V83.958c0,106.703-90.391,193.203-201.867,193.203L26.506-212.967z"/>\n	<path fill="#FFFFFF" d="M26.651,277.163L26.651,277.163c-111.504,0-201.879-86.5-201.879-193.204v-296.926H26.506L26.651,277.163z"\n		/>\n	<polygon fill="#FFFFFF" points="139.799,-167.901 153.37,-131.006 189.487,-131.006 160.963,-111.452 171.815,-76.436\n		139.799,-97.069 108.042,-76.436 118.877,-111.717 90.127,-131.006 126.221,-131.006 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="139.799,-167.901 153.37,-131.006 189.487,-131.006\n		160.963,-111.452 171.815,-76.436 139.799,-97.069 108.042,-76.436 118.877,-111.717 90.127,-131.006 126.221,-131.006 	"/>\n	<polygon fill="#FFFFFF" points="139.799,-78.151 153.37,-41.221 189.487,-41.221 160.963,-21.694 171.815,13.322 139.799,-7.303\n		108.042,13.322 118.877,-21.959 90.127,-41.221 126.221,-41.221 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="139.799,-78.151 153.37,-41.221 189.487,-41.221\n		160.963,-21.694 171.815,13.322 139.799,-7.303 108.042,13.322 118.877,-21.959 90.127,-41.221 126.221,-41.221 	"/>\n	<polygon fill="#FFFFFF" points="139.799,11.603 153.37,48.521 189.487,48.521 160.963,68.076 171.815,103.091 139.799,82.466\n		108.042,103.091 118.877,67.81 90.127,48.521 126.221,48.521 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="139.799,11.603 153.37,48.521 189.487,48.521 160.963,68.076\n		171.815,103.091 139.799,82.466 108.042,103.091 118.877,67.81 90.127,48.521 126.221,48.521 	"/>\n	<polygon fill="#FFFFFF" points="139.799,101.38 153.37,138.287 189.487,138.287 160.963,157.833 171.815,192.833 139.799,172.208\n		108.042,192.833 118.877,157.552 90.127,138.287 126.221,138.287 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="139.799,101.38 153.37,138.287 189.487,138.287\n		160.963,157.833 171.815,192.833 139.799,172.208 108.042,192.833 118.877,157.552 90.127,138.287 126.221,138.287 	"/>\n	<polygon fill="#E8423F" points="-86.47,-167.901 -72.9,-131.006 -36.806,-131.006 -65.302,-111.452 -54.447,-76.436\n		-86.47,-97.069 -118.228,-76.436 -107.373,-111.717 -136.15,-131.006 -100.052,-131.006 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="-86.47,-167.901 -72.9,-131.006 -36.806,-131.006\n		-65.302,-111.452 -54.447,-76.436 -86.47,-97.069 -118.228,-76.436 -107.373,-111.717 -136.15,-131.006 -100.052,-131.006 	"/>\n	<polygon fill="#E8423F" points="-86.47,-78.151 -72.9,-41.221 -36.806,-41.221 -65.302,-21.694 -54.447,13.322 -86.47,-7.303\n		-118.228,13.322 -107.373,-21.959 -136.15,-41.221 -100.052,-41.221 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="-86.47,-78.151 -72.9,-41.221 -36.806,-41.221\n		-65.302,-21.694 -54.447,13.322 -86.47,-7.303 -118.228,13.322 -107.373,-21.959 -136.15,-41.221 -100.052,-41.221 	"/>\n	<polygon fill="#E8423F" points="-86.47,11.603 -72.9,48.521 -36.806,48.521 -65.302,68.076 -54.447,103.091 -86.47,82.466\n		-118.228,103.091 -107.373,67.81 -136.15,48.521 -100.052,48.521 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="-86.47,11.603 -72.9,48.521 -36.806,48.521 -65.302,68.076\n		-54.447,103.091 -86.47,82.466 -118.228,103.091 -107.373,67.81 -136.15,48.521 -100.052,48.521 	"/>\n	<polygon fill="#E8423F" points="-86.47,101.38 -72.9,138.287 -36.806,138.287 -65.302,157.833 -54.447,192.833 -86.47,172.208\n		-118.228,192.833 -107.373,157.552 -136.15,138.287 -100.052,138.287 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="-86.47,101.38 -72.9,138.287 -36.806,138.287 -65.302,157.833\n		-54.447,192.833 -86.47,172.208 -118.228,192.833 -107.373,157.552 -136.15,138.287 -100.052,138.287 	"/>\n	<polygon fill="#E8423F" points="26.588,-126.862 -5.431,-106.495 5.452,-141.51 -23.068,-161.053 13.042,-161.053 26.588,-197.694\n			"/>\n	<polygon fill="#FFFFFF" points="26.588,-197.694 40.159,-160.772 76.276,-160.772 47.502,-141.51 58.635,-106.221 26.588,-126.862\n			"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="26.588,-197.694 40.159,-160.772 76.276,-160.772\n		47.502,-141.51 58.635,-106.221 26.588,-126.862 -5.431,-106.495 5.452,-141.51 -23.068,-161.053 13.042,-161.053 	"/>\n	<polygon fill="#E8423F" points="26.588,-37.1 -5.431,-16.741 5.452,-51.756 -23.068,-71.295 13.042,-71.295 26.588,-107.936 	"/>\n	<polygon fill="#FFFFFF" points="26.588,-107.936 40.159,-71.022 76.276,-71.022 47.502,-51.756 58.635,-16.479 26.588,-37.1 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="26.588,-107.936 40.159,-71.022 76.276,-71.022\n		47.502,-51.756 58.635,-16.479 26.588,-37.1 -5.431,-16.741 5.452,-51.756 -23.068,-71.295 13.042,-71.295 	"/>\n	<polygon fill="#E8423F" points="26.588,52.662 -5.431,73.021 5.452,38.021 -23.068,18.466 13.042,18.466 26.588,-18.167 	"/>\n	<polygon fill="#FFFFFF" points="26.588,-18.167 40.159,18.748 76.276,18.748 47.502,38.021 58.635,73.287 26.588,52.662 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="26.588,-18.167 40.159,18.748 76.276,18.748 47.502,38.021\n		58.635,73.287 26.588,52.662 -5.431,73.021 5.452,38.021 -23.068,18.466 13.042,18.466 	"/>\n	<polygon fill="#E8423F" points="26.588,142.435 -5.431,162.794 5.452,127.779 -23.068,108.224 13.042,108.224 26.588,71.568 	"/>\n	<polygon fill="#FFFFFF" points="26.588,71.568 40.159,108.49 76.276,108.49 47.502,127.779 58.635,163.052 26.588,142.435 	"/>\n	<polygon fill="none" stroke="#010202" stroke-width="3.048" points="26.588,71.568 40.159,108.49 76.276,108.49 47.502,127.779\n		58.635,163.052 26.588,142.435 -5.431,162.794 5.452,127.779 -23.068,108.224 13.042,108.224 	"/>\n	<polygon fill="#FFFFFF" points="26.588,161.349 40.159,198.255 76.276,198.255 47.502,217.521 58.635,252.81 26.588,232.177 	"/>\n	<polygon fill="#E8423F" points="26.588,232.177 -5.431,252.551 5.452,217.521 -23.068,197.974 13.042,197.974 26.588,161.349 	"/>\n	<g>\n		<path fill="none" stroke="#010202" stroke-width="3.048" d="M26.506-212.967l0.145,490.129 M26.506-212.967h202.012V83.958\n			c0,106.703-90.391,193.203-201.867,193.203c-111.504,0-201.879-86.5-201.879-193.203v-296.926L26.506-212.967L26.506-212.967z\n			 M26.588,161.349l13.57,36.906h36.117l-28.789,19.266l11.148,35.28l-32.047-20.625l-32.02,20.375l10.875-35.03l-28.512-19.547\n			h36.109L26.588,161.349z"/>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/vs.svg','images/kanton/wappen/20px/Wappen_Waadt_matt.svg.png','images/kanton/wappen/50px/Wappen_Waadt_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Waadt_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Wallis','Q834','2014-09-16 00:00:00','2014-03-16 10:24:03','2021-02-05 20:25:09'),
(24,'NE',24,'Neuenburg','Neuchâtel','Neuchâtel',1,2,'fr','Neuenburg',NULL,NULL,803,1815,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.469px" height="492.748px" viewBox="0 0 406.469 492.748" enable-background="new 0 0 406.469 492.748"\n	 xml:space="preserve">\n<g>\n	<g>\n		<g>\n			<g>\n				<g>\n					<path fill="#FFFFFF" d="M203.086,1.565h201.839v296.668c0,106.594-90.281,193.047-201.703,193.047\n						c-111.406,0-201.711-86.453-201.711-193.047V1.565H203.086z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<g>\n		<g>\n			<g>\n				<g>\n					<path fill="#E8423F" d="M274.115,1.748v477.259c76.164-27.384,130.414-97.538,130.805-179.905V1.746L274.115,1.748\n						L274.115,1.748z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<g>\n		<g>\n			<g>\n				<g>\n					<path fill="#16A74E" d="M1.52,1.756v296.477c0,85.461,58.031,157.922,138.43,183.313V1.757L1.52,1.756L1.52,1.756z"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<g>\n		<g>\n			<g>\n				<g>\n					<polygon fill="#FFFFFF" points="393.559,59.955 346.365,59.955 346.365,12.526 332.332,12.526 332.332,59.955 285.99,59.955\n						285.99,73.998 332.332,73.998 332.332,119.877 346.365,119.877 346.365,73.998 393.559,73.998 					"/>\n				</g>\n			</g>\n		</g>\n	</g>\n	<g>\n		<g>\n			<g>\n				<g>\n					<g>\n						<g>\n							<g>\n								<g>\n									<g>\n										<g>\n											<defs>\n												<rect id="SVGID_1_" y="0.014" width="406.457" height="492.734"/>\n											</defs>\n											<clipPath id="SVGID_2_">\n												<use xlink:href="#SVGID_1_"  overflow="visible"/>\n											</clipPath>\n											<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M203.086,1.533h201.839v296.668\n												c0,106.609-90.281,193.031-201.703,193.031c-111.406,0-201.711-86.422-201.711-193.031V1.533H203.086z"/>\n										</g>\n									</g>\n								</g>\n							</g>\n						</g>\n					</g>\n				</g>\n			</g>\n		</g>\n	</g>\n</g>\n</svg>','images/kanton/wappen/svg/ne.svg','images/kanton/wappen/20px/Wappen_Wallis_matt.svg.png','images/kanton/wappen/50px/Wappen_Wallis_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Wallis_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Neuenburg','Q12738','2014-09-16 00:00:00','2014-03-16 10:24:03','2021-02-05 20:25:09'),
(25,'GE',25,'Genf','Genève','Ginevra',1,2,'fr','Genf',NULL,NULL,282,1815,'\n<!-- Created with Inkscape (http://www.inkscape.org/) -->\n\n<svg\n   xmlns:dc="http://purl.org/dc/elements/1.1/"\n   xmlns:cc="http://creativecommons.org/ns#"\n   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"\n   xmlns:svg="http://www.w3.org/2000/svg"\n   xmlns="http://www.w3.org/2000/svg"\n   xmlns:xlink="http://www.w3.org/1999/xlink"\n   version="1.1"\n   width="406.539"\n   height="492.82401"\n   viewBox="-175.626 -214.155 406.539 492.824"\n   id="Ebene_1"\n   xml:space="preserve"><metadata\n   id="metadata405"><rdf:RDF><cc:Work\n       rdf:about=""><dc:format>image/svg+xml</dc:format><dc:type\n         rdf:resource="http://purl.org/dc/dcmitype/StillImage" /><dc:title></dc:title></cc:Work></rdf:RDF></metadata><defs\n   id="defs403"><defs\n     id="defs163">\n									<rect\n   width="406.539"\n   height="492.82401"\n   x="-175.62601"\n   y="-214.155"\n   id="SVGID_7_" />\n								</defs><clipPath\n     id="SVGID_8_">\n									<use\n   id="use167"\n   style="overflow:visible"\n   x="0"\n   y="0"\n   width="406.539"\n   height="492.82401"\n   xlink:href="#SVGID_7_" />\n								</clipPath></defs>\n<g\n   id="g5">\n		<path\n   d="M 27.502,-212.635 H 229.404 V 84.091 c 0,106.609 -90.328,193.047 -201.773,193.047 l -0.129,-489.773 z"\n   id="path7"\n   style="fill:#e8423f" />\n	</g><path\n   d="m 174.788,-132.315 0,27.168 18.867,0 0,16.199 -18.867,0 0,27.168 -16.493,0 0,-27.168 -18.851,0 0,-16.199 18.851,0 0,-27.168 z m 23.078,91.973 0,-19.328 19.742,0 0,-9.157 0,-65.851 -19.742,0 0,-19.071 19.742,0 0,-26.257 -29.609,-0.055 0,17.922 -24.836,0.293 0,-18.285 -29.883,0 0,45.453 -20.344,0 -0.102,75.008 20.446,0 0,45.843 29.883,0 0,-18.433 24.836,-0.305 0,18.457 29.609,0.031 0,-26.265 z"\n   id="polygon37"\n   style="fill:#ffd134;fill-opacity:1;stroke:#010202;stroke-width:3.26399994" /><path\n   d="m 121.163,-183.717 c 0,-2.945 -1.477,-5.559 -3.656,-7.199 -0.461,-4.543 -4.266,-8.105 -8.922,-8.105 -4.625,0 -8.391,3.496 -8.875,7.992 -2.297,1.625 -3.75,4.305 -3.75,7.313 0,0.242 -0.016,0.488 0,0.711 V 88.607 h 25.203 v -271.828 -0.496 z M 96.499,74.4075 c -0.047,13.125 0.6015,54.2345 -37.5625,68.8125 l -0.03125,24.96875 c 38.141,14.609 37.7655,47.35925 37.8125,60.53125 l 23.65625,0 c 0.031,-13.172 -1.68725,-45.9535 36.46875,-60.5625 l 0,-24.84375 C 118.68575,128.73575 120.405,87.5325 120.374,74.4075 l -23.875,0 z m 11.46875,59.40625 c 5.898,0 10.656,4.703 10.75,10.5 5.82,0.149 10.5,4.84325 10.5,10.65625 0,5.812 -4.679,10.56225 -10.5,10.65625 -0.125,5.797 -4.883,10.4375 -10.75,10.4375 -5.852,0 -10.60975,-4.6405 -10.71875,-10.4375 -5.82,-0.141 -10.46875,-4.85925 -10.46875,-10.65625 0,-5.797 4.64875,-10.50025 10.46875,-10.65625 0.047,-5.813 4.85175,-10.5 10.71875,-10.5 z"\n   id="path95"\n   style="fill:#ffd134;fill-opacity:1;stroke:#010202;stroke-width:3.0480001;stroke-miterlimit:10" /><g\n   id="g9">\n		<path\n   d="m 27.631,277.138 0,0 c -111.41,0 -201.73,-86.438 -201.73,-193.047 V -212.636 H 27.502 l 0.129,489.774 z"\n   id="path11"\n   style="fill:#ffd134" />\n	</g><line\n   stroke-miterlimit="10"\n   x1="213.55299"\n   y1="103.435"\n   x2="213.55299"\n   y2="103.435"\n   id="line41"\n   style="fill:#ffd134;fill-opacity:1;stroke:#010202;stroke-width:2.77600002;stroke-linecap:square;stroke-miterlimit:10" /><path\n   d="m 284.03125,301.5 c -0.1073,13.77069 -6.88799,55.23566 -49.25,67.40625 -0.55232,-4.61762 -4.86532,-8.23275 -10.09375,-8.21875 -5.609,0 -10.1875,4.13275 -10.1875,9.21875 0,5.086 4.5785,9.21875 10.1875,9.21875 5.34465,0 9.73414,-3.75573 10.125,-8.53125 52.8486,14.05113 47.97111,61.08204 49.21875,64.34375 0.52689,-6.9571 1.9133,-55.2445 47.90625,-64.5625 0.272,4.86588 4.70581,8.75 10.125,8.75 5.633,0 10.125,-4.11675 10.125,-9.21875 0,-5.086 -4.492,-9.23375 -10.125,-9.21875 -5.24438,0 -9.57372,3.63557 -10.09375,8.28125 C 293.05168,358.38672 283.62028,317.68259 284.03125,301.5 z m -0.4375,46.46875 c 5.898,0 10.656,4.703 10.75,10.5 5.82,0.149 10.5,4.84325 10.5,10.65625 0,5.812 -4.679,10.56225 -10.5,10.65625 -0.125,5.797 -4.883,10.4375 -10.75,10.4375 -5.852,0 -10.60975,-4.6405 -10.71875,-10.4375 -5.82,-0.141 -10.46875,-4.85925 -10.46875,-10.65625 0,-5.797 4.64875,-10.50025 10.46875,-10.65625 0.047,-5.813 4.85175,-10.5 10.71875,-10.5 z m 0.4375,88.625 c -5.641,0 -10.1875,4.133 -10.1875,9.25 0,5.071 4.5465,9.21875 10.1875,9.21875 5.617,0 10.15625,-4.14075 10.15625,-9.21875 0,-5.117 -4.53925,-9.258 -10.15625,-9.25 z"\n   transform="translate(-175.626,-214.155)"\n   id="path73"\n   style="fill:#ffd134;fill-opacity:1;stroke:#010202;stroke-width:3.0480001;stroke-linecap:square;stroke-miterlimit:10" /><path\n   d="m 123.077,231.755 c 0.133,0 0.219,0.016 0.352,0.016 3.836,0 6.914,-3.148 6.914,-6.969 0,-3.836 -3.078,-6.961 -6.914,-6.961 h -0.055 -29.93 -0.07 c -3.836,0 -6.914,3.125 -6.914,6.961 0,3.836 3.094,6.969 6.914,6.969 0.133,0 0.234,-0.016 0.344,-0.016 h 29.359 z M 49.264,170.451 c 0,0.109 -0.039,0.219 -0.039,0.328 0,3.859 3.102,6.953 6.969,6.953 3.844,0 6.953,-3.094 6.953,-6.953 0,0 -0.016,0 -0.016,-0.016 h 0.016 v -29.969 l 0,0 c 0,-0.016 0.016,-0.031 0.016,-0.031 0,-3.844 -3.117,-6.969 -6.953,-6.969 -3.875,0 -6.969,3.125 -6.969,6.969 0,0.094 0.031,0.219 0.031,0.328 v 29.359 h -0.008 z m 117.11,-29.453 c 0,-0.125 0.031,-0.211 0.031,-0.289 0,-3.867 -3.141,-6.984 -6.977,-6.984 -3.844,0 -6.953,3.117 -6.953,6.984 h -0.016 v 29.93 h 0.016 v 0.07 c 0,3.836 3.109,6.945 6.953,6.945 3.836,0 6.977,-3.109 6.977,-6.945 0,-0.133 -0.031,-0.211 -0.031,-0.328 V 140.998 z M 124.881,77.232 H 92.084 c -3.594,0 -6.453,2.891 -6.453,6.438 0,3.563 2.828,6.461 6.406,6.477 h 32.813 0.031 c 3.547,0 6.43,-2.898 6.43,-6.477 0,-3.547 -2.867,-6.438 -6.43,-6.438 z M 124.405,56.826 H 91.936 c -3.508,0 -6.367,2.844 -6.367,6.359 0,3.508 2.844,6.328 6.328,6.344 h 32.492 0.016 c 3.508,0 6.383,-2.836 6.383,-6.344 0,-3.516 -2.875,-6.359 -6.383,-6.359 z"\n   id="path135"\n   style="fill:#ffd134;fill-opacity:1;stroke:#010202;stroke-width:3.24799991;stroke-miterlimit:10" /><path\n   d="m -17.81,103.841 -52.441,59.125 c 0,0 -3.637,3.313 -11.559,2.906 -9.582,-0.422 -14.664,-10.813 -18.598,-17.828 -1.496,-0.484 -4.754,-1.172 -4.754,-1.172 l -6.734,5.406 c 0,0 -2.082,1.984 -0.867,4.25 1.195,2.266 14.305,15.469 19.41,15.922 2.352,0.203 0.414,1.891 -0.152,2.125 -5.762,2.063 -15.168,-1.984 -15.168,-1.984 0,0 -0.695,-0.18 -6.258,-0.719 -5.566,-0.5 -4.711,3.516 -4.711,3.516 0,0 2.145,6.563 3.641,8.672 3.406,4.766 25.223,-2.953 25.223,-2.953 0,0 4.57,-0.734 5.824,1.953 -8.59,8.094 -14.414,14.016 -17.109,18.375 -4.609,7.938 -1.891,12.031 -1.02,13.094 1.824,1.609 9.121,1.859 12.625,-2.094 1.992,-2.281 4.219,-11.5 10.09,-20.016 4.406,-6.375 12.063,-12.656 16.688,-13.984 10.063,-2.891 24.742,4.969 24.742,4.969 0,0 7.176,3.031 10.336,-5.719 0.848,-2.375 1.059,-4.344 1.059,-4.344 l -0.977,-2.797 c 0,0 -17.961,-4.609 -25.457,-1.398 -2.945,1.266 -3.273,-1.477 -2.449,-3.094 1.25,-2.477 5.738,-8.742 12.305,-16.398 12.266,-14.305 29.535,-33.359 30.617,-41.141 -4.025,-2.406 -4.306,-4.672 -4.306,-4.672 z"\n   id="path147"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" /><path\n   d="m -53.232,-162.26 c -0.32,1.457 -0.059,7.168 2.488,8.535 1.141,0.625 2.156,-0.023 2.91,-1.129 0.75,-1.086 0.594,-2.582 0.594,-2.582 -0.02,-0.031 -1.832,-3.184 0.336,-6.555 2.383,-3.652 8.711,-8.055 25.352,-8.18 16.621,0.133 22.949,4.527 25.32,8.18 2.168,3.371 0.367,6.523 0.352,6.555 0,0 -0.168,1.504 0.59,2.582 0.746,1.105 1.785,1.754 2.922,1.129 2.535,-1.367 2.809,-7.086 2.488,-8.535 -1.512,-6.984 -8.219,-15.352 -31.664,-15.535 -23.473,0.183 -30.176,8.55 -31.688,15.535 z m 7.871,53.695 c -14.496,-7.656 -32.199,-6.617 -32.199,-6.617 0,0 -3.977,1.832 -4.336,5.234 -5.449,-3.066 -4.867,-9.074 -4.867,-9.074 0,0 0.449,-15.352 17.641,-9.629 2.051,0.68 6.938,-0.043 6.641,-1.93 -0.305,-1.832 4.551,-6.496 10.207,-2.488 5.656,4.016 42.938,43.742 48.547,57.234 -28.09,-14.41 -49.563,-16.234 -49.563,-16.234 0,0 -6.559,-0.457 -13.543,-0.266 4.543,-4.367 13.77,-9.52 17.641,-8.254 5.145,1.695 19.406,6.598 19.406,6.598 l -15.575,-14.574 z m -47.265,-14.262 c -1.664,10.422 1.227,11.262 4.785,13.301 3.969,2.258 30.703,0.363 35.938,0.832 5.215,0.48 20.133,14.859 20.133,14.859 0,0 -12.23,-7.313 -19.359,-8.508 -10.336,-1.758 -25.816,-0.133 -36.137,1.188 -10.359,1.309 -12.902,-8.387 -12.902,-8.387 0,0 -1.587,-9.449 7.542,-13.285 z"\n   id="path369"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" /><path\n   d="M 27.709,-212.549 V 276.396"\n   id="path4707"\n   style="fill:none;stroke:#010202;stroke-width:3.0480001" /><path\n   d="M 27.502,-212.635 H 229.404 V 84.091 c 0,106.609 -90.328,193.047 -201.773,193.047 -111.41,0 -201.73,-86.438 -201.73,-193.047 V -212.636 H 27.502 z"\n   id="path4705"\n   style="fill:none;stroke:#010202;stroke-width:3.0480001" /><path\n   d="m -90.56,224.466 c -5.059,-4.078 -5.098,-9.313 -5.016,-12.484 0.094,-4.094 -6.984,1.344 -6.41,3.953 0.313,1.477 -1.945,10.969 11.426,8.531 z"\n   id="path4703"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" /><path\n   d="m -126.369,193.919 c 0,0 1.117,-11.938 10.496,-13.672 5.641,-1.078 2.047,-5.523 2.047,-5.523 0,0 -8.969,-2.852 -15.063,8.625 -1.952,3.672 2.52,10.57 2.52,10.57 z"\n   id="path4701"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" /><path\n   d="m -128.603,154.904 c 0.57,-3.453 4.953,-16 18.25,-8.672 4.926,2.703 3.609,6.477 3.609,6.477 0,0 -2.633,3.359 -5.93,1.063 -8.601,-5.993 -7.855,-7.321 -15.929,1.132 z"\n   id="path4699"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" /><path\n   d="m -23.802,192.466 c 4.754,-2 5.719,-9.953 4.563,-11.531 -5.859,-7.867 -13.219,-8.453 -13.219,-8.453 0,0 -3.781,3.219 3.602,8.578 7.374,5.352 5.23,9.844 5.054,11.406 z"\n   id="path399"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" />\n<path\n   d="m -16.971,-174.20599 c 0,2.31904 -2.08098,4.199 -4.647999,4.199 -2.56702,0 -4.648,-1.87996 -4.648,-4.199 0,-2.31905 2.08098,-4.199 4.648,-4.199 2.567019,0 4.647999,1.87995 4.647999,4.199 z m 5.114,-20.806 c 0,5.11194 -4.477153,9.256 -10,9.256 -5.522848,0 -10,-4.14406 -10,-9.256 0,-5.11195 4.477152,-9.256 10,-9.256 5.522847,0 10,4.14405 10,9.256 z m -5.039,12.60699 c 0,2.32 -2.082,4.215 -4.664,4.215 -2.563,0 -4.633,-1.895 -4.633,-4.215 0,-2.297 2.07,-4.176 4.633,-4.176 2.582,0 4.664,1.879 4.664,4.176 z m -0.075,25.047 c 0,2.30634 -2.08098,4.176 -4.647999,4.176 -2.56702,0 -4.648,-1.86966 -4.648,-4.176 0,-2.30634 2.08098,-4.176 4.648,-4.176 2.567019,0 4.647999,1.86966 4.647999,4.176 z m 0,-8.414 c 0,2.31462 -2.08098,4.191 -4.647999,4.191 -2.56702,0 -4.648,-1.87638 -4.648,-4.191 0,-2.31463 2.08098,-4.191 4.648,-4.191 2.567019,0 4.647999,1.87637 4.647999,4.191 z m 27.321,3.359 c 0,2.32 2.082,4.199 4.664,4.199 2.543,0 4.641,-1.879 4.641,-4.199 0,-2.32 -2.098,-4.191 -4.641,-4.191 -2.582,0 -4.664,1.871 -4.664,4.191 z m -3.199,-7.914 c 0,2.363 2.063,4.266 4.648,4.266 2.559,0 4.641,-1.902 4.641,-4.266 0,-2.352 -2.082,-4.254 -4.641,-4.254 -2.586,0 -4.648,1.903 -4.648,4.254 z m -6.609,-5.918 c 0,2.305 2.09,4.184 4.672,4.184 2.555,0 4.648,-1.879 4.648,-4.184 0,-2.328 -2.094,-4.207 -4.648,-4.207 -2.583,0 -4.672,1.879 -4.672,4.207 z m -8.391,-3.656 c 0,2.313 2.086,4.176 4.664,4.176 2.559,0 4.641,-1.863 4.641,-4.176 0,-2.32 -2.082,-4.199 -4.641,-4.199 -2.578,0 -4.664,1.879 -4.664,4.199 z m 0.2300005,-1.88699 c 0,2.31462 -2.0845622,4.191 -4.6560005,4.191 -2.571437,0 -4.656,-1.87638 -4.656,-4.191 0,-2.31463 2.084563,-4.191 4.656,-4.191 2.5714383,0 4.6560005,1.87637 4.6560005,4.191 z m -45.8159995,19.375 c 0,2.31904 -2.084563,4.199 -4.656001,4.199 -2.571437,0 -4.656,-1.87996 -4.656,-4.199 0,-2.31905 2.084563,-4.199 4.656,-4.199 2.571438,0 4.656001,1.87995 4.656001,4.199 z M -54.865,-174.588 c 2.57,0 4.656,1.91 4.656,4.262 0,2.355 -2.086,4.266 -4.656,4.266 -2.57,0 -4.656,-1.91 -4.656,-4.266 0,-2.352 2.086,-4.262 4.656,-4.262 z m 11.221999,-1.657 c 0,2.31076 -2.08098,4.184 -4.647999,4.184 -2.56702,0 -4.648,-1.87324 -4.648,-4.184 0,-2.31075 2.08098,-4.184 4.648,-4.184 2.567019,0 4.647999,1.87325 4.647999,4.184 z m 8.419,-3.656 c 0,2.30634 -2.084562,4.176 -4.656,4.176 -2.571438,0 -4.656,-1.86966 -4.656,-4.176 0,-2.30634 2.084562,-4.176 4.656,-4.176 2.571438,0 4.656,1.86966 4.656,4.176 z m 9.078001,-1.88699 c 0,2.31462 -2.084562,4.191 -4.656,4.191 -2.571438,0 -4.656,-1.87638 -4.656,-4.191 0,-2.31463 2.084562,-4.191 4.656,-4.191 2.571438,0 4.656,1.87637 4.656,4.191 z m -28.719,7.19999 c 2.57,0 4.656,1.91 4.656,4.262 0,2.355 -2.086,4.266 -4.656,4.266 -2.57,0 -4.656,-1.91 -4.656,-4.266 0,-2.352 2.086,-4.262 4.656,-4.262 z m 60.657,28.589 v -0.016 c 0,0 -54.25,0.016 -54.266,0.016 -1.664,0 -3.023,1.586 -3.023,3.57 0,1.977 1.359,3.574 3.023,3.574 H 5.768 c 1.68,0 3.031,-1.598 3.031,-3.574 0,-1.968 -1.336,-3.542 -3.007,-3.57 z m 2.75,-7.14 v -0.016 l -59.504,0.008 c -1.848,0 -3.336,1.598 -3.336,3.574 0,1.992 1.488,3.582 3.336,3.582 0.051,0 0.098,-0.016 0.16,-0.023 h 59.16 c 0.066,0.008 0.121,0.023 0.168,0.023 1.84,0 3.328,-1.59 3.328,-3.582 -0.016,-1.969 -1.488,-3.551 -3.312,-3.566 z"\n   id="path4794"\n   style="fill:#e8423f;fill-opacity:1;stroke:#010202;stroke-width:3.0480001" /><path\n   d="m 26.936,-98.405 c 0,0 -6.41,-7.199 -7.16,-7.145 4.328,-3.801 7.566,-6 7.16,-8.535 -2.418,2.223 -12.402,-0.375 -13.035,-5.223 2.625,-1.168 1.961,-0.449 7.656,-7.152 -17.437,2.313 -15.574,-13.21 -15.574,-13.21 l -54.434,-0.543 -5.359,10.73 48.801,51.461 c 0,0 7.305,13.434 7.168,17.336 -7.441,-1.656 -10.055,-4.605 -27.25,8.707 -16.766,-6.16 -12.598,-3.113 -41.391,6.047 -9.68,3.078 -18.887,-3.297 -18.887,-3.297 0,0 -9.457,-10.84 5.238,-17.215 0.961,-2.234 -10.641,-17.57 -26.168,-35.762 -20.59,-29.977 -41.094,-68.734 -53.008,-88.91 -18.48,26.824 -4.617,54.719 17.223,79.512 5.641,6.688 18.305,20.398 24.371,25.566 10.352,10.008 12.809,11.855 12.809,14 -2.152,-0.094 -5.609,-1.246 -7.16,-1.297 -3.633,-0.965 -41.563,-20.141 -52.867,-30.934 -9.109,32.617 10.371,39.16 25.16,43.289 11.273,3.125 21.672,5.309 30.305,6.734 -0.238,0.969 -0.039,0.641 -0.246,1.098 -14.059,3.703 -42.168,5.656 -57.746,2.484 -4,34.172 47.961,22.172 60.352,13.672 0.746,-0.016 1.035,0 1.035,0 0,0 -0.418,1.313 -0.785,2.473 -13.297,12.035 -47.449,25.457 -57.402,29.219 19.188,38.766 61.832,-10.816 67.371,-18 0.902,0.031 1.031,0 1.781,0 4.586,5.621 -52.781,79.625 -62.352,91.125 39.754,23.375 66.473,-52.078 81.473,-83.422 1.895,0.375 2.551,0.281 2.551,0.281 0,0 0.168,4.816 -0.504,6.324 0.395,2.801 -33.063,108.41 -47.551,138.941 61.734,0.984 57.785,-97.316 67.695,-143.629 0.328,-1 1.664,-1.141 3.074,-0.813 3.367,4.984 -0.707,86.215 -3.633,110.277 47.113,-13.865 25.297,-104.47 27.184,-114.275 1.863,-4.508 5.023,-3.188 5.023,-3.188 0,0 18.512,54.657 17.945,59.536 -2.168,4.617 -42.953,88.141 -42.953,88.141 l 21.375,-4.422 c 0,0 11.848,37.938 13.801,38.766 C 3.19,105.201 6.526,87.529 8.983,85.013 c 4.816,16.375 19.164,46.422 12.582,83.125 -6.52,36.688 -34.391,61.875 -51.133,60.547 -9.211,-0.203 -9.41,-6.594 -7.816,-8.375 11.422,-12.836 7.207,-26.422 -6.395,-27.406 -5.941,-0.43 -20.512,0.984 -24.375,11.797 -0.992,2.781 1.465,2.828 1.465,2.828 0,0 3.32,-3.031 9.527,-3.836 18.375,-2.367 -12.582,19 -10.582,33.82 0.66,4.836 3.574,8.703 5.527,10.539 5.352,5.031 15.918,4.75 17.848,4.602 2.793,-0.18 32.766,2.805 65.727,-46.852 0.922,-1.406 1.879,0.281 1.602,4.953 -0.578,10.938 -14.555,29.227 -20.848,35.938 -1.832,1.93 -4.328,11.57 2.48,13.961 10.199,3.625 22.094,15.578 22.094,15.578 l 0.25,-374.637 z"\n   clip-path="url(#SVGID_8_)"\n   id="path169"\n   style="fill:#010202" /><path\n   d="m -17.154,-126.565 c 0,1.961 -2.543,3.527 -5.695,3.527 -3.137,0 -5.688,-1.566 -5.688,-3.527 0,-1.926 2.551,-3.504 5.688,-3.504 3.152,-0.008 5.695,1.578 5.695,3.504"\n   id="path201"\n   style="fill:#ffffff" /><path\n   d="m -22.322,-127.124 c 0,1.367 -1.281,2.473 -2.848,2.473 -1.586,0 -2.863,-1.105 -2.863,-2.473 0,-1.352 1.277,-2.449 2.863,-2.449 1.567,0 2.848,1.098 2.848,2.449"\n   id="path205"\n   style="fill:#010202" /><path\n   d="m -33.115,-134.436 c 0,0 -4.461,0.766 -4.422,3.984 0.102,5.352 15.496,-3.258 24.766,-1.434 -6.727,-3.113 -21.055,3.051 -22.055,0.633 -0.297,-0.679 1.711,-3.183 1.711,-3.183"\n   id="path209"\n   style="fill:#ffffff" /></svg>','images/kanton/wappen/svg/ge.svg','images/kanton/wappen/20px/Wappen_Zug_matt.svg.png','images/kanton/wappen/50px/Wappen_Zug_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Zug_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Genf','Q11917','2014-09-16 00:00:00','2014-03-16 10:24:03','2021-02-05 20:25:09'),
(26,'JU',26,'Jura','Jura','Giura',0,2,'fr','Delsberg',NULL,NULL,838,1979,'\n<!-- Generator: Adobe Illustrator 16.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg version="1.1" id="Ebene_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n	 width="406.316px" height="492.574px" viewBox="-175.931 -213.741 406.316 492.574"\n	 enable-background="new -175.931 -213.741 406.316 492.574" xml:space="preserve">\n<path fill="#FFFFFF" d="M27.084-212.217h201.77V84.357c0,106.555-90.271,192.954-201.641,192.954\n	c-111.352,0-201.617-86.397-201.617-192.954v-296.574H27.084z"/>\n<rect x="27.147" y="-212.217" fill="#E8423F" width="201.707" height="68.734"/>\n<rect x="27.139" y="-73.362" fill="#E8423F" width="201.707" height="70.137"/>\n<path fill="#E8423F" d="M27.139,137.021H221.26c4.93-16.719,7.594-34.422,7.594-52.672V66.896H27.139V137.021z"/>\n<path fill="#E8423F" d="M182.745,207.177H27.139v70.134h0.648C90.151,277.115,145.862,249.88,182.745,207.177"/>\n<g>\n	<g>\n		<g>\n			<g>\n				<defs>\n					<rect id="SVGID_1_" x="-175.931" y="-213.741" width="406.316" height="492.574"/>\n				</defs>\n				<clipPath id="SVGID_2_">\n					<use xlink:href="#SVGID_1_"  overflow="visible"/>\n				</clipPath>\n				<path clip-path="url(#SVGID_2_)" fill="none" stroke="#010202" stroke-width="3.048" d="M27.139-3.225h201.714v-70.129H27.139\n					V-3.225z M182.745,207.177H27.139v70.134h0.648C90.151,277.115,145.862,249.88,182.745,207.177z M27.139,207.177h155.59\n					c17.547-20.328,30.805-44.109,38.523-70.156H27.139V207.177z M27.139,137.021H221.26c4.93-16.719,7.594-34.422,7.594-52.672\n					V66.896H27.139V137.021z M27.139,66.896h201.714V-3.225H27.139V66.896z M228.854-143.483v-68.734H27.139v68.734H228.854z\n					 M27.139-73.354h201.714v-70.137H27.139V-73.354z"/>\n			</g>\n		</g>\n	</g>\n	<g>\n		<g>\n			<g>\n				<defs>\n					<rect id="SVGID_3_" x="-175.931" y="-213.741" width="406.316" height="492.574"/>\n				</defs>\n				<clipPath id="SVGID_4_">\n					<use xlink:href="#SVGID_3_"  overflow="visible"/>\n				</clipPath>\n				<path clip-path="url(#SVGID_4_)" fill="none" stroke="#010202" stroke-width="3.048" d="M27.084-212.217h201.77V84.357\n					c0,106.555-90.271,192.954-201.641,192.954c-111.352,0-201.617-86.397-201.617-192.954v-296.574H27.084z"/>\n			</g>\n		</g>\n	</g>\n</g>\n<path fill="#E8423F" d="M-157.173-138.331c0,20.855,9.961,45.488,38.043,46.184c5.313,0.145,18.621-0.496,27.414-9.07\n	c5.266-5.145,7.938-12.266,7.938-21.145c0-14.922-7.586-21.52-13.945-24.441c-7.711-3.496-16.809-3.129-22.086-1.551\n	c1.688-4.387,5.863-11.543,20.32-12c5.797-0.191,14.086,1.285,20.68,9.391c7.902,9.703,15,31,3.863,77.305l-0.441,1.871h57.129\n	l0.023-1.504c0.711-48.145-9.168-82.949-29.391-103.465c-16.938-17.184-36.281-19.047-43.824-19.047\n	C-156.412-195.795-157.173-138.905-157.173-138.331"/>\n<path fill="#010202" d="M-91.458-197.315c-34.168,0-50.609,15.609-58.402,28.703c-8.727,14.738-8.832,29.648-8.832,30.273\n	c0,21.543,10.352,46.984,39.504,47.727h0.523l0.605,0.008c8.41,0,35.801-2.285,35.801-31.75c0-21.168-15.016-28.723-29.063-28.723\n	c-1.832,0-3.824,0.137-5.723,0.434c2.352-3.727,7.137-7.863,17.602-8.199c0.344-0.016,0.609-0.016,0.871-0.016\n	c5.297,0,12.855,1.598,18.848,9.199c7.504,9.52,14.168,30.375,3.289,75.641l-0.895,3.758h3.855h53.703h3l0.047-3.016\n	c0.711-48.559-9.313-83.734-29.832-104.543C-63.892-195.42-83.732-197.315-91.458-197.315 M-155.634-138.362\n	c0-2.395,1.285-55.906,64.176-55.906c14.176,0,71.535,6.738,71.734,115.691c0,1.727-0.008,3.492-0.039,5.262h-53.703\n	c4.023-16.746,5.766-30.695,5.766-42.191c-0.008-33.793-15-46.398-30.863-46.398c-0.32,0-0.648,0-0.969,0.023\n	c-20.688,0.656-22.086,15.094-22.965,16.215c0.512-0.441,1.484-0.887,2.781-1.281c0.32-0.086,0.664-0.184,1.023-0.27\n	c1.992-0.48,4.555-0.809,7.379-0.809c11.055,0,26.023,5.039,26.023,25.672c0,26.031-23.746,28.703-32.762,28.703\n	c-0.383,0-0.727-0.016-1.047-0.016c-26.434-0.664-36.527-23.777-36.527-44.672v-0.023L-155.634-138.362L-155.634-138.362z"/>\n<rect x="-85.373" y="-67.506" fill="#E8423F" width="77.387" height="11.504"/>\n<rect x="-85.373" y="-67.506" fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="10" width="77.387" height="11.504"/>\n<rect x="-85.373" y="-35.788" fill="#E8423F" width="77.387" height="11.512"/>\n<rect x="-85.373" y="-35.788" fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="10" width="77.387" height="11.512"/>\n<rect x="-100.994" y="-51.604" fill="#E8423F" width="108.621" height="11.512"/>\n<rect x="-100.994" y="-51.604" fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="10" width="108.621" height="11.512"/>\n<polygon fill="#E8423F" points="-73.763,154.724 -107.701,194.427 -81.451,-19.569 -12.236,-19.569 14.292,194.427 -19.923,154.982\n	-46.701,240.052 "/>\n<polygon fill="none" stroke="#010202" stroke-width="3.048" stroke-miterlimit="10" points="-73.763,154.724 -107.701,194.427\n	-81.451,-19.569 -12.236,-19.569 14.292,194.427 -19.923,154.982 -46.701,240.052 "/>\n</svg>\n','images/kanton/wappen/svg/ju.svg','images/kanton/wappen/20px/Wappen_Zürich_matt.svg.png','images/kanton/wappen/50px/Wappen_Zürich_matt.svg.png','images/kanton/lage/Karte_Lage_Kanton_Zürich_2014.png',NULL,NULL,'https://de.wikipedia.org/wiki/Kanton_Jura','Q12755','2014-09-16 00:00:00','2014-03-16 10:24:03','2021-02-05 20:25:09');

DROP TABLE IF EXISTS kanton_jahr;
CREATE TABLE kanton_jahr (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Jahreswerte eines Kantons',
  kanton_id int(11) NOT NULL COMMENT 'Fremdschlüssel eines Kantons',
  jahr smallint(6) unsigned NOT NULL COMMENT 'Jahr auf welche sich die Werte beziehen',
  anzahl_nationalraete tinyint(4) unsigned NOT NULL COMMENT 'Anzahl Nationalräte des Kantons',
  einwohner int(11) unsigned NOT NULL COMMENT 'Wohnbevölkerung des Kantons',
  auslaenderanteil float NOT NULL COMMENT 'Ausländeranteil, zwischen 0 und 1',
  bevoelkerungsdichte smallint(6) unsigned DEFAULT NULL COMMENT 'Bevölkerungsdichte [Einwohner/km2]',
  anzahl_gemeinden smallint(6) unsigned DEFAULT NULL COMMENT 'Anzahl Gemeinden',
  steuereinnahmen int(11) unsigned DEFAULT NULL COMMENT 'Stuereinnahmen in Franken',
  ausgaben int(11) DEFAULT NULL COMMENT 'Ausgaben in Franken',
  finanzausgleich int(11) DEFAULT NULL COMMENT 'Geld durch Finanzausgleich bekommen, in Franken',
  schulden int(11) DEFAULT NULL COMMENT 'Schulden des Kantons in Franken',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY idx_kanton_jahr_unique (kanton_id,jahr) COMMENT 'Fachlicher unique constraint',
  KEY kanton_id (kanton_id),
  CONSTRAINT fk_kanton_jahr_kanton_id FOREIGN KEY (kanton_id) REFERENCES kanton (id)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Jahresbasierte Angaben zu Kantonen';

INSERT INTO kanton_jahr (id, kanton_id, jahr, anzahl_nationalraete, einwohner, auslaenderanteil, bevoelkerungsdichte, anzahl_gemeinden, steuereinnahmen, ausgaben, finanzausgleich, schulden, freigabe_datum, created_date, updated_date) VALUES
(1,1,2012,34,1408575,0.25,815,170,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:00','2014-09-16 00:00:00'),
(2,2,2012,26,992617,0.138,167,362,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:00','2014-09-16 00:00:00'),
(3,3,2012,10,386082,0.168,259,83,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:01','2014-09-16 00:00:00'),
(4,4,2012,1,35693,0.107,33,20,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:01','2014-09-16 00:00:00'),
(5,5,2012,4,149830,0.193,165,30,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:01','2014-09-16 00:00:00'),
(6,6,2012,1,36115,0.136,74,7,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:01','2014-09-16 00:00:00'),
(7,7,2012,1,41584,0.126,151,11,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(8,8,2012,1,39369,0.218,57,3,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(9,9,2012,3,116575,0.256,488,11,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(10,10,2012,7,291395,0.206,174,163,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(11,11,2012,7,259283,0.2,328,109,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(12,12,2012,5,194661,0.344,5261,3,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(13,13,2012,7,276537,0.201,534,86,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(14,14,2012,2,77955,0.244,262,26,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(15,15,2012,1,53438,0.146,220,20,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(16,16,2012,1,15789,0.099,91,6,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(17,17,2012,12,487060,0.226,240,77,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(18,18,2012,5,193920,0.173,27,146,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(19,19,2012,15,627893,0.23,447,213,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(20,20,2012,6,256213,0.231,259,80,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:02','2014-09-16 00:00:00'),
(21,21,2012,8,341652,0.274,121,135,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:03','2014-09-16 00:00:00'),
(22,22,2012,18,729971,0.321,227,318,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:03','2014-09-16 00:00:00'),
(23,23,2012,7,321732,0.22,62,134,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:03','2014-09-16 00:00:00'),
(24,24,2012,5,174554,0.246,217,37,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:03','2014-09-16 00:00:00'),
(25,25,2012,11,476024,0.372,1688,45,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:03','2014-09-16 00:00:00'),
(26,26,2012,2,70942,0.131,85,57,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-16 10:24:03','2014-09-16 00:00:00');

DROP TABLE IF EXISTS interessenraum;
CREATE TABLE interessenraum (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel des Interessenraumes',
  name varchar(50) NOT NULL COMMENT 'Name des Interessenbereiches',
  name_fr varchar(50) DEFAULT NULL COMMENT 'Französischer Name des Interessenbereiches',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Beschreibung des Interessenraumes',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Französische Beschreibung des Interessenraumes',
  reihenfolge int(11) DEFAULT NULL COMMENT 'Anzeigereihenfolge (je kleiner desto höher)',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY interessenraum_name_unique (name) COMMENT 'Fachlicher unique constraint',
  KEY reihenfolge (reihenfolge)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Liste der Interessenbereiche (Stammdaten)';

INSERT INTO interessenraum (id, name, name_fr, beschreibung, beschreibung_fr, reihenfolge, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'National (Schweiz)',NULL,'Schweiz',NULL,10,NULL,NULL,'2014-03-02 06:45:42','2014-03-02 06:45:42','2019-12-09 16:19:11'),
(2,'Kantonal',NULL,NULL,NULL,20,NULL,NULL,'2014-03-02 06:45:42','2014-03-02 06:45:42','2019-12-09 16:19:11'),
(3,'Kommunal',NULL,NULL,NULL,1000,NULL,NULL,'2014-03-02 06:46:37','2014-03-02 06:46:37','2019-12-09 16:19:11'),
(4,'Global',NULL,NULL,NULL,30,NULL,NULL,'2014-03-02 06:46:37','2014-03-02 06:46:37','2019-12-09 16:19:11'),
(5,'Europa',NULL,NULL,NULL,40,NULL,NULL,'2014-03-02 06:47:14','2014-03-02 06:47:14','2019-12-09 16:19:11'),
(6,'Nordamerika',NULL,NULL,NULL,50,NULL,NULL,'2014-03-02 06:47:14','2014-03-02 06:47:14','2019-12-09 16:19:11'),
(7,'Asien',NULL,NULL,NULL,60,NULL,NULL,'2014-03-02 06:48:31','2014-03-02 06:48:31','2019-12-09 16:19:11'),
(8,'Afrika',NULL,NULL,NULL,70,NULL,NULL,'2014-03-02 06:48:31','2014-03-02 06:48:31','2019-12-09 16:19:11'),
(9,'National (Ausland)',NULL,NULL,NULL,45,NULL,NULL,'2014-03-02 06:56:13','2014-03-02 06:56:13','2019-12-09 16:19:11'),
(10,'Südamerika',NULL,NULL,NULL,55,NULL,NULL,'2014-03-02 07:24:21','2014-03-02 07:24:21','2019-12-09 16:19:11'),
(11,'Australien',NULL,'Kontinent Australien: Australien, Neuseeland, ...',NULL,70,NULL,NULL,'2014-03-02 07:27:04','2014-03-02 07:27:04','2019-12-09 16:19:11');

DROP TABLE IF EXISTS rat;
CREATE TABLE rat (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Jahreswerte eines Rates',
  abkuerzung varchar(10) NOT NULL COMMENT 'Kürzel des Rates',
  abkuerzung_fr varchar(10) NOT NULL COMMENT 'Französische Abkürzung',
  name_de varchar(50) NOT NULL COMMENT 'Name auf deutsch',
  name_fr varchar(50) DEFAULT NULL COMMENT 'Name auf französisch',
  name_it varchar(50) DEFAULT NULL COMMENT 'Name auf italienisch',
  name_en varchar(50) DEFAULT NULL COMMENT 'Name auf englisch',
  anzahl_mitglieder smallint(6) DEFAULT NULL COMMENT 'Anzahl Mitglieder des Rates',
  typ enum('legislativ','exekutiv','judikativ') NOT NULL COMMENT 'Typ des Rates',
  interessenraum_id int(11) DEFAULT 1 COMMENT 'Interessenraum des Rates',
  anzeigestufe int(11) NOT NULL COMMENT 'Anzeigestufe, je höher desto selektiver, >=0 = alle werden angezeigt, >0 = Standardanzeige',
  gewicht int(11) NOT NULL COMMENT 'Reihenfolge der Einträge, je grösser desto tiefer ("schwerer")',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Eine Beschreibung',
  homepage_de varchar(255) DEFAULT NULL COMMENT 'Deutschsprachige Homepage',
  homepage_fr varchar(255) DEFAULT NULL COMMENT 'Franszösichsprache Homepage',
  homepage_it varchar(255) DEFAULT NULL COMMENT 'Italienischsprachige Homepage',
  homepage_en varchar(255) DEFAULT NULL COMMENT 'Englischsprachige Homepage',
  mitglied_bezeichnung_maennlich_de varchar(50) NOT NULL COMMENT 'Deutsche Bezeichnung der Männer',
  mitglied_bezeichnung_weiblich_de varchar(50) NOT NULL COMMENT 'Deutsche Bezeichung der Frauen',
  mitglied_bezeichnung_maennlich_fr varchar(50) NOT NULL COMMENT 'Französische Bezeichnung der Männer',
  mitglied_bezeichnung_weiblich_fr varchar(50) NOT NULL COMMENT 'Französische Bezeichung der Frauen',
  parlament_id int(11) NOT NULL COMMENT 'ID auf ws.parlament.ch',
  parlament_type char(1) DEFAULT NULL COMMENT 'Ratstypecode von ws.parlament.ch',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY idx_rat_unique (abkuerzung) COMMENT 'Fachlicher unique constraint',
  KEY interessenraum_id (interessenraum_id),
  CONSTRAINT fk_interessenraum_id FOREIGN KEY (interessenraum_id) REFERENCES interessenraum (id)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Tabelle der Räte von Lobbywatch';

INSERT INTO rat (id, abkuerzung, abkuerzung_fr, name_de, name_fr, name_it, name_en, anzahl_mitglieder, typ, interessenraum_id, anzeigestufe, gewicht, beschreibung, homepage_de, homepage_fr, homepage_it, homepage_en, mitglied_bezeichnung_maennlich_de, mitglied_bezeichnung_weiblich_de, mitglied_bezeichnung_maennlich_fr, mitglied_bezeichnung_weiblich_fr, parlament_id, parlament_type, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'NR','CN','Nationalrat','Conseil national','Consiglio nazionale','National Council',200,'legislativ',1,10,10,'','http://www.parlament.ch/D/ORGANE-MITGLIEDER/NATIONALRAT','http://www.parlament.ch/F/ORGANE-MITGLIEDER/NATIONALRAT','http://www.parlament.ch/i/organe-mitglieder/nationalrat/Pagine/default.aspx','http://www.parlament.ch/e/organe-mitglieder/nationalrat/Pages/default.aspx','Nationalrat','Nationalrätin','Le Conseiller national','La Conseillère nationale',1,'N','https://de.wikipedia.org/wiki/Nationalrat_(Schweiz)','Q676078','2014-09-16 00:00:00','2014-03-16 10:24:20','2021-02-06 15:32:39'),
(2,'SR','CE','Ständerat','Conseil des Etats','Consiglio degli Stati','Council of States',46,'legislativ',1,10,20,'','http://www.parlament.ch/d/organe-mitglieder/staenderat/Seiten/default.aspx','http://www.parlament.ch/f/organe-mitglieder/staenderat/Pages/default.aspx','http://www.parlament.ch/i/organe-mitglieder/staenderat/Pagine/default.aspx','http://www.parlament.ch/E/ORGANE-MITGLIEDER/STAENDERAT/Pages/default.aspx','Ständerat','Ständerätin','Le Conseiller aux Etats','La Conseillère aux Etats',2,'S','https://de.wikipedia.org/wiki/St%C3%A4nderat','Q609037','2014-09-16 00:00:00','2014-03-16 10:24:20','2021-02-06 15:32:39'),
(3,'BR','CF','Bundesrat','Conseil fédéral','Consiglio federale','Federal Council',7,'exekutiv',1,0,30,'','http://www.admin.ch/br/org/index.html?lang=de','http://www.admin.ch/br/org/index.html?lang=fr','http://www.admin.ch/br/org/index.html?lang=it','http://www.admin.ch/br/org/index.html?lang=en','Bundesrat','Bundesrätin','Le Conseiller federal','La Conseillère federal',0,NULL,'https://de.wikipedia.org/wiki/Bundesrat_(Schweiz)','Q30917','2014-09-16 00:00:00','2014-03-16 10:24:20','2021-02-06 15:32:39'),
(4,'B','','Vereinigte Bundesversammlung','Assemblée fédérale (Chambres réunies)',NULL,NULL,248,'legislativ',1,0,0,NULL,NULL,NULL,NULL,NULL,'','','','',3,'B','https://de.wikipedia.org/wiki/Bundesversammlung_(Schweiz)#Vereinigte_Bundesversammlung','Q684719','2015-03-21 00:00:00','2015-02-15 12:37:21','2021-02-06 15:32:39');

DROP TABLE IF EXISTS fraktion;
CREATE TABLE fraktion (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Fraktion',
  abkuerzung varchar(20) NOT NULL COMMENT 'Fraktionsabkürzung',
  name varchar(100) DEFAULT NULL COMMENT 'Ausgeschriebener Name der Fraktion',
  name_fr varchar(100) DEFAULT NULL COMMENT 'Ausgeschriebener französischer Name der Fraktion',
  position enum('links','rechts','mitte') DEFAULT NULL COMMENT 'Politische Position der Fraktion',
  farbcode varchar(15) DEFAULT NULL COMMENT 'HTML-Farbcode, z.B. red oder #23FF23',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Beschreibung der Fraktion',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Französische Beschreibung der Fraktion',
  von date DEFAULT NULL COMMENT 'Beginn der Fraktion, leer (NULL) = unbekannt',
  bis date DEFAULT NULL COMMENT 'Ende der Fraktion, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY fraktion_abkuerzung_unique (abkuerzung) COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY fraktion_name_unique (name)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Fraktionen des Parlamentes';

INSERT INTO fraktion (id, abkuerzung, name, name_fr, position, farbcode, beschreibung, beschreibung_fr, von, bis, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'RL','FDP-Liberale Fraktion','Groupe radical-libéral','rechts','#0A4BD6',NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/FDP-Liberale_Fraktion_der_Bundesversammlung','Q1387996','2014-09-16 00:00:00','2014-01-26 12:54:44','2021-02-06 15:32:39'),
(2,'GL','Grünliberale Fraktion','Groupe vert-libéral','mitte','#88487F',NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Gr%C3%BCnliberale_Fraktion_der_Bundesversammlung','Q1552293','2014-09-16 00:00:00','2014-01-26 12:55:26','2021-02-06 15:32:39'),
(3,'S','Sozialdemokratische Fraktion','Groupe socialiste','links','#FF0505',NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Sozialdemokratische_Fraktion_der_Bundesversammlung','Q2305290','2014-09-16 00:00:00','2014-01-26 12:55:47','2021-02-06 15:32:39'),
(4,'G','Grüne Fraktion','Groupe des Verts','links','#07F61E',NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Gr%C3%BCne_Fraktion_der_Bundesversammlung','Q688717','2014-09-16 00:00:00','2014-01-26 12:56:11','2021-02-06 15:32:39'),
(5,'V','Fraktion der Schweizerischen Volkspartei','Groupe de l''Union démocratique du Centre','rechts','#0A7D3A',NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Fraktion_der_Schweizerischen_Volkspartei_der_Bundesversammlung','Q1305894','2014-09-16 00:00:00','2014-01-26 12:56:31','2021-02-06 15:32:39'),
(6,'CE','Fraktion CVP-EVP',NULL,'mitte','#FB7407',NULL,NULL,NULL,'2019-12-01','https://de.wikipedia.org/wiki/Fraktion_CVP_der_Bundesversammlung','Q1440555','2014-09-16 00:00:00','2014-01-26 12:56:58','2021-02-06 15:32:39'),
(7,'BD','Fraktion BD',NULL,'mitte','#FFE543',NULL,NULL,'2002-03-20','2020-12-31','https://de.wikipedia.org/wiki/Fraktion_der_B%C3%BCrgerlich-Demokratischen_Partei_der_Bundesversammlung','Q1440560','2014-09-16 00:00:00','2014-01-26 12:57:21','2021-03-10 20:11:04'),
(8,'M-E','Mitte-Fraktion. Mitte-EVP.','Le Groupe du Centre. Centre-PEV.','mitte','#FF9B03','Die Mitte-Fraktion. Mitte-EVP. (M-CEB)','Le Groupe du Centre. Centre-PEV. (M-CED)','2019-12-02',NULL,'https://de.wikipedia.org/wiki/Fraktion_CVP/EVP/glp_der_Bundesversammlung','Q663985','2019-12-02 15:12:16','2019-12-02 15:11:54','2022-02-10 09:41:16');

DROP TABLE IF EXISTS partei;
CREATE TABLE partei (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Partei',
  abkuerzung varchar(20) NOT NULL COMMENT 'Parteiabkürzung',
  abkuerzung_fr varchar(20) DEFAULT NULL COMMENT 'Französische Parteiabkürzung',
  name varchar(100) DEFAULT NULL COMMENT 'Ausgeschriebener Name der Partei',
  name_fr varchar(100) DEFAULT NULL COMMENT 'Ausgeschriebener französischer Name der Partei',
  fraktion_id int(11) DEFAULT NULL COMMENT 'Fraktionszugehörigkeit der Partei im nationalen Parlament',
  gruendung date DEFAULT NULL COMMENT 'Gründungsjahr der Partei. Wenn der genaue Tag unbekannt ist, den 1. Januar wählen.',
  position enum('links','rechts','mitte') DEFAULT NULL COMMENT 'Politische Position der Partei',
  farbcode varchar(15) DEFAULT NULL COMMENT 'HTML-Farbcode, z.B. red oder #23FF23',
  homepage varchar(255) DEFAULT NULL COMMENT 'Homepage der Partei',
  homepage_fr varchar(255) DEFAULT NULL COMMENT 'Französische Homepage der Partei',
  email_fr varchar(100) DEFAULT NULL COMMENT 'Französische Kontakt E-Mail-Adresse der Partei',
  twitter_name varchar(15) DEFAULT NULL COMMENT 'Twittername',
  instagram_profil varchar(30) DEFAULT NULL COMMENT 'Instagram Username (Profil)',
  youtube_user varchar(50) DEFAULT NULL COMMENT 'Youtube Username',
  facebook_name varchar(150) DEFAULT NULL COMMENT 'Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt',
  twitter_name_fr varchar(50) DEFAULT NULL COMMENT 'Französischer Twittername',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Beschreibung der Partei',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Französische Beschreibung der Partei',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY partei_abkuerzung_unique (abkuerzung) COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY partei_name_unique (name) COMMENT 'Fachlicher unique constraint',
  KEY fraktion_id (fraktion_id),
  CONSTRAINT fk_partei_fraktion_id FOREIGN KEY (fraktion_id) REFERENCES fraktion (id)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Politische Parteien des Parlamentes';

INSERT INTO partei (id, abkuerzung, abkuerzung_fr, name, name_fr, fraktion_id, gruendung, position, farbcode, homepage, homepage_fr, email_fr, twitter_name, instagram_profil, youtube_user, facebook_name, twitter_name_fr, beschreibung, beschreibung_fr, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'FDP','PLR','Freisinnig-Demokratische Partei','PLR.Les Libéraux-Radicaux',1,'1970-01-01','mitte','#0A4BD6','http://www.fdp.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/FDP.Die_Liberalen','Q202638','2014-09-16 00:00:00','2013-11-23 14:36:01','2021-02-06 15:32:39'),
(2,'GLP','PVL','Grünliberale Partei','Parti vert-libéral',2,'2007-07-19','mitte','#9BD527','http://www.grunliberale.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Gr%C3%BCnliberale_Partei','Q545900','2014-09-16 00:00:00','2013-11-23 14:36:01','2021-12-02 15:53:15'),
(3,'SP','PSS','Sozialdemokratische Partei','Parti socialiste',3,'1970-01-01','links','#FF0505','http://www.sp-ps.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Sozialdemokratische_Partei_der_Schweiz','Q303745','2014-09-16 00:00:00','2013-11-23 14:36:47','2021-02-06 15:32:39'),
(4,'Grüne','Vert','Grüne Partei der Schweiz','Les Verts',4,'1983-01-06','links','#07F61E','http://www.gruene.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Gr%C3%BCne_Partei_der_Schweiz','Q659739','2014-09-16 00:00:00','2013-11-23 14:36:47','2021-06-12 10:15:26'),
(5,'SVP','UDC','Schweizerische Volkspartei','Union Démocratique du Centre',5,'1936-01-01','rechts','#0A7D3A','http://www.svp.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Schweizerische_Volkspartei','Q385258','2014-09-16 00:00:00','2013-11-23 14:37:22','2021-02-06 15:32:39'),
(6,'EVP','PEV','Evangelische Volkspartei',NULL,8,'1919-01-01','mitte','#FB7407','http://www.evppev.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Evangelische_Volkspartei','Q667718','2014-09-16 00:00:00','2013-11-23 14:37:22','2021-09-24 15:50:27'),
(7,'CVP','PDC','Christlichdemokratische Volkspartei',NULL,6,'1912-01-02','mitte','#FB7407','http://www.cvp.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Christlichdemokratische_Volkspartei','Q659461','2014-09-16 00:00:00','2013-11-23 14:39:52','2021-02-06 15:32:39'),
(8,'BDP','PBD','Bürgerlich-Demokratische Partei',NULL,7,'2008-01-01','mitte','#FFE543','http://www.bdp.info',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/B%C3%BCrgerlich-Demokratische_Partei','Q151768','2014-09-16 00:00:00','2013-11-23 14:39:52','2021-02-06 15:32:39'),
(9,'MCG',NULL,'Mouvement Citoyens Romands',NULL,5,NULL,'rechts','#0A7D3A',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://fr.wikipedia.org/wiki/Mouvement_citoyens_genevois','Q663580','2014-09-16 00:00:00','2014-01-19 15:34:33','2021-02-06 15:32:39'),
(10,'Lega',NULL,'Lega dei Ticinesi',NULL,5,NULL,'rechts','#0A7D3A','http://www.lega-dei-ticinesi.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Lega_dei_Ticinesi','Q668101','2014-09-16 00:00:00','2014-01-19 15:34:57','2021-02-06 15:32:39'),
(11,'CSP','PCS','Christlich-soziale Partei',NULL,6,NULL,'links','#FB7407','http://www.csp-pcs.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Christlichsoziale_Partei_(CVP)','Q111601372','2014-09-16 00:00:00','2014-01-19 15:36:26','2022-04-15 05:51:39'),
(12,'CSPO',NULL,'Christlichsoziale Volkspartei Oberwallis',NULL,6,NULL,'links','#FB7407','http://www.cspo.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Christlichsoziale_Volkspartei_Oberwallis','Q1084156','2014-09-16 00:00:00','2014-01-19 15:37:09','2021-02-06 15:32:39'),
(13,'PdA','PdT','Partei der Arbeit',NULL,4,NULL,'links',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Partei_der_Arbeit_der_Schweiz','Q661771','2015-12-07 00:00:00','2015-10-26 10:31:34','2021-03-10 20:21:23'),
(14,'LPS',NULL,'Liberale Partei der Schweiz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Liberale_Partei_der_Schweiz','Q667785','2015-12-07 00:00:00','2015-10-26 10:31:34','2021-02-06 15:32:39'),
(15,'BastA',NULL,'Basels starke Alternative',NULL,4,NULL,'links',NULL,'http://basta-bs.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Basels_starke_Alternative','Q809935','2015-12-07 00:00:00','2015-12-07 08:39:48','2021-02-06 15:32:39'),
(16,'LDP',NULL,'Liberal-Demokratische Partei',NULL,1,NULL,'rechts',NULL,'http://www.ldp.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Liberal-Demokratische_Partei_(Basel-Stadt)','Q201123','2015-12-07 00:00:00','2015-12-07 08:41:37','2021-02-06 15:32:39'),
(17,'PPS',NULL,'Piratenpartei Schweiz','Parti Pirate Suisse',NULL,'2018-09-20',NULL,NULL,'https://www.piratenpartei.ch/','https://www.partipirate.ch/',NULL,'ppsde',NULL,NULL,NULL,'PartiPirate','Die Ziele der Piratenpartei Schweiz umfassen insbesondere:\na. die Stärkung der Menschenrechte, Demokratie und Rechtsstaatlichkeit;\nb. die StärkungderFreiheit,VerantwortungundPartizipationallerMenschen;\nc. die Förderung eines transparenten Staates;\nd. den Förderung des freien Zugangs zu Wissen und Kultur;\ne. die Stärkung des Schutzs der Privatsphäre und der informationellen\nSelbstbestimmung der Bevölkerung;\nf. die Bekämpfung von Medienverboten und Zensur;\ng. die Einschränkung von schädlichen Monopolen.',NULL,'https://de.wikipedia.org/wiki/Piratenpartei_Schweiz','Q672479','2018-03-28 15:53:58','2018-03-28 15:53:15','2021-02-06 15:32:39'),
(18,'CVPO',NULL,'CVP Oberwallis',NULL,6,NULL,'mitte',NULL,'http://oberwallis.cvp.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Christlichdemokratische_Volkspartei_Oberwallis','Q1083999','2019-03-09 19:53:09','2019-03-09 19:42:29','2021-02-06 15:32:39'),
(19,'EDU','UDF','Eidgenössisch-Demokratische Union','Union Démocratique Fédérale',5,NULL,'rechts',NULL,'https://www.edu-schweiz.ch','https://www.udf-suisse.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Eidgen%C3%B6ssisch-Demokratische_Union','Q667836','2019-12-02 15:15:48','2019-12-02 15:15:21','2021-02-06 15:32:39'),
(20,'ALG',NULL,'Alternative - die Grünen Zug',NULL,4,NULL,'links','#84B414','https://gruene-zug.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Alternative_%E2%80%93_die_Gr%C3%BCnen_Zug','Q438674','2021-03-17 20:45:11','2019-12-02 15:16:51','2022-04-01 05:50:56'),
(21,'EàG','EàG','Ensemble à Gauche','Ensemble à Gauche',4,NULL,'links',NULL,'https://eag-ge.ch/','https://eag-ge.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-03-17 20:45:11','2019-12-02 15:17:13','2021-06-19 08:33:52'),
(22,'M','C','Die Mitte','Le Centre',8,'2021-01-01','mitte','#F29301','https://die-mitte.ch/','https://le-centre.ch/',NULL,'Mitte_Centre',NULL,NULL,NULL,'Mitte_Centre','Zusammenschluss der CVP und der BDP',NULL,'https://de.wikipedia.org/wiki/Die_Mitte','Q100934025','2021-03-17 20:45:11','2021-02-06 08:51:34','2021-12-02 15:54:36');

DROP TABLE IF EXISTS kommission;
CREATE TABLE kommission (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Kommission',
  abkuerzung varchar(15) NOT NULL COMMENT 'Kürzel der Kommission',
  abkuerzung_fr varchar(15) DEFAULT NULL COMMENT 'Französisches Kürzel der Kommission',
  name varchar(100) NOT NULL COMMENT 'Ausgeschriebener Name der Kommission',
  name_fr varchar(120) DEFAULT NULL COMMENT 'Ausgeschriebener französischer Name der Kommission',
  rat_id int(11) DEFAULT NULL COMMENT 'Ratszugehörigkeit; Fremdschlüssel des Rates',
  typ enum('kommission','subkommission','spezialkommission') NOT NULL DEFAULT 'kommission' COMMENT 'Typ einer Kommission (Spezialkommission ist eine Delegation im weiteren Sinne).',
  art enum('legislativkommission','aufsichtskommission','parlam verwaltungskontrolle','weitere kommission','delegation im weiteren sinne') DEFAULT NULL COMMENT 'Art der Kommission gemäss Einteilung auf Parlament.ch. Achtung für Delegationen im engeren Sinne (= Subkommissionen) sollte die Art der Mutterkommission gewählt werden, z.B. GPDel ist eine Subkommission der GPK und gehört somit zu den Aufsichtskommissionen.',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Beschreibung der Kommission',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Französische Beschreibung der Kommission',
  sachbereiche mediumtext NOT NULL COMMENT 'Liste der Sachbereiche der Kommission, abgetrennt durch ";".',
  sachbereiche_fr mediumtext DEFAULT NULL COMMENT 'Liste der Sachbereiche der Kommission auf französisch, abgetrennt durch ";".',
  anzahl_mitglieder tinyint(3) unsigned DEFAULT NULL COMMENT 'Anzahl Kommissionsmitglieder',
  anzahl_nationalraete tinyint(3) unsigned DEFAULT NULL COMMENT 'Anzahl Kommissionsmitglieder des Nationalrates',
  anzahl_staenderaete tinyint(3) unsigned DEFAULT NULL COMMENT 'Anzahl Kommissionsmitglieder des Ständerates',
  mutter_kommission_id int(11) DEFAULT NULL COMMENT 'Zugehörige Kommission von Delegationen im engeren Sinne (=Subkommissionen).  Also die "Oberkommission".',
  zweitrat_kommission_id int(11) DEFAULT NULL COMMENT 'Entsprechende Kommission im anderen Rat, Stände- o. Nationalratskommission',
  von date DEFAULT NULL COMMENT 'Beginn der Kommission, leer (NULL) = unbekannt',
  bis date DEFAULT NULL COMMENT 'Ende der Kommission, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag',
  parlament_url varchar(255) DEFAULT NULL COMMENT 'Link zur Seite auf Parlament.ch',
  parlament_id int(11) DEFAULT NULL COMMENT 'Kommissions-ID von ws.parlament.ch',
  parlament_committee_number int(11) DEFAULT NULL COMMENT 'committeeNumber auf ws.parlament.ch',
  parlament_subcommittee_number int(11) DEFAULT NULL COMMENT 'subcommitteeNumber auf ws.parlament.ch',
  parlament_type_code int(11) DEFAULT NULL COMMENT 'typeCode von ws.parlament.ch',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY kommission_abkuerzung_unique (abkuerzung) COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY kommission_name_unique (name) COMMENT 'Fachlicher unique constraint',
  KEY zugehoerige_kommission (mutter_kommission_id,freigabe_datum),
  KEY rat_id (rat_id),
  KEY zweitrat_kommission_id (zweitrat_kommission_id),
  CONSTRAINT fk_parent_kommission_id FOREIGN KEY (mutter_kommission_id) REFERENCES kommission (id),
  CONSTRAINT fk_zweitrat_kommission_id FOREIGN KEY (zweitrat_kommission_id) REFERENCES kommission (id)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Parlamententskommissionen';

INSERT INTO kommission (id, abkuerzung, abkuerzung_fr, name, name_fr, rat_id, typ, art, beschreibung, beschreibung_fr, sachbereiche, sachbereiche_fr, anzahl_mitglieder, anzahl_nationalraete, anzahl_staenderaete, mutter_kommission_id, zweitrat_kommission_id, von, bis, parlament_url, parlament_id, parlament_committee_number, parlament_subcommittee_number, parlament_type_code, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'SGK-N','','Kommission für soziale Sicherheit und Gesundheit Nationalrat','Commission de la sécurité sociale et de la santé publique Conseil national',1,'kommission','legislativkommission',NULL,NULL,'Sozialversicherungen;\nAltersvorsorge (Arbeitslosenversicherung: nur im Ständerat);\nSozialhilfe;\nFamiliensozialpolitik;\nGesundheitswesen; Gesundheitspolitik; Gesundheitsförderung; \nUnfall und Krankheitsprävention;\nHeilmittel;\nBetäubungs- und Suchtmittel;\nLebensmittel (Schutz der Gesundheit) und Gifte','Assurances sociales, prévoyance vieillesse (assurance-chômage uniquement pour la commission du Conseil des États);\nAide sociale;\nPolitique sociale de la famille;\nSystème de santé, politique de santé, promotion de la santé, prévention des accidents et des maladies;\nProduits thérapeutiques;\nStupéfiants et substances addictives;\nDenrées alimentaires (protection de la santé) et poisons',25,25,13,NULL,47,NULL,NULL,'http://www.parlament.ch/D/ORGANE-MITGLIEDER/KOMMISSIONEN/LEGISLATIVKOMMISSIONEN/KOMMISSIONEN-SGK/Seiten/default.aspx',6,6,NULL,NULL,'https://de.wikipedia.org/wiki/Kommissionen_f%C3%BCr_soziale_Sicherheit_und_Gesundheit','Q28499221','2014-09-16 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(3,'UREK-N','','Kommission für Umwelt, Raumplanung und Energie Nationalrat','Commission de l''environnement, de l''aménagement du territoire et de l''énergie Conseil national',1,'kommission','legislativkommission',NULL,NULL,'Umweltschutz; \nKlimapolitik und nachhaltige Entwicklung; \nNaturschutz, Heimatschutz, Gewässerschutz;\nRaumplanung und -entwicklung;\nEnergie und Energieversorung;\nWasser- und Forstwirtschaft;\nJagd, Fischerei','Protection de l''environnement, politique climatique et développement durable;\nProtection de la nature, du paysage et des eaux;\nAménagement et développement du territoire;\nÉnergie et approvisionnement en énergie;\nÉconomie hydraulique et forestière;\nChasse, pêche',25,25,13,NULL,48,NULL,NULL,'http://www.parlament.ch/D/ORGANE-MITGLIEDER/KOMMISSIONEN/LEGISLATIVKOMMISSIONEN/KOMMISSIONEN-UREK/Seiten/default.aspx',7,7,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(5,'KVF-N','','Kommission für Verkehr und Fernmeldewesen Nationalrat','Commission des transports et des télécommunications Conseil national',1,'kommission',NULL,NULL,NULL,'Verkehr (Schiene, Strasse, Zivilluftfahrt, Schifffahrt);\nTelekommunikation;\nService public (Grundversorgung und Marktregulation);\nMedien (Radio, Fernsehen, Internet);\nBundesnahe Betriebe (SBB, Post, Swisscom, skyguide, SRG)','Transports (rails, routes, aviation civile, navigation);\nTélécommunications;\nService public (desserte de base et régulation du marché);\nMédias (radio, télévision, Internet);\nEntreprises proches de la Confédération (les CFF, la Poste, Swisscom, skyguide, SSR)',25,NULL,NULL,NULL,49,NULL,NULL,NULL,9,9,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(7,'SiK-N','CPS-N','Sicherheitspolitische Kommission Nationalrat','Commission de la politique de sécurité Conseil national',1,'kommission',NULL,NULL,NULL,'Armee (inkl. Militärische Bauten);\nInnere Sicherheit und Sicherheitsverbund;\nTerrorismusbekämpfung; Polizeikoordination und polizeiliche Dienstleistungen;\nBevölkerungsschutz;\nZivildienst;\nSicherheits- und Friedenspolitik;\nMilitärische und zivile Friedensförderung im Bereich der Sicherheitspolitik;\nRüstungspolitik;\nWaffen;\nAbrüstung und Non- Proliferation;\nWirtschaftliche Landesversorgung;\nStrategische Führungsausbildung;\nKrisenmanagement des Bundes','Armée (y compris les constructions militaires);\nSécurité intérieure et réseau national de sécurité;\nLutte contre le terrorisme, coordination et prestations de service de la police;\nProtection de la population;\nService civil;\nPolitique de sécurité et de paix;\nPromotion civile et militaire de la paix dans le domaine de la politique de sécurité;\nPolitique d''armement;\nArmes;\nDésarmement et non-prolifération des armes;\nApprovisionnement économique du pays;\nFormation stratégique à la conduite, gestion des crises par la Confédération',25,NULL,NULL,NULL,50,NULL,NULL,NULL,8,8,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-10 14:18:48','2025-04-28 16:48:44'),
(9,'WBK-N','','Kommission für Wissenschaft, Bildung und Kultur Nationalrat','Commission de la science, de l''éducation et de la culture Conseil national',1,'kommission',NULL,NULL,NULL,'Wissenschaft;\nBildung (Bildungsförderung und -forschung, Aus- und Weiterbildung, usw.);\nForschung, Technologie und Innovation (Forschungs- und Innovationsförderung, Technologiefolgeabschätzung, Forschungsethik, usw.);\nSprachen und kulturelle Gemeinschaften (Förderung der Mehrsprachigkeit, Verständigung und Austausch, Sprachenfreiheit, ethnische Minderheiten);\nKultur und Kultureinrichtungen (inkl. Kulturelle Institutionen, Kulturerbe, Kulturgüterschutz und Kulturgütertransfer);\nSport;\nGeneration und Gesellschaften;\nKinder und Jugend;\nGleichstellungsfragen;\nTierschutz','Sciences;\nFormation (encouragement de la formation, recherche en éducation, perfectionnement et formation continue, etc.);\nRecherche, technologie et innovation (encouragement de la recherche et de l''innovation, évaluation des choix technologiques, éthique de la recherche, etc.);\nCommunautés linguistiques et culturelles (promotion du plurilinguisme, compréhension et échanges, liberté des langues, minorités ethniques);\nCulture et établissements culturels (y compris les institutions culturelles, le patrimoine culturel, la protection et le transfert des biens culturels);\nSport;\nGénérations et sociétés;\nEnfance et jeunesse;\nQuestions d''égalité;\nProtection des animaux',25,NULL,NULL,NULL,51,NULL,NULL,NULL,5,5,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(11,'WAK-N','','Kommission für Wirtschaft und Abgaben Nationalrat','Commission de l''économie et des redevances Conseil national',1,'kommission',NULL,NULL,NULL,'Volkswirtschaft; \nKonjunktur- und Währungspolitik;\nLandwirtschaft; \nGewerbe und Dienstleistungen (u. a. Handel, Finanzwesen, Versicherungen, Tourismus);\nSteuern (nationales und internationales Steuerwesen, Zollwesen);\nWettbewerb (Binnenmarkt, Preise, Kartelle, unlauterer Wettbewerb u. a. unter den Aspekten der Konsumenteninformation, des Konsumkredits, der technischen Handelshemmnisse, der Produktsicherheit und -qualität sowie des öffentlichen Beschaffungswesens);\nFörderung des Wirtschaftsstandortes;\nArbeitsmarkt (inkl. Arbeitslosenversicherung, nur im Nationalrat);\nGeistiges Eigentum (Patentrecht, Markenschutz usw.)',NULL,25,NULL,NULL,NULL,52,NULL,NULL,NULL,10,10,NULL,NULL,NULL,NULL,'2015-03-21 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(13,'SPK-N','','Staatspolitische Kommission Nationalrat','Commission des institutions politiques Conseil national',1,'kommission',NULL,NULL,NULL,'Bundesversammlung und Bundesrat;\nGewaltenteilung, Kompetenzverteilung zwischen den Bundesbehörden\nBundesverwaltung und Bundespersonal;\nBeziehungen zwischen Bund und Kantonen (allg. und institutionelle Fragen, Gewährleistung der kantonalen Verfassungen);\nPolitische Rechte;\nRolle des Staates bei der Meinungsbildung;\nBürgerrecht;\nAusweisschriften;\nAusländerrecht;\nAsylrecht;\nDatenschutz;\nBundesstatistik;\nBeziehungen zwischen Staat und Religion  ',NULL,25,NULL,NULL,NULL,53,NULL,NULL,NULL,11,11,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(15,'RK-N','','Kommission für Rechtsfragen Nationalrat','Commission des affaires juridiques Conseil national',1,'kommission',NULL,NULL,NULL,'Zivilgesetzbuch - Obligationenrecht - Zivilprozessordnung;\nUnlauterer Wettbewerb (vertragsrechtliche Aspekte, irreführende und vergleichende Werbung, missbräuchliche Allgemeine Geschäftsbedingungen);\nBodenrecht;\nVerfassungsgerichtsbarkeit;\nStrafrecht - Strafprozessordnung - Strafvollzug;\nGerichtsbehörden;\nGeldwäscherei;\nGeldspiele;\nEnteignung;\nSchuldbetreibung und Konkurs;\nInternationales Privatrecht;\nImmunität (nur im Ständerat); \nAmnestien (ausser Steueramnestien)',NULL,25,NULL,NULL,NULL,54,NULL,NULL,NULL,12,12,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(17,'APK-N','','Aussenpolitische Kommission Nationalrat','Commission de politique extérieure Conseil national',1,'kommission',NULL,'Gemäss Artikel 184 der Bundesverfassung (BV) besorgt der Bundesrat die auswärtigen Angelegenheiten, hat dabei aber die Mitwirkungsrechte der Bundesversammlung zu wahren. So beteiligt sich die Bundesversammlung gemäss Artikel 166 Absatz 1 BV an der Gestaltung der Aussenpolitik und beaufsichtigt die Pflege der Beziehungen zum Ausland. Konkreter bedeutet dies gemäss Artikel 24 des Parlamentsgesetzes (ParlG), dass die Bundesversammlung die internationale Entwicklung verfolgt und bei der Willensbildung über wichtige aussenpolitische Grundsatzfragen mitwirkt. Zu diesem Zweck hat der Bundesrat die zuständigen Kommissionen regelmässig, frühzeitig und umfassend über wichtige aussenpolitische Entwicklungen zu informieren (Art. 152 Abs. 2 ParlG). So orientiert der Bundesrat die APK in jeder Kommissionssitzung über aktuelle aussen-, aussenwirtschafts- und europapolitische Themen. Schliesslich konsultiert der Bundesrat die zuständigen Kommissionen zu wesentlichen Vorhaben sowie zu den Richt- und Leitlinien zum Mandat für bedeutende internationale Verhandlungen (Art. 152 Abs. 3 ParlG).','Selon l''art. 184 de la Constitution fédérale (cst.), le Conseil fédéral est responsable de la définition de la politique extérieure et de sa mise en œuvre. Néanmoins, il est tenu de respecter les droits de participation de l''Assemblée fédérale. En effet, en vertu de l''art. 166, al. 1 cst., l''Assemblée fédérale participe à la définition de la politique extérieure et surveille les relations avec l''étranger. Plus précisément, et selon l''art. 24 de la Loi sur le Parlement (LParl), les Chambres fédérales suivent l''évolution de la situation internationale et participent au processus de décision dans les questions importantes relevant de la politique extérieure. Pour réaliser cet article, le Conseil fédéral est tenu d''informer régulièrement, rapidement et de façon complète les commissions compétentes sur les événements importants survenus en matière de politique extérieure (art. 152, al. 2). Ainsi, le Conseil fédéral informe les CPE, à chaque séance, sur les actualités de politique étrangère, de politique économique extérieure, ainsi que sur les développements récents dans les relations entre la Suisse et l''Union européenne (UE) et dans l''UE. Enfin, le Conseil fédéral consulte les commissions sur les orientations principales en matière de politique extérieure et sur les directives ou lignes directrices concernant un mandat pour des négociations internationales importantes (art. 152, al. 3).','Beziehungen zu anderen Staaten sowie zur Europäischen Union;\nBeziehungen zu den internationalen Organisationen und Konferenzen (mit Ausnahme jener parlamentarischen Versammlungen, zu denen eine eigene Delegation besteht [EFTA, OSZE, NATO, usw.]);\nEntwicklungszusammenarbeit und Zusammenarbeit mit den osteuropäischen Ländern;\nHumanitäre Hilfe;\nFörderung der Menschenrechte und zivile Friedensförderung im Bereich der Aussenpolitik;\nVölkerrecht;\nFreihandelspolitik;\nNeutralität;\nImageförderung der Schweiz im Ausland;\nSitzstaatspolitik;\nAuslandschweizer;\nDiplomatisches Aussennetz','Relations avec d''autres Etats ainsi qu''avec l''Union européenne\n    Relations avec les organisations et conférences internationales (à l''exception des assemblées parlementaires pour lesquelles il existe une délégation spécifique (AELE, OSCE, OTAN, etc.)\n    Coopération au développement et coopération avec les pays d''Europe de l''Est\n    Aide humanitaire\nPromotion des droits de l''homme et promotion civile de la paix dans le domaine de la politique extérieure;\nDroit international public;\nPolitique de libre-échange;\nNeutralité;\nPromotion de l''image de la Suisse à l''étranger;\nPolitique de l''État hôte;\nSuisses de l''étranger;\nRéseau diplomatique extérieur;',25,NULL,NULL,NULL,55,NULL,NULL,NULL,4,4,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-10 14:18:48','2025-01-26 18:15:25'),
(19,'FK-N','','Finanzkommission Nationalrat','Commission des finances Conseil national',1,'kommission',NULL,NULL,NULL,'Prüfung der Voranschläge, der Nachtragskredite sowie der Rechnungen des Bundes und der Eidgenössischen Alkoholverwaltung;\nprüfung der zivilen Baubotschaften;\nOberaufsicht im Finanzbereich über die Bundesverwaltung;\nOberaufsicht über die verselbstständigten Einheiten des Bundes (z. B. Post, SBB) zusammen mit der GPK;\nVorberatung von Botschaften im Finanzbereich (z. B. Finanzhaushaltgesetz);\nMitberichte an die Legislativkommissionen zu finanzpolitisch relevanten Vorlagen',NULL,25,NULL,NULL,NULL,56,NULL,NULL,NULL,2,2,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-11-28 15:05:43','2025-01-26 18:15:25'),
(27,'GPK-N','','Geschäftsprüfungskommission Nationalrat','Commission de gestion Conseil national',1,'kommission',NULL,'Die Geschäftsprüfungskommissionen (GPK) üben gemäss Artikel 169 der Bundesverfassung (BV; SR 101) und Artikel 26 des Parlamentsgesetzes (ParlG; SR 171.10) im Auftrag der eidgenössischen Räte die Oberaufsicht aus über die Geschäftsführung des Bundesrates und der Bundesverwaltung, der eidgenössischen Gerichte und der anderen Träger von Aufgaben des Bundes mittels Inspektionen, Abklärungen, Behandlung von Jahres- und Geschäftsberichten (insbesondere des Bundesrates und der eidgenössischen Gerichte).',NULL,'Überprüfen insbesondere, ob die Bundesbehörden im Sinne der Verfassung und der Gesetze handeln; \nob die vom Gesetzgeber übertragenen Aufgaben erfüllt und die Ziele erreicht worden sind (Überprüfung der Rechtmässigkeit); \nob die vom Staat getroffenen Massnahmen sinnvoll sind und der Bundesrat seinen Entscheidungsspielraum richtig nutzt (Überprüfung der Zweckmässigkeit); \nob die vom Staat getroffenen Massnahmen die gewünschte Wirkung haben (Überprüfung der Wirksamkeit).',NULL,25,NULL,NULL,NULL,57,NULL,NULL,NULL,3,3,NULL,NULL,'https://de.wikipedia.org/wiki/Gesch%C3%A4ftspr%C3%BCfungskommission','Q1518234','2015-06-20 00:00:00','2013-11-28 16:00:46','2025-01-26 18:15:25'),
(39,'Bü-N','','Büro Nationalrat','Bureau Conseil national',1,'spezialkommission',NULL,'Das Büro ist jenes Organ eines Rates, das sich mit dem Verfahren, der Organisation und der Verwaltung des entsprechenden Rates beschäftigt. Das Büro des Nationalrates und das Büro des Ständerates bilden zusammen die Koordinationskonferenz.','Organe propre à chaque conseil assumant les tâches ayant trait à l''organisation, à la procédure et au secrétariat. Le Bureau du Conseil national et le Bureau du Conseil des États sont réunis au sein de la conférence de coordination.','Die Büros von Nationalrat und Ständerat erstellen das Sessionsprogramm des jeweiligen Rates;\nernennen die Kommissionen und Delegationen;\nweisen ihnen ihre Aufgabenbereiche und die zu behandelnden Geschäfte zu;\nlegen den Zeitplan der Beratungen fest','Les Bureaux du Conseil national et du Conseil des États élaborent le programme de la session, fixent le calendrier des délibérations pour leurs conseils respectifs, nomment les commissions et les délégations, définissent les domaines respectifs de ces dernières et leur attribuent les objets parlementaires à traiter.',25,NULL,NULL,NULL,58,NULL,NULL,'http://www.parlament.ch/D/ORGANE-MITGLIEDER/NATIONALRAT/BUERO/Seiten/default.aspx',1,1,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2013-12-13 23:45:23','2025-01-26 18:15:25'),
(47,'SGK-S','','Kommission für soziale Sicherheit und Gesundheit Ständerat','Commission de la sécurité sociale et de la santé publique Conseil des États',2,'kommission','legislativkommission',NULL,NULL,'Sozialversicherungen;\nAltersvorsorge (Arbeitslosenversicherung: nur im Ständerat);\nSozialhilfe;\nFamiliensozialpolitik;\nGesundheitswesen; Gesundheitspolitik; Gesundheitsförderung; \nUnfall und Krankheitsprävention;\nHeilmittel;\nBetäubungs- und Suchtmittel;\nLebensmittel (Schutz der Gesundheit) und Gifte','Assurances sociales, prévoyance vieillesse (assurance-chômage uniquement pour la commission du Conseil des États);\nAide sociale;\nPolitique sociale de la famille;\nSystème de santé, politique de santé, promotion de la santé, prévention des accidents et des maladies;\nProduits thérapeutiques;\nStupéfiants et substances addictives;\nDenrées alimentaires (protection de la santé) et poisons',13,25,13,NULL,1,NULL,NULL,'http://www.parlament.ch/D/ORGANE-MITGLIEDER/KOMMISSIONEN/LEGISLATIVKOMMISSIONEN/KOMMISSIONEN-SGK/Seiten/default.aspx',19,19,NULL,NULL,'https://de.wikipedia.org/wiki/Kommissionen_f%C3%BCr_soziale_Sicherheit_und_Gesundheit','Q28499221','2014-09-16 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(48,'UREK-S','','Kommission für Umwelt, Raumplanung und Energie Ständerat','Commission de l''environnement, de l''aménagement du territoire et de l''énergie Conseil des États',2,'kommission','legislativkommission',NULL,NULL,'Umweltschutz; \nKlimapolitik und nachhaltige Entwicklung; \nNaturschutz, Heimatschutz, Gewässerschutz;\nRaumplanung und -entwicklung;\nEnergie und Energieversorung;\nWasser- und Forstwirtschaft;\nJagd, Fischerei','Protection de l''environnement, politique climatique et développement durable;\nProtection de la nature, du paysage et des eaux;\nAménagement et développement du territoire;\nÉnergie et approvisionnement en énergie;\nÉconomie hydraulique et forestière;\nChasse, pêche',13,25,13,NULL,3,NULL,NULL,'http://www.parlament.ch/D/ORGANE-MITGLIEDER/KOMMISSIONEN/LEGISLATIVKOMMISSIONEN/KOMMISSIONEN-UREK/Seiten/default.aspx',20,20,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(49,'KVF-S','','Kommission für Verkehr und Fernmeldewesen Ständerat','Commission des transports et des télécommunications Conseil des États',2,'kommission',NULL,NULL,NULL,'Verkehr (Schiene, Strasse, Zivilluftfahrt, Schifffahrt);\nTelekommunikation;\nService public (Grundversorgung und Marktregulation);\nMedien (Radio, Fernsehen, Internet);\nBundesnahe Betriebe (SBB, Post, Swisscom, skyguide, SRG)','Transports (rails, routes, aviation civile, navigation);\nTélécommunications;\nService public (desserte de base et régulation du marché);\nMédias (radio, télévision, Internet);\nEntreprises proches de la Confédération (les CFF, la Poste, Swisscom, skyguide, SSR)',13,NULL,NULL,NULL,5,NULL,NULL,NULL,22,22,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(50,'SiK-S','','Sicherheitspolitische Kommission Ständerat','Commission de la politique de sécurité Conseil des États',2,'kommission',NULL,NULL,NULL,'Armee (inkl. Militärische Bauten);\nInnere Sicherheit und Sicherheitsverbund;\nTerrorismusbekämpfung; Polizeikoordination und polizeiliche Dienstleistungen;\nBevölkerungsschutz;\nZivildienst;\nSicherheits- und Friedenspolitik;\nMilitärische und zivile Friedensförderung im Bereich der Sicherheitspolitik;\nRüstungspolitik;\nWaffen;\nAbrüstung und Non- Proliferation;\nWirtschaftliche Landesversorgung;\nStrategische Führungsausbildung;\nKrisenmanagement des Bundes','Armée (y compris les constructions militaires);\nSécurité intérieure et réseau national de sécurité;\nLutte contre le terrorisme, coordination et prestations de service de la police;\nProtection de la population;\nService civil;\nPolitique de sécurité et de paix;\nPromotion civile et militaire de la paix dans le domaine de la politique de sécurité;\nPolitique d''armement;\nArmes;\nDésarmement et non-prolifération des armes;\nApprovisionnement économique du pays;\nFormation stratégique à la conduite, gestion des crises par la Confédération',13,NULL,NULL,NULL,7,NULL,NULL,NULL,21,21,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(51,'WBK-S','','Kommission für Wissenschaft, Bildung und Kultur Ständerat','Commission de la science, de l''éducation et de la culture Conseil des États',2,'kommission',NULL,NULL,NULL,'Wissenschaft;\nBildung (Bildungsförderung und -forschung, Aus- und Weiterbildung, usw.);\nForschung, Technologie und Innovation (Forschungs- und Innovationsförderung, Technologiefolgeabschätzung, Forschungsethik, usw.);\nSprachen und kulturelle Gemeinschaften (Förderung der Mehrsprachigkeit, Verständigung und Austausch, Sprachenfreiheit, ethnische Minderheiten);\nKultur und Kultureinrichtungen (inkl. Kulturelle Institutionen, Kulturerbe, Kulturgüterschutz und Kulturgütertransfer);\nSport;\nGeneration und Gesellschaften;\nKinder und Jugend;\nGleichstellungsfragen;\nTierschutz','Sciences;\nFormation (encouragement de la formation, recherche en éducation, perfectionnement et formation continue, etc.);\nRecherche, technologie et innovation (encouragement de la recherche et de l''innovation, évaluation des choix technologiques, éthique de la recherche, etc.);\nCommunautés linguistiques et culturelles (promotion du plurilinguisme, compréhension et échanges, liberté des langues, minorités ethniques);\nCulture et établissements culturels (y compris les institutions culturelles, le patrimoine culturel, la protection et le transfert des biens culturels);\nSport;\nGénérations et sociétés;\nEnfance et jeunesse;\nQuestions d''égalité;\nProtection des animaux',13,NULL,NULL,NULL,9,NULL,NULL,NULL,18,18,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(52,'WAK-S','','Kommission für Wirtschaft und Abgaben Ständerat','Commission de l''économie et des redevances Conseil des États',2,'kommission',NULL,NULL,NULL,'Volkswirtschaft; \nKonjunktur- und Währungspolitik;\nLandwirtschaft; \nGewerbe und Dienstleistungen (u. a. Handel, Finanzwesen, Versicherungen, Tourismus);\nSteuern (nationales und internationales Steuerwesen, Zollwesen);\nWettbewerb (Binnenmarkt, Preise, Kartelle, unlauterer Wettbewerb u. a. unter den Aspekten der Konsumenteninformation, des Konsumkredits, der technischen Handelshemmnisse, der Produktsicherheit und -qualität sowie des öffentlichen Beschaffungswesens);\nFörderung des Wirtschaftsstandortes;\nArbeitsmarkt (inkl. Arbeitslosenversicherung, nur im Nationalrat);\nGeistiges Eigentum (Patentrecht, Markenschutz usw.)',NULL,13,NULL,NULL,NULL,11,NULL,NULL,NULL,23,23,NULL,NULL,NULL,NULL,'2015-03-21 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(53,'SPK-S','','Staatspolitische Kommission Ständerat','Commission des institutions politiques Conseil des États',2,'kommission',NULL,NULL,NULL,'Bundesversammlung und Bundesrat;\nGewaltenteilung, Kompetenzverteilung zwischen den Bundesbehörden\nBundesverwaltung und Bundespersonal;\nBeziehungen zwischen Bund und Kantonen (allg. und institutionelle Fragen, Gewährleistung der kantonalen Verfassungen);\nPolitische Rechte;\nRolle des Staates bei der Meinungsbildung;\nBürgerrecht;\nAusweisschriften;\nAusländerrecht;\nAsylrecht;\nDatenschutz;\nBundesstatistik;\nBeziehungen zwischen Staat und Religion  ',NULL,13,NULL,NULL,NULL,13,NULL,NULL,NULL,24,24,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(54,'RK-S','','Kommission für Rechtsfragen Ständerat','Commission des affaires juridiques Conseil des États',2,'kommission',NULL,NULL,NULL,'Zivilgesetzbuch - Obligationenrecht - Zivilprozessordnung;\nUnlauterer Wettbewerb (vertragsrechtliche Aspekte, irreführende und vergleichende Werbung, missbräuchliche Allgemeine Geschäftsbedingungen);\nBodenrecht;\nVerfassungsgerichtsbarkeit;\nStrafrecht - Strafprozessordnung - Strafvollzug;\nGerichtsbehörden;\nGeldwäscherei;\nGeldspiele;\nEnteignung;\nSchuldbetreibung und Konkurs;\nInternationales Privatrecht;\nImmunität (nur im Ständerat); \nAmnestien (ausser Steueramnestien)',NULL,13,NULL,NULL,NULL,15,NULL,NULL,NULL,25,25,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(55,'APK-S','','Aussenpolitische Kommission Ständerat','Commission de politique extérieure Conseil des États',2,'kommission',NULL,'Gemäss Artikel 184 der Bundesverfassung (BV) besorgt der Bundesrat die auswärtigen Angelegenheiten, hat dabei aber die Mitwirkungsrechte der Bundesversammlung zu wahren. So beteiligt sich die Bundesversammlung gemäss Artikel 166 Absatz 1 BV an der Gestaltung der Aussenpolitik und beaufsichtigt die Pflege der Beziehungen zum Ausland. Konkreter bedeutet dies gemäss Artikel 24 des Parlamentsgesetzes (ParlG), dass die Bundesversammlung die internationale Entwicklung verfolgt und bei der Willensbildung über wichtige aussenpolitische Grundsatzfragen mitwirkt. Zu diesem Zweck hat der Bundesrat die zuständigen Kommissionen regelmässig, frühzeitig und umfassend über wichtige aussenpolitische Entwicklungen zu informieren (Art. 152 Abs. 2 ParlG). So orientiert der Bundesrat die APK in jeder Kommissionssitzung über aktuelle aussen-, aussenwirtschafts- und europapolitische Themen. Schliesslich konsultiert der Bundesrat die zuständigen Kommissionen zu wesentlichen Vorhaben sowie zu den Richt- und Leitlinien zum Mandat für bedeutende internationale Verhandlungen (Art. 152 Abs. 3 ParlG).','Selon l''art. 184 de la Constitution fédérale (cst.), le Conseil fédéral est responsable de la définition de la politique extérieure et de sa mise en œuvre. Néanmoins, il est tenu de respecter les droits de participation de l''Assemblée fédérale. En effet, en vertu de l''art. 166, al. 1 cst., l''Assemblée fédérale participe à la définition de la politique extérieure et surveille les relations avec l''étranger. Plus précisément, et selon l''art. 24 de la Loi sur le Parlement (LParl), les Chambres fédérales suivent l''évolution de la situation internationale et participent au processus de décision dans les questions importantes relevant de la politique extérieure. Pour réaliser cet article, le Conseil fédéral est tenu d''informer régulièrement, rapidement et de façon complète les commissions compétentes sur les événements importants survenus en matière de politique extérieure (art. 152, al. 2). Ainsi, le Conseil fédéral informe les CPE, à chaque séance, sur les actualités de politique étrangère, de politique économique extérieure, ainsi que sur les développements récents dans les relations entre la Suisse et l''Union européenne (UE) et dans l''UE. Enfin, le Conseil fédéral consulte les commissions sur les orientations principales en matière de politique extérieure et sur les directives ou lignes directrices concernant un mandat pour des négociations internationales importantes (art. 152, al. 3).','Beziehungen zu anderen Staaten sowie zur Europäischen Union;\nBeziehungen zu den internationalen Organisationen und Konferenzen (mit Ausnahme jener parlamentarischen Versammlungen, zu denen eine eigene Delegation besteht [EFTA, OSZE, NATO, usw.]);\nEntwicklungszusammenarbeit und Zusammenarbeit mit den osteuropäischen Ländern;\nHumanitäre Hilfe;\nFörderung der Menschenrechte und zivile Friedensförderung im Bereich der Aussenpolitik;\nVölkerrecht;\nFreihandelspolitik;\nNeutralität;\nImageförderung der Schweiz im Ausland;\nSitzstaatspolitik;\nAuslandschweizer;\nDiplomatisches Aussennetz','Relations avec d''autres Etats ainsi qu''avec l''Union européenne\n    Relations avec les organisations et conférences internationales (à l''exception des assemblées parlementaires pour lesquelles il existe une délégation spécifique (AELE, OSCE, OTAN, etc.)\n    Coopération au développement et coopération avec les pays d''Europe de l''Est\n    Aide humanitaire\nPromotion des droits de l''homme et promotion civile de la paix dans le domaine de la politique extérieure;\nDroit international public;\nPolitique de libre-échange;\nNeutralité;\nPromotion de l''image de la Suisse à l''étranger;\nPolitique de l''État hôte;\nSuisses de l''étranger;\nRéseau diplomatique extérieur;',13,NULL,NULL,NULL,17,NULL,NULL,NULL,17,17,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(56,'FK-S','','Finanzkommission Ständerat','Commission des finances Conseil des États',2,'kommission',NULL,NULL,NULL,'Prüfung der Voranschläge, der Nachtragskredite sowie der Rechnungen des Bundes und der Eidgenössischen Alkoholverwaltung;\nprüfung der zivilen Baubotschaften;\nOberaufsicht im Finanzbereich über die Bundesverwaltung;\nOberaufsicht über die verselbstständigten Einheiten des Bundes (z. B. Post, SBB) zusammen mit der GPK;\nVorberatung von Botschaften im Finanzbereich (z. B. Finanzhaushaltgesetz);\nMitberichte an die Legislativkommissionen zu finanzpolitisch relevanten Vorlagen',NULL,13,NULL,NULL,NULL,19,NULL,NULL,NULL,15,15,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(57,'GPK-S','','Geschäftsprüfungskommission Ständerat','Commission de gestion Conseil des États',2,'kommission',NULL,'Die Geschäftsprüfungskommissionen (GPK) üben gemäss Artikel 169 der Bundesverfassung (BV; SR 101) und Artikel 26 des Parlamentsgesetzes (ParlG; SR 171.10) im Auftrag der eidgenössischen Räte die Oberaufsicht aus über die Geschäftsführung des Bundesrates und der Bundesverwaltung, der eidgenössischen Gerichte und der anderen Träger von Aufgaben des Bundes mittels Inspektionen, Abklärungen, Behandlung von Jahres- und Geschäftsberichten (insbesondere des Bundesrates und der eidgenössischen Gerichte).',NULL,'Überprüfen insbesondere, ob die Bundesbehörden im Sinne der Verfassung und der Gesetze handeln; \nob die vom Gesetzgeber übertragenen Aufgaben erfüllt und die Ziele erreicht worden sind (Überprüfung der Rechtmässigkeit); \nob die vom Staat getroffenen Massnahmen sinnvoll sind und der Bundesrat seinen Entscheidungsspielraum richtig nutzt (Überprüfung der Zweckmässigkeit); \nob die vom Staat getroffenen Massnahmen die gewünschte Wirkung haben (Überprüfung der Wirksamkeit).',NULL,13,NULL,NULL,NULL,27,NULL,NULL,NULL,16,16,NULL,NULL,'https://de.wikipedia.org/wiki/Gesch%C3%A4ftspr%C3%BCfungskommission','Q1518234','2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(58,'Bü-S','','Büro Ständerat','Bureau Conseil des États',2,'spezialkommission',NULL,'Das Büro ist jenes Organ eines Rates, das sich mit dem Verfahren, der Organisation und der Verwaltung des entsprechenden Rates beschäftigt. Das Büro des Nationalrates und das Büro des Ständerates bilden zusammen die Koordinationskonferenz.','Organe propre à chaque conseil assumant les tâches ayant trait à l''organisation, à la procédure et au secrétariat. Le Bureau du Conseil national et le Bureau du Conseil des États sont réunis au sein de la conférence de coordination.','Die Büros von Nationalrat und Ständerat erstellen das Sessionsprogramm des jeweiligen Rates;\nernennen die Kommissionen und Delegationen;\nweisen ihnen ihre Aufgabenbereiche und die zu behandelnden Geschäfte zu;\nlegen den Zeitplan der Beratungen fest','Les Bureaux du Conseil national et du Conseil des États élaborent le programme de la session, fixent le calendrier des délibérations pour leurs conseils respectifs, nomment les commissions et les délégations, définissent les domaines respectifs de ces dernières et leur attribuent les objets parlementaires à traiter.',13,NULL,NULL,NULL,39,NULL,NULL,NULL,14,14,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-16 21:26:16','2025-01-26 18:15:25'),
(59,'Bü-VBV','','Büro Vereinigte Bundesversammlung','Bureau Assemblée fédérale',4,'kommission','weitere kommission',NULL,NULL,'Das Büro ist jenes Organ eines Rates, das sich mit dem Verfahren, der Organisation und der Verwaltung des entsprechenden Rates beschäftigt.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,708,708,NULL,NULL,NULL,NULL,'2015-06-20 00:00:00','2015-02-23 21:16:59','2025-01-26 18:15:25'),
(60,'IK-N','','Immunitätskommission Nationalrat','Commission de l''immunité Conseil national',1,'kommission','weitere kommission','Gesuche für die Aufhebung der Immunität von Ratsmitgliedern und von der Bundesversammlung gewählten Behördenmitgliedern (Art. 17 Abs. 1 und Art. 20 Abs. 1 ParlG, Art. 14 Abs. 1 VG) werden von den zuständigen Kommissionen beider Räte behandelt. Im Nationalrat ist eine eigens zu diesem Zweck geschaffene Immunitätskommission (IK) zuständig; im Ständerat werden die Gesuche von der Kommission für Rechtsfragen (RK-S) behandelt. Die IK setzt sich aus neun Mitgliedern zusammen; für jedes Mitglied wird eine ständige Stellvertreterin oder ein ständiger Stellvertreter gewählt.','Les requêtes visant à lever l''immunité de députés et de membres d''autorités élus par l''Assemblée fédérale (art. 17, al. 1, et art. 20, al. 1, LParl ; art. 14, al. 1, LRCF) sont examinées par les commissions compétentes de chacun des deux conseils. Si le Conseil des Etats a confié ce mandat à sa Commission des affaires juridiques (CAJ-E), le Conseil national a, pour sa part, créé une commission spécialement à cet effet : il s''agit de la Commission de l''immunité (CI), qui est constituée de neuf membres (un remplaçant permanent étant désigné pour chacun d''eux).','Bearbeitung der Gesuche für die Aufhebung der Immunität von Ratsmitgliedern',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'http://www.parlament.ch/d/organe-mitglieder/kommissionen/weitere-kommissionen/immunitaetskommission/Seiten/default.aspx',940,940,NULL,1,NULL,NULL,'2015-06-20 00:00:00','2015-02-23 21:20:36','2025-01-26 18:15:25');

DROP TABLE IF EXISTS branche;
CREATE TABLE branche (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Branche',
  name varchar(100) NOT NULL COMMENT 'Name der Branche, z.B. Gesundheit, Energie',
  name_fr varchar(100) DEFAULT NULL COMMENT 'Französischer Name der Branche, z.B. Gesundheit, Energie',
  kommission_id int(11) DEFAULT NULL COMMENT 'Zuständige Kommission im Nationalrat',
  kommission2_id int(11) DEFAULT NULL COMMENT 'Zuständige Kommission im Ständerat',
  technischer_name varchar(30) NOT NULL COMMENT 'Technischer Name für Branche. Keine Sonderzeichen sind erlaubt. Wird z.B. für das finden des Branchensymboles gebraucht.',
  beschreibung mediumtext NOT NULL COMMENT 'Beschreibung der Branche',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Französische Beschreibung der Branche',
  angaben mediumtext DEFAULT NULL COMMENT 'Angaben zur Branche',
  angaben_fr mediumtext DEFAULT NULL COMMENT 'Angaben zur Branche auf Französisch',
  isicv4 varchar(25) DEFAULT NULL COMMENT 'ISICv4-Codes, getrennt durch Leerzeichen. "International Standard of Industrial Classification of All Economic Activities (ISIC), Revision 4" ist ein Einteilungsstandard von Unternehmen der UNO, siehe https://unstats.un.org/unsd/publication/SeriesM/seriesm_4rev4e.pdf',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY branche_name_unique (name) COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY technischer_name (technischer_name),
  KEY idx_kommission_freigabe (kommission_id,freigabe_datum),
  KEY kommission2_id (kommission2_id),
  CONSTRAINT fk_kommission2_id FOREIGN KEY (kommission2_id) REFERENCES kommission (id),
  CONSTRAINT fk_kommission_id FOREIGN KEY (kommission_id) REFERENCES kommission (id)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Wirtschaftsbranchen';

INSERT INTO branche (id, name, name_fr, kommission_id, kommission2_id, technischer_name, beschreibung, beschreibung_fr, angaben, angaben_fr, isicv4, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'Gesundheit','Santé',1,47,'gesundheit','Akteure im Gesundheitswesen','Acteurs dans le domaine de la santé','Wie werden die ca. 60 Milliarden jährlich aufgeteilt','Comment se répartissent environ 60 milliards par année',NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(2,'Soziale Sicherheit','Sécurité sociale',1,47,'soziale_sicherheit','Akteure im Bereich sozialer Sicherheit','Acteurs dans le domaine de la sécurité sociale',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(3,'Energie','Énergie',3,48,'energie','Akteure der Energiebranche','Acteurs du secteur de l''énergie',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(4,'Umwelt','Environnement',3,48,'umwelt','Akteure im Bereich Umwelt','Acteurs dans le domaine de l''environnement',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(5,'Verkehr','Transport',5,49,'verkehr','Akteure der Verkehrsbranche','Acteurs dans le domaine des transports',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(7,'Bildung','Formation',9,51,'bildung','','',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(8,'Kultur','Culture',9,51,'kultur','','',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(9,'Wirtschaft','Économie',11,52,'wirtschaft','','',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(13,'Aussenpolitik/Aussenwirtschaft','Politique étrangère / Commerce extérieur',17,55,'aussenpolitik_aussenwirtschaft','','',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(14,'Staatspolitik/Staatswirtschaft','Politique intérieure / Economie publique',13,53,'staatspolitik_staatswirtschaft','','',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(15,'Landwirtschaft','Agriculture',11,52,'landwirtschaft','Landwirtschaftspolitik, Firmen, Verbände der Landwirtschaft.','Politique agricole, groupes d''intérêt et entreprises liées à l''agriculture',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(16,'Sicherheit','Sécurité',7,50,'sicherheit','Armee, innere Sicherheit, Rüstungsindustrie, Wehrtechnik, Friedenspolitik, Rettungswesen','Armée, sécurité intérieure, industrie de l''armement, technique militaire, politique de paix, organisations de sauvetage',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(17,'Sport','Sport',9,51,'sport','Sportverbände, Institutionen etc.','Associations et institutions sportives',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31'),
(18,'Kommunikation','Communication',5,49,'kommunikation','Medien, Verlage, Kommunikationsdienstleister','Médias, éditeurs, services dans le domaine de la communication',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-05-15 22:09:31');

DROP TABLE IF EXISTS interessengruppe;
CREATE TABLE interessengruppe (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Interessengruppe',
  name varchar(150) NOT NULL COMMENT 'Bezeichnung der Interessengruppe',
  name_fr varchar(150) DEFAULT NULL COMMENT 'Französische Bezeichnung der Interessengruppe',
  branche_id int(11) NOT NULL COMMENT 'Fremdschlüssel Branche',
  beschreibung mediumtext NOT NULL COMMENT 'Eingrenzung und Beschreibung zur Interessengruppe',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Eingrenzung und Beschreibung zur Interessengruppe auf französisch',
  alias_namen varchar(255) DEFAULT NULL COMMENT 'Strichpunkt-getrennte Aufzählung von alternative Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.',
  alias_namen_fr varchar(255) DEFAULT NULL COMMENT 'Strichpunkt-getrennte Aufzählung von alternativen französischen Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.',
  isicv4 varchar(25) DEFAULT NULL COMMENT 'ISICv4-Codes, getrennt durch Leerzeichen. International Standard of Industrial Classification of All Economic Activities (ISIC), Revision 4 ist ein Einteilungsstandard der UNO, siehe https://unstats.un.org/unsd/publication/SeriesM/seriesm_4rev4e.pdf',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  PRIMARY KEY (id),
  UNIQUE KEY interessengruppe_name_unique (name) COMMENT 'Fachlicher unique constraint',
  KEY idx_branche_freigabe (branche_id,freigabe_datum),
  CONSTRAINT fk_lg_lt FOREIGN KEY (branche_id) REFERENCES branche (id)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Interessengruppen einer Branche';

INSERT INTO interessengruppe (id, name, name_fr, branche_id, beschreibung, beschreibung_fr, alias_namen, alias_namen_fr, isicv4, wikipedia, wikidata_qid, freigabe_datum, created_date, updated_date) VALUES
(1,'Pharma','Pharmaceutique',1,'Medikamentenforschung, Medikamentenvertrieb, Pharmafirmen, Apotheken','Recherche pharmaceutique, vente de médicaments, entreprises pharmaceutiques, pharmacies.',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2014-11-26 19:22:17'),
(2,'Krankenkassen','Caisses maladie',1,'Krankenkassen, Dachorganisationen KK, Unterorganisationen KK','Caisses maladie, organisations faîtières des caisses maladies, sous-organisations des caisses maladie.','Krankenkassen; Krankenversicherungen; Gesundheitskassen; KK;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-01-12 06:58:30'),
(3,'Gesundheit','Santé',1,'Gesundheitsförderung, Drogenmissbrauch','Prévention de la santé','Gesundheitsförderung; Wohlbefinden; Drogenmissbrauch; Prävention;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-01-06 19:50:06'),
(4,'Arztmedizin','Médecine',1,'Ärzte, Arzmedizin, Berufsorganisationen Ärzte, medizinische Dienstleistungen, Physiotherapie, Hebammen','Médecins, médecine, organisations professionnelles des médecins, services médicaux, physiothérapie, sages-femmes','Ärzte; Arzt; Mediziner; Ärzteschaft; FMH; Physiotherapie; Hebammen; Leistungserbringer;',NULL,NULL,NULL,NULL,'2014-12-12 08:55:43','2013-11-10 14:18:53','2014-12-12 08:55:43'),
(5,'Spitäler','Hôpitaux',1,'Spitäler, Spitalorganisationen','Hôpitaux, organisations représentatives d''hôpitaux',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2014-11-26 19:26:32'),
(6,'Patient:innen','Patient·e·x·s',1,'Patientenorganisationen, Gesundheitskonsumenten','Organisations de défense des patients',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2024-07-23 15:52:18'),
(7,'Spitex','Spitex',1,'Spitex, Spitexverbände und -Organisationen','Organisation liées à Spitex',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-03-11 09:50:28'),
(8,'Öffentliches Gesundheitswesen','Santé publique',1,'Gesundheitsdirektoren, Kantone, öffentliche Gesundheitsorganisationen,Gesundheitsfinanzierer','Directions de la santé, cantons, organisations publiques de santé, financement de la santé','öffentliches Gesundheitswesen; Gesundheitsorganisationen; Gesundheitsdirektoren','',NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-03-11 09:50:28'),
(9,'Medizinaltechniken','Techniques médicales',1,'Forschung, Handel, technische Hilfsmittel im Bereich Medizinaltechnik','Recherche, commerce et solutions dans le domaine de la technique médicale','Medizinaltechnik; Medizintechnik; Hüftgelenke; Stents; Medtech; Implantate; Implantathersteller; Prothesen','',NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:53','2015-03-11 09:50:28'),
(10,'Musik','Musique',8,'Musiker, Produzenten etc, verschiedener Ausrichtung. zB. Rock- und Popmusik, Vereinigungen von Künstlern in diesem Bereich. Auch Klassik; Orchester etc.','Musiciens, orchestres, producteurs et autre métiers liées à tout genre musical, ainsi que les associations y liées.','Rock; Pop; Musiker; Musikproduzenten; Jazz; Klassik; Volkstümlich; Orchester; Band; Konzert; Konzertveranstalter; Openair;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-03 15:00:49','2015-03-11 09:50:28'),
(12,'Gemeinwohl/Gesellschaft','Communauté/Société',2,'Gemeinnützige Institutionen im sozialen Bereich. Ums Wohl der Gesellschaft in verschiedener Hinsicht (Alter, Jugend,  Behinderung, Gewalt etc.)','','Jugend; Behinderte; Gewaltprävention; Gemeinwohl; Alter; Behinderung; Handicap; Behindertenorganisation, Kinder, KESB, Soziale Einrichtung','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-04 17:42:24','2016-08-30 18:59:49'),
(13,'Kantone/Regionen','Cantons/Régions',14,'Vertreter von Kantonen, Repräsentanten wie zB Regierungsräte, Generalsekretäre, Mitglieder der Legislativen, Funktionäre der kantonalen Parteien; Regionen wie zB Regions Basiliensis, Espace Mittelland','','Kantone, Regierungsrat; Kantonsrat; Grosser Rat; Regionen, Regio; Regierungsrat; Regierungsräte;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-04 17:57:19','2015-03-11 09:50:28'),
(14,'Städte','Villes',14,'vor allem im Ständeverband organisierte Exponenten. Aber auch Parteifunktionäre auf Stadt-Ebene (nicht Gemeinden unterhalb Stadtgrösse).','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-04 17:59:43','2015-03-11 09:50:28'),
(15,'Behinderung','Handicap',1,'Organisationen, die sich mit Menschen mit Beeinträchtigungen beschäftigen.','Organisations de défense des handicapés','Behinderung; Handicap; Behinderte; Behindertenorganisation; Gebrechen;',NULL,NULL,NULL,NULL,'2014-12-12 08:55:43','2014-02-24 21:52:54','2023-11-20 22:01:46'),
(16,'Banken','Banques',9,'Banken, Kantonalbanken, Privatbanken, Anlagefonds, kollektive Kapitalgesellschaften','','Bank; Banken; Kantonalbank; Privatbank; Anlagefonds; Fonds; Hedgefunds; KKG, kollektive Kapitalgesellschagft','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-03-19 18:34:04','2015-03-11 09:50:28'),
(17,'Rohstoffhandel','Commerce de matières premières',9,'zB Clencore, Gasindustrie, Ölindustrie',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 18:35:22','2017-04-07 10:12:49'),
(18,'Consulting/PR','Conseil en relations publiques',9,'PR- und Public Affairs-Firmen, Kommunikationsagenturen, Consultingunternehmen.',NULL,'Consulting; PR; Public Relations; Corporate Communications; Public Affairs, Spin doctors; Kommunikationsunternehmen; Kommunikationsagentur; politische Kommunikation; Unternehmenskommunikation; Kommunikation; Lobbyismus; Lobbyfirma; Lobbyfirmen; Lobbyunter',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 18:37:55','2015-03-23 21:22:04'),
(19,'Immobilien/Hauseigentümer:innen','Immobilier et propriétaires fonciers',9,'Immobilienhändler, Hauseigentümer, Makler, Wohnbaugenossenschaften',NULL,'Hausbesitzer; Wohnbaugenossenschaften; Immobilienmakler; Immobilienfirmen; Hauseigentümer; Wohnungeigentümer; Wohnungsbesitzer; Hypothekarschuldner',NULL,NULL,NULL,NULL,'2015-01-09 07:22:36','2014-03-19 18:39:21','2024-07-22 16:39:40'),
(20,'Parteien','Partis',14,'alle Parteien','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 18:43:45','2015-03-11 09:50:28'),
(21,'Militärgeschichte','Histoire militaire',16,'Militärhistoriker/Militär-Reisen, Vereinigungen, die ehemalige Bunker betreiben etc.',NULL,'Militärhistorie; Militärgeschichte; Armeegeschichte; Bunker; Militärhistoriker; Armeehistoriker; Militaria',NULL,NULL,NULL,NULL,'2015-01-09 07:22:36','2014-03-19 18:46:43','2017-03-30 15:18:59'),
(23,'Wirtschaft allgemein','Economie en général',9,'Gremien, die sich mit wirtschaftlichen Fragen auseinandersetzen, beraten, promoten. Wie zB. Swiss Economic Forum und andere.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 18:56:06','2018-08-22 13:02:56'),
(24,'Migration','Immigration',14,'Asylwesen, Ausländerrecht, Flüchtlingswesen','','Asyl; Asylwesen; Asylpolitik; Ausländer; Ausländerpolitik; Flüchtllinge; Flüchtlingspolitik; Migration; Migrationspolitik;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:00:51','2015-03-11 09:50:28'),
(25,'Hilfswerke','Oeuvres d''entraide',2,'Hilfswerke allgemein wie zB Heks aber auch Stiftungen in ähnlicher RIchtung','','Hilfswerk; Bedürftige; Sozial; Benachteiligte','',NULL,NULL,NULL,'2015-01-09 07:22:36','2014-03-19 19:01:42','2015-03-11 09:50:28'),
(26,'Individualverkehr','Transport individuel',5,'motorisierter Individualverkehr wie zB TCS, ACS, aber auch Mobility','','MIV; Individualverkehr; Autofahrer, Autobesitzer, PW-Besitzer; Personenwagen; Autovermieter; Autovermietung; Carsharing','',NULL,NULL,NULL,'2015-01-09 07:22:36','2014-03-19 19:04:10','2016-08-30 19:14:27'),
(27,'Bildungsförderung','Promotion de la formation',7,'Insitutionen, die die Bildung fördern, Stipendien vergeben etc.','Institutions qui promeuvent la formation, dispensent des bourses d''études, etc.','Bildungsförderung; Stipendium; Stipendien; Nationalfonds; Fördergelder',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:07:53','2018-06-21 10:45:59'),
(28,'Privatschulen','Ecoles privées',7,'Privatschulen aller Niveaus','Ecoles privées de tout niveau',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:08:34','2015-03-11 09:50:28'),
(29,'Energieversorgung','Fournisseur d''énergie',3,'Elektrizitätsversorger, örtliche EWS, Firmen der Energiewirtschaft etc.',NULL,'Energieversorger; Elektrizitätswerk; EVU; Energiewirtschaft;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:11:28','2024-07-22 16:44:41'),
(30,'Atomenergie','Energie nucléaire',3,'Atomlobby, herkömmliche Energieträger','Lobby nucléaire, fournisseurs d''énergie classiques','Atomlobby; AKW-Befürworter; Kernkraft-Befürworter; AKW, KKW; Nuklearenergie; Kernkraft; Atomkraft; Atomenergie; Kernenergie','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-03-19 19:14:55','2015-03-11 09:50:28'),
(31,'Energie allgemein','Energie en général',3,'allgemeine Tätigkeiten im Energiesektor, zb Energie-Agentur der Wirtschaft, Energiestadt Label.','Activités générales dans le domaine de l''énergie, p. ex. agence énergétique dans l''économie, label Energiestadt','Energieagentur; Energiestadt; Energie-Label; Energieeffizienzlabel; Energielabel','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:16:41','2015-03-11 09:50:28'),
(32,'Erneuerbare Energien','Energies alternatives',3,'Erneuerbare Energien, alternative Energien, Vereinigungen, zb SES, Dachorganisation für erneuerbare Energien.','Associations pour les énergies alternatives','Erneuerbare; erneuerbare Energie; Naturstrom; Anti-AKW; Atomausstieg; Windkraft; Windenergie; Sonnenenergie; Solarenergie; Photovoltaik; Kleinwasserkraft; Geothermie; Erdwärme; Solarstrom;',NULL,NULL,NULL,NULL,'2014-12-12 08:55:43','2014-03-19 19:20:39','2024-03-11 09:29:26'),
(33,'Öffentlicher Verkehr','Transports publics',5,'lokale ÖV-Unternehmen, Verbände des öffentlichen Verkehrs, Litra, VÖV, VCS etc','','ÖV; öffentlicher Verkehr; Bahn; Bus; Tram; Schiff; Seilbahn;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:23:43','2016-08-30 19:14:27'),
(34,'Kunsthandwerk','Artisanat culturel',8,'Kunsthandwerk-Förderung, Buchbinder','Promotion de l''artisanat culturel, relieurs','Kunsthandwerk; Buchbinder; Kunsthandwerker;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:26:05','2015-03-11 09:50:28'),
(35,'Staatspolitik allgemein','Politique en général',14,'Institutionen mit staatspolitischen Anliegen, auch Bürgergemeinden, Korporationen etc. sowie Organisationen, die der Unterstützung von Parteien dienen, Fundraisingorganisationen von Parteien etc.','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:28:35','2015-03-11 09:50:28'),
(36,'Logistik/Transport','Logistique/Transport',5,'Logistik, Transport, Spedition, inkl Verbände wie Asta, aber auch zB Spedlogswiss, Camionneure sowie Unternehmen aus dem Bereich Nutzfahrzeuge. Auch Frachtschiffahrt auf dem Rhein',NULL,'Logistik; Transport; Spedition; Camionneure; Schwerverkehr; Lastwagen; Logistiker; Logistikunternehmen, Rheinhäfen',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:33:01','2016-08-30 19:14:27'),
(38,'Nahrungsmittel','Alimentation',9,'Nahrungsmittelproduzenten, Schokolade, Früchte, Kaffee, Getränkeindustrie etc. inkl Milchwirtschaft (doppelte Branchen/Interessengruppe-Zuteiung)','','Nahrungsmittel; Nahrungsmittelproduzenten; Nahrungsmittelindustrie; Getränkeindustrie; Ernährung; Rohstoffe;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:39:46','2015-03-11 09:50:28'),
(39,'Milchwirtschaft','Industrie laitière',15,'Milchverarbeiter, Käsereien, Molkereien','','Michproduzenten; Milchverarbeiter; Molkereien; Milchprodukte;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:42:39','2015-03-11 09:50:28'),
(40,'Handelsbeziehungen international','Relations commerciales internationales',13,'Verbände der Exportwirtschaft, Freundschaftsvereinigungen, Delegationen zB Schweiz-Südafrika, Schweiz-Kasachstan, Schweiz-Taiwan. Idee, Handelsbeziehungen etablieren.','Groupes d''intérêt de l''industrie d''exportation, amicales internationales, délégations p. ex. Suisse-Taiwan, Suisse-Kazakhstan, avec vue d''entretenir des relations commerciales','Exportwirtschaft; Handelsbeziehungen;',NULL,NULL,NULL,NULL,'2014-11-17 14:11:38','2014-03-19 19:47:11','2017-04-07 10:16:37'),
(41,'Bildung/Wissenschaft','Formation/Science',7,'Schulen, Fachhochschulen, Unis, Universitäre Einrichtungen (div. Institute), Berufsschulen','(Hautes) écoles, universités, instituts académiques, écoles de commerce','Schulen; Schule; Fachhochschulen; Fachhochschule; Uni; Universität; Universitäten; Universitäre Einrichtungen; Institut; Berufsschule; Berufsschulen; Höhere Fachschule;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-19 19:55:03','2015-03-11 09:50:28'),
(42,'Pensionskassen','Fonds de pension et de retraite',9,'Einrichtungen der beruflichen Vorsorge nach BVG.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 08:06:58','2017-04-07 10:15:34'),
(43,'Langsamverkehr','Mobilité douce',5,'Velo','','Velofahrer; Radfahrer; Langsamverkehr; Fussgänger;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-27 11:57:17','2016-08-30 19:14:27'),
(44,'Kulturinstitutionen','Institutions culturelles',8,'Kulturinstitiutionen aller Art wie Stadttheater, Museen, Vereine, Veranstalter, Denkmalpflege. Aber auch Museen mit Sammlungen kulturhistorischer Art und gesellschaftlichen Themen (Ballenberg, Verkehrshaus etc.)','Institutions culturelles de toutes sortes comme théatres, musées, associations, organisateurs, monuments historiques. Egalement musées aved de collections ayant une pertinence culturelle, historique et sociétale (p. ex. musée des transports)','Museum; Museen; Theater; Stadttheater; Kulturveranstalter; Kleintheater; Kabarett; Denkmalpflege; Denkmalschutz; Freilichtmuesum; Freilichtmuseen; Kunstmuseum; Kunstmuseen;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 17:30:47','2016-08-30 19:14:27'),
(45,'Think Tanks','Think Tanks',9,'Denkfabriken wie zB Avenir Suisse, Denknetz Schweiz etc.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 17:39:45','2017-04-07 10:15:53'),
(46,'Oel-/Gasindustrie','Industrie du gaz et du pétrole',3,'Erdölkonzerne, Tankstellen, Gasunternehmen (Socar, Gazprom)','Groupes pétroliers, stations service, entreprises de gaz (Socar, Gazprom)','Erdölindustrie; Gasindustrie; Erdöl; Erdgas; Rohstoffe; Rohstoffhandel; Öl; Gas; Pipeline; Rohstoffhandelsfirmen; Fracking',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 17:46:32','2018-06-27 10:51:02'),
(47,'Komunikationsdienstleistungen','Services de communication',18,'Kommunikationsdienstleister wie Swisscom, Cablecom, ICT-Firmen','Fournisseur de services de communication comme Swisscom, Cablecom','Kommunikationsdienstleister; Provider; ICT; ICT-Unternehmen; Informationstechnologie; Information technology; Kommunikationstechnik; Kommunikationstechnologie; Information and communication technology;',NULL,NULL,NULL,NULL,'2016-10-18 17:27:17','2014-04-08 17:56:34','2024-07-23 15:55:14'),
(48,'Printmedien','Médias imprimés',18,'Zeitungen, Zeitschriften mit Hauptgeschäft im Printmedienbereich sowie Druckereien.','Journaux, magazines dont l''activité principale est imprimée, imprimerie',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 17:57:00','2018-02-02 18:10:34'),
(49,'Elektronische Medien','Médias électroniques',18,'Medien, mit Haupttätigkeit im elektronischen Bereich','Médias dont l''activité principale est dans l''électronique','Radio; Radiostationen; Lokalradios; TV; Fernsehen; TV-Stationen; Lokal-TV; Regionalfernsehen; Regional-TV; Internet; Internet-Plattform; News-Plattform; neue Medien',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 17:57:40','2018-06-27 10:19:03'),
(50,'Cleantech','Technologies propres',9,'Unternehmen der Cleantechbranche',NULL,'Cleantech; grüne Technologie; Umweltechnologie',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 18:04:56','2018-06-27 11:31:47'),
(51,'Bauhauptgewerbe','Construction - Gros œuvre',9,'Für eine detailliertere Abgrenzung der beiden Bereiche, insbesondere für die Frage, was zum Bauhauptgewerbe gehört, kann der gesamtschweizerisch geltende Landesmantelvertrag für das Schweizerische Bauhauptgewerbe (LMV 2008, 2008 - 2010) herangezogen werden. Dieser definiert folgende Bereiche als Bauhauptgewerbe (Art. 2 Abs. 1 LMV 2008):\na)    Hochbau, Tiefbau (einschliesslich Spezialtiefbau), Untertagbau und Strassenbau (einschliesslich Belagseinbau);\n\nb)    Aushub, Abbruch, Deponie- und Recyclingbetriebe;\n\nc)    Steinhauer- und Steinbruchgewerbe sowie Pflästereibetriebe;\n\nd)    Marmor- und Granitgewerbe;\n\ne)    Gerüst-, Fassadenbau- und Fassaden-Isolationsbetriebe, ausgenommen Betriebe, die in der Gebäudehülle (umfasst geneigte Dächer, Unterdächer, Flachdächer und Fassadenbekleidungen, mit dazugehörendem Unterbau und Wärmedämmung) tätig sind;\n\nf)     Abdichtungs- und Isolationsbetriebe für Arbeiten an der Gebäudehülle im weiteren Sinn und analoge Arbeiten im Tief- und Untertagbau;\n\ng)    Betoninjektions- und Betonsanierungsbetriebe, Betonbohr- und Betonschneide-unternehmen;\n\nh)    Betriebe, die Asphaltierungen ausführen und Unterlagsböden erstellen (wie Schaler, Eisenleger, Maurer)\n\ni)     Gartenbaufirmen, soweit sie mehrheitlich Arbeiten wie Bauarbeiten, Planierungen, Maurerarbeiten usw., ausführen;\n\nj)     Betriebe bzw. Betriebsteile der Sand- und Kiesgewinnung;\n\nk)    Transport von und zu Baustellen;\n\nl)     Herstellung und Transport von lagerfähigen Baustoffen.','','Hochbau; Tiefbau; Strassenbau; Aushub; Abbruch; Deponie; Steinhauer; Steinbruch; Gerüstbau; Fassadenbau; Gebäudehülle; Abdichtung; Isolation; Beton; Asphalt; Gartenbau; Sand; Maurer*; Baumeister;','',NULL,NULL,NULL,'2014-12-12 08:56:49','2014-04-08 18:17:56','2021-01-03 08:52:54'),
(52,'Baunebengewerbe','Construction - Secondaire',9,'Zum Baunebengewerbe gehören grundsätzlich sämtliche übrigen Bauarbeiten wie bspw. Maler-, Gipser-, Dachdecker-, Plattenleger-, Gärtner-, Spenglerei-, Heizungs-, Klima-, Lüftungs-, Schreiner-, Zimmerei-, Metallbau- sowie Sanitär- und Elektroinstallationsarbeiten. Diese Abgrenzung entbindet den Auftraggeber allerdings nicht davon, im Einzelfall zu prüfen, ob die konkreten Bauarbeiten ein tragendes Element betreffen; dies deshalb weil bestimmte Arbeitsgattungen (bspw. Zimmerei- oder Metallbauarbeiten) je nach Bauvorhaben ein tragendes oder nicht tragendes Element betreffen können.','','Übrige Bauarbeiten; Maler; Gipser; Dachdecker; Plattenleger; Gärtner; Spengler; Heizung; Lüftung; Haustechnik; Schreiner; Zimmerei; Metallbau; Sanitär; Elektro;','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-04-08 18:18:37','2021-01-03 08:52:54'),
(53,'Arbeitnehmer:innenorganisationen','Organisations de travailleur·euse·x·s',9,'Gewerkschaften, Angestellte Kaderorganisation,',NULL,'Gewerkschaften; Arbeitnehmer; Arbeitnehmerorganisationen; Angestellte; Angestelltenverbände; Arbeitnehmervertretung; Gewerkschafter',NULL,NULL,NULL,NULL,'2014-12-12 08:55:43','2014-04-08 18:20:48','2024-07-23 15:52:04'),
(54,'Umwelt & Natur','Environnement et nature',4,'Organisationen wie Greenpeace, Pro Natura, Vogelwarte, Landschaftsschutz',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 18:27:46','2019-10-05 17:13:42'),
(55,'Tierschutz','Protection des animaux',4,'Tierschutzorganisationen',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 18:28:29','2019-03-15 20:33:41'),
(56,'Sozialversicherungen','Assurances sociales',2,'Sozialversicherungen, Sozialwerke, AHV, IV, Ausgleichskassen, etc.','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 18:40:03','2015-03-11 09:50:28'),
(57,'Versicherungen','Assurances',9,'alle Versicherungen, auch Suva, exklusive Krankenversicherer (KVG)',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 18:55:12','2017-04-07 10:23:17'),
(58,'Advokaturen/Treuhand','Cabinets/Fiduciaires',9,'Treuhänder, Anwälte, Notare, Wirtschaftsprüfer und ihre Standesorganisationen','','Anwälte; Treuhänder; Wirtschaftsprüfer; Anwaltskanzlei; Advokat; Juristen;','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-04-08 19:05:53','2015-03-11 09:50:28'),
(59,'KMU/Gewerbe/Arbeitgeber:innen','PME/Entreprises/Employeurs',9,'Organisationen, Interessenverbände; KMU-Verband, Gewerbeverband etc. Berufsorganisationen, Selbstständige, Arbeitgeberorganisationen',NULL,'KMU; Familienunternehmen; Kleine und mittlere Unternehmen; Arbeitgeber; Gewerbe; Standesorganisationen; Berufsorganisationen; Gewerbebetriebe;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 19:10:17','2024-07-22 16:40:16'),
(60,'Tourismus/Gastronomie','Tourisme/Gastronomie',9,'Gastro, Hotellerie, Tourismus','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 19:14:03','2015-03-11 09:50:28'),
(61,'Industrie','Industrie',9,'Industrieunternehmen',NULL,'Industrie; Grossindustrie; Industriesektor; Grossfirmen; Grossunternehmen',NULL,NULL,NULL,NULL,'2015-01-09 07:22:36','2014-04-08 19:34:32','2017-04-07 10:24:30'),
(62,'Medien allgemein','Médias en général',18,'Verbände und Institutionen aus dem Bereich Medien.',NULL,'Medien; Medienbranche; Medium; Medienunternehmen',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 19:51:49','2018-02-02 18:10:34'),
(63,'Kulturförderung','Promotion de la culture',8,'allgemeine Kulturförderung, auch kulturhistorisch','Promotion générale de la culture, y compris historique','Kulturförderung; Kunstförderung; Kunststipendium; Mäzene; Kunststiftungen','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-08 19:55:35','2015-03-11 09:50:28'),
(64,'Reinigungsgewerbe','Entreprises de nettoyage',9,'Reinigungsbranche, Hauswarte, Facility Management','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 17:43:51','2015-03-11 09:50:28'),
(65,'Spitzensport','Sport d''élite',17,'professionelle Sportarten','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 17:45:27','2016-08-30 19:14:27'),
(66,'Breitensport','Sport populaire',17,'Amateurszene, Volksläufe, Laiensport','','Breitensport; Amateursport; Volksläufe; Volkslauf; Fitness;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 17:46:06','2016-08-30 19:14:27'),
(67,'Gleichstellung','Egalité',2,'Frauenorganisationen, Männerverbände, kantonale und instituionelle Fachstellen für Gleichstellung, div Frauenorganisationen','','Gleichstellung; gleiche Rechte; Emanzipation; Frauenorganisationen; Männerorganisation;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 18:17:01','2015-03-11 09:50:28'),
(68,'Hilfswerke international','Oeuvres d''entraide internationales',13,'Hilfswerke mit Engagement in der Dritten Welt/Schwellenländern, Zusammenarbeit mit DEZA etc.','Oeuvres d''entraide avec engagement dans le Tiers Monde et les pays en voie de développement, collaboration avec la DDC, etc.','3. Welt; Entwicklungshilfe; Entwicklungszusammenarbeit; 3. Welt; Drittewelt; Nothilfe; Katatstrophenhilfe; Glückskette',NULL,NULL,NULL,NULL,'2015-01-09 07:22:36','2014-04-22 18:33:02','2019-12-16 12:12:51'),
(69,'Kosmetika/pharmazeutische Produkte','Produits pharmaceutiques et cosmétiques',1,'Kosmetikaindustrie, Drogerien, heilmittelähnliche Substanzen, Produkte mit Zusatzstoffen etc.','Industrie cosmétique, drogueries, substances soignantes, compléments alimentairesm etc.','Drogerie; Kosmetikindustrie; Parfüm; Zusatzstoffe; heilmittelähnliche Substanzen; Makeup; Parfümerie;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 18:56:56','2017-04-07 10:30:31'),
(70,'Aussenpolitik allgemein','Politique étrangère en général',13,'Beziehungspflege, Imagepflege, Schweiz-PR, wirtschaftlich motiviert','Entretien de relations, travail d''image, relations publiques pour la Suisse, motivation économique','Aussenpolitik; Beziehungspflege; Imagepflege; Wirtschaftsbeziehungen; Kontaktpflege;','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-04-22 19:05:05','2015-03-11 09:50:28'),
(71,'Friedensförderung/Menschenrechte','Promotion de la paix',13,'Förderung der Menschenrechte und zivile Friedensförderung im Bereich der Aussenpolitik','Promotion des droits humains et promotion civile de la paix dans le cadre de la politique extérieure','Friede; Peace; Menschenrechte; Gute Dienste',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 19:06:38','2020-03-23 15:16:24'),
(72,'Sicherheit allgemein','Sécurité en général',16,'private Sicherheitsdienste, private Initiativen zur Verbesserung der Sicherheit und Verhinderung Kriminalität','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 19:20:55','2015-03-11 09:50:28'),
(73,'Pflege','Soin',1,'Pflege in Heimen, Pflegeinstitutionen, auch Verbände wie SBK','Soins dans des homes, insitutions de soins, également groupes d''intérêt',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 19:32:24','2015-03-11 09:50:28'),
(74,'Dienstleistungen allg.','Services en général économie',9,'Verschiedene Dienstleister wie Vergleichsportale, Messen, Ausstellungen und andere Vermittler zwischen der Wirtschaft/Gewerbe und Konsumenten.',NULL,'Vergleichsportal; Preisvergleich; Preisvergleichsportal; Schnäppchenportal; Ausstellung, Messe, Expo, Exposition',NULL,NULL,NULL,NULL,'2016-10-18 17:27:17','2014-04-22 19:43:02','2017-04-07 10:33:20'),
(75,'Pro EU','Pro UE',13,'pro europäisch','Organisations pro-européennes (p. ex. NOMES)',NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 19:53:08','2017-04-07 10:34:00'),
(76,'Anti-EU','Anti UE',13,'EU-kritische Organisationen (wie z.B. AUNS).','Organisation anti-UE (p.ex. ASIN)','Anti-EU; EU-Kritiker; EU-Skeptiker; EU nein; Unabhängigkeit; Souveränität;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 19:53:26','2024-07-23 15:52:55'),
(77,'Futtermittel/Pflanzenbau','Nourriture pour animaux / Production végétale',15,'Futtermittelindustrie, Futtermühlen, Pflanzenbau, etc.','Fourage, farines alimentaires pour animaux, silots, production végétale.','Viehfutter; Futtermittelindustrie',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 20:04:07','2016-06-09 13:55:14'),
(78,'IT','Technologies de l''information',9,'Organisationen und Unternehmen aus dem Bereich ICT',NULL,'IT; ICT; Information and Communication Technology; Informationstechnologie; Computer; Netzwerke; Software; Kommunikationstechnologie; Informatik;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 20:16:46','2017-04-07 10:35:59'),
(79,'Heime/Institutionen','Homes/Institutions',2,'Diverse Heime, also Alters-, Behinderten-, Kinderheime (private und öffentliche Institutionen).','','Altersheim; Behindertenheim; Jugendheim; Heimwesen; Institution; Pflegeheim','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 20:21:33','2016-08-30 18:59:49'),
(80,'Ökologie','Agriculture écologique',15,'Umweltbereich in der Landwirtschaft, zB Kleinbauern',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 20:23:37','2017-04-07 10:36:36'),
(81,'Konsument:innenenschutz','Protection des consommateur·ice·x·s',9,'Konsumenten',NULL,'Konsumentenschutz; Konsum; Konsumenten; Kassensturz; Konsumentenvertreter; Ombudsstellen',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 20:30:06','2024-07-23 15:57:41'),
(82,'Weinbau, Bier und Spirituosen','Vins, bière et spiritueux',15,'Rebbau, Weinbau, Winzern, Verarbeiter, Schnapsbrenner, Spirituosen, Bierbrauer, Bierhändler',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 17:44:02','2016-08-25 15:59:10'),
(83,'Promotion/Label','Promotion en agriculture',15,'Verkaufsorganisationen, Label, Promotionsverbände',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 17:51:57','2019-11-16 16:34:43'),
(84,'Obstwirtschaft','Industrie fruitière',15,'Obstwirtschaft, Pflanzer, Verarbeiter, Händler --> Schnaps siehe Weinbau/Spirituosen','','Obstwirtschaft; Obstbauern; Obstverarbeiter; Früchte; Obsthändler; Früchtehändler;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:05:06','2015-03-11 09:50:28'),
(85,'Landwirtschaft allgemein','Agriculture en général',15,'Verschiedene landwirtschaftliche Organisationen, Bürgschaftsgenossenschaften, IGs etc',NULL,'Landwirtschaft; Bürgschaftsgenossenschaften; landwirtschaftliche Genossenschaften;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:13:36','2019-03-21 09:42:47'),
(86,'Viehwirtschaft','Elevage d''animaux',15,'Viehzucht, Händler, Pferdezucht etc','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:14:22','2015-03-11 09:50:28'),
(87,'Maschinenindustrie','Industrie des machines-outils',9,'Unternehmen der Maschinen-, Elektro- und Metallindustrie (auch Motoren, Pumpen, etc) sowie die Werkzeugbranche.','','Maschinenindustrie; Elektroindustrie; Metallindustrie; Motorenhersteller; Werkzeugindustrie; Werkzeugmacher;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:16:48','2015-03-11 09:50:28'),
(88,'Dienstleistungen Gesundheit','Services de santé',1,'Unternehmen und Organisationen mit Dienstleistungen im Bereich Gesundheitswesen','Entreprises de services pour le domaines de la santé, p. ex. solutions électroniques','Dienstleister Gesundheitswesen; Abrechnungs-Software; Patientendossier; eHealth;',NULL,NULL,NULL,NULL,'2016-10-18 17:27:17','2014-04-29 18:26:28','2017-04-07 10:41:57'),
(89,'Sport allgemein','Sport en général',17,'Sportmuseum, Schiedsrichter, Ausrüster, Fans etc.','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:32:36','2016-08-30 19:14:27'),
(90,'Verkehrssicherheit','Sécurité routière',5,'Organisationen, die sich in der Sicherheit im Verkehr allgemein engagieren. BFU, Roadcross etc','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:38:17','2016-08-30 19:14:27'),
(91,'Klima','Climat',4,'Klimapolitik und nachhaltige Entwicklung, My Climate','','Klimapolitik; Klimawandel; Klimaschutz; Climate change; Nachhaltige Entwicklung; Sustainability; Klimakonferenz; CO2-Kompensation;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:42:41','2015-03-11 09:50:28'),
(92,'Detailhandel','Commerce de détail',9,'Detailhändler','','Detailhandel; Detailhändler, Grossverteiler; Detailhandelsunternehmen;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:44:05','2015-03-11 09:50:28'),
(93,'Umwelt allgemein','Environnement en général',4,'allgemeiner Umweltschutz,  technologisches, etc.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:56:11','2019-10-05 17:13:47'),
(94,'Raumplanung','Aménagement du territoire',4,'Themen der Raumplanung, Landschaftsschutz','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 18:57:26','2015-03-11 09:50:28'),
(95,'Rüstungsindustrie','Industrie de l''armement',16,'Wehrtechnik, Waffen, Rüstungsgüter','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 19:05:33','2015-03-11 09:50:28'),
(96,'Produktion/Handel Landwirtschaft','Production/Commerce',15,'Saatgut, Herstellung, Handel mit landwirtschaftlichen Produkten etc.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 19:23:19','2017-04-07 10:43:00'),
(97,'Biotech','Biotechnologie',9,'Firmen der Biotechnologie, auch Gentech, Syngenta etc.','','Biotechnologie; Gentechnologie; Gentech; Freisetzung;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 19:25:27','2015-03-11 09:50:28'),
(98,'Mieter:innen','Locataire·x·s',9,'Mieterinnen und Mieterverbände',NULL,'Mieterinnen- und Mieterverband; Mieter;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-29 19:30:24','2024-07-23 15:51:42'),
(99,'Abgaben und Steuern','Taxes et redevances',9,'Steuersenkungsinitiativen, Abgabenkritiker, Befürworter von Steuerwettbewerb','','Steuerwettbewerb; Erbschaftssteuer; Mehrwertsteuer; Steuersenkung; Steuererhöhung','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-04-29 19:46:51','2015-03-11 09:50:28'),
(100,'Berggebiete','Régions de montagne',14,'Organisationen, die sich explizit für Berggebiete einsetzen',NULL,'Berggebiet; Alpen; Berghilfe; Winterhilfe; Bergbauern; Alpwirtschaft; Alp; Alpen;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-06-23 10:26:28','2017-04-07 10:43:33'),
(101,'Textilindustrie','Industrie textile',9,'Firmen der Textilindustrie, Textilverarbeitung','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-06-23 12:08:23','2015-03-11 09:50:28'),
(102,'Kinder/Jugend','Enfants/Jeunesse',2,'Unterstützung von Kindern, Jugend; Förderung, Interessenvertretung von Kindern-/Jugendlichen','','Kinder; Kinderparlament; Jugend; Jugendparlament; Jugendpolitik; Jugendförderung; junge Erwachsene;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-06-23 12:11:00','2016-08-30 18:59:49'),
(103,'Religion','Religion',14,'Religiöse Gruppen verschiedener Glaubensrichtungen und Freikirchen.','',NULL,'',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-07-11 15:35:32','2015-03-11 09:50:28'),
(104,'Innere Sicherheit','Sécurité intérieure/Services de renseignement',16,'Organisationen im Bereich innere Sicherheit, Antiterrorismus, Nachrichtendienste, Bundeskriminalpolizei, Bundesanwaltschaft, Fedpol',NULL,'Innere Sicherheit; Nachrichtendienst; Bundeskriminalpolizei; Verbrechensbekämpfung; Geheimdienst; Bundesanwaltschaft; Fedpol; Überwachung; Fichierung;',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-07-17 10:41:51','2017-04-07 10:43:55'),
(105,'Polizei','Police',16,'Diverse Polizeikorps, Berufsverbände, Organisationen mit Bezug zu Polizeikorps bzw. Dienstleistungen im Zusammenhang mit der Polizeibehörde.','',NULL,'',NULL,NULL,NULL,'2014-10-02 08:31:18','2014-07-17 10:43:33','2015-03-11 09:50:28'),
(106,'Gemeinden','Communes',14,'Organisationen, Verbände der Gemeinden','','Gemeinde; Gemeinwesen; Gemeindeverband; Gemeindeverbände; Regionalverband; Kommunen','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-07-17 11:03:00','2015-03-11 09:50:28'),
(107,'Investmentgesellschaften','Société d''investissement',9,'Investmentgesellschaften, Beteiligungsgesellschaften','','Fonds; Hedge Fund; Anlagen; Beteiligungen; Investments; Beteiligungsgesellschaft;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-07-17 11:13:01','2015-03-11 09:50:28'),
(108,'Handel','Commerce',9,'Import/Export von Gütern aller Art.','','Import; Export; Einfuhr; Ausfuhr','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-07-17 11:29:22','2015-03-11 09:50:28'),
(111,'Militär','Militaire',16,'Armee, Militär, Luftwaffe','','Armee; Heer, Militär; Luftwaffe; Landesverteidigung;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-08-08 14:11:03','2015-03-11 09:50:28'),
(115,'Chemie/Biotech','Chimie/Biotechnologie',9,'Unternehmen der chemischen Industrie und Biotech.','','Chemie; Biotech; chemische Industrie; Biotech; Biotechnologie; Chemieunternehmen; Chemieindustrie;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-09-02 18:17:06','2015-03-11 09:50:28'),
(116,'Luftfahrt','Transport aérien',5,'Unternehmen der zivilen und militärischen Luftfahrt','','Luftfahrt; Fliegen; Flugverkehr; Flugzeug; Fluggesellschaften; Aviation;','',NULL,NULL,NULL,'2014-09-16 00:00:00','2014-09-02 18:22:01','2016-08-30 19:14:27'),
(117,'Aufsichtsgremien','Organes de contrôle',14,'Aufsichtsgremien der Kantone und des Bundes (z.B. Stiftungsaufsicht, Finma etc)',NULL,'Aufsichtsgremien; Aufsichtsgremium; Kontrolleure; Kontrolle; Stiftungsaufsicht; Finma;',NULL,NULL,NULL,NULL,'2014-12-12 08:55:43','2014-09-02 18:41:06','2017-04-07 10:46:04'),
(118,'Globalisierungskritik','Altermondialisme',13,'Organisationen aus dem Bereich Förderung der Menschenrechte, Freihandelspolitik, die sich einsetzen für faire Handelsbeziehungen von Schweizer Wirtschaftsunternehmen; auch globalisierungskritissche Organisationen.','Organisations de promotion des droits humains, du commerce équitable, pour des relations économiques éthiques de la part des entreprises suisses. Y compris organisations altermondialistes.','Fairtrade; Globalisierungskritiker; Menschenrechte;',NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2014-10-21 18:34:29','2024-07-22 16:42:27'),
(119,'Grafik','Graphique',18,'Grafik, Typografie sowie andere der Werbung/Printmedien vorgelagerte Berufe und Tätigkeiten.','Graphisme, typographie et autres métiers et activités liés à l''impression et à la publicité','Grafik; visuelle Gestaltung; Polygraph; Polygraf; Typograph; Typografie;','',NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-05 14:56:04','2015-03-11 09:50:28'),
(120,'Rettungswesen','Sauvetage',16,'Rettungsdienste wie z.B. Rega, Ambulanzen, Feuerwehr etc.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-05 15:03:00','2023-08-14 10:15:22'),
(121,'Vermögensverwaltung','Gestion de fortune',9,'Unabhängie Vermögensverwalter, wie sie beispielsweise im Verband der Schweizerischen Vermögensverwalter organisisert sind (Anlageberater und andere Finanzdienstleister).',NULL,'Finanzdienstleister; Nichtbankensektor; Finanzintermediäre; Parabanken',NULL,NULL,NULL,NULL,'2016-10-18 17:27:17','2014-11-05 15:09:15','2024-07-22 16:39:08'),
(122,'Wasser','Eau',4,'Wasserversorgung, Abwasserentsorgung, Abwasserreinigung und ähnliches',NULL,NULL,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-05 15:17:14','2018-06-06 09:46:53'),
(123,'Wasserkraft','Energie hydraulique',3,'Wasserkraftwerke, Pumpspeicherkraftwerke','Usines hydrauliques',NULL,'',NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-05 15:24:28','2015-03-11 09:50:28'),
(124,'Landwirtschaftstechnik','Technique',15,'Technische Hilfsmittel und Tätigkeiten für die Landwirtschaft, z.B. Landmaschinen etc.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-05 16:56:35','2017-04-07 10:47:31'),
(125,'Werbung','Publicité',18,'Unternehmen der klassischen Werbebranche; also Werbefirmen, Unternehmen zur Aquisition von Werbung','Branche publicitaire classique, démarchage pour publicité',NULL,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-18 22:50:42','2018-10-31 10:25:07'),
(126,'Abfallwirtschaft','Déchets',4,'Abfallwirtschaft, Deponien sowie Unternehmen der Recyclingbranche','','Recycling; Deponie; Müll; Kehricht','',NULL,NULL,NULL,'2014-12-12 08:55:43','2014-11-18 22:54:17','2015-03-11 09:50:28'),
(127,'Zuwanderungskritik','Anti-immigration',14,'Organisationen, die sich für eine Beschränkung der Zuwanderung einsetzen.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-11-26 00:00:00','2014-11-20 17:05:15','2024-07-22 16:41:50'),
(128,'Bildende Künste','Arts plastiques',8,'Bildende Künstler wie Kunstmaler, Bildhauer etc.','Arts plastiques comme peintres, sculpteurs, etc.','Maler, Bildhauer, Skulpturen','',NULL,NULL,NULL,'2015-01-06 19:17:59','2015-01-06 19:16:21','2015-03-11 09:50:28'),
(129,'Buchhandel','Librairie',18,'Buchhändler und Buchverlage','Commerce de livres et maisons d''édition','Buch; Buchhandel; Buchhändler; Buchverlag; Edition; Buchhandlung',NULL,NULL,NULL,NULL,'2015-01-09 17:42:13','2015-01-06 19:21:48','2017-04-07 10:50:32'),
(130,'Uhrenindustrie','Horlogerie',9,'Unternehmen der Uhrenindustrie bzw. Zulieferer der Uhrenindustrie.','','Uhrenfabrik; Decoltage','',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-01-06 19:25:05','2015-03-21 00:00:00'),
(131,'Anti-AKW','Anti-nucléaire',3,'Kritiker und Gegner der Atomenergie bzw. klassische AKW-Gegner.','Critiques et opposants à l''énergie nucléaire','AKW-Gegner, Atomausstieg, Nuklearkritiker, AKW-Ausstieg',NULL,NULL,NULL,NULL,'2015-01-06 19:41:05','2015-01-06 19:30:35','2024-07-22 16:42:06'),
(132,'Schifffahrt','Transport naval',5,'Unternehmen aus dem Bereich der touristischen Schiffahrt.','','Kreuzfahrt, Schiffahrt, Boot, Dampfschiff','',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-01-19 22:16:18','2016-08-30 19:14:27'),
(133,'Tabak','Tabac',9,'Verbände und Organisationen der Tabakindustrie, des Tabakhandels, Tabakanbaus, Zigarrenvereine etc.','','Cigarre, Zigarette, Cigar, Raucher Fumeur','',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-01-24 08:38:41','2015-03-21 00:00:00'),
(134,'Gentechnik-Kritik','Anti-OMG',15,'Kritker der Gentechnologie','Opposants aux organismes génétiquement modifiés.','Anti-Gentech; Gentechnologie-Gegner; Freisetzungsgegner',NULL,NULL,NULL,NULL,'2015-01-24 11:13:44','2015-01-24 11:13:27','2024-07-22 16:42:11'),
(135,'Holz- und Waldwirtschaft','Industrie du bois',9,'Sägereien, Holzverarbeiter, Holzvermarkter;','',NULL,'',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-02-16 16:32:51','2015-03-21 00:00:00'),
(136,'Glücksspiel','Jeux de hasard',9,'Lotteriegesellschaften, Casinos und ähnliche Einrichtungen aus dem Bereich des Glücksspiels.','',NULL,'',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-02-16 16:36:29','2015-03-21 00:00:00'),
(137,'Geflügelzucht','Elevage de volailles',15,'Unternehmen, Verbände und Firmen mit dem Hauptzweck der Geflügelzucht (Pouletmästereien etc).','',NULL,'',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-02-16 16:42:06','2015-03-21 00:00:00'),
(138,'Architektur','Architecture',9,'Architekten, Architekturbüros im engeren Sinn.','','Architektur, Baugestalter, Planer','',NULL,NULL,NULL,'2015-03-21 00:00:00','2015-02-26 13:47:27','2015-03-21 00:00:00'),
(139,'Film/Theater','Cinéma/théatre',8,'Film- und Theaterschaffen.',NULL,'Kino, Cinema, Theater, Spectacle, darstellende Künste, Varietee, Kabaret',NULL,NULL,NULL,NULL,'2015-08-16 00:00:00','2015-04-15 08:54:07','2017-04-07 10:51:23'),
(140,'Literatur','Litérature',8,'Schriftsteller und Autoren.',NULL,'Buchautor, Publizist, Literaten',NULL,NULL,NULL,NULL,'2015-08-16 00:00:00','2015-04-15 08:59:15','2017-04-07 10:51:32'),
(141,'Zivilschutz','Protection civile',16,'Setzt sich für den Schutz der Bevölkerung ein: Sicherheit, Intervention und Prävention.',NULL,NULL,NULL,NULL,NULL,NULL,'2015-08-16 00:00:00','2015-04-19 06:20:08','2017-04-07 10:51:54'),
(143,'Justiz','Justice',14,'Gerichte bzw. rechtssprechende Organe, also auch Staatsanwälte etc.','Cours de justice et leurs organes, tels que procureurs, etc.','Staatsanwalt, Bezirksgericht, Obergericht, Kantonsgericht, Militärgericht, Handelsgericht, Bundesgericht, Bundesanwaltschaft, Versicherungsgericht','ministère publique, tribunal de district, tribunal cantonal, tribunal militaire, tribunal de commerce, tribunal fédéral, tribunal administratif, tribunal des assurance',NULL,NULL,NULL,'2015-06-08 11:24:24','2015-06-08 11:23:07','2015-06-09 20:18:59'),
(144,'Lärmschutz','Protection contre le bruit',4,'Lärmschutz allgemein auch Anwohnervereinigungen in Sachen Fluglärm, SBB-Lärm, etc.',NULL,'Südanflug, Kloten Flughafen, Lärm',NULL,NULL,NULL,NULL,'2016-02-04 00:00:00','2015-12-11 15:41:39','2017-04-07 10:52:32'),
(145,'Fischerei','Pêche',15,'Fischerei, Fischer, Fischzucht','Pêche, pêcheurs, pisciculture',NULL,NULL,NULL,NULL,NULL,'2016-09-06 15:10:15','2016-09-06 15:09:53','2016-09-06 15:10:15'),
(146,'Zünfte, Verbindungen und Serviceclubs','Corporations, guildes, sociétés estudiantines',9,'Handwerkerzünfte, Studentenverbindungen sowie andere Vereinigungen wie Serviceclubs, deren Zweck letztlich die Vernetzung von Berufsleuten, Studenten und Unternehmern zum Zweck haben. ','Corporations, guildes, sociétés estudiantines, tout comme autres type d''associations tels les clubs service dont le but est de permettre la mise en réseau de professionnels, étudiants ou d''entreprises.','Rotary, Lionsclub, Studentenverbindung, Bruderschaft',NULL,NULL,NULL,NULL,'2016-12-19 08:35:32','2016-12-09 09:47:26','2016-12-19 08:35:32'),
(147,'Kleintierzucht','Elevage de petits animaux',15,'Kaninchenzüchter und andere Kleintierzüchter, (vorwiegend Freizeitbereich).','Éleveurs de lapins et autres éleveurs de petits animaux.',NULL,NULL,NULL,NULL,NULL,'2019-04-09 08:58:37','2019-03-24 10:26:01','2019-04-09 08:58:37'),
(148,'Internationale Institutionen','Institutions internationales',13,'Internationale Institutionen und Organisationen.','Institutions et des organisations internationale.','UNO, EU, EFTA',NULL,NULL,NULL,NULL,'2019-08-26 10:15:48','2019-08-26 10:15:09','2024-07-23 16:00:55');

DROP TABLE IF EXISTS organisation;
CREATE TABLE organisation (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Technischer Schlüssel der Lobbyorganisation',
  name_de varchar(150) NOT NULL COMMENT 'Name der Organisation. Sollte nur juristischem Namen entsprechen, ohne Zusätze, wie Adresse.',
  name_fr varchar(150) DEFAULT NULL COMMENT 'Französischer Name',
  name_it varchar(150) DEFAULT NULL COMMENT 'Italienischer Name',
  uid varchar(15) DEFAULT NULL COMMENT 'UID des Handelsregisters; Schweizweit eindeutige ID (http://www.bfs.admin.ch/bfs/portal/de/index/themen/00/05/blank/03/02.html); Format: CHE-999.999.999',
  ehra_id int(11) DEFAULT NULL COMMENT 'EHRA-ID des Handelsregisters',
  ch_id varchar(20) DEFAULT NULL COMMENT 'CH-ID des Handelsregisters (alte HR-ID)',
  in_handelsregister tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Ist die Organisation im Handelsregister (Zefix) eingetragen?',
  inaktiv tinyint(1) DEFAULT 0 COMMENT 'Gibt es die Organisation noch?',
  ort varchar(100) DEFAULT NULL COMMENT 'Ort der Organisation',
  abkuerzung_de varchar(20) DEFAULT NULL COMMENT 'Abkürzung der Organisation, kann in der Anzeige dem Namen nachgestellt werden, z.B. Schweizer Kaderorganisation (SKO)',
  alias_namen_de varchar(255) DEFAULT NULL COMMENT 'Strichpunkt-getrennte Aufzählung von alternative Namen für die Organisation; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.',
  abkuerzung_fr varchar(20) DEFAULT NULL COMMENT 'Französische Abkürzung der Organisation',
  alias_namen_fr varchar(255) DEFAULT NULL COMMENT 'Französischer Aliasnamen: Strichpunkt-getrennte Aufzählung von alternative Namen für die Organisation; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.',
  abkuerzung_it varchar(20) DEFAULT NULL COMMENT 'Italienische Abkürzung der Organisation',
  alias_namen_it varchar(255) DEFAULT NULL COMMENT 'Italienischer Aliasnamen: Strichpunkt-getrennte Aufzählung von alternativen Namen für die Organisation; bei der Suche wird für ein einfacheres Finden auch in den Alias-Namen gesucht.',
  land_id int(11) DEFAULT 191 COMMENT 'Land der Organisation',
  interessenraum_id int(11) DEFAULT NULL COMMENT 'Interessenraum der Organisation',
  rechtsform enum('AG','GmbH','Stiftung','Verein','Informelle Gruppe','Parlamentarische Gruppe','Oeffentlich-rechtlich','Einzelunternehmen','KG','Genossenschaft','Staatlich','Ausserparlamentarische Kommission','Einfache Gesellschaft','Parlamentarische Freundschaftsgruppe') DEFAULT NULL COMMENT 'Rechtsform der Organisation',
  rechtsform_handelsregister varchar(4) DEFAULT NULL COMMENT 'Code der Rechtsform des Handelsregister, z.B. 0106 für AG. Das Feld kann importiert werden.',
  rechtsform_zefix int(11) DEFAULT NULL COMMENT 'Numerischer Rechtsformcode von Zefix, z.B. 3 für AG. Das Feld kann importiert werden.',
  typ set('EinzelOrganisation','DachOrganisation','MitgliedsOrganisation','LeistungsErbringer','dezidierteLobby','Gemeinnuetzig','Gewinnorientiert') NOT NULL COMMENT 'Typ der Organisation. Beziehungen können über Organisation_Beziehung eingegeben werden.',
  vernehmlassung enum('immer','punktuell','nie') NOT NULL COMMENT 'Häufigkeit der Teilname an nationalen Vernehmlassungen',
  interessengruppe_id int(11) DEFAULT NULL COMMENT 'Fremdschlüssel Interessengruppe. Hauptinteressengruppe. Über die Interessengruppe wird eine Branche zugeordnet.',
  interessengruppe2_id int(11) DEFAULT NULL COMMENT 'Fremdschlüssel Interessengruppe. 2. Interessengruppe der Organisation.',
  interessengruppe3_id int(11) DEFAULT NULL COMMENT 'Fremdschlüssel Interessengruppe. 3. Interessengruppe der Organisation.',
  homepage varchar(255) DEFAULT NULL COMMENT 'Link zur Webseite',
  handelsregister_url varchar(255) DEFAULT NULL COMMENT 'Link zum Eintrag im Handelsregister',
  twitter_name varchar(15) DEFAULT NULL COMMENT 'Twittername',
  instagram_profil varchar(30) DEFAULT NULL COMMENT 'Instagram Username (Profil)',
  youtube_user varchar(50) DEFAULT NULL COMMENT 'Youtube Username',
  facebook_name varchar(150) DEFAULT NULL COMMENT 'Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt',
  linkedin_profil_url varchar(255) DEFAULT NULL COMMENT 'URL zum LinkedIn-Profil',
  xing_profil_name varchar(150) DEFAULT NULL COMMENT 'Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link',
  beschreibung mediumtext DEFAULT NULL COMMENT 'Beschreibung der Organisation, Zweck gemäss Handelsregister oder  Statuten',
  beschreibung_fr mediumtext DEFAULT NULL COMMENT 'Französische Beschreibung',
  sekretariat varchar(500) DEFAULT NULL COMMENT 'Für parlamentarische Gruppen: Ansprechsperson, Adresse, Telephonnummer, usw. des Sekretariats der parlamentarischen Gruppen (wird importiert)',
  adresse_plz varchar(10) DEFAULT NULL COMMENT 'Postleitzahl der Organisation',
  bfs_gemeinde_nr smallint(5) unsigned DEFAULT NULL COMMENT 'BFS Gemeindenummer (BFS GDENR)',
  wikipedia varchar(255) DEFAULT NULL COMMENT 'Link zum Wikipedia-Eintrag',
  wikidata_qid varchar(12) DEFAULT NULL COMMENT 'Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.',
  updated_by_import timestamp NULL DEFAULT NULL COMMENT 'Datum, wann die Organisation durch einen Import zu letzt aktualisiert wurde. Ein Datum bedeutet, dass die Organisation unter der Kontrolle des Importprozesses.',
  freigabe_datum timestamp NULL DEFAULT NULL COMMENT 'Freigabedatum (Freigabe = Daten sind fertig)',
  created_date timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Erstellt am',
  updated_date timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Abgeändert am',
  organisation_name_de_rechtsform_uid_unique varchar(195) GENERATED ALWAYS AS (concat_ws('_',name_de,rechtsform,ifnull(uid,0),ifnull(inaktiv,0))) VIRTUAL COMMENT 'Kombination aus name_de, rechtsform, uid und inaktiv muss eindeutig sein. (Fachlicher unique constraint)',
  PRIMARY KEY (id),
  UNIQUE KEY uid_unique (uid) COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY organisation_name_fr_unique (name_fr,rechtsform) USING BTREE COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY organisation_name_it_unique (name_it,rechtsform) USING BTREE COMMENT 'Fachlicher unique constraint',
  UNIQUE KEY organisation_name_de_rechtsform_uid_unique (organisation_name_de_rechtsform_uid_unique),
  KEY idx_lobbygroup (interessengruppe_id),
  KEY interessengruppe2_id (interessengruppe2_id),
  KEY interessengruppe3_id (interessengruppe3_id),
  KEY land (land_id),
  KEY interessenraum_id (interessenraum_id),
  KEY idx_bfs_gemeinde_nr (bfs_gemeinde_nr),
  CONSTRAINT fk_lo_lg FOREIGN KEY (interessengruppe_id) REFERENCES interessengruppe (id),
  CONSTRAINT fk_org_country FOREIGN KEY (land_id) REFERENCES country (id),
  CONSTRAINT fk_org_interessenraum FOREIGN KEY (interessenraum_id) REFERENCES interessenraum (id),
  CONSTRAINT fk_organisation_bfs_gemeinde_nr FOREIGN KEY (bfs_gemeinde_nr) REFERENCES bfs_gemeinde (gdenr),
  CONSTRAINT fk_organisation_interessengruppe2_id FOREIGN KEY (interessengruppe2_id) REFERENCES interessengruppe (id),
  CONSTRAINT fk_organisation_interessengruppe3_id FOREIGN KEY (interessengruppe3_id) REFERENCES interessengruppe (id)
) ENGINE=InnoDB AUTO_INCREMENT=10664 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Liste der Lobbyorganisationen';

INSERT INTO organisation (id, name_de, name_fr, name_it, uid, ehra_id, ch_id, in_handelsregister, inaktiv, ort, abkuerzung_de, alias_namen_de, abkuerzung_fr, alias_namen_fr, abkuerzung_it, alias_namen_it, land_id, interessenraum_id, rechtsform, rechtsform_handelsregister, rechtsform_zefix, typ, vernehmlassung, interessengruppe_id, interessengruppe2_id, interessengruppe3_id, homepage, handelsregister_url, twitter_name, instagram_profil, youtube_user, facebook_name, linkedin_profil_url, xing_profil_name, beschreibung, beschreibung_fr, sekretariat, adresse_plz, bfs_gemeinde_nr, wikipedia, wikidata_qid, updated_by_import, freigabe_datum, created_date, updated_date) VALUES
(2,'ROBINVEST AG',NULL,NULL,'CHE-114.321.043',910350,'CH02030324539',1,1,'Herrliberg',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',107,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203032453&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt Beratung, Erbringen von Dienstleistungen im Bereiche Unternehmensführung und Durchführung von Finanzgeschäften. Sie kann sämtliche Geschäfte tätigen, welche mit dem Gesellschaftszweck direkt oder indirekt in Zusammenhang stehen und sich auch an anderen Unternehmen beteiligen. Die Gesellschaft kann überdies Liegenschaften erwerben, verwalten und veräussern.',NULL,NULL,'8704',152,NULL,NULL,NULL,'2016-11-30 09:07:37','2013-11-10 14:18:51','2024-04-26 11:54:54'),
(3,'Albert Bächtold-Stiftung',NULL,NULL,'CHE-113.069.220',261901,'CH29070011470',1,1,'Wilchingen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation','nie',63,NULL,NULL,'https://www.albert-baechtold.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Mithilfe bei der Finanzierung der Neuauflagen vergriffener Albert-Bächthold-Bücher (Klettgauer Mundart-Schriftsteller, 1891-1981)',NULL,NULL,'8217',2974,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(4,'Schweizer Musikinsel Rheinau',NULL,NULL,'CHE-115.234.470',963288,'CH02070016323',1,1,'Herrliberg',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,Gemeinnuetzig','nie',63,NULL,NULL,'www.musikinsel.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001632&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt: a) die Förderung des musikalischen Schaffens von Jugendlichen und Erwachsenen; b) die Mithilfe bei der Entwicklung der musikalischen und künstlerischen Fähigkeiten; c) die Bereitstellung geeigneter Infrastruktur als Übungsplattform für Konzertvorbereitungen, musikalische Wettbewerbe, künstlerischen Unterricht, Symposien und Seminarien. Zur Umsetzung des Stiftungszweckes betreibt die Stiftung insbesondere ein Zentrum auf der Insel des ehemaligen Klosters Rheinau mit Übungsräumlichkeiten, Unterkünften und Verpflegungsangeboten. Die Stiftung verfolgt keine Erwerbszwecke. Sie ist politisch und konfessionell neutral. Ihre Leistungen sind gemeinnützig.',NULL,NULL,'8704',152,NULL,NULL,NULL,'2016-10-10 07:23:39','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(5,'fun & business AG',NULL,NULL,'CHE-100.938.881',434451,'CH24030005618',1,1,'Egerkingen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',60,NULL,NULL,NULL,'http://www.moneyhouse.ch/fr/u/fun_business_ag_CH-240.3.000.561-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb, Vermietung und Verpachtung jeglicher Art von Betrieben der Freizeitbranche wie Hotels, Restaurants, Bars, Dancings und Discos sowie Betrieb, Verwaltung und Vermietung von Konferenz- und Businessräumen. Kann im In- und Ausland andere Unternehmungen gründen, übernehmen oder sich daran beteiligen, Grundeigentum erwerben, verwalten, vermitteln und veräussern, Zweigniederlassungen errichten sowie alle Geschäfte tätigen und Verträge abschliessen, die geeignet sind, den Zweck der Gesellschaft zu fördern.',NULL,NULL,'4622',2401,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(6,'bosec consulting gmbh',NULL,NULL,'CHE-109.104.853',626798,'CH24040018509',1,1,'Kestenholz',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',18,NULL,NULL,'http://bosec-consulting.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Unternehmensberatung sowie Handel mit und Vermittlung von Waren und Dienstleistungen aller Art; kann sich an andern Unternehmen beteiligen oder sich mit diesen zusammenschliessen sowie Grundstücke erwerben, verwalten und veräussern.',NULL,NULL,'4703',2403,NULL,NULL,NULL,'2016-03-18 11:03:50','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(8,'Automobil Club der Schweiz, ACS','Automobile Club de Suisse','Automobile Club Svizzero','CHE-107.814.205',470659,'CH03560012733',1,1,'Bern','ACS',NULL,'ACS',NULL,'ACS',NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',26,NULL,NULL,'http://www.acs.ch/ch-de/ACS-the-club/portrait/index.asp?navid=1','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356001273&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,'automobilclubderschweiz','automobilclubderschweiz','acs.schweiz',NULL,NULL,'Der ACS, ein Verein im Sinne des ZGB, gegründet am 6. Dezember 1898 in Genf, bezweckt den Zusammenschluss der Automobilisten zur Wahrung der verkehrspolitischen, wirtschaftlichen, touristischen, sportlichen und aller weiteren mit dem Automobilismus zusammenhängenden Interessen wie Konsumenten- und Umweltschutz. Er widmet der Strassenverkehrs-gesetzgebung und ihrer Anwendung seine besondere Aufmerksamkeit. Er setzt sich ein für die Verkehrssicherheit auf der Strasse.\n\nDer Gesamtclub setzt sich aus den Mitgliedern seiner insgesamt 20 Sektionen zusammen, welche sich wiederum als selbständige Vereine organisieren.','L''ACS, association dans l''esprit du ZGB, fondée le 6 décembre 1898 à Genève, a pour objectif de rassembler les passionnés d''automobile pour protéger la politique des transports, l''économie, le tourisme, le sport et tous les autres intérêts liés à l''automobile, comme les consommateurs et l''environnement. protection. Il accorde une attention particulière à la législation relative à la circulation routière et à son application. Il s''engage pour la sécurité routière.\n\nL''ensemble du club est composé des membres de ses 20 sections, qui à leur tour s''organisent en clubs indépendants.',NULL,'3011',351,'https://de.wikipedia.org/wiki/Automobil_Club_der_Schweiz','Q787474',NULL,'2025-08-20 00:00:00','2013-11-10 14:18:51','2025-08-20 13:24:54'),
(9,'Industrie- und Handelsverein Thal-Gäu-Bipperamt',NULL,NULL,NULL,NULL,NULL,0,0,'Oensingen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'http://www.ihv-tgb.ch/index.php?id=18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Mitglieder des Industrie- und Handelsvereins Thal-Gäu-Bipperamt treten mit ihren Fähigkeiten und ihrer Überzeugung für ein freies Unternehmertum im Rahmen einer sozial-humanen Marktwirtschaft ein. Mitglied von Economie Suisse',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(11,'Hüppi AG',NULL,NULL,'CHE-112.423.922',796580,'CH29030151492',1,1,'Küsnacht ZH',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',51,NULL,NULL,'http://www.hueppi.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2903015149&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt den Betrieb einer Unternehmung für Strassen-, Hoch- und Tiefbau sowie die Beratung auf diesen Gebieten. Die Gesellschaft kann im Übrigen alle kommerziellen, finanziellen und anderen Geschäfte tätigen, die bestimmt und geeignet sind, die Entwicklung des Unternehmens und die Erreichung des Gesellschaftszwecks zu fördern oder zu erleichtern. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im In- und Ausland errichten und sich an anderen Unternehmen im In- und Ausland beteiligen. Die Gesellschaft kann Grundstücke, beschränkte dingliche Rechte und Immaterialgüterrechte erwerben, halten und veräussern.',NULL,NULL,'8700',154,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(12,'comparis.ch AG',NULL,NULL,'CHE-106.829.753',378630,'CH28049002329',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',74,NULL,NULL,'http://www.comparis.ch','http://www.moneyhouse.ch/u/comparis_ch_ag_CH-280.4.900.232-9.htm','Comparis',NULL,NULL,NULL,NULL,NULL,'comparis.ch - eine Idee mit Erfolg\n\ncomparis.ch ist der führende Internet-Vergleichsdienst der Schweiz. Konsumenten können auf www.comparis.ch einfach und schnell Tarife und Leistungen von Krankenkassen, Versicherungen, Banken, Telecom-Anbietern, Immobilien, Autos und Motorrädern sowie Aktionen aus dem Detailhandel vergleichen. Dank der Comparis-Vergleiche und -Bewertungen können die Konsumenten direkt zum Anbieter mit dem besten Preis-Leistungs-Verhältnis wechseln.\n\ncomparis.ch wurde 1996 vom Ökonomen Richard Eisler gegründet. Seine Idee, Konsumenten im Internet einen raschen Prämienvergleich im unübersichtlichen Krankenkassenmarkt zu ermöglichen, hatte Erfolg: Seither haben über 500''000 Personen ihre Krankenkasse über comparis.ch gewechselt. Jedes Jahr sparen die Wechsler dadurch mehr als 300 Millionen Franken. Im März 2010 gewann Comparis die Silbermedaille in der Kategorie "Simply the Best" des renommierten Schweizer Internet-Preises "Best of Swiss Web". Anlässlich des 10-jährigen Jubiläums des Internetpreises wurden in dieser Spezialkategorie die besten Schweizer Websiten aller Zeiten juriert.\nSeit Juni 2000 ist comparis.ch eine Aktiengesellschaft mit Sitz in Zürich und zählt heute ca. 100 Mitarbeiterinnen und Mitarbeiter.','comparis.ch - une idée qui a du succès\n\ncomparis.ch est le premier comparateur sur internet de Suisse. Sur www.comparis.ch, les consommateurs peuvent comparer facilement et rapidement les tarifs et les prestations des caisses maladie, des assurances, des banques, des opérateurs télécom, de l''immobilier, des voitures et des motos ainsi que les promotions du commerce de détail. Grâce aux comparaisons et aux évaluations de Comparis, les consommateurs peuvent passer directement au prestataire offrant le meilleur rapport qualité-prix.\n\ncomparis.ch a été fondé en 1996 par l''économiste Richard Eisler. Son idée de permettre aux consommateurs de comparer rapidement les primes sur Internet dans un marché de l''assurance maladie peu clair a eu du succès : depuis, plus de 500 000 personnes ont changé de caisse maladie via comparis.ch. Chaque année, les personnes qui changent de caisse économisent ainsi plus de 300 millions de francs. En mars 2010, Comparis a remporté la médaille d''argent dans la catégorie "Simply the Best" du prestigieux prix Internet suisse "Best of Swiss Web". A l''occasion du dixième anniversaire du prix Internet, les meilleurs sites suisses de tous les temps ont été jugés dans cette catégorie spéciale.\nDepuis juin 2000, comparis.ch est une société anonyme dont le siège est à Zurich et qui compte aujourd''hui une centaine de collaborateurs.',NULL,'8003',261,NULL,NULL,NULL,'2025-09-01 17:57:55','2013-11-10 14:18:51','2025-09-01 17:57:55'),
(13,'Alfred Flury-Stiftung',NULL,NULL,'CHE-110.384.702',288119,'CH02070000694',1,1,'Affoltern am Albis',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.aktion-nodrugs.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000069&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Alfred Flury-Stiftung hat sich als politisch und konfessionell nicht gebundene Non-Profit-Organisation zum Ziel gesetzt, durch\n• Aufklärung\n• Information\n• Aktion\nzum Schutz unserer Jugendlichen und Kinder vor jugendgefährdenden Einflüssen beizutragen, wie zum Beispiel Drogen- oder Alkoholkonsum.',NULL,NULL,'8910',2,NULL,NULL,NULL,'2016-10-14 18:11:05','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(14,'Jugend ohne Drogen',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation','punktuell',3,NULL,NULL,'www.jod.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zum Verein Jugend ohne Drogen\n\nDer Verein Jugend ohne Drogen wurde im Januar 1994 in Zürich gegründet und ist ein gesamtschweizerischer Verein. Er nimmt zu aktuellen Fragen der Schweizer Drogenpolitik Stellung\n\nDer Vereinszweck umfasst die Verbreitung sachgerechter Information, die Förderung von Drogenprävention, die geeignet ist, Kinder und Jugendliche in ihrer Persönlichkeit zu stärken sowie die Förderung von Aktivitäten, die geeignet sind, Kinder und Jugendliche vor Rauschgiften zu schützen und den Entzug, die dauerhafte Entwöhnung Drogenabhängiger und deren Wiedereingliederung in die Gesellschaft zu gewährleisten.Der Verein Jugend ohne Drogen ist Mitglied im ''dachverband drogenabstinenz schweiz / www.drogenabstinenz.ch''.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-18 00:00:00','2013-11-10 14:18:51','2022-09-18 23:01:22'),
(15,'Stiftung zur Förderung der Weiterbildung in Hausarztmedizin','Fondation pour la Promotion de la Formation en Médecine de Famille FMF','Fondazione per la promozione della formazione in medicina di famiglia','CHE-114.633.382',930148,'CH03670435873',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',4,NULL,NULL,'http://www.whm-fmf.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0367043587&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Über uns\nDie gemeinnützige Stiftung zur Förderung der Weiterbildung in Hausarztmedizin (WHM) wurde am 13. November 2008 in Bern gegründet. Sie hat den Zweck, Projekte und Massnahmen zu unterstützen, welche die Weiterbildung und damit die Qualität der medizinischen Grundversorgung in Hausarztpraxen nachhaltig fördern, sowie die Kompetenz von angehenden Hausärzten verbessern. Zur Erfüllung dieses Zwecks entwickelt die Stiftung WHM geeignete Konzepte, organisiert auf die hausärztliche Tätigkeit ausgerichtete Weiterbildungsangebote, koordiniert die Weiterbildung in der ambulanten Grundversorgung und unterstützt diese finanziell.\n\n2009 übernahm die Stiftung WHM das beim Kollegium für Hausarztmedizin (KHM) angesiedelte Programm "Weiterbildung in Hausarztpraxen (Praxisassistenz)". Das KHM hatte das Praxisassistenz-Programm seit 1998 entwickelt und betreut, mit Unterstützung von FMH und VSAO. Im Rahmen des Programms subventioniert die Stiftung WHM die Löhne der Praxisassistenzärzte und organisiert Lehrpraktiker-Kurse sowie Praxisführungs-Kurse für Assistenzärzte. Nebst Administration des eigenen Praxisassistenz-Programms, stellt die Stiftung WHM ihre Dienstleistung im Administrationsbereich auch den kantonalen Programmen zur Verfügung. Weiterhin steht die Stiftung WHM Assistenzärzten und Lehrpraktikern betreffend Fragen im Bereich der Weiterbildung in Hausarztmedizin beratend zur Seite.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2020-07-15 14:51:47','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(16,'Associazione per l''aiuto medico al Centro America',NULL,NULL,'CHE-101.667.041',9873,'CH50060026285',1,1,'Giubiasco','AMCA',NULL,NULL,NULL,NULL,NULL,191,10,'Verein','0109',6,'EinzelOrganisation','nie',68,NULL,NULL,'http://www.amca.ch/',NULL,'amca_svizzera',NULL,NULL,NULL,NULL,NULL,'L''Associazione creata nel 1985 persegue lo scopo di promuovere e contribuire con ogni mezzo idoneo e senza fini di lucro, allo sviluppo sanitario dei paesi e dei movimenti democratici del Centro America. L''Associazione contribuisce attivamente al miglioramento delle condizioni sociali ed educative dei paesi in cui opera.',NULL,NULL,'6512',5002,NULL,NULL,NULL,'2022-09-13 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(17,'Associazione Svizzera Inquilini (Asi) Federazione della Svizzera',NULL,NULL,'CHE-106.826.766',NULL,NULL,0,0,'Massagno','ASI',NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',98,NULL,NULL,'https://www.asi-infoalloggio.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Dachverband der Mieterinnen- und Mieterverbände in der italienischsprachigen Schweiz. Ist selber Mitglied im Dachverband der Schweizer Mieterinnen- und Mieterverbände',NULL,NULL,'6900',5196,NULL,NULL,NULL,'2020-06-15 10:55:11','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(18,'Movimento dei Senza Voce',NULL,NULL,'CHE-158.749.771',1098601,'CH50160149221',1,1,'Mendrisio',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer','nie',25,NULL,NULL,'http://movimentodeisenzavoce.org','http://ti.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=5016014922&amt=501&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Tessiner Zweig der Bewegung Sans Papier.Chi siamo\n\nMovimento dei Senza Voce (MdSV) è un''associazione apartitica e aconfessionale costituita ai sensi dell''art.60 e ss. del Codice Civile Svizzero.\n\nL''associazione ha come scopi quelli di sostenere la creazione e l''attuazione di una politica migratoria rispettosa dei diritti umani, di favorire attivamente la partecipazione dei migranti al tessuto sociale con il conseguimento di tutti i diritti sociali, civili e politici,  di chiedere la regolarizzazione di tutti i sans-papiers residenti in Svizzera, di promuovere l''assistenza giuridica e socio-sanitaria, di rivendicare per ottenere le strutture necessarie per i bisogni fondamentali di tutte le persone, svizzeri e stranieri, senza fissa dimora o con problemi di ordine sociale e di restare attenti alle nuove forme di disagio, discriminazione ed esclusione sociale.\n\nFondata nel 2001 l''Associazione fa parte del Movimento svizzero dei sans-papiers.',NULL,NULL,'6850',5254,NULL,NULL,NULL,'2017-06-03 19:49:31','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(19,'Nationale Arbeitsgemeinschaft Suchtpolitik','Coordination politique des addictions',NULL,NULL,NULL,NULL,0,0,'Bern','NAS',NULL,'CPA',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.nas-cpa.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die NAS-CPA wurde 1996 als Plattform für die suchtpolitische Diskussion verschiedener Organisationen gegründet. Mitglieder sind sowohl Organisationen, die sich fachlich mit dem Thema Sucht- und Drogenpolitik auseinandersetzen als auch solche, die in ihrem beruflichen oder gesellschaftlichen Engagement mit der Suchtthematik in Berührung kommen.','La NAS-CPA a été fondée en 1996 pour servir de plateforme de discussion à plusieurs associations impliquées dans la politique en matière d''addictions. Ses membres sont tant des associations s''occupant de politique des addictions que des organisations touchant à cette thématique de par leur vocation professionnelle ou sociale.',NULL,'3011',NULL,NULL,NULL,NULL,'2025-09-09 11:46:22','2013-11-10 14:18:51','2025-09-09 11:46:22'),
(20,'EQUAM Stiftung',NULL,NULL,'CHE-108.180.722',467455,'CH02070006954',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',4,NULL,NULL,'http://www.equam.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000695&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Standards formulieren, Qualität prüfenund verbessern\nDie EQUAM Stiftung ist auf Initiative der folgenden Organisationen entstanden:\n\n SanaCare AG\n Medix Aerzte AG\n Stiftung HMO\n\nDiese drei Managed Care Organisationen verfolgten mit der Gründung der EQUAM Stiftung\nfolgende Ziele:\n\n1.die Struktur-, Prozess- und Ergebnisqualität von HMO-Zentren regelmässig zu prüfen\nund messbare Verbesserungen zu fördern;\n2.die Qualitätsstandards insbesondere aus ärztlicher Sicht mit Einbezug der Patientenschaft\nzu formulieren und ihre Einhaltung durch eine unabhängige Instanz kontrollieren zu lassen;\n3.ein entsprechendes Qualitätszertifikat zu schaffen, welches erteilt und auch wieder\nentzogen werden kann.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2025-07-01 12:59:42','2013-11-10 14:18:51','2025-07-01 12:59:42'),
(22,'Schweizerische Gesundheitsdirektorenkonferenz (GDK)','Conférence suisse des directrices et directeurs cantonaux de la santé (CDS)','Conferenza svizzera delle direttrici e dei direttori cantonali della sanità (CDS)','CHE-396.955.404',NULL,NULL,0,0,'Bern 7','GDK',NULL,NULL,NULL,NULL,NULL,191,NULL,'Staatlich','0224',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',8,NULL,NULL,'http://www.gdk-cds.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'In der GDK sind die für das Gesundheitswesen zuständigen Regierungsmitglieder der Kantone in einem politischen Koordinationsorgan vereinigt. Zweck der Konferenz ist es, die Zusammenarbeit der 26 Kantone sowie zwischen diesen, dem Bund und mit wichtigen Organisationen des Gesundheitswesens zu fördern. Rechtlich und finanziell werden die Konferenz und ihr Zentralsekretariat durch die Kantone getragen.\n\nDie Entscheide der Konferenz haben für ihre Mitglieder und die Kantone den Stellenwert von Empfehlungen. Eine Ausnahme bilden die Regelungen zur Osteopathie. Die Konferenz ist auch als Gesprächsforum der Gesundheitsdirektorinnen und Gesundheitsdirektoren sowie als Ansprechpartnerin für die Bundesbehörden sowie für zahlreiche nationale Verbände und Institutionen von Bedeutung.','La CDS réunit les membres des gouvernements cantonaux compétents en matière de santé au sein d''un organe de coordination politique. Le but de la conférence est de promouvoir la collaboration entre les 26 cantons ainsi qu''entre ceux-ci, la Confédération et les principales organisations du domaine de la santé. La conférence et son secrétariat central sont soutenus juridiquement et financièrement par les cantons.\n\nLes décisions de la conférence ont valeur de recommandations pour ses membres et les cantons. Les réglementations relatives à l''ostéopathie constituent une exception. La Conférence joue également un rôle important en tant que forum de discussion des directrices et directeurs de la santé et en tant qu''interlocutrice des autorités fédérales ainsi que de nombreuses associations et institutions nationales.',NULL,'3000',351,NULL,NULL,NULL,'2024-02-12 15:12:24','2013-11-10 14:18:51','2024-02-12 15:12:24'),
(23,'Forum Managed Care','fmc',NULL,'CHE-110.635.726',744885,'CH02060008391',1,1,'Neuägeri',NULL,'Schweizer Forum für Integrierte Versorgung',NULL,'Forum suisse pour les soins intégrés',NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.fmc.ch/','http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000839&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Das Forum Managed Care ist ein offener Verein für die Diskussion und Verbreitung innovativer Systeme im Schweizer Gesundheitswesen.\n\nEs vereinigt alle Institutionen und Akteure im Gesundheitswesen, die sich mit der Steuerung der Gesundheitsversorgung in qualitativer und ökonomischer Sicht befassen. Das Forum bildet die massgebliche Plattform für den Erfahrungsaustausch über Instrumente und Konzepte der gesteuerten Gesundheitsversorgung und fördert deren Bekanntheit, Akzeptanz und Verbreitung.',NULL,NULL,'6314',1709,NULL,NULL,NULL,'2025-07-01 18:42:17','2013-11-10 14:18:51','2025-07-01 18:42:17'),
(24,'Fourchette verte Tessin',NULL,'Federazione Fourchette verte Ticino',NULL,NULL,NULL,0,0,'Vezia',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation','nie',3,NULL,NULL,'http://www.fourchetteverte.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Ziele von Fourchette verte Schweiz beinhalten hauptsächlich die Strategie "Gesundheit für alle" (Gesundheit 21) der WHO.\n\nFourchette verte engagiert sich vor allem, wenn es darum geht, Veränderungen beim Essverhalten und des Lebensstils zu fördern, und somit zur Vorbeugung von gewissen Erkrankungen beizutragen (Herz-Kreislauf-Erkrankungen, einige Krebsleiden, Krankheiten in Verbindung mit Übergewicht etc.).',NULL,NULL,'6943',NULL,NULL,NULL,NULL,'2017-09-01 06:59:14','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(25,'Public Health Schweiz','Santé publique Suisse','Salute pubblica Svizzera','CHE-113.074.681',1657725,'CH03661000658',1,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.public-health.ch/logicio/pmws/publichealth__home__de.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Public Health Schweiz tritt als nationale Dachorganisation für das Wachstum und die Entwicklung von Public Health und deren Umsetzung in die Praxis ein.\n \nPublic Health Schweiz stützt ihr Handeln auf wissenschaftlicher Basis ab und ist in einem europäischen und weltweiten Netzwerk verankert.\n \nPublic Health Schweiz fördert als nationales Forum den fachübergreifenden Austausch zwischen den für die Gesundheit der Bevölkerung der Schweiz tätigen Personen und Organisationen: Mit Konferenzen, dem Newsletter, verschiedenen Fachgruppen und spannenden Publikationen.',NULL,NULL,'3005',351,NULL,NULL,NULL,'2025-07-01 18:15:05','2013-11-10 14:18:51','2025-07-01 18:15:05'),
(26,'Schweizerischer Verband freier Berufe',NULL,NULL,NULL,NULL,NULL,0,0,'Bern','SVFB',NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.freieberufe.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Verband freier Berufe (SVFB) vertritt als Spitzenverband die gesellschaftspolitisch bedeutsame Gruppe der Angehörigen der freien Berufe sowie deren Standesorganisationen auf nationaler Ebene in allen Bereichen, in welchen gleichgerichtete Interessen bestehen.','En tant qu''association faîtière, l''Union suisse des professions libérales (USPL) représente le groupe important des membres des professions libérales ainsi que leurs organisations professionnelles au niveau national dans tous les domaines où il existe des intérêts convergents.',NULL,'3011',NULL,NULL,NULL,NULL,'2025-09-26 16:09:44','2013-11-10 14:18:51','2025-09-26 16:09:44'),
(27,'Swiss Label',NULL,NULL,'CHE-397.373.251',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',108,NULL,NULL,'http://www.swisslabel.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'SWISS LABEL, die Gesellschaft zur Promotion von Schweizer Produkten und Dienstleistungen, ist ein Verein nach Artikel 60ff des Schweizerischen Zivilgesetzbuches. SWISS LABEL befasst sich im weitesten Sinne mit der Marken- und Labelpflege. Ihr Markenzeichen ist die Armbrust.',NULL,NULL,'3001',351,NULL,NULL,NULL,'2025-07-12 16:16:16','2013-11-10 14:18:51','2025-07-12 16:16:16'),
(28,'FMH Verbindung der Schweizer Ärztinnen und Ärzte','Féderation des médecins suisse','Federazione dei medici svizzeri','CHE-105.892.329',724416,'CH03560324913',1,1,'Bern','FMH',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',4,NULL,NULL,'http://www.fmh.ch/fmh.html','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356032491&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0','doctorfmh',NULL,NULL,'doctorfmh','https://www.linkedin.com/company/fmh%E2%80%93verbindung-schweizer-aerztinnen-und-aerzte/',NULL,'Die Verbindung der Schweizer Ärztinnen und Ärzte FMH ist ein Berufsverband der Schweizer Ärzte. Der Verein vertritt die Interessen der Ärzteschaft in gesamtschweizerischen Angelegenheiten.','La Fédération des médecins suisses FMH est une association professionnelle des médecins suisses. Elle représente les intérêts du corps médical dans les affaires concernant l''ensemble de la Suisse.',NULL,'3006',351,'https://de.wikipedia.org/wiki/Verbindung_der_Schweizer_%C3%84rztinnen_und_%C3%84rzte','Q1721067',NULL,'2025-08-21 00:00:00','2013-11-10 14:18:51','2025-08-21 09:41:01'),
(29,'futureHospital Institute AG in Liquidation',NULL,NULL,'CHE-109.051.760',623248,'CH10030248781',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.futurehospital.ch','http://www.moneyhouse.ch/u/futurehospital_institute_ag_CH-100.3.024.878-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'ehemals Swiss eHealth Campus AG!\nInternationales Kompetenzentrum für Innovationsprojekte, Wissenstransfer, Forschung, Think Tank und industrielle Zusammenarbeit\nDas futureHospital Institute (fHI) verkörpert eine Netzwerkplattform, welche Kompetenzen aus verschiedenen Disziplinen des Gesundheitssystems verdichtet und sämtlichen Partnern und Kunden in Form von verschiedenen Dienstleistungen zur Verfügung stellt. Schwerpunkt ist ICT und eHealth im Gesundheitssystem.\nUnser Beirat trägt wesentlich dazu bei, dass in unserem Unternehmen das Wissen und die Innovationskraft auf möglichst hohem Niveau kultiviert wird.\nDie führenden Partnerunternehmen aus Wirtschaft/Industrie stellen ihre innovativsten Lösungen zu Verfügung, um die teils sehr abstrakten und komplexen Prozesse greifbar und verständlich zu machen. \nUnsere Associate Partner erweitern durch ihre Expertise die Zugänglichkeit von spezifischem Wissen, welches wiederum unseren Kunden in Form von Consulting, Expertisen und Projektmanagement zur Verfüg steht.',NULL,NULL,'6003',1061,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(30,'Ente Ospedaliero Cantonale (EOC)',NULL,NULL,'CHE-108.955.162',1394077,'CH50180148607',1,1,'Bellinzona','EOC',NULL,NULL,NULL,NULL,NULL,191,NULL,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'http://www.eoc.ch/pagina.cfm?menu=2041&pid=2161',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Spitalverbund Tessin EOC l''ospedale multisito\n\nL''Ente Ospedaliero Cantonale si distingue per la qualità e la sicurezza delle cure facendo beneficiare i pazienti dei progressi medici e tecnologici di provata efficacia. Combina armoniosamente eccellenza medica e cure incentrate sulla relazione, ricerca avanzata e formazione di qualità. La multidisciplinarietà dell''offerta sanitaria è un grosso vantaggio per i pazienti che trovano in un''unica struttura specialisti di varie discipline, pronti ad intervenire per qualsiasi situazione.\n\nL''EOC è composto da 6 istituti:\nL''Ospedale Regionale di Lugano con le sedi Civico e Italiano\nL''Ospedale Regionale di Bellinzona e Valli con la sede San Giovanni a Bellinzona e le sedi di Faido e Acquarossa\nL''Ospedale Regionale di Mendrisio - Beata Vergine\nL''Ospedale Regionale di Locarno - la Carità\nL''Istituto Oncologico della Svizzera Italiana\nLa Clinica di Riabilitazione di Novaggio',NULL,NULL,'6500',5002,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(31,'ANW Abbundcenter Nordwestschweiz AG',NULL,NULL,'CHE-113.164.002',847805,'CH28030100158',1,1,'Gelterkinden','ANW',NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',52,NULL,NULL,'http://www.abbundnw.ch/index.php?nodeId=node46b5eaeea5b18','http://www.moneyhouse.ch/u/anw_abbundcenter_nordwestschweiz_ag_CH-280.3.010.015-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Aufbau und Betrieb eines Kompetenzzentrums zur industriellen Fertigung von Halb- und Fertigfabrikaten aus Holz und Holzwerkstoffen für Zimmerei- und weitere Betriebe der Bau- und Holzwirtschaft. Dabei werden sämtliche Dienstleistungen von der Planung bis zur Lieferung vor Ort erbracht.',NULL,NULL,'4460',2846,NULL,NULL,NULL,'2021-01-27 09:15:59','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(32,'Autobus AG Liestal',NULL,NULL,'CHE-102.638.220',11222,'CH28039149820',1,1,'Liestal','AAGL',NULL,NULL,NULL,NULL,NULL,191,2,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',33,NULL,NULL,'https://autobus.ag',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ÖV-Unternehmen im mittleren Baselbiet','Entreprises de transports publics dans le centre de Bâle',NULL,'4410',2829,NULL,NULL,NULL,'2023-08-28 14:36:03','2013-11-10 14:18:51','2024-09-30 14:11:50'),
(33,'Konferenz der Kantonsregierungen','Conférence des gouvernements cantonaux','Conferenza dei governi cantonali',NULL,NULL,NULL,0,0,'Bern 7','KdK',NULL,'CdC',NULL,'CdC',NULL,191,NULL,'Staatlich',NULL,NULL,'DachOrganisation,LeistungsErbringer','immer',13,NULL,NULL,'http://www.kdk.ch/int/kdk/de/kdk.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zusammenarbeit horizontal und vertikal fördern\n\nNach der Volksabstimmung über den EWR im Jahr 1992 suchten die Kantonsregierungen verstärkt nach Wegen, um die interkantonale Zusammenarbeit (horizontaler Föderalismus) und die Zusammenarbeit mit dem Bund (vertikaler Föderalismus) zu verbessern. Dies hat am 8. Oktober 1993 zur Gründung der Konferenz der Kantonsregierungen (KdK-Vereinbarung) geführt.\n\nZweck der KdK ist, die Zusammenarbeit unter den Kantonen in ihrem Zuständigkeitsbereich zu fördern und in kantonsrelevanten Angelegenheiten des Bundes die erforderliche Koordination und Information der Kantone sicherzustellen, insbesondere in Fragen\n\n- der Erneuerung und Weiterentwicklung des Föderalismus;\n- der Aufgabenteilung zwischen Bund und Kantonen;\n- der Willensbildung und Entscheidungsvorbereitung im Bund;\n- des Vollzugs von Bundesaufgaben durch die Kantone;\n- der Aussen- und Europapolitik.',NULL,NULL,'3000',NULL,NULL,NULL,NULL,'2025-02-13 09:19:59','2013-11-10 14:18:51','2025-02-13 09:19:59'),
(34,'Fédération Romande des Consommateurs (FRC)',NULL,NULL,'CHE-106.063.525',NULL,NULL,0,0,'Lausanne','FRC',NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'EinzelOrganisation','immer',81,NULL,NULL,'http://frc.ch/',NULL,'frc_CH','frc.ch',NULL,'federation.romande.des.consommateurs/',NULL,NULL,'La Fédération romande des consommateurs (FRC) est une organisation de protection des consommateurs de Suisse romande.','Die Fédération romande des consommateurs (FRC) ist eine Konsumentenschutzorganisation der Westschweiz.',NULL,NULL,5586,'https://de.wikipedia.org/wiki/F%C3%A9d%C3%A9ration_romande_des_consommateurs','Q3092132',NULL,'2025-08-20 12:48:36','2013-11-10 14:18:51','2025-08-20 12:48:36'),
(35,'Stiftung für Konsumentenschutz',NULL,NULL,'CHE-107.809.718',279826,'CH03570159990',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'DachOrganisation','immer',81,NULL,NULL,'http://konsumentenschutz.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357015999&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung für Konsumentenschutz setzt sich seit 1964 für die Anliegen der Konsumentinnen und Konsumenten ein. Die Geschäftsstelle befindet sich in Bern.',NULL,NULL,'3013',351,'https://de.wikipedia.org/wiki/Stiftung_f%C3%BCr_Konsumentenschutz','Q18413256',NULL,'2025-07-02 11:32:08','2013-11-10 14:18:51','2025-07-02 11:32:08'),
(36,'Schweizerischer Gewerkschaftsbund','Union syndicale suisse',NULL,NULL,NULL,NULL,0,0,'Bern 23','SGB',NULL,'USS',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',53,NULL,NULL,'http://www.sgb.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3000',NULL,NULL,NULL,NULL,'2025-09-02 11:25:52','2013-11-10 14:18:51','2025-09-02 11:25:52'),
(39,'economiesuisse',NULL,NULL,'CHE-105.833.663',737612,'CH02060008207',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','immer',23,NULL,NULL,'https://www.economiesuisse.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000820&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der grösste Dachver­band der Schwei­zer Wirt­schaft\neconomie­suisse vertritt die In­ter­es­sen der Wirt­schaft im politi­schen Pro­zess und setzt sich für optimale Rah­menbedingun­gen ein. Zu un­se­ren Mit­gliedern zäh­len 100 Bran­chenver­bän­de, 20 kanto­nale Handels­kammern sowie einige Einzelunternehmen. Insge­s­amt vertre­ten wir 100''000 Schweizer Unternehmen aus allen Branchen mit insgesamt 2 Millionen Arbeitsplätzen in der Schweiz. KMU und Grossunternehmen, export- und binnen­markt­orientier­te Betriebe: Im Dachver­band economie­suisse sind sie alle ver­eint.',NULL,NULL,'8032',261,NULL,NULL,NULL,'2025-09-08 20:17:09','2013-11-10 14:18:51','2025-09-08 20:17:09'),
(40,'Schweizerisches Konsumentenforum kf',NULL,NULL,'CHE-107.533.568',1514500,'CH03660872974',1,1,'Bern','kf',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',81,NULL,NULL,'http://www.konsum.ch',NULL,'kf_schweiz',NULL,NULL,NULL,NULL,NULL,'Das kf ist die unabhängige, liberale Schweizer Konsumentenorganisation und versteht sich als Kompetenzzentrum für Fragen des Konsums.\nDas kf ist ein Verein nach Art. 60 ff ZGB und Dachverband von eigenständigen Sektionen. Viele schweizerische Organisationen und Verbände sind beim kf Kollektivmitglied. Das kf vertritt so eine halbe Million Konsumentinnen und Konsumenten.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2025-08-21 00:00:00','2013-11-10 14:18:51','2025-08-21 09:41:01'),
(41,'Associazione consumatrici e consumatori della Svizzera italiana',NULL,NULL,NULL,NULL,NULL,0,0,'Lugano-breganzona',NULL,'Konsumentenverband der Südschweiz',NULL,NULL,'ACSI',NULL,191,NULL,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',81,NULL,NULL,'http://www.acsi.ch/index.cfm?sezid=357',NULL,NULL,NULL,NULL,'acsiconsumi','https://www.linkedin.com/company/acsi-svizzera-italiana?originalSubdomain=ch',NULL,'Die ACSI ist ein gemeinnütziger Verein, der seit 1974 tätig ist und dessen Hauptziel es ist, die Verbraucher zu schützen und ihre Rechte durchzusetzen, aber auch sie über einen verantwortungsvollen Konsum aufzuklären. Sie ist eine der vier von der Bundesregierung anerkannten Organisationen und leistet wichtige Informations- und politische Arbeit im Namen aller Verbraucher.','L''ACSI est une association à but non lucratif, active depuis 1974, dont l''objectif principal est de protéger les consommateurs et de faire valoir leurs droits, mais aussi de les informer sur la consommation responsable. Elle est l''une des quatre organisations reconnues par le gouvernement fédéral et effectue un important travail d''information et de politique au nom de tous les consommateurs.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-12-05 10:26:50'),
(42,'Fédération des Entreprises romandes',NULL,NULL,'CHE-107.750.953',NULL,NULL,0,0,'Genève',NULL,NULL,'FER Genève','Fédération des Entreprises romandes Genève',NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,dezidierteLobby','immer',59,NULL,NULL,'http://www.fer-sr.ch/contact.html',NULL,'FERGeneve','fergeneve','FERGenevelive','fergeneve/','https://www.linkedin.com/company/fergeneve/',NULL,'Die Fédération des Entreprises Romandes Genève ist ein Wirtschaftsverband der in der Region Romandie tätigen Unternehmen mit Sitz in Genf. Er umfasst rund 28.000 Mitglieder mit ungefähr 80 Berufsverbänden. Der Verband betätigt sich im Bereich der sozialen Partnerschaften, Entwicklungen von Dienstleistungen und Vernetzung seiner Mitglieder.','La Fédération des Entreprises Romandes Genève est une association économique des entreprises actives dans la région romande, dont le siège est à Genève. Elle regroupe près de 28.000 membres avec environ 80 associations professionnelles. La Fédération est active dans le domaine des partenariats sociaux, du développement de services et de la mise en réseau de ses membres.',NULL,'1201',NULL,'https://de.wikipedia.org/wiki/F%C3%A9d%C3%A9ration_des_entreprises_romandes_Gen%C3%A8ve','Q3091633',NULL,'2025-06-06 18:04:14','2013-11-10 14:18:51','2025-06-06 18:04:14'),
(43,'Schweizerischer Gemeindeverband','Association des Communes Suisses','Associazione dei Comuni Svizzeri','CHE-105.832.037',1331820,'CH03660726433',1,1,'Bern','SGV',NULL,NULL,NULL,NULL,NULL,191,3,'Verein','0109',6,'DachOrganisation,dezidierteLobby','immer',106,NULL,NULL,'https://www.chgemeinden.ch',NULL,'CH_Gemeinden','chgemeinden',NULL,'profile.php?id=100066620326480','https://www.linkedin.com/company/association-des-communes-suisses/',NULL,'Der Schweizerische Gemeindeverband ist seit 1953 der politische Vertreter der Gemeinden auf Bundesebene.','L''Association suisse des communes est le représentant politique des communes au niveau fédéral depuis 1953.',NULL,'3007',351,NULL,NULL,NULL,'2025-08-20 13:00:19','2013-11-10 14:18:51','2025-08-20 13:00:19'),
(44,'Schweizerischer Städteverband','Union des villes suisses','Unione delle città svizzere','CHE-108.142.006',NULL,NULL,0,0,'Bern','SSV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','immer',14,NULL,NULL,'http://staedteverband.ch/de/Info/Stadteverband',NULL,'staedteverband',NULL,NULL,NULL,'https://www.linkedin.com/company/staedteverband/?viewAsMember=true',NULL,'Der Schweizerische Städteverband ist der Dienstleistungs- und Interessenverband, der die Interessen der Städte und städtischen Gemeinden in der Schweiz vertritt. Damit ist der Städteverband die Stimme der urbanen Schweiz, in der rund drei Viertel der Schweizer Bevölkerung wohnen und 84 % der Wirtschaftsleistung unseres Landes erbracht werden. Der Städteverband wurde 1897 gegründet und zählt heute 125 Mitglieder.','L''Association Suisse des Villes est l''association de services et d''intérêts qui représente les intérêts des villes et des communautés urbaines de Suisse. L''Union des villes est ainsi la voix de la Suisse urbaine, où vivent environ les trois quarts de la population suisse et où sont générés 84% de la production économique de notre pays. L''association municipale a été fondée en 1897 et compte aujourd''hui 125 membres.',NULL,'3011',351,NULL,NULL,NULL,'2025-08-20 20:54:33','2013-11-10 14:18:51','2025-08-20 20:54:34'),
(45,'Schweizerische Arbeitsgemeinschaft für die Berggebiete (SAB)','Groupement suisse pour les régions de montagne (SAB)','Gruppo svizzero per le regioni di montagna (SAB)','CHE-105.783.077',NULL,NULL,0,0,'Bern','SAB',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','immer',100,85,NULL,'http://www.sab.ch/UEber-Uns.674.0.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die SAB ist ein Verein und wurde 1943 gegründet. Mitglieder sind alle Bergkantone, Berggemeinden, landwirtschaftliche und Selbsthilfeorganisationen, Berggebietsregionen (IHG-Regionen) und weitere Körperschaften im Berggebiet sowie zahlreiche Einzelpersonen.\n\nUnsere wichtigsten Tätigkeiten sind:\n\n    Politische Interessevertretung für die Berggebiete und ländlichen Räume\n    Dienstleistungen für die Berggebiete und ländlichen Räume\n    Information der Öffentlichkeit über die Anliegen der Berggebiete und ländlichen Räume',NULL,NULL,'3011',351,NULL,NULL,NULL,'2025-07-01 12:52:09','2013-11-10 14:18:51','2025-07-01 12:52:09'),
(47,'Schweizer Bauernverband (SBV)','Union Suisse des Paysans','Unione Svizzera dei Contadini (USC)','CHE-108.088.677',429308,'CH40069010169',1,1,'Brugg AG','SBV',NULL,'USP',NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',85,NULL,NULL,'http://www.sbv-usp.ch/de/wer-wir-sind/organisation/','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4006901016&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0','chbauernverband',NULL,NULL,NULL,NULL,NULL,'60''000 Bauernfamilien\n25 Kantonale Bauernverbände,\n60 Dach-, Fachorganisationen\nLandwirtschaftskammer (100 Mitglieder)\n\nGlobale Interessenvertretung des Bauernstandes als Dachorganisation der Bauern und Bäuerinnen, insbesondere gegenüber den Bundesbehörden, den Politikern und den Wirtschafts- und Sozialpartnern, unter Wahrung der ethnischen Grundwerte bei der Erfüllung seiner Aufgaben.',NULL,NULL,'5200',4095,NULL,NULL,NULL,'2025-09-11 15:18:22','2013-11-10 14:18:51','2025-09-11 15:18:22'),
(48,'Schweizerische Bankiervereinigung (SwissBanking)','Association suisse des banquiers','Associazione svizzera dei banchieri','CHE-105.814.447',165808,'CH27060001895',1,1,'Basel','SBV','SwissBanking',NULL,NULL,NULL,NULL,191,4,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',16,NULL,NULL,'http://www.swissbanking.org/home/aboutus-link/portrait.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Bankiervereinigung (SBVg) ist der Spitzenverband des Schweizer Finanzplatzes. Hauptzielsetzung der SBVg ist die Beibehaltung und Förderung optimaler Rahmenbedingungen im In- und Ausland für den Finanzplatz Schweiz.',NULL,NULL,'4052',2701,NULL,NULL,NULL,'2025-02-13 09:16:34','2013-11-10 14:18:51','2025-02-13 09:16:34'),
(49,'Kaufmännischer Verband Schweiz','Société suisse des employés de commerce','Società svizzera degli impiegati del commercio','CHE-105.840.918',240345,'CH02069004059',1,1,'Zürich','kfmv',NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',53,NULL,NULL,'http://www.kvschweiz.ch/Verband','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206900405&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','KvSchweiz','kfmv.ch','kfmv','kfmv.ch','https://www.linkedin.com/company/kfmv/',NULL,'Der Kaufmännische Verband Schweiz ist das Kompetenzzentrum für Bildung und Beruf im kaufmännisch-betriebswirtschaftlichen Umfeld sowie im Detailhandel.','La Société suisse des employés de commerce est le centre de compétences pour la formation et la profession dans l''environnement commercial et de gestion ainsi que dans le commerce de détail.',NULL,'8004',261,'https://de.wikipedia.org/wiki/Kaufm%C3%A4nnischer_Verband_Schweiz','Q1737058',NULL,'2025-03-05 18:04:53','2013-11-10 14:18:51','2025-03-05 18:04:53'),
(50,'Travail.Suisse',NULL,NULL,'CHE-112.735.043',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',53,NULL,NULL,'http://www.travailsuisse.ch/',NULL,'TravailsuisseCH',NULL,NULL,'travailsuisse',NULL,NULL,'Travail.Suisse ist eine Organisation, welche die politischen Interessen der Arbeitnehmenden und Angestellten eigenständig, kompetent und glaubwürdig vertritt. Im Auftrag seiner Mitgliedsverbände nimmt Travail.Suisse Einfluss auf die Entscheidungsprozesse in den für die Arbeitnehmenden wichtigen Politikbereichen.','Travail.Suisse est une organisation qui défend les intérêts politiques des travailleurs et des employés de manière autonome, compétente et crédible. Sur mandat de ses fédérations membres, Travail.Suisse exerce une influence sur les processus de décision dans les domaines politiques importants pour les travailleurs et travailleuses.',NULL,'3001',351,NULL,NULL,NULL,'2025-08-29 13:55:57','2013-11-10 14:18:51','2025-08-29 13:55:57'),
(51,'EBL (Genossenschaft Elektra Baselland)',NULL,NULL,'CHE-105.966.413',351952,'CH28059103058',1,1,'Liestal','EBL',NULL,NULL,NULL,NULL,NULL,191,NULL,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'http://www.ebl.ch/de/unternehmen/','http://www.moneyhouse.ch/u/ebl_%28genossenschaft_elektra_baselland%29_CH-280.5.910.305-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'EBL ist ein bedeutendes Unternehmen aus Liestal BL, das mehr als 200 000 Menschen täglich mit Strom, Wärme und mit Dienstleistungen der Telekommunikation sicher bedient.\n \nUnd das seit über 110 Jahren.\n \nAls eine privatrechtliche, vollkommen unabhängige Genossenschaft verpflichtet sich das Unternehmen zu verantwortungsbewusstem Handeln für die nachhaltige Entwicklung unserer Umwelt und unserer Gesellschaft.  Durch die konstante Erweiterung der EBL Geschäftsfelder profitieren viele und nicht zuletzt die Kunden der EBL vom einzigartigen Angebot an innovativen und ökologischen Produkten und Dienstleistungen von EBL.',NULL,NULL,'4410',2829,NULL,NULL,NULL,'2023-08-28 14:32:15','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(52,'Raiffeisenbank Liestal-Oberbaselbiet Genossenschaft',NULL,NULL,'CHE-108.751.694',458831,'CH28059117637',1,1,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Genossenschaft','0108',5,'MitgliedsOrganisation','nie',16,NULL,NULL,'http://www.raiffeisen.ch/raiffeisen/internet/rb0027.nsf/sitzcode/0771/?OpenDocument','http://bl.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2805911763&amt=280&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Im Sinne des genossenschaftlichen Gedankengutes von Friedrich Wilhelm Raiffeisen folgende Bankgeschäfte zu tätigen: Entgegennahme von Geldern in allen bankgemässen Formen, einschliesslich Spareinlagen; Hypothekar- und Kreditgeschäft; Abwicklung des Zahlungsverkehrs, indifferentes Geschäft, insbesondere Wertschriftengeschäft. Die Genossenschaft kann Liegenschaften zu Bankzwecken kaufen sowie neu- und umbauen, Liegenschaften im Zwangsverwertungsverfahren ersteigern oder zur Vermeidung einer Versteigerung ankaufen, Liegenschaften verkaufen sowie alle mit Liegenschaften im Zusammenhang stehenden grundbuchlichen Rechte und Lasten begründen und löschen.','Effectuer les opérations bancaires suivantes dans l''esprit de la pensée coopérative de Friedrich Wilhelm Raiffeisen : Réception de fonds sous toutes les formes bancaires, y compris les dépôts d''épargne ; opérations hypothécaires et de crédit ; traitement du trafic des paiements, opérations indifférentes, en particulier opérations sur titres. La coopérative peut acheter des immeubles à des fins bancaires ainsi que les construire ou les transformer, acheter des immeubles aux enchères dans le cadre d''une procédure de réalisation forcée ou les acheter pour éviter une vente aux enchères, vendre des immeubles ainsi que créer et radier tous les droits et charges du registre foncier en rapport avec des immeubles.',NULL,'4410',2829,NULL,NULL,NULL,'2023-08-28 14:32:15','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(53,'Erdgas Zürich AG',NULL,NULL,'CHE-294.453.924',1145922,'CH02030394035',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',46,NULL,NULL,'http://www.erdgaszuerich.ch/de/ueber-erdgas-zuerich.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Gesellschaft bezweckt das Erbringen von Dienstleistungen im Bereich des Handels mit Erdgas und der Erdgasversorgung sowie im Bereich des Handels und der Versorgung mit anderen Energieträgern in der Stadt und in der Region Zürich. Die Gesellschaft darf dazu alle Geschäfte tätigen, die direkt oder indirekt mit ihrem Zweck in Zusammenhang stehen. Die Gesellschaft kann im In- und Ausland Grundeigentum erwerben, belasten, veräussern und verwalten. Sie kann auch Finanzierungen für eigene oder fremde Rechnung vornehmen sowie Garantien und Bürgschaften für Tochtergesellschaften und Dritte eingehen.',NULL,NULL,'8048',261,NULL,NULL,NULL,'2019-09-16 10:02:05','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(54,'Kinderschutz Schweiz','Protection de l''enfance Suisse',NULL,'CHE-114.634.795',930146,'CH03670435852',1,1,'Bern',NULL,'Stiftung Kinderschutz Schweiz',NULL,'Fondation Protection de l''enfance Suisse',NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,dezidierteLobby','punktuell',102,NULL,NULL,'http://www.kinderschutz.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0367043585&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0','kinderschutz_ch','kinderschutzschweiz',NULL,'kinderschutzschweiz/','https://www.linkedin.com/company/kinderschutz/',NULL,'Als nationale Stiftung macht sich Kinderschutz Schweiz in allen Landesteilen dafür stark, dass die Kinder unserer Gesellschaft in Würde aufwachsen, ihre Rechte gewahrt werden und ihre Integrität geschützt wird. Als Grundlagen ihrer Arbeit dienen die UNO-Konvention über die Rechte des Kindes, die Bundesverfassung, die Konvention des Europarates zum Schutz der Menschenrechte und Grundfreiheiten sowie die Gesetzgebung von Bund und Kantonen.','En tant que fondation nationale, l''Association Suisse pour la Protection de l''Enfant s''engage dans toutes les régions du pays pour que les enfants de notre société grandissent dans la dignité, que leurs droits soient respectés et que leur intégrité soit protégée. Son travail se fonde sur la Convention de l''ONU relative aux droits de l''enfant, la Constitution fédérale, la Convention de sauvegarde des droits de l''homme et des libertés fondamentales du Conseil de l''Europe ainsi que sur la législation fédérale et cantonale.',NULL,'3008',351,NULL,NULL,NULL,'2025-10-28 08:58:52','2013-11-10 14:18:51','2025-10-28 08:58:52'),
(55,'Stiftung Pestalozzianum',NULL,NULL,'CHE-105.983.854',286345,'CH02079030703',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.pestalozzianum.ch/de/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207903070&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Pestalozzianum ist ein Gemeinschaftswerk des Kantons Zürich, der Pädagogischen Hochschule Zürich und der vorgängigen Stiftung Pestalozzianum. Sie wurde in heutiger Form im Jahr 2003 gegründet. Die Vorgängerstiftung führte seit 1875 das "Pestalozzianum Zürich", ein Institut für Pädagogik, das 2002 in die Pädagogische Hochschule Zürich integriert worden ist.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2025-09-02 12:03:02','2013-11-10 14:18:51','2025-09-02 12:03:02'),
(56,'CASTAGNA, Beratungs- und Informationsstelle',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',12,NULL,NULL,'http://www.castagna-zh.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Wir beraten weibliche Jugendliche, in der Kindheit sexuell ausgebeutete Frauen, nicht ausbeutende Eltern, Bezugspersonen von Betroffenen, Fachpersonen und Institutionen',NULL,NULL,'8006',NULL,NULL,NULL,NULL,'2022-09-15 00:00:00','2013-11-10 14:18:51','2022-09-15 12:53:16'),
(57,'Pflege- und Adoptivkinder Schweiz',NULL,NULL,'CHE-112.356.757',1278866,'CH02060021767',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',12,NULL,NULL,'http://www.pflegekinder.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Seit 60 Jahren setzt sich die Pflegekinder-Aktion Schweiz für bessere Entwicklungschancen von Pflegekindern ein.\n\nIn der Schweiz leben rund 15''000 Pflegekinder. Die meisten kommen aus mehrfach belasteten Familienverhältnissen. Pflegekinder brauchen ein sicheres Zuhause und Erwachsene, auf die sie sich verlassen können.\n\nDie Pflegekinder-Aktion Schweiz setzt sich in der Öffentlichkeit für die Interessen von Kindern ein, die in einer Pflegefamilie leben, weil ihre Eltern nicht in angemessener Weise für sie sorgen können. Viele von ihnen haben traumatische Erfahrungen gemacht, Angst, Ohnmacht, Vernachlässigung oder Misshandlung erlebt. Mit ihren Aktivitäten will die Pflegekinder-Aktion Schweiz die Entwicklungschancen der Pflegekinder fördern.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2025-07-01 18:42:17','2013-11-10 14:18:51','2025-07-01 18:42:17'),
(58,'PRO FAMILIA SCHWEIZ','Pro Familia Suisse',NULL,'CHE-107.272.072',331314,'CH03560008848',1,1,'Bern','PFS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',12,NULL,NULL,'http://www.profamilia.ch/portrait.html','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356000884&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Wir sind die Dachorganisation von über 40 nationalen Mitgliederorganisationen und von kantonalen Pro Familia Sektionen, die sich für Familien, für Eltern einsetzen. Pro Familia Schweiz (PFS) vernetzt die Familien und Elternorganisationen, die kantonalen und regionalen Pro Familia Sektionen und trägt als Dachverband zur Stärkung der Stellung der Familien in Anerkennung deren Vielfalt bei.\n\nZweck des Dachverbandes Pro Familia Schweiz ist die Förderung der Familienpolitik in der Schweiz.\n\nDas Kompetenzzentrum von Pro Familia Schweiz begleitet Unternehmen und die Öffentliche Hand in der Gestaltung der Familienfreundlichkeit. Schwerpunktthema ist die Vereinbarkeit von Beruf und Familie.','Le centre de compétence de Pro Familia Suisse accompagne les entreprises, les institutions et les pouvoirs publics dans la promotion de conditions cadre favorables à une meilleure conciliation de la vie professionnelle avec la vie privée et familiale.',NULL,'3011',351,NULL,NULL,NULL,'2025-06-19 16:36:10','2013-11-10 14:18:51','2025-06-19 16:36:10'),
(59,'Basler Kantonalbank',NULL,NULL,'CHE-108.954.493',218288,'CH27080000022',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'MitgliedsOrganisation,LeistungsErbringer','nie',16,NULL,NULL,'http://www.bkb.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Basler Kantonalbank betätigt sich als Universalbank. Sie ermöglicht ihrer Kundschaft die sichere und zinstragende Anlage ihrer Ersparnisse und anderer Gelder. Sie ermöglicht nach Massgabe ihrer Mittel und den Verhältnissen am Geld- und Kapitalmarkt zunächst der Bevölkerung und der Wirtschaft des Kantons Basel-Stadt von Kleinst- bis Grossunternehmen die Befriedigung ihrer Kredit- und Geldbedürfnisse. Sie trägt unter besonderer Berücksichtigung der Bedürfnisse der gegenwärtigen Bevölkerung, der Wirtschaft und der öffentlichen Hand zu einer ausgewogenen sowie ökologisch, wirtschaftlich und sozial nachhaltigen Entwicklung des Kantons Basel-Stadt bei, die zugleich die Fähigkeit künftiger Generationen nicht gefährdet, ihre eigene Bedürfnisse zu befriedigen. Sie fördert die Chancengleichheit und die Gleichberechtigung. Sie ist nach kaufmännischen Grundsätzen zu führen und strebt einen ihrem Zweck angemessenen Gewinn an.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2020-04-04 19:55:18','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(60,'adoro consulting ag',NULL,NULL,'CHE-116.091.960',996486,'CH27030144053',1,1,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',58,NULL,NULL,NULL,'http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2703014405&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt die Erbringung von Dienstleistungen im Bereich Unternehmensberatung, Treuhand, Steuern, Rechnungswesen und Buchführung, Revision sowie damit zusammenhängende Tätigkeiten. Sie kann Liegenschaften, Beteiligungen und Immaterialgüter erwerben, halten und veräussern sowie alle anderen Geschäfte tätigen, welche geeignet sind, die Entwicklung der Unternehmung zu fördern oder zu erleichtern. Sie kann Finanzierungen für sich und Dritte vornehmen, Darlehen gewähren, sowie Garantien und andere Sicherheiten stellen.',NULL,NULL,'6300',1708,NULL,NULL,NULL,'2019-08-16 14:28:15','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(61,'aspero ag',NULL,NULL,'CHE-115.898.753',990616,'CH27030143761',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,9,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',57,NULL,NULL,'http://aspero.ch/','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2703014376&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Versicherungen sind unser Metier. Als neutraler und unabhängiger Versicherungsbroker stellen wir uns voll in den Dienst unserer Kunden.\n\nWir beraten Sie neutral und auf Ihre persönlichen Bedürfnisse zugeschnitten in den Bereichen Krankenversicherungen, Sachversicherungen (wie z.B. Hausrat- und Privathaftpflicht- und Motorfahrzeugversicherungen etc.), Lebensversicherungen, Rechtsschutzversicherungen, Geschäftsversicherungen (wie z.B. Krankentaggeld, Unfallversicherungen etc.). Zudem bieten wir Ihnen auch persönlich zugeschnittene Vorsorgelösungen und Finanzierungen an',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2018-09-04 15:52:32','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(62,'Dr. Sebastian Frehner Consulting',NULL,NULL,'CHE-115.054.962',955803,'CH27010155575',1,1,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Einzelunternehmen','0101',1,'EinzelOrganisation,LeistungsErbringer','nie',18,NULL,NULL,NULL,'http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2701015557&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Erbringung von Dienstleistungen im Bereich Unternehmensberatung und Treuhand',NULL,NULL,'6300',1711,NULL,NULL,NULL,'2019-08-16 14:28:15','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(63,'pro rabais',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','nie',108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4051',NULL,NULL,NULL,NULL,'2017-07-10 17:37:26','2013-11-10 14:18:51','2017-07-10 17:37:26'),
(64,'xundart AG',NULL,NULL,'CHE-113.726.644',878321,'CH32030616070',1,1,'Wil SG',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',4,NULL,NULL,'http://www.xundart.ch/','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3203061607&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Betreibt ein Ärztenetzwerk und bezweckt den Abschluss von Managed Care Verträgen mit Versicherern, die gemeinsame Wahrung beruflicher Interessen der Mitglieder, die Förderung einer hohen, von den NetzärztInnen mitdefinierten medizinischen Qualität sowie die Förderung einer zeitgemässen medizinischen Grundversorgung, die Sicherstellung einer wirksamen, zweckmässigen und wirtschaftlichen medizinischen Grundversorgung im geografischen Tätigkeitsgebiet der beteiligten NetzwerkärztInnen, die Förderung und Optimierung der Zusammenarbeit auf gleichberechtigter Basis zwischen Grundversorgern und SpezialärztInnen in Behandlungsketten, die partnerschaftliche Zusammenarbeit der NetzärztInnen bei der Betreuung der PatientInnen, die kontinuierliche Optimierung der regionalen Gesundheitsversorgung durch die Weiterentwicklung des Ärztenetzwerks.',NULL,NULL,'9500',3427,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(65,'SPO Schweizerische Patientenorganisation','Fondation Organisation suisse des patients OSP',NULL,'CHE-106.079.070',436266,'CH02079044874',1,1,'Zürich','SPO',NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.spo.ch/','http://www.moneyhouse.ch/u/schweizerische_stiftung_spo_patientenschutz_CH-020.7.904.487-4.htm',NULL,NULL,NULL,'spopatientenorganisation/','https://www.linkedin.com/company/spo-patientenorganisation/',NULL,'Die Stiftung SPO Patientenschutz schützt und fördert die Patientenrechte im Gesundheitswesen wie etwa gegenüber Ärzten, Zahnärzten, Krankenkassen. Sie setzt sich ein für Information und Beratung und ermöglicht den Patienten eine aktive, verantwortungsvolle Mitwirkung.','La Fondation Organisation suisse des patients OSP protège et promeut les droits des patients dans le domaine de la santé, par exemple vis-à-vis des médecins, des dentistes et des caisses d''assurance maladie. Elle s''engage pour l''information et le conseil et permet aux patients de participer activement et de manière responsable.',NULL,'8006',261,NULL,NULL,NULL,'2025-06-18 13:52:48','2013-11-10 14:18:51','2025-06-18 13:52:48'),
(66,'Santé sexuelle suisse','Santé sexuelle Suisse','Salute sessuale Svizzera','CHE-109.590.152',599107,'CH55010218197',1,1,'Lausanne','SGCH','Sexuelle Gesundheit Schweiz','SSCH',NULL,'SSCH',NULL,191,NULL,'Stiftung','0110',7,'DachOrganisation,LeistungsErbringer','punktuell',3,NULL,NULL,'https://www.sexuelle-gesundheit.ch','https://www.rc2.vd.ch/registres/hrcintapp-pub/companyReport.action?companyOfsUid=CHE-109.590.152','SGCH_SSCH','sexuellegesundheitschweiz',NULL,'SexuelleGesundheitSchweiz',NULL,NULL,'Der Verein SEXUELLE GESUNDHEIT SCHWEIZ ist ein gemeinnütziger Zusammenschluss von Organisationen, die im Bereich der sexuellen Gesundheit und Rechte tätig sind.','L''association SANTÉ SEXUELLE SUISSE est une alliance d''utilité publique. Elle regroupe des organisations actives dans le domaine de la santé sexuelle et reproductive, et des droits y afférents.',NULL,'1003',5586,NULL,NULL,NULL,'2025-08-29 13:55:57','2013-11-10 14:18:51','2025-08-29 13:55:57'),
(67,'Gesellschaft Schweiz - Albanien',NULL,NULL,'CHE-114.291.436',908286,'CH32060632583',1,1,'Goldach',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',70,NULL,NULL,'http://www.schweiz-albanien.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Wir verstehen uns als Transformationsstelle zwischen Politik, Verwaltung, Wirtschaft, Unternehmen und Investoren in und zwischen den beiden Ländern.\nWir stützen uns auf ein umfassendes und dicht gespanntes Netzwerk in der Schweiz und in Albanien.\nWir bauen auf die langjährige Erfahrung von Schweizer Institutionen der Entwicklungszusammenarbeit, Schweizer Unternehmen in Albanien und Albanischen Unternehmern und Bürgern in der Schweiz.\nWir arbeiten zusammen mit europäischen Unternehmen, die in Albanien, Kosova und Mazedonien bereits tätig sind.\nWer zuverlässige Informationen benötigt, Kontakte sucht oder Geschäfte anbahnen will, wendet sich an die Gesellschaft Schweiz-Albanien.',NULL,NULL,'9403',3213,NULL,NULL,NULL,'2020-12-07 07:22:16','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(68,'Interessengemeinschaft öffentlicher Verkehr Ostschweiz',NULL,NULL,NULL,NULL,NULL,0,0,NULL,'IGöV Ostschweiz',NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',33,NULL,NULL,'http://www.igoev.ch/ostschweiz/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Interessengemeinschaft öffentlicher Verkehr Ostschweiz (IGöV) ist ein politisch neutraler Verein, dessen Mitglieder sich aktiv dafür einsetzen, dass die bestehenden guten Angebote im Bereich des öffentlichen Verkehrs weiter ausgebaut und bestehende Lücken geschlossen werden. Dem Verein gehören Benutzerinnen und Benutzer des öV, Angestellte von Transportunternehmungen und weitere Fachleute des öV sowie Politikerinnen und Politiker der verschiedenen Parteien an.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-10-19 16:52:03','2013-11-10 14:18:51','2022-10-04 22:11:38'),
(69,'Interessengemeinschaft öffentlicher Verkehr Schweiz','Communauté d''intérêts pour les transports publics Suisse',NULL,NULL,NULL,NULL,0,0,'Bern 6','IGöV Schweiz',NULL,'Citrap Suisse',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,DachOrganisation,dezidierteLobby','punktuell',33,NULL,NULL,'http://www.igoev.ch/',NULL,'igoev_citrap',NULL,NULL,NULL,NULL,NULL,'Die Interessengemeinschaft öffentlicher Verkehr (IGöV) vertritt die Anliegen und Bedürfnisse der ÖV-Nutzerinnen und -Nutzer - Präsidentin Florence Brenzikofer über die grössten Herausforderungen und die dringlichsten Projekte.','La Communauté d''intérêts pour les transports publics (CITraP) défend les intérêts et les besoins des usagers des transports publics - la présidente Florence Brenzikofer évoque les plus grands défis et les projets les plus urgents.',NULL,'3000',NULL,NULL,NULL,NULL,'2025-07-02 11:32:08','2013-11-10 14:18:51','2025-07-02 11:32:08'),
(70,'miva',NULL,NULL,'CHE-107.854.736',595961,'CH32060490666',1,1,'Wil SG',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',68,NULL,NULL,'http://www.miva.ch','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3206049066&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Als eines der ältesten Hilfswerke der Schweiz setzt sich miva seit 1932 für benachteiligte Menschen im Süden ein. Sie unterstützt die Finanzierung und professionelle Beschaffung von zweckmässigen Transport- und Kommunikationsmitteln für die Selbsthilfe. Berücksichtigt werden Partner an der Basis, die sich für die lokale Entwicklung sowie in sozialen und pastoralen Projekten engagieren. Ihre Aktivitäten basieren auf Nächstenliebe, gelebter Solidarität und Hilfe zur Selbsthilfe.',NULL,NULL,'9500',3427,NULL,NULL,NULL,'2022-09-15 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(71,'umverkehR','actif-trafic','Straffico','CHE-112.638.859',NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'MitgliedsOrganisation,dezidierteLobby','nie',43,NULL,NULL,'http://www.umverkehr.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'umverkehR (ja, das grosse "R" ist Absicht!) ist eine Umweltorganisation mit gut 6000 Sympatisantinnen und Unterstützern. Unsere Mitglieder stammen grösstenteils aus der Schweiz, der Sitz des Vereins ist Zürich. Auf französisch heissen wir übrigens actif-trafiC und auf italienisch Straffico.',NULL,NULL,NULL,261,NULL,NULL,NULL,'2025-09-02 11:07:20','2013-11-10 14:18:51','2025-09-02 11:07:20'),
(72,'Stiftung Albert Grütter-Schlatter zur Unterstützung alleinstehender alter Leute',NULL,NULL,'CHE-110.376.329',274791,'CH26070000143',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.monetas.ch/htm/647/de/Firmendaten-Stiftung-Albert-Gr%C3%BCtter-Schlatter-zur-Unterst%C3%BCtzung-alleinstehender-alter-Leute.htm?subj=1315957','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2607000014&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Finanzielle Unterstützung von über 70 Jahre alten alleinstehenden Frauen und Männern, die kein eigenes Heim haben und deren AHV-Rente ungenügend ist. Vorausgesetzt sind das solothurnische Bürgerrecht oder der Wohnsitz im Kanton Solothurn.',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2018-09-18 14:04:57','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(73,'Pro Senectute Kanton Solothurn - Für das Alter',NULL,NULL,'CHE-105.902.459',331470,'CH26070000705',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.so.pro-senectute.ch/d/index.cfm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung hat zum Ziel, das Wohl der älteren Menschen im Kanton Solothurn zu erhalten und zu heben.',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2018-09-18 14:04:57','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(74,'Keradonum Stiftung Hornhautbank in Liquidation',NULL,NULL,'CHE-114.617.271',928989,'CH24170079435',1,1,'Olten',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,dezidierteLobby','nie',4,NULL,NULL,'http://www.monetas.ch/htm/647/de/?subj=2076091',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Bezweckt, in Olten eine Hornhautbank zu errichten und zu betreiben und alle mit der Hornhautmedizin in Zusammenhang stehenden Tätigkeiten auszuüben oder zu fördern, namentlich akquiriert sie Gewebe für die Augenmedizin, arbeitet diese auf und stellt sie für Transplantationszwecke entsprechend spezialisierten Institutionen zur Verfügung, leistet Aufklärung auf dem Gebiet der Hornhauttransplantation und sensibilisiert die Öffentlichkeit über die Notwendigkeit von Hornhautspenden, fördert die Forschung auf dem Gebiet der Hornhautchirurgie sowie die Zusammenarbeit mit Spitälern, Universitäten sowie Unternehmen im medizinischen und pharmazeutischen Bereich.','Elle a pour but de créer et d''exploiter une banque de cornées à Olten et d''exercer ou de promouvoir toutes les activités en rapport avec la médecine de la cornée, notamment d''acquérir des tissus pour l''ophtalmologie, de les traiter et de les mettre à la disposition d''institutions spécialisées correspondantes à des fins de transplantation, de fournir des informations dans le domaine de la transplantation de cornées et de sensibiliser le public à la nécessité des dons de cornées, de promouvoir la recherche dans le domaine de la chirurgie de la cornée ainsi que la collaboration avec les hôpitaux, les universités et les entreprises du secteur médical et pharmaceutique.',NULL,'4600',2581,NULL,NULL,NULL,'2019-09-04 13:30:36','2013-11-10 14:18:51','2024-07-19 05:08:57'),
(76,'Interessengemeinschaft öffentliche Arbeitsplätze',NULL,NULL,NULL,NULL,NULL,0,0,'Olten','IGöffA',NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',53,NULL,NULL,'http://www.igarbeit.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein setzt sich für einen attraktiven Service publique bei öffentlichen\nDienstleistungen ein, für flächendeckende Erbringung von Dienstleistungen für alle zu\nfairen Preisen und Arbeitsbedingungen.\nDer Verein fördert innovative Ideen zum Ausbau des Service publique\nDer Verein fördert die Bewusstseinsbildung über die Bedeutung der Arbeitsplätze\nin öffentlichen Dienstleistungen für die Region Olten und mobilisiert die Region zum\nErhalt und Ausbau dieser Arbeitsplätze.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-06-26 08:17:21','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(77,'Komitee Pro Eppenberg',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',33,NULL,NULL,'http://eppenbergtunnel.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Pro Eppenberg Tunnel',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-06-26 08:17:21','2013-11-10 14:18:51','2017-10-30 08:09:12'),
(78,'Verband Lehrerinnen & Lehrer Solothurn',NULL,NULL,'CHE-104.438.028',NULL,NULL,0,0,'Solothurn','LSO',NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',53,NULL,NULL,'http://www.lso.ch/cms/front_content.php?idcat=67&idart=174&lang=1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Lehrerinnen und Lehrer Kt. Solothurn',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2022-09-23 00:00:00','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(79,'Europäische Bewegung Schweiz','Mouvement européen Suisse','Nuovo movimento europeo svizzero','CHE-107.811.158',NULL,NULL,0,0,'Bern','NEBS','Neue Europäische Bewegung Schweiz','NOMES','Nouveau mouvement européen Suisse','NUMES',NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',75,NULL,NULL,'https://www.europa.ch/',NULL,'nomesnebs',NULL,NULL,NULL,NULL,NULL,'Unser Ziel: das europäische Stimmrecht erhalten\nDie Globalisierung stellt für alle Menschen eine Herausforderung dar. Die Europäerinnen und Europäer begegnen ihr in der Europäischen Union gemeinsam. Damit die Schweiz bei den Entscheidungen, die sie betreffen, mitbestimmen kann, muss sie das europäische Stimmrecht erhalten.\n\nUnsere Aufgabe: den Beitritt zu möglichst günstigen Bedingungen herbeiführen\nUm das europäische Stimmrecht zu erhalten, müssen wir Mitglied der Europäischen Union werden. Die Aufgabe der Nebs besteht darin, die Schweiz so vorzubereiten, dass sie zu optimalen wirtschaftlichen, sozialen und institutionellen Bedingungen Aktivmitglied der EU werden kann. Dieser Prozess muss heute eingeleitet werden. Die Nebs begleitet ihn aktiv.','Au-delà de ses activités, le Nomes prend régulièrement position sur les enjeux d''actualité liés à la politique européenne suisse. Il participe aux procédures de consultation officielles du Conseil fédéral et diffuse ses opinions par voie de presse.\n\nBilatéralisme, Erasmus+, libre échange agricole ou litige fiscal, quelle que soit la question, le Nomes prend position. Il apporte une contribution non partisane, indépendante et constructive à la compréhension de la politique européenne de la Suisse.',NULL,'3014',351,NULL,NULL,NULL,'2025-07-22 00:00:00','2013-11-10 14:18:51','2025-07-22 16:55:11'),
(80,'Palliative Care Netzwerk Kanton Solothurn',NULL,NULL,NULL,NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',4,NULL,NULL,'http://www.palliativecare-so.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Netzwerk bezweckt die Vernetzung sowie den Informations- und Erfahrungs-\n   \naustausch zwischen Personen und Institutionen, die sich im Kanton Solothurn\n   \nfür Palliative Care "als umfassende ärztliche, pflegerische, soziale, psychologische\n    \nund spirituelle Begleitung der Kranken und ihrer Angehörigen einsetzen.\n   \n    \n- die Information der Öffentlichkeit, der Fachwelt und der Politik über die\n   \nAnliegen von Palliative Care.\n   \n- die Förderung der Weiter- und Fortbildung auf dem Gebiet von Palliative Care.\n- die Förderung und Koordination eines bedarfsgerechten Leistungsangebotes.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-06-26 08:18:04','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(81,'Pro Natura Solothurn',NULL,NULL,'CHE-100.499.166',NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',54,NULL,NULL,'http://www.pronatura-so.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Pro Natura ist die führende Organisation für Naturschutz in der Schweiz. Als Anwältin und Meinungsmacherin für Naturschutz verteidigt sie engagiert und kompetent die Interessen der Natur und setzt sich für die Förderung und den Erhalt der einheimischen Tier- und Pflanzenwelt ein. Zu den Pioniertaten der 1909 gegründeten Organisation gehört die Schaffung des Schweizerischen Nationalparks. Heute betreut Pro Natura über 600 Naturschutzgebiete und ein Dutzend Naturschutzzentren in der ganzen Schweiz. Mit ihren Sektionen ist Pro Natura in allen Kantonen der Schweiz aktiv.',NULL,NULL,NULL,2601,NULL,NULL,NULL,'2022-09-14 00:00:00','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(82,'IG Pro Vebo - Pro Insos',NULL,NULL,NULL,NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',15,NULL,NULL,'http://www.vebo.ch/de/partnerschaften-vebo-genossenschaft-public-private-partnership-ig-pro-vebo.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Unterstützungsgremium für die Genossenschaft VEBO.\nIm Vorfeld der  NFA entstand 2003, auf die Initiative des Solothurner Ständerates Rolf Büttiker, die Interessengemeinschaft "IG pro VEBO und INSOS". Sie vereinigt die solothurnischen Mitglieder des Bundesparlaments und die wichtigsten Kantons- und Gemeindeparlamentarierinnen und -Parlamentarier aller Parteien, um die Interessen der VEBO und ihrer Interessengruppen in der Politik auf den Ebenen Bund, Kantone und Gemeinden zu wahren.\n\nDer Zweck der VEBO Genossenschaft ist die Förderung der Eingliederung von Menschen mit Behinderung in unsere Gesellschaft". Die VEBO nimmt ihre vielfältigen sozialen Aufgaben in den folgenden fünf Produktbereichen wahr: Integrationsmassnahmen, Berufliche Massnahmen, Geschützte Arbeitsplätze, Wohnen, Tagesstätten',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-08 17:22:42','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(83,'SEV - Gewerkschaft des Verkehrspersonals','Syndicat du personnel des transports','Sindacato del personale dei trasporti','CHE-105.832.066',417009,'CH03560011547',1,1,'Bern','SEV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,DachOrganisation,LeistungsErbringer','punktuell',53,33,NULL,'http://www.sev-online.ch/de/der-sev/sev.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der SEV ist die grösste und stärkste Gewerkschaft im Bereich des öffentlichen Verkehrs und der Touristischen Bahnen. Der SEV organisiert rund 40''000 Beschäftigte in den Branchen Bahn, Bus/Nahverkehr, Schifffahrt, Touristische Bahnen sowie Luftverkehr.','Le SEV est le plus grand et le plus puissant syndicat dans le domaine des transports publics et des chemins de fer touristiques. Le SEV organise environ 40''000 employés dans les branches des chemins de fer, des bus/transports urbains, de la navigation, des chemins de fer touristiques ainsi que du transport aérien.',NULL,'3006',351,'https://de.wikipedia.org/wiki/Gewerkschaft_des_Verkehrspersonals','Q1520570',NULL,'2023-01-27 00:00:00','2013-11-10 14:18:51','2024-11-08 06:02:13'),
(84,'Spital Club Solothurn',NULL,NULL,'CHE-285.626.315',NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'https://www.so-h.ch/spitalclub/angebot.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zusatzversicherungen zur obligatorischen Krankenkasse',NULL,NULL,NULL,2601,NULL,NULL,NULL,'2018-09-18 14:04:57','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(85,'Spitex Verband Kanton Solothurn',NULL,NULL,NULL,NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',7,NULL,NULL,'http://www.spitexso.ch/index.cfm/3F6C0897-F8E0-1700-BA518B941B9848FC/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Spitex Verband Kanton Solothurn SVKS ist der Dachverband von 39 gemeinnützigen, lokalen Spitex-Organisationen im Kanton Solothurn.\n\nEr vertritt als Arbeitgeber- und Fachverband die Interessen seiner Mitgliederorganisationen sowie der Klientinnen und Klienten bei Behörden, Versicherungen, Partnerorganisationen und in der Öffentlichkeit.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-09-18 14:04:57','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(86,'Staatspersonalverband Kanton Solothurn',NULL,NULL,NULL,NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',53,NULL,NULL,'http://www.staatspersonal.ch/home/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-08-20 20:54:33','2013-11-10 14:18:51','2025-08-20 20:54:34'),
(87,'Schweizerische Vereinigung zum Schutz der kleinen und mittleren Bauern',NULL,NULL,NULL,NULL,NULL,0,0,'Bern','VKMB','Kleinbauernvereinigung',NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',80,NULL,NULL,'http://www.kleinbauern.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Vereinigung zum Schutz der kleinen und mittleren Bauern (Abkürzung: Kleinbauern-Vereinigung oder VKMB) setzt sich für eine vielfältige, nachhaltige und bäuerliche Land­wirtschaft ein. Die Nahrungsproduktion soll optimal mit multifunk­tio­­nalen Leistungen, umwelt­schonender Be­wirt­­schaf­­tung und art­gerechter Nutztier­haltung kombiniert werden. Sie strebt die Versorgung der Bevölkerung mit möglichst ökologisch, fair und regional produzierten Lebensmitteln an.',NULL,NULL,'3001',NULL,NULL,NULL,NULL,'2025-09-08 21:23:29','2013-11-10 14:18:51','2025-09-08 21:23:29'),
(88,'Vereinigung Solothurnischer Musikschulen',NULL,NULL,NULL,NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',10,NULL,NULL,'http://www.solothurnermusikschulen.ch/cms/component/option,com_frontpage/Itemid,1/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Vereinigung Solothurner Musikschulen umfasst möglichst alle öffentlichen Musikschulen im Kanton Solothurn.\nWir streben einen hohen Mitgliederanteil an.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-09-18 14:04:57','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(90,'GEWA',NULL,NULL,'CHE-106.023.767',630815,'CH03570296758',1,1,'Zollikofen',NULL,'Stiftung für berufliche Integration',NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.gewa.ch/','https://be.chregister.ch/cr-portal/auszug/auszug.xhtml;jsessionid=d66f1441b725e6c8f19d1bfdd4b5?uid=CHE-106.023.767#',NULL,NULL,NULL,NULL,NULL,NULL,'Die GEWA Stiftung für berufliche Integration ist ein sozialwirtschaftliches Unternehmen mit dem Ziel, Menschen, die aus psychischen Gründen besonders herausgefordert sind, beruflich zu integrieren. Unser Kernanliegen ist es, Menschen zu befähigen, ihren Platz in der Arbeitswelt zu finden. Um diesen Auftrag wahrzunehmen, vereint die GEWA unter ihrem Dach elf Betriebe verschiedener Branchen.',NULL,NULL,'3052',361,NULL,NULL,NULL,'2025-07-15 00:00:00','2013-11-10 14:18:51','2025-07-15 15:48:18'),
(91,'STIFTUNG WILDSTATION LANDSHUT (SWSL)',NULL,NULL,'CHE-115.177.955',961105,'CH03670460080',1,1,'Utzenstorf','SWSL',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',54,NULL,NULL,'http://www.wildstation.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Wir kümmern uns um die Aufzucht oder die Genesung von schweizer Wildtieren. Die Stiftung Wildstation Landshut in Utzenstorf, Kanton Bern, liegt auf einem 16.000 qm2 grossen Gelände neben dem idyllischen Schloss Landshut.',NULL,NULL,'3427',351,NULL,NULL,NULL,'2023-07-10 08:11:08','2013-11-10 14:18:51','2024-11-08 05:08:51'),
(92,'Berner Jägerverband (BEJV)',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',54,NULL,NULL,'http://www.bernerjagd.ch/willkommen-beim-bejv.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'zur Erhaltung und Förderung der bernischen Patentjagd und einer weidgerechten Jagdausübung. Der Berner Jägerverband verurteilt jegliche Form von Wilderei;\nfür eine nachhaltige Bejagung der Wildbestände nach wildbiologischen Gesichtspunkten;\nzur Hege der jagdbaren, nichtjagdbaren und gefährdeten freilebenden Tierarten sowie zur Erhaltung und Wiederherstellung deren Lebensräume;',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-07-15 00:00:00','2013-11-10 14:18:51','2025-07-15 15:48:18'),
(93,'Verband Bernischer Gemeinden VBG',NULL,NULL,'CHE-132.499.207',NULL,NULL,0,0,'Bern 8','VBG',NULL,NULL,NULL,NULL,NULL,191,3,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',106,NULL,NULL,'http://www.begem.ch/index.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3000',351,NULL,NULL,NULL,'2014-12-30 08:40:13','2013-11-10 14:18:51','2024-09-24 13:43:04'),
(94,'Aktion für vernünftige Energiepolitik Schweiz',NULL,NULL,NULL,NULL,NULL,0,1,'Bern','AVES',NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',30,NULL,NULL,'http://www.aves.ch/ziele.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'AVES Schweiz war ein 1979 gegründeter Verein, der sich sich "für eine sichere, ausreichende und volkswirtschaftlich optimale Energieversorgung der Schweiz" einsetzte. Dies manifestierte sich primär in einem grossen Engagement für die Schweizer Atomenergie. Nach der Reaktorkatastrophe im japanischen Fukushima 2011 verlor der Verein zunehmend an Gewicht. Am 15. November 2018 wurde die AVES Schweiz aufgelöst. Kantonale Sektionen existieren weiterhin. Den Mitgliedern von AVES Schweiz wurde empfohlen, dem Energie Club Schweiz beizutreten.',NULL,NULL,'3011',NULL,NULL,NULL,NULL,'2021-02-04 08:17:14','2013-11-10 14:18:51','2021-02-04 08:17:15'),
(95,'Aargauische Kantonalbank',NULL,NULL,'CHE-105.845.287',216660,'CH40089260990',1,1,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',16,NULL,NULL,'http://www.akb.ch/','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4008926099&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Kantonalbank',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2019-09-04 13:30:36','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(96,'Zurzach Care AG',NULL,NULL,'CHE-109.380.850',661937,'CH40030230771',1,1,'Bad Zurzach',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'http://www.reha-clinic.ch/cms/','http://www.moneyhouse.ch/u/rehaclinic_ag_CH-400.3.023.077-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'RehaClinic betreibt als Unternehmen einer gemeinnützigen Stiftung an fünf Standorten (Bad Zurzach, Baden, Braunwald, Glarus, Zollikerberg) Rehabilitationskliniken für den stationären und ambulanten Aufenthalt seiner Patientinnen und Patienten sowie an ausgewählten Lagen umfassend ausgestattete ambulante Therapie- und Trainingszentren zur Rehabilitation und Prävention (Lenzburg, Wil, Winterthur, Zug, Zürich Flughafen, Basel).\n\nDie Gesellschaft bezweckt auf gemeinnütziger Basis den Betrieb von Rehabilitationskliniken unter einheitlicher Führung an den Standorten Bad Zurzach und Baden und allfällig weiteren Standorten. Weiter bezweckt die Gesellschaft die Erbringung von Dienstleistungen in allen, die Rehabilitation betreffenden medizinischen und administrativen Bereichen; kann sich an anderen Unternehmungen beteiligen, Zweigniederlassungen und Tochtergesellschaften errichten sowie Grundeigentum erwerben, verwalten und veräussern.',NULL,NULL,'5330',4324,NULL,NULL,NULL,'2022-09-17 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(97,'Stiftung Pro Senectute Aargau',NULL,NULL,'CHE-105.902.471',342668,'CH40070161358',1,1,'Unterentfelden',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.ag.pro-senectute.ch/d/index.cfm?ID=16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Erhaltung oder Verbesserung des Wohles der älteren Menschen im Kanton Aargau; kann auch zum Wohl anderer Bevölkerungsgruppen beitragen, dies auch in Zusammenarbeit mit anderen privaten oder öffentlichen Institutionen.',NULL,NULL,'5035',4013,NULL,NULL,NULL,'2020-03-08 10:50:44','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(98,'Schweizerische Stiftung für Klinische Krebsforschung','Fondation suisse pour la recherche clinique sur le cancer','Fondazione svizzera per la ricerca clinica sul cancro','CHE-110.379.871',280013,'CH02079037247',1,1,'Bern','SSKK',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',4,NULL,NULL,'http://www.klinische-krebsforschung.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die klinische Krebsforschung hat zum Ziel, neue Krebstherapien zu erforschen und bestehende Tumortherapien weiterzuentwickeln, um so die Heilungschancen von krebskranken Patienten und Patientinnen zu verbessern. Während die Pharmaindustrie hauptsächlich in der Erforschung und Entwicklung von neuen Medikamenten tätig ist, widmet sich die Klinische Krebsforschung der Frage, wie die Wirkung einer Krebstherapie mit bereits zugelassenen Medikamenten und anderen Therapieformen verbessert werden kann.',NULL,NULL,'3008',351,NULL,NULL,NULL,'2023-07-10 08:11:08','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(99,'Stiftung OL SCHWEIZ','Fondation CO suisse','Fondazione CO svizzera','CHE-112.346.003',791099,'CH02070012406',1,1,'Schinznach Dorf',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',66,NULL,NULL,'http://www.stiftungolschweiz.ch/index2.html','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001240&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Stiftung ist die nachhaltige gesamtschweizerische Förderung des Orientierungslaufes. Vor allem die Jugend soll motiviert und befähigt werden, in der Natur zu laufen und sich zu orientieren.',NULL,NULL,'5107',4125,NULL,NULL,NULL,'2019-09-04 13:30:36','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(100,'THERAPLUS Stiftung für Therapiebegleitung in Liquidation',NULL,NULL,'CHE-109.536.997',531063,'CH40070216521',1,1,'Fislisbach',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.theraplus.ch/Ueberuns',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Ein wesentliches Ziel ist die Verbesserung der Lebensqualität für Langzeitpatienten und ihre Angehörigen und die Entlastung aller in die Therapie involvierten Personen. THERAPLUS will mit ihrem Beratungsangebot die Lücke in Bezug auf Fragen zur individuellen und alltäglichen Lebenssituation von Langzeitpatienten schliessen, sowie eine höhere Eigenkompetenz und Therapietreue durch patientengerechte Information erzielen.',NULL,NULL,'5442',4027,NULL,NULL,NULL,'2019-09-04 13:30:36','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(101,'Verein Schweizerisches Netzwerk gesundheitsfördernder Spitäler und Dienste',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','nie',5,NULL,NULL,'http://www.healthhospitals.ch/de/hph-mfh-all-in-one/tgkeitsfelder-mainmenu-301.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Netzwerk der WHO, welche die Gesundheitsförderung in den Spitälern vorantreiben soll.\n\nDer Trägerverein "Schweizerisches Netzwerk gesundheitsfördernder Spitäler und Gesundheitsdienste" verpflichtet seine Mitglieder zur Förderung der Gesundheit mittels eines Standards: HPH-Mitglieder achten auf eine hohe Arbeitszufriedenheit ihrer Mitarbeitenden und zeigen den Patienten und Patientinnen und ihren Angehörigen auf, wie sie mit Einschränkungen umgehen und ihre Gesundheit stärken können.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-04 13:30:36','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(102,'Stiftung Brot für alle','Pain Pour Le Prochain',NULL,'CHE-111.788.947',763892,'CH03570333710',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',68,NULL,NULL,'http://www.brotfueralle.ch/en/deutsch/ueber-uns/geschichte/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Kirchliches Hilfswerk der Reformierten Kirchen der Schweiz',NULL,NULL,'3007',351,NULL,NULL,NULL,'2019-07-21 11:43:18','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(103,'Musikkollegium Winterthur',NULL,NULL,'CHE-100.555.675',1201809,'CH02060019223',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',10,NULL,NULL,'http://www.musikkollegium.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Musikkollegium bezweckt die Verbreitung und Pflege der Musik. Die Hauptaufgaben des Musikkollegiums sind: a) durch Veranstaltung von Konzerten alle Schichten der Bevölkerung mit bedeutenden Werken der Tonkunst vertraut zu machen und dafür mit privaten und öffentlichen Mitteln ein Sinfonieorchester unter der Bezeichnung "Musikkollegium Winterthur" zu führen; b) durch das Konservatorium Winterthur die Liebe und Kenntnis der Musik insbesondere bei der Jugend zu fördern.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2017-04-25 18:44:50','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(104,'Schweizer Vogelschutz SVS/BirdLife Schweiz','Association Suisse pour la protection des oiseaux ASPO','BirdLife Svizzera','CHE-106.614.566',NULL,NULL,0,0,'Zürich','SVS',NULL,'ASPO',NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,NULL,NULL,'http://www.birdlife.ch',NULL,'SVS_BirdLife','birdlife.ch','BirdLife_CH','BirdLife.Schweiz/','https://www.linkedin.com/company/birdlife-schweiz-suisse-svizzera',NULL,'Als Dachverband der Natur- und Vogelschutzvereine der Schweiz vereint der SVS/BirdLife Schweiz zwei Landesorganisationen, 19 Kantonalverbände und rund 450 lokale Sektionen. Er hat 63''000 Mitglieder und ist der Schweizer Partner von BirdLife International mit 2.5 Mio. Mitgliedern.\n\nDer SVS ist die schweizerische Naturschutzorganisation mit den Schwerpunkten Naturschutz in der Gemeinde, Schutz der Vögel und ihrer Lebensräume sowie internationale Zusammenarbeit im Naturschutz.','En tant qu''organisation faîtière des associations de protection de la nature et des oiseaux en Suisse, la SVS/BirdLife Suisse regroupe deux organisations nationales, 19 associations cantonales et environ 450 sections locales. Elle compte 63''000 membres et est le partenaire suisse de BirdLife International qui compte 2,5 millions de membres.\n\nLa SVS est l''organisation suisse de protection de la nature qui se concentre sur la conservation de la nature au sein de la communauté, la protection des oiseaux et de leurs habitats et la coopération internationale en matière de conservation de la nature.',NULL,'8045',261,NULL,NULL,NULL,'2025-10-28 08:44:33','2013-11-10 14:18:51','2025-10-28 08:44:33'),
(105,'Pro Infirmis, Zweigniederlassung Kanton Thurgau und Schaffhausen',NULL,NULL,'CHE-395.556.421',974450,'CH44090229700',1,1,'Frauenfeld',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0151',9,'MitgliedsOrganisation,LeistungsErbringer','nie',15,NULL,NULL,'http://www.proinfirmis.ch/de/pro-infirmis/organisation.html','http://tg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4409022970&amt=440&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Sektion Pro Infirmis Schweiz. ist die grösste Fachorganisation für behinderte Menschen in der Schweiz.',NULL,NULL,'8501',4566,NULL,NULL,NULL,'2023-08-28 14:49:30','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(106,'Retraites Populaires',NULL,NULL,'CHE-108.954.441',228849,'CH55000516454',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','punktuell',42,NULL,NULL,'https://www.retraitespopulaires.ch/','http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-0051645-4&ofrcLanguage=1','RetraitesPop','retraitespopulaires','RetraitesPopulaires','retraitespopulaires','https://www.linkedin.com/company/retraites-populaires/',NULL,'Die Retraites Populaires mit Sitz in Lausanne ist ein Schweizer Vorsorge- und Versicherungsunternehmen. Ihre Kernaktivität umfasst zum einen Vorsorge- und Versicherungslösungen im Rahmen der 2. und der 3. Säule. Zum anderen ist Retraites Populaires auf die Verwaltung von staatlichen und privaten Pensionskassen und Versicherungseinrichtungen im Kanton Waadt spezialisiert und übernimmt unter anderem die ihr delegierte operative Führung der kantonalen Pensionskasse Caisse de pensions de l''État de Vaud (CPEV) und der interkommunalen Pensionskasse Caisse intercommunale de pensions (CIP).','Retraites Populaires, basée à Lausanne, est une société suisse de retraite et d''assurance. Son activité principale comprend, d''une part, les solutions de prévoyance et d''assurance dans le cadre des 2e et 3e piliers. D''autre part, Retraites Populaires est spécialisée dans l''administration des caisses de pension et des institutions d''assurance publiques et privées du canton de Vaud et assume, entre autres, la gestion opérationnelle de la caisse de pension cantonale Caisse de pensions de l''État de Vaud. (CPEV) et la Caisse intercommunale de retraite de la Caisse intercommunale de retraites (CIP).',NULL,'1003',5586,'https://de.wikipedia.org/wiki/Retraites_Populaires','Q2146250',NULL,'2025-06-18 17:26:02','2013-11-10 14:18:51','2025-06-18 17:26:02'),
(107,'Caisse de pensions ECA-RP',NULL,NULL,'CHE-109.781.798',289438,'CH55001667622',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,'http://www.moneyhouse.ch/u/caisse_de_pensions_eca_rp_CH-550.0.166.762-2.htm','http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-0166762-2&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'prévoyance professionnelle en faveur des membres du personnel des Retraites Populaires et de l''Etablissement cantonal d''assurance contre l''incendie et les éléments naturels du canton de Vaud dans le cadre de la LPP et de ses dispositions d''exécution; prémunir ces personnes, ainsi que leurs proches et survivants, contre les conséquences économiques de la vieillesse, du décès et de l''invalidité.',NULL,NULL,'1003',5586,NULL,NULL,NULL,'2017-07-03 08:44:20','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(108,'Fondation Mont-Calme',NULL,NULL,'CHE-108.112.471',283109,'CH55001119624',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',79,NULL,NULL,'http://www.montcalme.ch/xml_1/internet/fr/application/d3/f36.cfm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alters- und Pflegeheim',NULL,NULL,'1005',5586,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(110,'ACS Sektion Waadt','ACS section vaud',NULL,NULL,NULL,NULL,0,0,'Savigny',NULL,'Automobil Club der Schweiz',NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',26,NULL,NULL,'http://www.acs.ch/ch-fr/sektionen/vaudoise/index.asp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Automobilclub der Schweiz, Sektion VD',NULL,NULL,'1073',NULL,NULL,NULL,NULL,'2022-09-13 00:00:00','2013-11-10 14:18:51','2022-09-13 16:41:51'),
(111,'Etablissement d''assurance contre l''incendie et les éléments naturels du Canton de Vaud (ECA)',NULL,NULL,'CHE-108.955.251',1165907,'CH55011317492',1,1,'Lausanne','ECA',NULL,NULL,NULL,NULL,NULL,191,2,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'http://www.eca-vaud.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Elementarschadenversicherung Kt. VD',NULL,NULL,'1018',5586,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(112,'Société coopérative de laiterie et d''agriculture de Bursins-Vinzel, en liquidation',NULL,NULL,'CHE-102.399.854',254638,'CH55001462226',1,1,'Bursins',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','nie',39,NULL,NULL,NULL,'http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-0146222-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Sauvegarde des intérêts professionnels de ses membres; mise en valeur de leur production laitière; achat ou location et mise à disposition de ses membres de matériel d''équipement et de toute fourniture agricole.',NULL,NULL,'1183',5853,NULL,NULL,NULL,'2016-09-06 14:44:30','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(113,'fenaco Genossenschaft','fenaco, fédération de coopératives agricoles',NULL,'CHE-106.106.123',328631,'CH03550005600',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',96,NULL,NULL,'http://www.fenaco.com/deu/default.shtml',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die fenaco versorgt die Landwirte mit Produktionsmitteln, übernimmt deren Erzeugnisse, veredelt diese und vermarktet sie. Zudem betreibt die fenaco die Detailhandelsketten Volg und LANDI und verkauft AGROLA Brenn- und Treibstoffe.','fenaco est une entreprise organisée sous forme de coopérative. Elle est issue de la fusion, en 1993, de six fédérations de coopératives agricoles, dont la tradition est plus que centenaire. L''objectif principal de fenaco consiste à soutenir les agriculteurs dans le développement économique de leurs entreprises. ',NULL,'3012',351,NULL,NULL,NULL,'2025-06-17 11:30:30','2013-11-10 14:18:51','2025-06-17 11:30:30'),
(114,'Association Relève PME',NULL,NULL,'CHE-114.651.144',NULL,NULL,0,0,'Paudex','PME',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer','nie',59,NULL,NULL,'http://www.relevepme.ch/run?iset=1077&refpage=54071',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Relève PME est une association à but non lucratif, dont les membres sont des entrepreneurs, des chefs d''entreprises et des cadres intéressés par la transmission d''entreprise. Indépendante et neutre, elle veut accompagner le changement de génération dans les PME et contribuer ainsi à la vitalité économique de notre pays.\n\nRelève PME vous offre des conseils, des informations et un soutien neutre pour réaliser une succession d''entreprise. Grâce à son réseau, les chefs d''entreprises et les cadres concernés par la transmission, la succession, la vente ou l''achat, maximiseront leurs chances de succès.',NULL,NULL,'1094',5586,NULL,NULL,NULL,'2021-09-28 15:33:14','2013-11-10 14:18:51','2024-08-16 05:08:46'),
(115,'Centre Patronal',NULL,NULL,'CHE-253.458.835',1124430,'CH03690558975',1,1,'Bern',NULL,'Centre Patronal Deutschschweiz',NULL,NULL,NULL,NULL,191,1,'Verein','0151',9,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,NULL,NULL,'https://www.centrepatronal.ch/de/home/',NULL,'BernCentre',NULL,NULL,NULL,'https://www.linkedin.com/company/centrepatronalbern/',NULL,'Der Arbeitgeberverband Centre Patronal ist als spezialisierter Dienstleister in den Bereichen Rechtsberatung, Verbandsmanagement, Politikberatung und Weiterbildung tätig. Zur Politik und Verwaltung wird ein vertrauensvoller und dynamischer Kontakt gepflegt. Centre Patronal vertritt als gesamtschweizerische Organisation die politischen Interessen der Privatwirtschaft.','Le Centre Patronal est un prestataire de services spécialisé dans les domaines du conseil juridique, de la gestion d''associations, du conseil politique et de la formation continue. Il entretient des contacts dynamiques et de confiance avec le monde politique et l''administration. En tant qu''organisation nationale, le Centre Patronal défend les intérêts politiques de l''économie privée.',NULL,'3011',351,NULL,NULL,NULL,'2025-02-13 00:00:00','2013-11-10 14:18:51','2025-02-14 17:29:11'),
(116,'Centre Patronal Paudex',NULL,NULL,'CHE-113.961.599',NULL,NULL,0,0,'Paudex',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.centrepatronal.ch/index.php?page=fr/organisation/Fpv',NULL,'CentrePatronal','centre_patronal',NULL,'centrepatronal/','https://www.linkedin.com/company/centre-patronal/',NULL,'Das Centre Patronal ist eine Wirtschaftsorganisation im Dienst der Unternehmung. Nebst der Führung des Sekretariats des Waadtländischen Arbeitgeberverbandes (Fédération patronale vaudoise) betreut es über 150 Berufsverbände- und organisationen. Ungefähr 200 Mitarbeiterinnen und Mitarbeiter nehmen die gleichen Aufgaben wahr wie das Centre Patronal in Bern, nämlich Politik, Information und Beratung, Verbandsmanagement und die Berufsbildung. Verschiedene Publikationen in französischer Sprache runden das Angebot ab.','La Fédération patronale vaudoise (FPV) est la plus importante organisation faîtière du canton. Avec plus de 22''000 membres individuels et environ 120 associations affiliées, elle réunit la plupart des entreprises et des groupements professionnels vaudois. Le Centre Patronal assure le secrétariat de la FPV.',NULL,'1094',NULL,NULL,NULL,NULL,'2023-03-16 15:20:01','2013-11-10 14:18:51','2024-03-18 20:24:21'),
(117,'Interkantonaler Rückversicherungsverband','Union intercantonale de réassurance',NULL,'CHE-108.922.889',90776,'CH03580181551',1,1,'Bern','IRV',NULL,'UIR',NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'http://www.irv.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0358018155&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der Interkantonale Rückversicherungsverband (IRV) bietet Rückversicherungsleistungen in den Bereichen Feuer- und Elementarschäden an. Als interkantonale, öffentlich-rechtliche Körperschaft ist der IRV nicht gewinnorientiert und ausschliesslich für die Kantonalen Gebäudeversicherungen (KGV) in der Schweiz tätig.','L''Union intercantonale de réassurance (UIR) propose des prestations de réassurance dans les domaines de l''incendie et des dommages naturels. En tant que corporation intercantonale de droit public, l''UIR n''a pas de but lucratif et travaille exclusivement pour les établissements cantonaux d''assurance (ECA) en Suisse.',NULL,'3011',351,'https://de.wikipedia.org/wiki/Interkantonaler_R%C3%BCckversicherungsverband','Q15820264',NULL,'2023-11-28 16:44:16','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(118,'Raiffeisenbank Menzingen-Neuheim, Menzingen',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',16,NULL,NULL,'http://www.raiffeisen.ch/raiffeisen/internet/rb0027.nsf/sitzcode/1457/?OpenDocument','Raiffeisenbank Menzingen-Neuheim Genossenschaft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-07-21 15:20:56','2013-11-10 14:18:51','2023-07-21 15:20:56'),
(119,'Ausgleichskasse Verom',NULL,NULL,'CHE-109.777.704',NULL,NULL,0,1,'Schlieren',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer','nie',56,NULL,NULL,'https://www.verom.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Ausgleichskasse für Pensionen, AHV etc.',NULL,NULL,'8952',247,NULL,NULL,NULL,'2019-07-27 21:03:43','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(121,'Internetplattform Swissmip',NULL,NULL,NULL,NULL,NULL,0,0,'Koppigen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',84,NULL,NULL,'http://www.szg.ch/ueber-uns/organisation/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Tätigkeiten der SZG bezwecken im Bereich der Spezialkulturen (Gemüse, Obst, Schnittblumen etc.) inkl. Kartoffeln, die Förderung einer leistungsfähigen Produktion, die Förderung einer effizienten Marktausrichtung sowie die Unterstützung der Marktregelung.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(122,'alps - Alpines Museum der Schweiz',NULL,NULL,'CHE-107.817.066',292852,'CH03570167123',1,1,'Bern',NULL,'Alpines Museum der Schweiz',NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',44,NULL,NULL,'http://www.alpinesmuseum.ch/de','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357016712&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck\nÜbernahme des bestehenden Schweiz. Alpinen Museums der Sektion Bern des S.A.C; Erstellung eines zweckmässigen Neubaues im Rahmen der dafür verfügbaren Mittel usw.	\n\nStiftungsträger\nSchweizerische Eidgenossenschaft\nKanton Bern\nStadt Bern\nSchweizer Alpen-Club\nSektion Bern des Schweizer Alpen-Club',NULL,NULL,'3005',351,NULL,NULL,NULL,'2023-07-08 23:50:28','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(123,'Schweizerisches Arbeiterhilfswerk SAH Wallis','Oeuvre suisse d''entraide ouvrière (OSEO) Valais',NULL,NULL,NULL,NULL,0,0,'Sion',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',12,NULL,NULL,'http://www.oseo-vs.ch/oseo-buts.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Schweizerische Arbeiterhilfswerk SAH besteht aus zehn Regionalvereinen. Sie führen in 13 Kantonen und 29 Städten der Schweiz rund 130 Programme für Erwerbslose und MigrantInnen durch. Durch praktische Massnahmen und politische Stellungnhmen steht das SAH-Netzwerk für die Anliegen benachteiligter Menschen in der Schweiz ein.',NULL,NULL,'1950',NULL,NULL,NULL,NULL,'2020-11-30 14:47:43','2013-11-10 14:18:51','2020-11-30 14:47:43'),
(124,'Pro Mente Sana Suisse romande',NULL,NULL,NULL,NULL,NULL,0,0,'Genève',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.promentesana.org/wq_pages/fr/association/principes-directeurs.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Pro Mente Sana soutient la cause des personnes qui souffrent d''une maladie ou d''un handicap psychique. Elle lutte pour leur intégration professionnelle et sociale et pour la garantie de leurs droits. Pro Mente Sana conseille, diffuse des informations variées et offre un espace qui permet le dialogue entre personnes concernées, proches et professionnels. Elle vise à promouvoir, dans l''opinion publique, une meilleure compréhension à l''égard des personnes souffrant d''une maladie psychique. Elle est active au niveau national et cantonal. Elle est neutre sur le plan politique et religieux.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-26 09:10:31','2013-11-10 14:18:51','2023-08-26 09:10:34'),
(125,'Universitätsspital Basel',NULL,NULL,'CHE-115.173.213',1122261,'CH27080000285',1,1,'Basel Universitätsspital',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',5,NULL,NULL,'http://www.unispital-basel.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Trägt dazu bei, eine wirksame, zweckmässige und wirtschaftliche Spitalversorgung zu gewährleisten. Dient der kantonalen, regionalen und überregionalen medizinischen Versorgung im Rahmen der Leistungsaufträge gemäss dem Bundesgesetz vom 18. März 1994 über die Krankenversicherung (KVG). Trägt im Rahmen von Leistungsvereinbarungen mit Hochschulen zur Forschung und Lehre bei. Erbringt bedarfsgerecht gemeinwirtschaftliche Leistungen. Kann weitere Leistungen erbringen, soweit dadurch die Erfüllung der staatlichen Leistungsaufträge nicht beeinträchtigt wird. Kann Kooperationen eingehen, Unternehmen gründen oder sich an Unternehmen beteiligen.',NULL,NULL,'4031',2701,NULL,NULL,NULL,'2018-03-21 09:14:37','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(126,'Schweizerische Pfadistiftung','Fondation Suisse du Scoutisme','Fondazione Svizzera dello Scautismo','CHE-101.789.796',334124,'CH27070013614',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',102,NULL,NULL,'http://www.scout.ch/de/3/pfadistiftung/stiftungsrat','http://www.moneyhouse.ch/u/schweizerische_pfadistiftung_CH-270.7.001.361-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung der Ziele und Werte des Pfadfindergedankens in der Schweiz im Interesse der Oeffentlichkeit und Unterstützung der Tätigkeit der Pfadfinder und Pfadfinderinnen sowie deren schweizerischen Organisationen, insbesondere Ausbildung der Führer und Füh',NULL,NULL,'4010',2701,NULL,NULL,NULL,'2025-06-23 07:07:59','2013-11-10 14:18:51','2025-06-23 07:07:59'),
(127,'Compasso - Berufliche Eingliederung - Informationsportal für Arbeitgeber',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.compasso.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Compasso fokussiert seine Informationstätigkeit für Arbeitgeber auf den Umgang mit Personen mit einer gesundheitlichen Beeinträchtigung, die entweder mit (Früherkennung & Integration) oder ohne Anstellung (Berufliche Re-Integration) sind. Mit praxiserprobten Tools, Schritt-für-Schritt-Anleitungen und konkreten Praxisbeispielen erhalten die Arbeitgeber durch das Informationsportal www.compasso.ch Unterstützung.\n\nDer Verein Compasso ist breit abgestützt und steht unter dem Patronat des Schweizerischen Arbeitgeberverbandes.','L''activité de Compasso au service des employeurs cible les personnes atteintes dans leur santé ayant un emploi (détection précoce et intégration) ou sans emploi (réintégration professionnelle). Le portail d''information www.compasso.ch. assiste les employeurs à l''aide d''outils qui ont fait leurs preuves, d''instructions pas à pas et de cas-types concrets.\n\nL''association Compasso repose sur une large assise. Elle est placée sous le patronage de l''Union patronale suisse.',NULL,'8021',NULL,NULL,NULL,NULL,'2023-11-02 16:48:05','2013-11-10 14:18:51','2023-11-02 16:48:05'),
(128,'IAMANEH Schweiz Suisse Svizzera Switzerland',NULL,NULL,'CHE-112.011.005',1036735,'CH27060006716',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',68,NULL,NULL,'http://www.iamaneh.ch/','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2706000671&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'IAMANEH Schweiz ist eine Entwicklungsorganisation, die sich für die Verbesserung, die Förderung und den Schutz der Gesundheit einsetzt.\n\nWir unterstützen Projekte in Westafrika, im Westbalkan und in Haiti.\n\nZielgruppe sind Frauen und Kinder, die wir dabei unterstützen, ihre Zukunft und Entwicklung eigenständig zu gestalten.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(129,'GELIKO Schweizerische Gesundheitsligen-Konferenz','GELIKO Conférence nationale suisse des ligues de la santé','GELIKO Conferenza nazionale svizzera delle leghe per la salute',NULL,NULL,NULL,0,0,'Zürich',NULL,'Geliko - Schweizerische Gesundheitsligen-Konferenz',NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.geliko.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Gesundheitsligen-Konferenz (GELIKO) vertritt die Interessen von Men­schen mit chronischen Krankheiten in der Gesundheits- und Sozialpolitik und kämpft gegen negative gesundheitliche, finanzielle und soziale Folgen von chronischen Krankheiten (Krebs, Rheuma, Diabetes, Lungenkrankheiten, Cystische Fibrose, Herz-Kreislauf-Leiden, HIV/Aids, Allergien etc.). Sie ist der Dachverband der gesamtschweizerisch tätigen gemeinnützigen Organisationen, die sich im Gesundheits- und Sozialwesen für die Prävention spezifischer Krankheiten einsetzen, Betroffene unterstützen oder sich allgemein für Krankheitsprävention und Gesundheitsförderung stark machen.','La Conférence nationale suisse des ligues de la santé (GELIKO) défend les intérêts des personnes atteintes de maladies chroniques dans la politique de la santé et la politique sociale et lutte contre les conséquences négatives des maladies chroniques sur la santé, les finances et la société (cancer, rhumatisme, diabète, maladies pulmonaires, mucoviscidose, maladies cardio-vasculaires, VIH/sida, allergies, etc.) Elle est l''organisation faîtière des organisations d''utilité publique actives dans toute la Suisse qui s''engagent dans le domaine de la santé et du social pour la prévention de maladies spécifiques, soutiennent les personnes concernées ou s''engagent de manière générale pour la prévention des maladies et la promotion de la santé.',NULL,'8005',NULL,NULL,NULL,NULL,'2025-07-01 12:59:42','2013-11-10 14:18:51','2025-07-01 12:59:42'),
(130,'Schweizerischer Verband des Personals öffentlicher Dienste (V.P.O.D.)','Syndicat suisse des services publics','Sindacato svizzero dei servizi pubblici','CHE-105.834.303',166333,'CH02069004269',1,1,'Zürich','VPOD',NULL,'SSP',NULL,'SSP',NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',53,NULL,NULL,'http://www.vpod.ch/','http://www.moneyhouse.ch/u/schweizerischer_verband_des_personals_offentlicher_dienste_%28v_p_o_d_%29_CH-020.6.900.426-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Das im öffentlichen Dienst tätige Personal im Sinne seines Arbeitsprogrammes in beruflicher, wirtschaftlicher, sozialer, politischer und kul-tureller Hinsicht zu schützen und zu fördern, insbesondere durch gewerkschaftliche Organisation des im öffentlichen Dienst tätigen Personals, Vertretung der Interessen der Mitglieder gegenüber den Arbeitgebern und der Oeffentlichkeit, gewerkschaftliche und allgemeine Aus- und Fortbildung seiner Mitglieder, Herausgabe von gewerkschaftlichen Publikationen, Gewährung von Rechtsschutz an seine Mitglieder, Schaffung und Förderung gemeinnütziger Einrichtungen und Unterstützung von in Not geratenen Mitgliedern und deren Familien und Pflege der Solidarität und kollegialer Beziehungen unter Gewerkschaftern.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2025-09-08 20:23:28','2013-11-10 14:18:51','2025-09-08 20:23:28'),
(131,'WWF Region Basel',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',54,131,NULL,'http://www.wwf-bs.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der WWF Region Basel wurde 1974 gegründet. Als eigenständiger Verein und als Sektion des WWF Schweiz für die Kantone Basel-Stadt und Basel-Landschaft ist er Teil des globalen WWF-Netzwerks.\nAus der Erkenntnis, dass für die Umwelt oft mehr auf kantonaler als auf eidgenössischer Ebene erreicht werden kann und die Zuständigkeit für die teilweise schleppende Umsetzung nationaler Umweltgesetze bei den Kantonen liegt, wurde die WWF Sektion Region Basel gegründet.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(132,'RadioZürisee AG',NULL,NULL,NULL,NULL,NULL,0,0,'Stäfa',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'AG',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',49,NULL,NULL,'http://www.zsm.ch/','http://zefix.ch/info/ger/zh020.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Lokalradio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-19 13:23:19','2013-11-10 14:18:51','2017-07-19 13:23:19'),
(133,'TopPharm Apotheke Paradeplatz AG',NULL,NULL,'CHE-115.765.508',984885,'CH02030353149',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,3,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',1,NULL,NULL,'http://www.paradeplatz.apotheke.ch/ueber.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Apotheke',NULL,NULL,'8001',261,NULL,NULL,NULL,'2017-07-19 13:23:19','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(134,'Schweizerische Greina-Stiftung (SGS) zur Erhaltung der alpinen Fliessgewässer','Fondation Suisse de la Greina (FSG) pour la protection des fleuves alpins','Fondazione Svizzera della Greina (FSG) per la protezione dei corsi d''acqua alpini','CHE-106.286.516',165974,'CH02079036587',1,1,'Zürich','SGS',NULL,'FSG',NULL,'FSG',NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,dezidierteLobby','punktuell',54,NULL,NULL,'http://www.greina-stiftung.ch/','http://www.moneyhouse.ch/en/u/schweizerische_greina_stiftung_(sgs)_zur_erhaltung_der_alpinen_fliessgewasser_CH-020.7.903.658-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Greina-Stiftung hat zum Ziel, sich für die nachhaltige Gestaltung und Aufwertung alpiner Fliessgewässer und Flusslandschaften einzusetzen und dabei insbesondere einer ökologischen Energienutzung ihre besondere Aufmerksamkeit zu schenken. Dieses Oberziel umfasst allgemein und zum Teil auch umfassend die Richtung.',NULL,NULL,'8006',261,NULL,NULL,NULL,'2025-09-02 11:09:30','2013-11-10 14:18:51','2025-09-02 11:09:30'),
(135,'Schweizerische Sportmittelschule Engelberg AG',NULL,NULL,'CHE-419.692.212',1147346,'CH14030044966',1,1,'Engelberg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',65,41,NULL,'http://www.sportmittelschule.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Nationales Leistungszentrum für den alpinen Skisport',NULL,NULL,'6390',1402,NULL,NULL,NULL,'2025-07-21 18:08:15','2013-11-10 14:18:51','2025-07-21 18:08:15'),
(136,'Gewerbeverband der Stadt Zürich',NULL,NULL,'CHE-105.833.203',235327,'CH02069001778',1,1,'Zürich','GVZ',NULL,NULL,NULL,NULL,NULL,191,3,'Verein','0109',6,'MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'http://www.gewerbezuerich.ch/web/mitgliedschaft/index.php',NULL,NULL,NULL,NULL,'profile.php?id=100064441249707',NULL,NULL,'Der Gewerbeverband der Stadt Zürich setzt sich ein für eine "wirtschaftsorientierte Standortpolitik" ein. Er vertritt die Interessen und Anliegen seiner Mitglieder in der Stadt Zürich und soll meinungsbildend beim Kanton und beim Bund wirken.','L''association professionnelle de la ville de Zurich s''engage en faveur d''une " politique de localisation à vocation économique ". Elle représente les intérêts et les préoccupations de ses membres dans la ville de Zurich et a pour objectif de façonner l''opinion au sein du canton et de la Confédération.',NULL,'8050',261,NULL,NULL,NULL,'2025-07-02 13:06:47','2013-11-10 14:18:51','2025-07-02 13:06:47'),
(137,'Pro Natura Basel',NULL,NULL,'CHE-317.269.598',NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer','punktuell',54,NULL,NULL,'http://www.pronatura-bs.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2701,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(138,'Swiss Police ICT',NULL,NULL,'CHE-202.308.125',NULL,NULL,0,0,'Bern','ICT',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,dezidierteLobby','punktuell',105,78,NULL,'http://www.spik.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Kern der Vereinsarbeit ist die jährliche Organisation des Schweizer Polizei Informatik\nKongress'' SPIK.\n\nSPIK ist die nationale Plattform für den Erfahrungsaustausch zu den Themen Polizeiinformatik und Bekämpfung von Cybercrime.\n\nSPIK richtet sich an Informatiker und Führungskräfte aller Polizeikorps ebenso wie an die IT-Industrie, die Wirtschaft und die Politik. Ziel des jährlich stattfindenden Kongresses ist es, die Involvierten mit neuen Ideen, Entwicklungen und Produkten vertraut zu machen.\n\nHinter dem Anlass steht der Verein Swiss Police ICT, dem Vertreter verschiedener Polizeikorps und Informatikfirmen angehören.\nEin politischer Beirat mit Vertretern der fünf Bundesratsparteien, einem Regierungsrat und einem Polizeikommandanten dient als politisches Konsultativ-Organ und Bindeglied zur Politik.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2020-11-23 08:18:52','2013-11-10 14:18:51','2024-05-10 05:10:00'),
(139,'Schweizerisches Rotes Kreuz Kanton Zürich',NULL,NULL,'CHE-106.832.198',385763,'CH02060002978',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',25,NULL,NULL,'http://www.srk-zuerich.ch','http://www.moneyhouse.ch/u/schweizerisches_rotes_kreuz_kanton_zurich_CH-020.6.000.297-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Das SRK Kanton Zürich ist einer der 24 Kantonalverbände des Schweizerischen Roten Kreuzes (SRK), der nationalen Rotkreuzgesellschaft. Das SRK wiederum ist Teil der weltweiten Rotkreuz- und Rothalbmondbewegung. Leitgedanke dieser Bewegung ist es, Menschen in Not zu helfen.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2017-07-19 13:23:19','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(140,'swisscleantech',NULL,NULL,'CHE-114.533.154',923595,'CH02060012281',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',50,NULL,NULL,'http://www.swisscleantech.ch',NULL,'swisscleantechD',NULL,'swisscleantech','swisscleantech/','https://www.linkedin.com/company/swisscleantech/',NULL,'Der Wirtschaftsverband swisscleantech steht für eine nachhaltige und liberale Wirtschaftspolitik. Er ist die Stimme jener Unternehmen und Verbände, die der nachhaltigen Entwicklung von Wirtschaft, Umwelt und Gesellschaft auf nationaler und internationaler Ebene eine Schlüsselrolle beimessen. Der Wirtschaftsverband swisscleantech versteht Cleantech als branchenübergreifendes Qualitätsmerkmal für ressourceneffizientes und emissionsarmes Wirtschaften.','L''association économique swisscleantech défend une politique économique durable et libérale. Elle est la voix des entreprises et des associations qui accordent un rôle clé au développement durable de l''économie, de l''environnement et de la société au niveau national et international. L''association économique swisscleantech considère Cleantech comme un label de qualité intersectoriel pour une économie efficace dans l''utilisation des ressources et pauvre en émissions.',NULL,'8005',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2013-11-10 14:18:51','2025-02-13 09:16:34'),
(141,'Frauenzentrale Zürich',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',67,NULL,NULL,'http://www.frauenzentrale.ch/zuerich/cms/front_content.php?idart=2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Zürcher Frauenzentrale ist ein gemeinnütziger, steuerbefreiter Verein und ein bedeutender Dachverband im Kanton Zürich, dem 140 Kollektivmitglieder und 1''050 Einzelmitglieder angeschlossen sind. Die Frauenzentrale ist parteipolitisch unabhängig und konfessionell neutral.',NULL,NULL,'8002',NULL,NULL,NULL,NULL,'2025-06-21 13:48:18','2013-11-10 14:18:51','2025-06-21 13:48:18'),
(142,'Fritz Heid AG, Thürnen',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',19,NULL,NULL,'http://www.monetas.ch/htm/647/de/Firmendaten-Fritz-Heid-AG.htm?subj=1172899',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Verwaltung von und Handel mit Immobilien sowie Handel mit Waren aller Art. Die Gesellschaft kann Planungs- und General- unternehmertätigkeiten ausüben, sich an anderen Unternehmungen beteiligen sowie Grundstücke, Patente und Lizenzen erwerben und veräussern.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-03-07 11:01:49','2013-11-10 14:18:51','2020-03-07 11:01:50'),
(143,'Kistenfabrik und Holzhandels AG',NULL,NULL,'CHE-102.274.081',99121,'CH28039102094',1,1,'Thürnen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',52,NULL,NULL,NULL,'http://bl.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2803910209&amt=280&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Fabrikation von Kisten und Harassen aller Art, speziell Lager-, Transport-, Export- und Werkstattkisten, Fabrikation von Holzwolle, Handel in Holz aller Art. Die Gesellschaft kann ihre Tätigkeit auf verwandte Branchen ausdehnen oder sich an ähnlichen Unternehmen beteiligen sowie Liegenschaften kaufen, verkaufen und verwalten.',NULL,NULL,'4441',2864,NULL,NULL,NULL,'2025-06-21 13:23:38','2013-11-10 14:18:51','2025-06-21 13:23:38'),
(144,'Treff 44 AG in Liquidation',NULL,NULL,'CHE-108.759.187',151645,'CH28039172924',1,1,'Thürnen',NULL,NULL,NULL,NULL,NULL,NULL,191,3,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',60,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/treff_44_ag_CH-280.3.917.292-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb einer Gastwirtschaft und Hotelerie. Die Gesellschaft kann ihre Tätigkeit auf verwandte Branchen ausdehnen oder sich an ähnlichen Unternehmen beteiligen sowie Liegenschaften kaufen, verkaufen und verwalten.',NULL,NULL,'4441',2864,NULL,NULL,NULL,'2025-06-21 13:23:38','2013-11-10 14:18:51','2025-06-21 13:23:38'),
(145,'Gewerbeverein Sissach und Umgebung',NULL,NULL,NULL,NULL,NULL,0,0,'Sissach',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation','nie',59,NULL,NULL,'http://www.gesi.ch/ueberuns/index.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Heute zählt unser Verein rund 200 Aktivmitglieder.\nWir nehmen nach wie vor die Interessen unserer Mitglieder war. Sei es in der Gemeinde oder in der Wirtschaftskammer Baselland. Daneben kommt aber auch das Gesellige nicht zu kurz. Wir präsentieren unsere Leistungsfähigkeit an unseren Gewerbeausstellungen.\nDie letzte fand im Mai 2010 statt und war ein grosser Erfolg.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-21 13:23:38','2013-11-10 14:18:51','2025-06-21 13:23:38'),
(146,'Hauseigentümerverband Sissach/Läufelfingen',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',19,NULL,NULL,'http://www.hev-sissach.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hauseigentümer-Verband Regional',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-21 13:23:38','2013-11-10 14:18:51','2025-06-21 13:23:38'),
(147,'Liga der Baselbieter Steuerzahler',NULL,NULL,'CHE-104.124.713',NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'EinzelOrganisation,dezidierteLobby','nie',99,NULL,NULL,'http://www.steuerzahler-bl.ch/ziele.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Gegen erhöhte Staatsquoten, gegen Bürokratie, gegen Abgaben',NULL,NULL,NULL,2774,NULL,NULL,NULL,'2025-06-21 13:23:38','2013-11-10 14:18:51','2025-06-21 13:23:38'),
(148,'KGIV der Wirtschaftskammer Basel-Landschaft',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Informelle Gruppe',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'http://www.kmu.org/KGIV.1272.0.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die "Konferenz der Gewerbe- und Industrievereine" ist eine ständige Fachkommission der Wirtschaftskammer Baselland. In der Fachkommission sind alle lokalen und regionalen KMU-Organisationen im Kanton Baselland, die der Wirtschaftskammer als Sektion angeschlossenen sind, vertreten.',NULL,NULL,'4410',NULL,NULL,NULL,NULL,'2016-06-24 17:37:02','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(149,'Wirtschaftsrat der Wirtschaftskammer Basel-Landschaft',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Informelle Gruppe',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Wirtschaftsrat Baselland ist das Parlament der Baselbieter KMU-Wirtschaft. Er nimmt Stellung zu wirtschafts- und KMU-politisch relevanten Sachfragen, beschliesst Abstimmungsparolen und gibt Wahlempfehlungen ab.',NULL,NULL,'4410',NULL,NULL,NULL,NULL,'2020-03-07 11:01:49','2013-11-10 14:18:51','2020-03-07 11:01:50'),
(150,'LifeWatch GmbH',NULL,NULL,'CHE-109.281.219',628687,'CH29030139064',1,1,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',9,NULL,NULL,'lifewatch.com','http://sh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2903013906&amt=290&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Halten von Beteiligungen an Gesellschaften, welche im Bereich der Forschung, Entwicklung, Herstellung, Verkauf und Vertrieb von Geräten in den Gebieten Elektronik, Computer und Engineering, insbesondere der Medizinalausrüstung, sowie der Erbringung von Dienstleistungen in diesen Gebieten tätig sind, einschliesslich der Telemedizin.',NULL,NULL,'6300',1711,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(151,'tracker.ch AG',NULL,NULL,'CHE-115.626.048',979351,'CH02030350831',1,1,'Adliswil',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',78,NULL,NULL,'http://www.tracker.com/chde/ueber-uns.aspx','http://zh.powernet.ch/webservices/net/HRG/HRG.asmx/getHRGHTML?chnr=CH-020.3.035.083-1&amt=020&toBeModified=0&validOnly=0&lang=1&sort=',NULL,NULL,NULL,NULL,NULL,NULL,'entwickelt und vertreibt innovative weltweit funktionierende Internet Ortungs-Lösungen mittels GPS- und GPRS-Technologie. Die von Tracker.com entwickelten Lösungen sind für zahlreiche Anwendungen geeignet und zeichnen sich durch eine intuitive und kinderleichte Bedienung aus. Die Hauptanwendungsbereiche von Tracker.com-Lösungen sind Logistik und Sport, die Ortung von Gegenständen und Objekte sowie die Lokalisierung von Menschen und Tiere.',NULL,NULL,'8134',131,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(152,'Young Kickers Foundation',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation','nie',66,NULL,NULL,'https://www.symphasis.ch/foerderbereiche/kultur-sport/damit-die-schweizer-jugend-am-ball-bleibt.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Sposoren-Gremium für jungs Fussballtalente der Stiftung Symphasis',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-20 21:49:39','2013-11-10 14:18:51','2017-07-20 21:49:39'),
(153,'Sportmuseum Schweiz in Liquidation',NULL,NULL,'CHE-105.922.798',293492,'CH27070013675',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation','nie',89,NULL,NULL,'www.sportmuseum.ch','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2707001367&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Systematisches Sammeln und Vermitteln im Bereich der Sportkultur.',NULL,NULL,'4001',2701,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(154,'FH SCHWEIZ, Dachverband Absolventinnen und Absolventen Fachhochschulen',NULL,NULL,'CHE-112.244.199',1182386,'CH02060018526',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',41,NULL,NULL,'http://www.fhschweiz.ch/content-n82-sD.html',NULL,'FH_SCHWEIZ',NULL,NULL,NULL,NULL,NULL,'FH SCHWEIZ\nist Themenführer für die FH-Anliegen und nimmt massgeblich Einfluss auf die schweizerische Bildungspolitik,\nsetzt sich ein für ein starkes duales Bildungssystem und für eine starke nationale Marke "Fachhochschule" bzw. "FH" in der Grundausbildung, Weiter- und Fortbildung und\nschafft attraktive Bedingungen für die Entwicklung der angeschlossenen Mitgliedorganisationen.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2025-09-10 17:38:08','2013-11-10 14:18:51','2025-09-10 17:38:08'),
(155,'Groupe Mutuel Services SA','Groupe Mutuel Services AG',NULL,'CHE-103.118.779',325595,'CH62660033191',1,1,'Martigny',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',2,57,NULL,'https://www.groupemutuel.ch/de/Groupe-Mutuel/Unser-Unternehmen.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Groupe Mutuel Services AG verwaltet Vorsorgestiftungen (Groupe Mutuel Vorsorge GMP und Walliser Vorsorge) sowie Krankenversicherer (Mutuelle Neuchâteloise Assurances Maladie und die Caisse-maladie de la vallée d''Entremont).\nDie Aktiengesellschaft ist Bestandteil der Groupe Mutuel Holding AG. \n2018 hat sich die Groupe Mutuel eine Holdingstruktur gegeben. Diese vereint unter sich Krankenversicherer, Krankenzusatzversicherer, eine Lebensversicherungsgesellschaft und sowie die Groupe Mutuel Services AG als Dienstleistungsgesellschaft.','Groupe Mutuel Services SA administre des fondations de prévoyance (Groupe Mutuel Prévoyance-GMP et Mutuelle Valaisanne de Prévoyance) ainsi que des caisses-maladie (Mutuelle Neuchâteloise Assurances Maladie et la Caisse-maladie de la vallée d''Entremont).En 2018, le Groupe Mutuel devient une holding. Celle-ci regroupe des caisses-maladie, des assureurs maladie complémentaires, une société d''assurance-vie et une société de service, Groupe Mutuel Services SA.',NULL,'1919',6136,NULL,NULL,NULL,'2022-11-11 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(156,'Schweizerischer Turnverband STV',NULL,NULL,'CHE-107.083.938',NULL,NULL,0,0,'Aarau','STV',NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer','punktuell',66,65,NULL,'http://www.stv-fsg.ch/verband/ueber-uns/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der 1985 gegründete Schweizerische Turnverband STV ist mit seinen rund 385''000 Mitgliedern nicht nur der grösste polysportive Verband der Schweiz, sondern auch der älteste. Mit seinen Vorgängerverbänden - dem Eidgenössischen Turnverein ETV (Gründungsjahr 1832) und dem Schweizerischen Frauenturnverband SFTV (Gründungsjahr 1908) - blickt er auf eine lange, in der Schweiz stark verwurzelte Tradition zurück.',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2017-07-20 21:49:39','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(157,'Swiss Olympic Association',NULL,NULL,'CHE-112.292.181',787497,'CH03560345987',1,1,'Ittigen',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',65,NULL,NULL,'http://www.swissolympic.ch/desktopdefault.aspx/tabid-3505/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356034598&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0','swissteam','swissolympicteam','SwissOlympicTeam','swissolympicteam/','https://www.linkedin.com/company/swiss-olympic/',NULL,'Swiss Olympic ist der Dachverband des Schweizer Sports und das Nationale Olympische Komitee der Schweiz. Swiss Olympic ist die Organisation, die den Schweizer Sport fördert und vertritt. Er bietet Dienstleistungen, Prävention, Bildung, Integrität und Nachsport an und verbreitet die olympischen Werte.','Swiss Olympic est l''association faîtière du sport suisse et le Comité national olympique suisse. Swiss Olympic est l''organisation qui promeut et représente le sport suisse. Elle offre des services, de la prévention, de l''éducation, de l''intégrité et du sport après le sport et diffuse les valeurs olympiques.',NULL,'3063',362,NULL,NULL,NULL,'2017-07-20 21:49:39','2013-11-10 14:18:51','2024-10-29 13:30:45'),
(158,'Arbeitsgruppe Gesundheitswesen',NULL,NULL,NULL,NULL,NULL,0,0,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',1,NULL,NULL,'http://www.fmc.ch/uploads/tx_userzsarchiv/CM_013-08.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Arbeitsgruppe Gesundheitswesen der Vereinigung Pharmafirmen in der Schweiz (VIPS)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(159,'Lions Club Winterthur',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation','nie',146,12,NULL,'https://winterthur.lionsclub.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Gründung der Organisation erfolgte im Jahr 1917, und sie hat sich seither zu der größten Freiwilligen-Organisation weltweit entwickelt. Ihr Leitprinzip lautet: "Wir dienen". Die vorrangigen Aktivitäten der Lions Clubs konzentrieren sich auf nichtöffentliche Vortragsveranstaltungen und Gesprächsrunden. In der Öffentlichkeit treten die Lions Clubs vor allem im Rahmen von Spendenaktionen in Erscheinung.','L''organisation a été fondée en 1917 et est depuis devenue la plus grande organisation bénévole au monde. Leur principe directeur est : " Nous servons ". Les principales activités des Lions clubs se concentrent sur des conférences non publiques et des tables rondes. Les Lions Clubs apparaissent en public principalement dans le cadre de campagnes de collecte de fonds.',NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-20 21:49:39','2013-11-10 14:18:51','2023-11-14 10:55:14'),
(160,'Swisscup Zürich',NULL,NULL,NULL,NULL,NULL,0,0,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',65,NULL,NULL,'www.swiss-cup.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Im internationalen Turnsport gilt der seit über 30 Jahren stattfindende Swiss Cup Zürich als Top-Event. Dazu trägt auch ein 40-köpfiges OK-Team aus erfahrenen Fachkräften bei, die sich zum grössten Teil ehrenamtlich für den Swiss Cup Zürich engagieren. Das gilt auch für die 300 Helferinnen und Helfer aus Turnvereinen, welche die erfolgreiche Durchführung des Events erst möglich machen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(161,'Berner Fachhochschule','Haute école spécialisée bernoise',NULL,'CHE-319.685.045',1413116,'CH03680792965',1,1,'Bern','BFH',NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'DachOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,'https://www.bfh.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Berner Fachhochschule BFH ist eine anwendungsorientierte Hochschule. Neben der Lehre gehören Weiterbildung, Forschung und Entwicklung sowie Dienstleistungen zu ihren Kernkompetenzen.\n\nDepartemente:\n- Architektur, Holz und Bau\n- Hochschule für Agrar-, Forst- und Lebensmittelwissenschaften\n- Hochschule der Künste Bern\n- Technik und Informatik\n- Wirtschaft, Gesundheit, Soziale Arbeit\n- Eidg. Hochschule für Sport Magglingen EHSM','La Haute école spécialisée bernoise HESB est une haute école orientée vers la pratique. Outre l''enseignement, la formation continue, la recherche et le développement ainsi que les prestations de services font partie de ses compétences clés.\n\nLes départements :\n- Architecture, bois et génie civil\n- Haute école des sciences agronomiques, forestières et alimentaires\n- Haute école des arts de Berne\n- Technique et informatique\n- Économie, santé, travail social\n- Haute école fédérale de sport de Macolin HEFSM',NULL,'3012',351,NULL,NULL,NULL,'2025-09-02 11:07:20','2013-11-10 14:18:51','2025-09-02 11:07:20'),
(162,'Kompetenzzentrum Sexualpädagogik und Schule',NULL,NULL,NULL,NULL,NULL,0,0,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Oeffentlich-rechtlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',41,NULL,NULL,'http://www.amorix.ch/kompetenzzentrum/auftrag/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Auftrag\n\nDas Bundesamt für Gesundheit BAG, Sektion Prävention und Promotion, unterstützt seit 2006 das Kompetenzzentrum Sexualpädagogik und Schule der Pädagogischen Hochschule Zentralschweiz PHZ mit zwei Verträgen und seit 2011 mit einer Subvention.\nDas Kompetenzzentrum Sexualpädagogik und Schule leistet einen Beitrag zum Nationalen Programm zur Prävention von HIV und anderen sexuell übertragbaren Infektionen (STI) NPHS 2011 - 2017.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(163,'ACADEMIE MOBILITE SA','ACADEMIE MOBILITE S.A.',NULL,'CHE-113.880.067',887710,'CH03630403609',1,1,'Ostermundigen',NULL,'Mobilitätsakademie des TCS',NULL,'L''Académie de la mobilité du TCS',NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',26,NULL,NULL,'http://www.mobilityacademy.ch/','http://www.moneyhouse.ch/u/academie_mobilite_sa_CH-036.3.040.360-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Über Verbandsgrenzen hinweg will die Mobilitätsakademie einen vorurteilsfreien Raum für kreatives Verkehrsdenken und -handeln schaffen. Mit ihrer Themenwahl und ihren Schwerpunktsetzungen stellt sie sich in den Dienst einer nachhaltigen Mobilität.\n\nDie Mobilitätsakademie entfaltet ihre Aktivitäten durch die Durchführung von Veranstaltungen, durch Publikationen von Schriftenreihen sowie durch Initiierung von und Beteiligung an nationalen und internationalen Forschungsvorhaben.\n\nZweck im Handelsregister: Bildung und Weiterbildung auf dem Gebiet der Mobilität, insbesondere im Bereich der Energie, der Technik, der Politik, der Verkehrssicherheit, der Wirtschaft, der Umwelt und der Raumverwaltung. Die Gesellschaft kann sich an anderen Unternehmen beteiligen, Unternehmen erwerben und gründen, die ähnlich und ergänzend sind, sowie Immobilien erwerben und verkaufen, insofern diese dem Zweck der Gesellschaft dienen können.',NULL,NULL,'3072',351,NULL,NULL,NULL,'2016-11-30 13:17:58','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(164,'Bildungszentrum für geistig behinderte Erwachsene des Kantons Freiburg','Centre de formation continue pour adultes handicapés, Fribourg',NULL,NULL,NULL,NULL,0,0,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',15,12,NULL,'http://www.cfc-bz.ch/Le%20centre.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Bildungszentrum für geistig behinderte Erwachsene des Kantons Freiburg - im Sommer 1987 durch Pro Infirmis ins Leben gerufen - ist seit 1990 die Stiftung für die Weiterbildung geistig behinderter Erwachsener. Sie wurde vom Staat Freiburg im Dezember des gleichen Jahres anerkannt.','Mis sur pied par Pro Infirmis en été 1987, le Centre de formation continue pour adultes handicapés mentaux du canton de Fribourg devient la Fondation pour la formation continue des personnes handicapées adultes en 1990. Elle est reconnue par l''Etat de Fribourg en décembre de cette même année.',NULL,'1700',NULL,NULL,NULL,NULL,'2016-11-11 17:25:59','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(165,'Fondation "Le Tremplin"',NULL,NULL,'CHE-105.921.617',297649,'CH21701702803',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',25,NULL,NULL,'http://www.tremplin.ch/fr/index.php','http://www.moneyhouse.ch/u/fondation_le_tremplin_CH-217.0.170.280-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Unterstützt Menschen in Not, vor allem im Zuge der Probleme im Zusammenhang mit Drogenmissbrauch oder Kriminalität für eine berufliche Wiedereingliederung oder soziale Unterstützung, Organisation von Dienstleistungen der Rezeption, Tagesstätten, Heimen Unterkunft, Haus Berufen, betreutes Wohnen, dauert es Caritas Freiburg, Verantwortung, Rechte und Pflichten des Dienst namens "Springboard"',NULL,NULL,'1700',2196,NULL,NULL,NULL,'2020-07-15 17:24:35','2013-11-10 14:18:51','2024-11-08 05:08:51'),
(166,'Fondation Les Buissonnets','Fondation Les Buissonnets',NULL,'CHE-106.054.012',265763,'CH21701701711',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',15,NULL,NULL,'http://www.lesbuissonnets.ch/index.php?lang=de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Les Buissonnets unterstützt und begleitet Kinder, Jugendliche und Erwachsene mit besonderem Bildungsbedarf und mit Behinderungen.','La fondation Les Buissonnets soutient et accompagne des enfants, des jeunes et des adultes ayant des besoins éducatifs particuliers et en situation de handicap.',NULL,'1700',2196,NULL,NULL,NULL,'2023-08-19 19:09:11','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(167,'Fonds de recherche du centenaire de l''Université de Fribourg','Fonds de recherche du centenaire de l''Université de Fribourg',NULL,'CHE-110.304.896',313122,'CH21701703543',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.unifr.ch/funding/de/fonds/','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0170354-3&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Ziel des Forschungsfonds zum hundertjährigen Bestehen der Universität Freiburg ist die allgemeine Förderung der wissenschaftlichen Forschungsarbeit an der Universität Freiburg und die Unterstützung von spezifischen Forschungsprojekten, welche zur intellektuellen Ausstrahlung der Universität beitragen.','Le Fonds de recherche du Centenaire de l''Université de Fribourg a pour but de promouvoir d''une façon générale la recherche scientifique à l''Université de Fribourg et de soutenir des projets de recherche spécifiques qui contribuent au rayonnement intellectuel de cette dernière.',NULL,'1700',2196,NULL,NULL,NULL,'2025-09-08 20:48:38','2013-11-10 14:18:51','2025-09-08 20:48:38'),
(168,'SchweizMobil','Fondation SuisseMobile','Fondazione SvizzeraMobile','CHE-101.560.118',387133,'CH03570039552',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',43,NULL,NULL,'http://www.schweizmobil.org/web/schweizmobil/de/home.html','http://www.moneyhouse.ch/u/schweizmobil_CH-035.7.003.955-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Dank der ausgezeichneten Zusammenarbeit aller Partner konnte SchweizMobil im Frühling 2008 durch die Stiftung SchweizMobil (Nachfolgerin der Stiftung Veloland Schweiz) nach nur gut dreijähriger Umsetzungszeit erfolgreich lanciert werden.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2025-07-02 10:27:28','2013-11-10 14:18:51','2025-07-02 10:27:28'),
(169,'Stiftung éducation21',NULL,NULL,'CHE-334.292.233',1114019,'CH03670550935',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,41,NULL,'http://www.education21.ch/de/home',NULL,'education21ch',NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt im Auftrage von und in Zusammenarbeit mit Akteuren aus Bund, Kantonen und Zivilgesellschaft die Förderung und Unterstützung von Bildung für nachhaltige Entwicklung (BNE) auf allen Ebenen der Bildungsarbeit in der Schweiz, und zwar insbesondere durch: Erstellen, Bündeln und Koordinieren von Dienstleistungen und Angeboten für Schule und Unterricht, namentlich in den Bereichen Lehrpläne, Unterrichtsmedien, Schul- und Unterrichtsentwicklung, Bildungsprojekte, Qualitätsentwicklung, Aus- und Weiterbildung von Lehrpersonen, Beratung relevanter Akteure, Veranstaltungen, Dokumentationen und Kommunikation, Wissenstransfer usw.;',NULL,NULL,'3011',351,NULL,NULL,NULL,'2025-10-02 08:55:56','2013-11-10 14:18:51','2025-10-02 08:55:56'),
(170,'Die Freunde des Konservatoriums Freiburg','Les Amis du Conservatoire de Fribourg',NULL,NULL,NULL,NULL,0,0,'Granges-Paccot',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',63,NULL,NULL,'http://www.fr.ch/cof/fr/pub/en_savoir_plus/association_des_amis.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'apporter au Conservatoire de Fribourg (enseignement dans tout le canton à 5''000 élèves grâce à 200 professeurs) un appui moral en entretenant l''intérêt pour cette institution dans les milieux où elle doit être soutenue;\npatronner des manifestations telles que concerts et conférences, à Fribourg et dans le canton de Fribourg;',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(171,'Dachverband Komplementärmedizin','Fédération de la médecine complémentaire (Fedmedcom)',NULL,'CHE-135.034.253',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',4,NULL,NULL,'http://www.dakomed.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Volk und Stände haben am 17. Mai 2009 die Vorlage "Zukunft mit Komplementärmedizin" mit 67 Prozent JA Anteil gutgeheissen und damit die Komplementärmedizin in der Bundesverfassung festgeschrieben: "Bund und Kantone sorgen im Rahmen ihrer Zuständigkeiten für die Berücksichtigung der Komplementärmedizin." Der Dachverband setzt sich dafür ein, dass diese in der Bundesverfassung festgeschriebene Bestimmung umgesetzt wird. \n\nEr setzt sich ein für die Förderung der integrativen Medizin (Zusammenarbeit von Schul- und Komplementärmedizin), die Aufnahme ärztlicher Richtungen der Komplementärmedizin in die Grundversicherung und in die weiteren Sozialversicherungen (SUVA, Militär- und Invalidenversicherung), die Förderung von Lehre und Forschung, die Schaffung nationaler Diplome und kantonaler Berufszulassungen für nichtärztliche Therapeuten und die Sicherstellung der Heilmittelvielfalt.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2025-07-23 00:00:00','2013-11-10 14:18:51','2025-07-23 11:38:00'),
(172,'Dachverband Schweizerischer Patientenstellen','Fédération Suisse des Patient-e-s',NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.patientenstelle.ch/de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-26 09:10:31','2013-11-10 14:18:51','2023-08-26 09:10:32'),
(173,'Denknetz',NULL,NULL,'CHE-354.638.783',NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',45,NULL,NULL,'http://www.denknetz-online.ch/spip.php?page=denknetz&id_rubrique=42&design=1&lang=de','-',NULL,NULL,NULL,NULL,NULL,NULL,'Das Denknetz\n- fördert den Gedankenaustausch und die Zusammenarbeit zwischen WissenschafterInnen, politischen und gewerkschaftlichen AkteurInnen und Institutionen im In- und Ausland\n- macht Forschungsresultate für die politische Praxis fruchtbar und vermittelt Anregungen für Forschungsprojekte\n- entwickelt und setzt Impulse für die politische Orientierung zu aktuellen Themen, ohne jedoch selbst direkt in politische Auseinandersetzungen einzugreifen.',NULL,NULL,NULL,261,NULL,NULL,NULL,'2025-08-20 20:54:33','2013-11-10 14:18:51','2025-08-20 20:54:33'),
(174,'Gesundheitsligen des Kantons Freiburg',NULL,NULL,NULL,NULL,NULL,0,0,'Freiburg',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.liguessante-fr.ch/default_de.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Unterstützung und Begleitung von Personen, die an Krebs, Diabetes oder einer Atemwegserkrankung leiden, damit sie so gut wie möglich mit der Krankheit und deren Konsequenzen im persönlichen, familiären, beruflichen und sozialen Bereich leben können.\n    Sensibilisierung der Risikogruppen für vorbeugende Massnahmen, um die Folgen dieser chronischen Krankheiten zu verringern.\n\nZu den Gesundheitsligen des Kantons Freiburg zählen die Krebsliga Freiburg, diabetesfreiburg, die Lungenliga Freiburg sowie ihre diversen Zentren und Projekte: das Zentrum für Brustkrebs-Früherkennung, das Krebsregister, das mobile Palliative Care Team Voltigo, die Fachstelle Tabakprävention - CIPRET und das Informations- und Präventionszentrum.','Soutenir et accompagner les personnes souffrant d''un cancer, d''un diabète ou d''une maladie respiratoire afin qu''elles puissent vivre le mieux possible avec la maladie et ses conséquences dans leur vie personnelle, familiale, professionnelle et sociale.\nSensibiliser les groupes à risque aux mesures préventives afin de réduire les conséquences de ces maladies chroniques.\n\nLes ligues de santé du canton de Fribourg comprennent la Ligue fribourgeoise contre le cancer, diabètefribourg, la Ligue pulmonaire fribourgeoise ainsi que leurs divers centres et projets : le Centre de dépistage du cancer du sein, le Registre des tumeurs, l''équipe mobile de soins palliatifs Voltigo, le Centre d''information et de prévention du tabagisme - CIPRET et le Centre d''information et de prévention.',NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-19 19:09:11','2013-11-10 14:18:51','2023-11-24 11:06:23'),
(175,'Krebsliga des Kantons Freiburg','Ligue fribourgeoise contre le cancer',NULL,NULL,NULL,NULL,0,0,'Freiburg',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.liguecancer-fr.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Öffentlicher Zweck der Liga :\n- die Hilfe für Krebskranke und ihre Angehörigen ;\n- die Prävention und die Früherkennung von Krebs ;\n- die Unterstützung der Krebsforschung.\nZu diesem Zweck sieht sie vor:\na) die Schaffung einer spezialisierten Beratungsstelle für den ganzen Kanton, welche den Krebskranken und ihren Angehörigen Information, Hilfe und psychosoziale Unterstützung anbietet und sie im Umgang mit der Krankheit und deren Konsequenzen im individuellen, familiären, beruflichen und sozialen Bereich berät und begleitet ;\nb) die Umsetzung von Informations-, Präventions- und Früherkennungs- massnahmen gegen den Krebs ;\nc) die Förderung der Krebsforschung ;\nd) die Beschaffung der notwendigen Geldquellen um die Bedürfnisse der Liga im\nRahmen ihrer Zwecke abzudecken.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-10-19 20:35:22','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(176,'Nationale Informationsstelle für Kulturgüter-Erhaltung (NIKE)',NULL,NULL,NULL,NULL,NULL,0,0,'Liebefeld',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',44,NULL,NULL,'http://www.nike-kultur.ch/de/oeffentlichkeitsarbeit.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Anlaufstelle und Informations-Drehscheibe: Die Nationale Informationsstelle für Kulturgüter-Erhaltung NIKE setzt sich für den Erhalt materieller Kulturgüter - von archäologischen Funden bis hin zu digitalen Datenträgern - in der Schweiz ein.\nDie Tätigkeit der NIKE gründet auf den Schwerpunkten "Sensibilisierung", "Koordination" und "politische Arbeit".\n35 Fachverbände und Publikumsorganisationen bilden den Trägerverein der engagierten Non-Profit-Organisation.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(177,'Association Ouestrail',NULL,NULL,NULL,NULL,NULL,0,0,'Delémont',NULL,NULL,'OuestRail',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',33,NULL,NULL,'http://www.ouestrail.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Ehemaliges Lötschbergkomitee, heute Lobbyorganisation für den Westschweizer Bahnlinienverkehr\n\nZiel: Pour préserver et développer son attractivité économique, pour répondre à l''augmentation croissante de la demande de transport, pour favoriser un transfert des voyageurs et des marchandises de la route vers le rail, la Suisse doit se doter d''un réseau ferroviaire performant.',NULL,NULL,'2800',NULL,NULL,NULL,NULL,'2025-09-02 11:19:56','2013-11-10 14:18:51','2025-09-02 11:19:56'),
(178,'Patientenstelle Westschweiz','Fédération Suisse des Patient-e-s - section romande',NULL,NULL,NULL,NULL,0,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.federationdespatients.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Le service aux pa­tients est la plus ancienne organisation d''aide aux patients de Suisse. L''association à but non lucratif se préserve de toute at­tache politique et confession­nelle.',NULL,NULL,'1701',NULL,NULL,NULL,NULL,'2025-06-17 13:46:29','2013-11-10 14:18:51','2025-06-17 13:46:29'),
(179,'Pro Velo Schweiz',NULL,NULL,'CHE-114.662.277',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',43,NULL,NULL,'http://www.pro-velo.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Pro Velo Schweiz ist der nationale Dachverband der lokalen und regionalen Verbände für die Interessen der Velofahrenden \n\nPro Velo hat zwei Hauptaufgaben: Erstens die Verbesserung der Rahmenbedingungen für das Velofahren in Alltag und Freizeit. Das Velofahren soll sicher, attraktiv, rasch und direkt sein. Zweitens die Erhöhung der Zahl der Velofahrenden, der zurückgelegten Wege und der gefahrenen Kilometer (Veloförderung).\n\nPro Velo setzt sich für die Verbesserung der rechtlichen Rahmenbedingungen des Veloverkehrs ein.\n\nIn Kursen und mit Aktionen vermittelt Pro Velo Kenntnisse über korrektes und sicheres Verhalten im Verkehr.\nPro Velo informiert über die Medien zu velorelevanten Themen.\nPro Velo gibt Publikums- und Fachbroschüren heraus mit velobezogenen Inhalten.\n\nPro Velo ist Ansprechstelle für Behörden, Fachpersonen, Velofahrende und Medien für Fragen rund ums Velo.\n\nPro Velo schafft den Rahmen für den Informationsaustausch und die Wissensvermittlung rund um das Thema Velofahren. Zu diesem Zweck beherbergt sie beispielsweise das Sekretariat der Parlamentarischen Gruppe Langsamverkehr und den "Velogipfel", die Koordinationsstelle Velostationen (www.velostation.ch) sowie die Koordinationsstelle bikesharing (www.bikesharing.ch).\n\nPro Velo ist anerkannter Fachverband für Fragen des Veloverkehrs, unter anderem für den Bund. In dieser Funktion hat sie verschiedene Berichte und Broschüren zum Thema Veloverkehr erarbeitet. (Bereich Langsamverkehr des Bundesamtes für Strassen: www.langsamverkehr.ch) \n\nPro Velo Schweiz hat Einsitz in verschiedenen nationalen und internationalen Gremien wie dem Vorstand des Schweizerischen Verkehrssicherheitsrates VSR (www.verkehrssicherheitsrat.ch), dem Expertenrat des Schweiz. Fonds für Verkehrssicherheit (www.fvs.ch), dem Stiftungsrat von SchweizMobil (www.schweizmobil.org) und dem Management Committee der European',NULL,NULL,NULL,351,NULL,NULL,NULL,'2025-09-08 20:23:28','2013-11-10 14:18:51','2025-09-08 20:23:28'),
(180,'Alzheimer Schweiz','Alzheimer Suisse','Alzheimer Svizzera','CHE-113.807.521',883662,'CH55010515949',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'https://www.alzheimer-schweiz.ch/de/startseite','http://www.moneyhouse.ch/u/schweizerische_alzheimervereinigung_CH-550.1.051.594-9.htm','AlzheimerCH','alzheimer___schweiz',NULL,'AlzheimerSchweiz','https://www.linkedin.com/company/alzheimer-schweiz/about/',NULL,'Die Schweizerische Alzheimervereinigung ist eine unabhängige, konfessionell und politisch neutrale, gemeinnützige Organisation. Sie setzt sich ein für eine Gesellschaft, in der die Menschen gleichwertig und gleich geschätzt miteinander leben. Sie ergreift Partei für Menschen, die an einer Demenzerkrankung leiden. Bei Demenzerkrankungen (Alzheimer oder andere Formen) treten Verluste des Erinnerungsvermögens zusammen mit anderen Funktionsstörungen des Gehirns auf. Dies führt zum Verlust der Selbständigkeit und hat schwerwiegende Folgen für die Betroffenen und ihr Umfeld.','L''Association Alzheimer Suisse est une organisation d''utilité publique indépendante, neutre sur le plan confessionnel et politique. Elle s''engage en faveur d''une société dans laquelle les personnes vivent ensemble sur un pied d''égalité et sont appréciées à leur juste valeur. Elle prend parti pour les personnes atteintes de démence. Les démences (maladie d''Alzheimer ou autres formes) se caractérisent par des pertes de mémoire associées à d''autres dysfonctionnements du cerveau. Cela entraîne une perte d''autonomie et a de graves conséquences pour les personnes concernées et leur entourage.',NULL,'3011',351,NULL,NULL,NULL,'2023-03-16 14:22:21','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(181,'Schweizeriche Gesellschaft für Gesundheitspolitik SGGP','Société suisse pour la politique de la santé (SSPS)','Società svizzera per al politica della salute (SSPS)','CHE-109.161.443',NULL,NULL,0,0,'Bern 8',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.sggp.ch/index-de.php?frameset=7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die SGGP\nwurde 1976 gegründet und hat sich seither als wichtigstes unabhängiges Forum in der schweizerischen Gesundheitspolitik etabliert. Die SGGP stellt allen gesundheitspolitisch interessierten Fachpersonen eine Plattform zur Verfügung. Sie dient als Netzwerk für Gesundheitsprofis, die über ihren Gartenzaun hinaus blicken und sich interdisziplinär austauschen möchten. Sie ist ein Think Tank und entwickelt laufend Ideen und Projekte zur Verbesserung des Gesundheitswesens.\n\nUnabhängig\nDie SGGP ist ein Verein und lebt von ihren rund 1100 Einzel- und Kollektivmitgliedern - finanziell wie auch inhaltlich. Sie bezieht keine Subventionen. Eventuelle Sponsoring-Partnerschaften bei Veranstaltungen und Publikationen erfolgen nach transparenten Kriterien.',NULL,NULL,NULL,351,NULL,NULL,NULL,'2024-08-14 17:25:18','2013-11-10 14:18:51','2024-08-14 17:25:18'),
(182,'Hochspannung unter den Boden','Haute tension sous terre',NULL,NULL,NULL,NULL,0,0,'Fribourg','HSUB.CH','HSUB','HTST.CH','HTST',NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',31,NULL,NULL,'http://www.htst.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Ziel des Vereins ist es, darauf hinzuwirken, dass für den Transport elektrischer Energie, speziell Hochspannungsleitungen eine möglichst moderne und umweltschonende Technik angewendet wird, wie z.B. die Verkabelung der Leitungen unter den Boden oder durchs Wasser.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-09-11 08:51:30','2013-11-10 14:18:51','2023-09-11 08:51:30'),
(183,'Koordinationsstab Harmos der Schweizerischen Konferenz der kantonalen Erziehungsdirektoren EDK','Bureau de coordination Harmos du Conférence suisse des directeurs cantonaux de l''instruction publique ',NULL,NULL,NULL,NULL,0,0,NULL,'Kosta HarmoS',NULL,'Bureau HarmoS',NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',13,NULL,NULL,'http://www.edk.ch/dyn/11659.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Koordinationsstab für die Umsetzung der "Interkantonalen Vereinbarung über die Harmonisierung der obligatorischen Schule" ("HarmoS-Konkordat") ist eine ständige Kommission der EDK. Er gewährleistet die Koordination bei der Umsetzung des Konkordats. Er koordiniert namentlich den Vollzug zwischen der EDK, den Sprachregionen und den EDK-Regionalkonferenzen.\n\nDas "HarmoS-Konkordat"  ist ein neues schweizerisches Schulkonkordat. Das Konkordat harmonisiert erstmals national die Dauer und die wichtigsten Ziele der Bildungsstufen sowie deren Übergänge. Gleichzeitig werden die bisherigen nationalen Lösungen im Schulkonkordat von 1970 bezüglich Schuleintrittsalter und Schulpflicht aktualisiert.\nÜber den Beitritt zum Konkordat entscheidet jeder Kanton einzeln.','Le Bureau de coordination pour la mise en œuvre de l''accord intercantonal sur l''harmonisation de la scolarité obligatoire est une commission permanente de la CDIP.\n\nIl assure la coordination de la mise en œuvre du "concordat HarmoS". Il fait notamment le lien entre la CDIP, les régions linguistiques et les conférences régionales.',NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(184,'Partners in Learning Leadership Forum',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation','nie',27,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(186,'Cochrane Schweiz','Cochrane Suisse',NULL,NULL,NULL,NULL,0,0,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',3,NULL,NULL,'http://swiss.cochrane.org/fr/accueil','-',NULL,NULL,NULL,NULL,NULL,NULL,'Cochrane Switzerland (Cochrane Suisse, Cochrane Schweiz, Cochrane Svizzera) est la branche suisse du Centre Cochrane Français. Sa coordination est assurée depuis Lausanne (Institut Universitaire de Médecine Sociale et Préventive).\n\nLe fonctionnement et les travaux de la Collaboration Cochrane ne sont pas financés par l''industrie pharmaceutique ou par toute autre source pouvant susciter un conflit d''intérêt.\nCochrane Suisse est financé par l''Institut universitaire de médecine sociale et préventive (IUMSP), Centre Hospitalier Universitaire Vaudois et Université de Lausanne, Bugnon 17, 1005 Lausanne.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(187,'Allianz Atomausstieg','Alliance "Non au nucléaire"',NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',131,NULL,NULL,'http://nein-zu-neuen-akw.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'In der Allianz Atomausstieg bündeln Schweizer Parteien, sowie die wichtigsten Umwelt- und Anti-Atom-Organisationen ihre Kräfte mit dem Ziel, den Atomausstieg der Schweiz zu beschleunigen und gesetzlich zu verankern.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-13 09:16:34','2013-11-10 14:18:51','2025-02-13 09:16:34'),
(188,'Association Sortir du nucléaire',NULL,NULL,'CHE-436.332.246',NULL,NULL,0,0,'Plan-les-Ouates',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'EinzelOrganisation,dezidierteLobby','punktuell',131,NULL,NULL,'http://www.sortirdunucleaire.ch',NULL,'sdnch',NULL,NULL,'sortirdunucleaire/',NULL,NULL,'Eine komfortable, aber sparsame Schweiz im Energieverbrauch, die nur mit Energien aus erneuerbaren Quellen betrieben wird, die beim Rückbau von Kernanlagen und der Lagerung radioaktiver Abfälle grösste Sorgfalt walten lässt.','Une Suisse confortable mais économe en matière de consommation d''énergie, qui ne fonctionne qu''avec des énergies issues de sources renouvelables, qui fait preuve du plus grand soin lors du démantèlement des installations nucléaires et du stockage des déchets radioactifs.',NULL,'1228',6633,NULL,NULL,NULL,'2023-08-26 09:10:31','2013-11-10 14:18:51','2024-04-06 14:09:14'),
(190,'Allianz "Ja zur Initiative für den OeV"','Alliance pour les transports publics',NULL,NULL,NULL,NULL,0,1,'Herzogenbuchsee',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',33,NULL,NULL,'http://www.verkehrsclub.ch/de/online/medien/medienmitteilungen.html?tx_frpredakartikel_pi3_detail=7704',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'VCS Initiative zum Ausbau des öffentlichen Verkehrs',NULL,NULL,'3001',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2020-12-30 07:43:01'),
(191,'Aqua Viva',NULL,NULL,'CHE-100.157.961',NULL,NULL,0,0,'Schaffhausen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',122,NULL,NULL,'http://www.aquaviva.ch',NULL,'gewaesserschutz','aquavivagewaesserschutz','aquavivagewaesserschutz','aquavivagewaesserschutz/','https://www.linkedin.com/company/aquavivaschweiz/',NULL,'Aqua Viva ist eine gemeinnützige Umweltorganisation und engagiert sich in Bundesbern und den Kantonen für eine starke rechtliche Verankerung des Gewässerschutzes.','Aqua Viva est une organisation environnementale d''utilité publique qui s''engage dans la Berne fédérale et dans les cantons pour un ancrage juridique fort de la protection des eaux.',NULL,'8201',230,NULL,NULL,NULL,'2025-08-20 21:04:04','2013-11-10 14:18:51','2025-08-20 21:04:04'),
(192,'Gesellschaft für das Weinbaumuseum am Zürichsee',NULL,NULL,NULL,NULL,NULL,0,0,'Au',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation','nie',44,NULL,NULL,'http://www.weinbaumuseum.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Weinbaumuseum am Zürichsee wurde 1978 am Fusse der Halbinsel Au eröffnet und erlaubt einen spannenden Einblick in den Weinbau der Region von den Anfängen bis zur Gegenwart. Der Besuch im Weinbaumuseum nimmt Sie mit auf eine önologische Zeitreise und ist ein Eintauchen in eine vergangene, für viele zum Teil unbekannt gewordene Welt von früher.\nDas Museum wird geführt von der Gesellschaft für das Weinbaumuseum am Zürichsee. Der Verein wurde 1968 gegründet und hat zum Ziel, die Geschichte des Weinbaus zu dokumentieren und die Erinnerung daran wach zu halten. Im neuen Leitbild wird ferner der Bezug zur Gegenwart betont. Das Museum soll Begegnungsort sein für am Wein interessierte Personen und auch moderne Aspekte des Weinbaus aufgreifen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-06 14:59:32','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(194,'Swiss Leaders',NULL,NULL,'CHE-105.814.080',1238408,'CH02060020345',1,1,'Zürich',NULL,'Schweizer Kader Organisation SKO',NULL,'Association suisse des cadres ASC',NULL,'Associazione svizzera dei quadri ASQ',191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',53,NULL,NULL,'https://www.swissleaders.ch/',NULL,'SwissLeaders_ch',NULL,'SwissLeaders','SwissLeaders.ch','https://www.linkedin.com/company/swissleaders/',NULL,'Swiss Leaders, bis 2021 Schweizer Kader Organisation - SKO ist ein branchenübergreifender, parteipolitisch unabhängiger Verband. Er setzt sich ein für die Interessen von Personen mit Führungsverantwortung.','Swiss Leaders, jusqu''en 2021 Organisation suisse des cadres - ASC est une association interprofessionnelle, indépendante de tout parti politique. Elle s''engage pour les intérêts des personnes ayant des responsabilités de direction.',NULL,'8006',261,NULL,NULL,NULL,'2021-06-07 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(195,'Spitex-Verband Kanton Zürich',NULL,NULL,'CHE-108.343.622',NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer','nie',7,NULL,NULL,'http://www.spitexzh.ch/verband/dienstleistungen/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Spitex Verband Kanton Zürich ist der Dachverband der (gemeinnützigen) Spitex-Organisationen im Kanton Zürich. Er wurde 1992 als Verein gegründet.\n\nZielsetzungen\nDer Verband vertritt die Interessen der Spitex-Organisationen und unterstützt diese im Gesundheits- und Sozialwesen sowie im politischen Umfeld. Der Verband untersützt die Entwicklung und den Ausbau von bedarfsorientierten, benützerfreundlichen und leistungsfähigen Spitex-Diensten im Kanton Zürich mit\n\nDienstleistungen\nInformation und Beratung\nZeitschrift "Spitex Magazin", telefonische Auskünfte und Beratung, Informationsveranstaltungen, Pressemitteilungen\nEntwicklung von Grundlagenpapieren\nu.a. Qualitätskonzept, Grundlagen für Kostenvergleiche (Benchmark), politische Stellungnahmen, Musterleistungsvereinbarung\nArbeitsinstrumente\nBedarfsabklärung, Arbeitsverträge, Mitarbeiterinnenbeurteilung, Stellenbeschreibungen, Besoldungs-empfehlungen\nInteressenvertretung\nVertretung der Spitex-Anliegen bei Bund, Kanton, Gemeinden, Krankenversicherungen (Tarif- und Vertragsverhandlungen), Mitarbeit bei der Beschwerdestelle für das Alter, Zürich und weiteren Gremien\nBildung\nSchulungskurse für Vorstands- und Behördenmitglieder und Mitarbeit bei der Entwicklung von Fortbildungsangeboten für Spitex-Mitarbeitende, SPICURA FaGe-Lehrbetriebsverbund für Heime und Spitex',NULL,NULL,NULL,261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(196,'Verein für Ingenieurbiologie',NULL,NULL,NULL,NULL,NULL,0,0,'Rapperswil',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','punktuell',NULL,NULL,NULL,'http://www.ingenieurbiologie.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein will die Anwendung ingenieurbiologischer Massnahmen fördern und beteiligt sich an der Erarbeitung von Grundlagen des Lebendverbaus. Zudem soll der Erfahrungsaustausch untereinander, mit verwandten Fachgebieten und Fachorganisationen gepflegt werden.',NULL,NULL,'8640',NULL,NULL,NULL,NULL,'2019-07-27 21:03:43','2013-11-10 14:18:51','2019-07-27 21:03:43'),
(197,'Fachhochschule Nordwestschweiz FHNW',NULL,NULL,'CHE-116.216.865',NULL,NULL,0,0,'Brugg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich','0224',NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,'http://www.fhnw.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die FHNW basiert auf dem Staatsvertrag der Kantone Aargau, Basel-Landschaft, Basel-Stadt und Solothurn vom 27. Oktober/9. November 2004.\n\nDie FHNW entstand aus der Fusion der drei Fachhochschulen Aargau, beider Basel und Solothurn, der Pädagogischen Hochschule Solothurn, der Hochschule für Pädagogik und Soziale Arbeit beider Basel sowie den Musikhochschulen der Musik Akademie Basel.',NULL,NULL,NULL,4123,NULL,NULL,NULL,'2025-07-01 18:03:32','2013-11-10 14:18:51','2025-07-01 18:03:32'),
(199,'Regionalplanungsgruppe Rohrdorferberg-Reusstal',NULL,NULL,'CHE-474.641.665',NULL,NULL,0,1,'Oberrohrdorf',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Staatlich','0224',NULL,'EinzelOrganisation,LeistungsErbringer','nie',13,NULL,NULL,'http://www.ag.ch/staatskalender/?rub=10581',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Reginalplanungsgruppe AG',NULL,NULL,NULL,4037,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(200,'Verteilung Alkoholzehntel im Aargau',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.aargauerzeitung.ch/schweiz/kanton-greift-eltern-bei-erziehung-unter-die-arme-11142623',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Kantonale Kommission zur Verteilung des Alkoholzehntelanteils des Bundes',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(201,'Albert und Ida Nüssli-Stutz-Stiftung',NULL,NULL,'CHE-109.585.062',278728,'CH40070100783',1,1,'Mellingen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',63,NULL,NULL,'http://www.moneyhouse.ch/u/albert_und_ida_nussli_stutz_stiftung_CH-400.7.010.078-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Förderung gemeinnütziger, wohltätiger, sozialer, erzieherischer, bilden-der, kultureller und künstlerischer Werke.',NULL,NULL,'5507',4033,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(202,'Stiftung Ballenberg',NULL,NULL,'CHE-110.398.650',363080,'CH09270026725',1,1,'Hofstetten b. Brienz',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',44,NULL,NULL,'http://ballenberg.ch/de/Info/Portrait',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Freilichtmuseum für bäuerliche Kultur(Stiftung)',NULL,NULL,'3858',580,NULL,NULL,NULL,'2019-08-16 17:30:01','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(203,'Reha Rheinfelden',NULL,NULL,'CHE-105.775.333',318348,'CH40079082363',1,1,'Rheinfelden',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'http://www.reha-rheinfelden.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Rehabilitationsklinik',NULL,NULL,'4310',4258,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(204,'Gen Suisse - Schweizerische Stiftung für Gentechnik',NULL,NULL,'CHE-109.599.992',279039,'CH03570105782',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,dezidierteLobby','punktuell',97,NULL,NULL,'http://www.gensuisse.ch/de/aktuelles',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Seit 20 Jahren unterstützt die Stiftung Gen Suisse den Dialog zwischen Forschung, Politik, Öffentlichkeit und Schulen. Gegründet 1991 in Zeiten hitziger Diskussionen rund um die Gentechnik, hat Gen Suisse mittlerweile 20 Jahre Forschung und Forschungspolitik im Bereich der Life Sciences begleitet. Die Errungenschaften und Entdeckungen der Forschung brachten Diskussionen zu möglichen Risiken und ethischen Aspekten mit sich. Die Politik hielt Schritt, um den neuen Möglichkeiten der Forschung zu rechtlichen Grundlagen zu verhelfen.',NULL,NULL,'8045',261,NULL,NULL,NULL,'2025-07-21 16:40:33','2013-11-10 14:18:51','2025-07-21 16:40:33'),
(205,'Stiftung Forschung 3R (Vermindern, Verbessern und Vermeiden von Tierversuchen) in Liquidation','Fondation Recherches 3R',NULL,'CHE-101.694.411',308370,'CH03570090009',1,1,'Münsingen',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',27,NULL,NULL,'http://www.forschung3r.ch','https://be.chregister.ch/cr-portal/auszug/auszug.xhtml;jsessionid=e2b3d4c214081673cd026e0ed58f?uid=CHE-101.694.411',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Forschung 3R bezweckt, die Forschung auf dem Gebiet der Alternativmethoden zu Tierversuchen durch Finanzierung von Forschungsprojekten zu fördern, und setzt sich für die Umsetzung und Verbreitung der 3R-Grundsätze ein. Sie unterstützt vordringlich Projekte zur Erforschung neuer Methoden oder zur Weiterentwicklung bekannter Methoden (Validierung von Methoden), welche im Sinne der 3 R (Reduce, Refine, Replace / Vermindern, Verbessern, Vermeiden) gegenüber der heutigen Tierversuchspraxis Verbesserungen versprechen. Die Forschungsprojekte werden nach periodisch festgesetzten Schwerpunkten für die Unterstützung ausgewählt.\nTräger der Stiftung\n\nDie Stiftung ist ein Gemeinschaftswerk der parlamentarischen Gruppe für Tierversuchsfragen (Öffentlichkeit), der Interpharma (Verband der forschenden pharmazeutischen Firmen der Schweiz mit den heutigen Mitgliedern Actelion Ltd., Merck Serono International SA, Novartis Pharma AG, F. Hoffmann-La Roche AG und den assoziierten Mitgliedern Bayer Schweiz AG, Cilag AG und Vifor AG) und des Fonds für versuchstierfreie Forschung - heute Stiftung Animalfree Research (Tierschutz). Sie besteht seit 1987 und steht unter der Aufsicht des Eidgenössischen Departements des Innern.','La Fondation Recherches 3R a pour but de promouvoir la recherche dans le domaine des méthodes de substitution à l''expérimentation en finançant des projets de recherche et s''engage pour la mise en œuvre et la diffusion des principes 3R. Elle soutient avant tout des projets destinés à découvrir de nouvelles méthodes ou à développer des méthodes existantes (validation de méthodes) qui peuvent apporter des améliorations par rapport aux expériences menées actuellement sur les animaux, dans le sens des 3 R (Reduce, Refine, Replace / Réduction, Réforme, Remplacement). Les projets soumis à la Fondation sont retenus selon les priorités, défini périodiquement.',NULL,'3110',616,NULL,NULL,NULL,'2021-01-09 16:19:27','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(206,'Kurt Imhof Stiftung für Medienqualität',NULL,NULL,'CHE-114.746.767',937693,'CH02070015865',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.oeffentlichkeit.ch/index.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die gemeinnützige "Stiftung Öffentlichkeit und Gesellschaft" setzt sich für mehr Qualitätsbewusstsein und für höhere Qualitätsansprüche in der medienvermittelten Kommunikation auf Seiten des Publikums wie auf Seiten der Medien ein. Die Stiftung fördert die vergleichende Analyse der medienvermittelten Kommunikation und die Bereitstellung der Ergebnisse für die interessierte Öffentlichkeit und für Schulen.',NULL,NULL,'8050',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(207,'Stiftung Regionales Blutspende-Zentrum',NULL,NULL,NULL,NULL,NULL,0,0,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung',NULL,NULL,'EinzelOrganisation','nie',3,NULL,NULL,'http://www.moneyhouse.ch/u/stiftung_regionales_blutspendezentrum_srk_aarau_CH-400.7.017.990-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(208,'Stiftung Vindonissapark',NULL,NULL,'CHE-114.865.716',944643,'CH40070316488',1,1,'Windisch',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',44,NULL,NULL,'http://www.vindonissapark.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung fördert die Vermittlung von Archäologie, Geschichte und Kunstgeschichte im historischen Raum Vindonissa sowie der Zusammenhänge zwischen den Kulturgütern und den landschaftlichen Voraussetzungen im "Wasserschloss", wo Aare, Limmat und Reuss zusammenfliessen.\n\nSie bündelt und koordiniert die privaten und öffentlichen Kräfte, die sich ideell und finanziell für diesen Zweck einsetzen. Die Stiftung kann Dritte, die sich diesem Zweck widmen, unterstützen oder die Vermittlung selber betreiben, insbesondere auch entsprechende Institutionen führen',NULL,NULL,'5210',4123,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(209,'Technopark Aargau',NULL,NULL,NULL,NULL,NULL,0,0,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',23,NULL,NULL,'http://www.technopark-aargau.ch/1.aspx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(210,'Forum Alter und Migration',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',12,NULL,NULL,'http://www.alter-migration.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Nationale Forum setzt sich für die Verbesserung der gesundheitlichen und sozialen Situation älterer Migrantinnen und Migranten in der Schweiz ein. Es hat sich zum Ziel gesetzt, die Rechte der älteren Migranten und Migrantinnen in der Schweiz zu stärken und den Respekt für die Leistungen dieser Generation zu fördern. mehr...',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(211,'Forum Vera',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,'Verantwortung für die Entsorgung radioaktiver Abfälle',NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',30,NULL,NULL,'http://www.forumvera.info/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Forum VERA setzt sich - unabhängig vom weiteren Schicksal der Kernenergienutzung in der Schweiz - für eine technisch sichere Entsorgung radioaktiver Abfälle ein. Das Forum VERA wird von der Nagra mit einem jährlichen Beitrag von Fr. 195 000 unterstützt.\n\nDie rund 2500 Mitglieder von Forum VERA sind Persönlichkeiten aus Wissenschaft, Kultur und Politik. Darunter finden sich sowohl Gegner als auch Befürworter der Kernenergie. Die Mitgliedschaft ist offen für alle Interessierten.\n\nZiel des Vereins ist es, eine breite gesellschaftliche Abstützung der Entsorgung radioaktiver Abfälle sowie eine demokratische Übernahme der Verantwortung in diesem Bereich zu erreichen.',NULL,NULL,'3011',NULL,NULL,NULL,NULL,'2025-02-12 13:21:25','2013-11-10 14:18:51','2025-02-12 13:21:25'),
(212,'Stiftung Speranza in Liquidation',NULL,NULL,'CHE-114.567.377',925529,'CH40070310534',1,1,'ohne Domizil-sans domicile',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',27,NULL,NULL,'http://www.stiftungsperanza.ch/default.aspx?navid=57','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4007031053&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Speranza schafft berufliche Perspektiven. Unzählige Jugendliche finden nach der obligatorischen Schulzeit den beruflichen Anschluss nicht oder werden nach abgeschlossener Berufslehre arbeitslos. Auch wer nach dem 50. Altersjahr seine Stelle verliert, hat geringe Chancen auf Wiedereingliederung in den Arbeitsmarkt. Unser oberstes Ziel ist die Ausbildung und die nachhaltige Integration von jungen und älteren Menschen in den Arbeitsmarkt.\n\nZefix: Wahrnehmung von sozialen Aufgaben und Unterstützung erfolgsorientierter unternehmerischer Projekte zur beruflichen Integration. Nachhaltige Stärkung der Wettbewerbsfähigkeit der Schweiz. Schaffung von Ausbildungsplätzen für schulisch schwache Jugendliche; Eingliederung von langzeitarbeitslosen Jugendlichen und ausgesteuerten; Eingliederung von Personen mit gesundheitlichen Leistungseinbussen. Die Stiftung verfolgt einen gemeinnützigen Zweck. Sie strebt für sich keinen Gewinn an. Die Stiftung fördert in der Öffentlichkeit das Verständnis für die Integration ins Erwerbsleben durch die aktive Information. Sie fördert auch die Zielsetzungen der Gönnervereinigung Stiftung Speranza und stellt finanzielle Mittel für die sofortige Realisierung von erfolgsversprechenden Projekten und Massnahmen zur Verfügung.',NULL,NULL,NULL,4001,NULL,NULL,NULL,'2022-09-23 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(213,'Hauseigentümerverband Sektion Baden/Brugg/Zurzach',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,'HEV Baden/Brugg/Zurzach',NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',19,NULL,NULL,'http://www.hev-schweiz.ch/index.php?id=2929&kt=AG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Sektion des Hauseigentümerverbandes (HEV)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2017-10-31 09:03:33'),
(214,'IG Musikinitiative',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',27,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Dass Musikunterricht die Entwicklung des Menschen positiv beeinflusst, ist unumstritten. Mit der verfassungsmässigen Verankerung eines zeitgemässen Musikunterrichts wollen wir diesen Wert für die Gesellschaft sichern. Die musizierende Jugend muss in Zukunft zu gutem Musikunterricht  Zugang haben - sowohl in der obligatorischen Schulzeit, als auch im ausserschulischen Bereich an Musikschulen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(215,'Skilift Oberegg-St. Anton AG',NULL,NULL,'CHE-101.904.488',178512,'CH31030002821',1,1,'Oberegg',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',60,NULL,NULL,'http://www.skilift-oberegg.ch/','http://ai.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3103000282&amt=310&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Errichtung und Betrieb eines Skiliftes von Oberegg nach dem St. Anton. Sie soll unter Wahrung ihres Charakters als Erwerbsgesellschaft nach Möglichkeit alle Zweige des Skisportes fördern und kann sich an andern ähnlichen Bestrebungen und Unternehmungen beteiligen.',NULL,NULL,'9413',3111,NULL,NULL,NULL,'2017-07-07 13:11:50','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(216,'ch-intercultur','ch-intercultur','ch-intercultur',NULL,NULL,NULL,0,0,'Bern','cic','Schweizer Feuilletondienst','cic',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',62,NULL,NULL,'http://www.ch-intercultur.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Sie interessieren sich für Kultur in der Schweiz, für Theater, Literatur, Kunst, Musik, für Kultur- oder Sprachenpolitik? Dann sind Sie bei uns am richtigen Ort. Als kultureller Informationsdienst schreibt der SFD tagesaktuell über Theater- und Tanzpremieren, über Kunstausstellungen und Konzerte in der ganzen Schweiz, und er bespricht jeweils die belletristischen Neuerscheinungen auf dem Deutschschweizer Büchermarkt. Kleine Häuser berücksichtigt er ebenso wie grosse, junge Autoren ebenso wie arrivierte. Randständige Kunst liegt dem SFD gleichermassen am Herzen wie der Mainstream.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-07-14 14:52:05','2013-11-10 14:18:51','2023-07-14 14:52:05'),
(217,'Stiftung Pro Innerrhoden',NULL,NULL,'CHE-116.184.969',NULL,NULL,0,0,'Appenzell',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',NULL,'EinzelOrganisation,LeistungsErbringer','nie',63,NULL,NULL,'https://www.ai.ch/verwaltung/kommissionen/stiftungsrat-stiftung-pro-innerrhoden',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Pro Innerrhoden fördert das einheimische kulturelle Schaffen des Kantons Appenzell I.Rh. sowie die entsprechenden Institutionen und Vereinigungen. Sie pflegt das kulturelle Erbe und unterstützt die Erhaltung und Wiederherstellung geschichtlicher und schutzwürdiger Kulturgüter. Die Stiftung Pro Innerrhoden betreibt und unterhält das Museum Appenzell und unterstützt zusammen mit den Bezirken und Schulgemeinden des inneren Landesteils die Volksbibliothek Appenzell.',NULL,NULL,NULL,3101,NULL,NULL,NULL,'2017-07-07 13:11:50','2013-11-10 14:18:51','2022-09-25 22:33:13'),
(218,'Schweizer Jugend forscht','La Science Appelle Les Jeunes',NULL,'CHE-107.156.017',292809,'CH02079036697',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.sjf.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Schweizer Jugend forscht organisiert Veranstaltungen für motivierte junge Menschen, die sich für Wissenschaft und Forschung interessieren. Wir legen Wert auf das selbständige Erfahren und Entdecken der Welt der Wissenschaften.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2023-06-19 16:03:48','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(220,'Stiftung Kinderdorf Pestalozzi',NULL,NULL,'CHE-105.770.471',279195,'CH30070102347',1,1,'Trogen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',68,79,NULL,'http://www.pestalozzi.ch/index.php?L=0','http://ar.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3007010234&amt=300&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Kinderdorf Pestalozzi unterhält in Trogen ein Kinderdorf, das notleidende Kinder aus allen Ländern aufnimmt. Das Kinderdorf will diesen Kindern eine Heimstätte bieten, in der sie eine sorgfältige Erziehung geniessen und im Geiste Pestalozzis zu aufgeschlossenen, der Völkerverständigung dienenden Menschen heran wachsen können. Im Rahmen des Stiftungszweckes ist es auch möglich, Schweizer Kinder aufzunehmen. Ausserdem unterstützt sie die Betreuung und Erziehung notleidender Kinder durch ausgewählte Aktionen ausserhalb der Schweiz. Solche Aktionen können eine Fortsetzung oder eine Ergänzung der Hilfe im Kinderdorf einschliessen. Sie ist bemüht, die in ihrer Tätigkeit gesammelten ärztlichen, pädagogischen und fürsorgerischen Erfahrungen der Jugenderziehung dienstbar zu machen. Sie kann, soweit es ihre Mittel zulassen, auch weitere ihrem Interessenkreis nahe stehenden Aufgaben fördern, wobei sie zugleich eine enge Zusammenarbeit mit anderen in- und ausländischen Kinderhilfe- und Jugendinstitutionen anstrebt.',NULL,NULL,'9043',3025,NULL,NULL,NULL,'2019-09-08 09:09:14','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(221,'Aufsichtskommission der Interstaatlichen Erwachsenenmatura',NULL,NULL,NULL,NULL,NULL,0,0,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Ausserparlamentarische Kommission',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'www.imes.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Aufsichtskommission der Interstaatliche Maturitätsschule für Erwachsene St.Gallen / Sargans c/o Kantonsschule Sargans.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-07 13:11:50','2013-11-10 14:18:51','2017-07-07 13:11:50'),
(223,'HKG Consulting AG',NULL,NULL,'CHE-100.922.360',532252,'CH03530265550',1,1,'Aarau','HKG',NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',50,NULL,NULL,'http://www.hkgroup.ch/unternehmen/','http://www.moneyhouse.ch/u/v/hkg_consulting_ag_CH-035.3.026.555-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Herzog Kull Group wurde 1978 gegründet und hat sich in dieser Zeit zu einem der führenden und landesweiten Anbieter in den Bereichen Elektroengineering Gebäudetechnik und Energieberatung entwickelt.',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(224,'Seniorweb AG','Seniorweb SA','Seniorweb SA','CHE-114.476.220',920025,'CH02030328929',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',12,NULL,NULL,'http://www.seniorweb.ch/type/page/ueber-uns','http://www.moneyhouse.ch/u/p/seniorweb_ag_CH-020.3.032.892-9.htm','Seniorweb_','seniorweb_schweiz',NULL,NULL,NULL,NULL,'Seniorweb.ch ist die dreisprachige, interaktive Internetplattform für die Generation 50plus in der Schweiz. Sie wird gestaltet, betrieben von Freiwilligen die für die Bedürfnisse ihrer Generation schreiben, organisieren und Netzwerke entwickeln. Sie bietet auch allen Altersorganisationen der Schweiz eine Plattform an, auf der diese ihre Mitglieder informieren können.','Seniorweb.ch est la plate-forme Internet trilingue et interactive pour la génération des 50 ans et plus en Suisse. Elle est conçue et gérée par des bénévoles qui écrivent, organisent et développent des réseaux pour les besoins de leur génération. Elle offre également à toutes les organisations de personnes âgées de Suisse une plateforme sur laquelle elles peuvent informer leurs membres.',NULL,'8004',261,NULL,NULL,NULL,'2023-08-29 17:34:29','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(225,'Swiss Economic Forum GmbH',NULL,NULL,'CHE-104.707.091',430826,'CH03540180022',1,1,'Gwatt (Thun)',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',23,NULL,NULL,'http://www.swisseconomic.ch/','http://www.moneyhouse.ch/u/swiss_economic_forum_gmbh_CH-035.4.018.002-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Das Swiss Economic Forum (SEF) fördert unternehmerisches Gedankengut, vernetzt Entscheidungsträger aus Wirtschaft, Politik und Wissenschaft und setzt sich aktiv für Jungunternehmen ein. Mit verschiedenen Aktivitäten unterstützen wir Unternehmer, Entscheidungsträger und Witschaftsführer bei der Umsetzung von unternehmerischen Herausforderungen und präsentieren frühzeitig neue Trends und neue Opportunitäten. Das Swiss Economic Forum bringt Unternehmertum auf den Punkt.',NULL,NULL,'3645',942,NULL,NULL,NULL,'2023-07-10 13:46:21','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(227,'Stiftung Krebsregister Aargau',NULL,NULL,'CHE-491.759.782',1024139,'CH40070342769',1,1,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://krebsregister-aargau.org/','http://www.moneyhouse.ch/u/stiftung_krebsregister_aargau_CH-400.7.034.276-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Führung eines Krebsregisters für den Kanton Aargau',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(228,'Freunde des Zentrums für Demokratie (ZDA)',NULL,NULL,NULL,NULL,NULL,0,0,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','nie',35,NULL,NULL,'http://www.zdaarau.ch/de/freunde/index.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein "Freunde des ZDA" wurde am 2. April 2009 gegründet und hat den Zweck, die Entwicklung des ZDA zu fördern und dessen Verankerung in der Bevölkerung, Politik und Wirtschaft zu verstärken. Die Vereinsmitglieder werden laufend über die öffentlichen Veranstaltungen des ZDA informiert und zur Teilnahme eingeladen. Grundsätzlich können sämtliche natürlichen oder juristischen Personen dem Verein als Mitglied beitreten.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(229,'Verein Cleantech Aargau',NULL,NULL,NULL,NULL,NULL,0,0,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',50,NULL,NULL,'http://www.cleantechaargau.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein Cleantech Aargau ist ein Zusammenschluss von Personen, Unternehmungen, Organisationen und Institutionen, die sich für die Stärkung von Cleantech im Kanton Aargau aussprechen und gemeinsame Ziele verfolgen.',NULL,NULL,'5000',NULL,NULL,NULL,NULL,'2018-08-13 11:22:13','2013-11-10 14:18:51','2018-08-13 11:22:13'),
(230,'Center for Disability and Integration, Universität St.Gallen',NULL,NULL,NULL,NULL,NULL,0,0,'St. Gallen','CDI-HSG',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation','nie',15,NULL,NULL,'http://www.cdi.unisg.ch/de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Center for Disability and Integration (CDI-HSG) ist ein interdisziplinäres Forschungscenter, in dem Betriebswirte, Volkswirte und Psychologen gemeinsam zur beruflichen Integration von Menschen mit Behinderung forschen.\n\nIm März 2009 nahm das Center for Disability and Integration (CDI-HSG) seine Tätigkeit an der Universität St.Gallen auf. Die Gründung des Centers wurde durch eine private Zuwendung ermöglicht. Das Center wurde gemeinsam vom Schweizerischen Institut für Empirische Wirtschaftsforschung SEW-HSG und dem Institut für Führung und Personalmanagement I.FPM-HSG gegründet.',NULL,NULL,'9000',NULL,NULL,NULL,NULL,'2022-01-03 10:31:17','2013-11-10 14:18:51','2022-01-03 10:31:17'),
(231,'Institut für Wirtschaftsethik der Universität St. Gallen',NULL,NULL,NULL,NULL,NULL,0,0,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',41,NULL,NULL,'http://www.iwe.unisg.ch/Ueber+uns.aspx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Im Mittelpunkt unseres theoretischen und empirisch/praktischen Forschungsinteresses stehen Fragen der Realisierung von Unternehmensverantwortung.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-07-10 12:41:20','2013-11-10 14:18:51','2023-07-10 12:41:20'),
(232,'Solothurner Spitäler AG',NULL,NULL,'CHE-112.667.097',821537,'CH24130054127',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'DachOrganisation','punktuell',5,NULL,NULL,'https://www.so-h.ch/',NULL,'SOspitaeler',NULL,NULL,NULL,NULL,NULL,'Spitalverbund öffentlicher Spitäler Kt. SO',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2023-01-27 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(233,'Moriz und Elsa von Kuffner - Stiftung',NULL,NULL,'CHE-100.660.266',280230,'CH02079049817',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.kuffner.ch/','http://www.moneyhouse.ch/u/moriz_und_elsa_von_kuffner__stiftung_CH-020.7.904.981-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung unterstützt Studierende an Hochschulen und Fachhochschulen, vorab aus Berggebieten, schweizerische Sozialwerke aller Art, betagtes, krankes und sich in Ausbildung befindendes Krankenpflegepersonal, Familien und Einzelpersonen in Bedrängnis sowie Berggemeinden und Institutionen in Bergregionen.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(234,'Axpo Holding AG',NULL,NULL,'CHE-101.846.968',608384,'CH40030222974',1,1,'Baden',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',29,NULL,NULL,'http://www.axpo.ch/','http://www.moneyhouse.ch/u/axpo_holding_ag_CH-400.3.022.297-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Axpo Gruppe produziert, handelt und vertreibt Energie zuverlässig für über 3 Millionen Menschen und mehrere tausend Unternehmen in der Schweiz und in über 30 Ländern Europas. \nZur Axpo Gruppe gehören die Axpo Holding AG mit Sitz in \nBaden und deren Tochtergesellschaften Axpo Power AG, \nAxpo Trading AG, Avectris AG und Centralschweizerische \nKraftwerke AG. Axpo ist zu 100 Prozent im Eigentum der \nNordostschweizer Kantone.',NULL,NULL,'5400',4021,NULL,NULL,NULL,'2025-02-13 09:16:34','2013-11-10 14:18:51','2025-02-13 09:16:34'),
(235,'De Martin AG Surface Technology',NULL,NULL,'CHE-101.520.567',43592,'CH44030045797',1,1,'Wängi',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',52,NULL,NULL,'http://www.demartin.com/de/news.cfm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt den Betrieb eines Unternehmens für Oberflächentechnik.',NULL,NULL,'9545',4781,NULL,NULL,NULL,'2017-07-22 10:35:29','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(236,'KIBAG HOLDING AG',NULL,NULL,'CHE-102.634.133',98555,'CH02039148576',1,1,'Bäch SZ',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',51,NULL,NULL,'http://www.kibag.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Bauunternehmung',NULL,NULL,'8806',1322,NULL,NULL,NULL,'2017-07-22 10:35:29','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(237,'Stiftung Kartause Ittingen',NULL,NULL,'CHE-108.316.878',278445,'CH44070019830',1,1,'Warth',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',44,NULL,NULL,'http://www.kartause.ch/de/home/?',NULL,NULL,'kartauseittingen',NULL,'kartause',NULL,NULL,'Die Stiftung bezweckt durch den Kauf und die Wiederherstellung der Kartause Ittingen, die Anlage in ihrem historischen Bestand zu erhalten und als weitgehend eigenwirtschaftliches Kulturzentrum zu betreiben.\nZu diesem Zweck führt sie einen Seminar- und Gastwirtschaftsbetrieb, betreutes Arbeiten und Wohnen, einen Werkbetrieb und einen Gutsbetrieb, und sie ermöglicht dem Kanton Thurgau den Betrieb des Ittinger Museums und des Kunstmusems Thurgau.','La fondation a pour but, par l''achat et la restauration de la chartreuse d''Ittingen, de conserver le site dans son état historique et de l''exploiter comme centre culturel largement autonome.\nA cet effet, elle gère une entreprise de séminaires et d''hôtellerie, un lieu de travail et d''habitation protégé, une entreprise de travaux publics et une exploitation agricole, et permet au canton de Thurgovie d''exploiter le musée d''Ittingen et le Kunstmusem Thurgau.',NULL,'8532',4621,NULL,NULL,NULL,'2024-01-24 12:42:51','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(238,'BDO AG',NULL,NULL,'CHE-105.952.747',202730,'CH02039279065',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'AG','0106',3,'EinzelOrganisation,DachOrganisation,LeistungsErbringer','punktuell',58,NULL,NULL,'http://www.bdo.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die BDO AG ist eine der führenden Wirtschaftsprüfungs-, Treuhand- und Beratungsgesellschaften der Schweiz. Mit 33 Niederlassungen verfügt BDO über das dichteste Filialnetz der Branche. Für grenzüberschreitende Aufgabenstellungen können wir auf das finanziell von uns unabhängige, weltweite BDO Netzwerk zurückgreifen.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2025-06-25 07:21:36','2013-11-10 14:18:51','2025-06-25 07:21:36'),
(239,'CSS Holding AG','CSS Holding SA','CSS Holding SA','CHE-111.661.465',747329,'CH10030281265',1,1,'Luzern','CSS',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'LeistungsErbringer','punktuell',2,NULL,NULL,'https://www.css.ch/de/home.html','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003028126&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Krankenversicherer und Tochtergesellschaften: Sanagate AG, Arcosana AG, INTRAS Assurance SA',NULL,NULL,'6005',1061,NULL,NULL,NULL,'2025-06-25 07:21:36','2013-11-10 14:18:51','2025-06-25 07:21:36'),
(240,'Emmi AG',NULL,NULL,'CHE-103.588.843',402421,'CH10030200848',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'DachOrganisation,LeistungsErbringer','punktuell',39,38,NULL,'http://group.emmi.com/','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003020084&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0','EmmiCorporate','emmi__ch','EmmiTubes','Emmi/','https://www.linkedin.com/company/emmi-schweiz-ag/',NULL,'Emmi AG mit Sitz in Luzern ist die grösste Molkerei der Schweiz und gehört zu den 500 grössten Unternehmen in der Schweiz. Zur Emmi-Gruppe gehören in der Schweiz zahlreiche Produktionsbetriebe. Ausserhalb der Schweiz hat Emmi Produktionsbetriebe u. a. in Chile, Deutschland, Italien, den Niederlanden, Österreich, Spanien, Tunesien, Brasilien, Kanada und den USA.','Emmi SA, dont le siège est à Lucerne, est la plus grande laiterie de Suisse et fait partie des 500 plus grandes entreprises du pays. De nombreuses entreprises de production font partie du groupe Emmi en Suisse. En dehors de la Suisse, Emmi possède des entreprises de production notamment au Chili, en Allemagne, en Italie, aux Pays-Bas, en Autriche, en Espagne, en Tunisie, au Brésil, au Canada et aux États-Unis.',NULL,'6005',1061,'https://de.wikipedia.org/wiki/Emmi_AG','Q632030',NULL,'2018-08-13 11:30:39','2013-11-10 14:18:51','2024-11-08 06:02:13'),
(241,'Verkehrsbetriebe Luzern AG',NULL,NULL,'CHE-103.178.209',596212,'CH10030243508',1,1,'Luzern','VBL','Verkehrsbetriebe der Stadt Luzern',NULL,NULL,NULL,NULL,191,2,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',33,NULL,NULL,'http://www.vbl.ch/',NULL,NULL,'vbl_verkehrsbetriebeluzern','VerkehrsbetriebeLuzernAG','verkehrsbetriebeluzern','https://www.linkedin.com/company/verkehrsbetriebe-luzern-vbl/',NULL,'Die Verkehrsbetriebe Luzern AG (VBL) sind ein öffentliches Verkehrsunternehmen im Kanton Luzern. Sie betreiben in der Stadt Luzern und den umliegenden Gemeinden den 1941 eröffneten Trolleybus Luzern mit sieben Linien sowie diverse Autobus-Linien.','Les Verkehrsbetriebe Luzern AG (VBL) sont une entreprise de transports publics du canton de Lucerne. Ils exploitent dans la ville de Lucerne et les communes environnantes le trolleybus de Lucerne, inauguré en 1941, avec sept lignes, ainsi que diverses lignes d''autobus.',NULL,'6005',1061,'https://de.wikipedia.org/wiki/Verkehrsbetriebe_Luzern','Q450886',NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-11-08 06:02:13'),
(242,'Stiftung BioPolis Entlebuch',NULL,NULL,'CHE-375.969.010',1008695,'CH10077924588',1,1,'Escholzmatt',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,dezidierteLobby','nie',60,NULL,NULL,'http://www.biosphaere.ch/de.cfm/company/projects/offer-GesellschaftUBE-Projekte-341974.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Unesco Biosphäre Entebuch Angebote im Bereich Tourismus, Umwewlt, Umweltbildung',NULL,NULL,'6182',1010,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(243,'Industrie- und Handelskammer Zentralschweiz IHZ',NULL,NULL,'CHE-107.249.860',1375410,'CH10068069787',1,1,'Luzern','IHZ',NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.ihz.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Industrie- und Handelskammer Zentralschweiz IHZ vereinigt rund 600 Industrie-, Handels- und Dienstleistungsunternehmen in den Kantonen Luzern, Uri, Schwyz, Ob- und Nidwalden.',NULL,NULL,'6004',1061,NULL,NULL,NULL,'2025-10-02 08:55:56','2013-11-10 14:18:51','2025-10-02 08:55:56'),
(244,'LITRA Informationsdienst öffentlicher Verkehr','Litra - service d''information pour les transports publics','Litra - servizio d''informazione per i trasporti pubblici','CHE-107.805.502',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',33,NULL,NULL,'http://www.litra.ch',NULL,'info_mobilitaet',NULL,NULL,NULL,'https://www.linkedin.com/company/litrainfodienst/',NULL,'Die LITRA hat den Zweck, über Fragen des öffentlichen und des privaten Verkehrs zu informieren und zu den Verkehrsproblemen im Sinne einer zielgerichteten Förderung des öffentlichen Verkehrs Stellung zu nehmen.','La LITRA a pour but d''informer sur les questions relatives aux transports publics et privés et de prendre position sur les problèmes de transport dans le sens d''une promotion ciblée des transports publics.',NULL,'3011',351,'https://de.wikipedia.org/wiki/Informationsdienst_f%C3%BCr_den_%C3%B6ffentlichen_Verkehr','Q1662542',NULL,'2025-10-07 10:50:38','2013-11-10 14:18:51','2025-10-07 10:50:38'),
(246,'AXA Versicherungen AG',NULL,NULL,'CHE-105.788.896',209000,'CH02039288275',1,1,'Winterthur','AXA',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',57,42,NULL,'https://www.axa.ch',NULL,'axa_schweiz','axaswitzerland','axach','axach/','https://www.linkedin.com/company/axaswitzerland/',NULL,'Die AXA Versicherungen AG mit Sitz in Winterthur ist eine Versicherungsgesellschaft und Tochtergesellschaft des französischen Versicherungskonzerns AXA.','AXA Assurances SA, dont le siège se trouve à Winterthour, est une compagnie d''assurance et filiale du groupe d''assurance français AXA.',NULL,'8400',230,'https://de.wikipedia.org/wiki/AXA_Versicherungen','Q300255',NULL,'2024-05-09 16:15:05','2013-11-10 14:18:51','2024-12-06 06:04:42'),
(247,'Osiris Therapeutics Inc., Baltimore',NULL,NULL,NULL,NULL,NULL,0,0,'Columbia MD',NULL,NULL,NULL,NULL,NULL,NULL,240,4,'AG',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',9,NULL,NULL,'http://www.osiris.com/index.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Stammzellenforschung in der Medizin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(248,'Rahn AG',NULL,NULL,'CHE-105.949.194',387590,'CH02030077935',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',9,NULL,NULL,'http://www.rahn-group.com/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203007793&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Kosmetik, Spezialitätenchemie',NULL,NULL,'8050',261,NULL,NULL,NULL,'2023-08-27 21:14:41','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(249,'Fritz Gerber-Stiftung für begabte junge Menschen',NULL,NULL,'CHE-109.829.991',445030,'CH27070026821',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.fritz-gerber-stiftung.ch/fakten-ziele.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Unter dem Namen Fritz-Gerber-Stiftung für begabte junge Menschen besteht mit Sitz in Basel eine Stiftung im Sinne der Art. 80 und folgende des Schweizerischen Zivilgesetzbuches. Die Stiftung bezweckt auf ausschliesslich gemeinnütziger Basis die Förderung begabter junger Menschen mit ständigem Wohnsitz in der Schweiz durch Leistung finanzieller Beiträge zur Aus-, Fort- und Weiterbildung. Sie ist dort tätig, wo für die Erreichung des Stiftungszweckes keine öffentlichen Gelder zur Verfügung stehen.',NULL,NULL,'4001',2701,NULL,NULL,NULL,'2025-06-20 16:01:55','2013-11-10 14:18:51','2025-06-20 16:01:55'),
(250,'Sanitas Krankenversicherung',NULL,NULL,'CHE-105.837.000',390731,'CH02070004690',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','nie',2,NULL,NULL,'https://zh.chregister.ch/cr-portal/auszug/auszug.xhtml?uid=CHE-105.837.000','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000469&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Krankenversicherer',NULL,NULL,'8004',261,NULL,NULL,NULL,'2017-10-31 17:20:09','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(251,'Stiftung VITA Parcours',NULL,NULL,'CHE-109.813.665',333679,'CH02070002516',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',3,66,NULL,'http://www.zurichvitaparcours.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000251&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Gesundheitsvorsorge',NULL,NULL,'8005',261,NULL,NULL,NULL,'2022-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(252,'Swiss School of Public Health (SSPH+), Zürich',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung',NULL,NULL,'DachOrganisation,dezidierteLobby','nie',3,NULL,NULL,'http://www.ssphplus.ch/spip.php?page=ssph_home&lang=de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Swiss School of Public Healthplus fördert und koordiniert auf nationaler Ebene die universitäre Weiterbildung und die damit verbundene Forschung in allen Bereichen von Public Health und Gesundheitsökonomie. Die SSPH+ wurde am 7. Juli 2005 durch eine Vereinbarung zwischen den Universitäten Basel, Bern, Genf, Lausanne, Zürich und der Università della Svizzera italiana gegründet. Im Januar 2008 wurde die SSPH+ in eine Stiftung der sechs Trägeruniversitäten umgewandelt. Im August 2008 wurde die Universität Neuchâtel als neue Partnerin in die Stiftung aufgenommen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-10-09 13:22:21','2013-11-10 14:18:51','2016-10-09 13:22:22'),
(253,'Jerusalem Foundation Switzerland',NULL,NULL,'CHE-101.838.360',277803,'CH02079021225',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,7,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.jerusalemfoundation.org/de/board_content.aspx?MID=751&CID=861&SID=863&ID=2218','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207902122&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Jerusalem Foundation ist sich des universalen Charakters der Stadt ebenso wie ihrer besonderen Stellung als Zentrum jüdischen Lebens bewusst. Daher setzt sie sich an vorderster Front dafür ein, dass Jerusalem sich weiter als eine moderne, offene und lebendige Stadt entwickelt, während ihr kulturhistorisches Erbe erhalten wird.\n\nOhne die Jerusalem Foundation wäre die Stadt nicht wiederzuerkennen: zahlreiche Gemeindezentren, Sportplätze, Parks und Kinderspielplätze, Büchereien, Theater, Museen sowie kulturelle und wissenschaftliche Einrichtungen gehen ebenso auf die Initiativen der Stiftung zurück wie eine große Zahl von Kindertageszentren, Seniorenheimen, Schulen und Neuerungen im Erziehungsbereich schlechthin.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2019-09-12 12:49:14','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(254,'Krebsliga des Kantons Zürich',NULL,NULL,'CHE-107.849.451',312630,'CH02060000934',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.krebsliga-zh.ch/de/ueber_uns/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Krebsliga des Kantons Zürich bietet Krebsbetroffenen und ihren Angehörigen einfach zugängliche Hilfestellung. Wir informieren, beraten und unterstützen. Und wir leisten mit der Unterstützung von ausgewählten Forschungsprojekten einen Beitrag zum Kampf gegen Krebs.',NULL,NULL,'8032',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(255,'vips Vereinigung Pharmafirmen in der Schweiz',NULL,NULL,'CHE-103.880.605',201005,'CH02069005478',1,1,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',1,NULL,NULL,'http://www.vips.ch/','http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206900547&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die vips Vereinigung Pharmafirmen in der Schweiz wurde 1950 gegründet. Der Anteil ihrer Mitgliedfirmen am Pharmamarkt Schweiz beträgt rund 70%; die vips ist der grösste schweizerische Pharmaverband.\n\n\nMitgliedfirmen der vips sind schweizerische Niederlassungen von ausländischen Pharmaunternehmen und produzierende Schweizer Pharmaunternehmen sowie Vertriebsgesellschaften.\n\n\nZiel und Zweck der Vereinigung ist es, die Interessen ihrer Mitgliedfirmen zur Schaffung angemessener Rahmenbedingungen für deren Geschäftstätigkeit im politischen und wirtschaftlichen Umfeld zu vertreten, marktbezogene Dienstleistungen für die Mitgliedfirmen zu erbringen und den Dialog zwischen den vips-Mitgliedfirmen und den Branchenverbänden zu pflegen',NULL,NULL,'6300',1711,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(256,'Institut Suisse de Police (ISP)',NULL,'Istituto Svizzero di Polizia','CHE-105.823.156',288494,'CH64510024466',1,1,'Neuchâtel',NULL,'Schweizerisches Polizei-Institut (SPI); Swiss Police Institute','ISP',NULL,'ISP',NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',105,NULL,NULL,'http://www.institut-police.ch/','http://hrc.ne.ch/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-645-1002446-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Das Schweizerische Polizei-Institut SPI ist eine private Stiftung mit Sitz in Neuenburg, getragen von Bund, Kantonen und Gemeinden. Das Institut bietet in Zusammenarbeit mit den kantonalen und kommunalen Polizeikorps Dienstleistungen im Bereich der polizeilichen Kaderausbildung, Weiterbildung und Ausbildung der Spezialisten an. Es koordiniert und überwacht die Berufsprüfung und die höhere Fachprüfung. Zudem verlegt es Lehrmittel von Polizisten für die Polizisten und engagiert sich in der angewandten Forschung.',NULL,NULL,'2000',6458,NULL,NULL,NULL,'2025-02-09 19:27:13','2013-11-10 14:18:51','2025-02-12 13:37:58'),
(257,'St. Galler Stiftung für Internationale Studien',NULL,NULL,'CHE-110.227.416',277458,'CH32070149833',1,1,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.stgallen-symposium.org/de-ch/About/SSIS/Board-of-Trustees.aspx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die St. Galler Stiftung für Internationale Studien ist eine unabhängige Stiftung in St. Gallen, die sich auf internationale Projekte an der Schnittstelle von Wirtschaft, Gesellschaft und Politik fokussiert. Als Aufsichts- und Begleitorgan des International Students'' Committee (ISC) und des St. Gallen Symposiums begleitet sie die Arbeit des jährlich wechselnden studentischen Organisationskomitees.',NULL,NULL,'9000',3203,NULL,NULL,NULL,'2018-10-11 08:32:19','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(258,'Sicherheitsverbund Schweiz (politische Leitung)',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',104,NULL,NULL,'http://www.news.admin.ch/NSBSubscriber/message/attachments/26018.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Konsultations- und Koordinationsmechanismus des Sicherheitsverbundes Schweiz (KKM SVS) ist geschaffen worden, um den sicherheitspolitischen Dialog zwischen Bund und Kantonen zu verbessern. Damit wurde ein Kernanliegen des sicherheitspolitischen Berichts 20101 des Bundesrates umgesetzt, an dessen Erarbeitung die Kantone beteiligt waren - konkret die Konferenz der Kantonalen Justiz- und Polizeidirektorinnen und -direktoren (KKJPD) und die Regierungskonferenz Militär, Zivilschutz, Feuerwehr (RK MZF).',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2021-01-03 08:52:54'),
(259,'Pulita Putzteam GmbH',NULL,NULL,'CHE-105.571.925',526477,'CH32040482328',1,1,'Reichenburg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',64,NULL,NULL,'http://www.moneyhouse.ch/u/pulita_putzteam_gmbh_CH-320.4.048.232-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Durchführung von Bau-und Gebäudeunterhaltsreinigungen',NULL,NULL,'8864',1345,NULL,NULL,NULL,'2020-03-08 22:13:36','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(260,'Les hôpitaux universitaires de Genève','Les hôpitaux universitaires de Genève',NULL,'CHE-108.907.884',368117,'CH66016779955',1,1,'Genève',NULL,NULL,'HUG',NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'DachOrganisation,LeistungsErbringer','punktuell',5,NULL,NULL,'http://www.hug-ge.ch/','http://ge.ch/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-660-1677995-5&ofrcLanguage=1','Hopitaux_unige',NULL,NULL,NULL,NULL,NULL,'Spitalverbund Universitätsspitäler GE','Fruit d''une tradition pluriséculaire d''excellence en médecine et en sciences, les HUG sont nés en 1995. Regroupant les huit hôpitaux publics genevois ainsi que 40 consultations ambulatoires, réparties sur l''ensemble du canton de Genève, ils constituent le 1er hôpital universitaire de Suisse.',NULL,'1205',6621,NULL,NULL,NULL,'2023-08-26 09:10:31','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(261,'Forum Gesundheit Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.forumgesundheitschweiz.ch/index.php/das-forum.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Forum Gesundheit Schweiz ist ein Zusammenschluss von Persönlichkeiten und Organisationen, die sich für ein qualitativ hoch stehendes und kosteneffizientes Gesundheitswesen mit wettbewerblichen Elementen einsetzen. Das Forum wurde im Frühjahr 2006 gegründet.\nUnsere Ziele\n\nDem Forum liegt ein qualitativ hoch stehendes, aber finanzierbares Gesundheitswesen am Herzen. Es will dazu beitragen, einen breit abgestützten Konsens über eine wirkungsvolle Eindämmung der Kostenexplosion im Gesundheitswesen zu schaffen, indem es marktwirtschaftliche Lösungen in die Diskussion einbringt.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-20 15:50:30','2013-11-10 14:18:51','2025-06-20 15:50:30'),
(262,'Association des Amis de la Fondation AGIR','Association des Amis de la Fondation AGIR',NULL,'CHE-115.695.374',981886,'CH66003950102',1,1,'Les Acacias',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','punktuell',6,NULL,NULL,'http://www.monetas.ch/htm/647/de/Firmendaten-Association-des-Amis-de-la-Fondation-AGIR.htm?subj=2140702',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Organtransplantation: Financer et réaliser diverses actions en faveur du don et de la transplantation d''organes; aider les malades insuffisants rénaux de la région genevoise; soutenir le développement de projets humanitaires en lien avec la transplantation.',NULL,NULL,'1227',6621,NULL,NULL,NULL,'2017-07-10 18:15:39','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(263,'Schweizerischer Hebammenverband','Fédération suisse des sages-femmes, FSSF',NULL,'CHE-108.141.998',NULL,NULL,0,0,'Bern','SHV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',73,NULL,NULL,'http://www.hebamme.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Schweizerischer Hebammenverband',NULL,NULL,'3007',2581,NULL,NULL,NULL,'2024-08-14 17:25:18','2013-11-10 14:18:51','2024-08-14 17:25:18'),
(264,'ARGOS, Association d''aide aux personnes toxico-dépendantes',NULL,NULL,NULL,NULL,NULL,0,0,'Genève',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',3,12,NULL,'http://www.argos.ch/concept-d-intervention/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Suchtbekämpfung: Argos a pour but la création et la gestion de dispositifs destinés à la prise en charge de personnes toxicodépendantes.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(265,'Fussverkehr Schweiz','Mobilité piétonne Suisse',NULL,'CHE-105.921.356',1046072,'CH02060016005',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',43,NULL,NULL,'http://www.fussverkehr.ch/ueber-uns/',NULL,'fussverkehr','fussverkehr',NULL,'mobilite.pietonne/','https://www.linkedin.com/company/fussverkehr/',NULL,'Der Verein wahrt die Interessen der Fussgängerinnen und Fussgänger und stärkt ihre Stellung im Siedlungs- und Verkehrsraum. Der Verein ist ein Fachverband mit gemeinnützigem Charakter, parteipolitisch und konfessionell neutral. Als Fachorganisation gemäss Bundesgesetz über die Fuss- und Wanderwege (FWG) unterstützt sie die öffentliche Hand bei dessen Vollzug.','L''association défend les intérêts des piétons et renforce leur position dans l''espace urbain et de circulation. L''association est une association spécialisée à caractère d''utilité publique, neutre sur le plan politique et confessionnel. En tant qu''organisation spécialisée selon la loi fédérale sur les chemins pour piétons et les chemins de randonnée pédestre (LCPR), elle soutient les pouvoirs publics dans l''application de celle-ci.',NULL,'8032',261,'https://de.wikipedia.org/wiki/Fussverkehr_Schweiz','Q1475397',NULL,'2025-08-20 20:54:33','2013-11-10 14:18:51','2025-08-20 20:54:33'),
(266,'Paul Grüninger Stiftung',NULL,NULL,'CHE-110.407.065',443336,'CH32070454974',1,1,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,5,'Stiftung','0110',7,'EinzelOrganisation','nie',35,NULL,NULL,'http://www.paul-grueninger.ch/pagine/stiftung/foerderprogramm.html','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3207045497&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Rehabilitierung des ehemaligen Polizeichefs Grüninger, Förderung der Forschung etc.',NULL,NULL,'9000',3203,NULL,NULL,NULL,'2023-03-02 18:26:28','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(267,'Editions D + P (Démocrate + Pays)',NULL,NULL,NULL,NULL,NULL,0,0,'Delémont',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG',NULL,NULL,'EinzelOrganisation','nie',48,NULL,NULL,'http://democrate.ch/node/7','http://democrate.ch/node/7',NULL,NULL,NULL,NULL,NULL,NULL,'Edition de journaux et périodiques, ainsi que toutes activités en rapport avec les médias.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(268,'Fiduconsult SA',NULL,NULL,'CHE-105.821.588',58170,'CH21701324103',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',58,NULL,NULL,'http://www.fiduconsult.ch/','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0132410-3&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Depuis 1974, FIDUCONSULT propose son savoir-faire dans tous les domaines de la révision et de l''expertise comptable, fiscale et juridique. Treuhand: FIDUCONSULT réunit plusieurs sociétés affiliées présentes dans cinq cantons et sur sept sites, avec un centre décisionnel basé à Fribourg, à proximité des deux régions linguistiques.',NULL,NULL,'1700',2196,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(269,'Groupe E SA',NULL,NULL,'CHE-108.954.582',60936,'CH21701304880',1,1,'Granges-Paccot',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'AG','0106',3,'DachOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'https://www.groupe-e.ch/de','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0130488-0&ofrcLanguage=1','groupe_e','groupe_e',NULL,'groupe.e.ch/','https://www.linkedin.com/company/groupe-e/',NULL,'Groupe E ist ein Schweizer Energieversorgungsunternehmen mit Hauptsitz in Granges-Paccot (Kanton Freiburg).','Groupe E est une entreprise suisse d''approvisionnement en énergie dont le siège se trouve à Granges-Paccot (canton de Fribourg).',NULL,'1763',2198,'https://de.wikipedia.org/wiki/Groupe_E','Q1547733',NULL,'2025-08-25 00:00:00','2013-11-10 14:18:51','2025-08-27 10:09:26'),
(270,'La Liberté médias SA',NULL,NULL,'CHE-268.629.206',1024187,'CH21735478008',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation','nie',48,NULL,NULL,'www.laliberte.ch','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-3547800-8&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'But: éditer et développer le journal d''information LA LIBERTE, dont la mission et les objectifs sont fixés dans sa charte rédactionnelle (cf. statuts pour but complet).',NULL,NULL,'1700',2196,NULL,NULL,NULL,'2020-03-06 14:14:48','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(271,'JPF Holding S.A., Bulle',NULL,NULL,'CHE-101.947.606',270390,'CH21704310851',1,1,'Bulle','JPF',NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',51,NULL,NULL,'http://www.jpf.ch/de/index.php','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0431085-1&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Tiefbau\n  	\nStrassen, Eisenbahnlinien, Stahlbeton, Planierungsarbeiten, Rohrleitungen, Brücken, stellen Bereiche dar, in welchen die JPF-Gruppe eine einzigartige Erfahrung und einen soliden Ruf erworben hat. Im Tiefbau, dem Hauptsektor des Unternehmens, beruht die Leistungsfähigkeit auf der Vielseitigkeit der Arbeitsgruppen.\n\nJPF Construction SA hat an erstrangigen Bauvorhaben wie der Sanierung und dem Ausbau von Tunnels sowie Eisenbahnlinien im Rahmen von Rail 2000 oder an der Realisierung der Autobahnen A12, A5 und A1, und kürzlich auch am Bau der Lausanner Metrobahn M2 teilgenommen. Das Unternehmen hat die technische Leitung für wichtige Bauabschnitte übernommen, die es selbständig oder im Konsortium verwirklicht hat.',NULL,NULL,'1630',2125,NULL,NULL,NULL,'2024-05-01 15:43:16','2013-11-10 14:18:51','2024-05-01 15:43:16'),
(272,'Liebherr Maschinen Bulle AG',NULL,NULL,'CHE-102.412.259',107563,'CH21704302225',1,1,'Bulle',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',87,NULL,NULL,'http://www.liebherr.com/de-DE/35275.wfw','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0430222-5&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Das Familienunternehmen Liebherr wurde im Jahr 1949 von Hans Liebherr gegründet. Der große Erfolg des ersten mobilen, leicht montierbaren und preisgünstigen Turmdrehkrans bildete das Fundament des Unternehmens. Heute zählt Liebherr nicht nur zu den größten Baumaschinenherstellern der Welt, sondern ist auch auf vielen anderen Gebieten als Anbieter technisch anspruchsvoller, nutzenorientierter Produkte und Dienstleistungen anerkannt. Inzwischen ist das Unternehmen zu einer Firmengruppe mit rund 38.000 Beschäftigten in über 130 Gesellschaften auf allen Kontinenten angewachsen.\n\nBulle: Dieselmotoren für Baumaschinen, Komponenten der Antriebstechnik',NULL,NULL,'1630',2125,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(273,'Société coopérative paysanne de cautionnement du canton de Fribourg','Société coopérative paysanne de cautionnement du canton de Fribourg',NULL,'CHE-102.346.444',255178,'CH21701500338',1,1,'Granges-Paccot',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Genossenschaft','0108',5,'EinzelOrganisation','nie',85,NULL,NULL,NULL,'https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0150033-8&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Bäuerliche Bürgschaftsgenossenschaft des Kantons Freiburg (Société paysanne de cautionnement du Canton de Fribourg), Route de Chantemerle 41, Granges-Paccot, Case postale 918, 1700 Fribourg. Vom Bund anerkannte bäuerliche Bürgschaftsgenossenschaft',NULL,NULL,'1763',2198,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(274,'Amis de la Fille-Dieu',NULL,NULL,NULL,NULL,NULL,0,0,'Romont',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','nie',44,NULL,NULL,'http://www.fille-dieu.ch/index.php/fr/les-amis-de-la-fille-dieu-11/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Renovation der Klosterkirche',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2014-09-16 00:00:00'),
(275,'cemsuisse Verband der Schweizerischen Cementindustrie','Cemsuisse Association de l''industrie suisse du ciment','Cemsuisse Associazione dell''industria svizzera del cemento)','CHE-108.028.072',822438,'CH03560357012',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',51,NULL,NULL,'http://www.cemsuisse.ch/cemsuisse/ueberuns/index.html?lang=de','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356035701&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0','cemsuisse',NULL,NULL,NULL,'https://www.linkedin.com/company/cemsuisse/?originalSubdomain=ch',NULL,'cemsuisse, der Verband der Schweizerischen Cementindustrie, nimmt die Interessenvertretung der Industrie auf nationaler und internationaler Ebene gegenüber Politik, Verwaltung, Verbänden, Medien und Öffentlichkeit wahr.','cemsuisse, l''Association suisse de l''industrie du ciment, assure la représentation des intérêts de l''industrie au niveau national et international auprès des milieux politiques, de l''administration, des associations, des médias et du public.',NULL,'3011',351,NULL,NULL,NULL,'2025-10-07 10:57:39','2013-11-10 14:18:51','2025-10-07 10:57:39'),
(276,'Stiftung Bieler Kommunikationstage','Fondation Journées Biennoises de la Communication',NULL,'CHE-109.816.221',670600,'CH07370142786',1,1,'Biel/Bienne',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',62,NULL,NULL,'http://www.comdays.ch/de/actu.php','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0737014278&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Seit 2010 keine Wirkung mehr. Wirs aber im Stade de Bienne neu überlegt.\n\nDie Stiftung Bieler Kommunikationstage wurde 2001 im Hinblick auf das zehnjährige Jubiläum des Bundesamtes für Kommunikation (BAKOM) zusammen mit der Stadt Biel gegründet, um ab 2002 eine Tagung zum Thema "Kommunikation" zu veranstalten. Die Veranstaltung sollte eine Lücke in der schweizerischen Konferenzlandschaft füllen und zugleich die Stadt Biel ihren strategischen Zielen für eine langfristige Entwicklungsplanung in Richtung Dienstleistungsstadt näher bringen.',NULL,NULL,'2503',371,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(277,'Verein Eidgenössisches Turnfest 2013',NULL,NULL,'CHE-115.611.880',1106970,'CH03660545256',1,1,'Biel/Bienne',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'LeistungsErbringer','nie',66,NULL,NULL,'http://www.etf-ffg2013.ch/','http://www.moneyhouse.ch/u/verein_eidgenossisches_turnfest_2013_CH-036.6.054.525-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein bezweckt die Durchführung des Eidgenössischen Turnfestes 2013 in Biel-Magglingen. Er unternimmt alles, was für eine erfolgreiche Durchführung des Anlasses notwendig ist.',NULL,NULL,'2504',371,NULL,NULL,NULL,'2022-10-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(278,'Tourismus Jura & Drei-Seen-Land','Jura & Trois-Lacs',NULL,NULL,NULL,NULL,0,0,'Neuchâtel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',60,NULL,NULL,'http://www.juradreiseenland.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die touristische Destination "Jura & Drei-Seen-Land" besteht aus folgenden Tourismusbüros:\n\n    Tourisme neuchâtelois\n    Jura Tourisme\n    Jura bernois Tourisme\n    Region Solothurn Tourismus\n    Tourismus Biel Seeland\n    Murten Tourismus\n    Estavayer / Payerne Tourismus\n    Yverdon-les-Bains Région',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-16 00:00:00','2013-11-10 14:18:51','2022-10-16 19:53:58'),
(279,'Neue Helvetische Gesellschaft NHG','Nouvelle Société Helvétique','Nuova Società Elvetica','CHE-378.066.305',NULL,NULL,0,0,'Aarwangen','NHG',NULL,'NSH',NULL,'NSE',NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,DachOrganisation,dezidierteLobby','punktuell',35,NULL,NULL,'http://www.nhg.ch/de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Neue Helvetische Gesellschaft (nachstehend NHG) will den Zusammenhalt des Landes stärken, indem sie die Verständigung fördert, identitätsstiftende Ziele formuliert und beiträgt zur Beanwortung von wichtigen Fragen, die sich landesintern oder in der Beziehung zum Ausland stellen.','La Nouvelle Société Helvétique (ci-après NSH) veut renforcer la cohésion du pays en favorisant la compréhension, en formulant des objectifs identitaires et en contribuant à répondre à des questions importantes qui se posent à l''intérieur du pays ou dans ses relations avec l''étranger.',NULL,'4912',321,NULL,NULL,NULL,'2023-07-25 22:58:43','2013-11-10 14:18:51','2023-07-25 22:58:43'),
(281,'Verein PPP (Public Private Partnership) Schweiz','Association PPP Suisse',NULL,NULL,NULL,NULL,0,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',35,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Am 19. Mai 2006 gründeten Vertreter der Schweiz. Eidgenossenschaft, einzelner Kantone und Städte sowie der Wirtschaft den Verein PPP Schweiz.\n\nSeine Ziele sind:\n\n    PPP als mögliches Realisierungsmodell für die Erfüllung öffentlicher Aufgaben in der Schweiz zu verankern und die Standardisierung zu fördern.\n    PPP als Qualitätsstandard der Zusammenarbeit von Staat und Wirtschaft zu positionieren, der die Wahrnehmung der öffentlichen Interessen garantiert und zu einer Win-win-Situation für Staat und Wirtschaft führt und so nachhaltige Projekterfolge sichert.\n    Die öffentliche Hand zu motivieren, PPP als methodische Grundlage anzuwenden, um die immer komplexer werdenden Aufgabenstellungen zu überprüfen und zu optimieren.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-16 00:00:00','2013-11-10 14:18:51','2022-10-16 19:53:58'),
(282,'Ospita - Die Schweizer Gesundheitsunternehmen',NULL,NULL,NULL,NULL,NULL,0,0,'Bern 14','PKS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',5,NULL,NULL,'https://www.ospita.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ospita bezweckt den Zusammenschluss medizinischer Leistungserbringer, die sich in unternehmerischer Art und Weise im Gesundheitswesen betätigen. Dazu gehören insbesondere Privatspitäler und weitere eigenständige Schweizer Gesundheitsunternehmen. Ehemals: Privatkliniken Schweiz.',NULL,NULL,'3000',NULL,NULL,NULL,NULL,'2025-06-10 11:17:52','2013-11-10 14:18:51','2025-06-10 11:17:52'),
(283,'Aktion Medienfreiheit',NULL,NULL,NULL,NULL,NULL,0,0,'Zollikon',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',62,NULL,NULL,'http://www.medienfreiheit.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Lobbyorganisation für:\n- die Förderung einer freiheitlichen Medienordnung,\n- die Schaffung von mehr Wettbewerb in der Medienbranche,\n- den Kampf gegen unnötige staatliche Interventionen und Subventionen im Bereich der Medien,\n- die Stärkung und Umsetzung der medialen Meinungsvielfalt in der Schweiz.','Organisation de lobbying pour :\n- la promotion d''un ordre médiatique libéral,\n- la création d''une plus grande concurrence dans le secteur des médias,\n- la lutte contre les interventions et les subventions inutiles de l''Etat dans le domaine des médias,\n- le renforcement et la mise en œuvre de la diversité des opinions dans les médias en Suisse.',NULL,NULL,NULL,NULL,NULL,NULL,'2025-09-01 20:58:46','2013-11-10 14:18:51','2025-09-01 20:58:46'),
(284,'Kanton Tessin','Canton du Tessin','Repubblica e Cantone Ticino',NULL,NULL,NULL,0,0,'Bellinzona','TI',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',13,NULL,NULL,'https://www4.ti.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'6500',NULL,NULL,NULL,NULL,'2025-02-13 09:19:59','2013-11-10 14:18:51','2025-02-13 09:19:59'),
(285,'Novartis International AG',NULL,NULL,'CHE-106.054.058',390865,'CH27030022781',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',1,NULL,NULL,'http://www.novartis.ch/media/contact.shtml','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2703002278&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt die Leitung des Novartis-Konzerns und Erbringung von Dienstleistungen, insbesondere auch die Beratung administrativer, finanzieller, rechtlicher, technischer und wissenschaftlicher Art.','La société a pour objet la gestion du groupe Novartis et la fourniture de services, notamment de conseils administratifs, financiers, juridiques, techniques et scientifiques.',NULL,'4056',2701,NULL,NULL,NULL,'2016-10-12 13:40:27','2013-11-10 14:18:51','2024-10-28 20:18:49'),
(287,'foraus - Forum Aussenpolitik - Forum de politique étrangère',NULL,NULL,'CHE-251.735.320',1237626,'CH03660648765',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','punktuell',70,NULL,NULL,'http://www.foraus.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Think Tank foraus entwickelt wissenschaftlich fundierte Empfehlungen für aussenpolitische EntscheidungsträgerInnen und die breite Öffentlichkeit, um so die Lücke zwischen Wissenschaft und Politik zu schliessen. Als Grassroots-Organisation gestützt auf ein schweizweites und internationales Netzwerk von Ehrenamtlichen ist foraus das Sprachrohr für junge DenkerInnen, die die Aussenpolitik von morgen prägen wollen.','Véritable pont entre la recherche et la politique, le think tank foraus développe des recommandations sur la politique étrangère pour les décideurs politiques et le grand public. Grâce à son modèle unique de participation bénévole, le foraus est devenu la plateforme nationale de référence pour les passionné·e·s de politique étrangère qui souhaitent influencer les choix de demain.',NULL,'3011',351,NULL,NULL,NULL,'2023-08-26 09:10:31','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(288,'INTERPHARMA',NULL,NULL,'CHE-107.982.682',91068,'CH27060001665',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',1,NULL,NULL,'https://www.interpharma.ch/ueber-uns/vision-mission/','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2706000166&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0','interpharma_ch',NULL,NULL,NULL,'https://www.linkedin.com/company/interpharma/',NULL,'Interpharma ist der Verband der forschenden pharmazeutischen Firmen der Schweiz und wurde 1933 als Verein mit Sitz in Basel gegründet. Die Kommunikationsstelle der Interpharma informiert die Öffentlichkeit über die Belange, welche für die forschende Pharma-Industrie in der Schweiz von Bedeutung sind sowie über den Pharmamarkt Schweiz, das Gesundheitswesen und die biomedizinische Forschung.','Interpharma est l''association des entreprises pharmaceutiques suisses pratiquant la recherche. Fondée en 1933, elle a son siège à Bâle. Le service de communication d''Interpharma informe le public sur les questions importantes pour l''industrie pharmaceutique pratiquant la recherche en Suisse ainsi que sur le marché pharmaceutique suisse, le système de santé et la recherche biomédicale.',NULL,'4051',2701,NULL,NULL,NULL,'2025-05-19 09:29:28','2013-11-10 14:18:51','2025-05-19 09:29:28'),
(289,'santésuisse',NULL,NULL,'CHE-115.055.306',955844,'CH24160085854',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',2,NULL,NULL,'http://www.santesuisse.ch/de/dyn_output.html?content.void=3271&navid=121',NULL,'santesuisse',NULL,NULL,NULL,NULL,NULL,'Wir sind die führende Branchenorganisation in der Schweizer Gesundheitspolitik.\nWir sind für die gesamte Branche der Krankenversicherer in allen Regionen der Schweiz repräsentativ.\nWir vertreten 7,2 Millionen Versicherte.\nWir haben eine grosse gesundheitspolitische Sachkompetenz.',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2023-07-21 15:20:56','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(290,'Schweizerische Aussenwirtschaftsförderung OSEC','Office Suisse d''Expansion Commerciale OSEC',NULL,NULL,NULL,NULL,0,0,'Zürich, Lausanne, Lugano',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',40,NULL,NULL,'http://aboutus.osec.ch/de/content/wer-wir-sind',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Osec, 1927 als nichtgewinnorientierter und halböffentlicher Verein in Lausanne gegründet, informiert, berät und begleitet Schweizer und Liechtensteiner KMU bei ihren internationalen Geschäftsvorhaben. Sie vernetzt Unternehmen, Wissensträger sowie private und öffentliche Organisationen weltweit und ermöglicht so eine schlagkräftige Aussenwirtschaftsförderung.\n\nNeben der Exportförderung kümmert sich die Osec seit anfangs 2008 auch um die nationale Standortpromotion der Schweiz im Ausland sowie um die Importförderung zugunsten ausgewählter Entwicklungs- und Transitionsländer.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 00:00:00','2013-11-10 14:18:51','2022-09-20 08:55:50'),
(291,'Schweizer Obstverband','Fruit-Union Suisse','Associazione Svizzera Frutta','CHE-105.971.331',166210,'CH17060000288',1,1,'Zug','SOV','Swissfruit','FUS',NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',84,NULL,NULL,'http://www.swissfruit.ch/m/mandanten/239/index.html','http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1706000028&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Verband der schweizerischen Obstproduzenten',NULL,NULL,'6300',1711,NULL,NULL,NULL,'2024-04-12 21:29:38','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(292,'Schweizerischer Versicherungsverband (SVV)','Association Suisse d'' Assurances (ASA)','Associazione Svizzera d''Assicurazioni (ASA)','CHE-112.938.310',837580,'CH02060010092',1,1,'Zürich','SVV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',57,NULL,NULL,'http://www.svv.ch/de/der-svv/portraet','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206001009&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Versicherungsverband (SVV) ist die Dachorganisation der privaten Versicherungswirtschaft. Dem SVV sind kleine und grosse, national und international tätige Erst- und Rückversicherer angeschlossen.\n\nEr setzt sich für die Erhaltung und Förderung einer liberalen und sozialverträglichen Markt- und Wettbewerbsordnung ein.\n\nDer SVV ist insbesondere in folgenden Bereichen tätig:\n\nSoziale Sicherheit (berufliche Vorsorge, Lebensversicherung, Krankenversicherung, Unfallversicherung)\nVersicherungsrecht und Versicherungsaufsicht\nWettbewerb und Regulierung\nWirtschafts- und Steuerpolitik\nKlima und Umwelt\nPrävention\nBildung\nMit einer aktiven Öffentlichkeitsarbeit fördert der SVV das Vertrauen in die Versicherungswirtschaft. Durch gemeinsames Fachwissen, gemeinsame Aktivitäten und den Austausch von branchenrelevanten Informationen stiftet er Nutzen für seine Mitglieder. Ausserdem sorgt er für eine umfassende, zielgerichtete und modular aufgebaute Aus- und Weiterbildung und setzt sich mit verschiedenen Massnahmen für die Prävention von Schäden ein.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2022-11-11 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(293,'Solidar Suisse','Solidar Suisse / Oeuvre suisse d''entraide ouvrière OSEO',NULL,'CHE-105.829.963',677036,'CH02060006831',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',68,NULL,NULL,'http://www.solidar.ch/portrait-solidar-suisse.html','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000683&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Solidar Suisse (Schweizerisches Arbeiterhilfswerk) setzt sich für eine sozial, politisch und ökonomisch gerechtere Gesellschaft ein: Mit über 50 Projekten in 12 Ländern und mit Kampagnen in der Schweiz. Solidar suisse engagiert sich für faire Arbeitsbedingungen, Existenz sichernde Einkommen, Demokratie und die Einhaltung der Menschenrechte. Bei Katastrophen leidert wes zudem humanitäre Hilfe.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2025-09-08 20:23:28','2013-11-10 14:18:51','2025-09-08 20:23:28'),
(294,'Schweizerischer Fussballverband','Association Suisse de Football','Associazione Svizzera di Football','CHE-112.610.602',1052592,'CH03660533488',1,1,'Muri b. Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',66,65,NULL,'http://www.football.ch/de/start.aspx','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0366053348&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Fussballverband bezweckt: die Förderung, Regelung und Kontrolle des Fussballs in der Schweiz, wobei Fairplay und erzieherische, kulturelle und integrative Kraft des Fussballs besonders berücksichtigt werden sollen; die körperliche Betätigung der Schweizer Bevölkerung, insbesondere der Jugend; die Wahrung der Gesamtinteressen seiner Mitglieder; den Ausgleich der Interessen und die Schlichtung von Differenzen unter seinen Mitgliedern; die Organisation und Durchführung von nationalen Wettbewerben in Zusammenarbeit mit den Abteilungen und Regionalverbänden; die Pflege nationaler und internationaler Beziehungen im Zusammenhang mit dem organisierten Sport, insbesondere des Fussballs, in all seinen Formen.',NULL,NULL,'3074',356,NULL,NULL,NULL,'2025-09-02 11:07:20','2013-11-10 14:18:51','2025-09-02 11:07:20'),
(295,'Hausärzte Schweiz, Berufsverband der Haus- und Kinderärztinnen Schweiz','Association des médecins de famille et de l''enfance Suisse (MFE)',NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,'MFE',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',4,NULL,NULL,'http://www.hausaerzteschweiz.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesundheit der Bevölkerung, ihre Lebensqualität sowie die Kosten und die Qualität der Gesundheitssysteme sind vom Stellenwert der Hausarztmedizin abhängig. Um der Schweizer Hausarztmedizin mehr Geltung zu verschaffen und die berufspolitischen Ziele gemeinsam anzugehen, haben die drei Fach-\ngesellschaften der Grundversorger - die Allgemeinmediziner (SGAM), die Internisten (SGIM) und die Pädiater (SGP) - im Jahr 2009 den Berufsverband "Hausärzte Schweiz" gegründet, dem heute rund 5500 Schweizer Haus- und Kinderärzte angehören.\n"Hausärzte Schweiz" setzt sich mit seiner strategischen Standespolitik für die  Hausarztmedizin ein. Durch gezieltes Lobbying vertritt der Verband seine Interessen  bei den Entscheidungsträgern in Politik und beim Bund. Zentrale Projekte des Berufsverbands sind die eidgenössische Volksinitiative "Ja zur Hausarztmedizin!" und der Masterplan. Weitere zentrale Themen des Verbands sind die Qualität, eHealth und die Interprofessionalität.','Une médecine de famille forte est avantageuse pour tous. Les systèmes de santé reposant sur les médecins de famille sont meilleurs et moins onéreux que ceux qui ne s''appuient que sur la médecine de spécialistes. Une médecine de famille faible aurait des conséquences désastreuses sur le système de santé. La santé de la population, sa qualité de vie ainsi que les coûts et la qualité des systèmes de santé dépendent directement de l''importance qui lui est accordée.\nLes trois sociétés des médecins de premier recours - spécialistes en médecine générale (SSMG), en médecine interne (SSMI) et en pédiatrie (SSP) - ont créé l''association professionnelle "Médecins de famille Suisse" le 17 septembre 2009 afin de conférer plus de poids à la médecine de famille menacée en Suisse et de défendre ensemble, à l''avenir, leurs objectifs en matière de politique professionnelle. L''association s''engage pour la promotion et le renforcement de la médecine de famille et défend les intérêts de ses membres.',NULL,'3011',NULL,NULL,NULL,NULL,'2025-06-17 13:28:23','2013-11-10 14:18:51','2025-06-17 13:28:23'),
(296,'Die Schweizerische Post AG','La Poste Suisse SA','La Posta Svizzera SA','CHE-109.030.864',418100,'CH03580172177',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',36,16,NULL,'http://www.post.ch/','http://www.moneyhouse.ch/u/die_schweizerische_post_ag_CH-035.8.017.217-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt gemäss Art. 3 Postorganisationsgesetz im In- und Ausland folgende Dienste zu erbringen: Beförderung von Postsendungen und Stückgütern in standardisierten Behältnissen sowie damit zusammenhängende Dienstleistungen; folgende Finanzdienstleistungen: Dienstleistungen des Zahlungsverkehrs, Entgegennahmen von Kundengeldern, Konto- und damit zusammenhängende Dienstleistungen, Anlagen im eigenen Namen, weitere Finanzdienstleistungen im Auftrag Dritter; Dienste im regionalen Personenverkehr sowie damit zusammenhängende Dienstleistungen. Die Gesellschaft kann die Erfüllung der Verpflichtung zur Grundversorgung mit Postdiensten sowie mit Dienstleistungen des Zahlungsverkehrs an direkt kontrollierte Postkonzerngesellschaften übertragen, sofern sie an diesen die kapital- und stimmenmässige Mehrheit hält und sofern diese nicht schon von Gesetzes wegen den Postkonzerngesellschaften obliegen. Nicht übertragen wird die Berichterstattung zur Grundversorgung. Die Gesellschaft verpflichtet die erfüllenden Postkonzerngesellschaften, die hierfür nötigen Datengrundlagen zu schaffen und der Gesellschaft zur Verfügung zu stellen. Die Gesellschaft kann die von der Verpflichtung zur Grundversorgung mit Postdiensten und Dienstleistungen des Zahlungsverkehrs verursachten Nettokosten mit Transferzahlungen zwischen einzelnen Unternehmensbereichen und Postkonzerngesellschaften ausgleichen. Die Vorgaben bezüglich des Quersubventionierungsverbots innerhalb des Konzerns sind zu beachten. Sie kann alle Rechtsgeschäfte tätigen, die dem Unternehmungszweck dienen, namentlich: Grundstücke erwerben und veräussern, Gesellschaften gründen, sich an Gesellschaften beteiligen, Mittel am Geld- und Kapitalmarkt aufnehmen und anlegen. Sie darf jedoch keine Kredite und Hypotheken an Dritte vergeben. Sie kann im Rahmen der üblichen Nutzung ihrer Infrastruktur Dienstleistungen im Auftrag Dritter erbringen.',NULL,NULL,'3030',351,NULL,NULL,NULL,'2025-08-20 20:40:57','2013-11-10 14:18:51','2025-08-20 20:40:57'),
(297,'Swiss Textiles Textilverband Schweiz',NULL,NULL,'CHE-105.942.499',415505,'CH02069002139',1,1,'Zürich','TVS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',101,NULL,NULL,'http://www.swisstextiles.ch/cms/front_content.php?idcat=2&lang=1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Rund 200 Unternehmen der Textil- und Bekleidungsindustrie bündeln ihre Interessen im TVS Textilverband Schweiz. Der Verband engagiert sich für die übergeordneten Interessen der Mitgliedunternehmen, die auf Grund der historisch gewachsenen Strukturen unterschiedlichen Bereichen angehören. Allen gemeinsam ist das Anliegen, ihre hochwertigen Produkte und Dienstleistungen von einem starken Brand im nationalen sowie internationalen Markt verankert zu wissen. Swiss Textiles, diese Marke steht für innovative, hochwertige Produkte sowie Dienstleistungen und wird als Gütesiegel in der ganzen Welt geschätzt.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(298,'Stiftung UNIA',NULL,NULL,'CHE-103.809.725',430102,'CH13000021555',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',53,NULL,NULL,'http://www.unia.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1300002155&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt Arbeitnehmende und RentnerInnen, insb. Mitglieder der Gewerkschaft UNIA in folgenden Bereichen zu unterstützen: a) Rechtshilfe: Durchsetzung von Ansprüchen und Forderungen gegenüber Dritten zwecks Verhinderung wirtschaftlicher und sozialer Nachteile, insbesondere im Zusammenhang mit Alter, Invalidität, Todesfall, Unfall, Krankheit, Arbeitslosigkeit, Arbeitsverhältnis sowie Konsumenten- und Familienschutz, alles zugunsten von unselbständig Erwerbstätigen, von RentenbezügerInnen sowie Arbeitslosen. Die Stiftung bietet Rechtshilfe in diesem Rahmen grundsätzlich unentgeltlich an. Der Stiftungsrat kann in einem Reglement festlegen, in welchen Fällen im Maximum kostendeckende Beiträge von den Destinatären verlangt werden können. b) Weiterbildung: Weiterbildung in sozialen, ökonomischen, beruflichen und kulturellen Belangen. c) Hilfe in Härte- und Notfällen: Hilfe in Fällen von Arbeitslosigkeit, Krankheit, Unglücksfällen oder anderen sozialen Notsituationen nach in einem Reglement vom Stiftungsrat festzulegenden Kriterien. d) Förderung des sozialen Wohnungsbaus: Förderung des Baus von Wohnungen mit moderaten Mieten. e) Ferienvergünstigungen: Vergünstigung von Ferien namentlich durch die Abgabe von Feriengutscheinen oder Reka-Checks zur Förderung des Verbringens von Ferien und Freizeit, insbesondere für Familien und für die Schaffung von Erholungsgelegenheiten zu sozialen Bedingungen. f) Eindämmung der Arbeitlosigkeit und Unterstützung anderer Institutionen: Geeignete Massnahmen zur Eindämmung der Arbeitslosigkeit und Unterstützung anderer steuerbefreiter sozialer Institutionen namentlich im Umfeld der Gewerkschaft UNIA. Der Stiftungsrat kann die vorstehenden Stiftungszwecke und das Verhältnis dieser Zwecke zueinander in einem oder mehreren Reglementen näher ausführen. Die Stiftung verfolgt keine kommerziellen Zwecke, erstrebt keinen Gewinn und erbringt keine Leistungen, die in direktem Zusammenhang mit der gewerkschaftlichen Interessenvertretung stehen.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2022-09-27 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(299,'Perron Campaigns GmbH',NULL,NULL,'CHE-287.285.366',1548397,'CH02040783257',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',18,NULL,NULL,'http://perroncampaigns.ch/about.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Public Relations und Kampagnen-Agentur von Politikwissenschafter Louis Perron',NULL,NULL,'8008',261,NULL,NULL,NULL,'2022-08-09 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(300,'Schweizerische Wettbewerbsvereinigung in Liquidation',NULL,NULL,'CHE-104.005.250',248027,'CH02069004461',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation','nie',18,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206900446&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206900446&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Bezweckt die Beratung und die Stellungnahme in Wettbewerbsfragen im privaten, gemischtwirtschaftlichen und öffentlichen Bereich, insbesondere inbezug auf das Kartellrecht und befasst sich weiter mit den Fragen der Arbeitgeber- und Arbeitnehmer-Koalitionen.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(302,'Schweizerische Akademie der Medizinischen Wissenschaften (SAMW)','Académie Suisse des Sciences Médicales','Accademia Svizzera delle Scienze Mediche','CHE-105.824.842',292849,'CH27070013606',1,1,'Bern','SAMW',NULL,'ASSM',NULL,'ASSM',NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','punktuell',4,NULL,NULL,'https://www.samw.ch/de.html','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2707001360&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die SAMW unterstützt eine hohe Qualität der Medizin in all ihren Facetten. Sie setzt sich ein für die Stärkung der Forschung und für den Transfer des Wissens in Aus-, Weiter- und Fortbildung und nimmt eine führende Rolle wahr in der umfassenden Reflexion über die Zukunft der Medizin. Im Sinne der Früherkennung antizipiert sie mögliche Entwicklungen und deren Auswirkungen auf Individuen, Gesellschaft und Medizin. Sie engagiert sich bei der Klärung ethischer Fragen im Zusammenhang mit neuen medizinischen Erkenntnissen, stellt ethische Richtlinien auf und setzt sich für deren Umsetzung ein. Die SAMW steht im Dialog mit der Gesellschaft: Sie nimmt Anliegen, Hinweise und Ängste aus der Bevölkerung auf, bemüht sich aktiv um Informationsvermittlung und steht für Experten- und Beratungstätigkeit zuhanden von Politik und Behörden zur Verfügung. Im Rahmen der Akademien der Wissenschaften Schweiz engagiert sich die SAMW in der Hochschul-, Wissenschafts- und Bildungspolitik; durch aktive Mitarbeit und Mitgliedschaft in verschiedenen internationalen Organisationen pflegt sie auch den internationalen Informations- und Erfahrungsaustausch.','L''ASSM soutient une médecine de haute qualité sous toutes ses facettes. Elle s''engage pour le renforcement de la recherche et pour le transfert du savoir dans la formation prégraduée, postgraduée et continue et assume un rôle de leader dans la réflexion globale sur l''avenir de la médecine. Dans un esprit de détection précoce, elle anticipe les évolutions possibles et leurs conséquences pour les individus, la société et la médecine. Elle s''engage dans la clarification des questions éthiques liées aux nouvelles connaissances médicales, établit des directives éthiques et s''engage pour leur mise en œuvre. L''ASSM est en dialogue avec la société : elle prend en compte les demandes, les remarques et les craintes de la population, s''efforce activement de transmettre des informations et se tient à disposition pour des activités d''expertise et de conseil à l''attention des politiques et des autorités. Dans le cadre des Académies suisses des sciences, l''ASSM s''engage dans la politique des hautes écoles, de la science et de la formation ; par sa collaboration active et son affiliation à différentes organisations internationales, elle entretient également l''échange international d''informations et d''expériences.',NULL,'3008',351,'https://de.wikipedia.org/wiki/Schweizerische_Akademie_der_Medizinischen_Wissenschaften','Q1287710',NULL,'2016-03-18 11:03:50','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(303,'Casa anziani Malcantonese Fondazione Giovanni e Giuseppina Rossi',NULL,NULL,'CHE-109.284.436',289517,'CH51470097811',1,1,'Croglio',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.moneyhouse.ch/it/u/ricovero_malcantonese_fondazione_giovanni_e_giuseppina_rossi_CH-514.7.009.781-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Creare e gerire un ricovero per i vecchi maschi e femmine dei circoli di Sessa, Magliasina, Breno, con preferenza per i domiciliati nei comuni dei tre circoli, poi gli attinenti di tali comuni domiciliati fuori dei tre circoli ed infine altre persone domiciliate nei comuni del Malcantone.',NULL,NULL,'6980',5239,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(304,'Ospedale Malcantonese Fondazione Giuseppe Rossi',NULL,NULL,'CHE-107.369.085',289975,'CH51470097834',1,1,'Castelrotto',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'http://www.oscam.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Privatklinik',NULL,NULL,'6980',5239,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(305,'Fondazione Circolo Franchi Liberali e Filarmonica Liberale-Radicale Collina d''Oro',NULL,NULL,'CHE-113.615.275',871733,'CH50170085022',1,1,'Gentilino',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'EinzelOrganisation','nie',63,NULL,NULL,'http://www.monetas.ch/htm/647/de/Firmendaten-Fondazione-Circolo-Franchi-Liberali-e-Filarmonica-Liberale-Radicale-Collina-d-Oro.htm?subj=1954447',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Kulturelle Stiftung und liberale Gesinnungspflege',NULL,NULL,'6925',5236,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(306,'Wohlfahrtsstiftung der Elektra Baselland in Liquidation',NULL,NULL,'CHE-109.719.434',270907,'CH28079116198',1,1,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://bl.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2807911619&amt=280&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Fürsorge für die Angestellten und Arbeiter der Elektra Baselland sowie deren Angehörige in Fällen von Alter, Krankheit, Invalidität, Tod und unverschuldeter Notlage.',NULL,NULL,'4410',2829,NULL,NULL,NULL,'2020-03-29 08:43:13','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(307,'Politcom, Agentur für politische Kommunikation und Public Affairs, Thomas de Courten',NULL,NULL,'CHE-112.286.022',787047,'CH28010084821',1,1,'Rünenberg',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Einzelunternehmen','0101',1,'EinzelOrganisation','nie',18,NULL,NULL,'www.politcom.ch','http://www.monetas.ch/htm/655/de/SHAB-Publikationen-Politcom-Agentur-f%C3%BCr-politische-Kommunikation-und-Public-Affairs-Thomas-de-Courten.htm?subj=1855356',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb einer Agentur für politische Kommunikation und Public Affairs; Dienstleistungen für Exponenten der Politik und der Wirtschaft; Konzeption, Entwicklung und Umsetzung von politischen Projekten; Coaching sowie administrative und fachliche Unterstützung von politischen Mandatsträgern; Erbringung von Dienstleistungen für Unternehmen, insbesondere KMU, in den Bereichen Strategie, Führung, Management, Werbung, Kommunikation und Öffentlichkeitsarbeit; Geschäftsführung bei Verbänden, Organisationen und Institutionen.',NULL,NULL,'4497',2860,NULL,NULL,NULL,'2023-08-28 14:32:15','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(308,'atelier politique Fehr',NULL,NULL,'CHE-423.681.861',1028235,'CH02010616678',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Einzelunternehmen','0101',1,'EinzelOrganisation,LeistungsErbringer','nie',18,NULL,NULL,'http://www.atelierpolitique.ch/kontakt','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0201061667&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Realisierung politischer Projekte; Schulung und Beratung von Personen und Institutionen in Politik und Wirtschaft; Publikationen (Reden, Referate, Artikel, Bücher); Vermittlung und Übernahme von Mandaten in Führungsorganen.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(309,'Profil',NULL,NULL,'CHE-109.626.502',466444,'CH02070006931',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','nie',15,NULL,NULL,'http://www.profil.proinfirmis.ch/organisation.php?sub=3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Bezweckt, behinderte Menschen im schweizerischen Arbeitsmarkt zu integrieren',NULL,NULL,'8008',261,NULL,NULL,NULL,'2023-08-28 14:49:30','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(310,'Charlotte und Hans Haller Stiftung',NULL,NULL,'CHE-111.694.714',298400,'CH02070000938',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',15,NULL,NULL,'http://www.moneyhouse.ch/u/charlotte_und_hans_haller_stiftung_CH-020.7.000.093-8.htm','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000093&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Ermöglichen von Behandlungen, Ausbildungen, Erholungsaufenthalten oder von Anschaffungen von das Leben von Behinderten erleichternden oder angenehmer gestaltenden Geräten in Fällen, in denen Krankenkassen oder Sozialversicherungen nicht oder nur in ungenügendem Masse zu Leistungen verpflichtet werden können.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2023-08-28 14:49:30','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(311,'Arbeitskreis Sicherheit und Wirtschaft',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich','ASUW',NULL,NULL,'Cercle de travail pour la sécurité et les technologies de défense',NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',95,NULL,NULL,'https://www.swissmem.ch/de/asd/asuw.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Arbeitskreis Sicherheit und Wirtschaft (zuvor: Arbeitskreis Sicherheit und Wehrtechnik) ist eine Organisation der Schweizer Rüstungsindustrie. Er besteht einerseits aus politisch tätigen Einzelmitgliedern und aus den Verbänden der Rüstungsindustrie (SWISS ASD, GRPM und GMDSI).','Le cercle de travail sécurité et économie (ASUW) est une organisation  de l''industrie suisse de l''armement. Il se compose d''une part de membres individuels actifs sur le plan politique et d''autre part des associations de l''industrie de l''armement (SWISS ASD, GRPM et GMDSI).',NULL,'8037',NULL,NULL,NULL,NULL,'2025-08-20 13:00:19','2013-11-10 14:18:51','2025-08-20 13:00:19'),
(312,'Agro-Marketing Suisse (AMS)',NULL,NULL,'CHE-100.777.483',420874,'CH03560174511',1,1,'Bern','AMS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',83,NULL,NULL,'https://www.agromarketingsuisse.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die AMS Agro-Marketing Suisse ist die Vereinigung der landwirtschaftlichen Branchenorganisationen der Schweiz. Sie verhilft Grundnahrungsmitteln aus der Schweiz zu einem professionellen Marktauftritt und fördert so die Sympathie für einheimische Produkte.','AMS Agro-Marketing Suisse est l''association des interprofessions agricoles suisses. Elle aide les produits alimentaires de base suisses à se présenter sur le marché de manière professionnelle et encourage ainsi la sympathie pour les produits indigènes.',NULL,'3006',351,NULL,NULL,NULL,'2024-04-12 21:29:38','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(313,'Verein Publikationen Spezialkulturen',NULL,NULL,'CHE-111.725.332',766313,'CH02060008713',1,1,'Wädenswil',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',NULL,NULL,NULL,'http://www.agroscope.admin.ch/publikationen/02121/02155/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein bezweckt die Förderung des Transfers von Wissen aus der landwirtschaftlichen Forschung und Extension, insbesondere durch die Forschungsanstalt Agroscope Changins-Wädenswil ACW, Standort Wädenswil sowie von branchenspezifischen Aktualitäten an die interessierten Kreise. Der Verein gibt Publikationen wie die Schweizerische Zeitschrift für Obst- und Weinbau und Merkblätter, Broschüren, Bücher etc. sowie weitere Publikationen von ACW heraus.',NULL,NULL,'8820',293,NULL,NULL,NULL,'2024-04-12 21:29:38','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(314,'Genossenschaft Studentenhaus ALV',NULL,NULL,'CHE-103.921.374',221587,'CH02059014754',1,1,'Zürich','ALV',NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','nie',146,NULL,NULL,'http://www.alvhaus.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Bau und Betrieb auf gemeinnütziger Grundlage eines Studentenhauses in Zürich und die Schaffung allfälliger weiterer Wohnmöglichkeiten für Studenten.',NULL,NULL,'8057',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(315,'Hauseigentümerverband Meilen und Umgebung',NULL,NULL,NULL,NULL,NULL,0,0,'Meilen',NULL,'HEV Meilen und Umgebung',NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',19,NULL,NULL,'http://www.hev-meilen.ch/home/kurzportrait/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'HEV Sektion Meilen: Zweck und Ziel des Verbandes ist die Wahrung und Vertretung der Rechte der Haus-, Grund- und Stockwerkeigentümer sowie des Privateigentums.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2017-10-31 09:03:18'),
(316,'Stiftung Schweizer Volkskultur',NULL,NULL,'CHE-312.394.090',1041261,'CH02070017847',1,1,'Bubikon',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',63,NULL,NULL,'http://www.ssvk.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001784&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung unterstützt Projekte zur Erhaltung und Förderung der schweizerischen Volkskultur im Sinne der Statuten der Schweizerischen Trachtenvereinigung. Die Stiftung hat gemeinnützigen Charakter und verfolgt keinerlei Erwerbszweck.',NULL,NULL,'8608',112,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(317,'Stiftung MyHandicap',NULL,NULL,'CHE-112.210.295',781657,'CH02070012194',1,1,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',15,NULL,NULL,'http://www.myhandicap.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die gemeinnützige Förderung bzw. Unterstützung von Menschen mit Behinderung; insbesondere bezweckt die Stiftung die gesellschaftliche Integration von, Massnahmen zur Erleichterung des Alltages von und den Informationsaustausch mit nicht-behinderten Menschen und unter behinderten Menschen und ihren Angehörigen in der Schweiz und in Europa.',NULL,NULL,'9000',3203,NULL,NULL,NULL,'2016-11-11 17:27:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(318,'HRS Holding AG',NULL,NULL,'CHE-112.008.888',768835,'CH32030560092',1,1,'Frauenfeld','HRS',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',19,51,NULL,'http://www.hrs.ch/fileadmin/Dokumente/Organisation/HRS_Gruppe_D.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Halten und Verwaltung von Beteiligungen. Die Gesellschaft kann Zweigniederlassungen oder Betriebsstätten im In- und Ausland errichten, sich an anderen Firmen und Institutionen direkt oder indirekt beteiligen, Finanzdienstleistungen erbringen sowie Grundstücke und Immaterialgüterrechte erwerben, verwalten und veräussern.',NULL,NULL,'8501',4566,NULL,NULL,NULL,'2017-07-22 10:35:29','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(319,'Swiss Steel Holding AG',NULL,NULL,'CHE-101.417.171',404249,'CH10030106567',1,1,'Emmenbrücke',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',52,NULL,NULL,'http://www.moneyhouse.ch/u/schmolzbickenbach_ag_CH-100.3.010.656-7.htm',NULL,NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/swiss-steel-group/',NULL,'Die Swiss Steel Group ist einer der weltweit führenden Anbieter individueller Lösungen im Bereich Spezial-Langstahlprodukte. Als einer der grössten Elektrostahlproduzenten Europas steht die Swiss Steel Group an der Spitze der nachhaltigen Stahlproduktion','Swiss Steel Group est l''un des principaux fournisseurs mondiaux de solutions individuelles dans le domaine des produits spéciaux en acier long. En tant que l''un des plus grands producteurs d''acier électrique d''Europe, Swiss Steel Group est à la pointe de la production durable d''acier.',NULL,'6020',1061,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-10-15 21:37:25'),
(320,'Spital Thurgau AG',NULL,NULL,'CHE-108.743.720',500682,'CH44030131195',1,1,'Frauenfeld',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',5,NULL,NULL,'http://www.stgag.ch/spital-thurgau-ag/ueber-uns/verwaltungsrat.html?Fsize=0.html.html.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Kantonsspital und Kliniken',NULL,NULL,'8500',4566,NULL,NULL,NULL,'2016-09-20 07:55:38','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(321,'Roland Eberle Mercanda Consulting',NULL,NULL,'CHE-390.676.199',1044695,'CH44010257623',1,1,'Frauenfeld',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Einzelunternehmen','0101',1,'EinzelOrganisation','nie',18,NULL,NULL,'http://www.moneyhouse.ch/u/roland_eberle_mercanda_consulting_CH-440.1.025.762-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Einzelfirma Unternehmensberatung',NULL,NULL,'8500',4566,NULL,NULL,NULL,'2017-07-22 10:35:29','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(322,'Careum Stiftung',NULL,NULL,'CHE-105.841.639',411831,'CH02079036771',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.careum.ch/web/guest/home','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207903677&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'1882 als Stiftung Schwesternschule und Krankenhaus vom Roten Kreuz Zürich Fluntern gegründet, versteht sich die Careum Stiftung heute als Organisation, die durch gezielte Veranstaltungen den Dialog zwischen den verschiedenen Akteuren des Gesundheitswesens fördert und in Nachwuchstalente investiert, die die Gesundheitswelt der Zukunft denken. Der Stiftungszweck gemäss Statuten lautet: "Die Stiftung fördert die Bildung im Gesundheitswesen durch Innovation und Entwicklung."',NULL,NULL,'8032',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(323,'AMIS Plus Stiftung',NULL,NULL,'CHE-114.622.875',929388,'CH02070015641',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',4,NULL,NULL,'http://www.amis-plus.ch/','http://zefix.ch/zfx-cgi/hrform.cgi/hraPage?alle_eintr=on&pers_sort=original&pers_num=0&language=1&col_width=366&amt=007',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt das Erfassen und Verwalten von Daten, die der epidemiologischen Charakterisierung von Patienten mit Herzkreislaufleiden dienen, insbesondere statistische Daten über die Entstehung, das Auftreten, die Häufigkeit und der Verlauf der Herzkreislaufkrankheiten, Massnahmen zur Prävention und Früherkennung, das Erfassen von Abklärungs- und Behandlungsstrategien und die Erarbeitung von Interventions- und Optimierungsoptionen.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(324,'Dr. med. Ernst und Fanny Bachmann-Huber-Stiftung',NULL,NULL,'CHE-100.657.287',261827,'CH02079003577',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.moneyhouse.ch/u/dr_med_ernst_und_fanny_bachmann_huber_stiftung_CH-020.7.900.357-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Entrichtung jährlicher Beiträge an die Universität Zürich und/oder an die Kantonsschule Zürichberg für zusätzliche Stipendien oder für besondere Anschaffungen. Die Stiftung verfolgt weder Erwerbs- noch Selbsthilfezwecke.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(325,'Foundation National Institute for Cancer Epidemiology and Registration (NICER)',NULL,NULL,'CHE-113.660.287',874020,'CH03570373493',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',8,41,NULL,'http://www.nicer.org/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357037349&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'NICER (Nationales Institut für Krebsepidemiologie und -registrierung) wurde im Mai 2007 unter Mithilfe der Universität Zürich von der Vereinigung Schweizerischer Krebsregister und Oncosuisse als unabhängige Stiftung gegründet. Ihr Zweck ist in der Stiftungsurkunde festgelegt. Laut Reglement fördert und unterstützt die Stiftung die bevölkerungsbezogene Krebsregistrierung und epidemiologische Krebsforschung in der Schweiz. Vor der Gründung wurden Daten in einzelnen Schweizer Kantonen seit 1969 erhoben. Mit diesen Daten und jenen des Bundesamtes für Statistik (BFS) können Aussagen gemacht werden über das Vorkommen, die Verbreitung und das Überleben von sowie die Sterblichkeit an Krebserkrankungen in der Schweiz. Ebenfalls werden Studien über Risikofaktoren und Analysen zu verschiedenen Aspekten der Prävention und Behandlung erstellt. Die Stiftung wird zur Hauptsache aus Bundesmitteln finanziert.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(326,'Pestalozzi-Stiftung für die Förderung der Ausbildung Jugendlicher aus schweizerischen Berggegenden',NULL,NULL,'CHE-109.641.996',394943,'CH02079030719',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.moneyhouse.ch/it/u/pestalozzi_stiftung_fur_die_forderung_der_ausbildung_jugendlicher_aus_schweizerischen_berggegenden_CH-020.7.903.071-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Förderung der Erziehung, Ausbildung und der beruflichen Weiterbildung von Kindern, Jugendlichen und jungen Erwachsenen aus Berg- und abgelegenen Landgebieten, wenn ihnen diese Möglichkeit ohne Hilfe von aussen nicht zugänglich wäre.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(327,'Schweizerische Herzstiftung','Fondation Suisse de Cardiologie','Fondazione Svizzera di Cardiologia','CHE-108.796.449',323284,'CH03570104705',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',4,NULL,NULL,'http://www.swissheart.ch/index.php?id=7&no_cache=1','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357010470&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Förderung der Erforschung und der Bekämpfung der Herz- und Gefässkrankheiten sowie des Hirnschlags. Die Aufklärungs- und Präventionsarbeit in der Bevölkerung auf dem Gebiet der Herz- und Gefässkrankheiten sowie des Hirnschlags. Die Beratung und Betreuung von Betroffenen und ihren Angehörigen. Die Stiftung hat gemeinnützigen Charakter und verfolgt keinerlei Erwerbszweck.',NULL,NULL,'3005',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(328,'Stiftung für Lungendiagnostik',NULL,NULL,'CHE-446.406.780',1035242,'CH02070017744',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',4,NULL,NULL,'http://www.lungendiagnostik.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001774&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Förderung der Früherfassung des Lungenkrebses und anderer Lungenkrankheiten in der Schweiz und im Ausland, das Angebot entsprechender Dienstleistungen sowie das Angebot und die Förderung von Massnahmen primärer, sekundärer und tertiärer Prävention im Zusammenhang mit der Lungengesundheit.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(329,'Stiftung für Sucht- und Gesundheitsforschung',NULL,NULL,'CHE-108.276.658',353278,'CH02070003363',1,1,'Zürich','ISGF','Schweizer Institut für Sucht- und Gesundheitsforschung',NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'https://www.isgf.uzh.ch/de.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung führt ein Institut für Sucht- und Gesundheitsforschung (im folgenden Institut genannt) in Zürich, welches ausschliesslich gemeinnützige Zwecke verfolgt. Insbesondere bezweckt das Institut, a) die interdisziplinäre Forschung im Bereich von Abhängigkeitsformen, ihrer Entstehung und Behandlung, sowie in weiteren gesundheitlich relevanten Bereichen zu fördern durch Ausführung von Forschungsaufträgen sowie durch eigene Projekte, b) die wissenschaftliche Auswertung von Interventionen im Suchtmittelbereich sowie in weiteren Gesundheitsbereichen zu fördern, c) Projekt- und Institutionsberatungen sowie Projektbegutachtungen durchzuführen, d) Forschungsergebnisse für die präventive, therapeutische, sozialpädagogische und sozialpolitische Praxis zugänglich zu machen e) Forschungsergebnisse in universitäre und andere Ausbildungsgänge einzubringen sowie Lehr- und Weiterbildungsveranstaltungen durchzuführen. Die Stiftung ist parteipolitisch und konfessionell neutral.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2013-11-10 14:18:51','2025-02-13 09:16:35'),
(331,'Verein "Forum Zürcher Gespräche"',NULL,NULL,'CHE-101.040.304',451321,'CH02060004371',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,dezidierteLobby','nie',NULL,NULL,NULL,'http://www.moneyhouse.ch/u/verein_forum_zurcher_gesprache_CH-020.6.000.437-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Interdisziplinäres, grenzüberschreitendes und parteipolitisch unabhängiges Gesprächsforum für den Austausch von Informationen, Analysen, Konzepten und Meinungen, die mitbestimmend für die wirtschaftliche und politische Entwicklung sind. Das Forum soll die Diskussion zwischen Persönlichkeiten, die mit ihren unternehmerischen und politischen Aktivitäten die wirtschaftliche Zukunft der Schweiz mitgestalten, auf hohem Niveau fördern. Der Verein verfolgt bei seiner Tätigkeit keinen wirtschaftlichen Zweck.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(332,'Pensimo Fondsleitung AG',NULL,NULL,'CHE-102.725.439',1395,'CH02030066511',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',42,19,NULL,'http://www.pemsimo.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203006651&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck des Unternehmens ist die Ausübung des Fondsgeschäfts, einschliesslich die Organisation, die Verwaltung und der Vertrieb von Anlagefonds, die Vertretung ausländischer Anlagefonds sowie die Erbringung von Dienstleistungen im administrativen Bereich für Anlagefonds und anlagefondsähnliche Vermögen.\nDie Pensimo Fondsleitung AG gehört zu 100 Prozent der Mensimo Management AG, die wiederum im Eigentum der drei BVG-Anlagestiftungen Pensimo, Turidomus und Testina steht. Die Geschäftstätigkeit der Pensimo Fondsleitung AG besteht in der Führung des börsenkotierten Immobilien-Anlagefonds SREIF (Swiss Real Estate Investment Fund).',NULL,NULL,'8005',261,NULL,NULL,NULL,'2018-10-11 08:32:19','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(333,'Aktiengesellschaft für die Neue Zürcher Zeitung',NULL,NULL,'CHE-104.085.912',2569,'CH02039007872',1,1,'Zürich','NZZ','Neue Zürcher Zeitung',NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',48,NULL,NULL,'http://nzzmediengruppe.ch/unternehmen/verwaltungsrat/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203900787&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/neue-zurcher-zeitung/',NULL,'Herausgabe der "Neuen Zürcher Zeitung" als ein von Sonderinteressen unabhängiges politisches, wirtschaftliches und kulturelles Organ von hoher Qualität und freisinnig-demokratischer Grundhaltung.','Publication de la "Neue Zürcher Zeitung" en tant qu''organe politique, économique et culturel indépendant de tout intérêt particulier, de grande qualité et d''inspiration libérale-démocrate',NULL,'8008',261,'https://de.wikipedia.org/wiki/Neue_Z%C3%BCrcher_Zeitung','Q658945',NULL,'2018-10-11 08:32:19','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(334,'Asga Pensionskasse Genossenschaft',NULL,NULL,'CHE-105.782.652',9620,'CH32050006881',1,1,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','punktuell',42,NULL,NULL,'http://www.asga.ch/','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3205000688&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Pensionskasse',NULL,NULL,'9001',3203,NULL,NULL,NULL,'2023-08-28 14:32:15','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(335,'Anlagestiftung Pensimo für Personalvorsorge-Einrichtungen',NULL,NULL,'CHE-104.331.896',286182,'CH02079030281',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,'http://www.pensimo.ch/pub/ape/index.php','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207903028&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Anlagestiftung Pensimo ist eine von Pensionskassen gegründete und nach unternehmerischen Grundsätzen geführte Anlageorganisation für Immobilien. Sie bietet einer ausgewählten Anzahl schweizerischer Personalvorsorgeeinrichtungen eine qualitativ hochstehende und zukunftsorientierte Anlage ihrer Mittel in Immobilien und deren professionelle Bewirtschaftung an.\n\nGeschäftsführung der Anlagestiftung: Pensimo Management AG',NULL,NULL,'8005',261,NULL,NULL,NULL,'2024-05-30 13:34:49','2013-11-10 14:18:51','2024-05-30 13:34:49'),
(336,'Schweizerischer Arbeitgeberverband','Union Patronale Suisse','Unione Svizzera Degli Imprenditori','CHE-105.833.864',NULL,NULL,0,0,'Zürich','Der Arbeitgeber',NULL,'Les Employeurs',NULL,'Gli Imprenditori',NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',59,NULL,NULL,'http://www.arbeitgeber.ch/index.php?option=com_content&view=category&layout=blog&id=20&Itemid=27&lang=de',NULL,'arbeitgeber_ch',NULL,NULL,NULL,'https://www.linkedin.com/company/schweizerischer-arbeitgeberverband/',NULL,'Der Schweizerische Arbeitgeberverband (SAV) ist die Stimme der Schweizer Arbeitgeber in Wirtschaft, Politik und Öffentlichkeit. Er organisiert als Spitzenverband der Wirtschaft 41 regionale und 39 Branchen-Arbeitgeberverbände sowie einige Einzelunternehmen (Mitglieder). Der SAV vereint alle wichtigen Branchen. Insgesamt steht der Verband für über 100''000 Klein-, Mittel- und Grossunternehmen mit mehr als eineinhalb Millionen Arbeitnehmenden aus allen Wirtschaftssektoren. Kooperiert eng mit Economiesuisse und den anderen Dachverbänder der Schweizer Wirtschaft.','L''Union patronale suisse (UPS) est la voix des employeurs suisses dans l''économie, la politique et le public. En tant qu''association faîtière de l''économie, elle organise 41 associations patronales régionales et 39 associations patronales sectorielles ainsi que quelques entreprises individuelles (membres). La FSA réunit toutes les branches importantes. Au total, l''association représente plus de 100''000 petites, moyennes et grandes entreprises avec plus d''un million et demi d''employés de tous les secteurs économiques. Elle coopère étroitement avec Economiesuisse et les autres associations faîtières de l''économie suisse.',NULL,'8032',261,NULL,NULL,NULL,'2025-09-01 20:58:46','2013-11-10 14:18:51','2025-09-01 20:58:46'),
(337,'SWISS RETAIL FEDERATION (Vereinigung der Mittel- und Grossbetriebe des schweizerischen Detailhandels)','Association des commerces de détail de taille moyenne en Suisse',NULL,'CHE-102.876.475',240344,'CH02069005865',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',92,NULL,NULL,'http://www.swiss-retail.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Swiss Retail ist der Verband der mittelständischen Detailhandelsunternehmen (stationär und online) in der Schweiz. Unter unseren Mitgliedern sind Warenhäuser, Fachmärkte und Fachgeschäfte, Verbraucher- und Abholmärkte, selbstständige Detaillisten, Food-Fachhändler und Kioske.\n\nSwiss Retail vertritt auf nationaler Ebene gegenüber Politik und Öffentlichkeit kraftvoll die Interessen des Mittelstands im Schweizer Detailhandel. Zudem bieten wir unseren Mitgliedern attraktive Dienstleistungen an.\n\nDer Verband engagiert sich für freiheitliche Rahmenbedingungen und hohe Standards in der Branche. Insbesondere bekämpft er Preistreiber, Handelshemmnisse und Überregulierung, die zum Nachteil der Kundschaft die Produkte verteuern.','Swiss Retail est l''association des commerces de détail de taille moyenne (stationnaires et en ligne), en Suisse. En font partie des grands magasins, des commerces et des marchés spécialisés, des grandes surfaces et marchés libre service, des détaillants indépendants, des commerces d''alimentation et des kiosques.\n\nA l''égard du monde politique et du public, Swiss Retail défend efficacement au plan national les intérêts des entreprises du commerce de détail suisse de taille moyenne. Aussi, elle fournit de nombreux services à ses membres.\n\nL''association s''engage pour un cadre d''activité libéral et des normes de haut niveau au sein de la branche. Elle s''oppose en particulier à la hausse des prix, aux entraves commerciales et à l''hyper-réglementation qui renchérissent les produits au détriment du client.',NULL,'3011',351,NULL,NULL,NULL,'2025-06-21 13:23:38','2013-11-10 14:18:51','2025-06-21 13:23:38'),
(338,'Baloise Leben AG',NULL,NULL,'CHE-101.305.342',14542,'CH27030003775',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'http://www.baloise.ch/de.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Gesellschaft ist der Betrieb der Lebensversicherung und aller übrigen Versicherungszweige, welche eine Lebensversicherungsgesellschaft auf Grund der gesetzlichen Vorschriften betreiben kann sowie der Rückversicherung in diesen Versicherungszweigen. Die Gesellschaft kann sich ferner im In- und Ausland an anderen Unternehmungen beteiligen, solche gründen oder übernehmen oder mit ihnen fusionieren.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2023-02-28 23:22:39','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(339,'Baloise Versicherung AG',NULL,NULL,'CHE-105.805.649',14553,'CH27030003631',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'http://www.baloise.ch/de.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Versicherungen',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2023-02-28 23:22:39','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(340,'SWISSAID, Schweizerische Stiftung für Entwicklungszusammenarbeit','SWISSAID, Fondation Suisse pour la coopération au développement','SWISSAID, Fondazione Svizzera per la cooperazione allo sviluppo','CHE-105.911.139',296939,'CH03570159759',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',68,NULL,NULL,'http://www.swissaid.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357015975&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0','SWISSAID',NULL,NULL,NULL,NULL,NULL,'Die Stiftung fördert die Solidarität der schweizerischen Bevölkerung mit Benachteiligten in der Welt. Ihren Zweck erfüllt SWISSAID insbesondere durch die folgenden Tätigkeiten: Unterstützung von Entwicklungsprojekten und -programmen in Entwicklungsländern und Entwicklungsregionen, die die Selbsthilfe besonders benachteiligter Bevölkerungsgruppen stärken; Information der schweizerischen Öffentlichkeit über die Arbeit von SWISSAID, über Fragen der Entwicklung und über Ursachen der Unterentwicklung und Fehlentwicklung; Teilnahme an der entwicklungspolitischen Meinungs- und Entscheidungsbildung mit dem Ziel, die schweizerischen Beziehungen mit den Entwicklungsländern im Interesse der besonders Benachteiligten mitzugestalten; Zusammenarbeit mit privaten und öffentlichen Institutionen im Sinne des Stiftungszwecks. In ihrer Tätigkeit ist SWISSAID offen für neue Entwicklungsansätze insbesondere aus der Dritten Welt.',NULL,NULL,'3008',351,NULL,NULL,NULL,'2025-07-01 12:52:09','2013-11-10 14:18:51','2025-07-01 12:52:09'),
(341,'Stiftung Allalin',NULL,NULL,'CHE-195.617.725',1056894,'CH03670536797',1,1,'Pfäffikon SZ',NULL,NULL,NULL,NULL,NULL,NULL,191,7,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',71,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Pflege der Beziehungen in kultureller, historischer und politischer Hinsicht zwischen den Ländern der Arabischen Welt und der Schweiz als Land im Zentrum von Europa. Sie organisiert zu diesem Zweck in der Arabischen Welt und in der Schweiz Veranstaltungen und andere Plattformen der Begegnung, welche der gegenseitigen Information und dem Meinungsaustausch dienen und so zum besseren Verständnis der unterschiedlichen Kulturen, der Geschichte und den Gesellschaften beitragen sollen.',NULL,NULL,'8808',1322,NULL,NULL,NULL,'2020-03-27 13:11:13','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(342,'CURAVIVA - Verband Heime und Institutionen Schweiz','Curaviva Association des Homes et Institutions Sociales Suisse','Associazione degli Istituti Sociali e di Cura Svizzeri','CHE-112.120.344',774946,'CH02060009001',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',79,NULL,NULL,'http://www.curaviva.ch/index.cfm/CC67AC52-A777-9EFA-1F9440E75954180C/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000900&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'CURAVIVA Schweiz - der nationale Dachverband der Heime und Institutionen\n\nDer nationale Dachverband setzt sich für Rahmenbedingungen ein, die es den Heimen und sozialen Institutionen ermöglichen, ihren Bewohnenden qualitativ hochstehende Unterstützung und Betreuung zu bieten. Hierfür vertritt CURAVIVA Schweiz auf politischer Ebene die gesundheits-, sozial- und bildungspolitischen Interessen seiner Mitglieder und stellt diesen zudem eine Vielzahl spezifischer Dienstleistungs- und Bildungsangebote zur Verfügung.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2021-02-11 11:50:06','2013-11-10 14:18:51','2024-04-28 10:36:59'),
(343,'Intergenerika',NULL,NULL,'CHE-102.170.062',603730,'CH28060043257',1,1,'Pratteln',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',1,NULL,NULL,'http://www.intergenerika.ch/','http://www.moneyhouse.ch/u/intergenerika_CH-280.6.004.325-7.htm','intergenerika',NULL,'Intergenerika',NULL,'https://www.linkedin.com/company/intergenerika-schweiz/',NULL,'Intergenerika ist die Vereinigung der führenden Generika- und Biosimilarsfirmen in der Schweiz.','Intergenerika est l''association des principales entreprises de génériques et de biosimilaires en Suisse.',NULL,'4133',2831,NULL,NULL,NULL,'2023-08-28 14:32:15','2013-11-10 14:18:51','2024-11-11 22:32:52'),
(344,'Schweizerischer Gewerbeverband','Union suisse des arts et métiers',NULL,'CHE-107.813.192',947708,'CH03660449618',1,1,'Bern','SGV',NULL,'USAM',NULL,NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.sgv-usam.ch/verband.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Gewerbeverband sgv vertritt die Interessen der kleinen und mittleren Unternehmen KMU in der Schweiz. Mitglieder des sgv sind die kantonalen Gewerbeverbände, Berufs- und Branchenverbände sowie die Organisationen der Gewerbeförderung.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2025-09-15 21:08:25','2013-11-10 14:18:51','2025-09-15 21:08:25'),
(345,'Hauseigentümerverband Baselland',NULL,NULL,'CHE-188.040.565',NULL,NULL,0,0,'Liestal','HEV BL',NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',19,NULL,NULL,'http://www.hev-bl.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zusammenschluss der Haus-, Wohnungs- und Grundeigentümer im Kanton Basel-Landschaft\n\nMitgliedsorganisation HEV Schweiz',NULL,NULL,'4410',2831,NULL,NULL,NULL,'2023-08-28 14:36:03','2013-11-10 14:18:51','2023-08-28 14:36:03'),
(346,'H + die Spitäler der Schweiz','H+ Les hôpitaux de Suisse',NULL,'CHE-110.622.534',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',5,59,NULL,'http://www.hplus.ch/',NULL,'hplus_spitaeler',NULL,NULL,NULL,'https://www.linkedin.com/company/hplus-die-spitaeler-der-schweiz',NULL,'H+ ist der Dachverband der öffentlichen und privaten Schweizer Spitäler, Kliniken und Pflegeinstitutionen. Als nationaler Verband nimmt H+ die Interessen der Mitglieder als Leistungserbringer und Arbeitgeber wahr.','H+ est l''association faîtière des hôpitaux, cliniques et institutions de soins publics et privés suisses. En tant qu''association nationale, H+ défend les intérêts de ses membres en tant que prestataires de services et employeurs.',NULL,'3013',351,NULL,NULL,NULL,'2023-08-28 14:37:23','2013-11-10 14:18:51','2025-02-09 18:20:47'),
(347,'Schweizerischer Mieterinnen- und Mieterverband','Association Suisse des locataires','Associazione Svizzera Inquilini',NULL,NULL,NULL,0,0,'Bern 23','SMV','Mieterverband','ASLOCA Suisse',NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',98,NULL,NULL,'http://www.smv-asloca-asi.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Dachorganisation sämtlicher kantonaler und regionaler MieterInnen-Verbände in der Schweiz.',NULL,NULL,'3000',NULL,NULL,NULL,NULL,'2025-08-25 00:00:00','2013-11-10 14:18:51','2025-08-27 10:20:09'),
(348,'Associazione Scigué',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',68,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Entwicklungshilfe-Organisation im Bildungsbereich. Der Name ist Sptizname des verstorbenen Gründers, Moreno Fibbioli.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-03-11 10:41:59','2013-11-10 14:18:51','2019-03-11 10:41:59'),
(349,'mcw - Miriam C. Wetter Arni',NULL,NULL,'CHE-114.757.334',1119104,'CH40010344850',1,1,'Zofingen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Einzelunternehmen','0101',1,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',18,NULL,NULL,'www.mcw.ch','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4001034485&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'mcw gestaltet politische Arbeit. Wir tun dies für Fachstellen, für Projekte oder als Geschäftsstelle ganzer Organisationen. Wenn Sie das mit uns machen wollen, bieten wir den fachlichen Hintergrund, Themenwissen, den Zugang zu wichtigen Stellen, die nötige Erfahrung, ein sechsköpfiges Team und eine inhabergeführte Firma. (Quelle: Webseite)',NULL,NULL,'4800',4289,NULL,NULL,NULL,'2016-10-18 17:41:40','2013-12-09 10:58:39','2024-04-28 10:36:59'),
(350,'furrerhugi.ag',NULL,NULL,'CHE-105.181.458',464885,'CH03530225381',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,5,'AG','0106',3,'EinzelOrganisation,dezidierteLobby','punktuell',18,NULL,NULL,'http://www.furrerhugi.ch',NULL,'FurrerHugi',NULL,NULL,NULL,NULL,NULL,'Furrerhugi ist eine inhabergeführte Kommunikationsagentur. Seit über zehn Jahren ist sie Ansprechpartnerin für Public Affairs und Corporate Communications und vernetzt Menschen mit Ideen an der Schnittstelle von Wirtschaft, Politik und Gesellschaft. \n\n2006 als Furrer.Hugi&Partner gegründet, hat sie sich innert kurzer Zeit in Bern, Zürich und Brüssel etabliert und arbeitet heute für nationale und internationale Unternehmen, Organisationen und Institutionen jeder Grösse.\n\nFurrerhugi betreibt auch das Kommunikationsportal Influence.ch und einen gleichnamigen Newsletter, der einmal im Monat verschickt wird.','Furrerhugi est une agence de communication dirigée par ses fondateurs et propriétaires. Depuis plus de dix ans, elle est l''interlocuteur privilégié en matière d''affaires publiques et de communication institutionnelle. Elle connecte les gens et les idées, à la jonction de l''économie, de la politique et de la société.\n\nFondée en 2006 sous le nom de Furrer.Hugi&Partner, elle s''est rapidement établie à Berne, Zurich et Bruxelles et travaille aujourd''hui pour des entreprises, organisations et institutions nationales et internationales de toutes tailles.\n\nFurrerhugi gère également le portail de communication Influence.ch et une newsletter du même nom, qui est envoyée une fois par mois.',NULL,'3011',351,NULL,NULL,NULL,'2024-12-17 16:12:51','2014-01-17 22:16:23','2024-12-17 16:12:51'),
(351,'BG OST-SÜD Bürgschaftsgenossenschaft für KMU',NULL,NULL,'CHE-107.979.875',129167,'CH32050003005',1,1,'St. Gallen','KMU',NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation','punktuell',59,NULL,NULL,'http://www.bgost.ch/','http://www.moneyhouse.ch/u/bg_ost_sud_burgschaftsgenossenschaft_fur_kmu_CH-320.5.000.300-5.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Genossenschaft fördert entwicklungsfähige Klein- und Mittelunternehmen durch die Gewährung von Bürgschaften mit dem Ziel, diesen die Aufnahme von Bankdarlehen zu erleichtern.','La coopérative soutient les petites et moyennes entreprises capables de se développer en leur accordant des garanties dans le but de leur faciliter l''obtention de prêts bancaires.',NULL,'9006',3203,NULL,NULL,NULL,'2023-08-27 21:16:39','2014-01-20 16:18:55','2024-04-28 10:36:59'),
(352,'Stiftung Schloss Neu-Bechburg',NULL,NULL,'CHE-110.387.178',291566,'CH24070000587',1,1,'Oensingen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation','nie',44,NULL,NULL,'http://www.neu-bechburg.ch/start.asp','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2407000058&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Das Schloss Neu-Bechburg im Sinne des Denkmalschutzes instandzustellen und zu unterhalten sowie es der Oeffentlichkeit zugänglich zu machen.',NULL,NULL,'4702',2407,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-01-25 16:02:33','2024-08-23 05:08:39'),
(353,'Aids Hilfe beider Basel',NULL,NULL,'CHE-104.364.111',NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.ahbb.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2701,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-02 21:24:30','2022-09-25 22:33:13'),
(354,'Aids-Hilfe Schweiz','Aide Suisse contre le Sida','Aiuto Aids Svizzero','CHE-105.915.077',292509,'CH02060000616',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.aids.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000061&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die AHS ist die Dachorganisation ihrer Mitglieder in der Schweiz und damit auch die Organisation für Menschen im Kontext von HIV/Aids.\nAls Dachorganisation koordiniert sie ihre eigenen nationalen Angebote und Projekte mit denen ihrer Mitglieder. Sie unterstützt und fördert die Meinungsbildung zu relevanten Themen im Verband und erbringt Dienstleistungen gegenüber ihren Mitgliedern.\nDie AHS hat zum Ziel, durch wirksame Präventionsprogramme neue Infektionen in den Zielgruppen mit erhöhtem HIV- und STI-Expositionsrisiko zu verhindern und die Lebensqualität von Menschen mit HIV sowie ihnen Nahestehenden zu verbessern. Sie engagiert sich für die Gleichstellung und Integration von Menschen mit HIV/Aids und setzt sich gemeinsam mit den Betroffenen für deren Anliegen und gegen Diskriminierung ein. Sie nimmt Stellung zu sozial- und gesundheitspolitischen Fragen und bringt ihre Fachkompetenz in den nationalen Strategieprozess ein.\nDie AHS erbringt Leistungen in den folgenden drei strategischen Geschäftsfeldern:\n HIV-/STI-Infektionen in den Zielgruppen mit erhöhtem Expositionsrisiko verhindern;\n Menschen mit HIV/Aids und ihnen Nahestehende unterstützen;\n Diskriminierung im Zusammenhang mit HIV/Aids verhindern / Integration fördern / Advocacy.',NULL,NULL,'8047',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-02-02 21:33:06','2025-02-13 09:16:35'),
(355,'Gemeinnützige Institutionen Basel',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','nie',12,NULL,NULL,'http://www.gi-basel.ch/home/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die GI-Basel - die Gemeinnützigen Institutionen Basel - vertreten über 40 gemeinnützige Organisationen in der Region Basel. Als Interessenverband stärken und fördern die GI-Basel die Idee, den Wert und den Nutzen der Gemeinnützigkeit gegenüber Politik, Verwaltung, Wirtschaft und Öffentlichkeit. Die GI-Basel setzen sich für vernünftige politische Rahmenbedingungen und für mehr unternehmerische Selbständigkeit für ihre Mitglieder ein.\nBis heute lag der Schwerpunkt der Aktivitäten der GI-Basel noch im Kanton Basel-Stadt. So haben sich die GI-Basel erfolgreich bei der Ausarbeitung und politischen Diskussion des neuen Staatsbeitragsgesetzes im Kanton Basel-Stadt engagiert. Im Grossen Rat sind inzwischen über 20 Grossrätinnen und Grossräte - immerhin ein Fünftel des Basler Parlaments - der überparteilichen "Parlamentarischen NPO-Gruppe GI-Basel" beigetreten. Bereits heute sind mehrere Mitglieder der GI-Basel in den Kantonen Basel-Land und Basel-Stadt tätig. Den GI-Basel ist es wichtig, dass auch im Kanton Basel-Land die Bedeutung und die Anliegen der Gemeinnützigen Institutionen wahrgenommen und gestärkt werden! Aus diesem Grund laden wir herzlich zu einer Veranstaltung ein,\n- an der wir Sie über die GI-Basel aus erster Hand informieren \n- und an der wir Ihre Bedürfnisse und Ihre Anliegen an die GI-Basel als Vertreterinnen und Vertreter von Gemeinnützigen Organisationen im Kanton Basel-Land aufnehmen möchten.',NULL,NULL,'4057',NULL,NULL,NULL,NULL,'2015-03-21 00:00:00','2014-02-02 22:10:24','2021-01-03 08:52:54'),
(356,'Musikbüro Basel',NULL,NULL,'CHE-113.737.085',878936,'CH27060005946',1,1,'Basel','RFV',NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'EinzelOrganisation,dezidierteLobby','nie',10,NULL,NULL,'http://www.rfv.ch','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2706000594&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Popförderung und Musiknetzwerk der Region Basel, RFV. \nDer RFV Basel fördert die Popmusik der Region Nordwestschweiz, insbesondere in den Kantonen Basel-Landschaft und Basel-Stadt. Der Verein engagiert sich und lobbyiert für die Ansprüche und Belange der Popmusik und für die Verbesserung der Rahmenbedingungen, unter denen sie kreiert, produziert, präsentiert, verbreitet und rezipiert wird. Der Verein berücksichtigt alle zeitgenössischen Stile der Popmusik, sowohl Subkultur wie Mainstream.',NULL,NULL,'4053',2701,NULL,NULL,NULL,'2018-10-07 11:40:55','2014-02-03 15:05:45','2024-04-28 10:36:59'),
(358,'FDP Die Liberalen Basel-Stadt',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',20,13,NULL,'http://www.fdp-bs.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4051',NULL,NULL,NULL,NULL,'2014-10-24 08:52:28','2014-02-03 15:58:59','2015-02-03 08:46:55'),
(360,'Netzwerk Kinderbetreuung',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',102,NULL,NULL,'http://www.netzwerk-kinderbetreuung.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Um den Qualitätsfragen mehr Gewicht zu verleihen, haben sich Vertreterinnen und Vertreter von Verbänden für Kindertagesstätten, Tagesfamilien und schulergänzende Betreuungsangebote zusammen mit Vertreterinnen und Vertretern von Trägerschaften, Wirtschaft, Forschung, Bildung und Politik an einen runden Tisch gesetzt und den Verein Netzwerk Kinderbetreuung Schweiz gegründet.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-04-04 15:22:26','2014-02-06 23:13:14','2022-04-04 15:22:27'),
(361,'Vereinigung für eine Starke Region Basel/Nordwestschweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',13,NULL,NULL,'http://www.starke-region-basel.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Vereinigung hat den Zweck, den politischen und wirtschaftlichen Zusammenschluss der Region Basel zu fördern und zu verwirklichen sowie die Zusammenarbeit innerhalb der Region Nordwestschweiz enger zu gestalten.','L''association a pour but de promouvoir et de réaliser l''union politique et économique de la région de Bâle et de resserrer la coopération au sein de la région du Nord-Ouest de la Suisse.',NULL,NULL,NULL,NULL,NULL,NULL,'2025-07-01 18:15:05','2014-02-10 14:46:11','2025-07-01 18:15:05'),
(362,'Arbeitgeberverband Basel',NULL,NULL,'CHE-108.138.453',NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.arbeitgeberbasel.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Wir sind Garant dafür, dass die arbeitgeberpolitischen Anliegen unserer Mitglieder mit Nachdruck vertreten werden. Wir geben den Arbeitgebern Stimme und Gewicht.\n\nDer Arbeitgeberverband Basel vertritt zudem die sozialpolitischen Anliegen seiner Mitglieder gegenüber Arbeitnehmerorganisationen. Als Vertragspartner ist der Arbeitgeberverband Basel massgeblich für die Ausgestaltung des regionalen Gesamtarbeitsvertrages für den Dienstleistungsbereich verantwortlich.\n\nAusserdem vertreten wir die Arbeitgeber in zahlreichen regionalen, nationalen und auch grenzüberschreitenden Gremien und pflegt einen engen Kontakt zu Behörden, politischen Mandatsträgern und Parteien.',NULL,NULL,NULL,2701,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-10 14:48:03','2022-09-25 22:33:13'),
(363,'Gewerbeverband Basel-Stadt',NULL,NULL,'CHE-108.208.616',1418317,'CH27060008855',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.kmu-channel.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Zweck des Vereins ist es, das Wohl der KMU-Wirtschaft generell und des Basler Gewerbes im Speziellen zu wahren und zu fördern.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2023-08-18 10:12:11','2014-02-10 14:48:49','2024-04-28 10:36:59'),
(364,'Regio Basiliensis',NULL,NULL,'CHE-100.701.787',NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',13,14,NULL,'http://www.regbas.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2701,NULL,NULL,NULL,'2023-08-18 10:12:11','2014-02-10 23:20:36','2023-08-18 10:12:11'),
(365,'Aktion für eine unabhängige und neutrale Schweiz (AUNS)','Action pour une Suisse indépendante et neutre (ASIN)','Azione per una Svizzera indipendente e neutrale (ASNI)',NULL,NULL,NULL,0,1,'Bern','AUNS',NULL,NULL,NULL,NULL,NULL,191,5,'Verein','0109',NULL,'EinzelOrganisation,dezidierteLobby','punktuell',76,NULL,NULL,'https://auns.ch/',NULL,'AUNS_CH',NULL,NULL,NULL,NULL,NULL,'Die AUNS wurde per 15.10.2022 aufgelöst. Sie ging in der neuen Organisation Pro Schweiz auf.','L''ASIN a été dissoute le 15.10.2022. Elle a été absorbée par la nouvelle organisation Pro Suisse.',NULL,'3000',584,NULL,NULL,NULL,'2023-09-11 08:51:30','2014-02-10 23:26:54','2023-09-19 11:00:26'),
(366,'Bund der Steuerzahler (BDS)',NULL,NULL,'CHE-108.437.039',369308,'CH02060002224',1,1,'Zürich','BDS',NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'MitgliedsOrganisation,dezidierteLobby','punktuell',99,NULL,NULL,'http://www.bds-schweiz.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Einsetzen für eine massvolle Steuerpolitik, eine tiefe Staatsquote und eine konsequent auf Sparen ausgerichtete Finanzpolitik von Bund, Kantonen und Gemeinden; ist besorgt, dass die Steuergelder nicht missbräuchlich verwendet werden; deckt Missstände auf; ist gemeinnützig und politisch neutral, kann sich aber zu politischen Sachfragen äussern, Stellung beziehen und Wahlempfehlungen abgeben; unterstützt ferner Massnahmen und Aktivitäten, die zur Erreichung dieses Zieles geeignet und zweckmässig sind; arbeitet insbesondere eng mit der "Stiftung Bund der Steuerzahler" zusammen und unterstützt diese auch finanziell; ist Trägerverein dieser Stiftung.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2025-07-14 00:00:00','2014-02-10 23:31:03','2025-07-14 09:17:22'),
(367,'Bürgergemeinderat der Stadt Basel',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,3,'Staatlich',NULL,NULL,'LeistungsErbringer,dezidierteLobby','punktuell',14,35,NULL,'http://www.buergergemeindebasel.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Bürgergemeinderat ist die oberste Behörde der Bürgergemeinde. Das Parlament besteht aus 40 Mitgliedern. Diese werden alle sechs Jahre von den in Basel lebenden Bürgerinnen und Bürgern gewählt. Um überhaupt wahlberechtigt zu sein, muss man das Basler Bürgerrecht besitzen. Die aktuelle Legislatur dauert vom 5. September 2023 bis Anfang September 2029.','Le conseil de la bourgeoisie est l''autorité suprême de la bourgeoisie. Il est composé de 40 membres. Ceux-ci sont élus tous les six ans par les citoyennes et citoyens vivant à Bâle. Pour avoir le droit de vote, il faut avoir la nationalité bâloise. La législature actuelle s''étend du 5 septembre 2023 à début septembre 2029.',NULL,NULL,NULL,NULL,NULL,NULL,'2025-10-28 08:58:52','2014-02-10 23:33:14','2025-10-28 08:58:52'),
(368,'Parlamentarische Gruppe Basel',NULL,NULL,NULL,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Parlamentarische Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-17 13:24:57','2019-08-16 14:28:15','2014-02-10 23:41:02','2021-02-07 14:49:02'),
(369,'Berufsübergreifende Kontroll-Vereinigung AIC',NULL,'L''Associazione Interprofessionale di Controllo (AIC)',NULL,NULL,NULL,0,0,'Bellinzona',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',51,NULL,NULL,'http://www.aic-ti.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'http://www.aic-ti.ch/node/1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 14:51:34','2021-01-03 08:52:54'),
(370,'Caisse de retraite anticipée du second oeuvre romand (RESOR)','Caisse de retraite anticipée du second oeuvre romand (RESOR)',NULL,'CHE-110.344.329',730236,'CH62670090914',1,1,'Sion',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation,DachOrganisation,LeistungsErbringer','nie',42,NULL,NULL,'http://www.resor.ch/de/portrait',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Arbeiter des Ausbaugewerbes sind einer starken körperlichen Belastung ausgesetzt, welche geeignete Massnahmen benötigt. Damit das Personal von Baustellen und Werkstätten in den Genuss einer finanziell tragbaren Frühpensionierung kommen, wurde am 22. Juni 2003 ein Kollektivvertrag für die vorzeitige Pensionierung im westschweizerischen Ausbaugewerbe (KVP) abgeschlossen.  \n\nZur Durchführung dieser Vereinbarung wurde eine neue soziale Institution gegründet: die Stiftung RESOR (Vorpensionierungskasse des Westschweizer Ausbaugewerbes). Dank der guten Zusammenarbeit aller Beteiligten konnte die Stiftung in den letzten Jahren ein schnelles und gesundes Wachstum verzeichnen.',NULL,NULL,'1950',6266,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-02-13 15:34:06','2024-04-28 10:36:59'),
(371,'Immobiliengenossenschaft COGERIM','COGERIM SOCIETE COOPERATIVE',NULL,NULL,NULL,NULL,0,0,'Genève',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Genossenschaft',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',19,NULL,NULL,'http://www.cogerim.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Notre Société est une coopérative qui gère pour le compte de divers propriétaires tels que : sociétés immobilières, PPE, fonds de prévoyance, communes, coopératives, etc., des immeubles en secteur libre ou subventionné.\n\nEn regard des exigences de ses clients et du chiffre d''affaires qu''elle réalise, notre Société peut se prévaloir de n''avoir jamais démarché un mandat de gestion à des concurrents de la branche. En effet, la quasi totalité du parc immobilier géré actuellement par COGERIM a été construit sous sa responsabilité, à la demande des propriétaires ou des promoteurs.\n\nPour l''élaboration de projets de construction, les compétences de COGERIM permettent notamment de définir très rapidement prix de revient et rendement brut d''une affaire; en cas d''exécution de celle-ci, la collaboration étroite avec des professionnels qualifiés dans la construction tels qu''architectes et ingénieurs assure une plus-value notable de son suivi.\n\nIl est à relever que les personnes responsables de COGERIM font partie de l''Association Professionnelle des Gérants et Courtiers en Immeubles de Genève (A.P.G.C.I.) et appliquent les règles de déontologie de la profession. Nous comptons également parmi nous deux régisseurs et courtiers en immeubles diplômés.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 15:53:42','2021-01-03 08:52:54'),
(372,'Egghölzli Verwaltungen AG in Liquidation',NULL,NULL,'CHE-103.047.688',49829,'CH03530045909',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',19,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/eggholzli_verwaltungen_ag_CH-035.3.004.590-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt das Erbringen von Dienstleistungen aller Art für Personen, die mit der Verwaltung von Grundstücken und/oder Wertschriften sowie mit dem Führen von juristischen Personen und/oder Handelsgesellschaften betraut sind. Die Gesellschaft kann alle Geschäfte eingehen und Verträge abschliessen, welche mit dem Gesellschaftszweck zusammenhängen, sich an anderen Unternehmen mit gleichen oder ähnlichen Zwecken beteiligen sowie Zweigniederlassungen im In- und Ausland errichten; sie kann Grundstücke erwerben, halten, belasten und veräussern.',NULL,NULL,'3015',351,NULL,NULL,NULL,'2021-09-06 08:52:34','2014-02-13 22:56:52','2024-04-28 10:36:59'),
(373,'IndustriALL Global Union',NULL,NULL,'CHE-399.862.070',1106999,'CH66014660126',1,1,'Carouge GE',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',53,NULL,NULL,NULL,'http://ge.ch/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-660-1466012-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'organiser et construire le pouvoir collectif des travailleurs et travailleuses manuels et non manuels des industries de la métallurgie, de la chimie, de l''énergie, des mines, du textile et des secteurs connexes à travers le monde, aux fins de promouvoir et défendre leurs droits et leurs intérêts communs, tant auprès des entreprises que des États (cf. statuts pour but complet).',NULL,NULL,'1227',6608,NULL,NULL,NULL,'2019-09-18 14:46:46','2014-02-13 23:09:32','2024-04-28 10:36:59'),
(374,'L''Evénement syndical SA en liquidation','Lausanne',NULL,'CHE-104.525.207',385591,'CH55000950971',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',48,NULL,NULL,'http://www.evenement.ch/','http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-0095097-1&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Französischsprachiges Pendent zur Work-Zeitung.',NULL,NULL,'1005',5586,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 23:32:09','2024-04-28 10:36:59'),
(375,'Unia Viva AG','SI Lignon-Résidence SA',NULL,'CHE-100.478.833',172500,'CH66000249649',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',19,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/si_lignon_residence_sa_CH-660.0.024.964-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Achat, vente, construction et gérance de tous immeubles en Suisse, dans le respect de la loi fédérale sur l''acquisition d''immeubles par des personnes à l''étranger.',NULL,NULL,'3015',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 23:39:17','2024-04-28 10:36:59'),
(376,'Société Immobilière Cluse-Préau SA','Société Immobilière Cluse-Préau SA',NULL,'CHE-100.379.740',170549,'CH66000149102',1,1,'Châtelaine',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',19,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/societe_immobiliere_cluse_preau_sa_CH-660.0.014.910-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: acquisition, construction, exploitation et éventuellement revente d''immeubles sis dans le canton de Genève.',NULL,NULL,'1219',6643,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 23:41:27','2024-04-28 10:36:59'),
(377,'Suva',NULL,NULL,'CHE-108.955.179',936661,'CH10087898666',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'https://www.suva.ch/','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1008789866&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Suva ist ein selbständiges Unternehmen des öffentlichen Rechts und versichert rund 115 000 Unternehmen bzw. 2 Millionen Berufstätige und Arbeitslose gegen die Folgen von Unfällen und Berufskrankheiten. Zudem führt sie im Auftrag des Bundes die Militärversicherung.',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2025-10-27 09:35:32','2014-02-13 23:49:34','2025-10-27 09:35:32'),
(378,'Tipo-Offset Aurora SA',NULL,NULL,'CHE-102.599.100',197773,'CH51430012379',1,1,'Canobbio',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',48,NULL,NULL,'http://www.tipo-aurora.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'L''esercizio di 1 tipografia per l''esecuzione di ogni genere di lavori tipografici, per l''edizione e la stampa di periodici e riviste, per la confezione di articoli da legatoria, come pure l''attività di compra-vendita di libri, riviste, dischi-cassette, la gestione di librerie o di qualsiasi altra attività a carattere culturale, ricreativo e commerciale.',NULL,NULL,'6952',5167,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 23:52:51','2024-04-28 10:36:59'),
(379,'Wohnbaugenossenschaft "Schönehof" Frauenfeld in Liquidation',NULL,NULL,'CHE-101.715.869',209959,'CH44050044698',1,1,'Frauenfeld',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Genossenschaft','0108',5,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Genossenschaft bezweckt, ihren Mitgliedern gesunde Wohnungen zu günstigen Mietzinsen zu vermitteln. Sie sucht ihren Zweck zu erreichen durch Beschaffung von geeignetem Bauland zu Eigentum oder zu Baurecht der Genossenschaft; Bau oder Erwerb von soliden, zweckmässigen Wohnhäusern und Vermietung der Wohnungen zu möglichst niedrigen Mietzinsen; Unterstützung der Bestrebungen zur Hebung der Wohnverhältnisse der Bevölkerung, insbesondere die Förderung einer planmässigen Boden- und Siedlungspolitik.',NULL,NULL,'8500',4566,NULL,NULL,NULL,'2015-03-21 00:00:00','2014-02-13 23:54:24','2024-04-28 10:36:59'),
(380,'Zivag Verwaltungen AG',NULL,NULL,'CHE-108.751.961',213090,'CH03530045387',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',19,NULL,NULL,'http://www.zivag.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Zivag Verwaltungen AG wurde im Jahre 1978 als Tochtergesellschaft der Gewerkschaft Unia gegründet.\nNeben dem Hauptsitz in Bern ist die Zivag mit einer Niederlassung in Zürich und einer Filiale in Lausanne vertreten und garantiert so eine umfassende geografische Abdeckung.\nDie Zivag Verwaltungen AG verfügt selbst über keine eigenen Immobilienbestände und bewirtschaftet ausschliesslich Liegenschaften für Dritte.',NULL,NULL,'3015',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-13 23:59:01','2024-04-28 10:36:59'),
(381,'Gewerkschaft Unia','Syndicat Unia','Sindacato Unia','CHE-105.830.937',354622,'CH03560117980',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',53,NULL,NULL,'http://www.unia.ch',NULL,'UniaSchweiz',NULL,NULL,NULL,NULL,NULL,'Die Unia vertritt die Interessen aller Arbeitnehmenden der Privatwirtschaft, berät ihre Mitglieder, bietet ihnen Rechtsschutz und weitere Dienstleistungen. Sie zählt rund 200''000 Mitglieder. Die Unia ist auch politisch aktiv und setzt sich ein für eine soziale und gerechte Gesellschaft.','Unia représente les intérêts de tous les salarié-e-s du secteur privé. Il conseille ses membres et leur offre une protection juridique ainsi que d''autres prestations. Il compte près de 200 000 membres. Unia gère aussi la plus grande caisse de chômage de Suisse. Unia est aussi actif au niveau politique et s''engage pour une société juste et sociale.',NULL,'3015',351,NULL,NULL,NULL,'2025-09-08 20:23:28','2014-02-17 11:14:23','2025-09-08 20:23:28'),
(382,'educationsuisse',NULL,NULL,'CHE-299.701.673',1116996,'CH03660553070',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,9,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',27,NULL,NULL,'http://www.educationsuisse.ch','http://infocube.ch/de/c/7027407/educationsuisse',NULL,NULL,NULL,NULL,NULL,NULL,'educationsuisse wurde im Jahr 1942 als Hilfskomitee für Auslandschweizerschulen gegründet und wurde später in Komitee für Schweizer Schulen im Ausland (KSA) umbenannt. Seit dem 1. Januar 2012 heisst der Verein educationsuisse. Im Lauf der Zeit hat sich der Verein zu einer zentralen Stelle im weltweiten Netzwerk der 17 Schweizer Schulen im Ausland entwickelt.',NULL,NULL,'3006',351,NULL,NULL,NULL,'2025-09-02 12:03:02','2014-02-19 18:08:03','2025-09-02 12:03:02'),
(383,'Stadtärztlicher Dienst Zürich',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Staatlich',NULL,NULL,'LeistungsErbringer','nie',4,NULL,NULL,'http://www.stadt-zuerich.ch/content/gud/de/index/das_departement/organisation/sgd/sgd_portrait1.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-19 19:20:08','2014-09-16 00:00:00'),
(384,'Dachverband Drogenabstinenz Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',3,NULL,NULL,'http://www.drogenpolitik.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Dachverband Drogenabstinenz Schweiz bezweckt eine präventive und abstinenzorientierte Drogenpolitik, die zum Ziel hat, den Rauschgiftmissbrauch und die Zahl der rauschgiftsüchtigen Personen nachhaltig zu reduzieren. Er informiert dazu die Bevölkerung über die Gefährlichkeit der Rauschgifte, um damit der Akzeptanz der Rauschgifte und deren Verharmlosung entgegenzutreten.\n\nMitglieder: http://www.drogenpolitik.ch/werwirsind/index.html',NULL,NULL,'3001',NULL,NULL,NULL,NULL,'2022-06-29 17:16:39','2014-02-19 20:05:49','2022-06-29 17:16:39'),
(385,'Kanton St. Gallen','Canton de Saint-Gall',NULL,'CHE-114.965.275',NULL,NULL,0,0,'St. Gallen','SG',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich','0221',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',13,NULL,NULL,'http://www.sg.ch/k/reg.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9001',3203,NULL,NULL,NULL,'2025-08-20 13:00:19','2014-02-19 20:11:17','2025-08-20 13:00:19'),
(387,'Soliswiss - Genossenschaft der Schweizer im Ausland',NULL,NULL,'CHE-107.813.482',226187,'CH03550062762',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','punktuell',12,NULL,NULL,'www.soliswiss.ch','http://www.moneyhouse.ch/u/genossenschaft_solidaritatsfonds_der_auslandschweizer_CH-035.5.006.276-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Solidaritätsfonds bezweckt die Vereinigung der Auslandschweizer zur gemeinsamen Selbsthilfe bei Existenzverlusten im Ausland, welche durch Kriege, innere Unruhen oder allgemeine politische Zwangsmassnahmen verursacht und nicht selbstverschuldet sind sowie zur Äufnung persönlicher Vorsorgegelder. Als Existenzverlust gilt jede wesentliche und nicht bloss vorübergehende Einbusse in der wirtschaftlichen Stellung eines Genossenschafters oder anderen Anspruchsberechtigten, insbesondere durch erhebliche und nicht unmittelbar ausgeglichene Beeinträchtigung der Einkommensgrundlage und Erwerbsmöglichkeiten. Um den Zweck der Existenzsicherung weiter zu unterstützen, vermittelt die Genossenschaft seinen Mitgliedern Geld- und Kapitalanlagen, Kranken- und Lebensversicherungen. Sie kann sich im Rahmen ihres Zwecks an anderen Unternehmen beteiligen und auch Nicht-Mitgliedern Dienstleistungen anbieten.',NULL,NULL,'3008',351,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-02-20 09:59:26','2025-02-13 09:16:35'),
(388,'Institut für Sicherheitsanalysen und strategisches Networking - Stiftung (ISSN)',NULL,NULL,'CHE-113.829.155',884983,'CH17070006677',1,1,'Zug','ISSN',NULL,NULL,NULL,NULL,NULL,191,NULL,'Stiftung','0110',7,'EinzelOrganisation','nie',72,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'-Objektive, strukturelle und fachübergreifende Analyse der Sicherheitssituation der Bevölkerung \n-Untersuchung des Gefährdungspotentials durch Extremismus, Rassismus und religiösen Fanatismus durch Gruppierungen oder Einzelpersonen\n-Erstellen entsprechender Berichte\n-Grundlagenforschung und Lehrtätigkeit zu den Phänomenen u.a. der illegalen Gewaltanwendung, des Terrorismus, der systematischen Aufhetzung zu Gewalt und Ausgrenzung\n-Strategische Vernetzung mit in- und ausländischen Know-how Trägern, akademischen und privaten Instituten\n(...)',NULL,NULL,'6302',1711,NULL,NULL,NULL,'2023-06-10 14:16:50','2014-02-20 10:20:40','2024-04-28 10:36:59'),
(389,'Farner St. Gallen AG',NULL,NULL,'CHE-115.271.152',964870,'CH32030663238',1,1,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',18,NULL,NULL,'http://www.yjoo.ch','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3203066323&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'YJOO ist eine Agentur für Kommunikation, die durch Relevanz Orientierung und nachhaltige Vertrauens-beziehungen schafft. Wir entwickeln Strategien, Inhalte, Form, Design und Prozesse - schweizweit an unseren Standorten Zürich, St.Gallen, Lausanne und Lugano.',NULL,NULL,'9001',3203,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-02-20 10:35:26','2025-02-13 09:16:35'),
(390,'SECONAIR GmbH',NULL,NULL,'CHE-109.460.331',664793,'CH17040036055',1,1,'Baar',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',116,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/seconair_gmbh_CH-170.4.003.605-5.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Beratung in sämtlichen fliegerischen Fachgebieten, Erarbeitung von Verfahren und Vorschriften für die Flugoperationen, Testen und Entwicklung von neuem Fluggerät und -material, Sachbearbeitung im Flight-Security Bereich inklusive weltweiten Sicherheitsabklärungen und Durchführung von Audits in der Flight Security sowie Vertretungen in internationalen Gremien der Aviatik; kann Patente, Lizenzen und Herstellungsverfahren erwerben, entwickeln, verwalten und verwerten, sich an Unternehmungen der gleichen Art beteiligen sowie Liegenschaften erwerben, veräussern und verwalten',NULL,NULL,'6340',1701,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-20 10:39:05','2024-04-28 10:36:59'),
(391,'Hirslanden AG',NULL,NULL,'CHE-113.796.171',882937,'CH02030314114',1,1,'Glattpark (Opfikon)',NULL,'Privatklinikgruppe Hirslanden AG',NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'https://www.hirslanden.ch/global/de/startseite.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Privatklinikgruppe Hirslanden umfasst 14 Kliniken in 10 Kantonen mit insgesamt über 100 integrierten Kompetenzzentren und mehr als 50 spezialisierten Instituten. Sie finden in jeder einzelnen Klinik optimale Voraussetzungen für eine rasche und umfassende Behandlung.','Le Groupe de cliniques privées Hirslanden gère 16 cliniques, dont beaucoup possèdent une clinique ambulatoire et un service d''urgence, 4 centres médicaux ainsi que 14 instituts de radiologie et 4 instituts de radiothérapie, ce qui fait de ce groupe le plus important réseau médical en Suisse.',NULL,'8152',66,NULL,NULL,NULL,'2021-02-24 09:55:13','2014-02-20 17:37:38','2024-04-28 10:36:59'),
(393,'Verband Schweizerischer Schreinermeister und Möbelfabrikanten',NULL,NULL,'CHE-105.959.169',245566,'CH02069005828',1,1,'Wallisellen',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',52,NULL,NULL,'www.vssm.ch','www.moneyhouse.ch/u/verband_schweizerischer_schreinermeister_und_mobelfabrikanten_CH-020.6.900.582-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verband Schweizerischer Schreinermeister und Möbelfabrikanten repräsentiert rund 2300 Schreinereien der deutschen und italienischen Schweiz. Dabei übernimmt der Verband übergeordnete Aufgaben aus unterschiedlichen Bereichen:\n\nVerhandlungen mit Gewerkschaften und Erarbeitung der Gesamtarbeitsverträge GAV\nEntwicklungen bezüglich der Grundausbildung im Lehrlingsbereich\neigenes Weiterbildungszentrum auf dem Bürgenstock\nzentrale Stelle für Marketing, Marktforschung und Werbedienstleistungen\ntechnische und betriebswirtschaftliche Beratung\nHerausgeber der wöchentlich erscheinenden Schweizerischen SchreinerZeitung\neigener Verlag mit Büchern, Lehrmitteln und Textilien\nKompetenzzentrum in Sachen ISO-Zertifizierung und Brandschutz\nDienstleistungszentrum bezüglich Buchhaltungen, Mehrwertsteuerberatungen und Firmenanalysen\nVollservice bezüglich Internetdienstleistungen Web-Design, eigene Internetplattform und Internetberatung',NULL,NULL,'8304',69,NULL,NULL,NULL,'2021-12-24 00:00:00','2014-02-20 18:13:03','2024-04-28 10:36:59'),
(394,'HKG Engineering AG Baden',NULL,NULL,'CHE-106.119.350',345943,'CH40030162128',1,1,'Dättwil AG','HKG',NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',50,52,NULL,'www.hgk.ch','http://www.moneyhouse.ch/u/herzog_kull_group_baden_ag_CH-400.3.016.212-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Planung und Projektierung von haus- und netztechnischen Anlagen, insbesondere im elektrotechnischen Bereich; die Gesellschaft kann sich an andern Unternehmen beteiligen, Zweigniederlassungen und Tochtergesellschaften errichten sowie Grundeigentum erwerben, belasten, verwalten und veräussern.',NULL,NULL,'5405',4021,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-24 18:37:49','2024-04-28 10:36:59'),
(398,'Oncosuisse, Schweizerische Vereinigung gegen Krebs','Oncosuisse,  l''union suisse contre le cancer','Programma nazionale contro il cancro',NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',6,41,NULL,'http://www.oncosuisse.ch/seiten/krebsprogramm/?oid=1813&lang=de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Vereinigung gegen Krebs, Oncosuisse, ist ein Zusammenschluss von fünf Schweizer Organisationen die sich der Bewältigung der Krebskrankheit widmen. Sie wurde 1999 gegründet und ist als einfache Gesellschaft organisiert. Ihre Hauptaufgabe ist die Koordination Politik zur Krebsbekämpfung in der Schweiz. Finanziert wird Oncosuisse durch Mitgliederbeiträge der Gesellschafter und durch Beiträge aus dem Co-Patronat der GDK.','Oncosuisse, l''union suisse contre le cancer, est un regroupement de cinq organisations suisses qui se consacrent à la lutte contre le cancer. Fondée en 1999, elle est organisée en tant que société simple. Sa principale mission est de coordonner la politique de lutte contre le cancer en Suisse. Oncosuisse est financée par les cotisations des sociétaires et par les contributions du co-patronage de la CDS.',NULL,'3008',NULL,NULL,NULL,NULL,'2022-03-05 12:26:24','2014-02-24 19:11:20','2022-03-05 12:26:24'),
(401,'Feriengemeinschaft al Forno Pila-Intragna',NULL,NULL,NULL,NULL,NULL,0,0,'Intragna',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',60,NULL,NULL,'http://www.al-forno.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Al Forno ist eine Feriengemeinschaft im Tessin. Sechs	Häuser liegen auf einer sonnigen und grünen Terrasse über Intragna, am Taleingang des Centovalli. Die Häuser können teilweise oder als Ganzes gemietet werden.\n\nTräger ist heute ein kleiner, der SP nahe stehender Verein, dessen Mitglieder sich für die bestmögliche Wahrung der Feriengemeinschaft Al Forno mit ihrem ideellen Erbe verpflichtet haben.',NULL,NULL,'6655',NULL,NULL,NULL,NULL,'2017-06-03 19:49:31','2014-02-24 19:21:10','2022-03-29 19:51:54'),
(402,'Spitex Schweiz','Association suisse des services d''aide et de soins à domicile',NULL,'CHE-108.308.399',NULL,NULL,0,0,'Bern 23',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',7,NULL,NULL,'http://www.spitex.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verband fördert die Entwicklung der Hilfe und Pflege zu Hause (Spitex). Er setzt sich \ndafür ein, dass die Versorgung der Bevölkerung durch Spitex-Dienstleistungen zu einer \ntragenden Säule des Gesundheits- und Sozialwesens wird. \n2. Als Arbeitgeber-Dachverband unterstützt er seine Mitglieder und die Spitex-Organisationen \nbei der Erfüllung ihrer Aufgaben und vertritt deren Interessen nach aussen. \n3. Als Fachverband befasst er sich mit allen spitexrelevanten Fragen. Dazu arbeitet er eng \nmit den anderen im Spitexbereich sowie im Gesundheits- und Sozialwesen tätigen \nOrganisationen, Institutionen und Behörden zusammen. \n4. Er übt insgesamt eine Koordinationsfunktion im Spitexbereich aus.',NULL,NULL,'3000',351,NULL,NULL,NULL,'2025-07-01 18:42:17','2014-02-24 21:10:00','2025-07-01 18:42:17'),
(403,'Aargauischer Tierschutzverein',NULL,NULL,'CHE-113.682.076',875180,'CH40060288187',1,1,'Untersiggenthal',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'EinzelOrganisation,MitgliedsOrganisation','punktuell',55,NULL,NULL,'http://www.tierschutz-aargau.ch/','http://www.moneyhouse.ch/u/aargauischer_tierschutzverein_CH-400.6.028.818-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein bezweckt die Förderung aller Anliegen des Tierschutzes. Er stellt sich vor allem zur Aufgabe, die Oeffentlichkeit über die Bedeutung sowie den ethnischen Wert des Tierschutzgedankens und der damit verbundenen Fragen aufzuklären. Er will alle berechtigten Interessen des Tierschutzes fördern, verteidigen und insbesondere durch Vorschläge und Aufklärung bei Behörden und Verwaltungen die gebührende rechtliche und wirtschaftliche Berücksichtigung des Tierschutzes wecken.',NULL,NULL,'5417',4044,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-24 21:23:05','2024-04-28 10:36:59'),
(404,'Swiss Women Network Swonet',NULL,NULL,NULL,NULL,NULL,0,0,'Dintikon',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',67,NULL,NULL,'www.swonet.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Internetportal SWONET ist der virtuelle Partner von alliance F, dem Dachverband der Schweizer Frauenorganisationen. SWONET bietet die Möglichkeit, sich mit einem Click über die Ziele und Aktivitäten verschiedenster Frauenorganisationen zu informieren. Das Portal SWONET ist kein weiterer Club oder Dachverband, sondern ausschliesslich ein unabhängiges Informationsportal.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-24 21:30:08','2014-09-16 00:00:00'),
(405,'Verein TIXI Aargau',NULL,NULL,'CHE-411.435.611',NULL,NULL,0,0,'Mägenwil',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,Gemeinnuetzig','nie',12,NULL,NULL,'http://www.tixi-ag.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'TIXI AARGAU ist ein gemeinnütziger, politisch und konfessionell neutraler Verein.',NULL,NULL,NULL,4032,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-24 21:34:04','2022-09-25 22:33:13'),
(406,'Sport Heart GmbH',NULL,NULL,'CHE-110.188.816',716897,'CH02040274306',1,1,'Schlieren',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',65,NULL,NULL,'http://www.sportheart.ch','http://www.moneyhouse.ch/u/sport_heart_gmbh_CH-020.4.027.430-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Sport Heart trägt mit gezielten finanziellen Beiträgen dazu bei, dass sich im Moment insgesamt mehr als 15 ausgewählte Einzel- und Teamathleten aus finanziell schwachen Randsportarten optimal auf die Olympischen Spiele in London 2012 sowie Soochi 2014 vorbereiten können.',NULL,NULL,'8952',247,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-24 21:39:20','2024-04-28 10:36:59'),
(407,'Avantidonne - Kontaktstelle für Frauen und Mädchen mit Behinderung',NULL,NULL,NULL,NULL,NULL,0,0,'Rüti',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',15,NULL,NULL,'http://avantidonne.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'avanti donne engagiert sich mit Grundlagenarbeit, Projekten und Angeboten speziell für Frauen und Mädchen mit Behinderung für die Gleichstellung - und damit für die Förderung der Selbstbestimmung, der Chancengleichheit und Lebensqualität aller Betroffenen.',NULL,NULL,'8630',NULL,NULL,NULL,NULL,'2022-09-17 00:00:00','2014-02-24 21:47:48','2022-09-17 15:57:00'),
(408,'Respekt ist Pflicht - für alle',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Informelle Gruppe',NULL,NULL,'LeistungsErbringer,dezidierteLobby','nie',67,NULL,NULL,'http://www.arip.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Aktion: " Respekt ist Pflicht- für alle." ist eine Kampagne gegen sexuelle, körperliche und psychische Gewalt, welche interaktiv und partizipativ mit Mädchen und junge Frauen zusammenarbeitet, ihr Selbstbewusstsein stärken soll und sie in die Arbeit ressourcenorientiert einbezieht.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-03-11 11:19:25','2014-02-24 21:53:51','2021-01-03 08:52:54'),
(409,'SwissMediaForum AG',NULL,NULL,'CHE-398.301.722',1229985,'CH40034400225',1,1,'Baden',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',62,NULL,NULL,'https://www.swissmediaforum.ch/','http://www.moneyhouse.ch/u/swissmediaforum_ag_CH-400.3.033.560-1.htm','SwissMediaForum',NULL,NULL,NULL,NULL,NULL,'Das Treffen wichtiger Vertreter aus Medien, Kommunikation, Wirtschaft und Politik im KKL Luzern.',NULL,NULL,'5400',4021,NULL,NULL,NULL,'2023-03-23 12:31:30','2014-02-24 22:01:30','2024-04-28 10:36:59'),
(410,'AWI AG','Clear Channel AWI SA','Clear Channel AWI SA','CHE-105.909.237',409011,'CH02039022792',1,1,'Hünenberg','AWI',NULL,NULL,NULL,NULL,NULL,191,4,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',125,NULL,NULL,'http://www.clearchannel.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Erstellung von Plakatwänden und anderer Reklameobjekte und deren Vermietung, Übernahme von Reklamezessionen und Nutzung derselben sowie Betätigung im gesamten Gebiete der Reklame- und Verkaufsorganisation; vollständige Zweckumschreibung gemäss Statuten.',NULL,NULL,'6331',1703,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-25 17:51:45','2024-04-28 10:36:59'),
(411,'Krebsliga Aargau',NULL,NULL,'CHE-107.344.547',1029897,'CH40060344812',1,1,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein','0109',6,'MitgliedsOrganisation','nie',6,1,NULL,'http://www.krebsliga-aargau.ch/de/','http://www.moneyhouse.ch/u/krebsliga_aargau_CH-400.6.034.481-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein fördert und unterstützt Massnahmen zur Verhütung, Früherfassung und Behandlung von Krebskrankheiten. Er setzt sich insbesondere die folgenden Aufgaben zum Ziel: Aufklärung der Bevölkerung und der im Gesundheitswesen tätigen Fachleute; finanzielle sowie psychosoziale und psychotherapeutische Unterstützung krebskranker Patienten und ihrer Familien; Förderung der ambulanten Onkologiepflege und Förderung der wissenschaftlichen Krebsforschung.',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-25 18:06:41','2024-04-28 10:36:59'),
(412,'Ombudsstelle E-Commerce',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Einfache Gesellschaft',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',81,NULL,NULL,'http://www.konsum.ch/ombudsstelle',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Ombudsstelle E-Commerce hilft Ihnen kostenlos, wenn Sie eine Beschwerde zu einem bestimmten Unternehmen basierend auf einem Einkauf im Internet haben, welches Sie nicht selber, respektive in für beide Seiten zufriedenstellender Übereinkunft lösen können.',NULL,NULL,'3007',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-25 18:38:12','2019-08-26 10:08:34'),
(413,'VSV Verband des Schweizerischen Versandhandels','Association Suisse de vente à distance',NULL,'CHE-103.906.618',204178,'CH02069006531',1,1,'Bern','VSV',NULL,'ASVAD',NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation','punktuell',74,NULL,NULL,'http://vsv-versandhandel.ch/','http://www.moneyhouse.ch/u/vsv_verband_des_schweizerischen_versandhandels_CH-020.6.900.653-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein bezweckt die Förderung der gemeinsamen wirtschaftlichen Interessen, insbesondere durch aktive Intervention im Sinne einer liberalen Wirtschaftsordnung bei Behörden, Institutionen und Konsumenten in der Schweiz. Darunter versteht sich auch das Einwirken auf die Schaffung von gleichen Rahmenbedingungen für Schweizer Versender im Ausland (EU) wie für ausländische Versender (aus der EU) in der Schweiz; die Pflege der Kontakte und des Erfahrungsaustausches unter den Aktivmitgliedern des Verbandes unter Wahrung ihrer unternehmerischen Eigenständigkeit im Wettbewerb; die gemeinsame Werbung für den Versandhandel der Verbandsmitglieder.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-25 18:46:23','2024-04-28 10:36:59'),
(414,'Ticketcorner Holding AG','Ticketcorner Holding SA',NULL,'CHE-108.563.514',453108,'CH02030193984',1,1,'Rümlang',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',47,NULL,NULL,'http://www.ticketcorner.ch','http://www.moneyhouse.ch/u/ticketcorner_holding_ag_CH-020.3.019.398-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Gesellschaft bezweckt den Erwerb, das Halten und die Verwaltung sowie die Veräusserung von Beteiligungen an Unternehmen der Schweiz und im Ausland. Die Gesellschaft kann im In- und Ausland Zweigniederlassungen und Tochtergesellschaften errichten. Sie kann Grundstücke erwerben, halten und veräussern. Die Gesellschaft kann alle kommerziellen, finanziellen und anderen Tätigkeiten ausüben, welche mit dem Zweck der Gesellschaft im Zusammenhang stehen, eingeschlossen die Gewährung von Darlehen an Aktionäre und Unternehmen, an denen sie Beteiligungen hält. Die Gesellschaft kann Finanzierungsverträge mit oder zugunsten ihrer Aktionäre und nahestehender Personen eingehen sowie für Verpflichtungen ihrer Aktionäre und nahestehnder Personen Sicherheiten insbesondere in Form von Garantien und Pfändern stellen.',NULL,NULL,'8153',97,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-25 18:52:06','2024-04-28 10:36:59'),
(415,'alliance F - Bund Schweizerischer Frauenorganisationen','alliance F - Alliance de sociétés féminines suisses',NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',67,NULL,NULL,'https://alliancef.ch',NULL,'alliance_F',NULL,NULL,NULL,NULL,NULL,'alliance F ist der grösste Schweizerische Frauendachverband, der sich seit 113 Jahren für die Anliegen der Frauen engagiert. alliance F zählt ca. 140 Mitgliederverbände (s. Netzwerk - angeschlossene Organisationen) und 400 Einzelmitglieder. Damit vertritt alliance F die Interessen von etwa 400''000 Frauen in der Schweiz. Der Verband versteht sich heute als politische Lobby-Organisation für die Anliegen im Zusammenhang mit der Gleichstellung von Frau und Mann in Beruf, Familie und Gesellschaft.',NULL,NULL,'3011',NULL,NULL,NULL,NULL,'2025-09-26 16:29:22','2014-02-25 19:03:54','2025-09-26 16:29:22'),
(416,'femdat.ch',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation','nie',74,NULL,NULL,'www.femdat.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'femdat.ch bietet ambitionierten Frauen und Akademikerinnen das umfassendste Stellennetz.\nfemdat.ch begleitet Unternehmen und Frauen bei Ein-, Auf- und Umstieg mit Expertise, Netzwerk und Beratung.',NULL,NULL,'8004',NULL,NULL,NULL,NULL,'2018-10-07 11:40:55','2014-02-25 19:09:43','2021-01-03 08:52:54'),
(417,'Reliva AG',NULL,NULL,'CHE-149.550.710',1007237,'CH02030359592',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'AG','0106',3,'EinzelOrganisation','nie',5,NULL,NULL,'www.reliva.ch/','http://www.moneyhouse.ch/u/reliva_patientenhotel_ag_CH-020.3.035.959-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Reliva entwickelt, baut und betreibt Patientenhotels in der Schweiz. Das erste Patientenhotel wird 2016 auf dem Campus des Centre hospitalier universitaire vaudois (CHUV) in Lausanne eröffnet. Weitere sind geplant.\nEin Patientenhotel erbringt Dienstleistungen in der Pflege, der Beherbergung und der Gastronomie. Es betreut Patienten, welche immer noch der Spital-Pflege bedürfen, aber nicht mehr auf der akut-stationären Bettenstation betreut werden müssen. Das Patientenhotel befindet sich jeweils in unmittelbarer Nähe zu einem oder mehreren Akutspitälern, mit welchen eine enge betriebliche Zusammenarbeit besteht.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-02-26 23:03:16','2024-04-28 10:36:59'),
(418,'CSD Holding AG',NULL,NULL,'CHE-101.754.183',241481,'CH03530034427',1,1,'Givisiez','CSD',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',NULL,NULL,NULL,'http://csd.ch/de/page-daccueil.html','http://www.moneyhouse.ch/u/csd_holding_ag_CH-035.3.003.442-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'CSD ist eines der führenden Schweizer Ingenieur- und Beratungsunternehmen. CSD ist in den Bereichen Ingenieurbau, Umwelt und natürliche Ressourcen tätig.',NULL,NULL,'1762',2197,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-04 17:37:38','2024-04-28 10:36:59'),
(419,'Swiss eHealth Forum',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.infosocietydays.ch/eHealth',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Vormals Swiss InfoSocietyDays. Über 1''000 Interessierte aus Wirtschaft, Verwaltung und Gesundheitswesen nehmen jedes Jahr an den InfoSocietyDays in Bern teil. Der Kongress für Anwendungen der Informations- und Kommunikationstechnologien (ICT) behandelt mit den drei Foren Swiss eEconomy Forum, Swiss eGovernment Forum und Swiss eHealth Forum drei wichtige Kernthemen der Informationsgesellschaft. Der Fokus liegt auf Einsatz und Nutzen der ICT für Wirtschaft, Verwaltung und Gesundheitswesen.',NULL,NULL,'3006',NULL,NULL,NULL,NULL,'2014-10-05 20:50:00','2014-03-04 18:07:03','2021-01-03 08:52:54'),
(420,'Energie-Agentur der Wirtschaft (EnAW)',NULL,NULL,'CHE-109.341.465',654739,'CH02060006463',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer','nie',31,NULL,NULL,'http://www.enaw.ch/de/','http://www.zefix.ch/zfx-cgi/hrform.cgi/hraPage?alle_eintr=on&pers_sort=original&pers_num=0&language=1&col_width=366&amt=007',NULL,NULL,NULL,NULL,NULL,NULL,'Bezweckt, als private Organisation der schweizerischen Wirtschaft mit dem Bund wirtschaftsnahe Aufgaben im Energiebereich gemäss der Bundesgesetzgebung zu vereinbaren und diese Aufgaben durchzuführen; kann von den Mitgliedern mit weiteren Aufgaben zur Entwicklung und Umsetzung energiewirtschaftlicher Instrumente betraut werden.',NULL,NULL,'8032',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-05 18:37:57','2025-02-13 09:16:34'),
(421,'proparis Vorsorge-Stiftung Gewerbe Schweiz',NULL,NULL,'CHE-107.813.246',292974,'CH03570126807',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'DachOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://www.zefix.ch/zfx-cgi/hrform.cgi/hraPage?alle_eintr=on&pers_sort=original&pers_num=0&language=1&col_width=366&amt=007',NULL,NULL,NULL,NULL,NULL,NULL,'Die proparis verfolgt den Zweck, eine berufliche Alters-, Hinterlassenen- und Invalidenvorsorge für die Arbeitnehmer im Gewerbe und die gewerblichen Selbständigerwerbenden anzubieten und durchzuführen. Aus den Stiftungsmitteln werden keine Leistungen erbracht, zu denen ein Arbeitgeber aus dem Arbeitsverhältnis gesetzlich oder vertraglich verpflichtet ist. Der proparis können sich alle zum Schweizerischen Gewerbeverband gehörenden Organisationen (Verbände, Selbstshilfeorganisationen und Institutionen) anschliessen. Im Weiteren vgl. Stiftungsurkunde.\n\nDie proparis Vorsorge-Stiftung Gewerbe Schweiz ist eine Sammelstiftung von 13 verbandlichen Gemeinschaftsstiftungen mit Sitz in Bern.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-05 18:53:22','2025-02-13 09:16:34'),
(422,'Fourchette verte Schweiz - Das Label der ausgewogenen Ernährung','Fédération Fourchette verte Suisse - Le label de l''alimentation équilibrée','Fourchette verte Svizzera - Il marchio dell''alimentazione equilibrata',NULL,NULL,NULL,0,0,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','nie',3,NULL,NULL,'http://www.fourchetteverte.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein koordiniert die kantonalen Sektionen von Fourchette verte in den Kantonen Genf, Tessin, Waadt, Freiburg, Neuenburg, Wallis, Jura, Bern, Solothurn, Aargau und Thurgau.\n\nDie Ziele von Fourchette verte Schweiz richten sich nach der Strategie "Gesundheit für alle" (Gesundheit 21) der WHO.\n\nFourchette verte fördert ein bewusstes Ernährungsverhalten und eine Lebensstiloptimierung.','La fédération regroupe les sections cantonales de Fourchette verte dans les cantons de Genève, Tessin, Vaud, Fribourg, Neuchâtel, Valais, Jura, Berne, Soleure, Argovie et Thurgovie.\n\nLes buts de Fourchette verte Suisse s''inscrivent dans la stratégie de la "Santé pour tous" (Santé 21) de l''OMS.\n\nFourchette verte s''investit de manière à promouvoir des modes d''alimentation et de vie sains.',NULL,'1007',NULL,NULL,NULL,NULL,'2016-10-17 21:34:42','2014-03-05 18:57:48','2021-01-03 08:52:54'),
(423,'Schweizeisches Institut für Unternehmerschulung im Gewerbe (SUI)',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',59,NULL,NULL,'http://www.siu.ch','http://www.zefix.ch/zfx-cgi/hrform.cgi/hraPage?alle_eintr=on&pers_sort=original&pers_num=0&language=1&col_width=366&amt=007',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Genossenschaft ist die allgemeine Förderung der Unternehmungsführung und die systematische Organisation der Unternehmeraus- und -weiterbildung in Gewerbe, Dienstleistung und Handel der Schweiz. Die Genossenschaft verfolgt keinen Erwerbszweck.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-12 12:49:14','2014-03-05 19:06:39','2019-09-12 12:49:14'),
(424,'Institut für Sozial- und Präventivmedizin, IUMSP','Institut universitaire de médecine sociale et préventive (IUMSP)',NULL,NULL,NULL,NULL,0,0,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,'http://www.iumsp.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-05 19:32:19','2016-08-31 21:39:21'),
(425,'Université de Lausanne','Université de Lausanne',NULL,'CHE-136.500.832',NULL,NULL,0,0,'Lausanne','UNIL',NULL,'UNIL',NULL,NULL,NULL,191,1,'Staatlich','0224',NULL,'DachOrganisation,LeistungsErbringer','immer',41,NULL,NULL,'http://www.unil.ch/index.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1015',5635,NULL,NULL,NULL,'2025-10-07 16:26:12','2014-03-05 19:38:28','2025-10-07 16:26:12'),
(426,'Università della Svizzera italiana',NULL,'Università della Svizzera Italiana','CHE-106.830.650',376704,'CH51480126903',1,1,'Lugano',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'DachOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: L''Università della Svizzera italiana sostiene la creazione, la trasmissione e la circolazione della conoscenza, incentiva il trasferimento e la valorizzazione dei risultati della ricerca e promuove la diffusione della cultura e della lingua italiana.',NULL,NULL,'6900',5192,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-05 19:43:18','2025-02-13 09:16:35'),
(427,'Schweizerische Gesundheitsstiftung Radix',NULL,NULL,'CHE-110.395.344',323281,'CH02079037239',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',3,NULL,NULL,'http://www.radix.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'RADIX ist ein nationales Kompetenzzentrum für die Entwicklung und Umsetzung von Massnahmen der öffentlichen Gesundheit. Auftraggeber von RADIX sind Bund und Kantone sowie private Organisationen und Unternehmen. Die thematischen Schwerpunkte sind Bewegung und Ernährung, psychische Gesundheit, Sucht und Gewalt. Gesundheitsförderung wird als Teildimension von Nachhaltiger Entwicklung verstanden. Die Dienstleistungen von RADIX fördern den Wissenstransfer, die Innovation, die Qualität und die Wirksamkeit.\n\nRADIX besteht seit 1972 als gemeinnützige, privatrechtliche Stiftung. Die damals gegründete Schweizerische Stiftung für Gesundheitserziehung fusionierte 1992 mit dem Verein RADIX Gesundheitsförderung in der Gemeinde. Dem gesundheitspolitischen Bedarf entsprechend entwickelt sich RADIX kontinuierlich weiter.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2022-09-16 00:00:00','2014-03-05 19:49:59','2024-04-28 10:36:59'),
(428,'Alliance Santé',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',2,NULL,NULL,'http://alliance-sante.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Unter dem Dach der alliance santé haben sich namhafte Organisationen und Verbände von Spitälern, Ärztinnen und Ärzten sowie weiteren Leistungserbrin­gern, Konsumenten, Krankenversicherern, Wirtschaft und Gewerbe zusammen­geschlossen, um sich gemeinsam mit der Politik gegen die Einheitskassen-Initiative zu engagieren.\n\nMitgliederliste:\nhttp://alliance-sante.ch/mitglieder/',NULL,NULL,'8001',NULL,NULL,NULL,NULL,'2018-03-03 17:32:26','2014-03-05 21:44:48','2021-01-03 08:52:54'),
(429,'curafutura - Die innovativen Krankenversicherer','Curafutura - Les assureurs-maladie innovants','Curafutura - Gli assicuratori-malattia innovative','CHE-329.365.671',1138041,'CH03660569545',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',2,NULL,NULL,'http://www.curafutura.ch','http://www.moneyhouse.ch/u/curafutura__die_innovativen_krankenversicherer_CH-036.6.056.954-5.htm','curafutura',NULL,'curafuturadieinnovativenkr5142',NULL,'https://www.linkedin.com/company/curafutura/',NULL,'curafutura - das ist der Verband der Krankenversicherer CSS Versicherung, Helsana und Sanitas. curafutura setzt sich für ein "solidarisch gestaltetes und wettbewerblich organisiertes" Gesundheitssystem ein.','curafutura - c''est l''association des assureurs-maladie CSS Assurance, Helsana et Sanitas. curafutura s''engage pour un système de santé " solidaire et organisé selon les principes de la concurrence ".',NULL,'3011',351,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-05 21:51:19','2025-02-13 09:16:35'),
(430,'Délégation de Taïwan, République de Chine','Délégation de Taiwan, République de Chine',NULL,'CHE-104.114.643',238990,'CH03560176050',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,7,'Verein','0109',6,'EinzelOrganisation,dezidierteLobby','nie',40,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/delegation_de_taiwan_republique_de_chine_CH-035.6.017.605-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung freundschaftlicher, wirtschaftlicher, kultureller oder touristischer Beziehungen zwischen der Schweiz und der Republik China (Taiwan) sowie Öffnung neuer Absatzmärkte für die schweizerische und die chinesische Industrie und Handel, usw.','Promouvoir les relations amicales, économiques, culturelles ou touristiques entre la Suisse et la République de Chine (Taïwan) et ouvrir de nouveaux débouchés pour l''industrie et le commerce suisses et chinois, etc.',NULL,'3005',351,NULL,NULL,NULL,'2025-09-02 11:10:44','2014-03-05 22:01:46','2025-09-02 11:10:44'),
(431,'Swisstasting Sàrl',NULL,NULL,'CHE-440.624.002',1130048,'CH03640563553',1,1,'Epalinges',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation','nie',38,NULL,NULL,'http://www.swisstasting.com/','http://www.moneyhouse.ch/u/swisstasting_sarl_CH-036.4.056.355-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'La Suisse authentique à déguster \nDs Unternehmen will in der Herstellung, Konstruktion, Entwicklung, Förderung, Verteilung und Verkauf über das Internet und andere Produkte zur Übertragung Swiss Geschmacksrichtungen, darunter Wein, Schokolade und Käse.',NULL,NULL,'1066',5584,NULL,NULL,NULL,'2017-09-01 06:59:14','2014-03-05 22:11:30','2024-04-28 10:36:59'),
(432,'Komitee für ein selbständiges Baselbiet',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,NULL,'Verein',NULL,NULL,'MitgliedsOrganisation','nie',13,NULL,NULL,'http://probaselbiet.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-28 14:32:15','2014-03-11 22:15:44','2023-08-28 14:32:15'),
(433,'SPEDLOGSWISS Verband schweizerischer Speditions- und Logistikunternehmen','Spedlogswiss Association Suisse des transitaires et des entreprises de logistique','Spedlogwiss Associazione Svizzera delle imprese di spedizione e logistica','CHE-100.088.030',435652,'CH27060001380',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation','punktuell',36,NULL,NULL,'http://www.spedlogswiss.ch','http://www.moneyhouse.ch/u/spedlogswiss_verband_schweizerischer_speditions_und_logistikunternehmen_CH-270.6.000.138-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Unterstützung der Verbandsmitglieder in wirtschaftlichen und unternehmerischen Belangen, Vertretung ihrer Interessen und Förderung der Speditionsbranche auf nationaler und internationaler Ebene.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2023-08-28 14:32:15','2014-03-11 22:23:30','2024-04-28 10:36:59'),
(434,'Swiss Reha',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer','punktuell',5,NULL,NULL,'www.swiss-reha.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'SW!SS REHA, die Vereinigung der führenden Rehabilitationskliniken der Schweiz, repräsentiert die namhaften Schweizer Rehabilitationskliniken aller Fachrichtungen. Diese verfügen zusammen über 2''391 Betten und damit über 50% des gesamtschweizerischen Bettenbestandes im Rehabilitationsbereich.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-28 14:32:15','2014-03-11 22:30:24','2023-08-28 14:32:15'),
(435,'Schweizerischer Verband der Bürgergemeinden und Korporationen','Fédération Suisse des Bourgeouisies et Corporations','Federazione Svizzera dei Patriziati',NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,3,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',35,NULL,NULL,'http://www.svbk.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hauptzwecke des Verbandes sind:\na) die Erhaltung und Pflege der bürgerlichen Institutionen\nb) die Wahrung der Interessen und die Beratung der Bürgergemeinden und Korporationen\nc) die Förderung und Stärkung der freundeidgenössischen Beziehungen unter den Mitgliedern',NULL,NULL,'3011',NULL,NULL,NULL,NULL,'2023-08-28 14:32:15','2014-03-11 22:37:59','2024-09-24 13:43:04'),
(436,'Stiftung centro del bel libro',NULL,NULL,'CHE-114.269.023',266610,'CH03570169141',1,1,'Steffisburg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',34,NULL,NULL,'www.cbl-ascona.ch/','http://www.moneyhouse.ch/u/stiftung_centro_del_bel_libro_CH-035.7.016.914-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Das centro del bel libro ascona bietet Handbuchbindern, Grafiker, Restauratoren und Interessenten mit entsprechenden Qualifikationen ein anspruchsvolles Forum kreativer Auseinandersetzung in technischer wie in gestalterischer Hinsicht. Die Kursteilnehmer können sich nach internationalen Methoden und Techniken weiterqualifizieren, ihre Fähigkeiten und Kenntnisse vertiefen, sich überprüfen und anregen, sich mit anderen austauschen und Wege gehen, die Ihnen im Alltag meist versagt bleiben - in kreativer Praxis und Selbstreflexion, fern von Berufsalltag, fern von Routine, Zeit- und Leistungsdruck.',NULL,NULL,'3613',355,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 19:41:51','2024-11-08 05:08:51'),
(437,'FDP Die Liberalen Kanton Zürich',NULL,NULL,'CHE-100.795.759',NULL,NULL,0,0,'Zürich','FDP',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',20,13,NULL,'http://www.fdp-zh.ch/die-partei',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8032',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-12 19:51:33','2025-02-13 09:16:34'),
(438,'FDP Die Liberalen Winterthur',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','punktuell',20,106,NULL,'http://www.fdp-winterthur.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8401',NULL,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 19:56:15','2017-04-25 18:44:50'),
(440,'Kantonaler Gewerbeverband Zürich KGV',NULL,NULL,'CHE-105.833.255',NULL,NULL,0,0,'Zürich','KGV Zürich','KGV KMU- und Gewerbeverband Kanton Zürich',NULL,NULL,NULL,NULL,191,2,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',59,NULL,NULL,'http://www.kgv.ch/',NULL,'kgv_zuerich','kgv_zh',NULL,'kgvzuerich','https://www.linkedin.com/company/kantonaler-gewerbeverband-z%C3%BCrich/',NULL,'Der KGV ist die Dachorganisation der kleinen und mittleren Unternehmen im Kanton Zürich. An der Drehscheibe zwischen Wirtschaft und Politik setzt er sich für gute wirtschaftliche Rahmenbedingungen für das Gewerbe im Kanton ein.','La KGV est l''organisation faîtière des petites et moyennes entreprises du canton de Zurich. À la croisée des chemins entre économie et politique, il plaide pour de bonnes conditions économiques pour les entreprises du canton.',NULL,'8032',261,NULL,NULL,NULL,'2025-07-02 13:06:47','2014-03-12 20:33:32','2025-07-02 13:06:47'),
(442,'Aktion für vernünftige Energiepolitik AVES, Sektion Winterthur',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','punktuell',30,NULL,NULL,'http://www.aves.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Ziele der AVES sind klar. Die AVES engagiert sich für eine sichere, ausreichende und volkswirtschaftlich optimale Energieversorgung der Schweiz, die gleichzeitig den Schutz von Mensch und Umwelt beachtet. Wir kämpfen für die Versorgungssicherheit in der Schweiz sowohl beim Strom wie bei den übrigen Energieträgern. Mit Nachdruck setzen wir uns dafür ein, dass unsere Gewerbebetriebe und Industrie auch weiterhin kostengünstig mit Energie versorgt werden können, da Hunderttausende von Arbeitsplätzen davon abhängig sind.\n\nExperimente lehnen wir ab. Den so genannten "Atomausstieg" betrachten wir als wohlfeile Konzession an eine einseitig informierte Öffentlichkeit. Die ökologischen, wirtschaftlichen und sozialen Folgen wurden weder von der Mehrheit des Bundesrates noch des Parlamentes genügend bedacht.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 20:54:50','2021-01-03 08:52:54'),
(443,'RWU Regionalplanung Winterthur und Umgebung',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'DachOrganisation','punktuell',14,NULL,NULL,'http://www.rwu-planung.ch/rwu/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Zweckverband Regionalplanung Winterthur und Umgebung (RWU) fördert die geordnete räumliche Entwicklung im Verbandsgebiet. Die RWU arbeitet die dafür notwendigen regionalen Pläne (Siedlungs- und Landschaftsplan, Verkehrspläne) aus und hilft mit, die Planungen der Mitgliedergemeinden unter sich zu koordineren und auf die regionalen Ziele auszurichten.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 21:01:53','2017-04-25 18:44:50'),
(444,'Berufsmaturitätsschule Zürich BMZ',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,'http://www.bms-zuerich.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 21:09:43','2017-04-25 18:44:50'),
(445,'Jubiläumsstiftung der Kantonsschule Winterthur 1963',NULL,NULL,'CHE-102.013.356',278440,'CH02079021871',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',27,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/jubilaumsstiftung_der_kantonsschule_winterthur_1963_CH-020.7.902.187-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung der Lehrkräfte der drei Kantonsschulen Büelrain, Im Lee und Rychenberg; sie unterstützt insbesondere berufliche Weiterbildung oder Forschungsarbeiten der Lehrer auf wissenschaftlichem und kulturellem Gebiet.',NULL,NULL,'8406',230,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 21:18:31','2024-07-19 05:08:57'),
(446,'Touring Club Suisse (TCS)','Touring Club Suisse','Touring Club Svizzero','CHE-105.819.195',194746,'CH66000018973',1,1,'Vernier','TCS Schweiz','Touring Club Schweiz','TCS Suisse',NULL,'TCS Svizzera',NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',26,NULL,NULL,'http://www.tcs.ch/de/der-club/mitgliedschaft/','http://ge.ch/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-660-0001897-3&ofrcLanguage=1','TCS_Schweiz','touringclub.schweiz','TCS','tcs.schweiz/','https://www.linkedin.com/company/touring-club-suisse/',NULL,'Der Touring Club Schweiz (TCS) ist ein nicht-gewinnorientierter Verein, welcher ungefähr 1,6 Millionen Mitglieder in der Schweiz hat. Er beschäftigt 1900 Mitarbeitende. Als grösster Mobilitätsclub der Schweiz bietet der TCS seinen Mitgliedern Dienstleistungen auf folgenden Gebieten an: Personen-Assistance, Fahrzeug-Assistance, Rechtsschutz, Tourismus und Freizeit.','Le Touring Club Suisse (TCS) est une association à but non lucratif qui compte environ 1,6 million de membres en Suisse. Il emploie 1900 collaborateurs. En tant que plus grand club de mobilité de Suisse, le TCS offre à ses membres des prestations dans les domaines suivants : Assistance aux personnes, assistance aux véhicules, protection juridique, tourisme et loisirs.',NULL,'1214',6643,'https://de.wikipedia.org/wiki/Touring_Club_Schweiz','Q692936',NULL,'2025-10-10 17:58:43','2014-03-12 21:54:09','2025-10-10 17:58:43'),
(447,'touring club schweiz (TCS) Sektion Zürich',NULL,NULL,'CHE-112.263.104',688813,'CH02060007145',1,1,'Volketswil','TCS ZH','TCS Sektion Zürich (TCS)',NULL,NULL,NULL,NULL,191,2,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',26,NULL,NULL,'https://www.tcs.ch/de/der-tcs/sektionen/zuerich/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000714&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Sektion Zürich umfasst über 200''000 Mitglieder und besteht aus 8 Ortsgruppen sowie dem Campingclub. Wir möchten alles dafür tun, dass die Mobilität sicher und einfach funktioniert, ob auf der Strasse, auf der Schiene, auf dem Veloweg, auf dem Trottoir oder auf dem Fussgängerstreifen. Präsent sind wir im Service Center in Volketswil, in der Kontaktstelle Winterthur sowie auf der Kurspiste in Dübendorf bei der Drive Z AG.',NULL,NULL,'8604',199,NULL,NULL,NULL,'2014-11-03 12:45:42','2014-03-12 21:56:58','2024-12-04 21:39:06'),
(448,'Touring Club Schweiz TCS Ortsgruppe Winterthur',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',26,NULL,NULL,'http://www.tcs.ch/de/der-club/meine-region/zuerich/veranstaltungen-gruppen/winterthur/rund-ums-auto.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 21:59:21','2017-04-25 18:44:50'),
(449,'Eidgenössische Kommission für Migrationsfragen','Commission fédérale pour les questions de migration','Commissione federale della migrazione',NULL,NULL,NULL,0,0,'Bern','EKM',NULL,'CFM',NULL,'CFM',NULL,191,1,'Ausserparlamentarische Kommission',NULL,NULL,'EinzelOrganisation','punktuell',24,NULL,NULL,'http://www.ekm.admin.ch/content/ekm/de/home.html',NULL,NULL,NULL,'ekmcfm','ekmcfm','https://www.linkedin.com/company/eidgen%C3%B6ssische-migrationskommission-ekm/',NULL,'Die Eidgenössische Migrationskommission EKM ist eine ausserparlamentarische Kommission. Sie setzt sich aus 30 vom Bundesrat gewählten Expertinnen und Experten aus dem Migrationsbereich zusammen. Die EKM hat den gesetzlichen Auftrag, sich mit sozialen, wirtschaftlichen, kulturellen, politischen, demografischen und rechtlichen Fragen zu befassen, die sich aus internationalen Migrationsbewegungen für die Schweiz und alle ihre Bewohnerinnen und Bewohner ergeben.','La Commission fédérale des migrations CFM est une commission extraparlementaire. Elle se compose de 30 experts du domaine de la migration nommés par le Conseil fédéral. La CFM a pour mandat légal de s''occuper des questions sociales, économiques, culturelles, politiques, démographiques et juridiques qui découlent des mouvements migratoires internationaux pour la Suisse et tous ses habitants.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-13 00:00:00','2014-03-12 22:08:36','2024-03-10 19:54:48'),
(450,'Eidgenössische Arbeitskommission EAK','Commission fédérale du travail','Commissione federale del lavoro',NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation','punktuell',23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-27 12:38:54','2014-03-12 22:16:23','2023-03-27 12:38:54'),
(451,'INSTITUT LIBERTAS',NULL,NULL,'CHE-104.049.201',277246,'CH03570161498',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,dezidierteLobby','nie',35,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/institut_libertas_CH-035.7.016.149-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt, zur Verteidigung der grundlegenden Freiheiten und zur Stärkung des staatsbürgerlichen Geistes in der Schweiz beizutragen durch Verwirklichung und Unterstützung von Studien und Veröffentlichungen, Veranstaltung von Vorträgen, Gesprächen und Seminarien sowie Ausrichtung von Stipendien und Unterstützungsbeiträgen usw.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 22:24:36','2024-04-28 10:36:59'),
(452,'Schweizerische Gesellschaft für militärhistorische Studienreisen (GMS)',NULL,NULL,'CHE-107.926.502',165970,'CH02069003923',1,1,'Wettingen','GMS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation','nie',21,NULL,NULL,'http://www.gms-reisen.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Was bietet denn die GMS? Wer wäre ohne sie schon im Führerhauptquartier in der Wolfsschanze bei Rastenburg gewesen oder mit der Erzeisenbahn nach Narvik gefahren, wer hätte schon den Kriegshafen von Sewastopol oder die leidgeprüfte Stadt Stalingrad besichtigt und wer hätte seinen Fuss schon auf den Hügel Eliane bei Dien Bien Phu oder die Festungsinsel Corregidor setzen können? Das alles ist wohl nur mit der GMS möglich.',NULL,NULL,'5430',4045,NULL,NULL,NULL,'2017-04-25 18:44:50','2014-03-12 22:35:21','2024-04-28 10:36:59'),
(453,'FDP.Die Liberalen Schweiz','PLR.Les Libéraux-Radicaux','PLR.I liberali radicali','CHE-101.858.173',NULL,NULL,0,0,'Bern','FDP Schweiz',NULL,'PLR Suisse',NULL,'PLR Svizzera',NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',20,NULL,NULL,'http://www.fdp.ch/',NULL,'FDP_Liberalen','fdp_schweiz','FDP_PLR','fdp.dieliberalen','https://www.linkedin.com/company/fdp-schweiz/',NULL,NULL,NULL,NULL,'3001',351,NULL,NULL,NULL,'2025-10-27 16:25:35','2014-03-13 16:13:13','2025-10-27 16:25:35'),
(454,'FDP Die Liberalen Tessin',NULL,'PLR I liberali radicali Ticino',NULL,NULL,NULL,0,0,'Camorino',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',20,13,NULL,'http://www.plrt.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'6528',NULL,NULL,NULL,NULL,'2025-08-21 09:27:14','2014-03-13 16:15:57','2025-08-21 09:27:14'),
(455,'IMMOBILIARE MEGISTI SA',NULL,'Immobiliare Megisti','CHE-109.422.709',660143,'CH51430258291',1,1,'Gentilino',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',19,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/immobiliare_megisti_sa_CH-514.3.025.829-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Kauf, Verkauf, Bau, Verwaltung und Bewirtschaftung von Immobilien. Es kann in jeder Filiale zu investieren, insbesondere die Beteiligung von anderen Unternehmen, insbesondere Unternehmen, die in Immobilien, Durchführung von Operationen und der Erbringung von Dienstleistungen und Beratung aller Art im kaufmännischen, Verwaltungs-, Kredit-und Versicherungsgewerbe, Handel und die Renovierung von Immobilien. Es können alle Vorgänge als nützlich erachtet werden oder im Zusammenhang mit der Erreichung ihrer unternehmerischen Zweck.',NULL,NULL,'6925',5236,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-13 16:34:49','2024-04-28 10:36:59'),
(456,'Skyline Invest SA',NULL,'Castelrosso','CHE-114.564.580',925457,'CH50130116106',1,1,'Paradiso',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',19,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/castelrosso_sa_CH-501.3.011.610-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Kauf, Verkauf, Leasing und Immobilien-Management, Beratung, Design, Erstellung von Gutachten für Immobilien. Die Gesellschaft kann Beteiligungen an anderen Unternehmen mit ähnlichem Zweck zu nehmen.',NULL,NULL,'6900',5210,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-13 16:36:54','2024-04-28 10:36:59'),
(457,'Hirzel.Neef.Schmid.Konsulenten AG',NULL,NULL,'CHE-109.387.958',657658,'CH02030252080',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',18,NULL,NULL,'http://www.konsulenten.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203025208&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/hirzel--neef--schmid--konsulenten-ag/',NULL,'Betrieb eines Büros für Kommunikations- und Wirtschaftsberatung; kann sich an anderen Unternehmungen beteiligen sowie Grundeigentum erwerben, belasten, veräussern und verwalten.','Exploitation d''un bureau de conseil en communication et en économie ; peut participer à d''autres entreprises et acquérir, grever, aliéner et gérer des biens immobiliers.',NULL,'8008',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-18 22:43:28','2025-02-13 09:16:35'),
(458,'Glencore (Schweiz) AG',NULL,NULL,'CHE-109.435.971',661643,'CH17030253028',1,1,'Baar',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',17,NULL,NULL,'http://www.glencore.com','http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1703025302&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0','glencore','glencoreplc','GlencoreVideos','GlencoreCH/?brand_redir=1079743815448235','https://www.linkedin.com/company/8518',NULL,'Die Glencore ist die weltweit grösste im Rohstoffhandel und Bergwerksbetrieb tätige Unternehmensgruppe. Ihr operativer Hauptsitz befindet sich in Baar in der Schweiz.','Glencore est le plus grand groupe mondial de négoce de matières premières et d''exploitation minière. Son siège opérationnel se trouve à Baar, en Suisse.',NULL,'6341',1701,'https://de.wikipedia.org/wiki/Glencore','Q169339',NULL,'2014-09-16 00:00:00','2014-03-18 22:46:45','2024-11-08 06:02:13'),
(459,'Inlandbanken','Banques domestiques','Banche domestiche',NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','nie',16,NULL,NULL,'http://www.inlandbanken.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Parlamentarische Gruppe Inlandbanken ist ein Dialoggefäss, das interessierten Parlamentsmitgliedern den Austausch zu aktuellen finanzplatzrelevanten Themen mit Fokus auf den inländischen Retailbankenplatz ermöglicht.','Le groupe parlementaire "Banques domestiques" est une instance de dialogue qui permet aux parlementaires intéressés d''échanger sur des sujets d''actualité liés à la place financière, en mettant l''accent sur le secteur des banques de détail en Suisse.','Simone Ryan\n+41 61 206 66 26\ns.ryan@vskb.ch\nKoordination Inlandbanken\nWallstrasse 8\n4051 Basel\nSCHWEIZ\nwww.inlandbanken.ch',NULL,NULL,NULL,NULL,'2025-01-26 18:18:51','2025-10-02 08:55:56','2014-03-18 22:59:12','2025-10-02 08:55:56'),
(460,'Raiffeisen Schweiz Genossenschaft',NULL,NULL,'CHE-105.997.193',406408,'CH32050022260',1,1,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer','punktuell',16,NULL,NULL,'https://www.raiffeisen.ch','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3205002226&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Raiffeisen hat sich in den vergangenen Jahren als führende Retail-Bankengruppe und drittgrösste Bankengruppe der Schweiz etabliert. Unsere einmalige Stärke ist die lokale Verankerung. Heute zählen 3,7 Millionen Schweizerinnen und Schweizer zu den Raiffeisen-Kunden. Davon sind über 1,8 Millionen Genossenschafter und somit Mitbesitzer ihrer Raiffeisenbank.\nRaiffeisen Schweiz ist eine Genossenschaft. Mitglied kann jede genossenschaftlich organisierte Bank werden, die sowohl die Musterstatuten der Raiffeisenbanken als auch die Statuten und Reglemente von Raiffeisen Schweiz anerkennt. Raiffeisen Schweiz trägt die Verantwortung für die Geschäftspolitik und -strategie der Raiffeisen Gruppe, fungiert als Kompetenzzentrum für die gesamte Gruppe und vertritt deren nationale und internationale Interessen.\n\nRaiffeisen Schweiz schafft Rahmenbedingungen für die Geschäftstätigkeit der örtlichen Raiffeisenbanken (beispielsweise IT, Infrastruktur, Refinanzierung) und berät und unterstützt sie in sämtlichen Belangen. Zudem ist Raiffeisen Schweiz gruppenweit für die Risikosteuerung, die Liquiditäts- und Eigenmittelhaltung sowie die Refinanzierung verantwortlich und übernimmt Tresorerie-, Handels- und Transaktionsfunktionen. Sechs Niederlassungen, die im Kundengeschäft tätig sind, werden direkt von Raiffeisen Schweiz geführt.',NULL,NULL,'9001',3203,NULL,NULL,NULL,'2025-06-25 07:21:36','2014-03-18 23:05:00','2025-06-25 07:21:36'),
(461,'Verband Schweizerischer Kantonalbanken','Union des Banques Cantonales suisses','Unione delle Banche Cantonali Svizzere','CHE-107.979.970',247913,'CH27060002261',1,1,'Basel','VSKB',NULL,'UBCS',NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',16,NULL,NULL,'https://kantonalbank.ch/','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2706000226&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,'kantonalbank',NULL,'https://www.linkedin.com/company/verband-schweizerischer-kantonalbanken/',NULL,'1907 haben sich die Kantonalbanken im Verband Schweizerischer Kantonalbanken (VSKB) zusammengeschlossen. Der VSKB vertritt die gemeinsamen Interessen seiner Mitglieder, fördert deren Zusammenarbeit und trägt dazu bei, die Stellung der Kantonalbanken in der Schweiz zu stärken.','En 1907, les banques cantonales se sont regroupées pour former l''Union des Banques Cantonales Suisses (UBCS). L''UBCS défend les intérêts communs de ses membres, encourage leur coopération et contribue à renforcer la position des Banques Cantonales en Suisse.',NULL,'4051',2701,NULL,NULL,NULL,'2022-11-08 00:00:00','2014-03-18 23:10:40','2024-11-17 13:23:32'),
(462,'Vereinigung Schweizerischer Futtermittelfabrikanten (VSF)',NULL,NULL,'CHE-108.724.007',201018,'CH03560027704',1,1,'Zollikofen','VSF',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',77,NULL,NULL,'http://www.vsf-mills.ch/VSF/Willkommen-bei-VSF.aspx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die in der VSF zusammengeschlossenen Futtermittelhersteller sind wichtige und kompetente Partner der Landwirtschaft. Die VSF - Firmen beziehen von den Getreideproduzenten die Rohstoffe und den Tierhaltern bieten sie qualitativ hochstehende Produkte sowie Dienstleistungen aller Art an. Die wissenschaftlichen Erkenntnisse aus der Tierernährung, die effiziente Nutzung der Nährstoffe sowie das Tierwohl garantieren sichere und gesunde tierische Erzeugnisse mit Herkunft Schweiz.\n\nDie VSF vertritt als unabhängiger Verband die Interessen der Futtermittelbranche gegenüber staatlichen Stellen sowie gegenüber der Öffentlichkeit. Die VSF setzt sich ein für eine unabhängige und produzierende Schweizer Landwirtschaft, für freie und offene Märkte sowie für eine nachhaltige und wettbewerbsfähige tierische Erzeugung.\n\nDie VSF wurde 1933 gegründet. Angeschlossen sind 56 private Unternehmen. Die VSF finanziert sich aus den Mitgliederbeiträgen. Der Verband bietet den Mitgliedern eine Vielzahl an Leistungen in den Bereichen Interessensvertretung, Bildung, Arbeitssicherheit, Wirtschaft und Soziales, vertritt die Interessen der Mitglieder in Kommissionen und Arbeitsgruppen und informiert sie über aktuelle Geschehnisse.',NULL,NULL,'3052',361,NULL,NULL,NULL,'2025-06-20 15:50:30','2014-03-24 09:58:43','2025-06-20 15:50:30'),
(463,'Krebsliga Schweiz','Ligue suisse contre le cancer','Lega Svizzera contro il cancro','CHE-107.818.640',318366,'CH03560179841',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer','punktuell',6,NULL,NULL,'http://www.krebsliga.ch','http://www.moneyhouse.ch/u/krebsliga_schweiz_CH-035.6.017.984-1.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Krebsliga ist eine nationale gemeinnützige Organisation, die gegen Krebs kämpft und Betroffene und Angehörige unterstützt. Sie ist als Verband organisiert und konfessionell und politisch neutral. Die Krebsliga besteht aus 19 kantonalen und regionalen Ligen sowie aus der Dachorganisation, der Krebsliga Schweiz. \n\nDie Dachorganisation widmet sich zusätzlich der Förderung der Krebsforschung und der Entwicklung psychosozialer Programme für Fachpersonen. Die Krebsliga Schweiz wurde 1910 gegründet und hat ihren Sitz in Bern. Sie besteht aus einem 11-köpfigen Vorstand, 8 Geschäftsleitungsmitgliedern und rund 100 meist teilzeitangestellten Mitarbeitenden. \n\nIhr angegliedert sind die Wissenschaftliche Kommission und die Schweizerische Studiengruppe für Komplementäre und Alternative Methoden bei Krebs (SKAK). Die Krebsliga Schweiz trägt das ZEWO - Gütesiegel für gemeinnützige Institutionen.',NULL,NULL,'3001',351,NULL,NULL,NULL,'2017-04-27 13:39:54','2014-03-24 09:59:46','2024-04-28 10:36:59'),
(464,'Scholten Partner GmbH',NULL,NULL,'CHE-116.048.987',995302,'CH02040434776',1,1,'Stäfa',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation','nie',18,NULL,NULL,'http://scholtenpartner.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0204043477&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Kommiuunikation für Wirtschaft und Politik',NULL,NULL,'8712',158,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-24 14:06:16','2024-04-28 10:36:59'),
(465,'Gesundheitspolitik der Bundesversammlung','Politique de la santé de l''Assemblée fédérale',NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','nie',4,NULL,NULL,'http://www.pg-gesundheitspolitik.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Parlamentarische Gruppe Gesundheitspolitik setzt sich mit aktuellen gesundheitspolitischen Themen auseinander. Sie ist eine Plattform für die Diskussion der Themen mit Expertinnen und Experten aus Praxis und Wissenschaft. Darüber hinaus kann die Gruppe eigene Initiativen und Vorstösse anstossen, um gesundheitspolitische Themen aktiv voranzutreiben. Ein besonderer Fokus liegt auf den finanziellen und strukturellen Aspekten des öffentlichen Gesundheitswesens. Ebenso setzt sich die Gruppe mit Innovationen und Entwicklungen auseinander, die gesellschaftspolitische Relevanz im Gesundheitswesen haben. Informationen an Parlamentarierinnen und Parlamentarier über gesundheitsrelevante Themen.',NULL,'Simon Gassmann\nSekretär/in\n+41 31 313 31 31\npg-gesundheitspolitik@sso.ch\nSchweizerische Zahnärzte-Gesellschaft\nPostfach\nThunstrasse 7\n3001 BERN\nSCHWEIZ\nwww.pg-gesundheitspolitik.ch\nHeike Scholten\nhs@sensoradvice.ch\nLimmatstrasse 291a\n8005 Zürich\nSCHWEIZ',NULL,NULL,NULL,NULL,'2025-04-28 18:54:53','2025-07-14 00:00:00','2014-03-24 14:18:15','2025-07-14 10:44:47'),
(466,'Sensor Advice GmbH',NULL,NULL,'CHE-386.347.887',1139382,'CH40040367772',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation','nie',18,NULL,NULL,'http://www.gentinettascholten.ch/heike-scholten/','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4004036777&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Erbringen von Dienstleistungen, insbesondere das Erstellen von Analysen, Strategien und Konzepten für Unternehmen, Verbände und Institutionen an den Schnittstellen zwischen Wirtschaft, Politik und Gesellschaft; kann Zweigniederlassungen errichten, sich an anderen Unternehmen beteiligen, gleichartige oder verwandte Unternehmen erwerben oder sich mit solchen zusammenschliessen sowie Grundstücke erwerben, verwalten und veräussern.',NULL,NULL,'8006',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-24 14:28:05','2024-04-28 10:36:59'),
(468,'Wirtschaftskammer Baselland',NULL,NULL,'CHE-100.494.447',394819,'CH28069145238',1,1,'Pratteln',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',59,NULL,NULL,'http://www.kmu.org/','http://bl.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2806914523&amt=280&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Wirtschaftskammer Baselland ist der Dachverband der Klein- und Mittelunternehmen (KMU) aus Gewerbe, Handel, Dienstleistung und Industrie sowie der Selbstständigerwerbenden im Kanton Baselland. \n\nDie Wirtschaftskammer als Non-Profit-Organisation wirkt als strategischer und leistungsfähiger Dach-Verband der Selbstständigerwerbenden und der Kleinen und Mittleren Unternehmen (KMU) im Kanton Baselland und in der Region Nordwestschweiz. Wir verstehen uns als ideellen, wirtschaftspolitischen Zusammenschluss aller Selbstständigerwerbenden und Unternehmen aus Gewerbe, Handel, Dienstleistung und Industrie. Wir verfolgen als solidarisches Ziel die Erhaltung und Schaffung günstiger Voraussetzungen für das wirtschaftliche Gedeihen unserer Mitgliedfirmen unter Wahrnehmung der sozialen und gesellschaftlichen Verantwortung in unserem Umfeld.',NULL,NULL,'4133',2831,NULL,NULL,NULL,'2023-08-28 14:36:03','2014-03-24 18:41:09','2024-04-28 10:36:59'),
(469,'BG Mitte, Bürgschaftsgenossenschaft für KMU',NULL,NULL,'CHE-107.181.104',237525,'CH05350020562',1,1,'Burgdorf','KMU',NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'MitgliedsOrganisation,LeistungsErbringer','nie',59,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/bg_mitte_burgschaftsgenossenschaft_fur_kmu_CH-053.5.002.056-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung von kleineren und mittleren Unternehmungen (KMU) durch Verbürgung von Darlehen und Krediten zugunsten der Genossenschafter sowie weiteren KMU, die nicht Genossenschafter sind, zur Eröffnung, Übernahme, Erhaltung und Erweiterung von Betrieben in den Kantonen Bern, Jura, Solothurn, Basel-Stadt, Basel-Land, Luzern, Ob- und Nidwalden. Im Kanton Aargau ist die Genossenschaft befugt, nebst der dort lokal zuständigen Organisation, den Markt parallel zu bearbeiten. Die Genossenschaft ist eine nach betriebswirtschaftlichen Grundsätzen geführte juristische Person. Die Genossenschaft handelt uneigennützig. Sie verfolgt im Sinne ihres Zweckes öffentliche Aufgaben und strebt keinen Erwerbszweck an. Ein allfälliger weiterer Nebenzweck ist aus den Statuten ersichtlich.',NULL,NULL,'3400',404,NULL,NULL,NULL,'2023-09-19 11:56:26','2014-03-24 18:52:22','2024-04-28 10:36:59'),
(470,'Stiftung Tierpark Weihermätteli',NULL,NULL,'CHE-240.331.450',1111403,'CH28070161028',1,1,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',NULL,NULL,NULL,'http://www.tierpark-weihermaetteli.ch/','http://www.moneyhouse.ch/u/stiftung_tierpark_weihermatteli_CH-280.7.016.102-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Finanzierung und den Betrieb des Tierparks Weihermätteli in Liestal, um diesen langfristig den Patientinnen und Patienten der Psychiatrie Baselland sowie der regionalen Bevölkerung als Naherholungsgebiet zugänglich zu machen. Die Stiftung hat gemeinnützigen Charakter und verfolgt keinen Erwerbszweck.',NULL,NULL,'4410',2829,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-24 18:59:47','2024-04-28 10:36:59'),
(472,'Arbeitgeber Baselland',NULL,NULL,'CHE-110.345.441',730427,'CH28060071227',1,1,'Pratteln',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',59,NULL,NULL,NULL,'http://bl.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2806007122&amt=280&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Primär Koordination aller arbeitgeberpolitischen Belange der Kleinen und Mittleren Unternehmen (KMU), insbesondere im Kanton Basel-Landschaft. Der Verein vertritt in diesem Bereich konsequent seine Mitglieder, indem er u.a. laufend arbeitgeberspezifische Interessen lokalisiert, dokumentiert und mit entsprechenden Massnahmen durchsetzt. Er koordiniert seine Tätigkeiten mit anderen repräsentativen Verbänden, insbesondere mit der Wirtschaftskammer Baselland.\nMittel: Erlöse aus Aktionen und Veranstaltungen;',NULL,NULL,'4133',2829,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-24 19:22:27','2024-04-28 10:36:59'),
(473,'Maler- und Gipserunternehmer-Verband Baselland',NULL,NULL,'CHE-100.033.589',NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',52,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Als moderner und marktorientierter Verband fördern wir Fachwissen, Qualität und Zusammenarbeit auf allen Ebenen und setzen uns gemeinsam mit Partnerverbänden für regionale und nationale Anliegen ein.\nUnser Ziel ist es, optimale Voraussetzungen für ein starkes einheimisches Maler- und Gipsergewerbe zu schaffen. Wir engagieren uns deshalb für kundengerechtes Verhalten der Mitglieder, eine fundierte Aus- und Weiterbildung der Berufsleute sowie für qualitätsbewusstes und umweltgerechtes Handeln.',NULL,NULL,'4410',2831,NULL,NULL,NULL,'2023-08-28 14:36:03','2014-03-24 19:28:51','2023-08-28 14:36:03'),
(474,'Schweizerischer Maler- und Gipserunternehmer-Verband (SMGV)','Association suisse des entrepreneurs plâtriers-peintres ASEPP','Associazione svizzera imprese pittori e gessatori ASIPG','CHE-105.955.763',467766,'CH02069004109',1,1,'Wallisellen','SMGV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',52,NULL,NULL,'http://www.smgv.ch/','http://www.moneyhouse.ch/u/schweizerischer_maler_und_gipserunternehmer_verband_%28smgv%29_CH-020.6.900.410-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Maler- und Gipserunternehmer-Verband (SMGV) ist der Branchen- und Arbeitgeberverband des schweizerischen Maler- und Gipsergewerbes. Er wurde am 31. Mai 1908 als Schweizerischer Maler- und Gipsermeister-Verband gegründet und vertritt derzeit die Interessen von rund 2000 Maler- und Gipserbetrieben der deutschen, französischen und italienischen Schweiz.',NULL,NULL,'8304',69,NULL,NULL,NULL,'2023-08-28 14:36:03','2014-03-24 19:37:50','2024-04-28 10:36:59'),
(475,'Schreinermeister-Verband Baselland',NULL,NULL,'CHE-100.043.470',NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation','nie',52,NULL,NULL,'http://www.schreinerbl.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4410',2831,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-24 19:42:49','2023-03-19 23:01:41'),
(476,'Schweizer Musikrat','Conseil Suisse de la Musique',NULL,'CHE-107.322.646',NULL,NULL,0,0,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',10,NULL,NULL,'http://www.musikrat.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizer Musikrat setzt sich für die Verbesserung von kultur- und bildungspolitischen Rahmenbedingungen für das Schaffen, Vermitteln, Verbreiten und Bewahren von Musik in ihrer Vielfalt ein. Er ist\n- die politische Interessenvertretung für Musik auf nationaler Ebene,\n- das regionenübergreifende Informations- und Kontaktzentrum des Musikbereichs,\n- der Partner für den internationalen musikpolitischen Austausch.\n\nAls Dachverband vereinigt der Schweizer Musikrat alle im Musikbereich tätigen Organisationen. Er repräsentiert das vielfältige Musikleben in der Schweiz mit seinen rund 2''000 Blasmusikvereinen, 1''850 Chören, 200 Berufs- und Laienorchestern, tausenden von Einzelmusikern, 8 Musiktheatern, 380 Musikschulen mit 230''000 Schülerinnen und Schülern und zahlreichen Ausbildungsstätten für Berufe im Bereiche der Musik.',NULL,NULL,'5001',4001,NULL,NULL,NULL,'2025-08-17 12:52:46','2014-03-25 07:56:46','2025-08-17 12:52:46'),
(477,'Hauseigentümerverband Schweiz','Association Suisse des Propriétaires Fonciers','Associazione Svizzera dei Proprietari Fondiari','CHE-107.846.317',462963,'CH02069003947',1,1,'Zürich','HEV Schweiz',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',19,NULL,NULL,'http://www.hev-schweiz.ch/home/aktuell/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206900394&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,'hevschweiz','hev-schweiz','hevschweiz',NULL,NULL,'Förderung, Wahrung und Vertretung der Interessen der Haus-, Grund- und Stockwerkeigentümer; tritt für die Erhaltung und den Schutz des Privateigentums ein; fördert und unterstützt die breite Streuung des Grundeigentums; strebt gemeinsam mit Hauseigentümerorganisationen in der französisch-, italienischsprachigen und in der rätoromanischen Schweiz eine gesamtschweizerische Eigentumspolitik an.','Elle encourage, défend et représente les intérêts des propriétaires de maisons, de terrains et d''étages ; s''engage pour le maintien et la protection de la propriété privée ; encourage et soutient la large diffusion de la propriété foncière ; s''efforce, en collaboration avec les organisations de propriétaires de Suisse romande, italienne et rhéto-romane, de mettre en place une politique de la propriété à l''échelle nationale.',NULL,'8008',261,NULL,NULL,NULL,'2025-09-15 21:08:25','2014-03-25 09:49:11','2025-09-15 21:08:25'),
(478,'Capriccio Barockorchester',NULL,NULL,NULL,NULL,NULL,0,0,'Rheinfelden',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation','nie',10,NULL,NULL,'http://www.capriccio-barock.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Capriccio setzt sich aus 22 professionellen Musikerinnen und Musikern zusammen, die mit grosser Hingabe Musik des 17. und 18. Jahrhunderts "erfahrbar" machen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 09:57:07','2014-09-16 00:00:00'),
(479,'Leder Partner in Liquidation',NULL,NULL,'CHE-107.706.024',579461,'CH40020175821',1,1,'Baden',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'KG','0103',2,'EinzelOrganisation','nie',18,NULL,NULL,'http://www.lederpartner.ch/7_.html','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4002017582&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Wir sind stolz auf unsere Kunden und ihre Art zu kommunizieren. Sie sind aufgeschlossen und haben den Mut, in der Kommunikation mit uns zusammen neue Wege zu gehen.\nUnsere partnerschaftliche Zusammenarbeit mit führenden Unternehmen und Organisationen aus Wirtschaft, Verwaltung, Politik und dem Non-Profit-Bereich bewirkt erfolgreiche Kommunikation nach aussen und innen. Dies gilt auch für schwierige Situationen. Fordernde Aufgaben faszinieren uns eben.\nDie besten Kommunikations-Kompositionen entstehen dort, wo wir uns mit der Haltung und dem Auftritt des Kunden voll identifizieren können. Eigentlich kennen wir und unsere Kunden auch nichts anderes:',NULL,NULL,'5400',4021,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 20:16:23','2024-04-28 10:36:59'),
(480,'ABB Schweiz Holding AG',NULL,NULL,'CHE-102.268.956',467919,'CH40030185505',1,1,'Baden','ABB',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',87,NULL,NULL,'http://www.abb.ch/cawp/chabb124/3d75d0e00526bf59c1256d6400368095.aspx','http://www.moneyhouse.ch/u/abb_schweiz_holding_ag_CH-400.3.018.550-5.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Das Unternehmen konzentriert sich schwergewichtig auf die beiden Kernbereiche Energie- und Automationstechnik und liefert Systeme und Gesamtlösungen für Versorgungs- und Industrieunternehmen. Zudem ist ABB Weltmarktführer für die Aufladung von grossen Diesel- und Gasmotoren mittels Turboladern.\n\nDa sich der Trend hin zur grünen Technologie verstärkt, ist nun das Zeitalter der Elektrofahrzeuge angebrochen. Als weltweit führendes Unternehmen in der Energie- und Automatisierungstechnik spielt ABB eine entscheidende Rolle in der Entwicklung einer nachhaltigen Mobilität und bietet innovative sowie effiziente Technologien für die Ladeinfrastruktur von Elektrofahrzeugen an. Das Angebot von ABB im Bereich Ladeinfrastruktur für Elektrofahrzeuge umfasst AC-Ladestationen und DC-Schnellladestationen, leistungsstarke Netzmanagement-Software, flexible Wartungsleistungen und Komponenten. Die Technologie von ABB stellt ein intelligentes Lademanagement und eine bessere Power Quality im Netz sicher und ermöglicht somit eine nachhaltige Mobilität.','L''entreprise se concentre principalement sur les deux domaines clés que sont la technique énergétique et la technique d''automatisation et fournit des systèmes et des solutions globales aux entreprises d''approvisionnement et aux entreprises industrielles. En outre, ABB est le leader mondial de la suralimentation des gros moteurs diesel et à gaz au moyen de turbocompresseurs.\n\nComme la tendance vers les technologies vertes se renforce, l''ère des véhicules électriques a maintenant commencé. En tant que leader mondial dans le domaine de l''énergie et de l''automatisation, ABB joue un rôle décisif dans le développement d''une mobilité durable et propose des technologies innovantes et efficaces pour l''infrastructure de recharge des véhicules électriques. L''offre d''ABB en matière d''infrastructure de recharge pour véhicules électriques comprend des stations de recharge AC et des stations de recharge rapide DC, des logiciels de gestion de réseau performants, des services de maintenance flexibles et des composants. La technologie d''ABB garantit une gestion intelligente de la charge et une meilleure qualité de puissance sur le réseau, permettant ainsi une mobilité durable.',NULL,'5400',4021,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 20:20:09','2024-10-07 21:37:50'),
(481,'Schweizerischer Pensionskassenverband (ASIP)',NULL,NULL,'CHE-262.195.020',1380742,'CH02060025275',1,1,'Zürich','ASIP',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',42,NULL,NULL,'http://www.asip.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der schweizerische Pensionskassenverband ASIP setzt sich für eine sichere und verständliche 2. Säule ein.\n\nOberstes Ziel des Schweizerischen Pensionskassenverbandes ASIP ist die praxisorientierte Gestaltung und Führung der beruflichen Vorsorge und deren Sicherheit im Interesse der Versicherten.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-03-25 20:39:52','2025-02-13 09:16:34'),
(482,'BVK Personalvorsorge des Kantons Zürich',NULL,NULL,'CHE-198.602.677',1152733,'CH02070019012',1,1,'Zürich','BVK',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','punktuell',42,NULL,NULL,'http://www.bvk.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001901&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die BVK ist die Vorsorgeeinrichtung für die Angestellten des Kantons Zürich. Viele politische Gemeinden, Schul- und Kirchgemeinden sowie verschiedene öffentlich-rechtliche Körperschaften und dem Kanton nahestehende Institutionen haben sich ebenfalls der BVK angeschlossen.\n\nMit 110''000 Aktivversicherten und Rentenbeziehenden ist die BVK die grösste Pensionskasse der Schweiz. Rund 79''000 Arbeitnehmende sind durch ihre Arbeitgebenden bei der BVK versichert. An 31''000 Personen werden Alters-, Invaliden- oder Hinterbliebenenrenten ausgerichtet.',NULL,NULL,'8006',261,NULL,NULL,NULL,'2022-09-23 00:00:00','2014-03-25 20:53:55','2024-04-28 10:36:59'),
(483,'Pensionskasse der Pro Infirmis',NULL,NULL,'CHE-109.741.215',367161,'CH02070003941',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer','punktuell',42,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000394&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die berufliche Vorsorge im Rahmen des BVG und seiner Ausführungsbestimmungen für die Arbeitnehmer der Pro Infirmis und ihrer Kollektivmitglieder sowie für deren Angehörigen und Hinterlassenen gegen die wirtschaftlichen Folgen von Alter, Tod und Invalidität. Die Stiftung kann über die gesetzlichen Mindestleistungen hinaus weitergehende Vorsorge betreiben, einschliesslich Unterstützungsleistungen in Notlagen, wie bei Krankheiten, Unfall, Invalidität oder Arbeitslosigkeit.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 20:57:07','2024-04-28 10:36:59'),
(484,'PROVITA Gesundheitsversicherung AG',NULL,NULL,'CHE-110.110.151',711453,'CH02030268429',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'MitgliedsOrganisation,LeistungsErbringer','nie',2,NULL,NULL,'http://www.swica.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000291&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','SWICA_SWICA',NULL,NULL,NULL,NULL,NULL,'Der Verein fördert das Gesundheitswesen und bietet Versicherungen gegen die wirtschaftlichen Folgen von Krankheit, Unfall und Mutterschaft an. Er kann sich an Unternehmensgruppen und Firmen beteiligen, Verbänden anschliessen sowie alle Geschäfte eingehen und Verträge abschliessen, die geeignet sind, den Zweck zu fördern oder die direkt oder indirekt damit in Zusammenhang stehen.\n\nPROVITA und SWICA pflegen seit mehreren Jahren eine enge Zusammenarbeit, von der Privat- und Unternehmenskunden gleichermassen profitieren. Durch die Integration der PROVITA in die SWICA Gesundheitsorganisation können die Synergien noch besser genutzt werden. PROVITA-Kunden finden neu sämtliche Informationen auf der SWICA-Website.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2019-01-10 17:26:56','2014-03-25 21:03:26','2024-04-28 10:36:59'),
(485,'SWICA Gesundheitsorganisation',NULL,NULL,'CHE-106.095.790',375599,'CH02060002689',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',2,NULL,NULL,'http://www.swica.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000268&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','SWICA_SWICA',NULL,NULL,NULL,NULL,NULL,'Der Verein bezweckt die Versicherung seiner Mitglieder gegen die wirtschaftlichen Folgen von Krankheit, Unfall, Mutterschaft, Invalidität und Tod gemäss den allgemeinen Versicherungsbedingungen, die Wahrung der gesundheitspolitischen Interessen seiner Mitglieder mit dem Ziel, eine langfristig leistungsfähige und finanziell tragbare Gesundheitsversorgung zu sichern, die Förderung und Unterstützung von Bestrebungen zur Verhütung von Krankheiten und Unfällen sowie die Entwicklung von Strategien und das Ergreifen von Massnahmen, um aktiv die Kostenentwicklung im Gesundheitswesen zu beeinflussen. Der Verein nimmt diesen Zweck insbesondere durch das Halten der Aktien der SWICA Krankenversicherung und von den Aktien anderer Krankenversicherungen im Sinne von Art. 620 ff. OR in Verbindung mit Art. 12 Bundesgesetz über die Krankenversicherung wahr.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2025-10-28 10:58:03','2014-03-25 21:07:30','2025-10-28 10:58:03'),
(486,'SCRC Holding AG in Liquidation',NULL,NULL,'CHE-111.707.535',759386,'CH02030277849',1,1,'Hünenberg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'DachOrganisation,LeistungsErbringer','nie',2,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203027784&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Beteiligungsgesellschaft der Provita\nDie Gesellschaft bezweckt den Erwerb, die dauernde Verwaltung und die Veräusserung von Beteiligungen an Unternehmen aller Art, im Besonderen auf dem Gebiete des Gesundheitswesens. Die Gesellschaft kann alle Geschäfte eingehen, die geeignet sind, den Zweck zu fördern oder die direkt oder indirekt damit in Zusammenhang stehen. Die Gesellschaft kann Grundstücke erwerben, halten, belasten und veräussern.',NULL,NULL,'6331',1703,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 21:11:41','2024-04-28 10:36:59'),
(487,'Stiftung zur Förderung der Eigenverantwortung in der beruflichen Vorsorge',NULL,NULL,'CHE-109.809.830',525886,'CH02070007630',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',42,NULL,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000763&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung der Anstrengungen im Bereich der Eigenverantwortung/Selbstregulierung in der beruflichen Vorsorge, insbesondere durch das Unterstützen der ASIP-Charta oder gleichwertiger Verhaltenskodizes in der beruflichen Vorsorge.\n\nVormals: "Stiftung Verhaltenskodex in der beruflichen Vorsorge"',NULL,NULL,'6003',1061,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 21:16:43','2024-04-28 10:36:59'),
(488,'Sulzer Vorsorgeeinrichtung',NULL,NULL,'CHE-109.383.009',396217,'CH02079046440',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,'http://www.sve.ch/de/home/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207904644&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Stiftung bezweckt die berufliche Vorsorge im Rahmen des BVG und seiner Ausführungsbestimmungen für die Arbeitnehmer der angeschlossenen Firmen sowie für deren Angehörige und Hinterlassenen gegen die wirtschaftlichen Folgen von Alter, Invalidität und Tod. Der Anschluss erfolgt aufgrund einer schriftlichen Anschlussvereinbarung, die der Aufsichtsbehörde zur Kenntnis zu bringen ist. Die Stiftung kann über die gesetzlichen Mindestleistungen hinaus weitergehende Vorsorge betreiben. Der Stiftungsrat erlässt Reglemente über die Leistungen, die Organisation, die Verwaltung und Finanzierung sowie über die Kontrolle der Stiftung. Aus den Reglementen und Anschlussvereinbarungen gehen das Verhältnis zu den angeschlossenen Arbeitgebern, den Versicherten und den übrigen Anspruchsberechtigten hervor. Die Reglemente können vom Stiftungsrat unter Wahrung der erworbenen Rechtsansprüche der Destinatäre geändert werden. Die Reglemente und ihre Änderungen sind der Aufsichtsbehörde einzureichen. Zur Erreichung ihres Zweckes kann die Stiftung Versicherungsverträge abschliessen oder in bestehende Verträge eintreten, wobei sie selbst Versicherungsnehmerin und Begünstigte sein muss.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-25 21:53:18','2024-04-28 10:36:59'),
(489,'Sulzer-Stiftung',NULL,NULL,'CHE-473.072.210',1042865,'CH02070017951',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',12,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001795&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die Förderung der allgemeinen Wohlfahrt von Mitarbeitenden, deren Angehörigen und Rentnern, die zum Sulzer-Konzern bzw. zu seinen ehemals wirtschaftlich oder finanziell eng verbundenen Unternehmen gehören. Dies erfolgt durch die Unterstützung und/oder die Durchführung sozialer Projekte und Aktivitäten, wozu u.a. karitative, humanitäre, gesundheitsfördernde, erzieherische und kulturelle Projekte und Aktivitäten gehören. In diesem Rahmen unterstützt die Stiftung auch Personen mit Defiziten im Rahmen ihrer Berufsausbildung und leistet Beiträge an Institutionen im Hinblick auf die Schaffung sowie den Erhalt von Arbeitsplätzen von Menschen mit Behinderung sowie zur Vermeidung drohender Arbeitslosigkeit.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 08:23:22','2024-04-28 10:36:59'),
(490,'VPS Verlag Personalvorsorge und Sozialversicherung AG',NULL,NULL,'CHE-106.182.093',204129,'CH10030169951',1,1,'Kriens','VPS',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',42,NULL,NULL,'http://www.schweizerpersonalvorsorge.ch/zeitschrift/der-vps-verlag/','lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003016995&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die VPS Verlag für Personalvorsorge und Sozialversicherung AG ist Herausgeberin der monatlich erscheinenden Fachzeitschrift "Schweizer Personalvorsorge" und des wöchentlichen Newsletters "Vorsorge aktuell". Der Verlag führt themenbezogene Tagungen durch und engagiert sich in der Ausbildung von Stiftungsräten und Personen, die mit der beruflichen Vorsorge und den Sozialversicherungen verbunden sind. Ausserdem organisiert er jedes Jahr eine Fachmesse 2. Säule, abwechselnd in Genf und Zürich. Aktionäre des Verlags sind ausschliesslich natürliche Personen, die in der Geschäftsleitung oder als redaktionelle Mitarbeiterinnen und Mitarbeiter tätig sind. So steht dem Verlag ein Netzwerk von profilierten Fachleuten der beruflichen Vorsorge und der Sozialversicherungen als kompetente Autoren, Referentinnen und Dozenten für seine vielfältigen Aktivitäten zur Verfügung.',NULL,NULL,'6010',1061,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 08:34:55','2024-04-28 10:36:59'),
(491,'Wohlfahrtsfonds der Angestellten und Arbeiter der Firma Caliqua AG',NULL,NULL,'CHE-109.717.369',266109,'CH27070012804',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'Wohlfahrtsfonds der Angestellten und Arbeiter der Firma Caliqua AG',NULL,NULL,NULL,NULL,NULL,NULL,'Fürsorge für die Angestellten und Arbeiter der Caliqua AG bei Krankheit, Invalidität, Alter, Tod und gegen die wirtschaftlichen Folgen der Arbeitslosigkeit.',NULL,NULL,'4053',2701,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 08:38:20','2024-04-28 10:36:59'),
(492,'Wohlfahrtsfonds Sulzer',NULL,NULL,'CHE-109.724.731',278045,'CH02079015209',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207901520&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der Zweck der Stiftung besteht in der Vorsorge zugunsten der Arbeitnehmer der Firma, der ehemals und der aktuell wirtschaftlich oder finanziell eng verbundenen Firmen, für deren Angehörige und deren Hinterlassenen sowie der Rentner gegen die wirtschaftlichen Folgen von Alter, Invalidität und Tod. Der Zweck kann insbesondere erfüllt werden durch die Erbringung von freiwilligen Zusatzleistungen zu den reglementarischen Vorsorgeleistungen bei Alter, Invalidität und Tod; die Erbringung von freiwilligen Einkaufsleistungen bei der reglementarischen Vorsorge der Arbeitnehmer. Weiter bezweckt die Stiftung die Unterstützung der Arbeitnehmer und deren Hinterbliebenen in Notlagen wie bei Krankheit, Unfall, Invalidität oder Arbeitslosigkeit. Die Stiftung kann zur Finanzierung von Beiträgen und Versicherungsprämien auch Leistungen an andere steuerbefreite Personalvorsorgeeinrichtungen erbringen, die zugunsten der Destinatäre bestehen.',NULL,NULL,'8400',230,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 08:41:44','2024-04-28 10:36:59'),
(493,'AM Suisse',NULL,NULL,'CHE-105.943.346',166144,'CH02069004117',1,1,'Zürich',NULL,'Schweizerische Metall-Union; Metallunion; Metall Union',NULL,'Union Suisse du Métal USM',NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,52,NULL,'https://www.amsuisse.ch/de/home-am-suisse/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Zweck der SMU ist:\ndie Unterstützung und Förderung der Mitglieder in ihren unternehmerischen und fachlichen Belangen\ndie Sicherstellung der praxis- und bedürfnisbezogenen, sich an den Erfordernissen von Gegenwart und Zukunft orientierenden Aus- und Weiterbildung in den von der SMU betreuten Branchen und Berufen\ndie Vertretung der Mitgliederinteressen gegenüber politischen Organen, Behörden, Sozialpartnern und anderen Organisationen.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 21:07:32','2024-04-28 10:36:59'),
(494,'Metall NWCH',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',52,NULL,NULL,'http://www.metallnw.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Oberste Zielsetzung bei allen unseren Aktivitäten sind die Wahrung und die Förderung der fachlichen und wirtschaftlichen Interessen unserer Mitglieder und unseres Berufsstandes in unserer Wirtschaftsregion.',NULL,NULL,'4410',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 21:13:49','2019-03-11 10:44:17'),
(495,'EIT.swiss',NULL,NULL,'CHE-107.820.140',200741,'CH02069005790',1,1,'Zürich','EIT','VSEI - Verband Schweizerischer Elektro-Installationsfirmen',NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer','punktuell',52,NULL,NULL,'http://www.vsei.ch','http://www.moneyhouse.ch/u/verband_schweizerischer_elektro_installationsfirmen_%28vsei%29_CH-020.6.900.579-0.htm',NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/eit-swiss?originalSubdomain=ch',NULL,'Der Verband setzt sich für gute Rahmenbedingungen für die Elektrizitätsunternehmen und eine sichere Stromversorgung ein. Der VSE informiert die Öffentlichkeit über Themen der Elektrizitätsbranche und bietet seinen Mitgliedern zahlreiche Dienstleistungen an. Als nationaler Verband ist der VSE in allen Sprachregionen der Schweiz tätig. Neben seinem Hauptsitz in Aarau ist der VSE auch in der Romandie durch seine Niederlassung in Lausanne und durch enge Zusammenarbeit mit ESI im Tessin vertreten.','L''association s''engage en faveur de bonnes conditions-cadre pour les entreprises électriques et d''un approvisionnement en électricité sûr. L''AES informe le public sur les thèmes de la branche électrique et propose de nombreuses prestations à ses membres. En tant qu''association nationale, l''AES est active dans toutes les régions linguistiques de Suisse. Outre son siège principal à Aarau, l''AES est également représentée en Suisse romande par sa succursale de Lausanne et au Tessin par une étroite collaboration avec ESI.',NULL,'8005',261,NULL,NULL,NULL,'2025-03-07 14:56:37','2014-03-26 21:24:24','2025-03-07 14:56:37'),
(496,'Verband Basellandschaftlicher Elektro-Installationsfirmen VBLEI',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',52,NULL,NULL,'http://www.vblei.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4410',NULL,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-26 21:25:44','2023-03-19 23:01:41'),
(497,'Genossenschaft Gebäudehülle Schweiz','Enveloppe des Edifices Suisse','Invulcor Edilizio Svizzera','CHE-107.894.888',356001,'CH32050167959',1,1,'Uzwil',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer','punktuell',51,NULL,NULL,'http://www.gh-schweiz.ch','http://www.moneyhouse.ch/u/genossenschaft_gebaudehulle_schweiz_CH-320.5.016.795-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Wahrung und Förderung der Interessen der Mitglieder sowie der Gebäudehüllenbranche in technischen und politischen Belangen. Die Mitglieder profitieren dabei hauptsächlich von Aktivitäten und Dienstleistungen, die der Verband im Zusammenhang mit der Förderung des nachhaltigen Bauens im Sinne energieeffizienter Gebäudehüllen erbringt. Der Verband setzt sich im Interesse seiner Mitglieder ein für die Weiterentwicklung von Materialien bezüglich Funktionalität und Design von Dächern und Fassaden sowie für die Weiterentwicklung der Anwendungstechnik. Die Mitglieder profitieren zudem von Bildungsdienstleistungen, die im Zusammenhang der Weiterentwicklung des Berufsfeldes der Gebäudehülle stehen.',NULL,NULL,'9240',3408,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 21:38:27','2024-04-28 10:36:59'),
(498,'Verband Dach & Wand Baselland (Vdwbl)',NULL,NULL,'CHE-103.800.983',NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',52,NULL,NULL,'http://www.vdwbl.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verband Dach und Wand Baselland ist der Branchenverband für alle Unternehmen, die in der Gebäudehülle tätig sind. Darunter fallen folgende Fachbereiche:\n\n    Steildach\n    Flachdach\n    Fassade\n    Abdichtung\n    Spengler\n    Gerüstbau\n\n	\n\n    Expertisen\n    Isolationen\n    Dachbegründung\n    Solaranlagen\n    Lehrlingsausbildung',NULL,NULL,'4410',2831,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-26 21:41:35','2023-03-19 23:01:41'),
(499,'Auto Gewerbe Verband Schweiz (AGVS)','Union professionelle suisse de l''automobile UPSA','Unione professionale svizzera dell''automobile','CHE-107.811.810',11267,'CH03560010278',1,1,'Bern','AGVS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',59,26,NULL,'http://www.agvs.ch/','http://www.moneyhouse.ch/u/agvs_autogewerbeverband_der_schweiz_CH-035.6.001.027-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Auto Gewerbe Verband Schweiz (AGVS), 1927 gegründet, versteht sich als dynamischer und zukunftsorientierter Branchen- und Berufsverband der Schweizer Garagisten. Rund 4000 kleine, mittlere und grössere Unternehmen, Markenvertretungen sowie unabhängige Betriebe sind Mitglied beim AGVS. Die insgesamt 39 000 Mitarbeitenden in den AGVS-Betrieben - davon um 8500 in der Aus- und Weiterbildung stehende Nachwuchskräfte - verkaufen, warten und reparieren den grössten Teil des Schweizer Fuhrparks mit rund 5,5 Millionen Fahrzeugen.\n\nIm Fokus der kundenorientierten Dienste stehen die Geschäftsbereiche "Aus- und Weiterbildung", "Handel/Kommunikation" und "Dienstleistungen/After Sales". Die Festigung der Verbandsausrichtung sowie die Konzentration auf bewährte AGVS-Kernkompetenzen sollen den Mitgliedern den grösstmöglichen Nutzen bringen und die Marke AGVS nachhaltig stärken.',NULL,NULL,'3006',351,NULL,NULL,NULL,'2025-07-21 16:13:56','2014-03-26 21:51:30','2025-07-21 16:13:56'),
(500,'Arcosana AG','Arcosana SA',NULL,'CHE-111.720.694',760342,'CH10030282176',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',2,NULL,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003028217&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Betrieb der obligatorischen Krankenpflege- und der freiwilligen Taggeldversicherung als Krankenkasse gemäss Art. 12 des Bundesgesetzes über die Krankenversicherung (KVG).',NULL,NULL,'6005',1061,NULL,NULL,NULL,'2022-09-15 00:00:00','2014-03-26 21:55:25','2024-04-28 10:36:59'),
(501,'Autogewerbeverband der Schweiz AGVS, Sektion beider Basel',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',59,26,NULL,'http://www.agvsbsbl.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-26 21:55:44','2023-03-19 23:01:41'),
(502,'Emmi Finanz AG',NULL,NULL,'CHE-200.318.288',1021821,'CH10037929673',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',38,39,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003792967&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Beteiligung an und Finanzierung von Unternehmungen der Industrie und des Handels, insbesondere aus der Unternehmensgruppe der Emmi AG sowie Durchführung der damit im Zusammenhang stehenden Finanz- und sonstigen Geschäfte; Beteiligungen; Verwaltung von Vermögenswerten, insbesondere Erwerb, Finanzierung, Erstellung, Verwaltung und Veräusserung von Liegenschaften; Tätigung von Patent-, Lizenz- und anderen Immaterialgüterrechtsgeschäften.',NULL,NULL,'6005',1061,NULL,NULL,NULL,'2018-08-13 11:30:39','2014-03-26 22:00:27','2024-04-28 10:36:59'),
(503,'Emmi-Vorsorgestiftung',NULL,NULL,'CHE-109.777.006',280519,'CH10070076649',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1007007664&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Berufliche Vorsorge im Rahmen des BVG und seiner Ausführungsbestimmungen für die Arbeitnehmer der unter der Emmi AG, Luzern, zusammengefassten Unternehmungen und weiteren mit dieser wirtschaftlich oder finanziell eng verbundenen Unternehmungen sowie für deren Angehörige und Hinterlassene gegen die wirtschaftlichen Folgen von Alter, Tod und Invalidität; Betrieb einer über die gesetzlichen Mindestleistungen hinaus weitergehende Vorsorge, einschliesslich Unterstützungsleistungen in Notlagen, wie bei Krankheit, Unfall, Invalidität oder Arbeitslosigkeit; Erbringung der Beiträge der Arbeitgeber aus Mitteln der Stiftung, soweit von diesen vorgängig Beitragsreserven geäufnet worden und diese gesondert ausgewiesen sind.',NULL,NULL,'6005',1061,NULL,NULL,NULL,'2018-08-13 11:30:39','2014-03-26 22:04:16','2024-04-28 10:36:59'),
(504,'ASTAG Schweizerischer Nutzfahrzeugverband','Astag, Association suisse des transports routiers','Astag, Associazione svizzera dei trasporti stradali','CHE-105.884.577',688023,'CH03560310352',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer','punktuell',36,NULL,NULL,'http://www.astag.ch','http://www.moneyhouse.ch/u/astag_schweizerischer_nutzfahrzeugverband_CH-035.6.031.035-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verband bezweckt, die ideellen und wirtschaftlichen Interessen seiner Mitglieder zu wahren und zu fördern. Er setzt sich ein für die Lösung aller Probleme im Zusammenhang mit dem motorisierten Nutzfahrzeugverkehr (Werk- und gewerbsmässiger Verkehr, Personen- und Güterverkehr) auf der Basis der freien Marktwirtschaft.',NULL,NULL,'3006',351,NULL,NULL,NULL,'2025-07-21 17:58:24','2014-03-26 22:06:41','2025-07-21 17:58:24'),
(505,'Astag, Sektion Nordwestschweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',36,NULL,NULL,'http://www.astag.ch/?rub=294',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4410',NULL,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-26 22:08:41','2023-03-19 23:01:41'),
(506,'Emmi-Wohlfahrtsfonds',NULL,NULL,'CHE-109.794.849',460313,'CH10070082311',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1007008231&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Gewährung von einmaligen oder wiederkehrenden Unterstützungen oder von Beiträgen a) an die aktiven und pensionierten Mitarbeiterinnen und Mitarbeiter im Falle von Alter, Krankheit, Unfall, Invalidität, Arbeitslosigkeit oder sonstiger Notlage; b) zugunsten deren Ehegatten und übrigen Hinterbliebenen, der Pflegebefohlenen und der Personen für deren Unterhalt die Mitarbeiterinnen und Mitarbeiter sorgen, im Falle von deren Alter, Krankheit, Unfall, Invalidität, Arbeitslosigkeit oder sonstiger Notlage; c) im Falle des Todes der Mitarbeiterin oder des Mitarbeiters an den überlebenden Ehegatten, die übrigen Hinterbliebenen, die Pflegebefohlenen und die Personen, für deren Unterhalt die Mitarbeiterin oder der Mitarbeiter gesorgt hat; ergänzende Vorsorge für bestimmte Mitarbeiter-Kategorien; dies im Rahmen der vom Stiftungsrat erlassenen Reglemente.',NULL,NULL,'6005',1061,NULL,NULL,NULL,'2018-08-13 11:30:39','2014-03-26 22:09:35','2024-04-28 10:36:59'),
(507,'Kaufmännischer Verband Baselland, Zweigniederlassung Schulen kvBL',NULL,NULL,'CHE-157.300.575',909674,'CH28090117468',1,1,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0151',9,'EinzelOrganisation,LeistungsErbringer','nie',53,NULL,NULL,'www.bildungszentrumkvbl.ch','http://www.moneyhouse.ch/u/kaufmannischer_verband_baselland_zweigniederlassung_bildungszentrum_kvbl_CH-280.9.011.746-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Kaufmännische Verband Baselland (KV BL) fördert die berufliche Bildung im Sinne einer soliden Grundbildung und einer permanenten Weiterbildung. Er ist Träger der im Auftrag des Kantons privatrechtlich geführten KV-Schulen mit drei Schulorten in\n• Reinach\n• Muttenz\n• Liestal',NULL,NULL,'4410',2829,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 22:17:37','2024-04-28 10:36:59'),
(508,'Kaufmännischer Verband Baselland KVBL',NULL,NULL,NULL,NULL,NULL,0,0,'Reinach',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',53,NULL,NULL,'www.kvbl.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-26 22:20:55','2014-11-25 20:52:04'),
(509,'INTRAS Assurance SA',NULL,NULL,'CHE-103.092.163',530743,'CH66015270002',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',2,NULL,NULL,NULL,'http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-660-1527000-2&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Aus der Fusion mit Blavignac S.A., à Carouge (GE) entstanden',NULL,NULL,'1010',5586,NULL,NULL,NULL,'2021-01-04 15:56:03','2014-03-27 07:52:42','2024-04-28 10:36:59'),
(510,'INTRAS Assurance-maladie SA',NULL,'INTRAS Assicurazione malattie SA','CHE-114.377.629',913914,'CH66063640085',1,1,'Lausanne 10',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',2,NULL,NULL,NULL,'http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-660-6364008-5&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: En tant que caisse-maladie au sens de l''article 12 de la loi fédérale sur l''assurance-maladie (LAMal), pratiquer l''assurance-maladie obligatoire et l''assurance facultative d''indemnités journalières (cf. statuts pour but complet).',NULL,NULL,'1000',5586,NULL,NULL,NULL,'2021-01-04 15:56:03','2014-03-27 07:55:23','2024-04-28 10:36:59'),
(511,'Sanagate AG',NULL,NULL,'CHE-114.896.792',946470,'CH10037901817',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',2,NULL,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003790181&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb der obligatorischen Krankenpflege- und der freiwilligen Taggeldversicherung als Krankenkasse gemäss Art. 12 des Bundesgesetzes über die Krankenversicherung (KVG).',NULL,NULL,'6005',1061,NULL,NULL,NULL,'2021-01-04 15:56:03','2014-03-27 08:01:44','2024-04-28 10:36:59'),
(515,'Hauseigentümerverein Gelterkinden und Umgebung',NULL,NULL,NULL,NULL,NULL,0,0,'Gelterkinden',NULL,NULL,NULL,'HEV Gelterkinden und Umgebung',NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',19,NULL,NULL,'http://www.hev-gelterkinden.ch/home/aktuell/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Achtung: Es heisst in diesem einen Fall tatsächlich HauseigentümerVEREIN!',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-27 08:10:25','2023-03-19 23:01:41'),
(516,'Dynamics Group AG',NULL,NULL,'CHE-113.304.378',855678,'CH02030304382',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',18,NULL,NULL,'http://www.dynamicsgroup.ch/de/home.html','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203030438&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Dynamics Group unterstützt ihre Kunden dabei, die Beziehungen zu ihren Stakeholdern - Markt, Investoren, Mitarbeitende, Politik und Öffentlichkeit - zu gestalten. Wir bieten umfassende Beratung auf allen Gebieten der Kommunikation, wobei der Fokus auf Positionierung und Reputation Management, Corporate Communications, Kapitalmarktkommunikation und Public Affairs liegt. Für Aufgaben ausserhalb unserer Kerngebiete ziehen wir spezialisierte Dienstleister bei.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2025-07-11 10:38:35','2014-03-27 08:19:45','2025-07-11 10:38:35'),
(517,'Schweizerische Volkspartei','Union démocratique du centre','Unione democratica di centro',NULL,NULL,NULL,0,0,'Bern','SVP','SVP Schweiz','UDC','UDC Suisse',NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',20,NULL,NULL,'http://www.svp.ch',NULL,'SVPch','svpch','svpch','SVPch','https://www.linkedin.com/company/svp-schweiz?originalSubdomain=ch',NULL,'Die Schweizerische Volkspartei, ist eine 1971 gegründete rechtspopulistische, europaskeptische, nationalkonservative und wirtschaftsliberale politische Partei.','L''Union démocratique du centre, est un parti politique de droite populiste, eurosceptique, national-conservateur et économiquement libéral, fondé en 1971.',NULL,NULL,NULL,NULL,NULL,NULL,'2025-09-02 11:03:28','2014-03-27 08:26:20','2025-09-02 11:03:28'),
(518,'Kaufmännischer Verband Luzern',NULL,NULL,'CHE-105.914.296',97252,'CH10060072026',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',53,NULL,NULL,'http://www.kvluzern.ch/','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1006007202&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Berufsorganisation der Angestellten und Auszubildenden in Kaufmännischen und verwandten Berufsfeldern; Sicherung und Verbesserung der wirtschaftlichen, sozialen, gesellschaftlichen und rechtlichen Lage seiner Mitglieder.',NULL,NULL,'6003',1061,NULL,NULL,NULL,'2025-06-20 15:50:30','2014-03-27 08:43:39','2025-06-20 15:50:30'),
(519,'Schweizerische Volkspartei Baselland',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal','SVP BL','SVP Baselland',NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','nie',20,13,NULL,'http://www.svp-baselland.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4410',NULL,NULL,NULL,NULL,'2023-08-28 14:36:03','2014-03-27 08:44:49','2023-08-28 14:36:03'),
(520,'SwissAccounting',NULL,NULL,'CHE-104.374.931',377040,'CH02060002723',1,1,'Zürich',NULL,'Schweizerischer Verband der dipl. Experten in Rechnungslegung und Controlling und der Inhaber des eidg. Fachausweises in Finanz- und Rechnungswesen',NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',58,NULL,NULL,'http://veb.ch',NULL,NULL,NULL,NULL,NULL,'https://www.linkedin.com/school/veb.ch/?originalSubdomain=ch',NULL,'veb.ch ist der Schweizerische Verband der diplomierten Experten in Rechnungslegung und Controlling und der Inhaber des eidgenössischen Fachausweises in Finanz- und Rechnungswesen. Er ist der grösste schweizerische Fachverband für Führungskräfte in Rechnungswesen und Controlling.','veb.ch est l''association suisse des experts diplômés en comptabilité et en controlling et des titulaires du brevet fédéral de spécialiste en finance et en comptabilité. Elle est la plus grande association professionnelle suisse pour les cadres en comptabilité et en controlling.',NULL,'8001',261,'https://de.wikipedia.org/wiki/Verband_der_diplomierten_Experten_in_Rechnungslegung_und_Controlling','Q2513888',NULL,'2025-06-25 07:21:36','2014-03-27 09:03:56','2025-06-25 07:21:36'),
(521,'KMU-Forum Baselland',NULL,NULL,NULL,NULL,NULL,0,0,'Liestal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation','nie',59,NULL,NULL,'http://www.baselland.ch/fileadmin/baselland/files/docs/ak/kommissionen/komm_vgd.pdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Wirtschaftskammer Baselland ist konstant vertretenes Mitglied der vom Regierungsrat ernannten ausserparlamentarischen Expertengruppe "KMU-Forum". Sie hat ein Vorschlagsrecht für deren Vertreter aus der Wirtschaft. Zu den Kernaufgaben des Forums gehören die Prüfung administrativer Belastungen und Einschränkungen unternehmerischer Freiheiten von KMU, welche aus dem Vollzug neuer und bestehender Regulierungen hervorgehen. Sie macht zudem Empfehlungen zu Händen des Regierungsrats und der kantonalen Verwaltung zur Vereinfachung des unternehmerischen Alltags und alternativer Regulierungen. Die Ausführungsbestimmungen zum KMU-Entlastungsgesetz sehen vor, dass sämtliche Erlasse, von denen KMU betroffen sein könnten, dem KMU-Forum zur Beurteilung zu unterbreiten sind.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-03-19 23:01:41','2014-03-27 09:05:11','2023-03-19 23:01:41'),
(522,'Schweizerische Treuhand-Kammer',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',58,NULL,NULL,'http://www.treuhand-kammer.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Siehe EXPERTsuisse',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-13 11:30:39','2014-03-27 09:09:54','2019-03-11 10:43:31'),
(523,'Schweizerischer Verband der Telekommunikation ASUT',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',47,NULL,NULL,'http://www.asut.ch/',NULL,'asut_ch',NULL,'asut5978',NULL,NULL,NULL,'asut ist der führende Verband der Telekommunikationsbranche in der Schweiz. Der Verband gestaltet gemeinsam mit seinen Mitgliedern die digitale Transformation der Schweiz und setzt sich für optimale politische, rechtliche und wirtschaftliche Rahmenbedingungen für die digitale Wirtschaft ein.','L''asut est l''association leader du secteur des télécommunications en Suisse. Avec ses membres, l''association façonne la transformation numérique de la Suisse et s''engage en faveur de conditions-cadres politiques, juridiques et économiques optimales pour l''économie numérique.',NULL,'3013',NULL,NULL,NULL,NULL,'2025-07-01 18:24:03','2014-03-27 09:30:53','2025-07-01 18:24:03'),
(524,'Aktive Mobilität','Mobilité Douce',NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,'Mobilité active',NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',43,NULL,NULL,'http://fussverkehr.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Förderung der aktiven Mobilitätsformen',NULL,'Jenny Leuba\n+41 43 488 40 33\njenny.leuba@fussverkehr.ch\nFussverkehr Schweiz\nKlosbachstrasse 48\n8032 Zürich\nSCHWEIZ',NULL,NULL,NULL,NULL,'2025-01-26 18:18:51','2025-10-28 08:58:52','2014-03-27 11:55:04','2025-10-28 08:58:52'),
(525,'Forum Velostationen Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',43,NULL,NULL,'http://www.velostation.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Forum Velostationen ist ein lockerer Zusammenschluss betroffener und interessierter Personen und Institutionen. Es wird von Pro Velo Schweiz und der Velokonferenz Schweiz getragen und vom Bundesamt für Strassen (ASTRA) unterstützt. Ein Ausschuss, zusammengestellt aus Vertretern der beiden Organisationen, koordiniert die Aktivitäten des Forums und bereitet sie vor.\n\nDas Forum Velostationen Schweiz unterstützt seit 1996 den Aufbau von Velostationen. Sie führt Informationsveranstaltungen durch, gibt einen Infoletter heraus und bietet spezialisierte FachberaterInnen für Behörden, welche sich für den Aufbau einer Velostation interessieren. Velostationen erlauben das geschützte und überwachte, meist kostenpflichtige Abstellen von Velos. Damit entsprechen sie dem Bedürfnis vieler Velofahrender, die ihr Velo am Bahnhof abstellen. Viele Velostationen bieten darüberhinaus weitere Dienstleistungen rund ums Velo an.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-27 12:09:32','2021-01-03 08:52:54'),
(526,'Velokonferenz Schweiz','Conférence Vélo suisse','Conferenza Bici Svizzera',NULL,NULL,NULL,0,0,'Biel/Bienne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',43,NULL,NULL,'http://www.velokonferenz.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Velokonferenz Schweiz (VkS) ist ein Forum für Erfahrungsaustausch und Wissenstransfer für Fachleute des Veloverkehrs in Verwaltungen, Behörden sowie Planungs- und Ingenieurbüros. Sie hat zum Ziel, die Rahmenbedingungen für den Veloverkehr auf Kantons-, Stadt- und Gemeindegebiet sowie auf Bundesebene zu verbessern.',NULL,NULL,'2501',NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-27 12:14:43','2015-02-23 14:52:17'),
(527,'Forum Bikesharing Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',43,NULL,NULL,'http://www.bikesharing.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Forum bikesharing Schweiz ist ein Angebot von Velokonferenz Schweiz und Pro Velo Schweiz. Es finanziert sich aus Geldern des Bundesamtes für Strassen, Unterstützungsbeiträgen von Institutionen aus dem Fachgebiet sowie Einnahmen über die angebotenen Dienstleistungen. \n\nDie Koordination bikesharing will eine Austauschplattform bieten rund um dieses neue Velo-Phänomen, das aus verschiedenen Gründen Akzente setzt:\n\nDas Velo als nachhaltiges Verkehrsmittel wird noch einfacher verfügbar und im Strassenbild sichtbarer.\nBikesharing-Velos können das eigene (Bahnhof )Velo ersetzen und damit die Velofahrenden von Diebstahl- und Vandalismusängsten entlasten.\nDie öffentlichen Leihvelos entlasten überfüllte Abstellanlagen.\nBikesharing vereinfacht den Tür-zu-Tür-Transport in Kombination mit dem öffentlichen Verkehr.\nVelos im Selbstverleih sind ein Stadtmarketing-Faktor.\nBikesharing ist service public.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-28 15:52:50','2021-01-03 08:52:54'),
(528,'Bundesamt für Strassen ASTRA',NULL,NULL,'CHE-304.459.014',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich','0220',NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',26,NULL,NULL,'http://www.astra.admin.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Seit seiner Gründung 1998 ist das Bundesamt für Strassen (ASTRA) die Schweizer Fachbehörde für die Strasseninfrastruktur und den individuellen Strassenverkehr.\n\nIm Verantwortungsbereich des eidgenössischen Departements für Umwelt, Verkehr, Energie und Kommunikation (UVEK) wirkt es für eine nachhaltige und sichere Mobilität auf der Strasse.\n\nIm Mittelpunkt steht folgendes Ziel: Sicherstellung der Funktionsfähigkeit des Nationalstrassen und Hauptstrassennetzes.',NULL,NULL,NULL,362,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-03-28 15:59:45','2022-09-25 22:33:13'),
(529,'Swiss Re AG',NULL,NULL,'CHE-191.546.434',1009345,'CH02030361838',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'AG','0106',3,'LeistungsErbringer','punktuell',57,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Zweck der Gesellschaft ist der Erwerb, das Halten, die Verwaltung und der Verkauf von direkten oder indirekten Beteiligungen an jeglicher Art von Geschäften in der Schweiz und im Ausland, insbesondere in den Bereichen Rückversicherung, Versicherung und Vermögensverwaltung. Die Gesellschaft kann jegliche Tätigkeiten durchführen und jegliche Massnahmen ergreifen, die dem Zweck der Gesellschaft dienen. Die Gesellschaft kann Beteiligungen an anderen Unternehmen in der Schweiz und im Ausland erwerben. Als Nebentätigkeit kann die Gesellschaft sowohl in der Schweiz als auch im Ausland Hypotheken und Immobilien erwerben und verkaufen. Die Gesellschaft wurde als Holdinggesellschaft für die Swiss Re Gruppe gegründet. Im Falle des Vollzugs des Umtauschangebotes der Aktien der Schweizerischen Rückversicherungs-Gesellschaft AG hält die Gesellschaft direkt oder indirekt die Mehrheit der Anteile der Unternehmen der Swiss Re Gruppe.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-01 14:01:18','2024-04-28 10:36:59'),
(531,'Stiftung Accentus',NULL,NULL,'CHE-109.640.867',524003,'CH02070007580',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'https://www.accentus.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000758&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Stiftung ist die Unterstützung und Förderung der Ausbildung, der Forschung sowie sozialer, karitativer, humanitärer, kultureller, medizinischer, wissenschaftlicher, ökologischer und anderer gemeinnütziger Werke. Die Stiftung ist politisch und konfessionell neutral.',NULL,NULL,'8045',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-02 08:10:55','2024-04-28 10:36:59'),
(532,'Stiftung EMPIRIS',NULL,NULL,'CHE-109.990.623',690348,'CH02070010135',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'Sie fördert Wissenschaft, Forschung und Ausbildung in verschiedenen Fachbereichen/Sachbereichen.','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001013&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Stiftung ist die Unterstützung und Förderung der Forschung, Wissenschaft und Ausbildung; die Stiftung übt ihre Tätigkeit aus beispielsweise durch Initiierung, Förderung und Unterstützung von Bestrebungen, Veranstaltungen oder Projekten im Ausbildungs-, Lehr- und Forschungsbereich; sie richtet unentgeltliche Zuwendungen an Institutionen und Organisationen in der Schweiz und im Ausland aus, welche öffentliche oder gemeinnützige Zwecke verfolgen und die Unterstützung und Förderung der Forschung, Wissenschaft und Ausbildung bezwecken. Die Tätigkeit der Institutionen und Organisationen kann national oder international ausgerichtet sein; kann auch Stipendien und sonstige Unterstützungsbeiträge an natürliche Personen ausrichten, Lehrstühle einrichten und finanzieren und Preise an Persönlichkeiten, Institutionen und Organisationen verleihen sowie alle weiteren Aktivitäten entfalten, die der Durchführung des Stiftungszwecks dienen.',NULL,NULL,'8045',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-02 08:15:39','2024-04-28 10:36:59'),
(533,'SIB Institut Suisse de Bioinformatique','Institut Suisse de Bioinformatique, SIB',NULL,'CHE-101.064.173',426004,'CH66007339983',1,1,'Genève','SIB',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,NULL,'http://ge.ch/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-660-0733998-3&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Das SIB wurde 1998 gegründet. Es entstand aus einer Gruppe von fünf engagierten Bioinformatikern.\n\nMit 30 Wissenschaftern von den Universitäten Genf und Lausanne, der Universitätsklinik in Genf sowie dem Ludwig-Institut für Krebsforschung und dem ISREC in Lausanne startete es seine Forschungstätigkeit.\n\nHeute umfasst es 25 Forschungsgruppen mit 300 Bioinformatikern an den Universitäten Genf, Lausanne, Basel, Zürich und Bern, den ETH in Zürich und Lausanne, dem Schweizerischen Institut für experimentelle Krebsforschung, dem Ludwig-Institut und dem Friedrich Miescher Institut.\n\nFinanziert wird das SIB hauptsächlich von der Schweizer Regierung und dem Nationalfond (40%). Ausserdem von der Europäischen Union (EU), den National Institutes of Health in den USA und der Industrie.\n\nDas Jahresbudget beträgt 18 Mio. Franken.\n\n160 Mitarbeiter unterstehen direkt dem SIB, zahlreiche weitere Mitarbeiter den kooperierenden Universitäten.',NULL,NULL,'1206',6621,NULL,NULL,NULL,'2023-09-11 08:51:30','2014-04-02 08:22:43','2024-04-28 10:36:59'),
(534,'Stiftung SYMPHASIS',NULL,NULL,'CHE-109.990.646',690351,'CH02070010140',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'https://www.symphasis.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001014&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Stiftung ist die Unterstützung und Förderung von sozialen und karitativen Werken, von Natur-, Tier- und Artenschutz, von Jugend-Behinderten-, Senioren- und Breitensport zur Steigerung der Gesundheit sowie der Kultur in all ihren möglichen Formen.',NULL,NULL,'8045',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-02 08:26:28','2024-04-28 10:36:59'),
(535,'Schweizerischer Verkehrssicherheitsrat',NULL,NULL,'CHE-113.603.800',871043,'CH03560372670',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',26,NULL,NULL,'http://www.vsr.ch/','http://www.moneyhouse.ch/u/schweizerischer_verkehrssicherheitsrat_CH-035.6.037.267-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Verkehrssicherheitsrat bezweckt die Förderung und Verstärkung aller Massnahmen zur Verbesserung der Verkehrssicherheit im Bereich des Strassenverkehrs in enger Zusammenarbeit mit den zuständigen Behörden, Organisationen und Dritten, die an dieser Zielsetzung interessiert sind. Er befasst sich mit den Einstellungen und dem Verhalten der Verkehrsteilnehmenden. Er fördert insbesondere die Entwicklung und Vertiefung des Verkehrssinns, die Kenntnis und Akzeptanz der Verkehrsvorschriften, die Verkehrserziehung sowie die lebenslange Aus- und Weiterbildung der Fahrzeuglenkerinnen und -lenker.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2024-06-18 11:48:24','2014-04-03 09:17:19','2024-06-18 11:48:24'),
(536,'Fonds für Verkehrssicherheit',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Ausserparlamentarische Kommission',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',26,NULL,NULL,'http://www.fvs.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Verwaltungskommission setzt sich aus 12 durch den Bundesrat ernannten Mitgliedern  aus  Bund, Kantonen, Verbänden und Organisationen des Strassenverkehrs sowie Versicherern zusammen.\nDie Verwaltungskommission tagt  viermal jährlich und entscheidet über die FVS-Strategie sowie  Gesuchsanträge. Abschlägige Entscheide der Verwaltungskommission können beim Bundes-verwaltungsgericht angefochten werden.\nSeit 2005 existiert ein Expertenrat. Er setzt sich aus Vertretern der wichtigsten Organisationen des Strassenverkehrs zusammen und unterstützt die Verwaltungskommission in beratender Funktion.\nDie Geschäftsstelle setzt die Beschlüsse der Verwaltungskommission selbständig um. Sie prüft Gesuche und Abrechnungen in formeller und materieller Hinsicht und kontrolliert sowie überwacht die laufenden Projekte.   \n\nDer Fonds für Verkehrssicherheit ist gemäss Unfallverhütungsbeitragsgesetz für die Förderung und Koordination von Massnahmen zur Verhütung von Unfällen im Strassenverkehr verantwortlich und verwaltet die ihm aus den Unfallverhütungsbeiträgen zur Verfügung gestellten Mittel (Art. 3ff.). \n\n"Weil das "menschliche Fehlverhalten" mit Abstand die häufigste Unfallursache ist, verschreibt sich der FVS dem lebenslangen Lernen. Das Lernen und damit einhergehend die Beeinflussung des menschlichen Verhaltens erfolgt u.a. durch Öffentlichkeitsarbeit (Kampagnen), Massnahmen im Bereich Schule und Verkehr (Schutzmassnahmen und Verkehrserziehung) sowie freiwillige Weiterbildung.    \nEin besonderes Anliegen des FVS ist auch der Schutz der schwächeren und schwächsten Verkehrsteilnehmer wie Fussgänger und Velofahrer. Besonders berücksichtigt werden aber auch Verkehrsteilnehmergruppen mit hohem Unfallrisiko, wie Neulenker und Motorradfahrer. "',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-03 09:33:11','2021-01-03 08:52:54'),
(537,'Sozialversicherungsanstalt des Kantons Zürich SVA',NULL,NULL,'CHE-115.115.753',NULL,NULL,0,0,'Zürich','SVA','SVA Zürich',NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0234',NULL,'EinzelOrganisation,LeistungsErbringer','nie',56,NULL,NULL,'https://svazurich.ch/',NULL,NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/svazurich/?originalSubdomain=ch',NULL,'Die SVA Zürich (Sozialversicherungsanstalt des Kantons Zürich) ist das Kompetenzzentrum für Sozialversicherungen im Kanton Zürich. Kundinnen und Kunden der SVA Zürich sind die Versicherten und Arbeitgebenden im Kanton Zürich.','La SVA Zurich (Agence d''assurances sociales du canton de Zurich) est le centre de compétence en matière d''assurance sociale du canton de Zurich. Les clients de la SVA Zurich sont les assurés et les employeurs du canton de Zurich.',NULL,'8005',261,NULL,NULL,NULL,'2025-07-02 13:06:47','2014-04-03 09:40:11','2025-07-02 13:06:47'),
(538,'WOHNEN SCHWEIZ Genossenschaft - Verband der Baugenossenschaften','Association des Coopératives de Construction',NULL,'CHE-116.249.913',1000621,'CH10057921416',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',19,NULL,NULL,'www.wohnen-schweiz.ch','http://www.moneyhouse.ch/u/wohnen_schweiz__verband_der_baugenossenschaften_CH-100.5.792.141-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'WOHNEN SCHWEIZ - Verband der Baugenossenschaften gehört im Rahmen des Wohnraumförderungsgesetzes WFG zu den schweizerischen Dachorganisationen des gemeinnützigen Wohnungsbaus.\n \nWOHNEN SCHWEIZ ist ein zuverlässiger Partner und hilft mit fachlicher Kompetenz zum guten Gelingen von Wohnbauprojekten der Wohnbaugenossenschaften.',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2025-08-20 00:00:00','2014-04-03 10:14:07','2025-08-20 09:22:26'),
(539,'Eawag',NULL,NULL,NULL,NULL,NULL,0,0,'Dübendorf',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',122,NULL,NULL,'www.eawag.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Eawag ist ein Forschungsinstitut im ETH-Bereich. Dieser umfasst die Eidgenössischen Technischen Hochschulen ETH Zürich und EPF Lausanne sowie die vier Forschungs-Institutionen PSI, WSL, Empa und Eawag. Der ETH-Bereich wird vom ETH-Rat geführt und ist dem Eidgenössischen Departement des Innern zugeordnet.\nDie Eawag besitzt zwölf Forschungsabteilungen, in welchen Natur-, Ingenieur- und Sozialwissenschafter innovative und qualitativ hochstehende Forschung betreiben. Die Kombination der verschiedenen wissenschaftlichen Disziplinen erlaubt eine ganzheitliche Erforschung des Wassers und der Gewässer. Forschungsschwerpunkte der Eawag sind Aquatische Ökosysteme, Urbane Wassersysteme sowie Chemikalien und Effekte.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-06 14:59:32','2014-04-03 10:22:35','2021-01-03 08:52:54'),
(541,'Schweizerischer Ingenieur- und Architektenverein (SIA)','Société suisse des ingénieurs et des architectes','Società svizzera degli ingegneri et degli architetti SIA','CHE-105.955.734',165982,'CH02069003986',1,1,'Zürich','SIA',NULL,'SIA',NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',51,NULL,NULL,'http://www.sia.ch','http://www.moneyhouse.ch/u/schweizerischer_ingenieur_und_architektenverein_%28sia%29_CH-020.6.900.398-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der SIA vereinigt Berufsleute aus Ingenieurwesen, Architektur und Wissenschaften verwandter Ausrichtung mit universitärer oder gleichwertiger Ausbildung. Ziel des SIA ist die Förderung von Ingenieurwesen, Architektur und anderen wissenschaftlichen Disziplinen aus den Bereichen Bau, Technik und Umwelt. Er bekräftigt deren kulturelle, soziale wie wirtschaftliche Bedeutung und fördert das kreative und innovative Schaffen der dahinter stehenden Fachleute sowie deren Streben nach Qualität. Der SIA fördert die interdisziplinäre Zusammenarbeit. Durch sein Wirken als massgebende schweizerische Berufsorganisation stellt er den Kontakt unter seinen Mitgliedern und zu den Behörden, zur Wirtschaft, zu den Bildungsinstitutionen und zur Öffentlichkeit sicher.','La Société suisse des ingénieurs et des architectes SIA est l''association professionnelle de référence des spécialistes de la construction, de la technique et de l''environnement. Avec ses seize mille membres actifs dans tous les domaines de l''architecture et de l''ingénierie, la SIA représente un réseau interdisciplinaire unique dont l''objectif central est de façonner le cadre naturel et bâti en Suisse selon des critères de durabilité et de qualité élevés.',NULL,'8001',261,NULL,NULL,NULL,'2025-07-01 13:13:27','2014-04-03 13:10:00','2025-07-01 13:13:27'),
(542,'Swiss eMobility','Swiss eMo­bil­ity',NULL,'CHE-487.002.813',1147994,'CH03660577823',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',26,NULL,NULL,'http://www.swiss-emobility.ch','http://www.moneyhouse.ch/u/swiss_emobility_CH-036.6.057.782-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Swiss eMobility ist eine Dachorganisation der Verkehrs- und Energiewirtschaft in der Schweiz. Sie unterstützt die Schaffung der politischen und institutionellen Grundlagen für die Entwicklung der Elektromobilität in der Schweiz. Er tritt ein für die Wahrung der Interessen im Zusammenhang mit der Elektromobilität. Er befasst sich mit wirtschaftlichen, rechtlichen, technischen, strukturellen, ökologischen und sozialen Fragen der Elektromobilität, gibt Empfehlungen ab und trifft Massnahmen zuhanden von Behörden und Parlamenten. Er fasst die gemeinsamen Bestrebungen seiner Mitglieder zusammen und vertritt die gemeinsamen Forderungen und Interessen gegenüber Behörden und Parlamenten sowie der Öffentlichkeit. Er fördert Bestrebungen einzelner Mitglieder, die mit dem Interesse von Swiss eMobility im Einklang stehen. Zudem pflegt er Kontakte mit internationalen Organisationen mit gleichen Interessen.','L''as­so­ci­a­tion Swiss eMo­bil­ity sou­tient la création de bases poli­tiques et in­sti­tu­tion­nelles en­cour­ageant le développe­ment de la mo­bilité élec­trique en Su­isse.\n Portrait\nElle défend les intérêts de ses mem­bres dans ce con­texte. Swiss eMo­bil­ity s''oc­cupe des as­pects économiques, ju­ridiques, tech­niques, struc­turels, écologiques et so­ci­aux de la mo­bilité élec­trique, donne des recom­man­da­tions et prend des mesures à l''in­ten­tion des au­torités et des par­lements. En outre, elle en­tre­tient des con­tacts avec des or­gan­i­sa­tions in­ter­na­tionales représen­tant les mêmes intérêts.',NULL,'3015',351,NULL,NULL,NULL,'2025-09-10 16:29:25','2014-04-03 13:15:32','2025-09-10 16:29:25'),
(543,'Cleantech21 Foundation',NULL,NULL,'CHE-113.966.792',892343,'CH02070014760',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',50,NULL,NULL,'www.ffgs.org','http://www.moneyhouse.ch/u/foundation_for_global_sustainability_%28ffgs%29_CH-020.7.001.476-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'FFGS is a think & do tank. We initiate and coordinate research and project development activities in the field of sustainability. We identify the right topics, work with the right partners, and deliver tangible and practical results.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2016-09-06 14:43:15','2014-04-03 13:35:00','2024-04-28 10:36:59'),
(544,'Maxmakers AG',NULL,NULL,'CHE-102.816.964',304217,'CH02039058517',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',19,NULL,NULL,'www.maxmakers.com','http://www.moneyhouse.ch/u/maxmakers_ag_CH-020.3.905.851-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'"Maxmakers is an international real estate development consulting firm, with a team of seasoned industry professionals. We advise governments and investors in developing complex real estate and destination projects."\n\nZweck der Gesellschaft ist die Erbringung von Dienstleistungen auf dem Gebiet der Planung und Durchführung von Projekten sowie die Abwicklung von Finanzgeschäften aller Art auf eigene oder fremde Rechnung, insbesondere der An- und Verkauf, das Halten und Verwalten von in- und ausländischen Beteiligungen an Unternehmungen, Immobilienprojekten und immateriellen Gütern jeglicher Art. Die Gesellschaft kann Mobilien, Immobilien, Konzessionen, Patente, Lizenzen und Rechte aller Art erwerben und veräussern; sie ist ferner berechtigt, Geschäfte abzuschliessen und sonstige Tätigkeiten auszuüben, die mit ihrem Zwecke in irgend einer Weise zusammenhängen. Durch Beschluss der Generalversammlung kann sie Zweigniederlassungen und Tochtergesellschaften im In- wie im Ausland errichten.',NULL,NULL,'8006',261,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-03 15:15:14','2024-04-28 10:36:59'),
(545,'Stiftung Global Infrastructure Basel',NULL,NULL,'CHE-116.200.025',999066,'CH27070030624',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Stiftung','0110',7,'DachOrganisation,LeistungsErbringer','nie',50,NULL,NULL,'http://www.gib-foundation.org/','http://www.moneyhouse.ch/u/global_infrastructure_basel_foundation_CH-270.7.003.062-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Zweck der Stiftung ist die Förderung der Zusammenarbeit verschiedener lokaler, regionaler, nationaler und globaler Akteure, welche gemeinsam eine nachhaltige Entwicklung anstreben, speziell durch Schaffung nachhaltiger Infrastrukturen in Entwicklungs- und Schwellenländern, aber auch in Industrieländern. Damit will die Stiftung einen Beitrag zum Klimaschutz, zur Ressourcenschonung und zu einer nachhaltigen Energieversorgung leisten.  Die Stiftung verfolgt keine Individualinteressen und keine wirtschaftlichen Zwecke.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2022-09-21 00:00:00','2014-04-03 15:30:39','2024-04-28 10:36:59'),
(546,'CleanTech Capital GmbH in Liquidation',NULL,NULL,'CHE-110.510.964',735732,'CH17040046992',1,1,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation','nie',50,NULL,NULL,'www.cltcap.com','http://www.moneyhouse.ch/u/cleantech_capital_gmbh_CH-170.4.004.699-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Erbringung von Beratungs-, Coaching-, Interim Management- und anderen Dienstleistungen namentlich in den Bereichen Business Development, Marketing und Vertrieb, Strategie- und Organisationsberatung, Kauf und Verkauf von Unternehmen, Kooperationen und Partnerschaften sowie Change- und Projektmanagement, insbesondere im Clean Technology und Infrastrukturbereich; vollständige Zweckumschreibung gemäss Statuten',NULL,NULL,'6300',1701,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-03 15:38:43','2024-04-28 10:36:59'),
(547,'Ampard AG in Liquidation',NULL,NULL,'CHE-392.647.932',1013144,'CH02030363066',1,1,'ohne Domizil-sans domicile',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',50,NULL,NULL,'http://www.ampard.com/','http://www.moneyhouse.ch/u/ampard_ag_CH-020.3.036.306-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Zweck der Gesellschaft ist die Beratung, Technologieentwicklung und das Beteiligungsmanagement im Bereich Energie sowie die Projektentwicklung, Finanzierung und der Betrieb von elektrischen Anlagen. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im In- und Ausland errichten und sich an anderen Unternehmen im In- und Ausland beteiligen sowie alle Geschäfte tätigen, die direkt oder indirekt mit ihrem Zweck in Zusammenhang stehen. Die Gesellschaft kann im In- und Ausland Grundeigentum erwerben, belasten, veräussern und verwalten. Sie kann auch Finanzierungen für eigene oder fremde Rechnung vornehmen sowie Garantien und Bürgschaften für Tochtergesellschaften und Dritte eingehen.',NULL,NULL,'8037',261,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-03 15:43:23','2024-04-28 10:36:59'),
(548,'UBS Clean Energy Infrastructure Switzerland AG in Liquidation',NULL,NULL,'CHE-440.083.827',1121453,'CH27030147898',1,1,'Basel','UBS',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',16,50,NULL,'http://www.ubs.com/ch/de/asset_management/institutionelle-anleger/investment-solutions/clean-energy-infrastructure-switzerland/overview.html','http://www.moneyhouse.ch/u/ubs_clean_energy_infrastructure_switzerland_ag_CH-270.3.014.789-8.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft ist als Komplementärin für die UBS Clean Energy Infrastructure Switzerland, Kommanditgesellschaft für kollektive Kapitalanlagen tätig und bezweckt die Strukturierung, Gründung, Verwaltung und Beratung von Unternehmen und kollektiven Kapitalanlagen im Bereich erneuerbarer Energien, Energieeffizienz und Energieinfrastruktur sowie verwandten Gebieten. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im In- und Ausland errichten und sich an anderen Unternehmen im In-und Ausland beteiligen. Die Gesellschaft kann alle kommerziellen, finanziellen und anderen Tätigkeiten ausüben, die geeignet erscheinen, den Zweck der Gesellschaft zu fördern, oder die mit diesem zusammenhängen.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2018-04-08 18:04:50','2014-04-03 15:56:03','2024-04-28 10:36:59'),
(549,'Hochschule für Technik Rapperswil (HSR), Fachhochschule Ostschweiz',NULL,NULL,'CHE-116.078.391',NULL,NULL,0,1,'Rapperswil SG','HSR',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich','0224',NULL,'EinzelOrganisation,LeistungsErbringer','nie',41,NULL,NULL,'http://www.hsr.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die HSR Hochschule für Technik Rapperswil ist Mitglied der Fachhochschule Ostschweiz FHO. 1972 wurde sie als Interkantonales Technikum Rapperswil gegründet. Die HSR wird von den drei Kantonen St. Gallen, Schwyz und Glarus getragen undl bildet in Technik/IT sowie Architektur/Bau/Planung rund 1500 Bachelor- und Masterstudierende aus. Die CAS- und MAS-Lehrgänge an der HSR richten sich an Fachleute aus der Praxis. Durch ihre 18 Institute der anwendungsorientierten Forschung und Entwicklung pflegt die HSR eine intensive Zusammenarbeit mit der Wirtschaft und der öffentlichen Hand.',NULL,NULL,'8640',3340,NULL,NULL,NULL,'2022-10-14 00:00:00','2014-04-03 16:27:38','2022-11-18 05:08:47'),
(550,'Verein CULTURA',NULL,NULL,'CHE-496.596.381',1113450,'CH03660550339',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',44,NULL,NULL,NULL,'http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0366055033&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein CULTURA ist der Dachverband der Schweizerischen Organisationen der Kulturunternehmen und -institutionen. Er bezweckt die Förderung und Wahrung der Interessen ihrer Mitglieder. Seine Tätigkeit hat keine eigenen Gewinnzwecke zum Ziel.',NULL,NULL,'3005',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-04 08:47:56','2024-04-28 10:36:59'),
(551,'The Swiss Leading Hospitals',NULL,NULL,'CHE-114.075.973',899342,'CH17060002108',1,1,'Baar',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,dezidierteLobby','nie',5,NULL,NULL,'http://www.slh.ch','http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1706000210&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Erhöhung des Anteils von in- und ausländischen Patienten bei den Vereinsmitgliedern sowie Interessenvertretung der Vereinsmitglieder gegenüber in- und ausländischen Versicherungseinrichtungen.',NULL,NULL,'6340',1701,NULL,NULL,NULL,'2022-09-13 00:00:00','2014-04-04 16:55:05','2024-04-28 10:36:59'),
(552,'EVTEC AG',NULL,NULL,'CHE-115.813.047',986996,'CH10037916622',1,1,'Obernau',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',26,NULL,NULL,'http://www.evtec.ch/c5website/index.php','http://www.moneyhouse.ch/u/evtec_ag_CH-100.3.791.662-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Das EVTEC-Team besteht aus Ingenieuren mit umfangreicher Erfahrung im Bereich der Elektronik, Leistungselektronik und Regelungstechnik mit Schwerpunkt Elektromobilität. Mit einem Netzwerk aus Fertigungspartnern und Fachspezialisten im Gebiet elektronischer und mechatronischer Komponenten ist EVTEC in der Lage, Sie bei der Konzeption, Planung und Prototypenfertigung im Rahmen Ihres E-Mobil-Projekts zu unterstützen.\n\nHandelsregister:\nForschung, Entwicklung, Beratung, Schulung und Handel in den Bereichen Elektronik und Informatik; Beteiligungen; Erwerb, Belastung, Veräusserung und Verwaltung von Grundeigentum; Vornahme von Finanzierungen; Eingehung von Garantien und Bürgschaften für Tochtergesellschaften und Dritte.',NULL,NULL,'6012',1059,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-05 10:24:48','2024-04-28 10:36:59'),
(553,'ewz UTN NE1 AG',NULL,NULL,'CHE-114.920.019',947784,'CH02030339170',1,1,'Laufenburg','UTN',NULL,NULL,NULL,NULL,NULL,191,2,'AG','0106',3,'MitgliedsOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'http://www.stadt-zuerich.ch/content/ewz/de/index.html','http://www.moneyhouse.ch/u/ewz_ubertragungsnetz_ag_CH-020.3.033.917-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt insbesondere den Betrieb und die Sicherstellung der Leistungsfähigkeit, wie Unterhalt und Ausbau, und die Interoperabilität der Elektrizitätsnetzanlagen und der dazugehörigen Nebenanlagen, namentlich des 380/220 kV-Netzes. Sie kann alle damit zusammenhängenden Tätigkeiten und Dienstleistungen erbringen. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im In- und Ausland errichten und sich an anderen Unternehmen im In- und Ausland beteiligen sowie alle Geschäfte tätigen, die direkt oder indirekt mit ihrem Zweck in Zusammenhang stehen oder geeignet sind, ihn zu fördern. Die Gesellschaft kann im In- und Ausland Grundeigentum erwerben, belasten, veräussern und verwalten. Sie kann auch Finanzierungen für eigene oder fremde Rechnung vornehmen sowie Garantien und Bürgschaften für Tochtergesellschaften, die Aktionärin und Dritte eingehen.',NULL,NULL,'5080',4170,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-05 10:35:27','2024-04-28 10:36:59'),
(554,'Azienda elettrica ticinese',NULL,NULL,'CHE-108.954.547',226546,'CH50080005335',1,1,'Monte Carasso',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'MitgliedsOrganisation,LeistungsErbringer','punktuell',123,NULL,NULL,'http://www.aet.ch','http://www.moneyhouse.ch/u/azienda_elettrica_ticinese_CH-500.8.000.533-5.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Produktion und Handel von Strom und bietet zu diesem Zweck, die Erzeugung von Wasserkraft, dass der Staat es zu benutzen selbst entscheidet, nach kantonalen und eidgenössischen Gesetzgebung in Kraft, und die Anteile von Energie aus bestehenden oder zukünftigen Investitionen.','La production et le commerce de l''électricité et offre à cette fin, la production d''énergie hydroélectrique que l''État décide d''utiliser lui-même, selon la législation cantonale et fédérale en vigueur, et les parts d''énergie provenant d''investissements existants ou futurs.',NULL,'6513',5002,NULL,NULL,NULL,'2014-11-05 16:06:27','2014-04-05 10:43:30','2024-11-03 15:08:52'),
(555,'Energie Wasser Bern',NULL,NULL,'CHE-109.954.395',680321,'CH03580307604',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,3,'Oeffentlich-rechtlich','0117',8,'MitgliedsOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'http://www.ewb.ch','http://www.moneyhouse.ch/u/energie_wasser_bern_CH-035.8.030.760-4.htm?eid=756364',NULL,NULL,NULL,NULL,NULL,NULL,'Erfüllt öffentliche und gewerbliche Aufgaben in den Bereichen Energieversorgung (Elektrizität, Gas, Fernwärme), Wasserversorgung, thermische Kehrichtverwertung und Fernmeldedienste auf dem Gebiet der Stadt Bern. Ist berechtigt, auch ausserhalb dieses Gebietes tätig zu werden. Kann mit andern Unternehmen des öffentlichen oder privaten Rechts zusammenarbeiten sowie solche Unternehmen erwerben oder sich daran beteiligen. Kann eigene Unternehmensteile veräussern und in rechtlich selbständige Unternehmen überführen. An Tochterunternehmen können sich andere Unternehmen beteiligen. Vollständiger Leistungsauftrag vgl. Reglement der Energie Wasser Bern vom 22.05.2003.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2025-07-01 12:59:42','2014-04-05 10:51:26','2025-07-01 12:59:42'),
(556,'Elektrizitätswerke des Kantons Zürich (EKZ)',NULL,NULL,'CHE-108.954.688',437308,'CH02089000022',1,1,'Zürich','EKZ',NULL,NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'http://www.ekz.ch/content/ekz/de/home.html','http://www.moneyhouse.ch/u/elektrizitatswerke_des_kantons_zurich_(ekz)_CH-020.8.900.002-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die EKZ versorgen rund eine Million Menschen kostengünstig, sicher und umweltgerecht mit Strom. Sie setzen rund zehn Prozent des in der Schweiz benötigten Stroms ab und gehören damit zu den grössten Schweizer Energieversorgungsunternehmen.\n\nDie EKZ setzen sich bewusst für die nachhaltige Gestaltung der Zukunft ein. Mit Investitionen in Produktionsanlagen im In- und Ausland, innovativen Projekten sowie ihrer Auswahl von Naturstromprodukten unterstützen sie den Ausbau der erneuerbaren Energien.\n\nDer Geschäftsbereich EKZ Eltop plant und realisiert massgeschneiderte Lösungen in den Bereichen Elektroinstallationen, Telekommunikation, Informatik sowie Gebäudeautomation für Privat- und Geschäftskunden sowie die öffentliche Hand.\n\nInsgesamt beschäftigen die EKZ rund 1500 Mitarbeitende, darunter 200 Lernende. Die EKZ sind ein selbständiges, öffentlich-rechtliches Unternehmen und zu 100 Prozent im Besitz des Kantons Zürich. Mit einer Beteiligung von 18,4 Prozent sind sie die grösste Aktionärin der Axpo Holding AG und haben damit Zugang zu Produktionskapazitäten.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2024-09-30 15:01:56','2014-04-05 15:17:35','2024-09-30 15:01:56'),
(557,'Swisscom (Schweiz) AG',NULL,NULL,'CHE-101.654.423',415941,'CH03530169309',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',47,NULL,NULL,'http://www.swisscom.ch/de/biz/managed-mobility.html?campID=shortcut-mobility','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0353016930&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Swisscom ist das führende Telekommunikations-Unternehmen der Schweiz mit Sitz in Ittigen nahe der Hauptstadt Bern. Über 20''000 Mitarbeitende erzielten 2013 einen Umsatz von CHF 11,43 Mia.',NULL,NULL,'3050',362,NULL,NULL,NULL,'2022-08-22 10:51:50','2014-04-05 15:25:09','2024-04-28 10:36:59'),
(558,'Bouygues E&S InTec Management AG',NULL,NULL,'CHE-100.032.911',448272,'CH02039149846',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,5,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',31,52,NULL,'http://www.alpiq-intec.ch/ueber-alpiq-intec/about-alpiq-intec.jsp','http://www.moneyhouse.ch/u/alpiq_intec_management_ag_CH-020.3.914.984-6.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Alpiq InTec, eine Tochter der Alpiq Holding, ist ein Schweizer Unternehmen mit 80 Standorten in allen Landesteilen. Die Firmengruppe besteht aus mehreren Tochtergesellschaften, die sich geografisch und thematisch spezialisiert haben.\n\nDie Alpiq InTec Gruppe (ehemals Atel Installationstechnik AG) mit Sitz in Zürich ist ein in den Bereichen Gebäudetechnik, Gebäudemanagement, Verkehrstechnik, Energieversorgungstechnik, Prozessautomation, Energieeffizienz-Beratung und Elektromobilität tätiges Schweizer Unternehmen. Ihren geografischen Fokus richtet die Gruppe auf die Schweiz und Norditalien sowie, im Bereich Verkehrstechnik, auf ganz Europa.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-05 15:34:01','2024-04-28 10:36:59'),
(559,'Alpiq Holding SA',NULL,NULL,'CHE-100.032.288',122834,'CH40039231459',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,5,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'http://www.alpiq.ch','http://www.moneyhouse.ch/u/alpiq_holding_ag_CH-400.3.923.145-9.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: der Erwerb, der Besitz, die Verwaltung und Nutzung von Investitionen insbesondere in den Bereichen Energie, Strom, Gas und Wärme.',NULL,NULL,'1003',5586,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-05 15:37:52','2024-04-28 10:36:59'),
(560,'SOCAR Energy Switzerland GmbH',NULL,NULL,'CHE-106.847.076',526845,'CH02040219504',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',46,NULL,NULL,'http://www.socarenergy.ch','http://www.moneyhouse.ch/u/socar_energy_switzerland_gmbh_CH-020.4.021.950-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'SOCAR Energy Switzerland ist mit verschiedenen Geschäftsbereichen im Öl- und Gasmarkt tätig: Retail mit über 150 Tankstellen, Vertrieb von flüssigen Brenn- und Treibstoffen für den Grosshandel sowie Flüssiggas für Industrie und Endkonsumenten. SOCAR Energy Switzerland ist ein Unternehmen von SOCAR, der staatlichen Energiegesellschaft der Republik Aserbaidschan.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-05 15:44:02','2024-04-28 10:36:59'),
(561,'Schweizer Forum Elektromobilität',NULL,NULL,NULL,NULL,NULL,0,0,'c/o Mobilitätstsakademie Maulbeerstrasse 10, 3001 Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',26,NULL,NULL,'http://www.forum-elektromobilitaet.ch','-',NULL,NULL,NULL,NULL,NULL,NULL,'Mit dem "Schweizer Forum Elektromobilität" wurde Anfang 2011 ein Kompetenzzentrum für Elektromobilität geschaffen. Dieses soll die Markteinführung begleiten und konkrete Beratungsmassnahmen lancieren. Es geht um die Koordination der verschiedenen Aktivitäten, die zu einer effizienten, nutzerfreundlichen und umweltgerechten Elektrifizierung des Strassenverkehrs in der Schweiz führen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-05 16:47:24','2021-01-03 08:52:54'),
(562,'Fachkommission Gesundheit FDP',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation','nie',3,NULL,NULL,'http://www.fdp.ch/partei/fachkommissionen.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-06 22:31:31','2014-09-16 00:00:00'),
(563,'Yvette Estermann Stiftung',NULL,NULL,'CHE-115.437.470',972206,'CH10077910772',1,1,'Kriens',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',35,NULL,NULL,'http://www.yvette-estermann-stiftung.ch/','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1007791077&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die immerwährende Erhaltung der Schweizerischen Eidgenossenschaft als unabhängiges, neutrales und souveränes Land in der Staatsform der direkten Demokratie, in der Schweiz und gegenüber dem Ausland;\nsie unterstützt sämtliche Bestrebungen, die diesem Zweck dienen oder ihn zu fördern geeignet sind, insbesondere Massnahmen und Aktionen, Veranstaltungen, Vorträge sowie die Organisation von Podien;\ndie Stiftung kann Personen, Institutionen, Organisationen und Firmen auszeichnen, welche sich um den Erhalt der direkten Demokratie oder um die Schweiz -im Sinne des Stiftungszweckes -verdient gemacht haben.',NULL,NULL,'6010',1059,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-04-07 14:21:58','2025-02-13 09:16:34'),
(564,'Neue Heimat Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Kriens',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'MitgliedsOrganisation','nie',35,NULL,NULL,'www.neue-heimat.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Arbeitsgruppe "Neue Heimat" steht für die Schweiz ein und sie orientiert sich an folgenden Grundsätzen: \n\n    Wir stehen für unser Land ein!\n    Wir halten uns an die Regeln und Gesetze des Rechtsstaates\n    Wir setzen uns für eine souveräne und unabhängige Schweiz ein. Ein EU- Beitritt kommt für uns nicht in Frage\n    Wir setzen uns für ein freies Land ein, das die Steuerlast für alle auf einem massvollen Niveau hält\n    Wir setzen uns für eine Schweiz ein, welche die staatlichen, bürokratischen Auflagen auf ein Minimum beschränkt\n    Wir wollen die Eigenverantwortung hoch halten \n    Wir kämpfen dafür, dass jene Ausländer, die sich nicht an unsere Regeln halten, ihr Aufenthaltsrecht verwirken. Dasselbe gilt auch für die Eltern, wenn sie ihre Erziehungsverantwortung nicht wahrnehmen\n    Wir fordern schnellere, härtere Strafen und einen rigorosen Strafvollzug. Strafen müssen eine abschreckende Wirkung haben\n    Wir stehen für eine weltoffene Schweiz, die ihre Beziehungen zu allen Nationen pflegt und ihre wirtschaftlichen Interessen wahrnimmt\n    Wir setzen uns für eine Schweiz ein, welche die dauernde, bewaffnete Neutralität bewahrt. Wenn in einen Konflikt verwickelte Parteien uns darum ersuchen, leistet die Schweiz unparteiisch diplomatische Vermittlungsdienste\n    Wir stehen ein für eine Schweiz, die in schweren Notlagen humanitäre Hilfe leistet',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-29 16:56:23','2014-04-07 14:25:10','2022-06-29 16:56:23'),
(565,'Eidgenössische Kommission für allgemeine Leistungen und Grundsatzfragen','Commission fédérale des prestations générales et des principes','Commissione federale delle prestazioni generali e delle questioni fondamentali',NULL,NULL,NULL,0,0,'Bern','ELGK',NULL,'CFPP',NULL,'CFPF',NULL,191,1,'Ausserparlamentarische Kommission',NULL,NULL,'EinzelOrganisation','punktuell',3,NULL,NULL,'http://www.admin.ch/ch/d/cf/ko/index_10197.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Eidgenössische Kommission für allgemeine Leistungen und Grundsatzfragen berät das Departement bei der Bezeichnung der Leistungen nach Artikel 33, bei der Ausarbeitung der Bestimmungen nach den Artikeln 36 Absatz 1, 77 Absatz 4 und 105 Absatz 4 sowie bei der Beurteilung von Grundsatzfragen in der Krankenversicherung unter Berücksichtigung der ethischen Aspekte bei der Leistungsbezeichnung. \n\nSie hat insbesondere die folgenden Aufgaben: \n\na. Definition von Grundsätzen im Leistungsbereich sowie Beratung und Vorschlag von Verordnungsbestimmungen zu Grundsätzen im Leistungsbereich; \n\nb. Festsetzung von Grundsätzen, damit der Datenschutz und die Interessen der Versicherten bei der Leistungsbezeichnung in der Krankenversicherung gewahrt werden; \n\nc. Ausarbeitung von Kriterien für die Beurteilung von Leistungen nach Artikel 33 Absatz 3 des Gesetzes und Artikel 70.','La Commission fédérale des prestations générales et des questions politiques conseille le Département sur la désignation des prestations selon l''article 33, sur l''évolution des dispositions selon les articles 36, paragraphe 1, 77, paragraphe 4, et 105, paragraphe 4, ainsi que sur l''évaluation des questions fondamentales en matière d''assurance maladie. les aspects éthiques de la description du service.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 00:00:00','2014-04-07 22:57:33','2024-03-10 20:02:21'),
(566,'Kantonales Ethik-Forum St. Gallen',NULL,NULL,NULL,NULL,NULL,0,0,'St. Gallen',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',41,NULL,NULL,'http://www.sg.ch/home/gesundheit/kantonales_ehtik-forum.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Gesundheitsdepartement wählt die Mitglieder des Ethik-Forums sowie den Vorsitzenden. Dem Ethik-Forum sowie den Spitalregionen und den beiden Kantonalen Psychiatrischen Diensten steht dabei ein Vorschlagsrecht zu.\n\nGestützt auf den Postulatsbericht der Regierung "Ethische Beratung in der Gesundheitsversorgung" wurde zur Förderung einer umfassenden ethischen Kultur, speziell in den öffentlichen Institutionen im Gesundheitswesen, das Kantonale Ethik-Forum geschaffen. Das 15-köpfige interdisziplinär zusammengesetzte Gremium besteht aus Fachpersonen der Medizin, Pflege und Sozialarbeit der verschiedenen Spitäler und Kliniken sowie aus Expertinnen und Experten der Ethik, Theologie und Rechtslehre sowie einer Patientenorganisation.\n \nUnter dem Vorsitz von Kantonsarzt Markus Betschart bearbeitet das Kantonale Ethik-Forum allgemein ethische Fragestellungen, welche vor allem spitalverbundsübergreifend das Gesundheitswesen des Kantons St.Gallen in den öffentlichen Spitälern und in den Kantonalen Psychiatrischen Diensten betreffen. Ziel ist es, den Anfragestellenden (einzelne Personen, Gruppen, Organisationen oder Kommissionen im Kanton St.Gallen) Ansätze, die aus ethischer Sicht möglich sind, zur Beantwortung von komplexen Fragestellungen aufzuzeigen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-11 13:25:17','2021-01-03 08:52:54'),
(567,'Kantonale Ethikkommission Zürich, Abteilung A',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Staatlich',NULL,NULL,'EinzelOrganisation','nie',41,NULL,NULL,'http://www.kek.zh.ch/internet/gesundheitsdirektion/kek/de/ueber_uns.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Forschungsprojekte mit Personen, an Verstorbenen, an Embryonen und Föten sowie mit biologischem Material und gesundheitsbezogenen Personendaten zu Krankheiten oder zu Aufbau und Funktion des menschlichen Körpers benötigen vorgängig die Bewilligung einer kantonalen Ethikkommission.\n\nDie KEK Zürich ist gemäss den Richtlinien von Good Clinical Practice (ICH-GCP) und den eidgenössischen Vorgaben der Organisationsverordnung zum Humanforschungsgesetz (OV-HFG) zusammengesetzt. Sie beurteilt Forschungsgesuche aus allen Bereichen der Humanforschung.\n\nDie Abteilung A der KEK hat neben der Beurteilung von Forschungsgesuchen auch den Auftrag, der Gesundheitsdirektion für alle Fragen aus dem Gesundheitswesen beratend zur Verfügung zu stehen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-11 13:35:29','2021-01-03 08:52:54'),
(568,'Concret AG',NULL,NULL,'CHE-107.481.500',317898,'CH03530131310',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',73,NULL,NULL,'http://www.concret-ag.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0353013131&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Das bieten wir\n\nZertifizierung von Qualitätsmanagement-Systemen in Akut-Spitälern, Pflegeheimen, Rehabilitationskliniken und Spitex-Organisationen.\nSchulungen/Fachexpertise\nFür Organisationen, die nicht von Concret AG zertifiziert sind, werden folgende  Dienstleistungen angeboten: Schulung und Praxisberatung von Pflegeteams zu Themen rund um Pflegeprozess / Führen von Pflegedokumentationen. Erstellen von Fachexpertisen auf der Grundlage der Concret Normen©. \nDie Zertifizierungsstelle Concret AG ist akkreditiert durch die Schweizerische Akkreditierungsselle des Staatssekretariats für Wirtschaft SECO (SAS) und damit berechtigt, wirksame Qualitätsmanagementsysteme in der Pflege zu zertifizieren. Grundlage des Zertifizierungsverfahrens bilden die Concret Normen©, welche Struktur,- Prozess- und Ergebnisqualität abbilden und im Sinne eines Mindeststandards ganz oder hinreichend erfüllt sein müssen. Die Concret-Normen© wurden in Zusammenarbeit mit dem Institut für Pflegewissenschaft Basel validiert.\n\nZertifizierung von Qualitätsmanagement-Systemen in Akut-Spitälern, Pflegeheimen, Rehabilitationskliniken und Spitex-Organisationen.',NULL,NULL,'3008',351,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-11 23:11:14','2024-04-28 10:36:59'),
(569,'Rheumaliga Zürich, Zug und Aargau',NULL,NULL,'CHE-105.814.022',1203150,'CH02060019286',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.rheumaliga.ch/zh/Aktuelles',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Im Zentrum aller Bemühungen der Rheumaliga Zürich steht der Mensch mit seinem Bedürfnis nach Wohlbefinden, Beschwerdefreiheit und Lebensqualität. Gesunde Menschen werden durch Prävention und Information in ihren Bemühungen unterstützt, ihre Gesundheit zu erhalten. Menschen mit eingeschränkter Gesundheit lässt die Rheumaliga Zürich durch medizinische, therapeutische, soziale und präventive Massnahmen Hilfe zukommen.',NULL,NULL,'8048',261,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-11 23:27:15','2024-04-28 10:36:59'),
(571,'Physioswiss',NULL,NULL,NULL,NULL,NULL,0,0,'Sursee',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',4,NULL,NULL,'http://www.physio.ch',NULL,NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/physioswiss/',NULL,'Der Schweizer Physiotherapie Verband Physioswiss vertritt die Interessen von rund 12''000 Mitgliedern. Für die Menschen in der Schweiz gestaltet der Verband gemeinsam mit 16 Kantonal- und Regionalverbänden die Zukunft des Gesundheitswesens mit.','Physioswiss, l''Association Suisse de Physiothérapie, représente les intérêts de près de 10 000 membres. Avec ses 16 associations cantonales et régionales, elle contribue à façonner l''avenir du système de santé suisse.',NULL,'6210',NULL,NULL,NULL,NULL,'2024-08-14 17:25:18','2014-04-11 23:42:51','2024-08-14 17:25:18'),
(572,'Palliative Care Netzwerk Zürich/Schaffhausen',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',4,NULL,NULL,'http://www.pallnetz.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Vernetzt\nFachpersonen und Institutionen, die in den Kantonen Zürich und Schaffhausen im Sinne der palliativen Betreuung tätig sind, werden untereinander bekannt gemacht und der gegenseitige Informations- und Erfahrungsaustausch wird gefördert. Übergänge von zu Hause ins Spital, vom Spital ins Pflege- oder Altersheim oder wieder zurück nach Hause gelingen müheloser, wenn sich die Fachleute kennen und zusammenarbeiten.\n\nErreicht wird dies durch regelmässig stattfindende Veranstaltungen, durch die Entwicklung von Arbeitsinstrumenten, welche Sie auf dieser Website herunterladen können, und durch den Aufbau einer themenspezifischen Datenbank.\nFördert\nDamit Menschen am Ort ihrer Wahl gepflegt werden können, braucht es Rahmenbedingungen. Z.B. eine 24h-Beratungshotline für Fachpersonen, Spezialistinnen oder Spezialisten, die in besonders schwierigen Situationen Hilfe vor Ort anbieten oder Menschen, die bereit sind, Nachtwachen zu machen. Hier engagieren wir uns mit politischen Vorstössen, konzeptioneller Arbeit oder dem Aufbau von Spezialangeboten. Ein Konzept zu Koordinations- und Unterstützungsangeboten können Sie unter "Arbeitsinstrumente" herunterladen.\nInformiert\nDie breite Bevölkerung und Fachpersonen des Gesundheitswesens sollen wissen, dass Palliative Care eine umfassende Behandlung und Begleitung bei einer fortschreitenden Krankheit ist. Wünsche und Bedürfnisse der betroffenen Menschen sind zentral und werden ernst genommen. Alle Menschen haben ein Anrecht auf palliative Begleitung und dürfen behandelnde Fachpersonen danach fragen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-11 23:58:46','2021-01-03 08:52:54'),
(573,'Zeitungshaus AG',NULL,NULL,'CHE-115.430.350',971806,'CH27030142780',1,1,'Baar',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',48,NULL,NULL,NULL,'http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2703014278&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Herausgebergesellschaft der Basler Zeitung; Im Handelsregister ist der Zweck allerdings sehr allgemein gefasst:\nDie Gesellschaft bezweckt Erwerb, Halten und Verwaltung von Beteiligung an und Finanzierung von Unternehmen im In-und Ausland. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im ln- und Ausland errichten und sich an anderen Unternehmen im In- und Ausland beteiligen sowie alle Geschäfte tätigen, die direkt oder indirekt mit ihrem Zweck in Zusammenhang stehen. Die Gesellschaft kann im In- und Ausland Grundeigentum erwerben, belasten, veräussern und verwalten. Sie kann auch Darlehen und Finanzierungen für eigene oder fremde Rechnung vornehmen sowie Garantien und Bürgschaften für Tochtergesellschaften und Dritte eingehen.',NULL,NULL,'6340',1701,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-12 07:50:27','2024-04-28 10:36:59'),
(575,'Departement Gesundheit der Zürcher Hochschule für Angewandte Wissenschaften',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur','ZHAW Gesundheit',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',41,NULL,NULL,'http://www.gesundheit.zhaw.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Departement Gesundheit der ZHAW hat sich zum Ziel gesetzt, auf hohem wissenschaftlichem Niveau Bachelor- und Masterstudiengänge, angewandte Forschung und Entwicklungsowie Weiterbildungen und Dienstleistungen anzubieten, und damit in der Schweiz Spitzenleistungenauf europäischem Niveau zu erbringen. Obschon dieses strategische Ziel von der Schulleitung der ZHAW grundsätzlich unterstützt wird, ist die Realisierung schwierig und mit Risiken behaftet. Die grösste Schwierigkeit besteht darin, die hoch gesteckten Ziele trotz der beschränkten finanziellen Mittel seitens Kanton Zürich und Bund erreichen zu können.','Le département Santé de la ZHAW s''est fixé pour objectif de proposer des cursus de bachelor et de master, de la recherche appliquée et du développement ainsi que des formations continues et des services de haut niveau scientifique, et de fournir ainsi en Suisse des prestations de pointe au niveau européen. Bien que cet objectif stratégique soit en principe soutenu par la direction de la ZHAW, sa réalisation est difficile et comporte des risques. La plus grande difficulté consiste à atteindre les objectifs ambitieux malgré les moyens financiers limités du canton de Zurich et de la Confédération.',NULL,NULL,NULL,NULL,NULL,NULL,'2024-05-16 17:14:32','2014-04-12 17:07:04','2024-05-16 17:14:32'),
(576,'Pro Natura - Schweizerischer Bund für Naturschutz',NULL,NULL,'CHE-105.825.132',398287,'CH27060003884',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,NULL,NULL,'http://www.pronatura.ch/','http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2706000388&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0','pronaturach','pro_natura_de','ProNaturaVideo','pronatura/','https://www.linkedin.com/company/pro-natura-%E2%80%93-f%C3%BCr-mehr-natur-%C3%BCberall-/?originalSubdomain=de',NULL,'Pro Natura ist die führende Organisation für Naturschutz in der Schweiz. Als Anwältin und Meinungsmacherin für Naturschutz verteidigt sie engagiert und kompetent die Interessen der Natur und setzt sich für die Förderung und den Erhalt der einheimischen Tier- und Pflanzenwelt ein. Zu den Pioniertaten der 1909 gegründeten Organisation gehört die Schaffung des Schweizerischen Nationalparks. Heute betreut Pro Natura über 600 Naturschutzgebiete und ein Dutzend Naturschutzzentren in der ganzen Schweiz. Mit ihren Sektionen ist Pro Natura in allen Kantonen der Schweiz aktiv.\nAls privater, gemeinnütziger Verein ist Pro Natura auf Mitgliederbeiträge und Spenden angewiesen. Pro Natura zählt über 100''000 Mitglieder sowie rund 30''000 treue Gönnerinnen und Gönner. Pro Natura ist ZEWO-zertifiziert.','Pro Natura est l''organisation phare en matière de protection de la nature en Suisse. Elle met toutes ses compétences en œuvre pour défendre les intérêts de la nature. Elle s''engage avec détermination et d''une manière conséquente pour la sauvegarde et la conservation de la faune et de la flore indigènes. La création du Parc national suisse fait partie des réalisations pionnières de l''organisation fondée en 1909. Aujourd''hui, Pro Natura gère plus de 600 réserves naturelles et une douzaine de centres nature dans toute la Suisse. Pro Natura est active avec ses sections dans tous les cantons suisses.',NULL,'4053',2701,NULL,NULL,NULL,'2025-10-28 08:52:32','2014-04-12 17:24:00','2025-10-28 08:52:32'),
(577,'Pflege','Soins',NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',73,NULL,NULL,'http://spitex.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Durch Spitex Schweiz, ARTISET/CURAVIVA, Association Spitex privée Suisse ASPS, Schweizer Berufsverband für Pflegefachfrauen und Pflegefachmänner SBK-ASI und senesuisse Förderung aller Bereich der Pflege (Spitäler, Heime, ambulante Pflege, Spitex)Förderung der Pflege in politischer, rechtlicher und gesellschaftlicher HinsichtKontakte mit den Pflegenden und deren BerufsorganisationenOrganisation Info-Veranstaltungen über die Pflege für Parlamentarier/innen und die ÖffentlichkeitAufbau eines Netzwerkes innerhalb des GesundheitswesensKontakte mit Behörden und VerwaltungenKontakte mit Ausbildungsinstitutionen sowie Lehre und Forschung',NULL,'Patrick Imhof\nSekretär/in\n+41 31 381 22 81\nparlgruppepflege@spitex.ch\nSpitex Schweiz\nEffingerstrasse 33\n3008 Bern 13\nSCHWEIZ\nDominique Wilhelm\nSekretär/in\n+41 31 381 22 81\nparlgruppepflege@spitex.ch\nSpitex Schweiz\nEffingerstrasse 33\n3008 Bern',NULL,NULL,NULL,NULL,'2025-04-28 18:54:53','2025-08-29 13:55:57','2014-04-12 18:14:08','2025-08-29 13:55:57'),
(578,'Klinik Villa im Park AG',NULL,NULL,'CHE-107.893.073',427809,'CH40039041348',1,1,'Rothrist',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'https://www.villaimpark.ch/de/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Verwaltung und Führung einer Privatklinik; die Gesellschaft kann sich bei anderen Unternehmungen des In- und Auslandes beteiligen sowie Liegenschaften, Patente, Lizenzen etc. erwerben, veräussern und verwalten.	\n\nDie Klinik Villa im Park ist eine im Mittelland regional verankerte Belegarztklinik mit den Fachrichtungen Chirurgie und Geburtshilfe, welche über rund 40 Betten verfügt.\n\nGELÖSCHT AM 2.7.18',NULL,NULL,'4852',4282,NULL,NULL,NULL,'2019-09-04 13:30:36','2014-04-12 18:53:33','2024-04-28 10:36:59'),
(579,'Association romande et tessinoise des institutions d''action sociale',NULL,NULL,NULL,NULL,NULL,0,0,'Yverdon-les-bains','Artias',NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,dezidierteLobby','punktuell',12,NULL,NULL,'http://www.artias.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'L''ARTIAS est un organisme regroupant les secteurs public et privé, qui contribue au développement, en Suisse romande et au Tessin, d''une action sociale basée sur la promotion de l''information, de la solidarité et de la lutte contre l''exclusion, ainsi qu''au renforcement des liens avec les institutions sociales suisses, en particulier avec celles de langue allemande.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-07-14 00:00:00','2014-04-12 21:33:02','2025-07-14 10:44:47'),
(580,'VCS Verkehrs-Club der Schweiz','ATE Association transports et environnement','ATA Associazione traffico e ambiente','CHE-105.871.764',200360,'CH05360063312',1,1,'Bern','VCS',NULL,'ATE',NULL,'ATA',NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',33,NULL,NULL,'https://www.vcs-ate.ch',NULL,'verkehrsclub',NULL,'vcsverkehrs-clubderschweiz6937','verkehrsclub.ch/','https://www.linkedin.com/company/vcs-verkehrs-club-der-schweiz?originalSubdomain=ch',NULL,'Der VCS Verkehrs-Club der Schweiz setzt sich seit 1979 für eine menschen- und umweltgerechte Mobilität ein. Er engagiert sich für eine nachhaltige Verkehrspolitik.','L''ATE Association transports et environnement s''engage depuis 1979 pour une mobilité respectueuse de l''homme et de l''environnement. Elle s''engage pour une politique des transports durable.',NULL,'3011',351,NULL,NULL,NULL,'2025-09-08 20:23:28','2014-04-12 23:19:45','2025-09-08 20:23:28'),
(581,'Grüne Partei der Schweiz (Grüne)','Les Vert-e-s - Parti écologiste suisse',NULL,'CHE-110.394.971',319746,'CH55001739902',1,1,'Bern','GPS','Grüne Schweiz',NULL,'Les Verts - Parti écologiste suisse',NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','immer',20,93,NULL,'http://www.gruene.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Grüne Partei der Schweiz will zum Aufbau einer demokratischen, dezentralen, föderalistischen und solidarischen Gesellschaft beitragen, welche im Einklang mit der Natur und in Frieden mit allen Völkern lebt. Deshalb räumt sie der langfristigen Erhaltung unserer Lebensgrundlagen Priorität ein.','Le Parti écologiste suisse veut contribuer à la construction d''une société démocratique, décentralisée, fédéraliste et solidaire, qui vit en harmonie avec la nature et en paix avec tous les peuples. C''est pourquoi il accorde la priorité à la préservation à long terme de nos ressources vitales.',NULL,'3011',351,NULL,NULL,NULL,'2025-09-25 21:15:48','2014-04-12 23:24:16','2025-09-25 21:15:48'),
(582,'Kanton Waadt','Etat de Vaud',NULL,NULL,NULL,NULL,0,0,'Lausanne','VD',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','immer',13,NULL,NULL,'http://www.vd.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-09-11 15:18:22','2014-04-12 23:27:36','2025-09-11 15:18:22'),
(583,'Stiftung Landschaftsschutz Schweiz','FP Fondation suisse pour la protection et l''aménagement du paysage',NULL,'CHE-107.818.427',469731,'CH03570159494',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,dezidierteLobby','punktuell',54,NULL,NULL,'https://www.sl-fp.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357015949&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/stiftung-landschaftsschutz-schweiz/',NULL,'Die Stiftung Landschaftsschutz Schweiz SL strebt die Erhaltung, Pflege und Aufwertung der schützenswerten Landschaft in der Schweiz an. Sie verfolgt dieses Ziel, in dem sie die natürlichen und kulturellen Werte der Landschaft sichert, fördert und wiederherstellt.','La Fondation pour la protection du paysage suisse SL a pour objectif la préservation, l''entretien et la valorisation des paysages dignes d''être protégés en Suisse. Elle poursuit cet objectif en préservant, en promouvant et en restaurant les valeurs naturelles et culturelles du paysage.',NULL,'3007',351,NULL,NULL,NULL,'2025-10-02 08:56:46','2014-04-12 23:43:57','2025-10-02 08:56:46'),
(584,'FFU FachFrauen Umwelt PEE Professionnelles En Environnement','Professionelles en environnement',NULL,'CHE-163.209.718',NULL,NULL,0,1,'Liestal','FFU',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,dezidierteLobby','punktuell',93,67,NULL,'http://www.ffu-pee.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die FachFrauen Umwelt ffu-pee vertreten die Interessen der Frauen, die sich beruflich mit Umweltfragen befassen. Im Umweltbereich tätige Frauen aus der ganzen Schweiz haben den Verein im Mai 1989 gegründet. Heute zählen die ffu-pee über 1000 Mitglieder. Sie arbeiten in Öko- und Planungsbüros, im eigenen Betrieb, in Umweltorganisationen, in der Verwaltung, an Forschungsinstituten und an Hochschulen oder absolvieren eine Ausbildung im Umweltbereich.',NULL,NULL,'4410',2829,NULL,NULL,NULL,'2025-06-21 13:34:33','2014-04-12 23:52:05','2025-06-21 13:34:33'),
(585,'sanu durabilitas - Schweizerische Stiftung für Nachhaltige Entwicklung','sanu durabilitas Fondation Suisse pour le Développement Durable',NULL,'CHE-101.292.254',284164,'CH03570169067',1,1,'Biel/Bienne','Durabilitas',NULL,'Durabilitas',NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','punktuell',54,NULL,NULL,'https://www.sanu.ch','http://www.moneyhouse.ch/u/sanu_durabilitas__schweizerische_stiftung_fur_nachhaltige_entwicklung_CH-035.7.016.906-7.htm',NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/durabilitas/',NULL,'Durabilitas zeigt als Denkwerkstatt in Zusammenarbeit mit Personen aus der Praxis und mit Bildungsinstitutionen wichtige und aktuelle Themen und Herausforderungen für eine nachhaltige Entwicklung der Schweiz auf. Sie erarbeitet, beurteilt und kommuniziert Lösungskonzepte zu den identifizierten Herausforderungen und gibt neue Impulse für Aus- und Weiterbildungsangebote im Natur-, Landschafts- und Umweltschutz sowie der nachhaltigen Entwicklung generell.','En tant que laboratoire d''idées, Durabilitas met en évidence, en collaboration avec des praticiens et des établissements d''enseignement, les thèmes et les défis importants et actuels pour le développement durable de la Suisse. Elle élabore, évalue et communique des solutions aux défis identifiés et donne de nouvelles impulsions pour les offres de formation initiale et continue dans les domaines de la protection de la nature, du paysage et de l''environnement, ainsi que du développement durable en général.',NULL,'2502',371,NULL,NULL,NULL,'2025-09-02 15:22:04','2014-04-13 00:02:15','2025-09-02 15:22:04'),
(586,'Fondation du foyer d''accueil Le Christ-Roi','Fondation du foyer d''accueil Le Christ-Roi',NULL,'CHE-108.032.955',272828,'CH62670028118',1,1,'Lens',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',79,NULL,NULL,NULL,'http://vs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=6267002811&amt=626&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb eines Altersheims\nExploitation d''un foyer d''accueil pour personnes âgées dans des locaux mis à disposition par les communes de Lens et d''Icogne. La fondation développera son but en priorité pour les ressortissants des communes fondatrices. Elle exercera également son activité auprès des personnes indigentes ou de condition modeste',NULL,NULL,'1978',6240,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-13 14:38:20','2024-04-28 10:36:59'),
(588,'Gebäudeversicherung Bern (GVB)','Assurance immobilière Berne (AIB)',NULL,'CHE-108.954.056',503287,'CH03580249055',1,1,'Ittigen','GVB','GVB Bern',NULL,NULL,NULL,NULL,191,1,'Oeffentlich-rechtlich','0117',8,'EinzelOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'http://www.gvb.ch/de.html','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0358024905&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,'gebaudeversicherungbern','gvbbern','https://www.linkedin.com/company/gebaeudeversicherung-bern/',NULL,'Die GVB versichert die Gebäude im Kantonsgebiet, sorgt für die Wahrung der Brandsicherheit und die Prävention von Feuer- und Elementarschäden gemäss dem Feuerschutz- und Feuerwehrgesetz und übernimmt weitere, ihr von der Gesetzgebung übertragene Aufgaben. Bietet im Rahmen des gesetzlichen Handlungsspielraumes eine marktgerechte Versicherungsdeckung zu möglichst günstigen Bedingungen an und richtet ihre Dienstleistungen an den allgemeinen Erwartungen der Hauseigentümerinnen und Hauseigentümer aus.','L''AIB assure les bâtiments situés sur le territoire cantonal, veille au maintien de la sécurité incendie et à la prévention des dommages dus au feu et aux éléments naturels conformément à la loi sur la protection contre le feu et sur les sapeurs-pompiers et assume d''autres tâches qui lui sont confiées par la législation. Dans le cadre de la marge de manœuvre légale, elle offre une couverture d''assurance conforme au marché, aux conditions les plus avantageuses possibles, et oriente ses prestations en fonction des attentes générales des propriétaires immobiliers.',NULL,'3063',362,NULL,NULL,NULL,'2020-03-07 10:47:23','2014-04-14 15:24:14','2024-10-28 09:32:56'),
(589,'Verband Holzindustrie Schweiz HIS','Industrie du bois Suisse',NULL,'CHE-105.832.014',166246,'CH03550146656',1,1,'Bern','HIS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',135,NULL,NULL,'http://www.holz-bois.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0355014665&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Unternehmen und Berufsangehörgen der Holzindustrie zur Wahrung der gemeinsamen Interessen zusammenzuschliessen; Erhaltung der selbständigen Unternehmungen; Förderung einer dynamischen Wirtschafts-, Konjunktur-, Finanz- und Sozialpolitik; Förderung der Holzverwendung; Förderung der beruflichen Aus- und Weiterbildung; Regelung der Lohn- und Arbeitsverhältnisse; Vertiefung der Kollegialität und Zusammenarbeit im Mitgliederkreis; Vertretung der Berufsinteressen der Mitglieder nach aussen; Unterstützung bei der Erfüllung regionaler Anliegen und Bedürfnisse; Verwirklichung des Verbandszweckes durch andere geeignete Tätigkeiten und Massnahmen, in Anpassung an die wechselnden Verhältnisse und Bedürfnisse.',NULL,NULL,'3005',351,NULL,NULL,NULL,'2015-03-21 00:00:00','2014-04-14 15:55:10','2024-04-28 10:36:59'),
(590,'JagdSchweiz','Chasse Suisse','Caccia Svizzera','CHE-432.917.666',1606079,'CH40064536088',1,1,'Zofingen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,NULL,NULL,'https://www.jagdschweiz.ch/',NULL,'JagdSchweiz',NULL,NULL,'JagdSchweizChasseSuisseCacciaSvizzeraCatschaSvizra/',NULL,NULL,'Der Zweck des Verbands besteht in der Erhaltung und Förderung einer zeitgemässen Jagd in der Schweiz. Der Verband hat folgende Aufgaben: Förderung und Erhaltung der freilebenden Tierwelt und ihrer Lebensräume, Vertretung der Interessen der Schweizer Jägerschaft im In- und Ausland, Erhaltung und Fortbestand einer weidgerechten und nachhaltigen Jagd, unter Wahrung und Förderung der Interessen aller Jäger/innen und unter Berücksichtigung der bestehenden Jagdsysteme, der unterschiedlichen Jagdarten sowie der kulturellen und landschaftlichen Vielfalt in der Schweiz, Unterstützung der Mitglieder, Sicherstellung einer nationalen Öffentlichkeitsarbeit sowie Zusammenarbeit mit zielverwandten Organisationen.','Le but de la fédération est de préserver et de promouvoir une chasse moderne en Suisse. La fédération a les tâches suivantes : Promouvoir et préserver la faune sauvage et ses habitats, représenter les intérêts des chasseurs suisses en Suisse et à l''étranger, maintenir et pérenniser une chasse durable et respectueuse du gibier, en préservant et promouvant les intérêts de tous les chasseurs et en tenant compte des systèmes de chasse existants, des différents types de chasse ainsi que de la diversité culturelle et paysagère en Suisse, soutenir ses membres, assurer un travail de relations publiques au niveau national et collaborer avec des organisations poursuivant des buts similaires.',NULL,'4800',4289,NULL,NULL,NULL,'2023-09-29 16:22:34','2014-04-14 16:00:57','2024-04-28 10:36:59'),
(591,'Verein Schweizer Armeemuseum',NULL,NULL,NULL,NULL,NULL,0,0,'Thun',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',21,NULL,NULL,'http://www.armeemuseum.ch/index.php?id=1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein Schweizer Armeemuseum ist ein Kompetenzzentrum für die Geschichte des Schweizer Wehrwesens. Er setzt sich insbesondere die Errichtung eines schweizerischen Armeemuseums ein. Er fördert die Tätigkeit der von ihm gegründeten Stiftung Historisches Material der Schweizer Armee. Grundlegend für die Erreichung seiner Ziele ist die Erhaltung und Pflege des historischen Materials der Schweizer Armee ein, eines schützenswerten Kulturgutes.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-14 16:06:53','2014-09-16 00:00:00'),
(592,'Schweizerischer Bäcker-Confiseurmeister-Verband','Association suisse des patrons boulangers-confiseurs',NULL,'CHE-101.558.682',218445,'CH03560174130',1,1,'Bern','SBC','Swissbaker; Schweizer Bäcker-Confiseure',NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',38,NULL,NULL,'http://www.swissbaker.ch',NULL,NULL,'swissbaker.ch','swissbaker99','swissbaker.ch','https://www.linkedin.com/company/swissbaker/',NULL,'Der Schweizerische Bäcker-Confiseurmeister-Verband (SBC) mit Sitz in Bern ist die Berufsorganisation der Arbeitgeber der gewerblichen Bäckereien-Confiserien schweizweit. Der SBC vertritt deren Interessen und setzt sich für bestmögliche politische, wirtschaftliche und rechtliche Rahmenbedingungen ein. Er tritt für eine freie Marktwirtschaft mit sozialer und ökologischer Verantwortung ein.','L''Association suisse des patrons boulangers-confiseurs (ASPBC), dont le siège est à Berne, est l''organisation professionnelle des employeurs des boulangeries-confiseries artisanales dans toute la Suisse. Le SBC défend leurs intérêts et s''engage pour les meilleures conditions politiques, économiques et juridiques possibles. Il s''engage pour une économie de marché libre avec une responsabilité sociale et écologique.',NULL,'3011',351,NULL,NULL,NULL,'2022-09-19 00:00:00','2014-04-14 16:17:08','2024-10-29 11:36:56'),
(593,'Schweizerischer Landmaschinen-Verband SLV',NULL,NULL,'CHE-104.034.487',NULL,NULL,0,0,'Bern','SLV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',124,NULL,NULL,'http://www.slv-asma.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Schweizerische Landmaschinen-Verband (SLV) ist der Branchenverband von schweizerischen Firmen, die sich mit Landmaschinen befassen.\n\nEr vereinigt ca. 200 Mitglieder, die sich aus Herstellern, Importeuren und Händlern zusammensetzen.\n\nHauptanliegen des SLV sind die langfristig gesicherte Versorgung der Landwirtschaft mit geeigneten Mechanisierungslösungen, guten Service- und Reparaturleistungen sowie Ersatzteilen zu vertretbaren Kosten.\n\nIm Sinne dieser Branchen-Ziele bemüht sich der SLV um einen fairen Wettbewerb unter seinen Mitgliedern und um Transparenz des Angebotes gegenüber der Kundschaft, den Landwirten.\n\nDer SLV vertritt die Interessen der Landmaschinenbranche bei schweizerischen Behörden, Institutionen, befreundeten und benachbarten Organisationen.\n\nDie Organisation und Durchführung der schweizerischen Landmaschinenschau AGRAMA im Milizsystem ist ein Beispiel der vielen vorteilhaften Dienstleistungen, die der SLV seinen Mitgliedern und der Kundschaft bietet.',NULL,NULL,'3005',351,NULL,NULL,NULL,'2016-09-06 14:40:59','2014-04-14 16:21:32','2022-09-25 22:33:13'),
(594,'Securitas AG Schweizerische Bewachungsgesellschaft','Securitas SA Société Suisse de Surveillance','Securitas SA Società svizzera di vigilanza','CHE-106.832.531',167148,'CH03530011164',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',72,NULL,NULL,'http://www.securitas.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0353001116&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Organisation von Bewachungsdiensten',NULL,NULL,'3011',351,NULL,NULL,NULL,'2025-06-18 18:13:10','2014-04-14 16:30:16','2025-06-18 18:13:10'),
(595,'Spiritsuisse',NULL,NULL,NULL,NULL,NULL,0,0,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',82,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Vormals Schweizerische Vereinigung der Markenspirituosen (SVM) \n\nSPIRITSUISSE ist der Verein[1]  der wichtigsten Produzenten und Verkäufer von Qualitätsspirituosen in der Schweiz. Er vertritt 58% der in der Schweiz kommerzialisierten Spirituosen und umfasst zehn grosse einheimische Firmen und Schweizer Filialen von internationalen Unternehmen.\n\nDie Mitglieder:\nhttp://www.spiritsuisse.ch/die-assoziation/die-mitglieder/?lang=de',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-09-01 18:12:00','2014-04-14 16:36:09','2021-01-03 08:52:54'),
(596,'Association Spitex privée Suisse (ASPS)','Association Spitex privée Suisse',NULL,'CHE-112.619.980',807454,'CH03560355752',1,1,'Bern','ASPS',NULL,'ASPS',NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',7,NULL,NULL,'http://spitexpriveesuisse.ch/de/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356035575&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Dachverband privater Spitex-Organisationen\nDie ASPS wurde im 2005 von privaten Spitex-Organisationen gegründet. Alle Mitglieder sind in der Schweiz von den Krankenkassen anerkannte und zugelassene Spitex-Anbieter.\n\n    Die ASPS fördert die individuelle Hilfe, Betreuung und Pflege zu Hause (Spitex). Sie setzt sich dafür ein, dass die Versorgung der Bevölkerung durch Spitex-Dienstleistungen zu einer tragenden Säule des Gesundheits- und Sozialwesens wird. Spitex soll als echte Alternative zum Heim weiterentwickelt und gefördert werden.\n    Die ASPS trägt, als Ergänzung zu den öffentlichen Spitex-Organisationen, zur Aufwertung und Gleichbehandlung der privaten Spitex-Organisationen auf gesellschaftlicher, wirtschaftlicher, privater und politischer Ebene bei.',NULL,NULL,'3013',351,NULL,NULL,NULL,'2025-08-20 20:54:33','2014-04-14 23:24:45','2025-08-20 20:54:34'),
(597,'Vermeiren (Svizzera) SA',NULL,NULL,'CHE-101.580.500',301057,'CH51430065586',1,1,'Lugano',NULL,NULL,NULL,NULL,NULL,NULL,191,5,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',9,NULL,NULL,'http://www.gribi.ch/ve/de/firma.asp','http://ti.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=5143006558&amt=501&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Wir wollen ein führendes Unternehmen im Bereich Rollstühle in der Schweiz werden. Dank einem gut ausgebauten Lager und dank der Vorratshaltung der wichtigsten Ersatzteile wollen wir dem interessierten Fachhandel einen optimalen Service bieten. \n\n\nWir beliefern nur Wiederverkäufer und institutionelle Organisationen in der Schweiz\n\nWir unterstützen den Fachhandel mit Schulungen, Werbematerial und mit einem raschen Lieferservice. Wir bieten qualitativ hoch stehendes Material zu einem preiswerten Endverkaufspreis. Wir gewähren auf den Rahmen der Vermeiren-Rollstühle 5 Jahre Bruchgarantie.',NULL,NULL,'6900',5192,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-14 23:37:14','2024-04-28 10:36:59'),
(598,'Schweizer Zucker AG','Sucre Suisse SA','Zucchero Svizzero SA','CHE-105.928.559',398384,'CH44030012581',1,1,'Frauenfeld',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','punktuell',38,NULL,NULL,'http://www.zucker.ch/','http://tg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4403001258&amt=440&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Vormals Zuckerfabriken Aarberg + Frauenfeld AG\n\nDie Schweizer Zucker AG (SZU) verarbeitet als einziges Unternehmen in der Schweiz Zuckerrüben und versorgt den Schweizer Markt mit Zucker und den anfallenden Futtermitteln. Der SZU kommt dadurch hinsichtlich Menge, Qualität und Lieferbereitschaft eine marktführende Position zu.','La SA des Sucre Suisses est la seule entreprise en Suisse qui transforme des betteraves sucrières, approvisionne le pays en sucre et en fourrages issus des sous-produits. La SUS occupe donc une position dominante sur le marché, ceci sur le plan de la quantité, de la qualité et de la disponibilité. Une extension des activités dans des secteurs apparentés est recherchée.',NULL,'8502',4566,NULL,NULL,NULL,'2025-04-17 14:00:51','2014-04-14 23:42:28','2025-04-17 14:00:51'),
(599,'GastroSuisse',NULL,NULL,'CHE-107.820.275',426799,'CH02069004476',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',60,NULL,NULL,'https://www.gastrosuisse.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Grösster Arbeitgeberverband der Schweizer Gastronomie und Hotellerie','La plus grande association patronale de la gastronomie et de l''hôtellerie suisses',NULL,'8046',261,NULL,NULL,NULL,'2025-03-19 16:33:59','2014-04-14 23:57:43','2025-03-19 16:33:59'),
(600,'Medizinische Fakultät der Universität Bern',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',41,NULL,NULL,'http://www.medizin.unibe.ch/content/index_ger.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-05 18:25:12','2014-04-15 00:04:22','2022-10-05 18:25:12'),
(601,'Informationsgruppe Erfrischungsgetränke','Groupe d''information Boissons rafraîchissantes',NULL,NULL,NULL,NULL,0,0,'Zürich','IGEG','IG Erfrischungsgetränke','GIBR',NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',38,NULL,NULL,'https://ig-erfrischungsgetraenke.ch/',NULL,'info_IGEG',NULL,NULL,NULL,NULL,NULL,'Der Zusammenschluss von Vertretern der Erfrischungsgetränkeproduzenten und der nationalen Politik dient der aktiven und transparenten Beteiligung an der politischen und gesellschaftlichen Debatte rund um Ernährung, Gesundheit sowie der Förderung eines aktiven Lebensstils. Lanciert jährlich eine GFS-Umfrage zum Thema Zuckersteuer.','En s''unissant, les représen­tants des pro­duc­teurs de bois­sons rafraîchissan­tes et les per­son­nal­ités poli­tiques par­ticipent de manière active et trans­par­ente au débat poli­tique et social sur l''alimentation, la san­té et la pro­mo­tion d''un style de vie act­if.',NULL,'8027',NULL,NULL,NULL,NULL,'2025-07-15 00:00:00','2014-04-15 00:09:36','2025-07-15 15:48:18'),
(602,'WWF Schweiz','WWF Suisse','WWF Svizzera','CHE-106.092.857',326592,'CH02079051957',1,1,'Zürich','WWF',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,131,NULL,'http://www.wwf.ch','http://www.moneyhouse.ch/u/wwf_schweiz_CH-020.7.905.195-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung unterstützt in der Schweiz und im Fürstentum Liechtenstein die Stiftung WWF - World Wide Fund for Nature (vormals World Wildlife Fund), in Gland, für die weltweite Erhaltung der natürlichen Umwelt und ihrer verschiedenen Erscheinungsformen. Sie setzt alle angemessenen Instrumente ein, um mit bestmöglicher Wirkung ihren Zweck zu erreichen. Die Stiftung unterstützt zweckdienliche Programme und Projekte im In- und Ausland, finanziert ihre Tätigkeit zweckverträglich und nützt ihre finanziellen Mittel effizient.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2025-09-18 13:53:32','2014-04-16 12:12:22','2025-09-18 13:53:32'),
(603,'WWF - WORLD WIDE FUND FOR NATURE (formerly World Wildlife Fund)',NULL,NULL,'CHE-107.971.916',210837,'CH55001289207',1,1,'Gland','WWF',NULL,NULL,NULL,NULL,NULL,191,4,'Stiftung','0110',7,'DachOrganisation,dezidierteLobby','nie',54,NULL,NULL,'www.wwf.org','http://www.moneyhouse.ch/u/wwf__world_wide_fund_for_nature_%28formerly_world_wildlife_fund%29_CH-550.0.128.920-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'réunir, gérer et engager des fonds pour la conservation de l''environnement naturel de l''humanité à l''échelle mondiale, soit de la faune, de la flore, des forêts, des paysages, de l''eau, du sol et d''autres ressources naturelles.',NULL,NULL,'1196',5721,NULL,NULL,NULL,'2025-07-01 17:59:15','2014-04-16 12:15:11','2025-07-01 17:59:15'),
(604,'Casafair Schweiz','habitatdurable',NULL,'CHE-233.920.658',NULL,NULL,0,0,'Bern',NULL,'casa fair',NULL,'Habitat Durable',NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',19,NULL,NULL,'https://casafair.ch/',NULL,'VerbandCasafair',NULL,NULL,'VerbandCasafair','https://www.linkedin.com/company/casafair/',NULL,'Casafair ist der Verband für umweltbewusste und faire Wohneigentümer*innen. Er setzt sich für klimafreundliches Bauen, gesundes Wohnen, haushälterische Bodennutzung und faire Miet- und Nachbarschaftsverhältnisse ein.','Casafair est l''association des propriétaires de logements respectueux de l''environnement et équitables. Elle s''engage pour une construction respectueuse du climat, un habitat sain, une utilisation mesurée du sol et des rapports de location et de voisinage équitables.',NULL,'3011',351,NULL,NULL,NULL,'2025-07-12 17:01:38','2014-04-16 12:36:19','2025-07-12 17:01:38'),
(605,'Gastgeber-Akademie Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'DachOrganisation,LeistungsErbringer','nie',60,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Gastgeber Akademie ist eine Plattform von Unternehmen in der Hotellerie. Nebst den Hotels von Best Western gehören unter anderem auch die Ambassador Swiss Hotels dazu. Insgesamt sollen rund 200 Schweizer Betriebe Zugang zur Akademie haben. Ab 2014 will sich die Akademie auch für aussenstehende Gaststätten öffnen.\n\nDie Kosten belaufen sich in drei Jahren auf rund 800''000 Franken. Finanziell getragen wird das Projekt nebst den Hotelpartnern auch vom Staatssekretariat für Wirtschaft (Seco) über das Förderprogramm Innotour.\n\nMitglieder ua: Best Western, Ambassador Swiss Hotels\n\nsiehe: http://www.blick.ch/news/wirtschaft/schweizer-hoteliers-gruenden-akademie-fuer-mehr-gastfreundschaft-id2220857.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-03-27 13:11:13','2014-04-16 13:05:23','2021-01-03 08:52:54'),
(606,'BEST WESTERN SWISS HOTELS Genossenschaft in Liquidation',NULL,NULL,'CHE-107.882.402',9623,'CH03550002907',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,DachOrganisation','nie',60,NULL,NULL,'http://www.bestwestern.ch/','http://www.moneyhouse.ch/u/best_western_swiss_hotels_CH-035.5.000.290-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Engere Zusammenarbeit der Genossenschafter in verschiedenen Sachbereichen, vor allem im Bereich Hotel-Marketing.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-16 14:44:23','2024-04-28 10:36:59'),
(607,'GENOSSENSCHAFT AMBASSADOR SWISS HOTELS',NULL,NULL,'CHE-113.002.090',841550,'CH03550362923',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer','nie',60,NULL,NULL,'http://ash-hotels.ch/deutsch/','http://www.moneyhouse.ch/u/ambassador_swiss_hotels_genossenschaft_CH-035.5.036.292-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Genossenschaft Ambassador Swiss Hotels (ASH) wurde 2006 gegründet und besteht momentan aus 65 Mitgliedern. Unser Ziel ist es, für die Genossenschafter Vorteile und zusätzliche Einsparungen ("Economies of Scale") zu realisieren.',NULL,NULL,'3006',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-16 14:48:52','2024-04-28 10:36:59'),
(608,'Fondation Suisse Bellevue',NULL,NULL,'CHE-108.753.061',296864,'CH64510017450',1,1,'Neuchâtel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/schweizerische_stiftung_bellevue_CH-645.1.001.745-0.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Erstellung und Verwaltung von Häusern für die Aufnahme, Beobachtung, Behandlung, Rehabilitation, Berufsberatung, Berufsausbildung, Stellenvermittlung, Nachsorge von Jugendlichen (e) s intelligente (n) erreicht (e) von Verhaltens-Täter (n), Drogenabhängige oder nicht.',NULL,NULL,'2000',6458,NULL,NULL,NULL,'2019-09-12 15:53:22','2014-04-16 15:01:01','2024-04-28 10:36:59'),
(609,'Projektgruppe Dombresson der Fondation Suisse Bellevue',NULL,NULL,NULL,NULL,NULL,0,0,'Neuchâtel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-16 15:04:03','2017-10-30 08:09:12'),
(610,'Universitätsspital Zürich',NULL,NULL,'CHE-108.904.325',NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Oeffentlich-rechtlich','0234',NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'http://www.usz.ch/Seiten/default.aspx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,261,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-16 15:24:38','2022-09-25 22:33:13'),
(611,'Förderverein ProPapiliorama','Amis du papiliorama',NULL,NULL,NULL,NULL,0,0,'Kerzers',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation','nie',54,NULL,NULL,'http://www.propapiliorama.ch/index.php/fr/accueil',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Förderverein "ProPapiliorama" wurde im Jahr 2003 gegründet und ist ein von der Stiftung Papiliorama unabhängiger Verein. Hauptziel des Vereins ist die Unterstützung des Papilioramas bei der Finanzierung von Anschaffungen und Neubauten, bei speziellen Anlässen und bei der Vermittlung von Patenschaften.','L''association de soutien "Amis du papiliorama" ou plus brièvement association de soutien est une association au sens des art. 60ss. du code civil suisse (CC) distincte et indépendante de la fondation Papiliorama. Elle a son siège à Chiètres.\nL''association est politiquement et religieusement neutre. Elle est créée en 2003.\n \nElle soutient le papiliorama de Chiètres dans le financement de ses acquisitions, lors d''occasions particulières et arrange des parrainages. Elle ne participe pas aux frais d''exploitation.',NULL,'3210',NULL,NULL,NULL,NULL,'2023-08-19 19:09:11','2014-04-16 15:41:46','2023-08-19 19:09:11'),
(612,'Gesundheitscoaching',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.gesundheitscoaching-khm.ch/public/willkommen.php',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Durch verhaltensbezogene individuelle Beratung werden die Botschaften der Präventionsprogramme transportiert und tragen dazu bei, dass die PatientIn- nen dies auch umsetzen können. Das vom KHM (Kol- legium für Hausarztmedizin) initiierte "Gesundheits- coaching" beispielsweise holt den Patienten, die Pati- entin bei der individuellen Verhaltenskonstellation ab. Der Hausarzt, die Hausärztin erarbeitet mit dem Pati- enten oder der Patientin zuerst die Prioritäten und Motivationen und ermöglicht so, die individuellen Ge- sundheitskompetenzen und Ressourcen zu entwickeln. Das Projekt "Gesundheitscoaching" hat Methoden entwickelt, die es dem Arzt oder der Ärztin ermögli- chen, die PatientInnen systematisch auf ihr Gesund- heitsverhalten anzusprechen, sie zu sensibilisieren und zu motivieren, damit sie sich eigene Gesundheitsziele setzen und auch erreichen, begleitet von ihrem Arzt oder ihrer Ärztin. Das "Gesundheitscoaching" opera- tionalisiert erstmals moderne Gesundheitsförderungs- und Beratungskonzepte (u.a. Gesundheitskompetenz, Empowerment, Shared Decision Making, Motivational Interviewing).\nSo finden die nationalen Präventionsprogramme, die Hinweisplakate zu Alkohol, zu Übergewicht und Rau-\nchen ihre Entsprechung in der individuellen Beratung in der Arztpraxis, wo jeder und jede Einzelne davon überzeugt werden kann, dass er oder sie das persönliche Verhalten ändern muss - und kann.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-16 15:43:37','2021-01-03 08:52:54'),
(613,'Bundesamt für Gesundheit (BAG)',NULL,NULL,'CHE-467.023.568',NULL,NULL,0,0,'Bern','BAG',NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich','0220',NULL,'EinzelOrganisation,LeistungsErbringer','punktuell',8,NULL,NULL,'http://www.bag.admin.ch/aktuell/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Wir setzen uns kompetent für die Gesundheit ein, fördern eine gesunde Lebensweise und sorgen dafür, dass es den Menschen in unserem Land gut geht. Wir sind verantwortlich dafür, dass unser Gesundheitssystem leistungsfähig und bezahlbar bleibt.\n\nDie wichtigsten Vorgaben zur Gesundheit sind in der Bundesverfassung geregelt. Wir sind für die Anwendung von mehr als zwanzig Gesetzen und von zahlreichen Verordnungen zuständig, die auf diesen Normen aufbauen. Entsprechend breit ist unser Aufgabengebiet: Wir kümmern uns um die soziale Kranken- und Unfallversicherung, die Vorschriften für Chemikalien und Heilmittel, die Gesetzgebungen in den Bereichen biologische Sicherheit, Forschung am Menschen und Transplantationsmedizin, die Gesundheitsförderung, die nationalen Programme zur Bekämpfung von Suchtverhalten und sexuell übertragbaren Krankheiten, den Strahlenschutz, die Regelung der universitären Medizinal- und Gesundheitsberufe und vertreten die gesundheitspolitischen Interessen der Schweiz in internationalen Organisationen und gegenüber anderen Staaten.',NULL,NULL,NULL,355,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-04-16 16:02:23','2025-02-13 09:16:35'),
(614,'IG Seltene Krankheiten','CI Maladies rares',NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.ig-seltene-krankheiten.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die IG Seltene Krankheiten will dazu beitragen, die Situation der Betroffenen nachhaltig zu verbessern, bestehende regulatorische Lücken zu schliessen und das Bewusstsein um die Problematik seltener Krankheiten in der Schweiz zu verbessern.\n\nDie IG Seltene Krankheiten hat folgende Ziele:\nVersorgung der Patienten verbessern\nSicherstellen des Zugangs zu Diagnostik, wirksamen Therapien und Betreuung für alle Patienten;\nRegelung der Finanzierung von Massnahmen im Bereich seltene Krankheiten;\nVernetzung und Informationsaustausch der Fachpersonen verbessern. \n \nNationalen Massnahmenplan erstellen\nDie angestrebte nationale Strategie aktiv begleiten, mitgestalten und fördern. \n \nSensibilisierung erhöhen\nSensibilisierung von Politik, Verwaltung, Medien und Öffentlichkeit für die Thematik;\nEtablierung einer Austausch- und Koordinationsplattform (Runder Tisch). \n \nForschung und Entwicklung stärken\nPriorisieren seltener Krankheiten in der Grundlagen- und der klinischen Forschung;\nSchaffung nationaler Kompetenzzentren;\nDie Zusammenarbeit mit europäischen und internationalen Referenzzentren und \n-netzwerken fördern;\nDen Informationsaustausch und die Zusammenarbeit von Fachleuten, Betroffenen und Verwaltung verbessern;\nAnreize schaffen für die Grundlagen- und klinische Forschung im Bereich seltene Krankheiten.\n\nIm Zentrum steht die Unterstützung des Bundes bei der Erarbeitung einer nationalen Strategie. Der Bundesrat hat das Bundesamt für Gesundheit (BAG) mit der Erarbeitung einer solchen Strategie mit Massnahmenplan beauftragt, nachdem die Nationalrätin und Präsidentin der IG Seltene Krankheiten, Ruth Humbel, den Bundesrat mit einem Vorstoss zum Handeln aufgefordert hatte.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-08-20 00:00:00','2014-04-16 16:24:48','2025-08-20 09:22:26'),
(615,'Stiftung Schweizerische Akademie für Chiropraktik',NULL,NULL,'CHE-110.197.933',266878,'CH03570070203',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',4,NULL,NULL,'http://www.chirosuisse.info','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357007020&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung unterhält in der Schweiz eine Akadamie für Weiter- und Fortbildung von Chriopraktoren im Rahmen des Bundesgesetztes über die universitären Medizinalberufe. Sie bereitet überdies auf die Zulassungsprüfungen für Chiropraktoren vor, sie führt Bildungslehrgänge durch und ermöglicht die Tätigkeit als Assistenten. Sie betreibt auch Forschung. Sie kann im Übrigen jede Ausbildungstätigkeit für Chiropraktoren, vor und nach bestandener Prüfung, unterstützen, eingeschlossen die Vermittlung von Assistenzstellen, sowie die Herausgabe von Publikationen und Lehrmitteln. Sie kann Immobilien erwerben oder sich an Immobiliengesellschaften beteiligen, um die Räumlichkeiten für die Erfüllung ihrer Aufgaben zu sichern. Sie kann weitere Institutionen errichten.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2022-06-29 20:44:01','2014-04-16 16:33:13','2024-04-28 10:36:59'),
(616,'diabetesschweiz','Association Suisse du Diabète','Associazione Svizzera per il Diabete','CHE-107.344.932',228223,'CH02069003763',1,1,'Baden','SDG','diabetesschweiz',NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.diabetesgesellschaft.ch','http://www.moneyhouse.ch/u/schweizerische_diabetes_gesellschaft_(sdg)_CH-020.6.900.376-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Verbesserung der Lage der Diabetikerinnen und Diabetiker in der Schweiz im Sinne der Internationalen Diabetes-Föderation, insbesondere die geeignete Instruktion, Förderung der Hilfe zur Selbsthilfe und psychosoziale Begleitung der Betroffenen und ihrer Angehörigen, die Aufklärung der Öffentlichkeit, wie auch die Früherfassung der Zuckerkrankheit und Untstützung der Erforschung wissenschaftlicher und sozialer Probleme der Krankheit, der Verein vertritt als Patientenorganisation die Anliegen der Diabetikerinnen und Diabetiker aus einer interdisziplinären Optik gegenüber den Anspruchsgruppen, insbesondere aus Politik, Industrie und Wissenschaft.',NULL,NULL,'5400',4021,NULL,NULL,NULL,'2022-02-14 20:40:43','2014-04-16 16:44:01','2024-04-28 10:36:59'),
(617,'Trybol AG',NULL,NULL,'CHE-101.903.508',197009,'CH29030044332',1,1,'Neuhausen am Rheinfall',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',69,NULL,NULL,'http://www.trybol.ch','http://www.moneyhouse.ch/u/trybol_ag_CH-290.3.004.433-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Herstellung und Vertrieb von kosmetischen, pharmazeutischen und chemischen Produkten sowie von Geräten für die Gesundheits- und Schönheitspflege.',NULL,NULL,'8212',2937,NULL,NULL,NULL,'2023-07-21 14:42:21','2014-04-16 17:06:52','2024-04-28 10:36:59'),
(618,'Dianam S.A.',NULL,NULL,'CHE-103.473.068',269014,'CH29030017635',1,1,'Neuhausen am Rheinfall',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',69,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/dianam_s_a_CH-290.3.001.763-5.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Herstellung und Vertrieb kosmetischer und pharmazeutischer Produkte.',NULL,NULL,'8212',2937,NULL,NULL,NULL,'2023-07-21 14:42:21','2014-04-16 17:11:39','2024-04-28 10:36:59'),
(619,'Oltra AG',NULL,NULL,'CHE-102.880.011',130072,'CH24930001088',1,1,'Olten',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',51,NULL,NULL,'http://www.wthommen.ch','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2493000108&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Gründungsjahr: 14.11.1961 / seit 04.10.2004 als reine General- und Totalunternehmung tätig.\n    Aktienkapital: CHF 3''000''000.-\n    Firmennummer: CH-249.3.000.108-8\n    MwSt-Nummer: CHE-102.880.011\n    Mitarbeiter: 42 (inkl. unserer Schwesterfirma W. Thommen AG)\n    Sitz: Zielempgasse 16, 4600 Olten',NULL,NULL,'4600',2581,NULL,NULL,NULL,'2022-08-09 08:40:53','2014-04-17 11:01:07','2024-04-28 10:36:59'),
(620,'Gewerbekammer des Schweizerischen Gewerbeverbands',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','immer',59,NULL,NULL,'https://www.sgv-usam.ch/%C3%BCber-den-sgv/gewerbekammer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Gewerbekammer, das Parlament des Schweizerischen Gewerbeverbands sgv, besteht aus 85 bis 99 Mitgliedern, wovon 60 aus den schweizerischen Berufsverbänden und 25 aus den kantonalen Gewerbe­ver­bänden am Gewerbekongress gewählt und die übrigen Mitglieder vom Vorstand berufen werden. Die Kammer tagt - je nach Dringlichkeit - zwei bis drei Mal pro Jahr. Sie wählt den Vorstand, die beiden Vizepräsidenten und ernennt den Direktor der Geschäftsstelle. Sie legt die allgemeine Gewerbepolitik fest, nimmt zu Gesetzesvorlagen Stellung und fasst die Beschlüsse über alle Geschäfte, die nicht einem anderen Organ vorbehalten sind.',NULL,NULL,'3001',NULL,NULL,NULL,NULL,'2025-02-13 09:15:09','2014-04-17 11:19:13','2025-02-13 09:15:09'),
(621,'Groupe Mutuel Assurances GMA SA',NULL,NULL,'CHE-100.739.755',512757,'CH62130055900',1,1,'Martigny','GMA',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer','punktuell',2,57,NULL,'http://www.groupemutuel.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Groupe Mutuel Versicherungen AG ist ein Privatversicherer und eine Gesellschaft der Groupe Mutuel Holding SA.',NULL,NULL,'1920',6136,NULL,NULL,NULL,'2025-06-10 11:49:32','2014-04-17 11:51:04','2025-06-10 11:49:32'),
(622,'Stiftung aha! Allergiezentrum Schweiz','aha! Centre d''allergie suisse','aha! Centro allergie svizzera','CHE-106.004.600',507171,'CH03570250067',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.aha.ch','http://www.moneyhouse.ch/u/stiftung_aha_allergiezentrum_schweiz_CH-035.7.025.006-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'aha! Allergiezentrum Schweiz ist eine schweizweit tätige, von der ZEWO anerkannte und ISO-zertifizierte, gemeinnützige Stiftung. Wir sind das Kompetenzzentrum im Allergiebereich und fokussieren uns auf die Reaktionen der Atemwege, des Verdauungssystems und der Haut auf Umweltreize. Wir treten in der Öffentlichkeit als Allergiezentrum Schweiz in Erscheinung und sind eine unabhängige Anlaufstelle für Betroffene und Betreuende, aber auch für weitere interessierte Kreise wie Medien, Unternehmen, Ausbildungsstätten, Politik, Behörden und Verbände. Unser Spektrum an Dienstleistungen reicht von der Beratung Einzelner und Schulungen bis zu Präventionsprojekten und Kampagnen für die breite Bevölkerung. Diese Angebote werden ermöglicht durch unser weit verzweigtes Netzwerk und die enge Zusammenarbeit mit führenden Fachpersonen und Fachgesellschaften in den relevanten Bereichen.',NULL,NULL,'3014',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-17 17:26:09','2024-04-28 10:36:59'),
(623,'Liga für Zeckenkranke Schweiz (LiZ)','Ligue suisse des personnes atteintes de maladies à tiques',NULL,'CHE-309.624.987',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'www.zeckenliga.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Liga für Zeckenkranke Schweiz (LiZ) hat zum Ziel, Informationen über Zeckenkrankheiten auszutauschen und zu verbreiten. Sie engagiert sich für die Prävention und versucht, die Kontakte zwischen Kranken und medizinischen, sozialen und gesundheitspolitischen Institutionen zu erleichtern.',NULL,NULL,NULL,351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-17 17:43:15','2022-09-25 22:33:13'),
(624,'Lungenliga Schweiz','Ligue pulmonaire','Lega polmonare','CHE-107.810.762',833346,'CH03560360163',1,1,'Köniz',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'www.lungenliga.ch','http://www.moneyhouse.ch/u/lungenliga_schweiz_CH-035.6.036.016-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Lungenliga Schweiz bezweckt die Bekämpfung von Lungenkrankheiten, Atembehinderungen, Tuberkulose und Allergien. Sie kann sich auch für Patientinnen und Patienten anderer Krankheitsgruppen einsetzen. Sie kann zu diesem Zweck auf Beschluss des Delegiertenrates (DR) Gesellschaften gründen, sich an solchen beteiligen oder mit solchen zusammenarbeiten. In Kantonen, wo eine andere gemeinnützige Institution die Aufgaben einer kantonalen Lungenliga wahrnimmt, wird die Zusammenarbeit mit der Lungenliga Schweiz vertraglich geregelt. Alle statutarischen Regelungen, die sich auf die kantonalen Lungenligen beziehen, gelten sinngemäss für die Form der vertraglichen Zusammenarbeit.',NULL,NULL,'3098',351,NULL,NULL,NULL,'2022-09-27 00:00:00','2014-04-17 17:58:18','2024-04-28 10:36:59'),
(625,'Rheumaliga Schweiz','Ligue suisse contre le rhumatisme','Lega svizzera contro il reumatismo','CHE-107.820.186',166240,'CH02069004193',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'www.rheumaliga.ch','http://www.moneyhouse.ch/u/rheumaliga_schweiz_CH-020.6.900.419-3.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein fördert die Bekämpfung der Rheumaerkrankungen und deren Folgen für die Betroffenen auf gesamtschweizerischer Ebene. Er lässt sich dabei von den anerkannten Grundsätzen der medizinischen Wissenschaften und der sozialen Arbeit leiten. Der Verein erfüllt seinen Zweck vor allem durch die Erbringung von Dienstleistungen sowohl für Betroffene wie auch für die Mitgliederorganisationen, Fachpersonen und für die breite Öffentlichkeit: Information, Prävention, Sozialarbeit, Förderung der Hilfe zur Selbsthilfe, Förderung der Therapie und Wiedereingliederung, Aus-, Fort- und Weiterbildung, Unterstützung von Fachpersonen, Arbeitgebern; Vertretung der Interessen von Menschen, die in Folge einer rheumatischen Erkrankung behindert sind gegenüber Behörden, Fachleuten, Leistungserbringern und Versicherern; Koordination und Förderung der Zusammenarbeit mit nationalen und internationalen Institutionen ähnlicher Zwecksetzung.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-17 18:04:29','2024-04-28 10:36:59'),
(626,'Cystische Fibrose Schweiz CFS','Société Suisse pour la Mucoviscidose CFCH','Società Svizzera per la Fibrosi Cistica CFCH','CHE-108.031.631',1276527,'CH03660676582',1,1,'Bern','CFS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'www.cfch.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Gesellschaft für Cystische Fibrose (kurz CFCH) ist eine Nonprofit-Organisation. Sie wurde 1966 gegründet und verfolgt mit ihrer Arbeit folgende Zwecke:\n\n    Förderung der Selbsthilfe\n    Beraten, informieren und unterstützen von CF-Betroffenen und deren Familien\n    Forschung über Ursache und Behandlung von CF fördern\n    Kontakt zu regionalen, nationalen und internationalen Organisationen pflegen\n    CF bekannt machen',NULL,NULL,'3014',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-17 18:48:22','2024-04-28 10:36:59'),
(627,'Schweizerische Muskelgesellschaft',NULL,NULL,'CHE-100.516.244',1274930,'CH02060021566',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',15,NULL,NULL,'http://www.muskelgesellschaft.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Muskelgesellschaft wurde am 15. Juni 1974 von Erica Brühlmann-Jecklin, Psychotherapeutin und Schriftstellerin, gegründet. Erica Brühlmann-Jecklin erhielt als 16-Jährige die Diagnose Progressive Muskeldystrophie und versprach sich mit der Gründung einer Gesellschaft den verbesserten Austausch von muskelkranken Menschen. Schon kurz nach der Gründung fanden diverse Veranstaltungen zum Thema Muskelkrankheiten statt.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-17 21:36:56','2024-04-28 10:36:59'),
(628,'Schweizerische Psoriasis und Vitiligo Gesellschaft SPVG','Société Suisse du Psoriasis et du Vitiligo SSPV',NULL,'CHE-108.288.437',NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'www.spvg.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Schweizerische Psoriasis und Vitiligo Gesellschaft (SPVG) ist eine Patientenvereinigung mit zur Zeit rund 1200 Mitgliedern. Sie nimmt sich der Fragen und Probleme im Umfeld von Psoriasis und Vitiligo an, steht betroffenen Personen mit Rat bei und wird von einem namhaften Wissenschaftlichen Beirat unterstützt. Sie vertritt die Interessen von Psoriasis und Vitiligo Patienten zum Beispiel gegenüber Krankenkassen oder Behörden, versucht die Öffentlichkeit auf Probleme im Zusammenhang mit diesen Krankheiten zu sensibilisieren und gibt unter anderem eine Mitglieder- und Fachzeitschrift in Deutsch sowie Französisch heraus.',NULL,NULL,NULL,351,NULL,NULL,NULL,'2016-09-06 14:43:15','2014-04-17 21:42:32','2022-09-25 22:33:13'),
(629,'Selbsthilfe Schweiz','Fondation Info-Entraide Suisse','Fondazione Auto-Aiuto Svizzera','CHE-109.155.856',506057,'CH27070027357',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'DachOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.selbsthilfeschweiz.ch','http://www.moneyhouse.ch/u/selbsthilfe_schweiz_CH-270.7.002.735-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Selbsthilfe Schweiz ist der nationale Dachverband der 19 regionalen Selbsthilfezentren und zweier schweizerischen Selbsthilfeorganisationen.\nSie ist seit dem Jahr 2000 tätig, vormals unter dem Namen Stiftung KOSCH.',NULL,NULL,'4053',2701,NULL,NULL,NULL,'2023-07-25 22:58:43','2014-04-17 22:15:47','2024-04-28 10:36:59'),
(630,'IG Zöliakie der deutschen Schweiz',NULL,NULL,NULL,NULL,NULL,0,0,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer','punktuell',6,NULL,NULL,'www.zoeliakie.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die IG Zöliakie der Deutschen Schweiz ist eine Patientenorganisation (Rechtsform: gemeinnütziger Verein), die sich für die Anliegen von Betroffenen mit Zöliakie oder Dermatitis herpetiformis Duhring einsetzt und über alle Belange der glutenfreien Ernährung und des Lebens mit Zöliakie informiert.  Der Vorstand, verschiedene Arbeitsgruppen und ein Teilzeitsekretariat erledigen die laufenden Arbeiten und entwickeln Projekte.  Unter anderem ist für uns die Öffentlichkeitsarbeit ein grosses Anliegen.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-28 14:49:30','2014-04-17 22:23:07','2023-08-28 14:49:30'),
(631,'aphasie suisse','Aphasie Suisse',NULL,'CHE-104.265.006',NULL,NULL,0,0,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',6,NULL,NULL,'http://www.aphasie.org/de/uber-uns/aphasie-suisse',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Schweizerische Arbeitsgemeinschaft für Aphasie; Fachgemeinschaft und Betroffenenorganisation; \naphasie suisse ist eine Non-Profit-Organisation im Gesundheits- und Sozialbereich. Die schweizweit tätige Fachgesellschaft und Betroffenenorganisation wurde 1983 als Verein im Sinne der Art. 60ff. ZGB gegründet. Sie ist politisch und konfessionell neutral.\n\n \n\nMenschenbild\n\nIm Leben eines Menschen können Krankheiten auftreten, die zu psychischen, physischen und sozialen Folgen führen können. Wir betrachten den Menschen als entwicklungsfähig und unterstützen Schritte der Betroffenen bei der Teilhabe am sozialen Leben.\n\nJede aphasische Person ist für uns ein spezieller und wertvoller Mensch. Wir setzen bei ihren Kompetenzen und nicht bei ihren krankheitsbedingten Defiziten a',NULL,NULL,NULL,1061,NULL,NULL,NULL,'2017-07-10 18:15:39','2014-04-17 23:12:34','2022-09-25 22:33:13'),
(632,'Aspasie','Aspasie',NULL,'CHE-103.502.824',NULL,NULL,0,0,'Genf',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',12,NULL,NULL,'http://www.aspasie.ch',NULL,NULL,NULL,NULL,'AssociationAspasie',NULL,NULL,'Beratungsstelle für Sexarbeitende in Genf\nAspasie est une association de solidarité, crée à Genève en 1982 par des personnes prostituées et leurs alliés. Dans une attitude de non jugement elle défend les droits des personnes qui exercent le travail du sexe, offre accueil, information, prévention et soutien.\n\nAspasie travaille de concert avec l''association Boulevards, dont le cahier des charges est la prévention hors murs, de rue et de nuit.',NULL,NULL,NULL,6621,NULL,NULL,NULL,'2025-06-19 16:03:50','2014-04-19 14:15:23','2025-06-19 16:03:50'),
(633,'Watch it','Association des ami-e-s des images',NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation','nie',12,NULL,NULL,'http://watchit.uiah.fi/fr/introduction/index.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Vereinigung hat zum Ziel zu sensibilisieren, wie Sexualität und Sport benutzt werden, um Bilder zu "verkaufen".','WATCH IT! ( "Ouvrez l´oeil!) vous propose des outils pour développer votre "Sherlock Holmes visuel" et mieux vous orienter dans le flot de messages visuels dans lequel nous évoluons quotidiennement.',NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-10 18:15:39','2014-04-19 14:28:05','2017-07-10 18:15:39'),
(634,'Association Nochlezhka Suisse Solidaire','Russe sans-papier das leur propre pays',NULL,'CHE-114.501.674',921678,'CH55010556346',1,1,'Lutry',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,dezidierteLobby','nie',68,NULL,NULL,'http://www.suissesolidaire.org','http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-1055634-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Nochlezhka Suisse Solidaire, oder N.S.S., wurde im August 2008 in Genf gegründet und unterstützt die russische ONG Nochlezhka, " ein Dach in der Nacht ", die sich in Sankt Petersburg befindet. N.S.S. wurde einzig für die finanzielle, materielle und politische Unterstützung der russischen ONG Nochlezhka gegründet.\n\nNochlezhkas Ziel : Als Erstes den Sans-Papiers und Obdachlosen eine Überlebenschance zu bieten, damit sie schliesslich den Weg zurück ins aktive Leben finden. Es gibt mehrere tausend Obdachlose in Sankt Petersburg.\nN.S.S. ist eine Non-Profit-Organisation. Schweizer Persönlichkeiten, die die Menschenrechte verteidigen und gegen die Ungerechtigkeit in der Verwaltung kämpfen, sind Spender von N.S.S.\n\nSeit Anfang 2011 gibt es eine basler Sektion, die N.S.S.B. Ihr Ziel ist es, die Deutschschweiz auf die russische Realität aufmerksam zu machen, neue Unterstützung zu finden und zusätzliche Finanzierungsmittel zu sammeln.',NULL,NULL,'1095',5606,NULL,NULL,NULL,'2017-07-10 18:15:39','2014-04-19 14:35:53','2024-04-28 10:36:59'),
(635,'Association of European Parliamentarians with Africa AWEPA',NULL,NULL,NULL,NULL,NULL,0,0,'Amsterdam',NULL,NULL,NULL,NULL,NULL,NULL,158,4,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',70,NULL,NULL,'http://www.awepa.org/',NULL,'AWEPA',NULL,NULL,NULL,NULL,NULL,'AWEPA works in cooperation with African Parliaments to strengthen parliamentary democracy in Africa, to keep Africa high on the political agenda in Europe and to facilitate African-European Parliamentary dialogue.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-03 08:15:21','2014-04-21 12:01:01','2017-07-03 08:15:21'),
(636,'Zürich Erneuerbar',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',32,NULL,NULL,'http://www.zuerich-erneuerbar.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Am 27. Februar 2005 wurde mit grosser Mehrheit die neue Verfassung des Kantons Zürichs angenommen. Diese verpflichtet den Kanton und die Gemeinden zu einer haushälterischen Nutzung des Bodens und zur Erhaltung des Lebensraumes.\n\nDie im Kanton wohnhaften Menschen und die Umwelt sollen vor schädlichen oder lästigen Einwirkungen geschützt werden.\n\nNachhaltige Technologien können gefördert werden.\n\nDer Kanton hat für günstige Rahmenbedingungen, für eine ausreichende, umweltschonende, wirtschaftliche und sichere Energieversorgung zu sorgen.\n\nDabei schafft er Anreize für die Nutzung einheimischer und erneuerbarer Energien und für den rationellen Energieverbrauch.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-19 15:47:47','2014-04-21 12:17:15','2025-06-19 15:47:47'),
(637,'Biodiversität und Artenschutz','Biodiversité et gestion des espèces',NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','punktuell',54,NULL,NULL,'http://www.birdlife.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Erhaltung und Förderung der biologischen Vielfalt in der Schweiz.',NULL,'Raffael Ayé\n+41 44 457 70 20\nraffael.aye@birdlife.ch\nBiodiversität und Artenschutz\nPostfach\nWiedingstr. 78\n8036 Zürich\nSCHWEIZ\nwww.birdlife.ch',NULL,NULL,NULL,NULL,'2024-05-05 08:00:39','2025-09-08 20:48:38','2014-04-21 14:06:45','2025-09-08 20:48:38'),
(638,'Kaufmännischer Verband Zürich',NULL,NULL,'CHE-105.904.168',97251,'CH02069002677',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,LeistungsErbringer','nie',53,NULL,NULL,'http://www.kvz.ch','http://www.moneyhouse.ch/u/kaufmannischer_verband_zurich_CH-020.6.900.267-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Der KVZ ist die Berufsorganisation der Angestellten und Auszubildenden im Dienstleistungs-, Handels-, Industrie-, Bau- und Gewerbesektor sowie in der öffentlichen Verwaltung; ist konfessionell und parteipolitisch neutral; bezweckt Sicherung und Verbesserung der wirtschaftlichen, sozialen, gesellschaftlichen und rechtlichen Lage seiner Mitglieder. Die Statuten enthalten nähere Bestimmungen wie dieser Zweck erreicht werden kann.',NULL,NULL,'8001',261,NULL,NULL,NULL,'2019-09-18 16:41:36','2014-04-21 14:37:08','2024-04-28 10:36:59'),
(639,'Pro Natura Zürich',NULL,NULL,'CHE-107.448.218',NULL,NULL,0,0,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,NULL,NULL,'http://www.pronatura-zh.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,261,NULL,NULL,NULL,'2019-09-12 20:38:37','2014-04-21 14:52:52','2022-09-25 22:33:13'),
(640,'Familienpolitik','Politique familiale',NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',12,NULL,NULL,'http://www.profamilia.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Familienpolitik hat sich in den vergangenen Jahren zu einem wichtigen Thema des politischen Diskurses entwickelt. Die Parlamentarische Gruppe Familienpolitik will familienpolitische Projekte, die sich in der parlamentarischen Beratung befinden, thematisieren und sich über die Parteigrenzen hinweg für deren Realisierung einsetzen. Neue, gesellschaftliche Entwicklungen, mit denen sich die Familien konfrontiert sehen, antizipieren, den politischen Handlungsbedarf ausloten und gegebenenfalls mögliche Massnahmen und Strategien erarbeiten.',NULL,'Nadja Schmid\n+ 41 31 381 90 30\ninfo@profamilia.ch\nPro Familia Schweiz\nMarktgasse 36\n3011 Bern\nSCHWEIZ\nwww.profamilia.ch',NULL,NULL,NULL,NULL,'2024-11-01 17:22:03','2025-10-28 08:58:52','2014-04-21 15:03:26','2025-10-28 08:58:52'),
(641,'Parlamentarische Gruppe Suchtpolitik, Prävention und Jugendschutz ','Intergroupe parlementaire Politique des addictions, prévention et protection de  la jeunesse ',NULL,NULL,NULL,NULL,0,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Parlamentarische Gruppe',NULL,NULL,'MitgliedsOrganisation,dezidierteLobby','nie',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8001',NULL,NULL,NULL,'2018-07-17 13:24:57','2017-07-19 13:29:19','2014-04-21 15:09:15','2021-02-07 14:49:02'),
(642,'Forum Elle (Die Frauenorganisation der Migros)',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,MitgliedsOrganisation,LeistungsErbringer,Gemeinnuetzig','nie',67,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Frauenorganisation der Migros. Sie nimmt sich den neu formulierten, vom Inhalt her aber nach wie vor gültigen Werten von Guttlieb Duttweiler an und greift sie auch in unserem Veranstaltungsangebot regelmässig auf. Dazu gehören beispielsweise der Kampf gegen Machtmissbrauch, die Achtung der schweizerischen Privatwirtschaft, vorbildliche, faire Bezahlung und Sozialleistungen, die Frau als Verfechterin des Migros-Gedankenguts, die Wirtschaftlichkeit und die Absage an eine Gewinnbeteiligung. Wir vernetzen Frauen verschiedenster Herkunft und bieten ihnen auch kulturell ein reiches Angebot.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2017-07-10 18:29:12','2014-04-21 15:19:43','2017-07-10 18:29:12'),
(643,'Unser Recht','Notre Droit','Nostro Diritto','CHE-203.410.157',NULL,NULL,0,0,'Küsnacht',NULL,'Verein "Unser Recht"',NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,dezidierteLobby','nie',143,NULL,NULL,'http://www.unser-recht.ch',NULL,'UnserRecht',NULL,NULL,'UnserRechtNotreDroitNostroDirittoNossDretg/','https://www.linkedin.com/company/unser-recht/posts/?feedView=all',NULL,'Unser Recht ist eine Schweizer Denkfabrik für Recht und Politik und setzt sich ein für die Geltung, Achtung und Weiterentwicklung von Grundrechten, Rechtsstaatlichkeit und Völkerrecht in der Schweiz und in Europa.','Notre droit est un groupe de réflexion suisse sur le droit et la politique. Il s''engage pour la validité, le respect et le développement des droits fondamentaux, de l''Etat de droit et du droit international en Suisse et en Europe.',NULL,NULL,4001,NULL,NULL,NULL,'2025-07-01 13:13:27','2014-04-21 16:11:27','2025-07-01 13:13:27'),
(644,'Pro Seniorweb - Stiftung',NULL,NULL,'CHE-114.400.599',914948,'CH02070015247',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,Gemeinnuetzig','nie',12,NULL,NULL,'http://www.seniorweb.ch/type/page/mitglieder-der-stiftung-pro-seniorweb','http://www.moneyhouse.ch/u/pro_seniorweb__stiftung_CH-020.7.001.524-7.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Stiftung bezweckt; in der Schweiz altersgerechte Kommunikations- und Begegnungsformen für Generationen 50plus zu fördern; eine zeitgemässe Alterspolitik in der Kommunikation zu formulieren und sich für eine zeitgemässe Sicht des Älterwerdens einzusetzen; einer Zweiklassengesellschaft mit digitalem Graben entgegenzuwirken; Dienstleistungen für ältere Menschen, Rat und Hilfe in Bereichen der Informationstechnologie zu vermitteln; die Zusammenarbeit mit gleichgelagerten Organisationen und Bildungsanstalten in der Schweiz und im Ausland zu fördern; die Vernetzung von gleichen oder ähnlichen Interessen zu fördern; sie ist gesamtschweizerisch tätig, berücksichtigt die verschiedenen Sprachregionen und unterhält Kontakte zu Auslandschweizern und ihren Organisationen. Die Zielsetzungen soll die Stiftung insbesondere durch den Betrieb einer Website unter der Domain www.seniorweb.ch sowie unter dem Namen "Seniorweb" verfolgen. Die Website soll einer breiten Öffentlichkeit die Belange der älteren Generation allgemein näher bringen.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-21 17:58:55','2024-04-28 10:36:59'),
(645,'machs! GmbH',NULL,NULL,'CHE-115.169.950',960631,'CH40040321714',1,1,'Nussbaumen AG',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation','nie',18,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/machs_gmbh_CH-400.4.032.171-4.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Operative Ausübung von Geschäftsführungen, strategische und/oder operative Beratungsdienstleistungen im Bereich Kommunikation, Personalwesen, Politik und Finanzen sowie das Anbieten von Aus- und Weiterbildung; kann Zweigniederlassungen errichten, sich an anderen Unternehmungen beteiligen oder sich mit diesen zusammenschliessen, Grundstücke und Wertschriften erwerben, halten und veräussern sowie Darlehen gewähren.',NULL,NULL,'5415',4038,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-21 18:40:41','2024-04-28 10:36:59'),
(646,'Swiss Science Center Technorama',NULL,NULL,'CHE-107.165.714',297098,'CH02079045462',1,1,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','punktuell',41,NULL,NULL,'www.technorama.ch','http://www.moneyhouse.ch/u/swiss_science_center_technorama_CH-020.7.904.546-2.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb des Swiss Science Center Technorama, das vorab als Bildungsinstitution dient, indem es Wissenschaft und Technik in lebendiger Schau zur Darstellung bringt, um bei einer breiten Öffentlichkeit dafür Interesse zu wecken und das Verständnis zu fördern.',NULL,NULL,'8404',230,NULL,NULL,NULL,'2025-09-01 15:55:46','2014-04-21 19:06:57','2025-09-01 15:55:46'),
(647,'HKG Engineering AG',NULL,NULL,'CHE-105.905.707',80150,'CH40030031710',1,1,'Aarau','HKG',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,Gewinnorientiert','nie',50,52,NULL,'www.hkg.ch','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4003003171&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Durchführung von Planungen sämtlicher haustechnischer Installationen von Gebäuden aller Art; die Gesellschaft kann im In- und Ausland Zweigniederlassungen und Tochtergesellschaften errichten, sich an anderen Unternehmungen beteiligen sowie im In- und Ausland Grundeigentum erwerben, belasten, veräussern und verwalten.',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-21 19:35:02','2024-04-28 10:36:59'),
(648,'Verein Netzwerk Arbeit Kanton Schwyz',NULL,NULL,NULL,NULL,NULL,0,0,'Schwyz','Netzwerk Arbeit',NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.netzwerk-arbeit.ch/dynamic/page.asp?seiid=19',NULL,NULL,NULL,'netzwerk-arbeit',NULL,'https://www.linkedin.com/company/verein-netzwerk-arbeit-kanton-schwyz/',NULL,'Das Ziel von Netzwerk Arbeit Kanton Schwyz liegt darin, Menschen mit gesundheitlichen Einschränkungen wieder ins Arbeitsleben zu integrieren. Gemeinsam mit der IV-Stelle Schwyz unterstützt der Verein interessierte Unternehmen bei einer Wiedereingliederung.','L''objectif de Netzwerk Arbeit Kanton Schwyz est de réintégrer dans la vie professionnelle des personnes atteintes dans leur santé. En collaboration avec l''office AI de Schwyz, l''association soutient les entreprises intéressées par une réinsertion.',NULL,NULL,NULL,NULL,NULL,NULL,'2024-07-15 12:05:31','2014-04-21 22:41:36','2024-07-15 12:07:39'),
(649,'Lakers Sport AG',NULL,NULL,'CHE-105.632.946',534863,'CH32030484024',1,1,'Rapperswil SG',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',65,NULL,NULL,'http://www.lakers.ch/index.php/club/lakerssportag','http://sg.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3203048402&amt=320&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der Schlittschuhclub Rapperswil-Jona wurde am 17. Januar 1945 gegründet.\nDer Club wurde im Sommer 2005 in "Rapperswil-Jona Lakers" umbenannt.\nDie "Lakers" spielen seit 1994 (ohne Unterbruch) in der Nationalliga A.\n  	 \nLakers Sport AG\nDer Club ist eine Aktiengesellschaft und erzielt einen Jahresumsatz von rund Fr. 11.5 Mio.\nAm 13. Juli 2000 wurde die SCRJ Sport AG gegründet, welche dann auf die Saison 05/06 auf Lakers Sport AG umbenannt wurde.\nDie Lakers Sport AG hat über 1500 Aktionäre.\nDie Lakers Sport AG beschäftigt 45 Festangestellte.',NULL,NULL,'8640',3340,NULL,NULL,NULL,'2022-06-04 14:42:22','2014-04-21 22:51:02','2024-04-28 10:36:59'),
(650,'Microsoft Schweiz GmbH',NULL,NULL,'CHE-110.088.994',710491,'CH02040270498',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,Gewinnorientiert','nie',78,NULL,NULL,'www.microsoft.com','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0204027049&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Vermittlung von und Handel mit Software- und Hardware-Produkten aller Arten, speziell mit Produkten, die von der Microsoft Corporation (USA) und deren Tochtergesellschaften hergestellt werden, sowie Erbringung von Dienstleistungen, die damit zusammenhängen, kann sich an Unternehmen ähnlicher Art beteiligen, Grundeigentum erwerben, verwalten und veräussern sowie gewerbliche Schutzrechte, Immaterialgüterrechte und Know-how erwerben und verwerten.',NULL,NULL,'8058',62,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-22 20:21:20','2024-04-28 10:36:59'),
(651,'Swissgrid AG',NULL,NULL,'CHE-112.175.457',779370,'CH40030261874',1,1,'Aarau',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',29,NULL,NULL,'https://www.swissgrid.ch/swissgrid/de/home.html','http://ag.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4003026187&amt=400&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Swissgrid ist die Nationale Netzgesellschaft und verantwortet als Übertragungsnetzeigentümerin den sicheren, zuverlässigen und wirtschaftlichen Betrieb des Schweizer Höchstspannungsnetzes.\n\nAn den Standorten in Laufenburg, Frick und Vevey beschäftigt Swissgrid über 400 qualifizierte Mitarbeitende aus 17 Nationen.\n\nAls Mitglied des europäischen Netzwerkes der Übertragungsnetzbetreiber ENTSO-E nimmt sie zudem Aufgaben im Bereich der Koordination und der Netznutzung im europäischen Stromaustausch wahr.\n\nDie Schweizer Elektrizitätsunternehmen Axpo Power, Alpiq, Alpiq Suisse, BKW, Axpo Trading, CKW und andere Aktionäre halten 100% des Swissgrid Aktienkapitals.',NULL,NULL,'5000',4001,NULL,NULL,NULL,'2021-01-26 15:12:59','2014-04-23 09:36:21','2024-04-28 10:36:59'),
(652,'Association romande contre la drogue ARCD',NULL,NULL,NULL,NULL,NULL,0,0,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','punktuell',3,NULL,NULL,'http://www.arcd.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'L''Association romande contre la drogue (ARCD) est une association sans but lucratif dont les buts statutaires sont :\n\n    protéger la jeunesse et la société contre les effets de la drogue ;\n    contribuer à promouvoir une politique de la drogue cohérente fondée principalement sur la prévention, la thérapie (dans un but d''abstinence) et la répression ;\n    soutenir tout projet permettant de développer la prévention ainsi que de réduire l''offre et la demande de stupéfiants ;\n    combattre tout projet législatif ou constitutionnel facilitant la culture et/ou la production, l''acquisition, l''importation et la possession de stupéfiants en vue de la consommation personnelle.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-26 09:10:31','2014-04-23 11:21:17','2023-08-26 09:10:33'),
(653,'Wilhelm Schulthess - Stiftung',NULL,NULL,'CHE-105.885.944',292482,'CH02079035490',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',5,NULL,NULL,'http://www.schulthess-klinik.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207903549&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung nach Zefix: Bezweckt ein orthopädisches Heil- und Erziehungsinstitut zu betreiben und unbemittelte, gebrechliche und hilfsbedürftige Menschen beiderlei Geschlechts und jeden Alters zur Heilung oder Besserung ihres Zustandes sowie ihrer beruflichen Ausbildung darin aufzunehmen.\n\nDie Schulthess Klinik in Zürich ist eine der führenden orthopädischen Kliniken Europas mit über 800 Mitarbeitenden. Ihr zentrales Anliegen ist es, Menschen von ihren Schmerzen zu befreien und ihre Mobilität wiederherzustellen. Die Klinik ist offen für Allgemein- und Zusatzversicherte.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-04-23 18:02:48','2025-02-13 09:16:35'),
(654,'Schweizerische Vereinigung für Qualitäts- und Management-Systeme (SQS)','Association Suisse pour Systèmes de Qualité et de Management (SQS)','Associazione Svizzera per Sistemi di Qualità e di Management (SQS)','CHE-106.270.366',353123,'CH05360023309',1,1,'Zollikofen','SQS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','punktuell',74,NULL,NULL,'http://www.sqs.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die SQS fördert und unterstützt mit allen ihr zur Verfügung stehenden und geeigneten Mitteln die Bestrebungen der Wirtschaft, privater und öffentlicher Organisationen auf den Gebieten der Produkte-, Dienstleistungs-, Prozess- und Unternehmensqualität. Insbesondere unterstützt sie deren Wettbewerbs- und Leistungsfähigkeit durch: Begutachtung und Bewertung der Qualitäts- und Managementsysteme besonders im Hinblick auf Erfüllung der Anforderungen und zweckmässige Anwendung von einschlägigen schweizerischen und ausländischen Normen, Richtlinien und Vorschriften; Bescheinigung der Erfüllung von Anforderungen einschlägiger normativer Grundlagen durch Erteilung eines befristeten Zertifikates, abgekürzt SQS-Zertifikat; Konformitätsbewertungen und -bestätigungen unter anderem in Form einer Zusammenarbeit mit akkreditierten und notifizierten Partnern; Benchmark-, Rating- und weitere Bewertungsleistungen; Schulungen; Beteiligungen an Unternehmen, die Dienstleistungen im Qualitäts- und Managementbereich anbieten, erwerben, halten und veräussern. Ein allfälliger Nebenzweck ist aus den Statuten ersichtlich.',NULL,NULL,'3052',361,NULL,NULL,NULL,'2025-09-08 20:17:09','2014-04-23 18:16:31','2025-09-08 20:17:09'),
(655,'Personalvorsorgestiftung der Wilhelm Schulthess-Stiftung',NULL,NULL,'CHE-109.732.535',292480,'CH02079035504',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207903550&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt die überobligatorische berufliche Vorsorge für die Arbeitnehmer der Firma (Schultess-Klinik) und der mit ihr wirtschaftlich verbundenen Gesellschaften sowie für deren Angehörige und Hinterlassenen gegen die wirtschaftlichen Folgen von Alter, Tod und Invalidität. Sie kann die überobligatorische, freiwillige Vorsorge betreiben oder finanzieren, einschliesslich Unterstützungsleistungen in Notlagen, wie bei Krankheit, Unfall, Invalidität oder Arbeitslosigkeit. Zur Erreichung ihres Zweckes kann die Stiftung Versicherungsverträge abschliessen oder in bestehende Verträge eintreten.',NULL,NULL,'8008',261,NULL,NULL,NULL,'2022-09-23 00:00:00','2014-04-23 18:24:44','2024-04-28 10:36:59'),
(656,'Kommission für Wirtschaftspolitik','Commission de la politique économique',NULL,NULL,NULL,NULL,0,0,'Bern',NULL,'Kommission für Wirtschaftspolitik des Seco',NULL,NULL,NULL,NULL,191,1,'Ausserparlamentarische Kommission',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',23,NULL,NULL,'http://www.admin.ch/opc/de/classified-compilation/20053019/index.html#a4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Kommission berät das Eidgenössische Departement für Wirtschaft, Bildung und Forschung (WBF)1 und das Staatssekretariat für Wirtschaft (SECO) in Fragen einer innovativen, wettbewerbsorientierten und Arbeitsplätze schaffenden Wirtschaftspolitik und ihrer Rahmenbedingungen. Sie orientiert sich dabei an den schweizerischen Gegebenheiten, am europäischen und globalen Umfeld sowie an einer nachhaltigen Entwicklung.\n\n2 Sie nimmt Stellung zu grundsätzlichen Fragen des Arbeitsmarktes.\n\n3 Sie äussert sich zu wesentlichen Fragen der Aussenwirtschaftspolitik.','La commission conseille le Département fédéral de l''économie (DFE) et le Secrétariat d''Etat à l''économie (seco) pour toutes les questions ayant trait à une politique\néconomique novatrice, axée sur la compétitivité et créatrice d''emploi, et à ses conditions  générales.',NULL,'3003',NULL,NULL,NULL,NULL,'2024-01-04 19:45:38','2014-04-23 18:37:41','2024-01-04 19:45:38'),
(657,'Die Mitte Schweiz','Le Centre Suisse','Alleanza del Centro Svizzera',NULL,NULL,NULL,0,0,'Bern',NULL,'CVP Christlichdemokratische Volkspartei der Schweiz',NULL,'PDC Parti démocrate-chrétien de la Suisse',NULL,'PPD Svizzero',191,1,'Verein',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','immer',20,NULL,NULL,'http://www.cvp.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Es handelt sich um die Kantonalpartei der "Mitte Schweiz".',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-09-15 21:08:25','2014-04-23 18:43:45','2025-09-15 21:08:25'),
(658,'Farner Consulting AG',NULL,NULL,'CHE-105.833.189',400461,'CH02039085190',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',18,NULL,NULL,'http://www.farner.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0203908519&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','AgenturFarner','farner_teamfarner','FarnerCh',NULL,'https://www.linkedin.com/company/farner-teamfarner/','Farner Consulting AG','Die Farner Consulting AG ist eine Schweizer Beratungs- und Kommunikationsplattform mit landesweiter Abdeckung an sieben Standorten.','Farner Consulting AG est une plateforme suisse de conseil et de communication qui couvre l''ensemble du pays sur sept sites.',NULL,'8001',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-04-24 08:38:37','2025-02-13 09:16:35'),
(659,'Gleichstellungskommission des Kantons Zürich',NULL,NULL,NULL,NULL,NULL,0,0,'Zürich/Oberglatt',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Ausserparlamentarische Kommission',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',67,NULL,NULL,'http://www.zh.ch/internet/justiz_inneres/ffg/de/ueber_uns/gleichstellungskommission.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Kommission für die Gleichstellung von Frau und Mann des Kantons Zürich ist eine ständige Kommission, die den Regierungsrat in Gleichstellungsfragen berät.\nDie Mitglieder werden vom Regierungsrat auf Amtsdauer gewählt. Administrativ ist die Gleichstellungskommission der Direktion der Justiz und des Innern angegliedert. Seit ihrer Gründung trifft sich die Kommission zu vier Sitzungen pro Jahr, in der Regel einmal pro Quartal.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-23 00:00:00','2014-04-24 10:51:19','2022-09-23 17:24:38'),
(661,'EnergieSchweiz','SuisseEnergie',NULL,NULL,NULL,NULL,0,0,'Ittigen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','nie',31,NULL,NULL,'http://www.energieschweiz.ch',NULL,NULL,'energieschweiz',NULL,'EnergieSchweiz','https://www.linkedin.com/company/energieschweiz/',NULL,'Im Bereich der Energieeffizienz und der erneuerbaren Energien spielen verschiedene Akteure eine wichtige Rolle: Bund, Kantone, Gemeinden, Unternehmen unterschiedlicher Branchen, Umwelt- und Konsumentenorganisationen sowie natürlich die Schweizer Bevölkerung. EnergieSchweiz ist die zentrale Plattform, welche die unterschiedlichen Akteure informiert, sensibilisiert, vernetzt, koordiniert und den Know-how Austausch unterstützt. EnergieSchweiz wird operativ vom Bundesamt für Energie geleitet. EnergieSchweiz finanziert und begleitet Projekte von Partnern aus dem öffentlichen Sektor und der Privatwirtschaft, die die Massnahmen gemäss dem "Detailkonzept EnergieSchweiz 2013-2020" unterstützen.','Dans le domaine de l''efficacité énergétique et des énergies renouvelables, différents acteurs jouent un rôle important : la Confédération, les cantons, les communes, les entreprises de différentes branches, les organisations environnementales et de consommateurs et, bien sûr, la population suisse. SuisseEnergie est la plate-forme centrale qui informe, sensibilise, met en réseau et coordonne les différents acteurs et soutient l''échange de savoir-faire. SuisseEnergie est dirigé opérationnellement par l''Office fédéral de l''énergie. SuisseEnergie finance et accompagne des projets de partenaires du secteur public et de l''économie privée qui soutiennent les mesures prévues dans le " Concept détaillé SuisseEnergie 2013-2020 ".',NULL,'3063',NULL,NULL,NULL,NULL,'2022-09-23 00:00:00','2014-04-24 11:35:20','2024-11-05 14:40:00'),
(662,'QualiCCare',NULL,NULL,'CHE-351.899.293',NULL,NULL,0,0,'Baden',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',6,NULL,NULL,'http://www.qualiccare.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein QualiCCare setzt sich dafür ein, die Patientenbetreuung in der Schweiz durch die Implementierung von "Best Practices" in der Versorgung von chronischen Krankheiten weiter zu verbessern.','L''association QualiCCare s''engage pour continuer à améliorer la prise en charge des patients en Suisse en mettant en œuvre les bonnes pratiques (" Best practices ") de suivi des maladies chroniques.',NULL,'5400',4021,NULL,NULL,NULL,'2022-10-16 00:00:00','2014-04-24 15:35:48','2022-10-16 19:53:58'),
(663,'Association suisse pour l''Evaluation d''Impact sur la Santé en liquidation','Association suisse pour l''Evaluation d''Impact sur la Santé','Associazione svizzera per la Valutazione d''Impatto sulla Salute','CHE-391.941.323',1132984,'CH55011032071',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',8,NULL,NULL,'http://www.impactsante.ch','http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-1103207-1&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Les buts de l''association sont de développer et mettre à disposition des collectivités publiques suisses un outil d''aide à la décision appelé Evaluation d''Impact sur la Santé (EIS) destiné à intégrer la promotion de la santé dans les processus de décision dans une perspective de développement durable; mettre en commun, capitaliser et valoriser les savoirs et les connaissances des cantons et d''autres partenaires suisses ou étrangers afin de promouvoir l''introduction de l''EIS dans la pratique des administrations publiques; inscrire les EIS dans les priorités des agendas politiques des collectivités publiques; mettre en synergie ces EIS avec les autres outils d''aide à la décision développés à différents niveaux institutionnels (pour but complet cf. statuts).',NULL,NULL,'1003',5586,NULL,NULL,NULL,'2019-09-12 15:53:22','2014-04-24 15:52:03','2024-04-28 10:36:59'),
(664,'Equiterre',NULL,NULL,NULL,NULL,NULL,0,0,'Genève',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',54,NULL,NULL,'www.equiterre.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die vor 40 Jahren gegründete Organisation equiterre (damals: Schweizerische Gesellschaft für Umweltschutz/SGU) - berät und begleitet die sich stets vermehrenden öffentlichen Gemeinschaften und Unternehmen auf dem Weg zur nachhaltigen Entwicklung.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-04-24 16:01:22','2014-09-16 00:00:00'),
(665,'Gesundheitsförderung Schweiz','Promotion Santé Suisse','Promozione Salute Svizzera','CHE-110.227.132',288374,'CH55000952559',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',3,NULL,NULL,'http://www.gesundheitsförderung.ch','http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-0095255-9&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Wir sind eine privatrechtliche Stiftung, die von Kantonen und Versicherern getragen wird. Mit gesetzlichem Auftrag initiieren, koordinieren und evaluieren wir Massnahmen zur Förderung der Gesundheit und zur Verhütung von Krankheiten.',NULL,NULL,'1003',5586,NULL,NULL,NULL,'2022-11-11 00:00:00','2014-04-24 16:14:21','2024-04-28 10:36:59'),
(666,'European Federation of Pharmaceutical Industries and Associations (EFPIA)',NULL,NULL,NULL,NULL,NULL,0,0,'Brüssel',NULL,NULL,NULL,NULL,NULL,NULL,191,5,'AG',NULL,NULL,'DachOrganisation,dezidierteLobby','nie',1,NULL,NULL,'http://www.efpia.eu/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Europäischer Dachverband der nationalen Verbänder der forschenden Pharmaunternehmen.\nEFPIA brings together 33 European national pharmaceutical industry associations as well as 40 leading companies undertaking research, development and the manufacture in Europe of medicinal products for human use.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:03:50','2014-04-24 20:51:37','2021-01-03 08:52:54'),
(667,'Association of International Pharmaceutical Manufacturers',NULL,NULL,'CHE-103.580.310',394354,'CH02060003144',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,4,'Verein','0109',6,'DachOrganisation,dezidierteLobby','nie',1,NULL,NULL,'http://www.ifpma.org/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000314&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Gesellschaft bezweckt die Beratung, Vermarktung und Erbringung von Dienstleistungen im In- und Ausland vor allem im Zusammenhang mit der Vermögensverwaltung und -Dienstleistungen, einschliesslich der Tätigkeit als Vermögensverwalterin kollektiver Kapitalanlagen und Vertreterin für ausländische kollektive Kapitalanlagen nach Massgabe der Kollektivanlagengesetzgebung, sowie den Erwerb und die Veräusserungen, vor allem aber das dauernde Halten von Beteiligungen an anderen Unternehmen im In- und Ausland, insbesondere im Bereich Finanzdienstleistungen. Die Gesellschaft kann Anleihen aufnehmen, gewerbliche Schutzrechte und Know-how erwerben, entwickeln, verwerten und veräussern. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im In- und Ausland errichten. Sie kann Grundstücke erwerben, halten und veräussern. Die Gesellschaft kann alle kommerziellen, finanziellen und anderen Tätigkeiten ausüben, welche mit dem Zweck der Gesellschaft direkt oder indirekt im Zusammenhang stehen.',NULL,NULL,'8002',261,NULL,NULL,NULL,'2016-03-18 11:03:50','2014-04-24 21:08:59','2024-11-08 05:08:51'),
(668,'SwissHTA; Value & Valuation of Health Technologies',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',3,NULL,NULL,'http://www.swisshta.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'a joint project of santésuisse (national association of sick funds), the Swiss Medical Association, the Swiss Academy of Medical Sciences, and Interpharma on development of HTA in Switzerland.\nHTA=Health Technology Assessments\nAngesichts der steigenden Gesundheitsausgaben und den leistungsfähigen, aber unter Umständen auch kostenintensiven medizinischen "Technologien" ist "Value for Money" eine berechtigte Forderung. Auch vor dem Hintergrund der demographischen Entwicklung besteht die Notwendigkeit einer systematischen Bewertung von Kosten und Nutzens medizinischer Verfahren, um ihren wirtschaftlichen und effizienten Einsatz sicherzustellen.\n\nZu diesem Zweck haben sich im Ausland sogenannte Health Technology Assessments (HTAs) entwickelt, deren Einsatz auch in der Schweiz zur Diskussion steht. HTAs beinhalten gesundheitsökonomische Evaluationen und berücksichtigen zusätzlich rechtliche, ethische und soziale Aspekte. Ihre Komplexität und ihr Ressourcenbedarf sind jedoch hoch.\n\nFür die Schweiz sollen deshalb Eckwerte für einen pragmatischen und handhabbaren Bewertungsprozess sowie wissenschaftlich fundierte Leitplanken definiert werden. Im Hinblick auf die Akzeptanz bei den Akteuren im Gesundheitswesen und den Bürgern ist auch dem institutionellen Rahmen eines HTA-Prozesses besondere Beachtung zu schenken.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:03:50','2014-04-24 21:19:41','2021-01-03 08:52:54'),
(669,'Schweizer Tourismus-Verband','Fédération suisse du tourisme FST','Federazione svizzera del tourismo FST','CHE-107.813.393',NULL,NULL,0,0,'Bern','STV',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',60,NULL,NULL,'http://www.swisstourfed.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Als Dachverband vertritt der STV die Interessen seiner über 600 Mitglieder gegenüber Politik, Behörden und Öffentlichkeit. Er fördert Qualität und Innovation im Tourismus: durch Bildung, Labels und Vernetzung.','En tant qu''association faîtière, la FST défend les intérêts de ses quelque 600 membres vis-à-vis de la politique, des autorités et du public. Elle encourage la qualité et l''innovation dans le tourisme par la formation, l''octroi de labels et la constitution de réseaux.',NULL,'3012',351,NULL,NULL,NULL,'2025-09-22 16:24:18','2014-04-24 22:26:42','2025-09-22 16:24:18'),
(670,'Grün 19',NULL,NULL,NULL,NULL,NULL,0,0,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','nie',93,NULL,NULL,'http://gruen19.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Nationales, "grünes" Ausstellungsformat mit internationaler Ausstrahlung: Mit der Gründung des breit abgestützten Vereins "GRÜN 18" soll die Basis für eine erfolgreiche Planung und Umsetzung einer Grossveranstaltung zur Auseinandersetzung mit zukunftsrelevanten Themenfeldern wie Energie und Klima, Ökologie und Technologie, Lebensraum und Raumplanung, Natur, Landwirtschaft, Ernährung sowie Wald und Landschaft geschaffen werden.',NULL,NULL,'3005',NULL,NULL,NULL,NULL,'2020-03-07 10:47:23','2014-04-24 22:38:38','2021-01-03 08:52:54'),
(671,'Eidgenössische Hochschule für Sport EHSM','Haute école fédérale de sport de Macolin HEFSM','Scuola universitaria federale dello sport di Macolin SUFSM',NULL,NULL,NULL,0,0,'Magglingen',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Staatlich',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',89,41,NULL,'http://www.baspo.admin.ch/internet/baspo/de/home/ehsm.html',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Eidgenössische Hochschule für Sport Magglingen EHSM befasst sich als einzige Schweizer Hochschule ausschliesslich mit Ausbildung, Forschung, Entwicklung und Dienstleistung im Bereich Sport.','La Haute école fédérale de sport de Macolin HEFSM est la seule haute école suisse à se consacrer exclusivement à la formation, à la recherche, au développement et aux prestations de services dans le domaine du sport.',NULL,NULL,NULL,'https://de.wikipedia.org/wiki/Eidgen%C3%B6ssische_Hochschule_f%C3%BCr_Sport_Magglingen','Q33121317',NULL,'2021-01-25 14:52:29','2014-04-24 22:48:17','2024-04-26 07:38:23'),
(672,'OK Tage der Aerophilatelie 2014',NULL,NULL,NULL,NULL,NULL,0,0,'Biel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation','nie',44,NULL,NULL,'http://www.sav-aerophilatelie.ch/tag-e-der-aerophilatelie/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Tage der Aerophilatelie 2014 finden am 14./15. Juni 2014 auf dem Flugplatz Biel-Kappelen statt. Unter dem Patronat des SAV organisiert der Philatelistenverein Biel den Anlass. Der Verein feiert 2014 sein 125-jähriges Bestehen. Herzliche Gratulation! Gleichzeitig werden weitere Jubiläen gefeiert: über 100 Jahre Flugwesen in Biel, 45 Jahre Flugplatz Biel-Kappelen und 85 Jahre der Flugverbindung Bern-Biel-Basel. Es wird ein Anlass mit einigen Überraschungen! Bitte merken Sie sich jetzt schon die Termine vor.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-09-16 13:55:37','2014-04-24 22:53:50','2016-09-16 13:55:37'),
(673,'Coop-Gruppe Genossenschaft','Groupe Coop Société Coopérative','Gruppo Coop Società Cooperativa','CHE-109.029.938',38909,'CH55000455269',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',92,NULL,NULL,NULL,'http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=5500045526&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,'https://www.linkedin.com/company/coop_2/',NULL,'Die Coop Genossenschaft gehört zu den grössten Detailhandels- und Grosshandelsunternehmen der Schweiz. Sie ist als Genossenschaft mit rund 2,5 Millionen Mitgliedern organisiert.','La société coopérative Coop fait partie des plus grandes entreprises de commerce de détail et de gros de Suisse. Elle est organisée sous forme de coopérative et compte environ 2,5 millions de membres.',NULL,'4053',2701,'https://de.wikipedia.org/wiki/Coop_(Schweiz)','Q432564',NULL,'2024-12-17 11:43:51','2014-04-24 23:13:18','2024-12-17 11:43:51'),
(674,'Schweizerische Energie-Stiftung','Fondation Suisse de l''Energie','Fondazione Svizzera dell''Energia','CHE-107.895.474',292932,'CH02079036408',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',32,131,NULL,'http://www.energiestiftung.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207903640&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','energiestiftung',NULL,NULL,NULL,NULL,NULL,'Die SES ist 1976 als Stiftung gegründet worden und engagiert sich seither für eine intelligente, umwelt- und menschengerechte Energiepolitik. Diese orientiert sich an der 2000-Watt-Gesellschaft.\n\nDie SES setzt sich für den effizienten Einsatz von Energie und die Förderung und Nutzung erneuerbarer Energiequellen ein. Die SES zeigt Wege auf, wie sich die Schweiz aus der verhängnisvollen Abhängigkeit einer fossil-atomaren Energieversorgung lösen kann.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2025-08-20 20:54:33','2014-04-24 23:18:48','2025-08-20 20:54:33'),
(675,'Syna',NULL,NULL,'CHE-106.841.501',456748,'CH02060004435',1,1,'Olten',NULL,'Syna - die Gewerkschaft',NULL,'Syna - le syndicat',NULL,'Syna - il sindacato',191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',53,NULL,NULL,'https://syna.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206000443&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','syna_ch','synadiegewerkschaft','synadiegewerkschaft2967','synadiegewerkschaft','https://www.linkedin.com/company/syna-ch',NULL,'Syna ist eine interprofessionelle Schweizer Gewerkschaft, die in den Sektoren Industrie, Gewerbe und Dienstleistung tätig ist und ca. 60 000 Mitglieder hat.','Syna est un syndicat interprofessionnel suisse actif dans les secteurs de l''industrie, de l''artisanat et des services et qui compte environ 60 000 membres.',NULL,'4600',2581,NULL,NULL,NULL,'2025-08-29 13:55:57','2014-04-24 23:25:01','2025-08-29 13:55:57'),
(676,'Hotel & Gastro Union',NULL,NULL,'CHE-105.802.970',148490,'CH10060125659',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',60,NULL,NULL,'http://www.hotelgastrounion.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NETZWERK\nAls Profi, der mit Leib und Seele seinen Beruf ausübt, treffen Sie bei uns auf Ihresgleichen. Als Mitglied sind Sie in der Branche vernetzt. Nutzen Sie das berufliche und gesellschaftliche Netzwerk:\n\n    an Anlässen der Berufsverbände und der Hotel & Gastro Union\n    an Anlässen der einzelnen Regionen der Hotel & Gastro Union\n    mit regionalen Netzwerken\n\nRECHTSBERATUNG\nIm Fall der Fälle - Die Hotel & Gastro Union und ihre fünf Berufsverbände unterstützen Sie falls nötig auch rechtlich:',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2025-07-02 11:32:08','2014-04-24 23:34:39','2025-07-02 11:32:08'),
(677,'Schweizerische Lebensrettungs-Gesellschaft SLRG','Société suisse de sauvetage SSS','Società svizzera di salvataggio SSS','CHE-100.812.955',1280780,'CH10068027364',1,1,'Sursee',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,LeistungsErbringer','nie',89,NULL,NULL,'www.slrg.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'In der Schweiz sollen alle Menschen ihren Aufenthalt und ihre Aktivitäten im und um das Wasser unbeschwert und verantwortungsbewusst geniessen können.\n\n\nUm dies zu ermöglichen, unterhält die Schweizerische Lebensrettungs-Gesellschaft SLRG ein qualitativ hochstehendes und kundenorientiertes Leistungsangebot in den Bereichen Information, Prävention, Ausbildung, Rettung und Rettungssport. Ihre Tätigkeit macht die SLRG zur führenden gemeinnützigen Organisation auf dem Gebiet der Wassersicherheit und Wasserrettung in der Schweiz. Rettungsschwimmerinnen und -schwimmer haben Vorbildcharakter und geniessen den Respekt der Bevölkerung.\n\nAls nationale Organisation von Freiwilligen und Ehrenamtlichen mit einer regionalen Struktur und selbständigen, lokalen Sektionen ist die SLRG für alle interessierten Menschen offen. Sie ergänzt die Leistungen hauptberuflicher Rettungsdienste landesweit.',NULL,NULL,'6210',1095,NULL,NULL,NULL,'2020-07-02 23:02:50','2014-04-24 23:42:15','2024-04-28 10:36:59'),
(678,'IG Detailhandel Schweiz','Communauté d''intérêt du commerce de détail suisse (CI CDS)',NULL,'CHE-169.739.593',NULL,NULL,0,0,'Basel','IG DHS',NULL,NULL,NULL,NULL,NULL,191,1,'Einfache Gesellschaft','0302',NULL,'DachOrganisation,LeistungsErbringer','punktuell',92,NULL,NULL,'http://www.igdhs.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Interessengemeinschaft Detailhandel Schweiz (IG DHS) wurde 2006 gründet. Sie bringt die gemeinsamen Interessen der Schweizer Unternehmen Migros, Coop, Manor, Valora, Denner und Charles Vögele in den politischen Meinungsbildungsprozess ein.',NULL,NULL,'4053',2701,NULL,NULL,NULL,'2023-03-16 14:22:21','2014-04-24 23:48:02','2023-03-16 14:22:21'),
(679,'Foundation - Global Risk Forum GRF Davos in Liquidation',NULL,NULL,'CHE-114.620.712',929153,'CH35070009055',1,1,'Davos Platz','GRF',NULL,NULL,NULL,NULL,NULL,191,4,'Stiftung','0110',7,'EinzelOrganisation','nie',91,NULL,NULL,'www.grforum.org','http://gr.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3507000905&amt=350&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'The Global Risk Forum GRF Davos promotes the worldwide exchange of know-how and expertise, creates solutions and fosters good practices in integrative risk management and climate change adaptation. Aiming for an improved understanding, assessment and management of disasters and risks that affect human safety, security, health, the environment, critical infrastructures, the economy and society at large.',NULL,NULL,'7270',3851,NULL,NULL,NULL,'2020-07-02 23:02:50','2014-04-24 23:58:13','2024-04-28 10:36:59'),
(680,'Stiftung RoadCross Schweiz','Fondation RoadCross Suisse','Fondazione RoadCross Svizzera','CHE-112.505.201',801994,'CH02070012733',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',90,NULL,NULL,'http://www.roadcross.ch/site/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001273&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Die Stiftung bezweckt Prävention und Bewältigung von Unfällen und von Schädigungen durch den Strassenverkehr. Ziele sind: 1. Die Hebung der Verkehrssicherheit. 2. Die Förderung einer gesunden und massvollen Entwicklung des Strassenverkehrs. 3. Die Verminderung der Anzahl der Opfer und Geschädigten des Strassenverkehrs. 4. Beratung und Unterstützung der Opfer und ihrer Angehörigen. Zur Erreichung dieser Ziele kann die Stiftung verschiedenste ihr geeignet erscheinende Mittel ergreifen und Massnahmen fördern. Die Stiftung kann Kooperationen eingehen und auch für das Ausland wirksam werden.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2020-07-02 23:02:50','2014-04-25 00:02:36','2024-04-28 10:36:59'),
(681,'Die Mitte Kanton Zürich','Le Centre Canton Zurich',NULL,NULL,NULL,NULL,0,0,'Zürich','Die Mitte ZH','CVP Christlichdemokratische Volkspartei Kanton Zürich','Le Centre ZH','PDC Parti démocrate-chrétien du canton de Zurich',NULL,NULL,191,2,'Verein',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','punktuell',20,NULL,NULL,'https://zh.die-mitte.ch/',NULL,'DieMitte_ZH','diemittezh',NULL,'DieMitteZH',NULL,NULL,'Es handelt sich um die Kantonalpartei der "Mitte Schweiz".','Il s''agit du parti cantonal du "Centre Suisse".',NULL,'8002',NULL,NULL,NULL,NULL,'2025-08-20 20:54:33','2014-04-25 14:20:08','2025-08-20 20:54:34'),
(682,'Verein Zusammenschluss Oberlandstrasse',NULL,NULL,NULL,NULL,NULL,0,0,'Bauma',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',26,NULL,NULL,'http://www.oberlandstrasse.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Verein "Zusammenschluss Oberlandstrasse" wurde am 11. Juni 1999 gegründet. Hauptziel des Vereins ZOS ist das Engagement für eine rasche Realisierung der Oberlandautobahn - ein Projekt, welches für die Bevölkerung und die Wirtschaft im Zürcher Oberland von hoher Bedeutung ist.\n\nDer Verein ZOS vermittelt, informiert und koordiniert als Bindeglied zwischen Bevölkerung, Politik und Projektierungsorganen. Er will die Entscheidungsträger während der Projektierung und Realisierung der Oberlandautobahn begleiten und die Anliegen der Anwohner und des Gewerbes vertreten.','L''association "Zusammenschluss Oberlandstrasse" a été fondée le 11 juin 1999. L''objectif principal de l''association ZOS est de s''engager pour une réalisation rapide de l''autoroute de l''Oberland - un projet qui revêt une grande importance pour la population et l''économie de l''Oberland zurichois.\n\nL''association ZOS sert d''intermédiaire, informe et coordonne en tant que lien entre la population, la politique et les organes de planification du projet. Elle veut accompagner les décideurs pendant l''élaboration du projet et la réalisation de l''autoroute de l''Oberland et défendre les intérêts des riverains et des commerçants.',NULL,'8494',NULL,NULL,NULL,NULL,'2025-09-08 18:25:35','2014-04-25 14:28:27','2025-09-08 18:25:35'),
(683,'Haflingerverein Nordostschweiz (HNO)',NULL,NULL,NULL,NULL,NULL,0,0,'Turbenthal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',86,NULL,NULL,'http://www.haflinger-no.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Haflingerverein bezweckt:\n• die Förderung der Haflingerpferdezucht\n• die Vermarktung\n• die Ausbildung\n• die Förderung der Freizeitaktivitäten und des Sports\n• die Pflege der Kameradschaft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-25 14:41:50','2021-01-03 08:52:54'),
(684,'Panathlon Club Winterthur',NULL,NULL,NULL,NULL,NULL,0,0,'Winterthur',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation','nie',66,NULL,NULL,'http://www.winterthur.panathlon.ch/de/ueberuns/default.asp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Begriff "Panathlon" stammt aus dem Griechischen und ist mit dem Ausdruck "Gesamtheit aller Sportdisziplinen" zu übersetzen; sein Leitspruch "Ludis iungit" bedeutet "vereint durch den Sport".\n\nDie Panathlonbewegung bezweckt die Verbreitung der Sportidee mit ihren moralischen und kulturellen Werten als Mittel für die harmonische Entwicklung der Menschen und der Solidarität unter den Völkern.\nIm weiteren pflegt die Panathlonbewegung die Freundschaft unter allen Panathleten und Personen, die im Sportleben tätig sind. Die Förderung des Fairplay-Gedankens, Tätigkeiten im Jugend- und Schulbereich sowie im Kultur-, Sport- und Sozialwesen gehören ebenso zu den Zielsetzungen wie die Unterstützuzng der olympischen Bewegung.',NULL,NULL,'8400',NULL,NULL,NULL,NULL,'2017-07-20 21:49:39','2014-04-25 21:27:46','2021-01-03 08:52:54'),
(686,'Allianz Schweizer Krankenversicherer in Liquidation','Alliance des assureurs maladie suisses AAMS','Unione degli assicuratori malattia svizzeri','CHE-448.351.724',1032717,'CH03660517975',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,dezidierteLobby','punktuell',2,NULL,NULL,'http://www.ask-aams.ch/index.php/de/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0366051797&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Allianz Schweizer Krankenversicherer wahrt und vertritt die Interessen seiner Mitglieder in den Geschäftsbereichen Krankenversicherung, Unfallversicherung, Taggeld und Zusatzversicherungen. Sie ist im Bereich von Branchenstandards, in Branchenprojekten und in der Branchenpolitik aktiv. Die Allianz vertritt hierbei eine liberale Wettbewerbsordnung, welche auf den Postulaten klarer Handlungsspielräume und Verantwortlichkeiten, zurückhaltender und berechenbarer Regulierung, hoher Selbstverantwortung und wettbewerblicher Ausgestaltung des Gesundheitswesens basiert. Die Allianz will ihre Positionen mit einer hohen Verbindlichkeit und Verlässlichkeit vertreten und die politischen und branchenbezogenen Prozesse effizient, professionell und pragmatisch mitgestalten. Die Allianz Schweizer Krankenversicherer unternimmt in der ganzen Schweiz alles Notwendige, um die in den Statuten formulierten Grundsätze und Zielsetzungen umzusetzen. Die Allianz engagiert sich vorab im Rahmen von Vernehmlassungen, Gesetzgebungsprozessen, Öffentlichkeitsarbeit und relevanten Branchenprojekten. Adressaten sind Politik, Öffentlichkeit, Aufsicht und Behörden.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-26 14:10:54','2024-04-28 10:36:59'),
(687,'Schweizerischer Verband für Gemeinschaftsaufgaben der Krankenversicherer (SVK)','Fédération usisse pour tâches communes des assureurs-maladie','Federazione svizzera per compiti communitari degli assicuratori malattia','CHE-108.088.915',396180,'CH26060000246',1,1,'Solothurn','SVK',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',2,NULL,NULL,'http://www.svk.org','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2606000024&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Wahrnehmung von folgenden Gemeinschaftsaufgaben: Durchführung der Versicherung für besondere Leistungen (VBL), Bewirtschaftung von Hilfsmitteln, Führung der IV-Koordination, Durchführung der privatrechtlichen internationalen Leistungsaushilfe sowie weitere vom Verwaltungsrat übertragene Aufgaben.',NULL,NULL,'4502',2601,NULL,NULL,NULL,'2022-11-11 00:00:00','2014-04-26 14:22:02','2024-04-28 10:36:59'),
(688,'CLINIQUE LE NOIRMONT SOCIETE COOPERATIVE',NULL,NULL,'CHE-107.920.913',32993,'CH67450000222',1,1,'Le Noirmont',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation','nie',5,NULL,NULL,'http://www.clinique-le-noirmont.ch/fr/la-clinique/presentation/','http://ju.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=6745000022&amt=670&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Création et exploitation de la Clinique Le Noirmont offrant des prestations et services de réadaptation médicale, en particulier cardio-vasculaire. La société jouit du statut hospitalier selon l''art. 39 de la loi fédérale sur l''assurance-maladie (LAMal). Elle a également pour but l''exploitation d''un restaurant dans ses locaux (cf. statuts pour but complet).',NULL,NULL,'2340',6754,NULL,NULL,NULL,'2020-03-27 13:11:13','2014-04-26 14:39:29','2024-04-28 10:36:59'),
(689,'tarifsuisse ag',NULL,NULL,'CHE-115.652.100',980314,'CH24130091716',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation','punktuell',2,NULL,NULL,'https://tarifsuisse.ch/','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2413009171&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'tarifsuisse ag ist eine Tochtergesellschaft von santésuisse. tarifsuisse ag ist mit 47 angeschlossenen Krankenversicherern und im schweizerischen Durchschnitt ca. 75 % Marktanteil die grösste Leistungseinkäuferin im KVG-Bereich.\n\n\n    tarifsuisse ag nutzt Synergievorteile, indem die Fixkosten für Tarifentwicklung, Tarifmanagement sowie Tarifcontrolling auf viele Versicherer verteilt werden können.\n\n\n    tarifsuisse ag ist der kompetente Ansprechpartner für Leistungserbringer und politische Behörden.\n\n\n    tarifsuisse ag erreicht für die Versicherten dank Verhandlungsmacht günstige Leistungen bei guter Qualität.\n\n\n    tarifsuisse ag gestaltet dank eingespielten Prozessen und fundiertem Know-how der Mitarbeitenden die grossen Veränderungen im KVG-Bereich, z.B. neue Pflege- und Spitalfinanzierung, aktiv mit.',NULL,NULL,'4502',2601,NULL,NULL,NULL,'2022-11-11 00:00:00','2014-04-26 14:44:51','2024-04-28 10:36:59'),
(690,'SASIS AG',NULL,NULL,'CHE-114.617.288',928993,'CH24130079389',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',2,NULL,NULL,'www.sasis.ch','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2413007938&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Entwicklung, Betrieb und Vertrieb von elektronischen Branchen-Applikationen der schweizerischen Krankenversicherer im Bereich der Statistik, der Leistungserbringer-Verzeichnisse, der Tarifvertrags-Verzeichnisse und der Versichertenkarten. Kann Referenzdaten und übrige Dienstleistungen zur Förderung des elektronischen Datenaustauschs zwischen Krankenversichern und Leistungserbringern bewirtschaften und anbieten, ihre Produkte und Dienstleistungen dem Branchenverband, den Krankenversicherern und Dritten anbieten, Zweigniederlassungen im In- und Ausland errichten und sich an anderen Unternehmen beteiligen oder sich mit diesen zusammenschliessen, ferner Grundstücke erwerben und veräussern sowie alle Geschäfte eingehen und Verträge abschliessen, die geeignet sind, den Zweck der Gesellschaft zu fördern, oder die direkt oder indirekt damit im Zusammenhang stehen.',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2022-11-11 00:00:00','2014-04-26 14:51:01','2024-04-28 10:36:59'),
(691,'Stiftung zur Förderung besonderer gemeinschaftlicher Aufgaben der sozialen Krankenversicherung',NULL,NULL,'CHE-100.658.252',295169,'CH26070000951',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',2,NULL,NULL,NULL,'http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2607000095&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung besonderer gemeinschaftlicher Aufgaben der sozialen Krankenversicherung der Schweiz, wie: Förderung der Kranken- und Unfallversicherung; Gewährung von Beiträgen an die Errichtung, Erweiterung und den Betrieb von den Krankenversicherern nahestehenden Instituten und Heilanstalten sowie Leistungen an die Behandlung besonders kostspieliger Krankheiten und Unfällen oder Krankheits- und Unfallfolgen; Gewährung von Beiträgen für die Anschaffung besonderer medizinischer Geräte und Apparate; Gewährung von Beiträgen an gemeinsame Aufwendungen der Krankenkassen für die Ausbildung, Information und Werbung.\nOrganisation: Stiftungsrat bestehend aus dem gemäss den Statuten von "santésuisse" gewählten Verwaltungsrat und Kontrollstelle.',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2023-07-21 15:20:56','2014-04-26 14:57:11','2024-04-28 10:36:59'),
(692,'Medidata AG',NULL,NULL,'CHE-107.618.934',337947,'CH10030168187',1,1,'Root D4',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',88,NULL,NULL,'https://www.medidata.ch/md/web/de/','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003016818&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung und Vereinfachung des Informationsaustausches im Gesundheitswesen (Kostengutsprachen, Rechnungen, Leistungsdaten etc.) zwischen den Leistungsträgern einerseits und den Leistungserbringern andererseits mit organisatorischen und technischen Massnahmen.','Promotion et simplification de l''échange d''informations dans le système de soins de santé (crédits de coûts, factures, données sur les services, etc.) entre les prestataires de services, d''une part, et les prestataires de services, d''autre part, par des mesures organisationnelles et techniques.',NULL,'6039',1065,NULL,NULL,NULL,'2022-11-11 00:00:00','2014-04-26 15:01:58','2024-04-28 10:36:59'),
(693,'CAVO-Stiftung',NULL,NULL,'CHE-110.263.903',266511,'CH44070028477',1,1,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',84,NULL,NULL,NULL,'http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=4407002847&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung bezweckt im Interesse der Allgemeinheit die Förderung aller Bestrebungen zur Hebung des schweizerischen Obstbaues sowie der alkoholfreien Verwertung von Obstprodukten und insbesondere auch die Unterstützung von Fachschulen und der beruflichen Ausbildung auf dem Gebiet des Obstbaues und der alkoholfreien Obstverwertung.',NULL,NULL,'6300',1711,NULL,NULL,NULL,'2016-03-18 11:06:40','2014-04-28 14:37:11','2024-04-28 10:36:59'),
(694,'Kernkraftwerk Gösgen-Däniken AG',NULL,NULL,'CHE-101.926.521',98296,'CH24930004181',1,1,'Däniken SO',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',30,29,NULL,'http://www.kkg.ch/de/i/intro.html;jsessionid=5B75BFE8B40B05A548BD8D449EEEB11F','http://so.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2493000418&amt=241&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Bau und Betrieb einer Anlage für die Nutzung der Kernenergie zur Erzeugung von elektrischer Energie sowie Wärme und radioaktiven Stoffen am Standort Däniken unter Einschluss des Umganges mit nuklearen Gütern sowie der Konditionierung und Zwischenlagerung von radioaktiven Stoffen und Abfällen. Kann alle Massnahmen treffen, um dieses Ziel zu erreichen, insbesondere die notwendigen Bewilligungen und Konzessionen einholen bzw. erwerben und anwenden sowie die entsprechenden Immobiliengeschäfte tätigen, ferner sich an Unternehmungen der Energiewirtschaft beteiligen.',NULL,NULL,'4658',2572,NULL,NULL,NULL,'2023-08-27 21:42:07','2014-04-28 15:06:22','2024-11-29 05:09:05'),
(695,'Connecta, Integration geistig Behinderter im Arbeitsmarkt',NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-07-27 21:03:43','2014-04-28 15:15:16','2019-07-27 21:03:43'),
(696,'Leichtathletik Club Zug',NULL,NULL,NULL,NULL,NULL,0,0,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',65,NULL,NULL,'http://www.lkz.ch/la/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-07-27 21:03:43','2014-04-28 15:18:12','2019-07-27 21:03:43'),
(697,'Orientierungslauf-Vereinigung Zug (OLV Zug)',NULL,NULL,NULL,NULL,NULL,0,0,'Zug',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',65,NULL,NULL,'http://www.olv-zug.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Die Orientierungslauf-Vereinigung Zug (OLV Zug) ist einer der grössten Orientierungslaufvereine der Schweiz. Das Ziel des Vereins ist die Förderung des OL- Sportes im Kanton Zug und den angrenzenden Gebieten. Der Verein wurde im Jahre 1972 gegründet und umfasst heute knapp 300 Mitglieder im Alter zwischen 3 und 80 Jahren.',NULL,NULL,'6312',NULL,NULL,NULL,NULL,'2023-07-09 10:43:31','2014-04-28 15:22:06','2023-07-09 10:43:31'),
(698,'Rotary Club Ägeri-Menzingen',NULL,NULL,NULL,NULL,NULL,0,0,'Unterägeri',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Verein',NULL,NULL,'EinzelOrganisation,LeistungsErbringer','nie',146,12,NULL,'http://www.rc-aegeri-menzingen.ch/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Gegründet 	12. März 1976 	  	Mitglieder 	54',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-07-27 21:03:43','2014-04-28 15:27:53','2019-07-27 21:03:43'),
(699,'Schweizer Weinhandelskontrolle','Contrôle suisse du commerce des vins','Controllo svizzero del commercio dei vini','CHE-114.641.068',930881,'CH02070015724',1,1,'Dübendorf',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',82,NULL,NULL,'http://www.cscv-swk.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001572&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung gewährleistet die Erfüllung der ihr durch die Schweizerische Eidgenossenschaft übertragenen Aufgaben im Bereich alkoholischer und nichtalkoholischer Erzeugnisse wie: a) die Durchführung der Kontrolle des Handels mit Wein im Sinne des Landwirtschaftsrechts; b) die Erstattung von Anzeigen bei der Feststellung eines Offizialdelikts; c) die Einhaltung der internationalen Verpflichtungen der Schweiz beim Handel mit Wein; d) den Schutz der Konsumenten.',NULL,NULL,'8600',191,NULL,NULL,NULL,'2016-09-06 14:34:49','2014-04-29 08:21:59','2024-04-28 10:36:59'),
(700,'Schweizerische Mobiliar Genossenschaft',NULL,NULL,'CHE-101.151.642',166159,'CH03550028435',1,1,'Bern',NULL,'Die Mobiliar',NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','nie',57,NULL,NULL,'http://www.mobi.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0355002843&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Förderung der direkten Versicherung auf genossenschaftlicher Grundlage. Sie verfolgt diesen Zweck dadurch, dass sie sich an entsprechenden Unternehmen beteiligt; sie kann sich an anderen Unternehmen beteiligen, einschliesslich solchen, die das Rückversicherungsgeschäft betreiben.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2025-07-15 00:00:00','2014-04-30 15:30:39','2025-07-15 13:08:38'),
(701,'Stiftung Technopark Zürich',NULL,NULL,'CHE-106.388.275',297030,'CH02079045499',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',23,NULL,NULL,'http://www.technopark.ch/start.cfm?p=60&s=620','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207904549&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung des Technologietransfers, insbesondere Erarbeiten und Vermitteln neuer wissenschaftlicher technischer Erkenntnisse und deren Umsetzung zur Steigerung von Produktivität und Wettbewerbsfähigkeit, sowie Unterstützung neuer Unternehmungen und Unternehmensbereiche und Beratung zu wissenschaftlichen, technischen und unternehmerischen Fragen.',NULL,NULL,'8005',261,NULL,NULL,NULL,'2023-08-28 14:37:23','2014-04-30 15:35:52','2024-04-28 10:36:59'),
(702,'media f imprimerie SA',NULL,NULL,'CHE-389.109.700',1061495,'CH21735503164',1,1,'Bulle',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',47,NULL,NULL,'http://www.media-f.ch/','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-3550316-4&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'exploitation d''une agence média spécialisée dans la stratégie, la planification, le conseil, la commercialisation d''espaces publicitaires et l''achat de budgets médias directement ou par la participation à d''autres sociétés (cf. statuts pour but complet).',NULL,NULL,'1630',2125,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 08:32:23','2024-04-28 10:36:59'),
(703,'Pensionskasse des Interkantonalen Rückversicherungsverbandes in Liquidation',NULL,NULL,'CHE-110.378.239',277307,'CH03570160630',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',42,NULL,NULL,'http://www.irv.ch/','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0357016063&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Berufliche Vorsorge im Rahmen des BVG und seiner Ausführungsbestimmungen für die Arbeitnehmer des Verbandes usw.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 08:41:55','2024-04-28 10:36:59'),
(704,'JPF Gravières SA',NULL,NULL,'CHE-106.842.989',462540,'CH21704315336',1,1,'Bulle','JPF',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation','nie',51,NULL,NULL,'jpf.ch','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0431533-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: exploiter des gravières de tous genres, notamment fabriquer, fournir et commercialiser des matières à base de graviers (bitumes, bétons, etc.).',NULL,NULL,'1630',2125,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 08:53:44','2024-04-28 10:36:59'),
(705,'JPF Immobilier SA',NULL,NULL,'CHE-107.773.747',160204,'CH21701302916',1,1,'Bulle','JPF',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation','nie',19,NULL,NULL,'www.jpf.ch','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0130291-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'But: activités liées à la gestion, à la promotion de biens immobiliers, et à l''entreprise générale, notamment acquisition, aliénation, exploitation, réalisation, location et gérance de toutes valeurs immobilières ou mobilières en Suisse et à l''étranger et, d''une manière générale, exécution tant pour son compte que pour le compte de tiers de toutes opérations commerciales, financières ou autres, en rapport direct ou indirect avec son but.',NULL,NULL,'1630',2125,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 09:02:17','2024-04-28 10:36:59'),
(706,'JPF Construction SA',NULL,NULL,'CHE-105.901.715',270388,'CH21704310866',1,1,'Bulle','JPF',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation','nie',51,NULL,NULL,'http://www.jpf.ch','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0431086-6&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'But: exploiter une entreprise générale de construction, notamment dans les domaines du génie civil, des routes, bâtiments et ouvrages en bois, exercer une activité d''entreprise générale, acquérir, gérer ou aliéner des participations à d''autres entreprises, acquérir, détenir, grever ou aliéner des biens-fonds et procéder à toutes opérations immobilières se référant au but qu''elle s''est fixé, exercer toute activités, faire toutes opérations, conclure tous contrats et assumer toutes fonctions propres à développer son but ou s''y rapportant directement ou indirectement, reprendre en particulier l''exploitation et des immeubles d''exploitation d''entreprises de construction existantes.',NULL,NULL,'1630',2125,NULL,NULL,NULL,'2022-10-13 00:00:00','2014-05-01 09:06:15','2024-04-28 10:36:59'),
(707,'St-Paul Immobilier SA','St-Paul SA',NULL,'CHE-105.901.738',88292,'CH21701317310',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,MitgliedsOrganisation','nie',48,NULL,NULL,'www.st-paul.ch','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0131731-0&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'exploiter des activités d''édition de livres et de revues, de librairies, de bibliothèques ou de toutes autres formes de réalisation et de diffusion d''imprimés ou de produits médias',NULL,NULL,'1700',2196,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 09:13:52','2024-04-28 10:36:59'),
(708,'St-Paul Holding SA','St-Paul Holding SA',NULL,'CHE-382.325.467',1024186,'CH21735477984',1,1,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'DachOrganisation','nie',48,NULL,NULL,'www.st-paul.ch','https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-3547798-4&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Acquérir, gérer, détenir, administrer et aliéner des participations minoritaires ou majoritaires, directes ou indirectes, dans toutes entreprises dans le secteur commercial, industriel, immobilier ou financier, tant en Suisse qu''à l''étranger (cf. statuts pour but complet).',NULL,NULL,'1700',2196,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 09:19:43','2024-04-28 10:36:59'),
(709,'Ombudsstelle Krankenversicherung',NULL,NULL,'CHE-109.829.123',333712,'CH26070000695',1,1,'Solothurn',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',2,NULL,NULL,NULL,'http://www.moneyhouse.ch/u/ombudsstelle_krankenversicherung_CH-260.7.000.069-5.htm',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Stellt den Versicherten von Krankenversicherern eine Ombudsstelle zur Verfügung und bemüht sich, Missverständnisse zwischen Versicherten und Versicherern durch Beratung sowie Information zu beheben und vermittelt bei Meinungsverschiedenheiten.',NULL,NULL,'4500',2601,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 09:28:05','2024-04-28 10:36:59'),
(713,'PHS Public Health Services GmbH',NULL,NULL,'CHE-111.739.392',761842,'CH05340168700',1,1,'Bern','PHS',NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',3,NULL,NULL,'http://www.public-health-services.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0534016870&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt die Konzeption und Umsetzung von Programmen und Projekten sowie die Beratung in den Bereichen Gesundheitsförderung, Prävention und "Umwelt und Gesundheit". Die Gesellschaft kann Zweigniederlassungen in der Schweiz und im Ausland errichten, sich an anderen Unternehmungen des In- und Auslandes beteiligen, gleichartige oder verwandte Unternehmen erwerben oder sich mit solchen zusammenschliessen, Grundstücke erwerben, verwalten und weiterveräussern, sowie alle Geschäfte eingehen und Verträge abschliessen, die geeignet sind, den Zweck der Gesellschaft zu fördern, oder die direkt bzw. indirekt damit im Zusammenhang stehen.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-05-01 15:46:57','2025-02-13 09:16:34'),
(714,'SwissNOSO',NULL,NULL,'CHE-115.050.013',955518,'CH02060013129',1,1,'Zürich',NULL,'Swissnoso',NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',3,NULL,NULL,'http://www.swissnoso.ch/de/swissnoso','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206001312&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck des Vereins ist die Reduktion der nosokomialen Infektionen in der Schweiz. Der Verein verfolgt seinen gemeinnützigen Zweck mittels Expertise und massgeblichen Stellungnahmen seiner aktiven Mitglieder, der Verbreitung von entsprechenden Informationen, sowie der Organisation von Überwachungs- und Interventionsprogrammen. Der Verein verfolgt keine kommerziellen Ziele und erstrebt keinen Gewinn. Der Verein kann zur Verfolgung seines nicht wirtschaftlichen Zwecks ein nach kaufmännischer Art geführtes Gewerbe betreiben, oder sich an einem solchen beteiligen.',NULL,NULL,'8091',261,NULL,NULL,NULL,'2022-10-27 00:00:00','2014-05-01 16:03:06','2024-04-28 10:36:59'),
(715,'Demenz Forschung Schweiz - Stiftung Synapsis',NULL,NULL,'CHE-110.306.470',724932,'CH02070011112',1,1,'Zürich','AFS',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',6,NULL,NULL,'http://www.synapsisfoundation.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001111&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Stiftung zur Unterstützung der Erforschung der Alzheimer''schen Krankheit\nund anderer neurodegenerativer Krankheiten',NULL,NULL,'8005',261,NULL,NULL,NULL,'2022-10-27 00:00:00','2014-05-01 16:11:43','2024-04-28 10:36:59'),
(716,'syneric GmbH',NULL,NULL,'CHE-115.446.954',972595,'CH02040420251',1,1,'Untersiggenthal',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'GmbH','0107',4,'EinzelOrganisation,LeistungsErbringer','nie',88,NULL,NULL,NULL,'http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0204042025&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt das Erbringen von Dienstleistungen mit Schwerpunkt im Bereich des Gesundheitswesens, die Konzeption und Umsetzung von Programmen und Projekten sowie Beratung in Management- und Rechtsfragen. Die Gesellschaft kann im In- und Ausland Zweigniederlassungen errichten, sich an anderen Unternehmen beteiligen, andere Unternehmen erwerben oder erworbene Unternehmen verkaufen, Liegenschaften und Wertschriften erwerben, verwalten und verkaufen sowie Darlehen aufnehmen und gewähren, Garantien und andere Sicherheiten stellen, Immaterialgüterrechte erwerben, verwalten und verwerten.',NULL,NULL,'5417',4044,NULL,NULL,NULL,'2022-10-27 00:00:00','2014-05-01 16:19:50','2024-04-28 10:36:59'),
(717,'Stiftung Märtplatz',NULL,NULL,'CHE-106.030.342',281541,'CH02079043581',1,1,'Freienstein',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',12,NULL,NULL,'http://www.maertplatz.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207904358&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Märtplatz ist eine Ausbildungsstätte für junge Menschen in besonderen Lebenslagen. Die Stiftung will junge Menschen mit schlechten Startbedingungen auf ihrem Weg ins Erwachsenenleben unterstützen. Zu diesem Zwecke betreibt sie frei von Profitdruck den Märtplatz, der individuelle Ausbildungsmöglichkeiten, vielfältige kulturelle Anregungen und Nachbetreuung bietet.',NULL,NULL,'8427',57,NULL,NULL,NULL,'2025-06-19 15:47:47','2014-05-01 16:27:52','2025-06-19 15:47:47'),
(718,'Verein ARC - Bildungsinstitut für Arbeitnehmende',NULL,NULL,'CHE-109.996.519',682222,'CH03560308346',1,1,'Bern','ARC',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer','nie',27,NULL,NULL,'http://www.formation-arc.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0356030834&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung der Bildung von Arbeitnehmerinnen und Arbeitnehmern; Organisation und Durchführung von Bildungskursen, Vermittlung von Bildungsmöglichkeiten, Zusammenarbeit mit anderen Organisationen der Weiterbildung sowie Herausgabe von Dokumentationen und Publikationen; Bildungskurse werden bei den ARC-Mitgliederverbänden organisierten Gewerkschafterinnen und Gewerkschafter zu besonderen Konditionen angeboten. Die Kurse sind bei Vollkosten auch offen für alle weiteren interessierten Personen; Durchführung von Einführungs- und Weiterbildungskursen für Gewerkschaftskader verschiedener Stufen; ist tätig für Arbeitnehmende in der deutsch- und französischsprechenden Schweiz.',NULL,NULL,'3007',351,NULL,NULL,NULL,'2022-10-27 00:00:00','2014-05-01 16:40:03','2024-04-28 10:36:59'),
(719,'Verein für Originalgraphik',NULL,NULL,'CHE-113.667.964',NULL,NULL,0,0,'Zürich','VFO','Edition VFO',NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,LeistungsErbringer','nie',63,NULL,NULL,'http://www.vfo.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Pflege und Förderung der künstlerischen Originalgrafik wie Radierung, Lithografie, Siebdruck, Holzschnitt; Verkauf der produzierten Blätter zu günstigen Preisen an Mitglieder (mit speziellem Rabatt) sowie Nicht-Mitglieder und Firmen.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2022-10-27 00:00:00','2014-05-01 16:44:26','2022-10-27 15:51:59'),
(720,'Fédération Patronale et Economique',NULL,NULL,'CHE-108.698.315',NULL,NULL,0,0,'Bulle','FPE',NULL,'FPE',NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'https://www.fpe-ciga.ch/',NULL,NULL,'fpe_ciga',NULL,'federationpatronale','https://www.linkedin.com/company/fpe-ciga/',NULL,'Ziel des Arbeitgeber- und Wirtschaftsverbandes ist die Förderung der regionalen Wirtschaft. Er unterstützt seine Mitglieder durch die Bereitstellung zahlreicher Dienstleistungen und die Verwaltung einiger ihrer Aktivitäten.','L''objectif de l''association des employeurs et des entreprises est de promouvoir l''économie régionale. Elle soutient ses membres en leur fournissant de nombreux services et en gérant certaines de leurs activités.',NULL,'1630',2125,NULL,NULL,NULL,'2024-02-08 15:52:05','2014-05-01 17:00:36','2024-02-08 15:52:05'),
(721,'Freiburgischer Arbeitgeberverband UPCF','Union Patronale du Canton de Fribourg UPCF',NULL,NULL,NULL,NULL,0,0,'Fribourg',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'MitgliedsOrganisation,LeistungsErbringer,dezidierteLobby','nie',59,NULL,NULL,'http://www.unionpatronale.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Der Freiburgische Arbeitgeberverband, der in drei Tätigkeitsbereiche aufgegliedert ist, organisiert und verwaltet heute mehr als 60 Berufsverbände, 16 Sekretariate für überbetriebliche Einführungskurse, 7 Sekretariate von Lehrlingskommissionen und 6 Familienzulagenkassen. Der Bereich der Sozialversicherungen FER-CIFA FER-CIFA 106.2 steht im Dienste unserer Mitglieder. Tag für Tag kümmern sich 50 Mitarbeiter um die Anliegen der mehr als 7500 Mitglieder des Freiburgischen Arbeitgeberverbandes (FAV).',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-17 11:30:30','2014-05-01 17:06:35','2025-06-17 11:30:30'),
(722,'Fédération des Entreprises Romandes Genève',NULL,NULL,'CHE-306.530.249',NULL,NULL,1,1,'Genève','FER-GE',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'EinzelOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'https://www.fer-ge.ch/web/fer-ge',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Créée en 1928, la FER Genève regroupe 26''000 entreprises genevoises, représentant plus de 160''000 employés. Elle gère plus de 75 associations professionnelles représentant l''ensemble des secteurs d''activités économiques, des institutions sociales (caisse de compensation AVS, 2ème et 3ème piliers, allocations familiales) et offre des services directs à ses membres (service d''assistance juridique, cours et séminaires, salaires et paies, etc.).',NULL,NULL,'1201',6621,NULL,NULL,NULL,'2023-08-26 09:10:31','2014-05-01 17:12:08','2024-04-28 14:40:59'),
(723,'Fédération des Entreprises Romandes de l''Arc jurassien',NULL,NULL,'CHE-113.484.441',865360,'CH67060041990',1,1,'Porrentruy',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'www.fer-arcju.ch','http://ju.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=6706004199&amt=670&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'FER Arcju est née en janvier 2007, de la fusion de l''UPIJ (Union patronale et interprofessionnelle du Jura et du Jura bernois) et de l''UJAM (Union jurassienne des arts et métiers). Déjà membre de la FER à travers l''UPIJ, la FER Arcju administre de nombreuses institutions à caractère social (AVS, AI, APG, LPP, chômage et allocations familiales), sous un même toit. Elle offre également à ses membres, au nombre de 1''200, toute une palette de prestations, allant des cours et séminaires aux conseils juridiques, en passant par un contrat collectif maladie-accident-perte de gain, que l''UPI a négocié avec une caisse-maladie, dans l''intérêt de ses membres. Enfin, à travers ses différentes publications, elle informe les entreprises sur des sujets économiques, sociaux et juridiques.',NULL,NULL,'2900',6800,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 17:16:14','2024-04-28 10:36:59'),
(724,'Bureau Neuchâtelois des Métiers du Bâtiment BNMB',NULL,NULL,NULL,NULL,NULL,0,0,'Neuchâtel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein',NULL,NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Fondé en avril 1992 par 5 associations actives dans le secteur de la construction, le Bureau Neuchâtelois des Métiers du Bâtiment constitue un toit patronal, sous lequel sont aujourd''hui regroupées 8 associations professionnelles, comptant elles-même près de 350 entreprises membres. Représentant 20% de l''économie du canton, le BNMB défend les intérêts de ses membres dans leurs relations avec les pouvoirs publics (commissions parlementaires, consultations du Conseil d''Etat) et les autres partenaires (syndicats, chambre de commerce). Il siège à ce titre dans la nouvelle commission tripartite du canton.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 17:20:54','2014-09-16 00:00:00'),
(725,'FER Neuchâtel fédération des entreprises romandes',NULL,NULL,'CHE-321.974.429',NULL,NULL,0,0,'Neuchâtel','FER',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'La Fédération des Entreprises Romandes Neuchâtel a été fondée en 1939 sous le nom de Fédération Neuchâteloise et Jurassienne des Groupements Patronaux. Regroupant 650 entreprises membres, elle gère de nombreuses associations professionnelles. Elle est souvent consultée pour des problèmes d''assurances sociales ou encore de droit du travail.',NULL,NULL,'2000',6458,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 17:26:47','2022-09-25 22:33:13'),
(726,'Fédération des Entreprises Romandes-Valais',NULL,NULL,'CHE-111.784.576',763734,'CH62660093775',1,1,'Sion','FER-VS',NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,MitgliedsOrganisation,dezidierteLobby','nie',59,NULL,NULL,'http://www.fer-vs.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Cette association interprofessionnelle a été fondée en début 2004 par l''Union Commerciale Valaisanne (UCOVA) et par l''Association Valaisanne des Mandataires de la Construction (AVMC). Elle est ouverte à d''autres associations professionnelles d''employeurs ainsi qu''à des membres individuels.\nLa FER-Vs regroupe actuellement environ 2''000 entreprises (PME principalement). Ses membres cotisent à la caisse FER VALAIS 106.7, agence de la deuxième plus grande caisse AVS interprofessionnelle de notre pays, aux caisses d''allocations familiales CACI (UCOVA) et CAFIA (AVMC), ainsi qu''à d''autres assurances sociales selon leurs besoins (LPP, LAA, LCA perte de gains maladie, LAMAL). Toutes ces institutions sociales sont gérées par le bureau de la sécurité sociale à Sion.\nElle défend les intérêts de ses membres, répond aux questions concernant le droit du travail et offre un service juridique dans ce domaine.',NULL,NULL,'1951',6266,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-05-01 17:35:22','2024-04-28 10:36:59'),
(727,'Jetra AG in Liquidation',NULL,NULL,'CHE-102.011.245',293988,'CH21706307469',1,1,'ohne Domizil-sans domicile',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','nie',108,NULL,NULL,NULL,'https://appls.fr.ch/hrcmatic/hrcintapp/externalCompanyReport.action?companyOfrcId13=CH-217-0630746-9&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck: Beteiligungen an Unternehmen aller Art im In- und Ausland sowie erwerben, verwerten und veräussern von Immaterialgüterrechten und Lizenzen; vollständige Zweckumschreibung gemäss Statuten',NULL,NULL,'3185',1711,NULL,NULL,NULL,'2016-10-17 21:43:10','2014-05-01 17:47:35','2024-04-28 10:36:59'),
(728,'Stiftung Klimarappen','Fondation Centime Climatique','Fondazione Centesimo per il Clima','CHE-112.494.603',801353,'CH02070012685',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',91,NULL,NULL,'www.klimarappen.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207001268&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Stiftung Klimarappen ist eine freiwillige Massnahme der Schweizer Wirtschaft für einen wirksamen Klimaschutz. Sie investiert ihr Vermögen in ausländische Projekte zur Verminderung von Treibhausgasen. Emissionsminderungszertifikate aus diesen Projekten gibt sie dem Bund kostenfrei ab. Finanziert wurde die Stiftung Klimarappen durch eine Abgabe von 1,5 Rappen pro Liter auf Benzin- und Dieselimporten in den Jahren 2006 bis 2012.',NULL,NULL,'8032',261,NULL,NULL,NULL,'2025-02-13 09:16:34','2014-05-01 17:53:57','2025-02-13 09:16:34'),
(729,'Betonsuisse Marketing AG',NULL,NULL,'CHE-113.315.212',856364,'CH03530368026',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,dezidierteLobby','nie',51,NULL,NULL,'http://betonsuisse.ch/betonsuisse/index.html','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0353036802&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Die Gesellschaft bezweckt das Erbringen von Marketing-, Promotions- und PR-Dienstleistungen sowie allfälliger technischer Unterstützung im Bereiche des Betons, dessen Herstellung, Verwendung und Verarbeitung. Zudem wahrt sie die Interessen der am Betonbau interessierten Organisationen und Industrien in wirtschaftlichen, wirtschaftspolitischen, industriepolitischen, kommunikativen sowie normenpolitischen, wissenschaftlichen und ausbildungsmässigen Belangen. Die Gesellschaft kann Zweigniederlassungen und Tochtergesellschaften im In- und Ausland errichten und sich an anderen Unternehmen im In- und Ausland beteiligen bzw. solche erwerben oder sich mit Unternehmen im In- und Ausland zusammenschliessen. Die Gesellschaft kann Grundstücke erwerben, halten und veräussern. Die Gesellschaft kann alle kommerziellen, finanziellen und anderen Tätigkeiten ausüben, welche mit dem Zweck der Gesellschaft im Zusammenhang stehen.',NULL,NULL,'3011',351,NULL,NULL,NULL,'2021-07-10 19:24:59','2014-05-01 17:58:30','2024-04-28 10:36:59'),
(730,'Senso5',NULL,NULL,'CHE-382.067.584',1055343,'CH62670141948',1,1,'Sion',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',3,27,NULL,NULL,'http://vs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=6267014194&amt=626&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Pädagogische Ernährungserziehungsprojekt\nDévelopper et généraliser le projet Senso5 dans les établissements scolaires; poursuivre et développer des recherches scientifiques en approche sensorielle regroupant les dimensions de pédagogie, de santé publique et de mise en valeur des produits agricoles et touristiques; vulgariser et diffuser les résultats des recherches; développer un pôle de compétences sensorielles en partenariat avec des instituts universitaires; de manière plus générale, agir dans le domaine de la promotion de la santé afin de développer un rapport sain à l''alimentation; gérer et promouvoir la marque de garantie "Senso5"; profiler le Valais comme une région pilote dans la mise en application de concepts sensoriels novateurs liés à l''alimentation, la pédagogie et la santé, dans le respect des principes du développement durable et dans la mise en valeur des produits régionaux',NULL,NULL,'1951',6266,NULL,NULL,NULL,'2016-09-06 14:44:30','2014-05-02 07:41:28','2024-04-28 10:36:59'),
(732,'Zeix AG',NULL,NULL,'CHE-100.918.571',531903,'CH32030484405',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,Gewinnorientiert','nie',78,NULL,NULL,'www.zeix.ch','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=3203048440&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Zweck der Gesellschaft ist Betrieb eines Verlages für Fachliteratur, besonders im Bereich der Internetnutzung, Betrieb entsprechender Internetangebote, Beratung und Schulung von Unternehmungen, Organisationen und deren Kunden, Handel mit den zugehörigen Hilfsmitteln. Die Gesellschaft kann im In- und Ausland tätig sein. Sie kann Zweigniederlassungen errichten, sich bei anderen Unternehmungen des In- und Auslandes beteiligen, gleichartige oder verwandte Unternehmungen erwerben oder errichten, Patente und Lizenzen erwerben und verwalten und Grundstücke im Ausland erwerben.',NULL,NULL,'8004',261,NULL,NULL,NULL,'2023-07-20 09:14:51','2014-05-22 09:59:15','2024-04-28 10:36:59'),
(733,'Zugang für Alle, Schweizerische Stiftung zur behindertengerechten Technologienutzung','Accès pour tous Fondation suisse pour une technologie adaptée aux handicapés','Accesso per tutti Fondazione svizzera per una tecnologia adeguata alle persone disabili','CHE-109.798.103',607377,'CH02070008583',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',15,NULL,NULL,'http://www.access-for-all.ch/','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0207000858&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0','Access4All',NULL,NULL,NULL,NULL,NULL,'Die Stiftung setzt sich in der Schweiz und im Fürstentum Lichtenstein für die Technologieerschliessung und -nutzung durch Menschen mit Behinderung ein; Sensibilisiert Wirtschaft, Wissenschaft, Behörden und Politik für die Bedürfnisse von behinderten und im speziellen von sehbehinderten Menschen im Bereich der Technik und der elektronischen Informationsvermittlung; Fördert die Technologienutzung für behinderte mit der Entwicklung und dem Angebot von Ausbildungsmassnahmen, Trainingsmethoden und Anwenderdokumentationen; Unterstützt und fördert die behindertengerechte Entwicklung und Anpassung von Geräten im Bereich, Beruf, Haushalt, Freizeit und Mobilität; Verfolgt und analysiert als Kompetenzzentrum Entwicklungen und Trends im Technologiebereich und unterhält die Zusammenarbeit mit Behinderten- und Fachorganisationen in der Schweiz und im Ausland.',NULL,NULL,'8057',261,NULL,NULL,NULL,'2025-06-20 16:21:37','2014-05-22 10:16:11','2025-06-20 16:21:37'),
(734,'Pensionskasse der Basler Kantonalbank',NULL,NULL,'CHE-102.214.297',244184,'CH27050000812',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,NULL,'http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2705000081&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Berufliche Vorsorge im Rahmen des BVG und seiner Ausführungsbestimmungen für die Mitarbeitenden der Basler Kantonalbank, mit dieser wirtschaftlich oder finanziell verbundener Unternehmen sowie für deren Angehörige und Hinterlassene gegen die wirtschaftlichen Folgen von Alter, Tod und Invalidität. Die Stiftung kann über die gesetzlichen Mindestleistungen hinaus weitergehende Vorsorge betreiben.',NULL,NULL,'4051',2701,NULL,NULL,NULL,'2019-08-16 14:28:15','2014-05-23 08:09:33','2024-04-28 10:36:59'),
(735,'Liberty BVG Sammelstiftung',NULL,NULL,'CHE-114.944.178',949010,'CH13070146846',1,1,'Seewen SZ','BVG',NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','nie',42,NULL,NULL,'http://www.liberty-vorsorge.ch','http://sz.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1307014684&amt=130&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Durchführung der beruflichen Vorsorge im Rahmen des BVG und seiner Ausführungsbestimmungen für die Arbeitnehmer der ihr angeschlossenen Arbeitgeber sowie für deren Angehörige und Hinterbliebenen nach Massgabe eines Reglements gegen die wirtschaftlichen Folgen von Alter, Tod und Invalidität.',NULL,NULL,'6423',1372,NULL,NULL,NULL,'2018-09-04 15:52:32','2014-05-23 08:21:06','2024-04-28 10:36:59'),
(736,'Coopérative Cité Derrière',NULL,NULL,'CHE-104.327.245',363492,'CH55000850940',1,1,'Lausanne',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','nie',19,NULL,NULL,NULL,'http://www.rc2.vd.ch/registres/hrcintapp-pub/externalCompanyReport.action?companyOfrcId13=CH-550-0085094-0&ofrcLanguage=1',NULL,NULL,NULL,NULL,NULL,NULL,'But: amélioration des conditions de logement de la population et plus particulièrement de ses membres par la pratique de prix favorables et d''utilité publique, notamment dans le cadre de la construction, avec l''aide des pouvoirs publics, d''un immeuble sis Rue Cité Derrière, à Lausanne, et qui sera érigé sur un droit distinct permanent accordé par l''Etat de Vaud.',NULL,NULL,'1003',5586,NULL,NULL,NULL,'2016-03-18 11:03:50','2014-05-23 17:37:48','2024-04-28 10:36:59'),
(740,'Société d''Edition du Journal "Le Peuple Valaisan" société coopérative','Société coopérative d''édition du journal Le Peuple',NULL,'CHE-103.322.498',244508,'CH62650024765',1,1,'Sion',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'EinzelOrganisation,LeistungsErbringer','nie',48,NULL,NULL,NULL,'http://vs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=6265002476&amt=626&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Assurer la parution du journal "Le Peuple Valaisan" et éventuellement d''autres publications',NULL,NULL,'1950',6266,NULL,NULL,NULL,'2020-11-30 14:47:43','2014-06-05 12:09:07','2024-04-28 10:36:59'),
(741,'Guido Fluri-Stiftung',NULL,NULL,'CHE-115.861.632',989046,'CH17070007066',1,1,'Cham',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation','nie',12,NULL,NULL,'http://www.guido-fluri-stiftung.ch/','http://www.hrazg.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1707000706&amt=170&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Stiftung zur Bekämpfung der Gewalt an Kindern, Aufklärung/Forschung Schizophrenie, Aufklärung/Forschung Hirntumore. Im Zentrum steht das Engagement zur Rehabilitierung der Verdingkinder, Zwangssterilisierten, Administrativ Versorgten und Zwangsadoptierten. Dazu lancierte die Stiftung die Wiedergutmachungsinitiative (2014).\n\n Aufruf gegen Kindergewalt\n\nEin Projekt zur Bekämpfung von Gewalt gegen Kinder! Gewalt innerhalb von Familien oder in öffentlichen und privaten Einrichtungen ist ein sehr grosses, gesellschaftliches Problem, aber leider immer noch ein Tabu-Thema.\nÜber 13''000 Pflegekinder gibt es jedes Jahr neu in der Schweiz. Tendenz zunehmend! Beinahe die Hälfte davon erfahren in irgend einer Form körperlichen wie geistigen Missbrauch. Dies muss sich ändern! Wir alle können helfen, mehr Aufmerksamkeit zu erreichen, zu handeln und die psychische Verarbeitung der Betroffenen zu erleichtern.  \n\nWorldkids "Aufruf gegen Kindergewalt" ist eine anonyme Plattform. Sie soll Ängste für das Handeln bei Gewalt an Kindern überwinden. Wir alle müssen frühzeitig Gewalt an Kindern erkennen und reagieren, bevor es zu spät ist! Innerhalb des Worldkids - Projekts liegen verschiedene Themen in Bearbeitung. Insbesondere die Aufarbreitung von Missbrauch und Gewalt in früheren Kinderheimen und anderen Institutionen.   \n\nMehr unter: www.worldkids.info\n\nErste Nationale Gedenkstätte für Heim- und Verdingkinder\nIn Mümliswil wurde die erste Nationale Gedenkstätte für Heim- und Verdingkinder eröffnet.\n\nHistorische Aufarbeitung von Schweizer Kinderheimen\nDie Guido Fluri - Stiftung finanziert das Projekt "Historische Aufarbeitung von Kinderheimen in der Schweiz" über CHF 300 000.00.   \n\nUnter der Plattform www.kinderheime-schweiz.ch können sich Betroffene, die in Kinderheimen Missbrauch erfahren haben, untereinander austauschen. Der Zürcher Historiker Dr. Thomas Huonker hat dieses Projekt in Bearbeitung. Nebst Zeitzeugen sind auch Urkunden, Pressartikel und Veranstaltungen dokumentiert.  \n\nErste Nationale Gedenkstätte Kinderheim Mümliswil  \n\nDie Stiftung hat weitere Kosten für Studien bezüglich "Kindergewalt in unserer Gesellschaft" bewilligt. In erster Linie geht es darum, auch die gegenwärtige Situation von Pflegekindern zu beleuchten, insbesondere "Anreize" durch Pflegekostenbeiträge.',NULL,NULL,'6330',1702,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-06-26 08:43:52','2024-04-28 10:36:59'),
(742,'CONCORDIA Beteiligungen AG','CONCORDIA Participations SA','CONCORDIA Partecipazioni SA','CHE-101.513.231',125070,'CH10030082595',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',2,NULL,NULL,NULL,'http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003008259&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Beteiligungen an andern Unternehmungen aller Art sowie Verwaltung dieser Beteiligungen; Erwerb, Verwaltung, Veräusserung, Miete, Vermietung, Pacht und Verpachtung von Liegenschaften.\n\nGemäss Sacheinlagevertrag vom 23.03.2007 übernimmt die Gesellschaft bei der Kapitalerhöhung von der Stiftung Kranken- und Unfallkasse Konkordia, in Luzern (CH-100.7.007.548-6), 5''000 Namenaktien zu CHF 1''000.-- der Solida Versicherungen AG, in Zürich (CH-020.3.924.522-5), 1''500 Namenaktien zu CHF 1''000.-- der Solimob AG, in Zürich (CH-020.3.924.387-0) und 10 Namenaktien zu CHF 10''000.-- der Hotel Johanniter AG, in Luzern (CH-100.3.007.149-5), zum Preise von CHF 9''150''850.--, wofür 1''180 Namenaktien zu CHF 5''000.-- ausgegeben und CHF 3''250''850.-- als Agio den Reserven gutgeschrieben werden.',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2022-09-16 00:00:00','2014-06-27 09:15:12','2024-04-28 10:36:59'),
(743,'Nagra, Nationale Genossenschaft für die Lagerung radioaktiver Abfälle','Société coopérative nationale pour le stockage des déchets radioactifs','Nagra, Società cooperativa nazionale per lo smaltimento delle scorie radioattive','CHE-105.877.519',125394,'CH40050101369',1,1,'Wettingen','Nagra','Nagra Schweiz; Nagra Suisse','Nagra',NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',30,NULL,NULL,'http://www.nagra.ch',NULL,'Nagra_Schweiz','jahrhundertprojekt','NagraCHonline','NagraGenossenschaft/','https://www.linkedin.com/company/nagra-nationale-genossenschaft-fuer-die-lagerung-radioaktiver-abfaelle/?originalSubdomain=ch',NULL,'Die Nagra plant und baut ein geologisches Tiefenlager für den radioaktiven Abfall der Schweiz. Nach Jahrzehnten der Forschung, reichen die Organisation im Herbst 2024 ein Rahmenbewilligungsgesuch ein.','La Nagra planifie et construit un dépôt géologique en profondeur pour les déchets radioactifs de la Suisse. Après des décennies de recherche, l''organisation déposera une demande d''autorisation générale à l''automne 2024.',NULL,'5430',4045,NULL,NULL,NULL,'2019-07-27 21:03:43','2014-06-27 09:26:11','2025-02-12 13:37:46'),
(744,'CONCORDIA Versicherungen AG','Concordia Assurances SA','Concordia Assicurazioni SA','CHE-101.503.037',38743,'CH10030052868',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','punktuell',57,NULL,NULL,'www.concordia.ch','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003005286&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Betrieb der Kranken- und Unfallversicherung sowie Lebensversicherung, sei es direkt oder auf dem Weg der Rückversicherung; Erbringung von Dienstleistungen im Bereich des Gesundheitswesens, namentlich Anbietung und Vermittlung von Versicherungsschutz gegen wirtschaftliche Folgen von Krankheit, Mutterschaft, Unfall, Invalidität und Tod; dies umfasst insbesondere die Zusatzversicherung zur Kranken- und Unfallversicherung, die Erwerbsausfall- und Invaliditätsversicherungen sowie die Lebensversicherungen gemäss dem Versicherungsvertragsgesetz; Anbietung von Versicherungen selber oder in Zusammenhang mit anderen Versicherungsträgern; Beteiligungen; Erwerb, Verwaltung, Veräusserung und Belastung von Grundstücken oder beschränkten dinglichen Rechten.',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2022-09-16 00:00:00','2014-06-27 11:04:41','2024-04-28 10:36:59'),
(745,'Stiftung Kranken- und Unfallkasse Konkordia',NULL,NULL,'CHE-109.357.495',279989,'CH10070075486',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Stiftung','0110',7,'EinzelOrganisation,LeistungsErbringer','punktuell',2,NULL,NULL,'www.concordia.ch','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1007007548&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Versicherungsschutz und Vorsorge für Mitglieder und Mitarbeiter der Schweiz. Kranken- und Unfallkasse Konkordia und alle damit zusammenhängenden Vorkehren.',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2022-09-16 00:00:00','2014-06-27 11:13:58','2024-04-28 10:36:59'),
(746,'CONCORDIA Schweizerische Kranken- und Unfallversicherung AG','CONCORDIA Assurance suisse de maladie et accidents SA','CONCORDIA Assicurazione svizzera malattie e infortuni SA','CHE-112.992.321',840920,'CH10037865697',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation','punktuell',2,NULL,NULL,'www.concordia.ch','http://lu.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=1003786569&amt=100&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Förderung des Gesundheitswesens als Krankenkasse; Erbringung von Dienstleistungen im Bereich des Gesundheitswesens, namentlich indem sie Versicherungsschutz bietet und vermittelt gegen wirtschaftliche Folgen von Krankheit, Mutterschaft, Unfall, Invalidität und Tod; Dies umfasst insbesondere die Versicherungen gemäss dem schweizerischen und dem liechtensteinischen Krankenversicherungsgesetz und die Versicherungen nach dem Unfallversicherungsgesetz; Versicherungen selber anbieten oder in Zusammenarbeit mit anderen Versicherungsträgern; Beteiligungen; Erwerb, Verwaltung, Veräusserung oder Belastung von Grundstücken oder beschränkt dinglichen Rechten.',NULL,NULL,'6002',1061,NULL,NULL,NULL,'2022-09-16 00:00:00','2014-06-27 11:21:16','2024-04-28 10:36:59'),
(747,'CONCORDIA Schweizerische Kranken- und Unfallversicherung',NULL,NULL,'CHE-105.803.751',469817,'CH10060193782',1,1,'Luzern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'DachOrganisation,LeistungsErbringer','punktuell',2,NULL,NULL,'https://www.concordia.ch','https://lu.chregister.ch/cr-portal/auszug/auszug.xhtml?uid=CHE-105.803.751','concordia_ch','concordia_schweiz',NULL,'concordia.ch','https://www.linkedin.com/company/concordia-ch',NULL,'Zweck: Der Verein bietet und vermittelt Versicherungsschutz gegen die wirtschaftlichen Folgen von Krankheit, Mutterschaft, Unfall, Invalidität und Tod; Unterstützung von Bestrebungen zur Verhütung von Krankheiten und Unfällen sowie von Invalidität und vorzeitigem Tod.',NULL,NULL,'6002',1061,'https://de.wikipedia.org/wiki/Concordia_Schweizerische_Kranken-_und_Unfallversicherung','Q1124160',NULL,'2014-09-16 00:00:00','2014-06-27 13:34:20','2024-04-28 10:36:59'),
(748,'Pro Infirmis',NULL,NULL,'CHE-103.189.584',166350,'CH02069004408',1,1,'Zürich',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Verein','0109',6,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','punktuell',15,NULL,NULL,'http://www.proinfirmis.ch/de/home.html','http://zh.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0206900440&amt=020&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,'pro_infirmis','user/ProInfirmisCH','ProInfirmis/','https://www.linkedin.com/company/pro-infirmis/?originalSubdomain=ch',NULL,'Pro Infirmis ist die nationale Dachorganisation für Menschen mit körperlichen, kognitiven und psychischen Beeinträchtigungen. Sie führt Beratungsstellen und vertritt die Interessen beeinträchtigter Menschen auf politischer Ebene.','Pro Infirmis est l''organisation faîtière nationale pour les personnes souffrant de handicaps physiques, cognitifs et psychiques. Elle gère des centres de consultation et défend les intérêts des personnes handicapées au niveau politique.',NULL,'8008',261,'https://de.wikipedia.org/wiki/Pro_Infirmis','Q1430997',NULL,'2025-06-20 15:57:11','2014-06-30 17:43:17','2025-06-20 15:57:11'),
(749,'MKR Consulting AG',NULL,NULL,'CHE-106.247.479',120533,'CH03530118858',1,1,'Bern','MKR',NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer,dezidierteLobby','nie',18,NULL,NULL,'http://www.mkr.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0353011885&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Pr- und Marketingagentur.',NULL,NULL,'3006',351,NULL,NULL,NULL,'2014-09-16 00:00:00','2014-06-30 18:10:45','2024-04-28 10:36:59'),
(750,'Baloise Holding AG',NULL,NULL,'CHE-102.743.957',13315,'CH27030005053',1,1,'Basel',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'AG','0106',3,'EinzelOrganisation,LeistungsErbringer','nie',57,NULL,NULL,NULL,'http://bs.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=2703000505&amt=270&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Gewährleistung der einheitlichen Geschäftsführung der "Bâloise-Versicherungs-Gesellschaften". Die Gesellschaft kann sich an anderen Unternehmungen irgendwelcher Art beteiligen, solche gründen oder übernehmen oder mit ihnen fusionieren.',NULL,NULL,'4001',2701,NULL,NULL,NULL,'2023-02-28 23:22:39','2014-07-01 13:19:25','2024-04-28 10:36:59'),
(751,'Verband öffentlicher Verkehr, Genossenschaft (VöV)','Union des transports publics, société coopérative (UTP)','Unione dei trasporti pubblici, società cooperativa (UTP)','CHE-107.816.575',200725,'CH03550037348',1,1,'Bern',NULL,NULL,NULL,NULL,NULL,NULL,191,1,'Genossenschaft','0108',5,'DachOrganisation,dezidierteLobby','punktuell',33,NULL,NULL,'http://www.voev.ch','http://be.powernet.ch/webservices/inet/HRG/HRG.asmx/getHRGHTML?chnr=0355003734&amt=036&toBeModified=0&validOnly=0&lang=1&sort=0',NULL,NULL,NULL,NULL,NULL,NULL,'Der VöV setzt sich ein für günstige Rahmenbedingungen, damit ein attraktives, kundenfreundliches und nachhaltiges öV-Angebot in allen Regionen der Schweiz erbracht werden kann. Der VöV vertritt die Interessen der Transportunternehmen des öV und des Schienengüterverkehrs in der Schweiz. Er unterstützt die Zusammenarbeit der Mitglieder, erbringt Dienstleistungen im Interesse der Branche und fördert die brancheninterne Zusammenarbeit. Seinen Zweck erfüllt der VöV insbesondere dadurch, dass er; die gemeinsamen Interessen der Unternehmungen des öffentlichen Verkehrs gegenüber Behörden, Politik und Dritten vertritt; den Erfahrungsaustausch unter den Mitgliedern und die Zusammenarbeit mit den am Verkehr interessierten Kreisen pflegt; bei definierten Aufgaben eine koordinierende und moderierende Rolle zwischen den Mitgliedern einnimmt; die Öffentlichkeit und die Behörden über die Bedeutung, die Herausforderungen und die Lösungen des öffentlichen Verkehrs informiert; im Mandatsverhältnis die Geschäftsstelle des nationalen Direkten Verkehrs führt; Branchenlösungen fördert oder entwickelt sowie gemeinsame Standards oder Regelwerke herausgibt; die unabhängige Ombudsstelle öffentlicher Verkehr einrichtet und finanziert; den Mitgliedern allgemeine Auskünfte rechtlicher, wirtschaftlicher, betrieblicher, technischer, tariflicher und administrativer Art erteilt; Fachveranstaltungen nach Massgabe der Mitgliederbedürfnisse organisiert; bedarfsgerecht die berufliche Aus- und Weiterbildung der Mitarbeitenden aller Stufen fördert; als Dienstleister übergeordnete Aufgaben der Branche wahrnimmt und den Mitgliedern gegen Entgelt Unternehmungsberatung anbieten kann;  die Vereinheitlichung der Betriebsmittel fördert; die Datenerhebung und Datenbearbeitung zwecks Ausarbeitung und Publikation von verkehrswirtschaftlichen und verkehrspolitischen Statistiken in aggregierter Form fördert. Individuelle Unternehmensdaten werden der Öffentlichkeit nur nach expliziter Einwilligung der Mitglieder bekannt gegeben; bei Konflikten zwischen Mitgliedern auf Wunsch der betroffenen Mitglieder vermittelt; die Grundlagen für ein Branchenschiedsgericht schafft; darauf hinwirkt, dass die Eisenbahninfrastrukturbetreiber die Netzentwicklung der Eisenbahninfrastruktur aufeinander abstimmen und koordinieren.',NULL,NULL,'3005',351,NULL,NULL,NULL,'2022-09-17 00:00:00','2014-07-08 14:16:46','2024-04-28 10:36:59'),
(752,'Seilbahnen Schweiz','Remontées Mécaniques Suisses','Funivie svizzere (FUS)','CHE-104.038.114',NULL,NULL,0,0,'Bern','SBS',NULL,'RMS',NULL,NULL,NULL,191,1,'Verein','0109',NULL,'DachOrganisation,dezidierteLobby','punktuell',33,60,NULL,'http://www.seilbahnen.org',NULL,NULL,'seilbahnenschweiz_sbs','seilbahnenschweiz6559','seilbahnen.schweiz/','https://www.linkedin.com/company/seilbahnen-schweiz/',NULL,'Seilbahnen Schweiz (SBS) ist der Verband der Schweizer Seilbahnbranche. In rechtlicher Sicht handelt es sich um einen Verein (Statuten). Ihm gehören als ordentliche Mitglieder rund 375 der etwa 500 Seilbahnunternehmungen aus allen Regionen des Landes an; darunter sämtliche grossen und mittelgrossen Unternehmungen, aber auch viele kleinere Bahnen. Die Seilbahnen Schweiz versteht sich daher als umfassende Branchenvertretung. Dies wird unterstrichen durch die Tatsache, dass dem Verband als "Befreundete Mitglieder" auch rund 120 Industrieunternehmen aus dem Bereich Seilbahnbau angehören. Zweck von Seilbahnen Schweiz ist es, die gemeinsamen Anliegen und Interessen der Mitglieder zu vertreten und ihre Zusammenarbeit zu fördern. Daraus ergibt sich ein breites Spektrum von Aktivitäten, das von der Vertretung gegenüber Behörden über die Mitgliederberatung bis zur Öffentlichkeitsarbeit reicht.','Remontées Mécaniques Suisses (RMS) est l''association de la branche des remontées mécaniques suisses. Juridiquement, il s''agit d''une association (statuts). Environ 375 entreprises de remontées mécaniques sur les 500 existant dans tout le pays lui sont affiliées en tant que membres ordinaires. Les grandes et moyennes entreprises de remontées mécaniques sont pratiquement toutes membres de l''association, de même que de nombreuses petites entreprises. Remontées Mécaniques Suisses se considère donc comme représentative pour la branche. Ceci est renforcé par le fait qu''outre les entreprises de transport, pas moins de 120 entreprises industrielles issues du domaine de la construction des remontées mécaniques sont affiliées à l''association au titre de "membres amis".\nLe but de Remontées Mécaniques Suisses est de défendre les besoins et les intérêts communs des membres et de développer la collaboration entre eux. Il en résulte un large spectre d''activités, qui va de la défense des intérêts face aux autorités à la fonction de conseiller jusqu''aux travaux de relations publiques. Les buts et les activités de Remontées Mécaniques Suisses sont définis sous forme d''une idée maîtresse dans la politique de l''association.\nLe siège de Remontées Mécaniques Suisses est à Berne. Au Dählhölzliweg 12, l''association gère un secrétariat de 70 collaboratrices et collaborateurs en commun avec l''Union des transports publics. Par cette étroite collaboration, ces deux organisations font profiter à leurs membres des nombreuses synergies qui résultent d''activités semblables - transports publics et transports touristiques.\nRemontées Mécaniques Suisses exploite un centre de formation à Meiringen, le CF RMS. Celui-ci organise dans ses locaux les cours interentreprises pour les apprentis des métiers Employé/e de remontées mécaniques AFP et Mécatronicien/ne de remontées mécaniques CFC. Le CF RMS assure en outre la formation et la formation continue des spécialistes du service de pistes et de sauvetage et d''autres domaines de la branche.',NULL,'3005',351,NULL,NULL,NULL,'2025-07-21 18:08:15','2014-07-08 14:34:57','2025-07-21 18:08:15'),
(753,'Zentralschweizer Komitee Durchgangsbahnhof Luzern',NULL,NULL,NULL,NULL,NULL,0,0,'Kastanienbaum',NULL,NULL,NULL,NULL,NULL,NULL,191,2,'Informelle Gruppe',NULL,NULL,'EinzelOrganisation,dezidierteLobby','nie',33,NULL,NULL,'https://www.komitee-durchgangsbahnhof.ch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Das Zentralschweizer Komitee Durchgangsbahnhof Luzern bündelt die Kräfte aus der Zentralschweiz und setzt sich mit Nachdruck für den Durchgangsbahnhof ein. Die über 700 Komiteemitglieder aus Politik, Wirtschaft und Expertenkreisen sowie von weiteren Mobilitäts- und Wirtschaftsorganisationen verdeutlichen die breite Abstützung des Projekts. \n\nIm Rahmen der öffentlichen Vernehmlassung zum Ausbauschritt der Bahninfrastruktur 2035 (AS 2035) des Bundes nimmt das Komitee Stellung zum geplanten Entwicklungsprogramm der Bahninfrastru