Lobbywatch Export: SQL
======================

Datei: export/lobbywatch.sql  
Datum: 03.11.2025 02:31:01  
Exporttyp: Öffentlich / Public  

Herausgeber: Lobbywatch (https://lobbywatch.ch)  

Die Inhalte von Lobbywatch.ch sind lizenziert unter einer Creative Commons Namensnennung - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz. (https://creativecommons.org/licenses/by-sa/4.0/deed.de)

Data are licensed as CC BY-SA

## kanton (kanton)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel des Kantons Technischer Schlüssel
abkuerzung | Kantonskürzel
kantonsnr | Nummer des Kantons gemäss Verfassung
name_de | Deutscher Name des Kantons Deutscher Name des Datensatzes.
name_fr | Französischer Name Französicher Name des Datensatzes.
name_it | Italienischer Name Italienischer Name des Datensatzes.
romandie | Gehört dieser Kanton zur Romandie?
anzahl_staenderaete | Anzahl Ständeräte
amtssprache | Amtssprachen des Kantons
hauptort_de | Hauptort des Kantons
hauptort_fr | Hauptort auf französisch
hauptort_it | Hauptort auf italienisch
flaeche_km2 | Fläche in km2
beitrittsjahr | Beitrittsjahr zur Schweiz
wappen_svg | SVG Wappen des Kantons
wappen_svg_pfad | Pfad zu SVG Wappen des Kantons
wappen_klein | Pfad zu kleinem Wappen des Kantons (25px)
wappen | Pfad zu Wappen des Kantons (50px)
lagebild | Pfad zum lagebild des Kantons
homepage | Homepage des Kantons
beschreibung | Beschreibung des Kantons
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## kanton_jahr (kanton_jahr)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Jahreswerte eines Kantons Technischer Schlüssel
kanton_id | Fremdschlüssel eines Kantons
jahr | Jahr auf welche sich die Werte beziehen
anzahl_nationalraete | Anzahl Nationalräte des Kantons
einwohner | Wohnbevölkerung des Kantons
auslaenderanteil | Ausländeranteil, zwischen 0 und 1
bevoelkerungsdichte | Bevölkerungsdichte [Einwohner/km2]
anzahl_gemeinden | Anzahl Gemeinden
steuereinnahmen | Stuereinnahmen in Franken
ausgaben | Ausgaben in Franken
finanzausgleich | Geld durch Finanzausgleich bekommen, in Franken
schulden | Schulden des Kantons in Franken
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## interessenraum (interessenraum)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel des Interessenraumes Technischer Schlüssel
name | Name des Interessenbereiches Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französischer Name des Interessenbereiches Französicher Name des Datensatzes.
beschreibung | Beschreibung des Interessenraumes
beschreibung_fr | Französische Beschreibung des Interessenraumes
reihenfolge | Anzeigereihenfolge (je kleiner desto höher)
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## rat (rat)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Jahreswerte eines Rates Technischer Schlüssel
abkuerzung | Kürzel des Rates
abkuerzung_fr | Französische Abkürzung
name_de | Name auf deutsch Deutscher Name des Datensatzes.
name_fr | Name auf französisch Französicher Name des Datensatzes.
name_it | Name auf italienisch Italienischer Name des Datensatzes.
name_en | Name auf englisch
anzahl_mitglieder | Anzahl Mitglieder des Rates
typ | Typ des Rates
interessenraum_id | Interessenraum des Rates
anzeigestufe | Anzeigestufe, je höher desto selektiver, >=0 = alle werden angezeigt, >0 = Standardanzeige
gewicht | Reihenfolge der Einträge, je grösser desto tiefer ("schwerer")
beschreibung | Eine Beschreibung
homepage_de | Deutschsprachige Homepage
homepage_fr | Franszösichsprache Homepage
homepage_it | Italienischsprachige Homepage
homepage_en | Englischsprachige Homepage
mitglied_bezeichnung_maennlich_de | Deutsche Bezeichnung der Männer
mitglied_bezeichnung_weiblich_de | Deutsche Bezeichung der Frauen
mitglied_bezeichnung_maennlich_fr | Französische Bezeichnung der Männer
mitglied_bezeichnung_weiblich_fr | Französische Bezeichung der Frauen
parlament_id | ID auf ws.parlament.ch
parlament_type | Ratstypecode von ws.parlament.ch
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## fraktion (fraktion)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Fraktion Technischer Schlüssel
abkuerzung | Fraktionsabkürzung
name | Ausgeschriebener Name der Fraktion Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Ausgeschriebener französischer Name der Fraktion Französicher Name des Datensatzes.
position | Politische Position der Fraktion
farbcode | HTML-Farbcode, z.B. red oder #23FF23
beschreibung | Beschreibung der Fraktion
beschreibung_fr | Französische Beschreibung der Fraktion
von | Beginn der Fraktion, leer (NULL) = unbekannt
bis | Ende der Fraktion, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## partei (partei)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Partei Technischer Schlüssel
abkuerzung | Parteiabkürzung
abkuerzung_fr | Französische Parteiabkürzung
name | Ausgeschriebener Name der Partei Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Ausgeschriebener französischer Name der Partei Französicher Name des Datensatzes.
fraktion_id | Fraktionszugehörigkeit der Partei im nationalen Parlament
gruendung | Gründungsjahr der Partei. Wenn der genaue Tag unbekannt ist, den 1. Januar wählen.
position | Politische Position der Partei
farbcode | HTML-Farbcode, z.B. red oder #23FF23
homepage | Homepage der Partei
homepage_fr | Französische Homepage der Partei
email_fr | Französische Kontakt E-Mail-Adresse der Partei
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
twitter_name_fr | Französischer Twittername
beschreibung | Beschreibung der Partei
beschreibung_fr | Französische Beschreibung der Partei
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## kommission (kommission)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Kommission Technischer Schlüssel
abkuerzung | Kürzel der Kommission
abkuerzung_fr | Französisches Kürzel der Kommission
name | Ausgeschriebener Name der Kommission Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Ausgeschriebener französischer Name der Kommission Französicher Name des Datensatzes.
rat_id | Ratszugehörigkeit; Fremdschlüssel des Rates
typ | Typ einer Kommission (Spezialkommission ist eine Delegation im weiteren Sinne).
art | Art der Kommission gemäss Einteilung auf Parlament.ch. Achtung für Delegationen im engeren Sinne (= Subkommissionen) sollte die Art der Mutterkommission gewählt werden, z.B. GPDel ist eine Subkommission der GPK und gehört somit zu den Aufsichtskommissionen.
beschreibung | Beschreibung der Kommission
beschreibung_fr | Französische Beschreibung der Kommission
sachbereiche | Liste der Sachbereiche der Kommission, abgetrennt durch ";".
sachbereiche_fr | Liste der Sachbereiche der Kommission auf französisch, abgetrennt durch ";".
anzahl_mitglieder | Anzahl Kommissionsmitglieder
anzahl_nationalraete | Anzahl Kommissionsmitglieder des Nationalrates
anzahl_staenderaete | Anzahl Kommissionsmitglieder des Ständerates
mutter_kommission_id | Zugehörige Kommission von Delegationen im engeren Sinne (=Subkommissionen).  Also die "Oberkommission".
zweitrat_kommission_id | Entsprechende Kommission im anderen Rat, Stände- o. Nationalratskommission
von | Beginn der Kommission, leer (NULL) = unbekannt
bis | Ende der Kommission, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
parlament_url | Link zur Seite auf Parlament.ch
parlament_id | Kommissions-ID von ws.parlament.ch
parlament_committee_number | committeeNumber auf ws.parlament.ch
parlament_subcommittee_number | subcommitteeNumber auf ws.parlament.ch
parlament_type_code | typeCode von ws.parlament.ch
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## branche (branche)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Branche Technischer Schlüssel
name | Name der Branche, z.B. Gesundheit, Energie Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französischer Name der Branche, z.B. Gesundheit, Energie Französicher Name des Datensatzes.
kommission_id | Zuständige Kommission im Nationalrat
kommission2_id | Zuständige Kommission im Ständerat
technischer_name | Technischer Name für Branche. Keine Sonderzeichen sind erlaubt. Wird z.B. für das finden des Branchensymboles gebraucht.
beschreibung | Beschreibung der Branche
beschreibung_fr | Französische Beschreibung der Branche
angaben | Angaben zur Branche
angaben_fr | Angaben zur Branche auf Französisch
isicv4 | ISICv4-Codes, getrennt durch Leerzeichen. "International Standard of Industrial Classification of All Economic Activities (ISIC), Revision 4" ist ein Einteilungsstandard von Unternehmen der UNO, siehe https://unstats.un.org/unsd/publication/SeriesM/seriesm_4rev4e.pdf
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## interessengruppe (interessengruppe)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Interessengruppe Technischer Schlüssel
name | Bezeichnung der Interessengruppe Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französische Bezeichnung der Interessengruppe Französicher Name des Datensatzes.
branche_id | Fremdschlüssel Branche
beschreibung | Eingrenzung und Beschreibung zur Interessengruppe
beschreibung_fr | Eingrenzung und Beschreibung zur Interessengruppe auf französisch
alias_namen | Strichpunkt-getrennte Aufzählung von alternative Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
alias_namen_fr | Strichpunkt-getrennte Aufzählung von alternativen französischen Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
isicv4 | ISICv4-Codes, getrennt durch Leerzeichen. International Standard of Industrial Classification of All Economic Activities (ISIC), Revision 4 ist ein Einteilungsstandard der UNO, siehe https://unstats.un.org/unsd/publication/SeriesM/seriesm_4rev4e.pdf
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## organisation (organisation)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Lobbyorganisation Technischer Schlüssel
name_de | Name der Organisation. Sollte nur juristischem Namen entsprechen, ohne Zusätze, wie Adresse. Deutscher Name des Datensatzes.
name_fr | Französischer Name Französicher Name des Datensatzes.
name_it | Italienischer Name Italienischer Name des Datensatzes.
uid | UID des Handelsregisters; Schweizweit eindeutige ID (http://www.bfs.admin.ch/bfs/portal/de/index/themen/00/05/blank/03/02.html); Format: CHE-999.999.999
ehra_id | EHRA-ID des Handelsregisters
ch_id | CH-ID des Handelsregisters (alte HR-ID)
in_handelsregister | Ist die Organisation im Handelsregister (Zefix) eingetragen?
inaktiv | Gibt es die Organisation noch?
ort | Ort der Organisation
abkuerzung_de | Abkürzung der Organisation, kann in der Anzeige dem Namen nachgestellt werden, z.B. Schweizer Kaderorganisation (SKO)
alias_namen_de | Strichpunkt-getrennte Aufzählung von alternative Namen für die Organisation; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
abkuerzung_fr | Französische Abkürzung der Organisation
alias_namen_fr | Französischer Aliasnamen: Strichpunkt-getrennte Aufzählung von alternative Namen für die Organisation; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
abkuerzung_it | Italienische Abkürzung der Organisation
alias_namen_it | Italienischer Aliasnamen: Strichpunkt-getrennte Aufzählung von alternativen Namen für die Organisation; bei der Suche wird für ein einfacheres Finden auch in den Alias-Namen gesucht.
land_id | Land der Organisation
interessenraum_id | Interessenraum der Organisation
rechtsform | Rechtsform der Organisation
rechtsform_handelsregister | Code der Rechtsform des Handelsregister, z.B. 0106 für AG. Das Feld kann importiert werden.
rechtsform_zefix | Numerischer Rechtsformcode von Zefix, z.B. 3 für AG. Das Feld kann importiert werden.
typ | Typ der Organisation. Beziehungen können über Organisation_Beziehung eingegeben werden.
vernehmlassung | Häufigkeit der Teilname an nationalen Vernehmlassungen
interessengruppe_id | Fremdschlüssel Interessengruppe. Hauptinteressengruppe. Über die Interessengruppe wird eine Branche zugeordnet.
interessengruppe2_id | Fremdschlüssel Interessengruppe. 2. Interessengruppe der Organisation.
interessengruppe3_id | Fremdschlüssel Interessengruppe. 3. Interessengruppe der Organisation.
homepage | Link zur Webseite
handelsregister_url | Link zum Eintrag im Handelsregister
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
beschreibung | Beschreibung der Organisation, Zweck gemäss Handelsregister oder  Statuten
beschreibung_fr | Französische Beschreibung
sekretariat | Für parlamentarische Gruppen: Ansprechsperson, Adresse, Telephonnummer, usw. des Sekretariats der parlamentarischen Gruppen (wird importiert)
adresse_plz | Postleitzahl der Organisation
bfs_gemeinde_nr | BFS Gemeindenummer (BFS GDENR)
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
updated_by_import | Datum, wann die Organisation durch einen Import zu letzt aktualisiert wurde. Ein Datum bedeutet, dass die Organisation unter der Kontrolle des Importprozesses.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## organisation_jahr (organisation_jahr)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Jahreswerte einer Organisation Technischer Schlüssel
organisation_id | Fremdschlüssel eines Kantons
jahr | Jahr auf welche sich die Werte beziehen
umsatz | Umsatz der Organisation in Franken
gewinn | Gewinn der Organisation in Franken
kapital | Marktkapitalisierung, Stiftungskapital, … in Franken
mitarbeiter_weltweit | Anzahl Mitarbeiter weltweit
mitarbeiter_schweiz | Anzahl Mitarbeiter in der Schweiz
geschaeftsbericht_url | Link zum Geschäftsbericht
quelle_url | URL der Quelle
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## parlamentarier (parlamentarier)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
nachname | Nachname des Parlamentariers
vorname | Vornahme des Parlamentariers
vorname_kurz | Alltagsvorname oder gebräuchlicher Spitzname, z.B. Nik für Niklaus
zweiter_vorname | Zweiter Vorname des Parlamentariers
buergerorte | Strichpunkt getrennte Liste der Bürgerorte
rat_id | Ratszugehörigkeit; Fremdschlüssel des Rates
kanton_id | Kantonszugehörigkeit; Fremdschlüssel des Kantons
kommissionen | Abkürzungen der Kommissionen des Parlamentariers (automatisch erzeugt [in_Kommission Trigger])
partei_id | Fremdschlüssel Partei. Leer bedeutet parteilos.
parteifunktion | Funktion des Parlamentariers in der Partei
fraktion_id | Fraktionszugehörigkeit im nationalen Parlament. Fremdschlüssel.
fraktionsfunktion | Funktion des Parlamentariers in der Fraktion
im_rat_seit | Jahr der Zugehörigkeit zum Parlament
im_rat_bis | Austrittsdatum aus dem Parlament. Leer (NULL) = aktuell im Rat, nicht leer = historischer Eintrag
ratswechsel | Datum in welchem der Parlamentarier den Rat wechselte, in der Regel vom National- in den Ständerat. Leer (NULL) = kein Ratswechsel hat stattgefunden
ratsunterbruch_von | Unterbruch in der Ratstätigkeit von, leer (NULL) = kein Unterbruch
ratsunterbruch_bis | Unterbruch in der Ratstätigkeit bis, leer (NULL) = kein Unterbruch
beruf | Beruf des Parlamentariers
beruf_fr | Beruf des Parlamentariers auf französisch
beruf_interessengruppe_id | Zuordnung (Fremdschlüssel) zu Interessengruppe für den Beruf des Parlamentariers
titel | Titel des Parlamentariers, wird von ws.parlament.ch importiert
aemter | Politische Ämter (importiert von ws.parlament.ch mandate)
weitere_aemter | Zusätzliche Ämter (importiert von ws.parlament.ch additionalMandate)
zivilstand | Zivilstand
anzahl_kinder | Anzahl der Kinder
militaerischer_grad_id | Militärischer Grad, leer (NULL) = kein Militärdienst
geschlecht | Geschlecht des Parlamentariers, M=Mann, F=Frau
geburtstag | Geburtstag des Parlamentariers
photo_dateiname | Photodateiname ohne Erweiterung
photo_dateierweiterung | Erweiterung der Photodatei
photo_dateiname_voll | Photodateiname mit Erweiterung
photo_mime_type | MIME Type des Photos
kleinbild | Bild 44x62 px oder leer.png
sitzplatz | Sitzplatznr im Parlament. Siehe Sitzordnung auf parlament.ch
email_2 | 2. (private) E-Mail-Adresse des Parlamentariers
homepage | Homepage des Parlamentariers
homepage_2 | Zweite Homepage, importiert von ws.parlament.ch
parlament_biografie_id | Biographie ID auf Parlament.ch; Dient zur Herstellung eines Links auf die Parlament.ch Seite des Parlamenteriers. Zudem kann die ID für die automatische Verarbeitung gebraucht werden.
parlament_number | Number Feld auf ws.parlament.ch, wird von ws.parlament.ch importiert, wird z.B. als ID für Photos verwendet.
parlament_beruf_json | Importierter Beruf des Parlamentariers: Beruf, Arbeitgeber, Jobtitel/Funktion, von, bis (von parlament.ch)
parlament_interessenbindungen | Importierte Interessenbindungen von ws.parlament.ch
parlament_interessenbindungen_json | Importierte Interessenbindungen von ws.parlament.ch als JSON. Rechtsformen: -, AG, Anst., EG, EidgKomm, Gen., GmbH, KollG, Komm., Körp., Stift., Ve., öffStift; Gremien: -, A, AufR., Bei., D, GL, GL, V, GV, Pat., Sr., V, VR, Vw., ZA, ZV; Funktionen: -, A, AufR., Bei., D, GL, GL, V, GV, Pat., Sr., V, VR, Vw., ZA, ZV
parlament_interessenbindungen_updated | Datum, wann die Interessenbindungen von ws.parlament.ch zu letzt aktualisiert wurden.
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
wikipedia | Link zum Wikipedia-Eintrag des Parlamentariers
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
sprache | Sprache des Parlamentariers, wird von ws.parlament.ch importiert
arbeitssprache | Arbeitssprache des Parlamentariers, erhältlich auf parlament.ch
adresse_firma | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
adresse_plz | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
adresse_ort | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
bfs_gemeinde_nr | BFS Gemeindenummer (BFS GDENR)
erfasst | Ist der Parlamentarier erfasst? Falls der Parlamentarier beispielsweise nicht mehr zur Wiederwahl antritt und deshalb nicht erfasst wird, kann dieses Feld auf Nein gestellt werden. NULL bedeutet Status unklar.
autorisierung_reminder_verschickt_visa | Autorisierungerinnerung verschickt durch
autorisierung_reminder_verschickt_datum | Autorisierungerinnerung verschickt am. (Leer/NULL bedeutet noch keine Anfrage verschickt.)
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass die Interessenbindungen und Zutrittsberechtigungen vom Parlamentarier autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## parlamentarier_transparenz (parlamentarier_transparenz)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
stichdatum | Stichdatum der Auswertung der Vergütungstransparenz
in_liste | Ist dieser Eintrag in der Transparenzliste mit dem angegebenen Stichdatum enthalten? (Dieses Feld verhindert Transparenzlisteneinträge löschen zu müssen, wenn diese nicht in der Transparenzliste enthalten sind.)
verguetung_transparent | Ist der dieser Parlamentarier transparent bzgl seinen Vergütungen? ja, nein, teilweise (Leer/NULL bedeutet noch nicht eingetragen): NEIN=Minimaltransparenz (= gesetzliches Minimum, bezahlt/ehrenamtlich); TEILWEISE=teilweise transparent (=gesetzl Minimum plus einzelne Entschädigungen als Betrag offengelegt); JA=transparent (=gesetzl. Minimum plus alles Entschädigungen offengelegt; Exkl. Entschädigung aus Hauptberuf)
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## person (person)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Zugangsberechtigung Technischer Schlüssel
nachname | Nachname des berechtigten Persion
vorname | Vorname der berechtigten Person
vorname_kurz | Alltagsvorname oder gebräuchlicher Spitzname, z.B. Nik für Niklaus
zweiter_vorname | Zweiter Vorname der zutrittsberechtigten Person
buergerorte | Strichpunkt getrennte Liste der Bürgerorte
namensunterscheidung | Namenszusatz zur Unterscheiden von Personen mit exakt gleichem Namen. Ein Unterscheidungsmerkmal der Person z.B. der Beruf, sollte im Feld gespeichert werden. NUR BEI PERSONEN MIT EXAKT GLEICHEM VORNAMEN UND NAMEN VERWENDEN.
beschreibung_de | Beschreibung der Person. Der Text ist öffentlich einsehbar.
beschreibung_fr | Französische Beschreibung der Person. Der Text ist öffentlich einsehbar.
parlamentarier_kommissionen | Abkürzungen der Kommissionen des zugehörigen Parlamentariers (automatisch erzeugt [in_Kommission/person Trigger])
zutrittsberechtigung_von | Welcher Parlamentarier gab die Zutrittsberechtigung?
beruf | Beruf der Person
beruf_fr | Französische Bezeichung des Beruf der Person
titel | Titel der Person, z.B. Lic. iur.
beruf_interessengruppe_id | Fremdschlüssel zur Interessengruppe für den Beruf
partei_id | Fremdschlüssel Partei. Parteimitgliedschaft der zutrittsberechtigten Person.
geschlecht | Geschlecht des Parlamentariers, M=Mann, F=Frau
arbeitssprache | Arbeitssprache des Zutrittsberechtigten
homepage | Homepage der zutrittsberechtigen Person
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
ist_parlamentarier_id | Verknüpfung zu Parlamentarier_in, falls diese Person einmal im Parlament war
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
updated_by_import | Datum, wann die Person durch einen Import zu letzt aktualisiert wurde.
erfasst | Ist die Person erfasst? Falls der zugehörige Parlamentarier beispielsweise nicht mehr zur Wiederwahl antritt und deshalb die Person nicht erfasst wird, kann dieses Feld auf Nein gestellt werden. NULL bedeutet Status unklar.
autorisierung_reminder_verschickt_visa | Autorisierungerinnerung verschickt durch
autorisierung_reminder_verschickt_datum | Autorisierungerinnerung verschickt am. (Leer/NULL bedeutet noch keine Anfrage verschickt.)
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## country (country)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Primary key Technischer Schlüssel
continent | Kontinent
name_en | Name des Landes auf Englisch
official_name_en | Offizieller Name des Landes (englisch)
capital_en | Hauptstadt auf Englisch
name_de | Name des Landes auf Deutsch Deutscher Name des Datensatzes.
official_name_de | Offizieller Name des Landes (deutsch)
type | Art Territoriums
capital_de | Hauptstadt auf Deutsch
name_fr | Französischer Name Französicher Name des Datensatzes.
official_name_fr | Offizieller Name des Landes (französisch)
capital_fr | Hauptstadt auf Französisch
name_it | Italienischer Name Italienischer Name des Datensatzes.
official_name_it | Offizieller Name des Landes (italiensich)
capital_it | Hauptstadt auf Italienisch
iso2 | ISO 3166 ALPHA-2 Code
iso3 | ISO 3166 ALPHA-3 Code
vehicle_code | Nationalitätszeichen für Fahrzeuge
ioc |  Ländercodes des Internationalen Olympischen Komitees (IOC)
tld | Top Level Domain für Internet
currency | Währungsabkürzung
phone | Internatinale Vorwahl
utc | Verschiebung zur Weltzeit GMT
show_level | Anzeigestufe je höher desto selektiver
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## mil_grad (mil_grad)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Militärischer Grad Technischer Schlüssel
name | Name des militärischen Grades Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französischer Name des militärischen Grades Französicher Name des Datensatzes.
abkuerzung | Abkürzung des militärischen Grades
abkuerzung_fr | Französische Abkürzung des militärischen Grades
typ | Stufe des militärischen Grades
ranghoehe | Ranghöhe des Grades
anzeigestufe | Anzeigestufe, je höher desto selektiver, >=0 = alle werden angezeigt, >0 = Standardanzeige
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## bfs_gemeinde (bfs_gemeinde)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Technischer Schlüssel
gdekt | Kantonskürzel
gdebznr | BFS Bezirknummer
gdenr | BFS Gemeindenummer
gdename | Name
gdenamk | Name kurz
gdebzna | Bezirk
gdektna | Kanton
gdemutdat | Mutationsdatum
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## interessenbindung (interessenbindung)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Interessenbindung Technischer Schlüssel
parlamentarier_id | Fremdschlüssel Parlamentarier
organisation_id | Fremdschlüssel Organisation
art | Art der Interessenbindung
funktion_im_gremium | Funktion innerhalb des Gremiums, z.B. Präsident in einem Vorstand einer AG entspricht einem Verwaltungsratspräsidenten, Präsident einer Geschäftsleitung entspricht einem CEO.
deklarationstyp | Ist diese Interessenbindung deklarationspflichtig? Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
status | Status der Interessenbindung
hauptberuflich | Eigene Firma/Haupttätigkeit: Ist diese Interessenbindung hauptberuflich? (Hauptberufliche Interessenbindungen müssen nicht offengelegt werden.)
behoerden_vertreter | Entstand diese Interessenbindung als Behördenvertreter von Amtes wegen? Beispielsweise weil ein Regierungsrat in einem Verwaltungsrat von Amtes wegen Einsitz nimmt.
beschreibung | Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
beschreibung_fr | Französische Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist die Quell-URL noch gültig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn der Interessenbindung, leer (NULL) = unbekannt
bis | Ende der Interessenbindung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
unterscheidung | Unterscheidungsfeld für ansonsten gleiche Interessenbindungen (parlamentarier_id, organisation_id, art und bis). NUR ANGEBEN WO NÖTIG.
updated_by_import | Datum, wann die Interessenbindung durch einen Import zu letzt aktualisiert wurde. Ein Datum bedeutet, dass die Interessenbindung unter der Kontrolle des Importprozesses.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## interessenbindung_jahr (interessenbindung_jahr)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Jahresvergütung von Intressenbindung Technischer Schlüssel
interessenbindung_id | Fremdschlüssel der Interessenbindung
jahr | Jahr auf welche sich die Werte beziehen
verguetung | Jährliche Vergütung CHF für Tätigkeiten aus dieser Interessenbindung, z.B. Entschädigung für Beiratsfunktion.
beschreibung | Beschreibung der Vergütung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass die Interessenbindungen vom Parlamentarier autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## in_kommission (in_kommission)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel einer Kommissionszugehörigkeit Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
kommission_id | Fremdschlüssel der Kommission
funktion | Funktion des Parlamentariers in der Kommission
parlament_committee_function | committeeFunction von ws.parlament.ch
parlament_committee_function_name | committeeFunctionName von ws.parlament.ch
von | Beginn der Kommissionszugehörigkeit, leer (NULL) = unbekannt
bis | Ende der Kommissionszugehörigkeit, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## in_rat (in_rat)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
rat_id | Fremdschlüssel des Rates
vorgaenger_parlamentarier_id | Vorgänger des Parlamentariers bei Nachgerutschten (Fremdschlüssel)
funktion | Funktion des Parlamentariers im Rat
von | Beginn der Ratszugehörigkeit, leer (NULL) = unbekannt
bis | Ende der Ratszugehörigkeit, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## in_partei (in_partei)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
partei_id | Fremdschlüssel der Partei
funktion | Funktion des Parlamentariers in der Partei
von | Beginn der Parteizugehörigkeit, leer (NULL) = unbekannt
bis | Ende der Parteizugehörigkeit, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## in_fraktion (in_fraktion)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
fraktion_id | Fremdschlüssel der Fraktion
funktion | Funktion des Parlamentariers in der Fraktion
von | Beginn der Fraktionszugehörigkeit, leer (NULL) = unbekannt
bis | Ende der Fraktionszugehörigkeit, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## mandat (mandat)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel
person_id | Fremdschlüssel Person
organisation_id | Fremdschlüssel Organisation
art | Art der Funktion des Mandatsträgers innerhalb der Organisation
funktion_im_gremium | Funktion innerhalb des Gremiums, z.B. Präsident in einem Vorstand einer AG entspricht einem Verwatlungsratspräsidenten, Präsident einer Geschäftsleitung entspricht einem CEO.
hauptberuflich | Eigene Firma/Haupttätigkeit: Ist dieses Mandat hauptberuflich? (Hauptberufliche Mandate müssen nicht offengelegt werden.)
beschreibung | Umschreibung des Mandates. Beschreibung wird nicht ausgewertet, jedoch in den Resultaten angezeigt.
beschreibung_fr | Französische Bezeichung des Mandates. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist die Quell-URL noch gültig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn des Mandates, leer (NULL) = unbekannt
bis | Ende des Mandates, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
unterscheidung | Unterscheidungsfeld für ansonsten gleiche Mandate (person_id, organisation_id, art und bis). NUR ANGEBEN WO NÖTIG.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## mandat_jahr (mandat_jahr)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel Jahresvergütung von Mandat Technischer Schlüssel
mandat_id | Fremdschlüssel des Mandates
jahr | Jahr auf welche sich die Werte beziehen
verguetung | Jährliche Vergütung CHF für Tätigkeiten des Mandates, z.B. Entschädigung für Beiratsfunktion.
beschreibung | Beschreibung der Verfgütung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass das Mandat von der Person autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## zutrittsberechtigung (zutrittsberechtigung)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Zutrittsberechtigung Technischer Schlüssel
parlamentarier_id | Fremdschlüssel Parlamentarier
person_id | Fremdschlüssel zur zutrittsberechtigten Person
parlamentarier_kommissionen | Abkürzungen der Kommissionen des zugehörigen Parlamentariers (automatisch erzeugt [in_Kommission/zutrittsberechtigung Trigger])
funktion | Funktion der zutrittsberechtigen Person.
funktion_fr | Funktion der zutrittsberechtigen Person auf französisch.
von | Beginn der Zutrittsberechtigung, leer (NULL) = unbekannt
bis | Ende der Zutrittsberechtigung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
updated_by_import | Datum, wann die Zutrittsberechtigung durch einen Import zu letzt aktualisiert wurde.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## organisation_beziehung (organisation_beziehung)

Datensatztyp: sql

Feld | Beschreibung
- | -
id | Technischer Schlüssel einer Organisationsbeziehung Technischer Schlüssel
organisation_id | Fremdschlüssel Organisation.
ziel_organisation_id | Fremdschlüssel der Zielorganisation.
art | Beschreibt die Beziehung einer Organisation zu einer Zielorgansation
beschreibung | Bezeichung der Organisationsbeziehung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
beschreibung_fr | Französische Bezeichung der Organisationsbeziehung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn der Organisationsbeziehung, leer (NULL) = unbekannt
bis | Ende der Organisationsbeziehung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am

