Lobbywatch Export: GraphML
==========================

Datei: export/lobbywatch.graphml  
Datum: 03.11.2025 02:31:01  
Exporttyp: Öffentlich / Public  

Herausgeber: Lobbywatch (https://lobbywatch.ch)  

Die Inhalte von Lobbywatch.ch sind lizenziert unter einer Creative Commons Namensnennung - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz. (https://creativecommons.org/licenses/by-sa/4.0/deed.de)

Data are licensed as CC BY-SA

## partei (partei)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
abkuerzung_mixed | Abkürzung deutsch und französisch
id | Technischer Schlüssel der Partei Technischer Schlüssel
abkuerzung | Parteiabkürzung
abkuerzung_fr | Französische Parteiabkürzung
name | Ausgeschriebener Name der Partei Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Ausgeschriebener französischer Name der Partei Französicher Name des Datensatzes.
fraktion_id | Fraktionszugehörigkeit der Partei im nationalen Parlament
gruendung | Gründungsjahr der Partei. Wenn der genaue Tag unbekannt ist, den 1. Januar wählen.
position | Politische Position der Partei
farbcode | HTML-Farbcode, z.B. red oder #23FF23
homepage | Homepage der Partei
homepage_fr | Französische Homepage der Partei
email_fr | Französische Kontakt E-Mail-Adresse der Partei
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
twitter_name_fr | Französischer Twittername
beschreibung | Beschreibung der Partei
beschreibung_fr | Französische Beschreibung der Partei
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
name_de | Ausgeschriebener Name der Partei Deutscher Name des Datensatzes.
abkuerzung_de | Parteiabkürzung
beschreibung_de | Beschreibung der Partei
homepage_de | Homepage der Partei
twitter_name_de | Twittername
email_de | Kontakt E-Mail-Adresse der Partei
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## branche (branche)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
id | Technischer Schlüssel der Branche Technischer Schlüssel
name | Name der Branche, z.B. Gesundheit, Energie Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französischer Name der Branche, z.B. Gesundheit, Energie Französicher Name des Datensatzes.
kommission_id | Zuständige Kommission im Nationalrat
kommission2_id | Zuständige Kommission im Ständerat
technischer_name | Technischer Name für Branche. Keine Sonderzeichen sind erlaubt. Wird z.B. für das finden des Branchensymboles gebraucht.
beschreibung | Beschreibung der Branche
beschreibung_fr | Französische Beschreibung der Branche
angaben | Angaben zur Branche
angaben_fr | Angaben zur Branche auf Französisch
isicv4 | ISICv4-Codes, getrennt durch Leerzeichen. "International Standard of Industrial Classification of All Economic Activities (ISIC), Revision 4" ist ein Einteilungsstandard von Unternehmen der UNO, siehe https://unstats.un.org/unsd/publication/SeriesM/seriesm_4rev4e.pdf
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
name_de | Name der Branche, z.B. Gesundheit, Energie Deutscher Name des Datensatzes.
beschreibung_de | Beschreibung der Branche
angaben_de | Angaben zur Branche
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## interessengruppe (interessengruppe)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
id | Technischer Schlüssel der Interessengruppe Technischer Schlüssel
name | Bezeichnung der Interessengruppe Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französische Bezeichnung der Interessengruppe Französicher Name des Datensatzes.
branche_id | Fremdschlüssel Branche
beschreibung | Eingrenzung und Beschreibung zur Interessengruppe
beschreibung_fr | Eingrenzung und Beschreibung zur Interessengruppe auf französisch
alias_namen | Strichpunkt-getrennte Aufzählung von alternative Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
alias_namen_fr | Strichpunkt-getrennte Aufzählung von alternativen französischen Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
isicv4 | ISICv4-Codes, getrennt durch Leerzeichen. International Standard of Industrial Classification of All Economic Activities (ISIC), Revision 4 ist ein Einteilungsstandard der UNO, siehe https://unstats.un.org/unsd/publication/SeriesM/seriesm_4rev4e.pdf
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
name_de | Bezeichnung der Interessengruppe Deutscher Name des Datensatzes.
beschreibung_de | Eingrenzung und Beschreibung zur Interessengruppe
alias_namen_de | Strichpunkt-getrennte Aufzählung von alternative Namen für die Lobbygruppe; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## interessenraum (interessenraum)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Name des Interessenbereiches Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Name des Interessenbereiches Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Name des Interessenbereiches Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
id | Technischer Schlüssel des Interessenraumes Technischer Schlüssel
name | Name des Interessenbereiches Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Französischer Name des Interessenbereiches Französicher Name des Datensatzes.
beschreibung | Beschreibung des Interessenraumes
beschreibung_fr | Französische Beschreibung des Interessenraumes
reihenfolge | Anzeigereihenfolge (je kleiner desto höher)
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
name_de | Name des Interessenbereiches Deutscher Name des Datensatzes.
beschreibung_de | Beschreibung des Interessenraumes
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## kommission (kommission)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
id | Technischer Schlüssel der Kommission Technischer Schlüssel
abkuerzung | Kürzel der Kommission
abkuerzung_fr | Französisches Kürzel der Kommission
name | Ausgeschriebener Name der Kommission Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Ausgeschriebener französischer Name der Kommission Französicher Name des Datensatzes.
rat_id | Ratszugehörigkeit; Fremdschlüssel des Rates
typ | Typ einer Kommission (Spezialkommission ist eine Delegation im weiteren Sinne).
art | Art der Kommission gemäss Einteilung auf Parlament.ch. Achtung für Delegationen im engeren Sinne (= Subkommissionen) sollte die Art der Mutterkommission gewählt werden, z.B. GPDel ist eine Subkommission der GPK und gehört somit zu den Aufsichtskommissionen.
beschreibung | Beschreibung der Kommission
beschreibung_fr | Französische Beschreibung der Kommission
sachbereiche | Liste der Sachbereiche der Kommission, abgetrennt durch ";".
sachbereiche_fr | Liste der Sachbereiche der Kommission auf französisch, abgetrennt durch ";".
anzahl_mitglieder | Anzahl Kommissionsmitglieder
anzahl_nationalraete | Anzahl Kommissionsmitglieder des Nationalrates
anzahl_staenderaete | Anzahl Kommissionsmitglieder des Ständerates
mutter_kommission_id | Zugehörige Kommission von Delegationen im engeren Sinne (=Subkommissionen).  Also die "Oberkommission".
zweitrat_kommission_id | Entsprechende Kommission im anderen Rat, Stände- o. Nationalratskommission
von | Beginn der Kommission, leer (NULL) = unbekannt
bis | Ende der Kommission, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
parlament_url | Link zur Seite auf Parlament.ch
parlament_id | Kommissions-ID von ws.parlament.ch
parlament_committee_number | committeeNumber auf ws.parlament.ch
parlament_subcommittee_number | subcommitteeNumber auf ws.parlament.ch
parlament_type_code | typeCode von ws.parlament.ch
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
name_de | Ausgeschriebener Name der Kommission Deutscher Name des Datensatzes.
abkuerzung_de | Kürzel der Kommission
beschreibung_de | Beschreibung der Kommission
sachbereiche_de | Liste der Sachbereiche der Kommission, abgetrennt durch ";".
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## organisation (organisation)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_mixed | Anzeigename aller Sprachen (deutsch, französich und italienisch), durch Semikolon ('; ') getrennt
anzeige_bimixed | Anzeigename in den Sprachen deutsch und französich, durch Semikolon ('; ') getrennt
searchable_name | Name, welcher für die Suche gebraucht wird.
anzeige_name_de | Name der Organisation. Sollte nur juristischem Namen entsprechen, ohne Zusätze, wie Adresse. Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Name Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
name | Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
id | Technischer Schlüssel der Lobbyorganisation Technischer Schlüssel
name_de | Name der Organisation. Sollte nur juristischem Namen entsprechen, ohne Zusätze, wie Adresse. Deutscher Name des Datensatzes.
name_fr | Französischer Name Französicher Name des Datensatzes.
name_it | Italienischer Name Italienischer Name des Datensatzes.
uid | UID des Handelsregisters; Schweizweit eindeutige ID (http://www.bfs.admin.ch/bfs/portal/de/index/themen/00/05/blank/03/02.html); Format: CHE-999.999.999
ehra_id | EHRA-ID des Handelsregisters
ch_id | CH-ID des Handelsregisters (alte HR-ID)
in_handelsregister | Ist die Organisation im Handelsregister (Zefix) eingetragen?
inaktiv | Gibt es die Organisation noch?
ort | Ort der Organisation
abkuerzung_de | Abkürzung der Organisation, kann in der Anzeige dem Namen nachgestellt werden, z.B. Schweizer Kaderorganisation (SKO)
alias_namen_de | Strichpunkt-getrennte Aufzählung von alternative Namen für die Organisation; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
abkuerzung_fr | Französische Abkürzung der Organisation
alias_namen_fr | Französischer Aliasnamen: Strichpunkt-getrennte Aufzählung von alternative Namen für die Organisation; bei der Suche werden für ein einfacheres Finden auch in den Alias-Namen gesucht.
abkuerzung_it | Italienische Abkürzung der Organisation
alias_namen_it | Italienischer Aliasnamen: Strichpunkt-getrennte Aufzählung von alternativen Namen für die Organisation; bei der Suche wird für ein einfacheres Finden auch in den Alias-Namen gesucht.
land_id | Land der Organisation
interessenraum_id | Interessenraum der Organisation
rechtsform | Rechtsform der Organisation
rechtsform_handelsregister | Code der Rechtsform des Handelsregister, z.B. 0106 für AG. Das Feld kann importiert werden.
rechtsform_zefix | Numerischer Rechtsformcode von Zefix, z.B. 3 für AG. Das Feld kann importiert werden.
typ | Typ der Organisation. Beziehungen können über Organisation_Beziehung eingegeben werden.
vernehmlassung | Häufigkeit der Teilname an nationalen Vernehmlassungen
interessengruppe_id | Fremdschlüssel Interessengruppe. Hauptinteressengruppe. Über die Interessengruppe wird eine Branche zugeordnet.
interessengruppe2_id | Fremdschlüssel Interessengruppe. 2. Interessengruppe der Organisation.
interessengruppe3_id | Fremdschlüssel Interessengruppe. 3. Interessengruppe der Organisation.
homepage | Link zur Webseite
handelsregister_url | Link zum Eintrag im Handelsregister
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
beschreibung | Beschreibung der Organisation, Zweck gemäss Handelsregister oder  Statuten
beschreibung_fr | Französische Beschreibung
sekretariat | Für parlamentarische Gruppen: Ansprechsperson, Adresse, Telephonnummer, usw. des Sekretariats der parlamentarischen Gruppen (wird importiert)
adresse_plz | Postleitzahl der Organisation
bfs_gemeinde_nr | BFS Gemeindenummer (BFS GDENR)
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
updated_by_import | Datum, wann die Organisation durch einen Import zu letzt aktualisiert wurde. Ein Datum bedeutet, dass die Organisation unter der Kontrolle des Importprozesses.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
organisation_name_de_rechtsform_uid_unique | Kombination aus name_de, rechtsform, uid und inaktiv muss eindeutig sein. (Fachlicher unique constraint)
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## organisation_jahr (organisation_jahr)

Datensatztyp: node

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Jahreswerte einer Organisation Technischer Schlüssel
organisation_id | Fremdschlüssel eines Kantons
jahr | Jahr auf welche sich die Werte beziehen
umsatz | Umsatz der Organisation in Franken
gewinn | Gewinn der Organisation in Franken
kapital | Marktkapitalisierung, Stiftungskapital, … in Franken
mitarbeiter_weltweit | Anzahl Mitarbeiter weltweit
mitarbeiter_schweiz | Anzahl Mitarbeiter in der Schweiz
geschaeftsbericht_url | Link zum Geschäftsbericht
quelle_url | URL der Quelle
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## parlamentarier (parlamentarier)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
name | Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_de | Deutscher Name des Datensatzes.
name_fr | Französicher Name des Datensatzes.
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
nachname | Nachname des Parlamentariers
vorname | Vornahme des Parlamentariers
vorname_kurz | Alltagsvorname oder gebräuchlicher Spitzname, z.B. Nik für Niklaus
zweiter_vorname | Zweiter Vorname des Parlamentariers
buergerorte | Strichpunkt getrennte Liste der Bürgerorte
rat_id | Ratszugehörigkeit; Fremdschlüssel des Rates
kanton_id | Kantonszugehörigkeit; Fremdschlüssel des Kantons
kommissionen | Abkürzungen der Kommissionen des Parlamentariers (automatisch erzeugt [in_Kommission Trigger])
partei_id | Fremdschlüssel Partei. Leer bedeutet parteilos.
parteifunktion | Funktion des Parlamentariers in der Partei
fraktion_id | Fraktionszugehörigkeit im nationalen Parlament. Fremdschlüssel.
fraktionsfunktion | Funktion des Parlamentariers in der Fraktion
im_rat_seit | Jahr der Zugehörigkeit zum Parlament
im_rat_bis | Austrittsdatum aus dem Parlament. Leer (NULL) = aktuell im Rat, nicht leer = historischer Eintrag
ratswechsel | Datum in welchem der Parlamentarier den Rat wechselte, in der Regel vom National- in den Ständerat. Leer (NULL) = kein Ratswechsel hat stattgefunden
ratsunterbruch_von | Unterbruch in der Ratstätigkeit von, leer (NULL) = kein Unterbruch
ratsunterbruch_bis | Unterbruch in der Ratstätigkeit bis, leer (NULL) = kein Unterbruch
beruf | Beruf des Parlamentariers
beruf_fr | Beruf des Parlamentariers auf französisch
beruf_interessengruppe_id | Zuordnung (Fremdschlüssel) zu Interessengruppe für den Beruf des Parlamentariers
titel | Titel des Parlamentariers, wird von ws.parlament.ch importiert
aemter | Politische Ämter (importiert von ws.parlament.ch mandate)
weitere_aemter | Zusätzliche Ämter (importiert von ws.parlament.ch additionalMandate)
zivilstand | Zivilstand
anzahl_kinder | Anzahl der Kinder
militaerischer_grad_id | Militärischer Grad, leer (NULL) = kein Militärdienst
geschlecht | Geschlecht des Parlamentariers, M=Mann, F=Frau
geburtstag | Geburtstag des Parlamentariers
photo_dateiname | Photodateiname ohne Erweiterung
photo_dateierweiterung | Erweiterung der Photodatei
photo_dateiname_voll | Photodateiname mit Erweiterung
photo_mime_type | MIME Type des Photos
kleinbild | Bild 44x62 px oder leer.png
sitzplatz | Sitzplatznr im Parlament. Siehe Sitzordnung auf parlament.ch
email_2 | 2. (private) E-Mail-Adresse des Parlamentariers
homepage | Homepage des Parlamentariers
homepage_2 | Zweite Homepage, importiert von ws.parlament.ch
parlament_biografie_id | Biographie ID auf Parlament.ch; Dient zur Herstellung eines Links auf die Parlament.ch Seite des Parlamenteriers. Zudem kann die ID für die automatische Verarbeitung gebraucht werden.
parlament_number | Number Feld auf ws.parlament.ch, wird von ws.parlament.ch importiert, wird z.B. als ID für Photos verwendet.
parlament_beruf_json | Importierter Beruf des Parlamentariers: Beruf, Arbeitgeber, Jobtitel/Funktion, von, bis (von parlament.ch)
parlament_interessenbindungen | Importierte Interessenbindungen von ws.parlament.ch
parlament_interessenbindungen_json | Importierte Interessenbindungen von ws.parlament.ch als JSON. Rechtsformen: -, AG, Anst., EG, EidgKomm, Gen., GmbH, KollG, Komm., Körp., Stift., Ve., öffStift; Gremien: -, A, AufR., Bei., D, GL, GL, V, GV, Pat., Sr., V, VR, Vw., ZA, ZV; Funktionen: -, A, AufR., Bei., D, GL, GL, V, GV, Pat., Sr., V, VR, Vw., ZA, ZV
parlament_interessenbindungen_updated | Datum, wann die Interessenbindungen von ws.parlament.ch zu letzt aktualisiert wurden.
twitter_name | Twittername
instagram_profil | Instagram Username (Profil)
youtube_user | Youtube Username
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
wikipedia | Link zum Wikipedia-Eintrag des Parlamentariers
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
sprache | Sprache des Parlamentariers, wird von ws.parlament.ch importiert
arbeitssprache | Arbeitssprache des Parlamentariers, erhältlich auf parlament.ch
adresse_firma | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
adresse_plz | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
adresse_ort | Wohnadresse des Parlamentariers, falls verfügbar, sonst Postadresse; Adressen erhältlich auf parlament.ch
bfs_gemeinde_nr | BFS Gemeindenummer (BFS GDENR)
erfasst | Ist der Parlamentarier erfasst? Falls der Parlamentarier beispielsweise nicht mehr zur Wiederwahl antritt und deshalb nicht erfasst wird, kann dieses Feld auf Nein gestellt werden. NULL bedeutet Status unklar.
autorisierung_reminder_verschickt_visa | Autorisierungerinnerung verschickt durch
autorisierung_reminder_verschickt_datum | Autorisierungerinnerung verschickt am. (Leer/NULL bedeutet noch keine Anfrage verschickt.)
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass die Interessenbindungen und Zutrittsberechtigungen vom Parlamentarier autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
beruf_de | Beruf des Parlamentariers
von | Jahr der Zugehörigkeit zum Parlament
bis | Austrittsdatum aus dem Parlament. Leer (NULL) = aktuell im Rat, nicht leer = historischer Eintrag
aktiv | 0/1: Ist der Datensatz zum Zeitpunkt des Exportes aktuell? , 1=aktiv, 0=abgelaufen/historisiert. Der Wert 'aktiv' wird vom 'von'- und 'bis'-Datum berechnet.
geburtstag_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe geburtstag
im_rat_seit_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe im_rat_seit
im_rat_bis_unix | Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe im_rat_bis
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'
von_unix | Von-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'von'
bis_unix | Bis-Datum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'bis'


## fraktion (fraktion)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
id | Technischer Schlüssel der Fraktion Technischer Schlüssel
abkuerzung | Fraktionsabkürzung
name | Ausgeschriebener Name der Fraktion Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_fr | Ausgeschriebener französischer Name der Fraktion Französicher Name des Datensatzes.
position | Politische Position der Fraktion
farbcode | HTML-Farbcode, z.B. red oder #23FF23
beschreibung | Beschreibung der Fraktion
beschreibung_fr | Französische Beschreibung der Fraktion
von | Beginn der Fraktion, leer (NULL) = unbekannt
bis | Ende der Fraktion, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
name_de | Ausgeschriebener Name der Fraktion Deutscher Name des Datensatzes.
beschreibung_de | Beschreibung der Fraktion
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## rat (rat)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Name auf deutsch Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Name auf deutsch Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Name auf deutsch Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
abkuerzung_mixed | Abkürzung deutsch und französisch
id | Technischer Schlüssel der Jahreswerte eines Rates Technischer Schlüssel
abkuerzung | Kürzel des Rates
abkuerzung_fr | Französische Abkürzung
name_de | Name auf deutsch Deutscher Name des Datensatzes.
name_fr | Name auf französisch Französicher Name des Datensatzes.
name_it | Name auf italienisch Italienischer Name des Datensatzes.
name_en | Name auf englisch
anzahl_mitglieder | Anzahl Mitglieder des Rates
typ | Typ des Rates
interessenraum_id | Interessenraum des Rates
anzeigestufe | Anzeigestufe, je höher desto selektiver, >=0 = alle werden angezeigt, >0 = Standardanzeige
gewicht | Reihenfolge der Einträge, je grösser desto tiefer ("schwerer")
beschreibung | Eine Beschreibung
homepage_de | Deutschsprachige Homepage
homepage_fr | Franszösichsprache Homepage
homepage_it | Italienischsprachige Homepage
homepage_en | Englischsprachige Homepage
mitglied_bezeichnung_maennlich_de | Deutsche Bezeichnung der Männer
mitglied_bezeichnung_weiblich_de | Deutsche Bezeichung der Frauen
mitglied_bezeichnung_maennlich_fr | Französische Bezeichnung der Männer
mitglied_bezeichnung_weiblich_fr | Französische Bezeichung der Frauen
parlament_id | ID auf ws.parlament.ch
parlament_type | Ratstypecode von ws.parlament.ch
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## kanton (kanton)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Deutscher Name des Kantons Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Name des Kantons Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Name Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_mixed | Anzeigename deutsch und französisch
id | Technischer Schlüssel des Kantons Technischer Schlüssel
abkuerzung | Kantonskürzel
kantonsnr | Nummer des Kantons gemäss Verfassung
name_de | Deutscher Name des Kantons Deutscher Name des Datensatzes.
name_fr | Französischer Name Französicher Name des Datensatzes.
name_it | Italienischer Name Italienischer Name des Datensatzes.
romandie | Gehört dieser Kanton zur Romandie?
anzahl_staenderaete | Anzahl Ständeräte
amtssprache | Amtssprachen des Kantons
hauptort_de | Hauptort des Kantons
hauptort_fr | Hauptort auf französisch
hauptort_it | Hauptort auf italienisch
flaeche_km2 | Fläche in km2
beitrittsjahr | Beitrittsjahr zur Schweiz
wappen_svg | SVG Wappen des Kantons
wappen_svg_pfad | Pfad zu SVG Wappen des Kantons
wappen_klein | Pfad zu kleinem Wappen des Kantons (25px)
wappen | Pfad zu Wappen des Kantons (50px)
lagebild | Pfad zum lagebild des Kantons
homepage | Homepage des Kantons
beschreibung | Beschreibung des Kantons
wikipedia | Link zum Wikipedia-Eintrag
wikidata_qid | Wikidata Item Q-ID. Wikidata enthält sprachunabhängige Wikipediadaten und stellt eine global gültige ID dar (semantic Web). Die Q-ID wird aufgrund des Wikipedia-Links automatisch gesetzt.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## kanton_jahr (kanton_jahr)

Datensatztyp: node

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Jahreswerte eines Kantons Technischer Schlüssel
kanton_id | Fremdschlüssel eines Kantons
jahr | Jahr auf welche sich die Werte beziehen
anzahl_nationalraete | Anzahl Nationalräte des Kantons
einwohner | Wohnbevölkerung des Kantons
auslaenderanteil | Ausländeranteil, zwischen 0 und 1
bevoelkerungsdichte | Bevölkerungsdichte [Einwohner/km2]
anzahl_gemeinden | Anzahl Gemeinden
steuereinnahmen | Stuereinnahmen in Franken
ausgaben | Ausgaben in Franken
finanzausgleich | Geld durch Finanzausgleich bekommen, in Franken
schulden | Schulden des Kantons in Franken
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## person (person)

Datensatztyp: node

Feld | Beschreibung
- | -
anzeige_name | Der Anzeigename ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige. In der Regel ist der deutsche Name enthalten.
anzeige_name_de | Deutscher Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
anzeige_name_fr | Französischer Anzeigename. Er ist eine Kombination anderer Namensfelder. Dieser Name enthält die relevanten Bestandteile zur Anzeige.
name | Name des Datensatzes. In der Regel ist der deutsche Name enthalten.
name_de | Deutscher Name des Datensatzes.
name_fr | Französicher Name des Datensatzes.
id | Technischer Schlüssel der Zugangsberechtigung Technischer Schlüssel
nachname | Nachname des berechtigten Persion
vorname | Vorname der berechtigten Person
vorname_kurz | Alltagsvorname oder gebräuchlicher Spitzname, z.B. Nik für Niklaus
zweiter_vorname | Zweiter Vorname der zutrittsberechtigten Person
namensunterscheidung | Namenszusatz zur Unterscheiden von Personen mit exakt gleichem Namen. Ein Unterscheidungsmerkmal der Person z.B. der Beruf, sollte im Feld gespeichert werden. NUR BEI PERSONEN MIT EXAKT GLEICHEM VORNAMEN UND NAMEN VERWENDEN.
beschreibung_de | Beschreibung der Person. Der Text ist öffentlich einsehbar.
beschreibung_fr | Französische Beschreibung der Person. Der Text ist öffentlich einsehbar.
parlamentarier_kommissionen | Abkürzungen der Kommissionen des zugehörigen Parlamentariers (automatisch erzeugt [in_Kommission/person Trigger])
beruf | Beruf der Person
beruf_fr | Französische Bezeichung des Beruf der Person
beruf_interessengruppe_id | Fremdschlüssel zur Interessengruppe für den Beruf
partei_id | Fremdschlüssel Partei. Parteimitgliedschaft der zutrittsberechtigten Person.
geschlecht | Geschlecht des Parlamentariers, M=Mann, F=Frau
arbeitssprache | Arbeitssprache des Zutrittsberechtigten
homepage | Homepage der zutrittsberechtigen Person
twitter_name | Twittername
linkedin_profil_url | URL zum LinkedIn-Profil
xing_profil_name | Profilname in XING (letzter Teil von Link), wird ergänzt mit https://www.xing.com/profile/ zu einem ganzen Link
facebook_name | Facebookname (letzter Teil von Link), wird mit https://www.facebook.com/ zu einem ganzen Link ergänzt
erfasst | Ist die Person erfasst? Falls der zugehörige Parlamentarier beispielsweise nicht mehr zur Wiederwahl antritt und deshalb die Person nicht erfasst wird, kann dieses Feld auf Nein gestellt werden. NULL bedeutet Status unklar.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
freigabe_datum_unix | Publikationsdatum als UNIX-Timestap (Sekunden seit 1.1.1970), siehe 'freigabe_datum'


## interessenbindung (interessenbindung)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Interessenbindung Technischer Schlüssel
parlamentarier_id | Fremdschlüssel Parlamentarier
organisation_id | Fremdschlüssel Organisation
art | Art der Interessenbindung
funktion_im_gremium | Funktion innerhalb des Gremiums, z.B. Präsident in einem Vorstand einer AG entspricht einem Verwaltungsratspräsidenten, Präsident einer Geschäftsleitung entspricht einem CEO.
deklarationstyp | Ist diese Interessenbindung deklarationspflichtig? Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
status | Status der Interessenbindung
hauptberuflich | Eigene Firma/Haupttätigkeit: Ist diese Interessenbindung hauptberuflich? (Hauptberufliche Interessenbindungen müssen nicht offengelegt werden.)
behoerden_vertreter | Entstand diese Interessenbindung als Behördenvertreter von Amtes wegen? Beispielsweise weil ein Regierungsrat in einem Verwaltungsrat von Amtes wegen Einsitz nimmt.
beschreibung | Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
beschreibung_fr | Französische Bezeichung der Interessenbindung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist die Quell-URL noch gültig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn der Interessenbindung, leer (NULL) = unbekannt
bis | Ende der Interessenbindung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
unterscheidung | Unterscheidungsfeld für ansonsten gleiche Interessenbindungen (parlamentarier_id, organisation_id, art und bis). NUR ANGEBEN WO NÖTIG.
updated_by_import | Datum, wann die Interessenbindung durch einen Import zu letzt aktualisiert wurde. Ein Datum bedeutet, dass die Interessenbindung unter der Kontrolle des Importprozesses.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## interessenbindung_jahr (interessenbindung_jahr)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel Jahresvergütung von Intressenbindung Technischer Schlüssel
interessenbindung_id | Fremdschlüssel der Interessenbindung
jahr | Jahr auf welche sich die Werte beziehen
verguetung | Jährliche Vergütung CHF für Tätigkeiten aus dieser Interessenbindung, z.B. Entschädigung für Beiratsfunktion.
beschreibung | Beschreibung der Vergütung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass die Interessenbindungen vom Parlamentarier autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
parlamentarier_id | Fremdschlüssel Parlamentarier
organisation_id | Fremdschlüssel Organisation


## in_kommission (in_kommission)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel einer Kommissionszugehörigkeit Technischer Schlüssel
parlamentarier_id | Fremdschlüssel des Parlamentariers
kommission_id | Fremdschlüssel der Kommission
funktion | Funktion des Parlamentariers in der Kommission
parlament_committee_function | committeeFunction von ws.parlament.ch
parlament_committee_function_name | committeeFunctionName von ws.parlament.ch
von | Beginn der Kommissionszugehörigkeit, leer (NULL) = unbekannt
bis | Ende der Kommissionszugehörigkeit, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
in_kommission_parlamentarier_kommission_funktion_unique | Kombination aus parlamentarier_id, kommission_id, funktion und bis muss eindeutig sein. (Fachlicher unique constraint)


## mandat (mandat)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel
person_id | Fremdschlüssel Person
organisation_id | Fremdschlüssel Organisation
art | Art der Funktion des Mandatsträgers innerhalb der Organisation
funktion_im_gremium | Funktion innerhalb des Gremiums, z.B. Präsident in einem Vorstand einer AG entspricht einem Verwatlungsratspräsidenten, Präsident einer Geschäftsleitung entspricht einem CEO.
hauptberuflich | Eigene Firma/Haupttätigkeit: Ist dieses Mandat hauptberuflich? (Hauptberufliche Mandate müssen nicht offengelegt werden.)
beschreibung | Umschreibung des Mandates. Beschreibung wird nicht ausgewertet, jedoch in den Resultaten angezeigt.
beschreibung_fr | Französische Bezeichung des Mandates. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist die Quell-URL noch gültig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn des Mandates, leer (NULL) = unbekannt
bis | Ende des Mandates, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
unterscheidung | Unterscheidungsfeld für ansonsten gleiche Mandate (person_id, organisation_id, art und bis). NUR ANGEBEN WO NÖTIG.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am


## mandat_jahr (mandat_jahr)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel Jahresvergütung von Mandat Technischer Schlüssel
mandat_id | Fremdschlüssel des Mandates
jahr | Jahr auf welche sich die Werte beziehen
verguetung | Jährliche Vergütung CHF für Tätigkeiten des Mandates, z.B. Entschädigung für Beiratsfunktion.
beschreibung | Beschreibung der Verfgütung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass das Mandat von der Person autorisiert wurden.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
person_id | Fremdschlüssel Person
organisation_id | Fremdschlüssel Organisation


## organisation_beziehung (organisation_beziehung)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel einer Organisationsbeziehung Technischer Schlüssel
organisation_id | Fremdschlüssel Organisation.
ziel_organisation_id | Fremdschlüssel der Zielorganisation.
art | Beschreibt die Beziehung einer Organisation zu einer Zielorgansation
beschreibung | Bezeichung der Organisationsbeziehung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
beschreibung_fr | Französische Bezeichung der Organisationsbeziehung. Möglichst kurz. Wird nicht ausgewertet, jedoch angezeigt.
quelle_url | URL der Quelle; zum Beleg
quelle_url_gueltig | Ist Quell-URL noch gueltig? Funktioniert er noch?
quelle | Quellenangabe, Format: "[Publikation], DD.MM.YYYY", falls vorhanden bitte die URL im Feld "Quelle URL" auch hinzufügen
von | Beginn der Organisationsbeziehung, leer (NULL) = unbekannt
bis | Ende der Organisationsbeziehung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
organisation_beziehung_organisation_ziel_organisation_art_unique | Kombination aus organisation_id, ziel_organisation_id, art und bis muss eindeutig sein. (Fachlicher unique constraint)


## zutrittsberechtigung (zutrittsberechtigung)

Datensatztyp: relationship

Feld | Beschreibung
- | -
id | Technischer Schlüssel der Zutrittsberechtigung Technischer Schlüssel
parlamentarier_id | Fremdschlüssel Parlamentarier
person_id | Fremdschlüssel zur zutrittsberechtigten Person
parlamentarier_kommissionen | Abkürzungen der Kommissionen des zugehörigen Parlamentariers (automatisch erzeugt [in_Kommission/zutrittsberechtigung Trigger])
funktion | Funktion der zutrittsberechtigen Person.
funktion_fr | Funktion der zutrittsberechtigen Person auf französisch.
von | Beginn der Zutrittsberechtigung, leer (NULL) = unbekannt
bis | Ende der Zutrittsberechtigung, leer (NULL) = aktuell gültig, nicht leer = historischer Eintrag
updated_by_import | Datum, wann die Zutrittsberechtigung durch einen Import zu letzt aktualisiert wurde.
autorisiert_datum | Autorisiert am. Leer/NULL bedeutet noch nicht autorisiert. Ein Datum bedeutet, dass der Eintrag vom Parlamentarier autorisiert wurde.
freigabe_datum | Freigabedatum (Freigabe = Daten sind fertig)
created_date | Erstellt am
updated_date | Abgeändert am
zutrittsberechtigung_parlamentarier_person_unique | Kombination aus parlamentarier_id, person_id und bis muss eindeutig sein. (Fachlicher unique constraint)


## parlamentarier_partei (parlamentarier)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
partei_id | Fremdschlüssel Partei. Leer bedeutet parteilos.


## parlamentarier_fraktion (parlamentarier)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
fraktion_id | Fraktionszugehörigkeit im nationalen Parlament. Fremdschlüssel.


## parlamentarier_rat (parlamentarier)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
rat_id | Ratszugehörigkeit; Fremdschlüssel des Rates


## parlamentarier_kanton (parlamentarier)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel des Parlamentariers Technischer Schlüssel
kanton_id | Kantonszugehörigkeit; Fremdschlüssel des Kantons


## organisation_interessengruppe (organisation)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Lobbyorganisation Technischer Schlüssel
interessengruppe_id | Fremdschlüssel Interessengruppe. Hauptinteressengruppe. Über die Interessengruppe wird eine Branche zugeordnet.


## organisation_interessengruppe2 (organisation)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Lobbyorganisation Technischer Schlüssel
interessengruppe2_id | Fremdschlüssel Interessengruppe. 2. Interessengruppe der Organisation.


## organisation_interessengruppe3 (organisation)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Lobbyorganisation Technischer Schlüssel
interessengruppe3_id | Fremdschlüssel Interessengruppe. 3. Interessengruppe der Organisation.


## organisation_interessenraum (organisation)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Lobbyorganisation Technischer Schlüssel
interessenraum_id | Interessenraum der Organisation


## interessengruppe_branche (interessengruppe)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Interessengruppe Technischer Schlüssel
branche_id | Fremdschlüssel Branche


## branche_kommission (branche)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Branche Technischer Schlüssel
kommission_id | Zuständige Kommission im Nationalrat


## branche_kommission2 (branche)

Datensatztyp: relationship

Feld | Beschreibung
- | -
created_date | Erstellt am
id | Technischer Schlüssel der Branche Technischer Schlüssel
kommission2_id | Zuständige Kommission im Ständerat

